C
C DEQSOL3.FOR
C ===========
C
C OUTPUT uses MODULE_DEQSOL
C PARSIN
C SHOWIT
C TABOUT
C TABPRN
C TIMEIN
C VALUES
C
C----------------------------------------------------------------------
C
      SUBROUTINE OUTPUT (XC, YC)
      USE MODULE_DEQSOL, ONLY : N, YVAL, ICOUNT, TX
C
C Action: Store calculated Y(I) values as YVAL(I,J) and re-set X
C Author: w.g.bardsley, university of manchester, u.k. 
C         02/07/2005 deleted special code to set y = y0 when ICOUNT = 1
C
C XC: output the next point to advance the integration
C YC: store the current Y(i) values in YVAL(icount,i)
C     
C TX stores the distinct time points for the integration
C ICOUNT is the row number for storing Y
C
      IMPLICIT   NONE
C
C Arguments
C
      DOUBLE PRECISION, INTENT (IN)  :: YC(*)
      DOUBLE PRECISION, INTENT (OUT) :: XC
C
C locals
C
      
      INTEGER    I
      DO I = 1, N
         YVAL(ICOUNT,I) = YC(I)
      ENDDO
      ICOUNT = ICOUNT + 1
      XC = TX(ICOUNT)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE PARSIN (ISAV, ISEND, M, N, NPMAX,
     +                   BL, BU, P, Y0,
     +                   FSAV, TSAV,
     +                   READY)
C
C Action: Change parameter or y0 values
C Author: w.g.bardsley, university of manchester, u.k.
C         15/04/2004 added call to LMHEDI and removed array PARAMS
C
C M = total number of parameters including initial conditions
C N = number of equations, i.e. number of initial conditions
C ISEND = 1: For         1 =< i =< M - N,  P(i) are parameters
C ISEND = 2: For M - N + 1 =< i =< M,      P(i) are initial conditions
C READY set to .FALSE. if a parameter is changed
C
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISAV, ISEND, M, N, NPMAX
      DOUBLE PRECISION,    INTENT (INOUT) :: BL(NPMAX), BU(NPMAX),
     +                                       P(NPMAX), Y0(N)
      CHARACTER (LEN = *), INTENT (INOUT) :: FSAV(ISAV), TSAV(ISAV)
      LOGICAL,             INTENT (INOUT) :: READY
C
C Locals
C      
      INTEGER    N0, N1, N2, N6, N11
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N6 = 6, N11 = 11)
      INTEGER    ICOLOR, JCOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4)
      INTEGER    NUMPOS(N11)
      INTEGER    I, J, JSEND, K, NDIFF, NIN, NPAR, NSET, NSTOP
      DOUBLE PRECISION PSAV
      DOUBLE PRECISION EPSI
      PARAMETER (EPSI = 1.0D-150)
      CHARACTER (LEN = 13) D13(3), SHOWLJ
      CHARACTER (LEN = 12) I12(3), FORM12
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  CIPHER*5
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, REPEET
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   GETIM1, GETDLE, GETDM1, GETDGE, LBOX02, TABLE5,
     +           LMHEDI, PARLIM, GETNOU, PUTADV
      INTRINSIC  ABS
      DATA       NUMPOS / N11*1 /
C
C Check ISEND then define NDIFF
C      
      IF (ISEND.LT.N1 .OR. ISEND.GT.N2) RETURN
      E_NUMBERS = E_FORMATS()  
      NDIFF = M - N
      IF (ISEND.EQ.N1) THEN
         IF (E_NUMBERS) THEN
            NSTOP = NDIFF
            NUMOPT = N11
            CIPHER = 'p(i) '
            WRITE (TEXT,100) NDIFF, CIPHER, CIPHER, CIPHER, CIPHER,
     +                       CIPHER
         ELSE
            I12(1) = FORM12(NDIFF)
            NSTOP = NDIFF
            NUMOPT = N11
            CIPHER = 'p(i) '
            WRITE (TEXT,150) TRIM(I12(1)), CIPHER, CIPHER,
     +                       CIPHER, CIPHER, CIPHER
         ENDIF  
      ELSE
         IF (E_NUMBERS) THEN
            NSTOP = N
            NUMOPT = N6
            CIPHER = 'y0(i)'
            WRITE (TEXT,100) N, CIPHER, CIPHER, CIPHER, CIPHER, CIPHER
            TEXT(NUMOPT) = 'Apply'
         ELSE
            I12(1) = FORM12(N)
            NSTOP = N
            NUMOPT = N6
            CIPHER = 'y0(i)'
            WRITE (TEXT,150) TRIM(I12(1)), CIPHER, CIPHER, CIPHER, 
     +                       CIPHER, CIPHER
            TEXT(NUMOPT) = 'Apply' 
         ENDIF   
      ENDIF
C
C Main loop
C      
      REPEET =.TRUE.
      DO WHILE (REPEET)
         NUMDEC = NUMOPT
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                TEXT)
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Display current values 
C             checks for table starting points will not normally be needed but are
C             retained for possible future use
C
            IF (ISEND.EQ.N1) THEN
               K = NDIFF
               IF (NDIFF.GT.500) THEN
                  I = N1
                  CALL GETIM1 (I, J, K, 
     +                        'Index i of p(i) to start table')
               ELSE
                 J = N1
               ENDIF
            ELSE
               K = N
               IF (N.GT.100) THEN
                  I = N1
                  CALL GETIM1 (I, J, K,
     +                        'Index i of y0(i) to start table')
               ELSE
                  J = N1
               ENDIF
               J = J + NDIFF
               K = K + NDIFF
            ENDIF
            JCOLOR = 15
            CALL TABLE5 (JCOLOR, 'OPEN')
            JCOLOR = 0
            DO I = J, K
               IF (I.LE.NDIFF) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,200) I, BL(I), P(I), BU(I)
                  ELSE
                     D13(1) = SHOWLJ(BL(I))
                     D13(2) = SHOWLJ(P(I))
                     D13(3) = SHOWLJ(BU(I))
                     WRITE (LINE,250) I, D13(1), D13(2), D13(3)  
                  ENDIF  
               ELSE
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,300) I, BL(I), P(I), BU(I), I - NDIFF
                  ELSE
                     D13(1) = SHOWLJ(BL(I))
                     D13(2) = SHOWLJ(P(I))
                     D13(3) = SHOWLJ(BU(I))
                     WRITE (LINE,350) I, D13(1), D13(2), D13(3),
     +                                I - NDIFF
                  ENDIF  
               ENDIF
               CALL TABLE5 (JCOLOR, LINE)
            ENDDO
            CALL TABLE5 (JCOLOR, 'CLOSE')
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: Change a lower limit (no change in READY)
C
            IF (ISEND.EQ.N1) THEN
               WRITE (LINE,400) 'Lower p-limit'
            ELSE
               WRITE (LINE,400) 'Lower y0-limit'
            ENDIF
            CALL GETIM1 (N0, NPAR, NSTOP, 
     +                   LINE)
            IF (NPAR.GE.N1) THEN
               IF (ISEND.NE.N1) NPAR = NPAR + NDIFF
               IF (E_NUMBERS) THEN  
                  WRITE (LINE,500) 'L', NPAR, BL(NPAR)
               ELSE
                  I12(1) = FORM12(NPAR)
                  D13(1) = SHOWLJ(BL(NPAR))
                  WRITE (LINE,550) 'L', TRIM(I12(1)), TRIM(D13(1)) 
               ENDIF  
               CALL GETDLE (BL(NPAR), P(NPAR),
     +                      LINE)
            ENDIF 
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Change a parameter (READY = .FALSE. if changed appreciably)
C
            IF (ISEND.EQ.1) THEN
               WRITE (LINE,400) 'p-value'
            ELSE
               WRITE (LINE,400) 'y0-value'
            ENDIF
            CALL GETIM1 (N0, NPAR, NSTOP,
     +                   LINE)
            IF (NPAR.GE.N1) THEN
               IF (ISEND.NE.N1) NPAR = NPAR + NDIFF
               PSAV = P(NPAR)
               IF (E_NUMBERS) THEN
                  WRITE (LINE,500) 'p', NPAR, PSAV
               ELSE
                  I12(1) = FORM12(NPAR)
                  D13(1) = SHOWLJ(PSAV)
                  WRITE (LINE,550) 'p', TRIM(I12(1)), TRIM(D13(1))
               ENDIF  
               CALL GETDM1 (BL(NPAR), P(NPAR), BU(NPAR), 
     +                      LINE)
               IF (ABS(PSAV - P(NPAR)).GT.EPSI) READY = .FALSE.
            ENDIF
         ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: Change a lower limit (no change in READY)
C
            IF (ISEND.EQ.N1) THEN
                WRITE (LINE,400) 'Upper p-limit'
            ELSE
                WRITE (LINE,400) 'Upper y0-limit'
            ENDIF
            CALL GETIM1 (N0, NPAR, NSTOP,
     +                   LINE)
            IF (NPAR.GE.N1) THEN
               IF (ISEND.NE.N1) NPAR = NPAR + NDIFF
               IF (E_NUMBERS) THEN  
               WRITE (LINE,500) 'U', NPAR, BU(NPAR)

               ELSE
                  I12(1) = FORM12(NPAR)
                  D13(1) = SHOWLJ(BU(NPAR))
                  WRITE (LINE,550) 'U', TRIM(I12(1)), TRIM(D13(1))
               ENDIF 
               CALL GETDGE (BU(NPAR), P(NPAR),
     +                      LINE) 
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: Full scale editing so READY is always set to .FALSE.
C
            IF (ISEND.EQ.N1) THEN
               I = N1
            ELSE
               I = NDIFF + N1
            ENDIF
            CALL LMHEDI (NSTOP,
     +                   BL(I), P(I), BU(I))
            READY = .FALSE.
         ELSEIF (NUMDEC.LT.NUMOPT) THEN
C
C NUMDEC > 5: parameter limits files
C      
            JSEND = NUMDEC - 5
            NPAR = M
            IF (JSEND.NE.5) CALL GETNOU (NIN)
            CALL PARLIM (JSEND, NIN, NPAR, NSET, ISAV, NPMAX,
     +                   BL, BU, P,
     +                   FSAV, TSAV,
     +                   ABORT)
            CLOSE (UNIT = NIN)
            IF (.NOT.ABORT .AND. NSET.GT.0) THEN
               READY = .FALSE.
               IF (NSET.EQ.M) THEN
                  CALL PUTADV (
     +           'All free p(i) and y0(i) have been re-set')
               ELSEIF (NSET.EQ.NDIFF) THEN
                  CALL PUTADV (
     +           'Just free p(i) have been re-set, not y0(i)')
               ELSE
                  WRITE (LINE,600) NDIFF, N, NSET
                  CALL PUTADV (LINE)
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            REPEET = .FALSE.   
         ENDIF
      ENDDO
C
C Define y0 on exit
C
      DO I = N1, N
         Y0(I) = P(NDIFF + I)
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Display the',I4,' currrent ',A
     +/'Change a ',A,' lower-limit'
     +/'Change a ',A,' parameter-value'
     +/'Change a ',A,' upper-limit'
     +/'Edit all current ',A,' values'
     +/'Read a parameter/limits file (PLF)'
     +/'Write a parameter/limits file (PLF)'
     +/'Install a PLF-type library file'
     +/'Access a PLF-type library file'
     +/'Help'
     +/'Apply')
  150 FORMAT (
     + 'Display the',1X,A,1X,' currrent ',A
     +/'Change a ',A,' lower-limit'
     +/'Change a ',A,' parameter-value'
     +/'Change a ',A,' upper-limit'
     +/'Edit all current ',A,' values'
     +/'Read a parameter/limits file (PLF)'
     +/'Write a parameter/limits file (PLF)'
     +/'Install a PLF-type library file'
     +/'Access a PLF-type library file'
     +/'Help'
     +/'Apply')     
  200 FORMAT (' Lower, p(',I3,'), Upper =',1P,3E11.3,' ... parameter')
  250 FORMAT (' Lower, p(',I3,'), Upper =',3(1X,A13),' ... parameter')
  300 FORMAT (' Lower, p(',I3,'), Upper =',1P,3E11.3,' ... y0(',I3,')')
  350 FORMAT (' Lower, p(',I3,'), Upper =',3(1X,A13),' ... y0(',I3,')')
  400 FORMAT (
     +'INDEX i for the ',A,'(i) to be changed (0 for no effect)')
  500 FORMAT (
     +'Value required for ',A,'(',I3,') (current =',1P,E11.3,')')
  550 FORMAT (
     +'Value required for ',A,'(',A,') (current =',1X,A,')')     
  600 FORMAT ('no. free p(i) =',I3,', no. y0(i) =',I3,
     +', total no. p(i) re-set =',I3)
      END
C
C---------------------------------------------------------------------- 
C
      SUBROUTINE SHOWIT (NZMOD,
     +                   ZMOD)
C
C Action: Show current model
C Author: w.g.bardsley, university of manchester, u.k.
C
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: NZMOD
      CHARACTER (LEN = *), INTENT (IN) :: ZMOD(NZMOD)
C
C Locals
C      
      INTEGER   I
      INTEGER   N0, N1, N3, N4, N15
      PARAMETER (N0 = 0, N1 = 1, N3 = 3, N4 = 4, N15 = 15)
      INTEGER   ICOLOR
      EXTERNAL TABLE1
      ICOLOR = N15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = N1, NZMOD
         IF (I.LE.N3) THEN
           ICOLOR = N4
         ELSE
           ICOLOR = N0
         ENDIF
         CALL TABLE1 (ICOLOR, ZMOD(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE TABOUT (IWANT, NOUT, NPTS, NTMAX, NUMY, NYMAX,
     +                   TX, YVAL)
C
C Action: File chosen values as functions of time
C Author: w.g.bardsley, university of manchester, u.k.
C
C NWIDE limits the number of Y(I) columns written to file
C
      IMPLICIT    NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT, NPTS, NTMAX, NUMY, NYMAX
      INTEGER,          INTENT (IN) :: IWANT(12)
      DOUBLE PRECISION, INTENT (IN) :: TX(NTMAX), YVAL(NTMAX,NYMAX)
C
C Locals
C      
      INTEGER    ISEND, NWIDE, N1, N3
      PARAMETER (ISEND = 1, NWIDE = 12, N1 = 1, N3 = 3)
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4)
      INTEGER    I, J, K, L
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  FNAME*1024, TITLE*80
      LOGICAL    ABORT, XYSFIL
      EXTERNAL   OFILES, GETTXT, YESNO2, GETIM1
      INTRINSIC  MIN
      XYSFIL = .TRUE.
      IF (NUMY.EQ.1) THEN
         K = NUMY
         L = NUMY
      ELSE
         CALL YESNO2 (ICOLOR, IX, IY,
     +'Create a curve-fit-type file (o/w: x, all selected y(i))',
     +   XYSFIL)
         IF (XYSFIL) THEN
            I = N1
            J = NUMY
            K = N1
            CALL GETIM1 (I, L, J, 
     +'Index i of the selected component y(i) required for file')
         ELSE
            K = MIN(NWIDE,NUMY)
         ENDIF
      ENDIF
      CLOSE (UNIT = NOUT)
      CALL OFILES (ISEND, NOUT, 
     +             FNAME,
     +             ABORT)
      IF (ABORT) THEN
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF
      CALL GETTXT ('Title for this data set', TITLE)
      WRITE (NOUT,100) TITLE
      IF (XYSFIL) THEN
         WRITE (NOUT,200) NPTS, N3
      ELSE
         WRITE (NOUT,200) NPTS, NUMY + N1
      ENDIF
      DO I = N1, NPTS
        IF (XYSFIL) THEN
           WRITE (NOUT,300) TX(I), YVAL(I,L), ONE
        ELSE
           WRITE (NOUT,300) TX(I), (YVAL(I,IWANT(J)), J = N1, K)
        ENDIF
      ENDDO
      WRITE (NOUT,400) N1
      IF (K.EQ.1) THEN
         IF (XYSFIL) THEN
            WRITE (NOUT,501) L
         ELSE
            WRITE (NOUT,501) (IWANT(J), J = N1, K)
         ENDIF
      ELSEIF (K.EQ.2) THEN
         WRITE (NOUT,502) (IWANT(J), J = N1, K)
      ELSEIF (K.EQ.3) THEN
         WRITE (NOUT,503) (IWANT(J), J = N1, K)
      ELSEIF (K.EQ.4) THEN
         WRITE (NOUT,504) (IWANT(J), J = N1, K)
      ELSEIF (K.EQ.5) THEN
         WRITE (NOUT,505) (IWANT(J), J = N1, K)
      ELSE
         WRITE (NOUT,506) (IWANT(J), J = N1, K)
      ENDIF
      CLOSE (UNIT = NOUT)
C
C Format statements
C      
  100 FORMAT (A)
  200 FORMAT (2I6)
  300 FORMAT (1P,7E11.3)
  400 FORMAT (I6)
  501 FORMAT ('Data simulated by DEQSOL: x, y(',I4,')')
  502 FORMAT ('Data simulated by DEQSOL: x',2(', y(',I4,')'))
  503 FORMAT ('Data simulated by DEQSOL: x',3(', y(',I4,')'))
  504 FORMAT ('Data simulated by DEQSOL: x',4(', y(',I4,')'))
  505 FORMAT ('Data simulated by DEQSOL: x',5(', y(',I4,')'))
  506 FORMAT ('Data simulated by DEQSOL: x',6(', y(',I4,')'))
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE TABPRN (IWANT, NPTS, NTMAX, NUMY, NYMAX, 
     +                   TX, YVAL)
C
C Action: Table of chosen values as functions of time
C Author: w.g.bardsley, university of manchester, u.k.
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NPTS, NTMAX, NUMY, NYMAX
      INTEGER,          INTENT (IN) :: IWANT(12)
      DOUBLE PRECISION, INTENT (IN) :: TX(NTMAX), YVAL(NTMAX,NYMAX)
C
C Locals
C      
      INTEGER    ICOLOR
      INTEGER    I, J, K, NSTART, NSTOP
      INTEGER    NWIDE, N0, N1, N4, N15
      PARAMETER (NWIDE = 6, N0 = 0, N1 = 1, N4 = 4, N15 = 15)  
      CHARACTER  LINE*100
      INTRINSIC  MIN
      EXTERNAL   TABLE5, GETIM1
      IF (NPTS.LE.1000) THEN
         NSTART = N1
         NSTOP = NPTS
      ELSE
         I = N1
         J = NPTS
         CALL GETIM1 (I, NSTART, J,'Index no. to start table')
         I = NSTART
C********CALL GETIM1 (I, NSTOP, J,'Index no. to stop table')
         NSTOP = NPTS
      ENDIF
      K = MIN(NWIDE,NUMY)
      IF (NUMY.EQ.1) THEN
         WRITE (LINE,101) (IWANT(J), J = N1, K)
      ELSEIF (NUMY.EQ.2) THEN
         WRITE (LINE,102) (IWANT(J), J = N1, K)
      ELSEIF (NUMY.EQ.3) THEN
         WRITE (LINE,103) (IWANT(J), J = N1, K)
      ELSEIF (NUMY.EQ.4) THEN
         WRITE (LINE,104) (IWANT(J), J = N1, K)
      ELSEIF (NUMY.EQ.5) THEN
         WRITE (LINE,105) (IWANT(J), J = N1, K)
      ELSE
         WRITE (LINE,106) (IWANT(J), J = N1, K)
      ENDIF
      ICOLOR = N15
      CALL TABLE5 (ICOLOR, 'OPEN')
      ICOLOR = N4
      CALL TABLE5 (ICOLOR, LINE)
      ICOLOR = N0
      DO I = NSTART, NSTOP
        IF (K.LE.4) THEN
           WRITE (LINE,200) TX(I), (YVAL(I,IWANT(J)), J = 1, K)
        ELSE
           WRITE (LINE,300) TX(I), (YVAL(I,IWANT(J)), J = 1, K)
        ENDIF
        CALL TABLE5 (ICOLOR, LINE)
      ENDDO
      CALL TABLE5 (ICOLOR, 'CLOSE')
C
C Format statements
C      
  101 FORMAT ('  x values    y(',I4,')')
  102 FORMAT ('  x values    y(',I4,')',5X,'y(',I4,')')
  103 FORMAT ('  x values    y(',I4,')',5X,'y(',I4,')',5X,'y(',I4,')')
  104 FORMAT ('  x values    y(',I4,')',5X,'y(',I4,')',5X,'y(',I4,')',
     +5X,'y(',I4,')')
  105 FORMAT ('  x values   y(',I4,')',4X,'y(',I4,')',4X,'y(',I4,')',
     +4X,'y(',I4,')',4X,'y(',I4,')')
  106 FORMAT ('  x values   y(',I4,')',4X,'y(',I4,')',4X,'y(',I4,')',
     +4X,'y(',I4,')',4X,'y(',I4,')',4X,'y(',I4,')')
  200 FORMAT (1P,5E12.4)
  300 FORMAT (1P,7E11.3)
      END
C
C---------------------------------------------------------------------- 
C
      SUBROUTINE TIMEIN (NPTS, NTMAX,
     +                   XEND, XSTART,
     +                   READY)
C
C Action: Change time range and/or initial conditions
C Author: w.g.bardsley, university of manchester, u.k.
C         30/06/2005 edited to impose T >= 0
C
C   NPTS: (input/output) number of time points NTMAX > NPTS >= 2
C  NTMAX: (input/unchanged) maximum number of time points - 1
C   XEND: (input/output) final time point XEND > XSTART
C XSTART: (input/output) first time point XSTART >= 0
C  READY: (input/output) indicator for changes in input data
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NTMAX
      INTEGER,          INTENT (INOUT) :: NPTS
      DOUBLE PRECISION, INTENT (INOUT) :: XEND, XSTART
      LOGICAL,          INTENT (INOUT) :: READY
C
C Locals
C
      INTEGER    N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      INTEGER    NUMDEC, NUMOPT, NUMSTA, NUMTXT
      PARAMETER (NUMOPT = 3, NUMSTA = 9, NUMTXT = NUMSTA + NUMOPT - 1)
      INTEGER    ISAV
      INTEGER    NUMBLD(NUMTXT)
      DOUBLE PRECISION XESAV, XSSAV
      DOUBLE PRECISION ZERO, EPSI, ONE
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-100, ONE = 1.0D+00)
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER (LEN = 100) LINE, TEXT(NUMTXT)
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, FORM12,SHOWLJ
      EXTERNAL   GETDG2, GETJM1, LSTBOX, PUTADV
      LOGICAL    REPEET
      INTRINSIC  ABS
      DATA       NUMBLD / NUMTXT*0 /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      XESAV = XEND
      XSSAV = XSTART
      ISAV = NPTS
C
C Check
C
      IF (XSTART.LT.ZERO .OR. XSTART.GE.XEND) THEN
         XSTART = ZERO
         XEND = ONE
      ENDIF
      IF (NPTS.LT.N2 .OR. NPTS.GT.NTMAX - N1) NPTS = N2
C
C Main loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) XSTART, XEND, NPTS
         ELSE
            D13(1) = SHOWLJ(XSTART)
            D13(2) = SHOWLJ(XEND)
            I12 = FORM12(NPTS)
            WRITE (TEXT,150) TRIM(D13(1)), TRIM(D13(2)), TRIM(I12)
         ENDIF      
         NUMDEC = NUMOPT
         NUMBLD(1) = 4
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                TEXT)
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Change x_start, x_stop
C
            IF (E_NUMBERS) THEN
               WRITE (LINE, 200) XSTART, XEND
            ELSE
               D13(1) = SHOWLJ(XSTART)
               D13(2) = SHOWLJ(XEND)
               WRITE (LINE,250) TRIM(D13(1)), TRIM(D13(2))
            ENDIF  
            CALL GETDG2 (XSTART, XEND,
     +                   LINE)
            IF (XSTART.LT.ZERO .OR. XSTART.GE.XEND) THEN
               WRITE (LINE,300)
               CALL PUTADV (LINE)
               XSTART = XSSAV
               XEND = XESAV
            ENDIF
            IF (ABS(XEND - XESAV).GT.EPSI .OR.
     +          ABS(XSSAV - XSTART).GT.EPSI)
     +         READY = .FALSE.
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: Change npts
C
            IF (E_NUMBERS) THEN 
               WRITE (LINE,400) NPTS
            ELSE
               I12 = FORM12(NPTS)
               WRITE (LINE,450) TRIM(I12)
            ENDIF      
            CALL GETJM1 (N2, NPTS, NTMAX - 1,
     +                   LINE)
            IF (ISAV.NE.NPTS) READY = .FALSE.
         ELSE
C
C NUMDEC = NUMOPT: Exit
C           
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Editing the range and number of points'
     +/
     +/'This control permits you to change the current range of'
     +/'independent variable and the number of points required.'
     +/
     +/'After changing these settings the system of equations will'
     +/'have to be integrated before further action can be taken.'
     +/ 
     +/'Change x_start, x_stop (current =',1P,E11.3,',',E11.3,')'
     +/'Change the number of points (current =',I5,')'
     +/'Apply')
  150 FORMAT (
     + 'Editing the range and number of points'
     +/
     +/'This control permits you to change the current range of'
     +/'independent variable and the number of points required.'
     +/
     +/'After changing these settings the system of equations will'
     +/'have to be integrated before further action can be taken.'
     +/ 
     +/'Change x_start, x_stop (current =',1X,A,',',1X,A,')'
     +/'Change the number of points (current =',1X,A,')'
     +/'Apply')     
  200 FORMAT ('x_start, x_stop (current =',1P,E11.3,',',E11.3,')')
  250 FORMAT ('x_start, x_stop (current =',1X,A,',',1X,A,')')
  300 FORMAT ('Must have x_stop > x_start >= 0')
  400 FORMAT ('Number of points required (current =',I5,')')
  450 FORMAT ('Number of points required (current =',1X,A,')')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE VALUES (IWANT, N, NUMY)
C
C Action: Change chosen selections
C Author: w.g.bardsley, university of manchester, u.k.
C         18/01/2010 extensive revision
C
C IWANT: Indices for selected components IWANT(i) =< N for i = 1, ..., 12
C     N: current number of equations
C  NUMY: current number of equations selected for table/plot
C
      IMPLICIT   NONE
C
C Arguments
C
      
      INTEGER, INTENT (IN)    :: N
      INTEGER, INTENT (INOUT) :: IWANT(12), NUMY
C
C Locals
C      
      INTEGER    N0, N1, N2, N12, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N12 = 12, N15 = 15)
      INTEGER    JCOLOR, NUMDEC, NUMOPT, NUMSTA, NUMTXT
      PARAMETER (NUMOPT = 6, NUMSTA = 15, NUMTXT = NUMSTA + NUMOPT - 1)
      INTEGER    NUMBLD(NUMTXT)
      INTEGER    I, J, K, NMAX
      DOUBLE PRECISION X(N12,N1)
      CHARACTER  SYMBOL*1
      CHARACTER  LINE*100, TEXT(NUMTXT)*100
      LOGICAL    REPEET
      EXTERNAL   GETJM1, TABLE1, LSTBOX, EDITI1, PUTADV
      INTRINSIC  MIN, DBLE, NINT
      DATA       NUMBLD / NUMTXT*0 /
C
C No action if N =< 1
C            
      IF (N.LE.N1) THEN
         CALL PUTADV ('Only available for more than one equation')
         IWANT(N1) = N1
         RETURN
      ENDIF
C
C Initialise
C         
      NMAX = MIN(N12,N)
      DO I = N1, NMAX
         IF (IWANT(I).LT.N1 .OR. IWANT(I).GT.N) IWANT(I) = N1
      ENDDO     
      WRITE (TEXT,100)
      NUMBLD(1) = 4
      NUMDEC = NUMOPT
C
C Main loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                TEXT)
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Table of current indices
C        
            JCOLOR = N15
            CALL TABLE1 (JCOLOR, 'OPEN')
            JCOLOR = N0
            DO I = N1, NUMY
               IF (IWANT(I).GE.N1 .AND. IWANT(I).LE.N) THEN
                  SYMBOL = ' '
               ELSE
                  SYMBOL = '*'
               ENDIF
               WRITE (LINE,200) I, IWANT(I), SYMBOL
               CALL TABLE1 (JCOLOR, LINE)
            ENDDO
            CALL TABLE1 (JCOLOR, 'CLOSE')
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: Change number selected for table/plot
C      
            WRITE (LINE,300)
            CALL GETJM1 (N1, NUMY, NMAX, LINE)
            NUMDEC = N1
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Change just one index
C      
            WRITE  (LINE,400)
            I = N1
            CALL GETJM1 (N1, I, NUMY, LINE)
            WRITE  (LINE,500) I
            CALL GETJM1 (N1, IWANT(I), N, LINE)
            NUMDEC = N1
         ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: Change all indices
C  
            WRITE (LINE,600)    
            DO I = N1, NUMY
               X(I,N1) = DBLE(IWANT(I))
            ENDDO
            CALL EDITI1 (N2, N1, N12, NUMY,
     +                   X,
     +                   LINE)
            K = N0
            DO I = N1, NUMY
               J = NINT(X(I,N1))
               IF (J.GE.N1 .AND. J.LE.N) THEN
                  IWANT(I) = J
               ELSE
                  K = K + N1   
               ENDIF     
            ENDDO   
            IF (K.GT.N0) THEN
               WRITE (LINE,700) K
               CALL PUTADV (LINE)
            ENDIF            
            NUMDEC = N1
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: Natural ordering
C      
            NUMY = NMAX
            DO I = N1, NUMY
               IWANT(I) = I
            ENDDO
            WRITE (LINE,800)
            CALL PUTADV (LINE)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: Exit loop
C         
            REPEET = .FALSE.   
         ENDIF
C
C Final check that IWANT is OK
C      
         J = N0
         DO I = N1, NUMY
            IF (IWANT(I).GT.N) J = J + N1
         ENDDO
         IF (J.GT.N0) THEN
            WRITE (LINE,700) J
            CALL PUTADV (LINE)
            NUMDEC = N1
            REPEET = .TRUE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Changing selection indices to display/plot sub-sets of y(i)'
     +/
     +/'If there are more than 12 equations in the set it is useful'
     +/'to choose indices to be used for tables and plots, so you can'
     +/'observe sub-sets of the y(i), e.g. y(i) profiles for i > 12.'
     +/'Only the indices for tables and plotting are changed, not the'
     +/'indices of the differential equations in the system.'
     +/
     +/'The selection is preserved unless you choose a new system'
     +/'with fewer equations, when re-ordering of indices may occur.'
     +/
     +/'Natural ordering may be preferred if the number of equations is'
     +/'less than or equal to 12, but selection can still be used.'
     +/ 
     +/'Display a table for the selected y(i)'
     +/'Change the total number of y(i) selected'
     +/'Edit just one selection index i'
     +/'Create a new selection set'
     +/'Revert to natural ordering'
     +/'Apply')
  200 FORMAT (' selection(',I3,') = y(',I3,')',1X,A)
  300 FORMAT ('Total number of components y(i) to be selected')
  400 FORMAT ('Index number for editing in the selection set')
  500 FORMAT ('Value of i for y(i) as index number',i3)
  600 FORMAT ('Edit indices selected for tables/plots')
  700 FORMAT ('Number of errors in indices selected is',I3)
  800 FORMAT ('Natural order of indices has been restored')
      END
C
C
