C
C DEQSOL4
C =======
C
C DERIV2
C DEQFIT
C DEQRAN
C FUNCT1 uses MODULE_DEQSOL
C GOFFIT uses MODULE_DEQSOL
C
C
      subroutine deriv2 (funct,
     +                   n,
     +                   g, w, x,
     +                   free)
c
c action: finite difference approximation to derivatives using qngrd1
c author: w.g.bardsley, university of manchester, u.k. 
c
      implicit   none
c
c arguments
c      
      integer,          intent (in)    :: n
      double precision, intent (inout) :: g(n), w(3*n), x(n)
      logical,          intent (inout) :: free(n)
c
c locals
c      
      integer    inform
      logical    tpoint
      parameter (tpoint = .false.)
      external   funct, qngrd2
      call qngrd2 (funct,
     +             inform, n,
     +             g, w, x,
     +             free, tpoint)
      end
C
C----------------------------------------------------------------------
C
      SUBROUTINE DEQFIT (IFAIL, IWRK, LIWRK, LW1, LW2, M, NBD, NOUT,
     +                   NPTS,
     +                   BL, BU, CPU, FC, G, W1, W2, XC,
     +                   OTYPE,
     +                   IWARNU,
     +                   USE_E04JYF, USE_E04KZF, USE_E04UFF)
C
C ACTION: Call to QNFIT2 from DEQSOL
C AUTHOR: W.G.Bardsley, University of Manchester, U.K
C         01/01/2000 added IWARNU
C         18/01/2010 added calls to NAG E04 routines
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: LIWRK, LW1, LW2, M, NOUT,
     +                                       NPTS 
      INTEGER,             INTENT (INOUT) :: IFAIL, IWRK(LIWRK), NBD(M)
      DOUBLE PRECISION,    INTENT (INOUT) :: BL(M), BU(M), CPU, FC,
     +                                       G(M), W1(LW1), W2(LW2), 
     +                                       XC(M)
      CHARACTER (LEN = *), INTENT (IN)    :: OTYPE
      LOGICAL,             INTENT (INOUT) :: IWARNU
      LOGICAL,             INTENT (IN)    :: USE_E04JYF, USE_E04KZF,
     +                                       USE_E04UFF   
C
C Locals
C
      INTEGER    I
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMTXT = 23)
      INTEGER    NUMBLD(NUMTXT)
      CHARACTER  TEXT(NUMTXT)*100
      CHARACTER  ATYPE*11
      PARAMETER (ATYPE = 'approximate')
      LOGICAL    FILEIT, SHOWIT
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   DERIV2, FUNCT1, QNFIT2, PATCH1
      EXTERNAL   E04QN1, E04MN1, E04SQ1, FUNCT2, FUNCT3
      DATA       NUMBLD / NUMTXT*0 /
C
C Advise user
C
       IF (IWARNU) THEN
          IWARNU = .FALSE.
          WRITE (TEXT,100)
          NUMBLD(1) = 1
          CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                 TEXT,
     +                 BORDER)
       ENDIF
C
C Set NBD to define types of limits required by QNFIT2/LBFGSB
C
      DO I = 1, M
         IF (BL(I).GT.XC(I)) BL(I) = XC(I)
         IF (BU(I).LT.XC(I)) BU(I) = XC(I)
         NBD(I) = 2
      ENDDO
      IF (USE_E04JYF) THEN
         FILEIT = .TRUE.
         SHOWIT = .TRUE.
         CALL E04QN1 (FUNCT2,
     +                IFAIL, NBD, IWRK, LIWRK, LW1, M, NOUT,
     +                BL, BU, FC, W2, W1, XC,
     +                FILEIT, SHOWIT) 
         CPU = W1(1)
      ELSEIF (USE_E04KZF) THEN
         FILEIT = .TRUE.
         SHOWIT = .TRUE.
         CALL E04MN1 (FUNCT3,
     +                IFAIL, NBD, IWRK, LIWRK, LW1, M, NOUT,
     +                BL, BU, FC, G, W2, W1, XC,  
     +                FILEIT, SHOWIT) 
         CPU = W1(1)   
      ELSEIF (USE_E04UFF) THEN
         FILEIT = .TRUE.
         SHOWIT = .TRUE.
         CALL E04SQ1 (FUNCT2, 
     +                IFAIL, NBD, IWRK, LIWRK, LW1, M, NOUT,
     +                BL, BU, FC, G, W2, W1, XC,  
     +                FILEIT, SHOWIT) 
         CPU = W1(1)            
      ELSE 
         CALL QNFIT2 (DERIV2, FUNCT1,
     +                IFAIL, IWRK, LIWRK, LW1, LW2, M, NBD,
     +                NOUT, NPTS,
     +                BL, BU, FC, G, W1, W2, XC,
     +                ATYPE, OTYPE)
         CPU = W1(4)
      ENDIF
C
C Format statement
C      
  100 FORMAT ('Advice about fitting systems of differential equations'
     +/
     +/'This procedure should only be attempted by experienced users.'
     +/'DEQSOL does parameter scaling but you MUST use data units such'
     +/'such that wssq/ndof, y(i) and time are of order unity. Note:-'
     +/
     +/'1)`The equations must be correct and the data of high quality.'
     +/'2)`The equations must be simulated first to make sure the TOL'
     +/'  `values, method and Jacobian (if used) are all appropriate.'
     +/'3)`You must have good starting estimates and carefully chosen'
     +/'  `limits on the parameter file to prevent overflow or failure'
     +/'  `to integrate successfully over the range.'
     +/'4)`Fix initial conditions using lower-limit = y0 = upper-limit'
     +/'  `unless it is absolutely essential to estimate them, since'
     +/'  `estimating y0(i) can lead to very serious complications.'
     +/'5)`Study the equations analytically to make sure parameters do'
     +/'  `not cross bifurcation boundaries during optimisation. This'
     +/'  `is very important if any y0(i) have to be estimated.'
     +/
     +/'DEQSOL makes finite difference and convergence calculations'
     +/'based on the above assumptions. If no significant progress is'
     +/'made after a few steps, optimisation will terminate and then it'
     +/'is up to you to re-scale the problem sensibly and start again.')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE DEQRAN (IFAIL, IWRK, LIWRK, LW1, LW2, M, N, NBD,
     +                   NCYCLE, NOUT, NPTS, NRAND,
     +                   BL, BU, CPU, FC, G, W1, W2, XC, XCRAN,
     +                   OTYPE,
     +                   IWARNU, RANPAR, RANY0,
     +                   USE_E04JYF, USE_E04KZF, USE_E04UFF)
C
C ACTION: Generate random starts then call QNFIT3
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 01/01/2000
C         If the user aborts the output then the current fitting
C         cycle will terminate but, because LINE = 'CLOSE' no
C         further action will take place.
C         23/01/2000 added alternative exit advice with NSWAP and NBIG
C         18/01/2010 added calls to NAG E04 routines
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: LIWRK, LW1, LW2, M, N,
     +                                       NCYCLE, NOUT, NPTS, NRAND 
      INTEGER,             INTENT (INOUT) :: IFAIL, IWRK(LIWRK), NBD(M)
      DOUBLE PRECISION,    INTENT (INOUT) :: BL(M), BU(M), CPU, FC, 
     +                                       G(M), W1(LW1), W2(LW2),
     +                                       XC(M), XCRAN(M)     
      CHARACTER (LEN = *), INTENT (IN)    :: OTYPE
      LOGICAL,             INTENT (INOUT) :: IWARNU
      LOGICAL,             INTENT (IN)    :: RANPAR, RANY0
      LOGICAL,             INTENT (IN)    :: USE_E04JYF, USE_E04KZF,
     +                                       USE_E04UFF   
C
C Locals
C      
      INTEGER    I, ICOUNT, JCOUNT, NBIG, NSWAP
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMTXT = 23)
      INTEGER    NUMBLD(NUMTXT)
      DOUBLE PRECISION OBJFUN, WSSQ1, WSSQ2
      DOUBLE PRECISION A, B, C, D, DELTA, DIFF1, DIFF2, X, Y
      DOUBLE PRECISION EPSI, TWO, FOUR, TEN
      PARAMETER (EPSI = 1.0D-06, TWO = 2.0D+00, FOUR = 4.0D+00,
     +           TEN = 10.0D+00)
      DOUBLE PRECISION G05CAF$, G05DDF$
      CHARACTER  LINE*100, TEXT(NUMTXT)*100
      CHARACTER  ATYPE*11, TYPE1(2)*7, WORD13*13, WORD25*25
      PARAMETER (ATYPE = 'approximate')
      LOGICAL    FIRST, FILEIT, SHOWIT
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   DERIV2, FUNCT1, FUNCT2, FUNCT3
      EXTERNAL   QNFIT3, PATCH1, LIST01, PUTADV, PUTWAR
      EXTERNAL   E04QN1, E04MN1, E04SQ1
      EXTERNAL   G05CCF$, G05CAF$, G05DDF$
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
      DATA       NUMBLD / NUMTXT*0 /
      DATA       TYPE1 / 'Normal ', 'Uniform' /
C
C Advise user if curve fitting for the first time
C
       IF (IWARNU) THEN
          IWARNU = .FALSE.
          WRITE (TEXT,100)
          NUMBLD(1) = 1
          CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                 TEXT,
     +                 BORDER)
       ENDIF
C
C Advise and call G05CCF$ to make sure a random seed is used
C
       IF (FIRST) THEN
          FIRST = .FALSE.
          CALL G05CCF$
          WRITE (TEXT,150)
          NUMBLD(1) = 1
          CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                 TEXT,
     +                 BORDER)
       ENDIF
C
C Set NBD to define types of limits required by QNFIT3/LBFGSB
C Initialise all XCRAN(i) in case only P(i) or only y0(i) are
C to be randomised. The non-randomised parameters will be fixed.
C Also set NBIG = 0 and NSWAP = 0 to count no. improvements
C
      NBIG = 0
      DO I = 1, M
         IF (BL(I).GT.XC(I)) BL(I) = XC(I)
         IF (BU(I).LT.XC(I)) BU(I) = XC(I)
         NBD(I) = 2
         XCRAN(I) = XC(I)
         IF (BU(I) - BL(I).GT.EPSI) THEN
            DIFF1 = XC(I) - BL(I)
            DIFF2 = BU(I) - XC(I)
            IF (DIFF1.GT.TEN*DIFF2 .OR. DIFF2.GT.TEN*DIFF1)
     +          NBIG = NBIG + 1
         ENDIF
      ENDDO
      IF (NBIG.GT.0) THEN
         WRITE (LINE,200) NBIG
         CALL PUTWAR (LINE)
      ENDIF
      NSWAP = 0
C
C Set OBJFUN = WSSQ/NDOF using FC as set in MAIN before call to DEQRAN
C
      OBJFUN = FC
C
C Define WORD25
C
      IF (RANPAR .AND. RANY0) THEN
         WORD25 = 'p(i) and y0(i) randomised'
      ELSEIF (RANPAR) THEN
         WORD25 = 'only p(i) randomised'
      ELSEIF(RANY0) THEN
         WORD25 = 'only y0(i) randomised'
      ENDIF
C
C Open the results output window
C
      LINE = 'OPEN'
      CALL LIST01 (LINE)
      WRITE (LINE,300) NCYCLE, TYPE1(NRAND), WORD25
      CALL LIST01 (LINE)
      WRITE (LINE,400)
      CALL LIST01 (LINE)
C
C Initialise the counters then start the cycles
C
      ICOUNT = 0
      JCOUNT = 0
      DO WHILE (ICOUNT.LT.NCYCLE .AND. LINE(1:5).NE.'CLOSE')
         ICOUNT = ICOUNT + 1
         JCOUNT = JCOUNT + 1
         IF (RANPAR) THEN
C
C Randomise parameters
C
            DO I = 1, M - N
               A = BL(I)
               B = BU(I)
               DELTA = B - A
               IF (DELTA.GT.EPSI) THEN
                  IF (NRAND.EQ.1) THEN
C
C NRAND = 1: Normal distribution
C
                     C = (A + B)/TWO
                     D = DELTA/FOUR
                     X = G05DDF$(C, D)
                     IF (X.LT.A) THEN
                        Y = A
                     ELSEIF (X.GT.B) THEN
                        Y = B
                     ELSE
                        Y = X
                     ENDIF
                  ELSEIF (NRAND.EQ.2) THEN
C
C NRAND = 2: Uniform distribution
C
                     X = G05CAF$(Y)
                     Y = A + DELTA*X
                  ENDIF
                  XCRAN(I) = Y
               ENDIF
            ENDDO
         ENDIF
         IF (RANY0) THEN
C
C Randomise the initial conditions Y0(i)
C
            DO I =  M - N + 1, M
               A = BL(I)
               B = BU(I)
               DELTA = B - A
               IF (DELTA.GT.EPSI) THEN
                  IF (NRAND.EQ.1) THEN
                     C = (A + B)/TWO
                     D = DELTA/FOUR
                     X = G05DDF$(C, D)
                     IF (X.LT.A) THEN
                        Y = A
                     ELSEIF (X.GT.B) THEN
                        Y = B
                     ELSE
                        Y = X
                     ENDIF
                  ELSEIF (NRAND.EQ.2) THEN
                     X = G05CAF$(Y)
                     Y = A + DELTA*X
                  ENDIF
                  XCRAN(I) = Y
               ENDIF
            ENDDO
         ENDIF
C
C Fit using the random starting estimates
C
         LINE = 'STATUS'
         CALL LIST01 (LINE)
         IF (LINE(1:5).EQ.'CLOSE') THEN
C
C If the user has interrupted output then LINE will be returned as 'CLOSE'
C
            ICOUNT = NCYCLE + 1
            JCOUNT = JCOUNT - 1
         ELSE
C
C This next action will not now be stopped from LIST01
C
            WRITE(LINE,'(A,I3,A)') 'Wait ... curve fit', ICOUNT,
     +                             ' in progress'
            CALL LIST01 (LINE)

            IF (USE_E04JYF) THEN
               FILEIT = .FALSE.
               SHOWIT = .FALSE.
               CALL FUNCT2 (N,
     +                      XC, WSSQ1)               
               CALL E04QN1 (FUNCT2,
     +                      IFAIL, NBD, IWRK, LIWRK, LW1, M, NOUT,
     +                      BL, BU, FC, W2, W1, XC,
     +                      FILEIT, SHOWIT) 
               CPU = W2(1)
               WSSQ2 = FC
            ELSEIF (USE_E04KZF) THEN
               FILEIT = .FALSE.
               SHOWIT = .FALSE.
               CALL FUNCT2 (N,
     +                      XC, WSSQ1)     
               CALL E04MN1 (FUNCT3,
     +                      IFAIL, NBD, IWRK, LIWRK, LW1, M, NOUT,
     +                      BL, BU, FC, G, W2, W1, XC,  
     +                      FILEIT, SHOWIT) 
               CPU = W2(1)
               WSSQ2 = FC
            ELSEIF (USE_E04UFF) THEN
               FILEIT = .FALSE.
               SHOWIT = .FALSE.
               CALL FUNCT2 (N,
     +                      XC, WSSQ1)     
               CALL E04SQ1 (FUNCT2, 
     +                      IFAIL, NBD, IWRK, LIWRK, LW1, M, NOUT,
     +                      BL, BU, FC, G, W2, W1, XC,  
     +                      FILEIT, SHOWIT) 
               CPU = W2(1)
               WSSQ2 = FC            
            ELSE 
               CALL QNFIT3 (DERIV2, FUNCT1, IFAIL, IWRK, LIWRK, LW1, 
     +                      LW2, M, NBD, NOUT, NPTS,
     +                      BL, BU, FC, G, W1, W2, XCRAN,
     +                      ATYPE, OTYPE)
               WSSQ1 = W1(1)
               WSSQ2 = W1(2)
               CPU = W1(4)
            ENDIF
            
            IF (WSSQ2.LT.OBJFUN) THEN
C
C Overwrite XC if a better solution has been found and redefine OBJFUN
C Also increment NSWAP
C
               WORD13 = '* Improvement'
               OBJFUN = WSSQ2
               DO I = 1, M
                  XC(I) = XCRAN(I)
               ENDDO
               NSWAP = NSWAP + 1
            ELSE
               WORD13 = ' '
            ENDIF
         ENDIF
         LINE = 'STATUS'
         CALL LIST01 (LINE)
         IF (LINE(1:5).EQ.'CLOSE') THEN
C
C If the user has interrupted output then LINE will be returned as 'CLOSE'
C
            ICOUNT = NCYCLE + 1
         ELSE
            WRITE (LINE,500) ICOUNT, WSSQ1, WSSQ2, OBJFUN, WORD13
C
C Output the results
C
            CALL LIST01 (LINE)
         ENDIF
C
C If the user has interrupted output then LINE will be returned as 'CLOSE'
C
         LINE = 'STATUS'
         CALL LIST01 (LINE)
         IF (LINE(1:5).EQ.'CLOSE') ICOUNT = NCYCLE + 1
      ENDDO
C
C Final message and close down of results output window
C
      IF (NSWAP.NE.1) THEN
         WRITE (LINE,600) NSWAP, JCOUNT
         CALL PUTADV (LINE)
      ELSE 
         WRITE (LINE,700) NSWAP, JCOUNT
         CALL PUTADV (LINE)
      ENDIF   
      
      LINE = 'STATUS'
      CALL LIST01 (LINE)
      IF (LINE(1:5).NE.'CLOSE') THEN
         LINE = 'CLOSE'
         CALL LIST01 (LINE)
      ENDIF
      IF (NSWAP.EQ.0) THEN
         WRITE (TEXT,800)
         NUMBLD(15) = 1
         CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                TEXT,
     +                BORDER)
         NUMBLD(15) = 0
      ENDIF
C
C Re-set FC to current best-fit OBJFUN
C
      FC = OBJFUN
C
C Format statements
C      
  100 FORMAT ('Advice about fitting systems of differential equations'
     +/
     +/'This procedure should only be attempted by experienced users.'
     +/'DEQSOL does parameter scaling but you MUST use data units such'
     +/'such that wssq/ndof, y(i) and time are of order unity. Note:-'
     +/
     +/'1)`The equations must be correct and the data of high quality.'
     +/'2)`The equations must be simulated first to make sure the TOL'
     +/'  `values, method and Jacobian (if used) are all appropriate.'
     +/'3)`You must have good starting estimates and carefully chosen'
     +/'  `limits on the parameter file to prevent overflow or failure'
     +/'  `to integrate successfully over the range.'
     +/'4)`Fix initial conditions using lower-limit = y0 = upper-limit'
     +/'  `or constrain initial conditions within narrow limits, since'
     +/'  `estimating y0(i) can lead to very serious complications.'
     +/'5)`Study the equations analytically to make sure parameters do'
     +/'  `not cross bifurcation boundaries during optimisation. This'
     +/'  `is very important if any y0(i) have to be estimated.'
     +/
     +/'DEQSOL makes finite difference and convergence calculations'
     +/'based on the above assumptions. If no significant progress is'
     +/'made after a few steps, optimisation will terminate and then it'
     +/'is up to you to re-scale the problem sensibly and start again.')
  150 FORMAT ('Advice about random starts'
     +/
     +/'If you try to [Minimise] or [Cancel] during random cycles there'
     +/'may be a delay with lengthy calculations, as the effect comes'
     +/'into play only after the end of the current iteration. Note:-'
     +/
     +/'1)`Usually you would only randomise the parameters, not y0(i).'
     +/'2)`Usually you would set fairly narrow parameter limits with'
     +/'  `the expected solution point in the middle of the range.'
     +/'3)`Usually you would select a normal distribution which uses a'
     +/'  `mean equal to the mid-range and a standard deviation equal'
     +/'  `to a quarter-range, with reflection at the boundaries.'
     +/'4)`If you use a uniform distribution and/or rather wide limits'
     +/'  `in order to locate a global rather than a local minimum, you'
     +/'  `must make sure that singularities/bifurcations cannot occur.'
     +/'5)`Study the equations analytically to make sure parameters do'
     +/'  `not cross bifurcation boundaries during optimisation. This'
     +/'  `is very important if any y0(i) have to be estimated.'
     +/
     +/'DEQSOL retains a set of best-fit parameters assigned before the'
     +/'first fit. From then on each objective functions is compared to'
     +/'the reference wssq/ndof and, if an improvement occurs, the new'
     +/'parameter will be used to overwrite the best-fit parameters.')
  200 FORMAT (I3,
     +' non-central lower =< middle =< upper limits (delta ratio > 10)')
  300 FORMAT ('No. cycles =',I3,', Distribution = ',A,', ',A)
  400 FORMAT (
     +'Cycle  Obj.Fun.(input)   Obj.Fun.(exit)   Obj.Fun.(best)')
  500 FORMAT (I5,1P,3E17.3,1X,A)
  600 FORMAT ('There were',I3,' improvements in',I3,' random cycles')
  700 FORMAT ('There was only',I3,' improvement in',I3,' random cycles')
  800 FORMAT ('More advice about random starts'
     +/
     +/'The random starts have failed and not led to any improvements,'
     +/'so the original parameters have not been upgraded. There could'
     +/'be several reasons for this.'
     +/
     +/'1)`Starting estimates from previous fit were satisfactory.'
     +/'2)`Process initiated with expected parameters not approximately'
     +/'  `in the middle of the parameter limits window, allowing the'
     +/'  `procedure to generate extreme (useless) starting estimates.'
     +/'  `The procedure works best when limits are set at something'
     +/'  `like +/- alpha*expected value with, say 3 =< alpha =< 10.'
     +/'3)`Incorrect model equation (or faulty Jacobian if supplied).'
     +/
     +/'Speeding up the fitting'
     +/
     +/'a)`Simulate before fitting to find good starting estimates.'
     +/'b)`Try the approximate integration and fitting options.'
     +/'c)`Set fixed parameters in the model supplied, instead of using'
     +/'  `lower limit = upper limit, as this still uses extra steps in'
     +/'  `the calculations to evaluate the model and gradient vector.'
     +/'d)`Do not use J(i) = 0 in the Jacobian, as this uses needless'
     +/'  `calculations and the Jacobian is zeroised by default.')
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE FUNCT1 (NC,
     +                   XC, FC)
      USE MODULE_DEQSOL, ONLY : NPMAX, NYMAX, IW, M, N, FACTOR,
     +                          PARNEW, Y0, ICOUNT, IRELAB, DOFDOM,
     +                          MPED, MODEL, METHOD, XEND, TOL, NMOD,
     +                          YPREV, Y, XSTART, YVAL, NUMPNT, USER,
     +                          SDATA, YDATA, INDX, NWORK, W,
     +                          IP, NIP
C
C Action: Function for DEQSOL/QNFIT1
C Author: w.g.bardsley, university of manchester, u.k.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)  :: NC
      DOUBLE PRECISION, INTENT (IN)  :: XC(NC)
      DOUBLE PRECISION, INTENT (OUT) :: FC
C
C Locals
C      
      INTEGER    I, IFAIL, J
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION CPU
      LOGICAL    TIMER
      PARAMETER (TIMER = .FALSE.)
      EXTERNAL ACTION
C
C Re-set the new parameters and initial conditions
C
      DO I = 1, M - N
         PARNEW(I) = FACTOR(I)*XC(I)
      ENDDO
      J = M - N
      DO I = 1, N
         J = J + 1
         Y0(I) = FACTOR(J)*XC(J)
      ENDDO
C
C Integrate the equations
C
      ICOUNT = 1
      IFAIL = 1
      CALL ACTION (IFAIL, IP, IRELAB, IW, NC, METHOD, MODEL, MPED, N,
     +             NIP, NMOD, NPMAX, NWORK, NYMAX,
     +             CPU, PARNEW, TOL, W, XEND, XSTART, Y, YPREV, Y0,
     +             TIMER, USER)
C
C Define the objective function
C
      FC = ZERO
      DO I = 1, N
         IF (NUMPNT(I).GT.0) THEN
            DO J = 1, NUMPNT(I)
               FC = FC +
     +            ((YVAL(INDX(J,I),I) - YDATA(J,I))/SDATA(J,I))**2
            ENDDO
         ENDIF
      ENDDO
      FC = FC/DOFDOM
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GOFFIT (IFAIL, IFIT, IWANT, MPAR, NFREE, NOUT, NTVAL,
     +                   NDIMY, NUMY, NYVAL,
     +                   BL, BU, CPU, FC, XC, XDATA,
     +                   X1, X3, X5, X7, X9, X11,
     +                   YCOM, Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10,
     +                   Y11, Y12,
     +                   RESUL)
      USE MODULE_DEQSOL, ONLY : N, NPTBIG, NTMAX, SDATA, NUMPNT, M,
     +                          NPTS, YDATA, INDX, YVAL, TX,
     +                          NPMAX, NHESS, IW, HESSIN, EIGVAL, CORR,
     +                          RECORD, W, FREE, STATS, RTOL, DIAGV,
     +                          DOFDOM
C
C Action: Goodness of fit
C Author: w.g.bardsley, university of manchester, u.k.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: IFIT, MPAR, NFREE,
     +                                    NOUT, NTVAL, NDIMY, NUMY,
     +                                    NYVAL
      INTEGER,          INTENT (INOUT) :: IFAIL
      INTEGER,          INTENT (IN)    :: IWANT(NUMY)
      DOUBLE PRECISION, INTENT (IN)    :: BL(MPAR), BU(MPAR), CPU, FC, 
     +                                    XC(MPAR), XDATA(NTVAL,NYVAL),
     +                                    YCOM(NTVAL,NYVAL)
      DOUBLE PRECISION, INTENT (INOUT) :: X1(NDIMY), X3(NDIMY),
     +                                    X5(NDIMY), X7(NDIMY),
     +                                    X9(NDIMY), X11(NDIMY)
      DOUBLE PRECISION, INTENT (INOUT) :: Y1(NDIMY), Y2(NDIMY),
     +                                    Y3(NDIMY), Y4(NDIMY),
     +                                    Y5(NDIMY), Y6(NDIMY), 
     +                                    Y7(NDIMY), Y8(NDIMY),
     +                                    Y9(NDIMY), Y10(NDIMY),
     +                                    Y11(NDIMY), Y12(NDIMY) 
      LOGICAL,          INTENT (IN)    :: RESUL     
C
C Locals
C      
      INTEGER
     +L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12,
     +N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12
      INTEGER    IBOT, IMID, ITOP
      PARAMETER (IBOT = 1)
      INTEGER    I, J, K, NTOTAL, NDOF
      INTEGER    ICOLOR, JCOLOR, IX, IY, LSHADE, NOPT, NUMDEC, NUMOPT,
     +           NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NOPT = 4,
     +           NSTART = 12)
      INTEGER    NUMBLD(30), NUMPOS(20)
      DOUBLE PRECISION CHISQD, G01ECF$, PROB
      DOUBLE PRECISION ZERO, EPSI
      CHARACTER (LEN = 13) D13(3), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12) I12(5), FORM12
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-10)
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    DEQLGL(2)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FILE1, FILE2, GRAPH, TAB1, TAB2
      PARAMETER (FILE2 = .TRUE., GRAPH = .TRUE., TAB2 = .TRUE.)
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      LOGICAL    FIRST(4)
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  CIPHER*5, PTITLE*33, XTITLE*1, YTITLE*4
      PARAMETER (XTITLE = 'x', YTITLE = 'y(i)')
      EXTERNAL  E_FORMATS, FORM12, SHOWLJ, SHOWRJ 
      EXTERNAL  TABLE5, GETJM1, GKSR01, GKS004, PUTFAT, PUTADV, GKS012,
     +          PUTIFA, LBOX01, VUCORR, VUSTDEV
      EXTERNAL  G01ECF$
      INTRINSIC ABS, DBLE
      DATA NUMPOS / 20*1 /
      DATA NUMBLD / 30*0 /
C
C Check
C      
      IF (NTVAL.NE.NTMAX) THEN
         CALL PUTADV ('NTVAL .NE. NTMAX in call to GOFFIT')
         RETURN
      ENDIF
C
C Initialise
C      
      E_NUMBERS = E_FORMATS()
      DO I = 1, 4
         FIRST(I) = RESUL
      ENDDO   
      IF (IFIT.EQ.2) THEN
         NTOTAL = NPTBIG
         NDOF = NTOTAL - NFREE
         IF (NDOF.LE.0) THEN
            CALL PUTFAT ('NDOF =< 0 in GOFFIT ... Chi-sqd. undefined')
            CHISQD = ZERO
            PROB = ZERO
         ELSE
            CHISQD = FC*DBLE(NDOF)
            IFAIL = 1
            PROB = G01ECF$('Upper-tail', CHISQD, DBLE(NDOF), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01ECF/GOFFIT')
         ENDIF
      ENDIF
C
C Main loop
C      
   20 CONTINUE
      IF (IFIT.EQ.2) THEN
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) CPU, FC, N, NTOTAL, M, NFREE, NDOF, PROB
         ELSE
            D13(1) = SHOWLJ(CPU)
            D13(2) = SHOWLJ(FC)
            I12(1) = FORM12(N)  
            I12(2) = FORM12(NTOTAL)  
            I12(3) = FORM12(M)  
            I12(4) = FORM12(NFREE)  
            I12(5) = FORM12(NDOF)  
            WRITE (TEXT,150) D13(1), D13(2), I12(1), I12(2), I12(3),
     +                       I12(4), TRIM(I12(5)), PROB
         ENDIF  
         IF (N.EQ.1) THEN
            NUMOPT = 6
            DO I = 13, 17
               TEXT(I) = TEXT(I + 1)
            ENDDO   
         ELSE   
            NUMOPT = 7
         ENDIF   
         NUMBLD(1) = 1
         NUMDEC = 1
         NTEXT = NSTART + NUMOPT - 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (N.EQ.1 .AND. NUMDEC.GT.1) NUMDEC = NUMDEC + 1
      ELSE
         NUMDEC = 6
      ENDIF
      IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: table of parameters
C        
         IF (STATS) THEN
C
C Table of parameters if STATS = .TRUE.
C      
            CALL VUSTDEV (M, NOUT, 
     +                    BL, BU, DIAGV, DOFDOM, EPSI, XC,
     +                    FIRST(2), FREE, STATS)
            FIRST(2) = .FALSE. 
         ELSE   
C
C Table of parameters if STARTS = .FALSE.
C        
            JCOLOR = 15
            CALL TABLE5 (JCOLOR, 'OPEN')
            IF (FIRST(1)) WRITE (NOUT,'(A)') ' '
            WRITE (LINE,200)
            IF (FIRST(1)) WRITE (NOUT,'(A)') LINE
            JCOLOR = 4
            CALL TABLE5 (JCOLOR, LINE)
            JCOLOR = 0
            DO I = 1, M
               IF (E_NUMBERS) THEN
                  IF (ABS(BU(I) - BL(I)).LE.EPSI) THEN
                     WRITE (LINE,300) I, BL(I), XC(I), BU(I), 
     +                               'Fixed'
                  ELSEIF (ABS(XC(I) - BL(I)).LE.EPSI) THEN
                     WRITE (LINE,300) I, BL(I), XC(I), BU(I),
     +                               'Lower Limit'
                  ELSEIF (ABS(XC(I) - BU(I)).LE.EPSI) THEN
                     WRITE (LINE,300) I, BL(I), XC(I), BU(I),
     +                             'Upper Limit'
                  ELSE
                     WRITE (LINE,400) I, BL(I), XC(I), BU(I)
                  ENDIF
               ELSE
                  D13(1) = SHOWRJ(BL(I))
                  D13(2) = SHOWRJ(XC(I))
                  D13(3) = SHOWRJ(BU(I))
                  IF (ABS(BU(I) - BL(I)).LE.EPSI) THEN
                     WRITE (LINE,350) I, D13(1), D13(2), D13(3), 
     +                               'Fixed'
                  ELSEIF (ABS(XC(I) - BL(I)).LE.EPSI) THEN
                     WRITE (LINE,350) I, D13(1), D13(2), D13(3),
     +                               'Lower Limit'
                  ELSEIF (ABS(XC(I) - BU(I)).LE.EPSI) THEN
                     WRITE (LINE,350) I, D13(1), D13(2), D13(3),
     +                             'Upper Limit'
                  ELSE
                     WRITE (LINE,450) I, D13(1), D13(2), D13(3)
                  ENDIF 



               ENDIF  
               IF (FIRST(1)) WRITE (NOUT,'(A)') LINE
               CALL TABLE5 (JCOLOR, LINE)
            ENDDO
            CALL TABLE5 (JCOLOR, 'CLOSE')
            FIRST(1) = .FALSE.
         ENDIF 
         GOTO 20           
      ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: Goodness of fit analysis for just one component
C      
         IF (N.EQ.1) THEN
            IMID = 1
         ELSE
            ITOP = N
            IMID = 1
            CALL GETJM1 (IBOT, IMID, ITOP, 'Component of interest')
         ENDIF
         IF (NUMPNT(IMID).GT.0) THEN
            IF (RESUL) THEN
               CIPHER = '    '
            ELSE
               CIPHER = '(NA)'
            ENDIF
            WRITE (TEXT,600) CIPHER, CIPHER
            I = 1
            J = 10
            K = J + NOPT - 1
            NUMBLD(1) = 4 
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, I, NOPT,
     +                   NUMPOS, J, K, 
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMBLD(1) = 0
            IF (I.EQ.1) THEN
               FILE1 = .FALSE.
               TAB1 = .TRUE.
            ELSEIF (I.EQ.2) THEN
               IF (RESUL) WRITE (NOUT,500) IMID
               FILE1 = .TRUE.
               TAB1 = .FALSE.
            ELSEIF (I.EQ.3) THEN
               IF (RESUL) WRITE (NOUT,500) IMID
               FILE1 = .TRUE.
               TAB1 = .TRUE.
            ELSE
               FILE1 = .FALSE.
               TAB1 = .FALSE.
               GOTO 20
            ENDIF
            DO I = 1, NUMPNT(IMID)
               Y2(I) = SDATA(I,IMID)
               Y3(I) = YCOM(INDX(I,IMID),IMID)
               Y5(I) = XDATA(I,IMID)
               Y6(I) = YDATA(I,IMID)
            ENDDO
            J = NFREE
            CALL GETJM1 (IBOT, J, NFREE,
     +'no. parameters used in this component (add 1 for y(0) ?)')
            IF (NUMPNT(IMID).GT.J) THEN
               CALL GKSR01 (NOUT, J, NUMPNT(IMID), 
     +                      Y1, Y2, Y3, Y4, Y5, Y6, 
     +                      FILE1, FILE2, GRAPH, TAB1, TAB2)
            ELSE
               CALL PUTFAT (
     +         'Too many parameters ... over-determined component')
            ENDIF
         ELSE
            CALL PUTFAT ('Insufficient data for analysis')
         ENDIF
         GOTO 20
      ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Goodness of fit analysis for all components
C      
         IF (NPTBIG.GT.0 .AND. NPTBIG.LE.NDIMY) THEN
            IF (RESUL) THEN
               CIPHER = '    '
            ELSE
               CIPHER = '(NA)'
            ENDIF
            WRITE (TEXT,600) CIPHER, CIPHER
            I = 1
            J = 10
            K = J + NOPT - 1
            NUMBLD(1) = 4 
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, I, NOPT,
     +                   NUMPOS, J, K, 
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMBLD(1) = 0
            IF (I.EQ.1) THEN
               FILE1 = .FALSE.
               TAB1 = .TRUE.
            ELSEIF (I.EQ.2) THEN
               IF (RESUL) WRITE (NOUT,550) 
               FILE1 = .TRUE.
               TAB1 = .FALSE.
            ELSEIF (I.EQ.3) THEN
               IF (RESUL) WRITE (NOUT,550) 
               FILE1 = .TRUE.
               TAB1 = .TRUE.
            ELSE
               FILE1 = .FALSE.
               TAB1 = .FALSE.
               GOTO 20
            ENDIF
            K = 0
            DO J = 1, N
               IF (NUMPNT(J).GT.0) THEN
                  DO I = 1, NUMPNT(J)
                     K = K + 1
                     Y2(K) = SDATA(I,J)
                     Y3(K) = YCOM(INDX(I,J),J)
                     Y5(K) = XDATA(I,J)
                     Y6(K) = YDATA(I,J)
                  ENDDO
               ENDIF   
            ENDDO
            J = NFREE
            IF (NPTBIG.GT.NFREE .AND. K.EQ.NPTBIG) THEN
               CALL GKSR01 (NOUT, J, K, 
     +                      Y1, Y2, Y3, Y4, Y5, Y6, 
     +                      FILE1, FILE2, GRAPH, TAB1, TAB2)
            ELSE
               CALL PUTFAT (
     +         'Too many parameters ... over-determined component')
            ENDIF
         ELSE
            CALL PUTFAT ('Insufficient data/array-space for analysis')
         ENDIF
         GOTO 20         
      ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: Covariance matrix
C         
          DEQLGL(1) = .TRUE.
          DEQLGL(2) = .FALSE.
          
          CALL VUCORR (IW, M, NFREE, NHESS, NOUT, NPMAX,  
     +                 CORR, EIGVAL, HESSIN, RTOL, W, 
     +                 RECORD,
     +                 DEQLGL, FIRST(3), FREE, STATS)
                       FIRST(3) = .FALSE. 
         GOTO 20 
      ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: Hessian matrix
C         
          DEQLGL(1) = .FALSE.
          DEQLGL(2) = .TRUE.
          
          CALL VUCORR (IW, M, NFREE, NHESS, NOUT, NPMAX,  
     +                 CORR, EIGVAL, HESSIN, RTOL, W, 
     +                 RECORD,
     +                 DEQLGL, FIRST(4), FREE, STATS)
                       FIRST(4) = .FALSE.
         GOTO 20    
      ELSEIF (NUMDEC.EQ.6) THEN
C
C NUMDEC = 6: plots
C      
         L1 = 0
         L2 = 0
         L3 = 0
         L4 = 0
         L5 = 0
         L6 = 0
         L7 = 0
         L8 = 0
         L9 = 0
         L10 = 0
         L11 = 0
         L12 = 0
         M1 = 0
         M2 = 0
         M3 = 0
         M4 = 0
         M5 = 0
         M6 = 0
         M7 = 0
         M8 = 0
         M9 = 0
         M10 = 0
         M11 = 0
         M12 = 0
         N1 = 1
         N2 = 1
         N3 = 1
         N4 = 1
         N5 = 1
         N6 = 1
         N7 = 1
         N8 = 1
         N9 = 1
         N10 = 1
         N11 = 1
         N12 = 1
         IF (NUMY.LT.1) THEN
            CALL PUTADV ('No components are selected')
         ELSEIF (NUMY.LE.2) THEN
C
C Set up first component for plotting .. NUMY < 3
C
            J = IWANT(1)
            N1 = NUMPNT(J)
            IF (N1.GT.0) THEN
               M1 = 5
               DO I = 1, N1
                  X1(I) = XDATA(I,J)
                  Y1(I) = YDATA(I,J)
               ENDDO
               L2 = 1
               N2 = NPTS
               DO I = 1, N2
                  Y2(I) = YVAL(I,J)
               ENDDO
               WRITE (PTITLE,700) J
            ELSE
               N1 = 1
               PTITLE = ' '
            ENDIF
C
C Set up second component for plotting if NUMY = 2
C
            IF (NUMY.EQ.2) THEN
               J = IWANT(2)
               N3 = NUMPNT(J)
               IF (N3.GT.0) THEN
                  M3 = 8
                  DO I = 1, N3
                     X3(I) = XDATA(I,J)
                     Y3(I) = YDATA(I,J)
                  ENDDO
                  L4 = 2
                  N4 = NPTS
                  DO I = 1, N4
                    Y4(I) = YVAL(I,J)
                  ENDDO
                  WRITE (CIPHER,800) J
              ELSE
                 N3 = 1
                 CIPHER = ' '
              ENDIF
            ELSE
               CIPHER = ' '
            ENDIF
            CALL GKS004 (L1, L2, L3, L4, M1, M2, M3, M4, N1, N2, N3, N4,
     +                   X1, TX, X3, TX, Y1, Y2, Y3, Y4,
     +                   PTITLE//CIPHER, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)
         ELSE
            J = IWANT(1)
            N1 = NUMPNT(J)
            IF (N1.GT.0) THEN
               M1 = 5
               DO I = 1, N1
                  X1(I) = XDATA(I,J)
                  Y1(I) = YDATA(I,J)
               ENDDO
               L2 = 1
               N2 = NPTS
               DO I = 1, N2
                  Y2(I) = YVAL(I,J)
               ENDDO
            ELSE
               N1 = 1
            ENDIF
            J = IWANT(2)
            N3 = NUMPNT(J)
            IF (N3.GT.0) THEN
               M3 = 8
               DO I = 1, N3
                  X3(I) = XDATA(I,J)
                  Y3(I) = YDATA(I,J)
               ENDDO
               L4 = 2
               N4 = NPTS
               DO I = 1, N4
                  Y4(I) = YVAL(I,J)
               ENDDO
            ELSE
               N3 = 1
            ENDIF
            IF (NUMY.GT.2) THEN
               J = IWANT(3)
               N5 = NUMPNT(J)
               IF (N5.GT.0) THEN
                  M5 = 11
                  DO I = 1, N5
                     X5(I) = XDATA(I,J)
                     Y5(I) = YDATA(I,J)
                  ENDDO
                  L6 = 3
                  N6 = NPTS
                  DO I = 1, N6
                     Y6(I) = YVAL(I,J)
                  ENDDO
               ELSE
                  N5 = 1
               ENDIF
            ENDIF
            IF (NUMY.GT.3) THEN
               J = IWANT(4)
               N7 = NUMPNT(J)
               IF (N7.GT.0) THEN
                  M7 = 14
                  DO I = 1, N7
                     X7(I) = XDATA(I,J)
                     Y7(I) = YDATA(I,J)
                  ENDDO
                  L8 = 4
                  N8 = NPTS
                  DO I = 1, N8
                     Y8(I) = YVAL(I,J)
                  ENDDO
               ELSE
                  N7 = 1
               ENDIF
            ENDIF
            IF (NUMY.GT.4) THEN
               J = IWANT(5)
               N9 = NUMPNT(J)
               IF (N9.GT.0) THEN
                  M9 = 4
                  DO I = 1, N9
                     X9(I) = XDATA(I,J)
                     Y9(I) = YDATA(I,J)
                  ENDDO
                  L10 = 1
                  N10 = NPTS
                  DO I = 1, N10
                     Y10(I) = YVAL(I,J)
                  ENDDO
               ELSE
                  N9 = 1
               ENDIF
            ENDIF
            IF (NUMY.GT.5) THEN
               J = IWANT(6)
               N11 = NUMPNT(J)
               IF (N11.GT.0) THEN
                  M11 = 3
                  DO I = 1, N11
                     X11(I) = XDATA(I,J)
                     Y11(I) = YDATA(I,J)
                  ENDDO
                  L12 = 2
                  N12 = NPTS
                  DO I = 1, N12
                     Y12(I) = YVAL(I,J)
                  ENDDO
               ELSE
                  N11 = 1
               ENDIF
            ENDIF
            CALL GKS012 (
     +      L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +      M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12,
     +      N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +      X1, TX, X3, TX, X5, TX, X7, TX, X9, TX,  X11, TX,
     +      Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11, Y12,
     +      'Data and Fitted Curves', XTITLE, YTITLE, 
     +      SAVEIT, SAVEIT)
         ENDIF
         IF (IFIT.EQ.2) THEN
            GOTO 20
         ELSE
            RETURN
         ENDIF
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'DEQSOL results from curve fitting'
     +/
     +/'cpu time (secs) =',1P,E10.3
     +/'Objective function (wssq/ndof) =',E10.3
     +/'Number of y(i) (equations) =',I6
     +/'Number of observations (npts) =',I6
     +/'Number of parameters p(i) =',I6
     +/'Number of free parameters (npar) =',I6
     +/'Number of degrees of freedom =',I6,' (npts - npar)'
     +/'P(chi-sq>wssq) (sig) =',0P,F7.4
     +/
     +/'Table of parameter estimates'
     +/'Goodness of fit analysis for a chosen y(i)'
     +/'Goodness of fit analysis for overall fit'
     +/'Display parameter correlation matrix'
     +/'Display eigenvalues/condition number of Hessian'
     +/'Plot data and best-fit model'
     +/'Cancel')
  150 FORMAT (
     + 'DEQSOL results from curve fitting'
     +/
     +/'cpu time (secs) =',1X,A
     +/'Objective function (wssq/ndof) =',1X,A
     +/'Number of y(i) (equations) =',1X,A
     +/'Number of observations (npts) =',1X,A
     +/'Number of parameters p(i) =',1X,A
     +/'Number of free parameters (npar) =',1X,A
     +/'Number of degrees of freedom =',1X,A,' (npts - npar)'
     +/'P(chi-sq>wssq) (sig) =',F7.4
     +/
     +/'Table of parameter estimates'
     +/'Goodness of fit analysis for a chosen y(i)'
     +/'Goodness of fit analysis for overall fit'
     +/'Display parameter correlation matrix'
     +/'Display eigenvalues/condition number of Hessian'
     +/'Plot data and best-fit model'
     +/'Cancel')   
  200 FORMAT ('Number   Lower-limit     Parameter   Upper-Limit')
  300 FORMAT (I6,1P,3(1X,E13.5),1X,A)
  350 FORMAT (I6,3(1X,A13),1X,A)
  400 FORMAT (I6,1P,3(1X,E13.5))
  450 FORMAT (I6,3(1X,A13))
  500 FORMAT (/' The following results are for component y(',I3,')')
  550 FORMAT (/' The following results are for all data in sequence')
  600 FORMAT (
     + 'DEQSOL goodness of fit options'
     +/
     +/'The options provided are:'
     +/'Table 1`list of residuals to identify outliers which you'
     +/'       `may wish to archive if it is not too large'
     +/'Table 2`statistical analysis of residuals is always'
     +/'       `displayed and written to the results log file' 
     +/'Plots  `half-normal and other plots are always available'
     +/
     +/'Table 1: display'
     +/'Table 1: write to file',1X,A
     +/'Table 1: display and write to file',1X,A
     +/'Cancel ... No tables, analysis or plots')
  700 FORMAT ('Data and best fit curves: i =',I3)
  800 FORMAT (',',I4)
      END
C
C
