C
C DEQSOL5.FOR
C ===========
C
C DEUSER uses MODULE_DEQSOL
C PLTORB
C PORTRT
C

C
C.......................................................................
C
      SUBROUTINE DEUSER (ISEND,
     +                   KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NPAR, NVAR, NX,
     +                   A, F, X, Y, YDE, YJA, Z,
     +                   MODEL_FILE, MODNAM,
     +                   ABORT, DEQN)
      USE MODULE_DEQSOL, ONLY : INDEX_1, INDEX_2, NXX,
     +                          NSTACK_1, NSTACK_2,
     +                          NLINES_1, NLINES_2,
     +                          NUMBER_1, NUMBER_2,
     +                          DATA_1, DATA_2,
     +                          USED, STACK
C
C ACTION : User defined model
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 29/12/94
C          14/10/1997 restored full word length
C          28/11/1999 changed NEQN to NEQN < 0 to allow no. of eqns. to
C                     be defined by the user's model file
C          01/01/2000 changed dimensions to (*) in case NEQN < 1, etc.
C          14/10/2001 introduced KMAX_A, KMAX_F, KMAX_J and KMAX_Y TO
C                     dimension call to user defined models
C          25/06/2016 introduced NVARSAV as NVAR = 1 is a fixed parameter with differential equations
C
C          ISEND = 1 : Read in and parse the model
C          ISEND = 2 : Evaluate the model
C          ISEND = 3 : Evaluate the Jacobian
C
      IMPLICIT        NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, KMAX_A, KMAX_F,
     +                                       KMAX_J, KMAX_Y, 
     +                                       NVAR, NX
      INTEGER,             INTENT (INOUT) :: NEQN, NPAR
      DOUBLE PRECISION,    INTENT (INOUT) :: A(KMAX_A), F(KMAX_F), X, Y, 
     +                                       YDE(KMAX_Y), YJA(KMAX_J), Z
      CHARACTER (LEN = *), INTENT (INOUT) :: MODEL_FILE, MODNAM(24)     
      LOGICAL,             INTENT (IN)    :: DEQN 
      LOGICAL,             INTENT (INOUT) :: ABORT
C
C Locals
C      
      INTEGER    NEQSAV, NPARSAV, NVARSAV
      INTEGER    NIN
      PARAMETER (NIN = 11)
      LOGICAL    DEQSAV
      SAVE       NEQSAV, NPARSAV, NVARSAV
      EXTERNAL   PUTFAT
      EXTERNAL   USER_FILE, USER_MODEL
C
C ISEND = 1: Initialise the program if ISEND = 1
C
      IF (ISEND.EQ.1) THEN
         IF (NX.GT.NXX) THEN
            CALL PUTFAT ('NX > NXX in DEUSER')
            ABORT = .TRUE.
            RETURN
         ENDIF
C
C Read in a model, set NEQSAV = 0 so number of eqns. read off file
C
         NEQSAV = 0
         NPARSAV = 0
         NVARSAV = 0
         DEQSAV = DEQN
         CALL USER_FILE (INDEX_1, INDEX_2, NEQSAV, NIN, NLINES_1,
     +                   NLINES_2, NPARSAV, NSTACK_1, NSTACK_2,
     +                   NUMBER_1, NUMBER_2, NVARSAV, NXX,
     +                   DATA_1, DATA_2,
     +                   MODEL_FILE, MODNAM,
     +                   ABORT, DEQSAV, USED)
         IF (DEQSAV .AND. .NOT.ABORT) THEN
            NEQN = NEQSAV
            NPAR = NPARSAV
         ENDIF   
      ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: Evaluate the model if ISEND is equal to 2
C
         CALL USER_MODEL (INDEX_1,
     +                    KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                    NEQSAV, NLINES_1, NPAR, NSTACK_1, NUMBER_1,
     +                    NVAR,
     +                    A, DATA_1, F, STACK, X, Y, YDE, YJA, Z)
      ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: Evaluate the Jacobian if ISEND is equal to 3
C
         CALL USER_MODEL (INDEX_2,
     +                    KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                    NEQSAV, NLINES_2, NPAR, NSTACK_2, NUMBER_2,
     +                    NVAR,
     +                    A, DATA_2, F, STACK, X, Y, YDE, YJA, Z)
      ENDIF
      END
C
C.......................................................................
C
      SUBROUTINE PLTORB (ISEND, NORBIT, NPTS, NTMAX,
     +                   X1, X2, X3, X4, X5, X6, X7, X8, X9, X10, X11,
     +                   X12,
     +                   Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11,
     +                   Y12,
     +                   ORBITF, ORBITT,
     +                   READY)
C
C ACTION : save orbits (ISEND = 1) o/w plot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 5/3/98
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, NORBIT, NPTS, NTMAX
      DOUBLE PRECISION,    INTENT (INOUT) ::
     +                 X1(NTMAX), X2(NTMAX), X3(NTMAX), X4(NTMAX),
     +                 X5(NTMAX), X6(NTMAX), X7(NTMAX), X8(NTMAX),
     +                 X9(NTMAX), X10(NTMAX), X11(NTMAX), X12(NTMAX),
     +                 Y1(NTMAX), Y2(NTMAX), Y3(NTMAX), Y4(NTMAX),
     +                 Y5(NTMAX), Y6(NTMAX), Y7(NTMAX), Y8(NTMAX),
     +                 Y9(NTMAX), Y10(NTMAX), Y11(NTMAX), Y12(NTMAX)
      CHARACTER (LEN = *), INTENT (IN)    :: ORBITF(NORBIT)
      CHARACTER (LEN = *), INTENT (INOUT) :: ORBITT(NORBIT)
      LOGICAL,             INTENT (INOUT) :: READY(NORBIT)
C
C Locals
C      
      INTEGER    I, IOS, J, K, NOUT
      INTEGER    L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +           N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12
      INTEGER    M
      PARAMETER (M = 0)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMDEC = 1,
     +           NUMOPT = 12, NSTART = 3, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      CHARACTER  PTITLE*10, XTITLE*10, YTITLE*10
      PARAMETER (PTITLE = 'Orbits',
     +           XTITLE = 'y(j)',
     +           YTITLE = 'y(i)')
      CHARACTER  LINE*100, TEXT(NTEXT)*100, WORD32*32
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GETJM1, GETNOU, GETSTR, RBOX01, PUTFAT, GKS012, YMDHMS
      SAVE       NUMPOS
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*0 /
      LINE = ' '!to silence NAGfor
      TEXT(1) = LINE
C
C Check NORBIT and NUMOPT
C
      IF (NORBIT.NE.NUMOPT) THEN
         CALL PUTFAT ('NORBIT .NE. NUMOPT in call to PLTORB')
         RETURN
      ENDIF
      IF (ISEND.EQ.1) THEN
C
C ISEND = 1: archive the current data if required then return
C            This entry assumes that the coordinates to be stored are
C            Y(2) and Y(1) for i = 1, NPTS, where NPTS > 1
C
         I = 0
         J = 0
         K = NORBIT
         CALL GETJM1 (I, J, K,
     +'Archive index for coordinates (input 0 if archive not required)')
         IF (J.GT.0 .AND. NPTS.GT.1) THEN
C
C Write coordinates to file
C
            CALL GETNOU (NOUT)
            CALL YMDHMS (WORD32)
            ORBITT(J) = WORD32
            CALL GETSTR ('Title for the phase plane data', ORBITT(J))
            OPEN (UNIT = NOUT, FILE = ORBITF(J))
            WRITE (NOUT,'(A)',IOSTAT=IOS) ORBITT(J)
            I = 2
            WRITE (NOUT,'(2I6)',IOSTAT=IOS) NPTS, I
            DO I = 1, NPTS
               WRITE (NOUT,'(1P,2E13.5)',IOSTAT=IOS) Y2(I), Y1(I)
            ENDDO
            CLOSE (UNIT = NOUT)
C
C Set READY to .TRUE. and equivalently NUMPOS to 1
C
            READY(J) = .TRUE.
            NUMPOS(J) = 1
         ENDIF
      ELSE
C
C ISEND not equal to 1: then display and edit the current archived data
C                       This entry plots data retrieved from orbit files 
C
         DO I = 1, NUMOPT
            IF (NUMPOS(I).EQ.1 .AND. .NOT.READY(I)) NUMPOS(I) = 0
         ENDDO
         WRITE (TEXT,100) (ORBITT(I), I = 1, NUMOPT)
         NUMBLD(1) = 1
         CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         DO I = 1, NUMOPT
            IF (NUMPOS(I).EQ.1 .AND. .NOT.READY(I)) NUMPOS(I) = 0
         ENDDO
C
C Initialise all the plotting parameters
C
         L1 = 0
         L2 = 0
         L3 = 0
         L4 = 0
         L5 = 0
         L6 = 0
         L7 = 0
         L8 = 0
         L9 = 0
         L10 = 0
         L11 = 0
         L12 = 0
         N1 = 0
         N2 = 0
         N3 = 0
         N4 = 0
         N5 = 0
         N6 = 0
         N7 = 0
         N8 = 0
         N9 = 0
         N10 = 0
         N11 = 0
         N12 = 0
C
C Open a unit then go systematically through the data sets
C
         CALL GETNOU (NOUT)
         IF (NUMPOS(1).EQ.1) THEN
            L1 = 5
            OPEN (UNIT = NOUT, FILE = ORBITF(1))
            READ (NOUT,'(A)') LINE
            READ (NOUT,*) N1, J
            DO I = 1, N1
               READ (NOUT,*) X1(I), Y1(I)
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
         IF (NUMPOS(2).EQ.1) THEN
            L2 = 5
            OPEN (UNIT = NOUT, FILE = ORBITF(2))
            READ (NOUT,'(A)') LINE
            READ (NOUT,*) N2, J
            DO I = 1, N2
               READ (NOUT,*) X2(I), Y2(I)
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
         IF (NUMPOS(3).EQ.1) THEN
            L3 = 5
            OPEN (UNIT = NOUT, FILE = ORBITF(3))
            READ (NOUT,'(A)') LINE
            READ (NOUT,*) N3, J
            DO I = 1, N3
               READ (NOUT,*) X3(I), Y3(I)
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
         IF (NUMPOS(4).EQ.1) THEN
            L4 = 5
            OPEN (UNIT = NOUT, FILE = ORBITF(4))
            READ (NOUT,'(A)') LINE
            READ (NOUT,*) N4, J
            DO I = 1, N4
               READ (NOUT,*) X4(I), Y4(I)
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
         IF (NUMPOS(5).EQ.1) THEN
            L5 = 5
            OPEN (UNIT = NOUT, FILE = ORBITF(5))
            READ (NOUT,'(A)') LINE
            READ (NOUT,*) N5, J
            DO I = 1, N5
               READ (NOUT,*) X5(I), Y5(I)
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
         IF (NUMPOS(6).EQ.1) THEN
            L6 = 5
            OPEN (UNIT = NOUT, FILE = ORBITF(6))
            READ (NOUT,'(A)') LINE
            READ (NOUT,*) N6, J
            DO I = 1, N6
               READ (NOUT,*) X6(I), Y6(I)
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
         IF (NUMPOS(7).EQ.1) THEN
            L7 = 5
            OPEN (UNIT = NOUT, FILE = ORBITF(7))
            READ (NOUT,'(A)') LINE
            READ (NOUT,*) N7, J
            DO I = 1, N7
               READ (NOUT,*) X7(I), Y7(I)
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
         IF (NUMPOS(8).EQ.1) THEN
            L8 = 5
            OPEN (UNIT = NOUT, FILE = ORBITF(8))
            READ (NOUT,'(A)') LINE
            READ (NOUT,*) N8, J
            DO I = 1, N8
               READ (NOUT,*) X8(I), Y8(I)
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
         IF (NUMPOS(9).EQ.1) THEN
            L9 = 5
            OPEN (UNIT = NOUT, FILE = ORBITF(9))
            READ (NOUT,'(A)') LINE
            READ (NOUT,*) N9, J
            DO I = 1, N9
               READ (NOUT,*) X9(I), Y9(I)
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
         IF (NUMPOS(10).EQ.1) THEN
            L10 = 5
            OPEN (UNIT = NOUT, FILE = ORBITF(10))
            READ (NOUT,'(A)') LINE
            READ (NOUT,*) N10, J
            DO I = 1, N10
               READ (NOUT,*) X10(I), Y10(I)
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
         IF (NUMPOS(11).EQ.1) THEN
            L11 = 5
            OPEN (UNIT = NOUT, FILE = ORBITF(11))
            READ (NOUT,'(A)') LINE
            READ (NOUT,*) N11, J
            DO I = 1, N11
               READ (NOUT,*) X11(I), Y11(I)
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
         IF (NUMPOS(12).EQ.1) THEN
            L12 = 5
            OPEN (UNIT = NOUT, FILE = ORBITF(12))
            READ (NOUT,'(A)') LINE
            READ (NOUT,*) N12, J
            DO I = 1, N12
               READ (NOUT,*) X12(I), Y12(I)
            ENDDO
            CLOSE (UNIT = NOUT)
         ENDIF
C
C Plot
C
         CALL GKS012 (L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +                 M,  M,  M,  M,  M,  M,  M,  M,  M,   M,   M,   M,
     +                N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +                X1, X2, X3, X4, X5, X6, X7, X8, X9, X10, X11, X12,
     +                Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11, Y12,
     +                PTITLE, XTITLE, YTITLE,
     +                AXES, GSAVE)
      ENDIF
C
C Format statement
C      
  100 FORMAT (
     + 'Select the archived orbits required for plotting'
     +/'...'
     +/A/A/A/A/A/A/A/A/A/A/A/A)
      END
C
C.......................................................................
C
      SUBROUTINE PORTRT (IP, NIP, NPMAX, 
     +                   P,
     +                   USER)
C
C ACTION : Phase portrait
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 5/3/98
C          03/02/2010 extensive editing
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NIP, NPMAX, IP(NIP)
      DOUBLE PRECISION, INTENT (IN) :: P(NPMAX)
      LOGICAL,          INTENT (IN) :: USER
C
C Locals      
C    
      INTEGER    NEQN, NMAX, NMAX2
      PARAMETER (NEQN = 2, NMAX = 50, NMAX2 = NMAX*NMAX)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 11,
     +           NSTART = 11, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    IARROW(NMAX2), IKOLOR(NMAX2)
      INTEGER    LCOLOR, NGRID, NGKS
      PARAMETER (LCOLOR = 15, NGKS = 0)
      INTEGER    I, J, JARROW, K, NSWAP1, NSWAP2
      DOUBLE PRECISION F(NEQN), Y(NEQN), THETA
      DOUBLE PRECISION HEAD(NMAX2), X1(NMAX2), X2(NMAX2), Y1(NMAX2),
     +                 Y2(NMAX2)
      DOUBLE PRECISION EPSI, EPSI_M, FACTOR, SHAFT, XDELTA, XSTART,
     +                 XSTOP, YDELTA, YSTART, YSTOP
      DOUBLE PRECISION XBOT, XTOP, YBOT, YTOP
      DOUBLE PRECISION T, ZERO, ONE, TWO, THREE, THREE_M, HSIZE,
     +                 QUART, RTOL
      PARAMETER (T = 1.0D+00, ZERO = 0.0D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, THREE = 3.0D+00, THREE_M = -THREE, 
     +           HSIZE = 0.005D+00, QUART = 0.25D+00, RTOL = 1.0D-200)
      CHARACTER (LEN = 13)  D13(6), SHOWLJ
      CHARACTER  TEXT(30)*100, LINE*100
      CHARACTER  CIPHER1*40, CIPHER2*40, CIPHER3*40, CIPHER4*40
      CHARACTER  BLANK*1, PTITLE*20, XTITLE*10, YTITLE*10
      PARAMETER (BLANK = ' ',
     +           PTITLE = 'Phase Portrait',
     +           XTITLE = 'y(2)',
     +           YTITLE = 'y(1)')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    COLOR1, REPEET, SCALE1, SWAP1
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   GKSVF1, LBOX01, GETJM1, GETDG2, GETDGT, PUTADV, PATCH2
      EXTERNAL   USEDEQ, DEQF02
      INTRINSIC  ABS, DBLE, ATAN, SIN, COS
      SAVE       NGRID, EPSI, FACTOR, SHAFT, XSTART, XSTOP, YSTART,
     +           YSTOP
      SAVE       COLOR1, SCALE1, SWAP1 
      DATA       COLOR1, SCALE1, SWAP1 / .TRUE., .TRUE., .FALSE. /
      DATA       NGRID / 20 /
      DATA       EPSI / 1.0D-06 /
      DATA       FACTOR, SHAFT / ONE, QUART /
      DATA       XSTART, XSTOP / THREE_M, THREE /
      DATA       YSTART, YSTOP / THREE_M, THREE /
      DATA       NUMBLD / 1*1, 29*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      JARROW = NGRID*NGRID
C
C Main branch point
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         NUMDEC = 1
         IF (SCALE1) THEN
            CIPHER1 = BLANK
            CIPHER2 = BLANK
            CIPHER3 = '(current = fixed length)'
         ELSE
            WRITE (CIPHER1,'(A,1P,E11.3)') ', proportionality factor =',
     +                                      SHAFT
            CIPHER2 = 'and proportionality factor'
            CIPHER3 = '(current = variable length)'
         ENDIF
         IF (COLOR1) THEN
            CIPHER4 = '(current = coloured)'
         ELSE
            CIPHER4 = '(current = monochrome)'
         ENDIF             
         IF (SWAP1) THEN
C
C Y(2) against Y(1)
C           
            NSWAP1 = 1
            NSWAP2 = 2
            XBOT = YSTART
            XTOP = YSTOP
            YBOT = XSTART
            YTOP = XSTOP
         ELSE
C
C Y(1) againsy Y(2)
C           
            NSWAP1 = 2
            NSWAP2 = 1
            XBOT = XSTART
            XTOP = XSTOP
            YBOT = YSTART
            YTOP = YSTOP
         ENDIF      
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) NGRID, NSWAP1, XBOT, NSWAP1, XTOP, 
     +                       NSWAP2, YBOT, NSWAP2, YTOP, 
     +                       FACTOR, CIPHER1, EPSI,
     +                       CIPHER2, CIPHER3, CIPHER4
         ELSE
            D13(1) = SHOWLJ(XBOT)
            D13(2) = SHOWLJ(XTOP)
            D13(3) = SHOWLJ(YBOT)
            D13(4) = SHOWLJ(YTOP)
            D13(5) = SHOWLJ(FACTOR)
            D13(6) = SHOWLJ(EPSI) 
            WRITE (TEXT,150) NGRID, NSWAP1, D13(1), NSWAP1, D13(2), 
     +                       NSWAP2, D13(3), NSWAP2, D13(4), 
     +                       D13(5), CIPHER1, D13(6),
     +                       CIPHER2, CIPHER3, CIPHER4
         ENDIF  
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Initialise the arrow types (changed at singularities) and head sizes
C
            DO I = 1, JARROW
               IARROW(I) = 1
               HEAD(I) = FACTOR*HSIZE
               IKOLOR(I) = 0
            ENDDO
            EPSI_M = - EPSI
C
C Define the mesh of grid points for y = Y(1) and x = Y(2)
C
            XDELTA = (XSTOP - XSTART)/(DBLE(NGRID) - ONE)
            YDELTA = (YSTOP - YSTART)/(DBLE(NGRID) - ONE)
            K = 0
            DO I = 1, NGRID
               IF (I.EQ.1) THEN
                  Y(1) = YSTART
               ELSEIF (I.EQ.NMAX) THEN
                  Y(1) = YSTOP
               ELSE
                  Y(1) = Y(1) + YDELTA
               ENDIF
               DO J = 1, NGRID
                  IF (J.EQ.1) THEN
                     Y(2) = XSTART
                  ELSEIF (J.EQ.NMAX) THEN
                     Y(2) = XSTOP
                  ELSE
                     Y(2) = Y(2) + XDELTA
                  ENDIF
C
C Evaluate the RHS of dy(i)/dx = F(i)
C
                  IF (USER) THEN
                     CALL USEDEQ (NEQN, T, Y, F, P, IP)
                  ELSE
                     CALL DEQF02 (NEQN, T, Y, F, P, IP)
                  ENDIF
C
C Increment K then assign angles and arrows ... First the arrow bases
C
                  K = K + 1
                  X2(K) = Y(2)
                  Y2(K) = Y(1)
C
C Now the arrow heads depending on F(i)
C
                  IF (SCALE1) THEN
                     IF (F(1).GT.EPSI .AND. F(2).GT.EPSI) THEN
C
C 1st quadrant
C
                        THETA = ATAN(F(1)/F(2))
                        X1(K) = X2(K) + XDELTA*COS(THETA)/TWO
                        Y1(K) = Y2(K) + YDELTA*SIN(THETA)/TWO
                     ELSEIF (F(1).GT.EPSI .AND. F(2).LT. EPSI_M) THEN
C
C 2nd quadrant
C
                        THETA = ATAN( - F(1)/F(2))
                        X1(K) = X2(K) - XDELTA*COS(THETA)/TWO
                        Y1(K) = Y2(K) + YDELTA*SIN(THETA)/TWO
                     ELSEIF (F(1).LT.EPSI_M .AND. F(2).LT.EPSI_M) THEN
C
C 3rd quadrant
C
                        THETA = ATAN(F(1)/F(2))
                        X1(K) = X2(K) - XDELTA*COS(THETA)/TWO
                        Y1(K) = Y2(K) - YDELTA*SIN(THETA)/TWO
                     ELSEIF (F(1).LT.EPSI_M .AND. F(2).GT.EPSI) THEN
C
C 4th quadrant
C
                        THETA = ATAN( - F(1)/F(2))
                        X1(K) = X2(K) + XDELTA*COS(THETA)/TWO
                        Y1(K) = Y2(K) - YDELTA*SIN(THETA)/TWO
                     ELSEIF (ABS(F(1)).LE.EPSI .AND.
     +                       ABS(F(2)).LE.EPSI) THEN
C
C The singular case when F(1) = F(2) = 0 so set X1 = X2, Y1 = Y2
C
                        X1(K) = X2(K)
                        Y1(K) = Y2(K)
                     ELSEIF (ABS(F(2)).LE.EPSI) THEN
C
C Vertical
C
                        X1(K) = X2(K)
                        IF (F(1).GT.ZERO) THEN
                           Y1(K) = Y2(K) + YDELTA/TWO
                        ELSE
                           Y1(K) = Y2(K) - YDELTA/TWO
                        ENDIF
                     ELSE
C
C Horizontal
C
                        Y1(K) = Y2(K)
                        IF (F(2).GT.ZERO) THEN
                           X1(K) = X2(K) + XDELTA/TWO
                        ELSE
                           X1(K) = X2(K) - XDELTA/TWO
                        ENDIF
                     ENDIF
                  ELSE
                     X1(K) = X2(K) + SHAFT*F(2)
                     Y1(K) = Y2(K) + SHAFT*F(1)
                  ENDIF
                  IF (COLOR1) THEN
                     IF (F(1).GT.EPSI .AND. F(2).GT.EPSI) THEN
                        IKOLOR(K) = 0
                     ELSEIF (F(1).GT.EPSI .AND. F(2).LT.EPSI_M) THEN
                        IKOLOR(K) = 4
                     ELSEIF (F(1).LT.EPSI_M .AND. F(2).LT.EPSI_M) THEN
                        IKOLOR(K) = 2
                     ELSEIF (F(1).LT.EPSI_M .AND. F(2).GT.EPSI) THEN
                        IKOLOR(K) = 1
                     ELSE
                        IKOLOR(K) = 0   
                     ENDIF         
                  ENDIF     
               ENDDO
            ENDDO
C
C Now call GKSVF1 to draw the vector field
C
            IF (SWAP1) THEN 
C
C Y(2) as a function of Y(1)
C              
               CALL GKSVF1 (IARROW, IKOLOR, JARROW, LCOLOR, NGKS,
     +                      HEAD, Y1, Y2, X1, X2,
     +                      PTITLE, YTITLE, XTITLE,
     +                      AXES, GSAVE)
            ELSE
C
C Y(1) as a function of Y(2)
C              
               CALL GKSVF1 (IARROW, IKOLOR, JARROW, LCOLOR, NGKS,
     +                      HEAD, X1, X2, Y1, Y2,
     +                      PTITLE, XTITLE, YTITLE,
     +                      AXES, GSAVE)
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: Change the number of divisions
C
            CALL GETJM1 (NEQN, NGRID, NMAX,
     +                  'Number of grid divisions required')
            JARROW = NGRID*NGRID
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Change the X-range
C             if SWAP1 = .TRUE. y = Y(2), x = Y(1)
C
            IF (SWAP1) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,200) YSTART, YSTOP
               ELSE
                   D13(1) = SHOWLJ(YSTART)
                   D13(2) = SHOWLJ(YSTOP)
                   WRITE (LINE,250) TRIM(D13(1)), TRIM(D13(2))
               ENDIF  
               CALL GETDG2 (YSTART, YSTOP,
     +                      LINE)
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,200) XSTART, XSTOP
               ELSE
                  D13(1) = SHOWLJ(XSTART)
                  D13(2) = SHOWLJ(XSTOP)
                  WRITE (LINE,250) TRIM(D13(1)), TRIM(D13(2))
               ENDIF  
               CALL GETDG2 (XSTART, XSTOP,
     +                      LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: Change the Y-range
C             if SWAP1 = .TRUE. y = Y(2), x = Y(1)
C
            IF (SWAP1) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,300) XSTART, XSTOP
               ELSE
                  D13(1) = SHOWLJ(XSTART)
                  D13(2) = SHOWLJ(XSTOP)
                  WRITE (LINE,350) TRIM(D13(1)), TRIM(D13(2))
               ENDIF  
               CALL GETDG2 (XSTART, XSTOP,
     +                      LINE)
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,300) YSTART, YSTOP
               ELSE
                  D13(1) = SHOWLJ(YSTART)
                  D13(2) = SHOWLJ(YSTOP) 
                  WRITE (LINE,350) D13(1), D13(2)
               ENDIF  
               CALL GETDG2 (YSTART, YSTOP,
     +                      LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: Change the arrow head size
C
            IF (E_NUMBERS) THEN
               WRITE (LINE,400) 'head', FACTOR
            ELSE
               D13(1) = SHOWLJ(FACTOR)
               WRITE (LINE,450) 'head', D13(1)
            ENDIF  
            CALL GETDGT (FACTOR, RTOL,
     +                   LINE)
            IF (.NOT.SCALE1) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,400) 'proportionality', SHAFT
               ELSE
                  D13(1) = SHOWLJ(SHAFT)  
                  WRITE (LINE,450) 'proportionality', D13(1) 
               ENDIF  
               CALL GETDGT (SHAFT, RTOL,
     +                      LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.6) THEN
C
C NUMDEC = 6: Change EPSI
C      
            IF (E_NUMBERS) THEN
               WRITE (LINE,500) EPSI
            ELSE
               D13(1) = SHOWLJ(EPSI)
               WRITE (LINE,550) D13(1)  
            ENDIF   
            CALL GETDGT (EPSI, RTOL,
     +                   LINE)
         ELSEIF (NUMDEC.EQ.7) THEN
C
C NUMDEC = 7: Change scaling
C         
            SCALE1 = .NOT.SCALE1
            IF (SCALE1) THEN
               WRITE (LINE,600) 'Fixed length', 'on'
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,400) 'proportionality', SHAFT
               ELSE
                  D13(1) = SHOWLJ(SHAFT)
                  WRITE (LINE,450) 'proportionality', D13(1) 
               ENDIF  
               CALL GETDGT (SHAFT, RTOL,
     +                      LINE)
               WRITE (LINE,600) 'Proportional', 'on'
            ENDIF
            CALL PUTADV (LINE)      
         ELSEIF (NUMDEC.EQ.8) THEN
C
C NUMDEC = 8: Change colour
C         
            COLOR1 = .NOT.COLOR1 
            IF (COLOR1) THEN
               WRITE (LINE,700) 'on'
            ELSE   
               WRITE (LINE,700) 'off'
            ENDIF       
            CALL PUTADV (LINE)
         ELSEIF (NUMDEC.EQ.9) THEN
C
C NUMDEC = 9: Change swap round
C         
            SWAP1 = .NOT.SWAP1 
            IF (SWAP1) THEN
               NSWAP1 = 2
               NSWAP2 = 1
            ELSE   
               NSWAP1 = 1
               NSWAP2 = 2
            ENDIF       
            WRITE (LINE,800) NSWAP1, NSWAP2
            CALL PUTADV (LINE) 
         ELSEIF (NUMDEC.EQ.10) THEN
C
C NUMDEC = 10: Help
C         
            WRITE (TEXT,900)
            I = 23
            CALL PATCH2 (NUMBLD, I,
     +                   TEXT)               
         ELSE
C
C NUMDEC = NUMOPT: Exit
C        
            REPEET = .FALSE.   
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'DEQSOL phase portrait options'
     +/
     +/'Number of grid points =',I3,' divisions'
     +/'X_start [i.e. y(',I1,')_begin] =',1P,E11.3
     +/'X_stop [i.e. y(',I1,')_end] =',1P,E11.3
     +/'Y_start [i.e. y(',I1,')_begin] =',1P,E11.3
     +/'Y_stop [i.e. y(',I1,')_end] =',1P,E11.3
     +/'Arrow size: head =',1P,E11.3,1X,A
     +/'Singularity tolerance, EPSI =',1P,E11.3
     +/
     +/'Plot the current vector field'
     +/'Change: number of grid points'
     +/'Change: X_start, X_stop'
     +/'Change: Y_start, Y_stop'
     +/'Change: arrow size',1X,A
     +/'Change: singularity tolerance EPSI'
     +/'Change: scaling type',2X,A
     +/'Change: colour scheme',2X,A
     +/'Change: assignment of plot axes'
     +/'Help'
     +/'Cancel')
  150 FORMAT (
     + 'DEQSOL phase portrait options'
     +/
     +/'Number of grid points =',I3,' divisions'
     +/'X_start [i.e. y(',I1,')_begin] =',1X,A
     +/'X_stop [i.e. y(',I1,')_end] =',1X,A
     +/'Y_start [i.e. y(',I1,')_begin] =',1X,A
     +/'Y_stop [i.e. y(',I1,')_end] =',1X,A
     +/'Arrow size: head =',1X,A,1X,A
     +/'Singularity tolerance, EPSI =',1X,A
     +/
     +/'Plot the current vector field'
     +/'Change: number of grid points'
     +/'Change: X_start, X_stop'
     +/'Change: Y_start, Y_stop'
     +/'Change: arrow size',1X,A
     +/'Change: singularity tolerance EPSI'
     +/'Change: scaling type',2X,A
     +/'Change: colour scheme',2X,A
     +/'Change: assignment of plot axes'
     +/'Help'
     +/'Cancel')     
  200 FORMAT (
     + 'X_start, X_stop required: current values =',1P,E11.3,',',E11.3)
  250 FORMAT (
     + 'X_start, X_stop required: current values =',1X,A,',',1X,A)     
  300 FORMAT (
     + 'Y_start, Y_stop required: current values =',1P,E11.3,',',E11.3)
  350 FORMAT (
     + 'Y_start, Y_stop required: current values =',1X,A,',',1X,A)     
  400 FORMAT (
     + 'Arrow ',A,' scaling factor required: current value =',1P,E11.3)
  450 FORMAT (
     + 'Arrow ',A,' scaling factor required: current value =',1X,A)     
  500 FORMAT (
     + 'EPSI to test F(i) for singularity: current value =',1P,E11.3)
  550 FORMAT (
     + 'EPSI to test F(i) for singularity: current value =',1X,A)     
  600 FORMAT (A,1X,'scaling of arrows switched',1X,A)   
  700 FORMAT ('Colouring of arrows is now switched',1X,A)
  800 FORMAT ('Y(',I1,') will be plotted as a function of Y(',I1,')')
  900 FORMAT (
     + 'Advice on constructing a Phase Plane Portrait'
     +/
     +/'This procedure is used for autonomous sytems with 2 components.'
     +/'Through each point of the y(1),y(2) plane there then passes one'  
     +/'unique trajectory (except at critical points). Portraits are'  
     +/'just vector fields with a vector located at each position on a'  
     +/'grid having direction defined by dy(1)/dy(2) (i.e. eliminating'  
     +/'the independent variable from the equations).'
     +/  
     +/'1.`Try to keep the actual range of the X and Y axes similar, as'  
     +/'  `otherwise the angles of the vectors become too distorted and'  
     +/'  `no longer represent the true direction of dy(1)/dy(2).'
     +/'2.`The colour coding can be selected to change as a function of'
     +/'  `direction defined by dy(1)/dy(2) but can be switched off.'     
     +/'3.`Fixed length vectors are easy to interpret but only indicate'
     +/'  `the direction, not the size, of dy(1)/dy(2).' 
     +/'4.`Proportionally scaled vectors show direction and size, but'
     +/'  `must be multiplied by an arbitrary proportionality factor'
     +/'  `that you have to choose in order to make the plot useful.'
     +/'5.`It is sometimes necessary to interchange the axes, change'
     +/'  `the number or size of arrow head, or change the definition'
     +/'  `of EPSI used to identify critical points in order to obtain'
     +/'  `the best visual representation of a vector field.') 
      END
      
C
C
