c
c deqsol7.for
c ===========
c
c deqexp
c vcovar ... uses module_deqsol
c vucorr
c vustd
c

c
c
      subroutine deqexp (m, n, nfiles, 
     +                   bl, bu, p, y0,
     +                   fnames,
     +                   abort)  
c
c action: see if expert mode parameters have been supplied
c author: w.g.bardsley, university of manchester, u.k., 28/12/2009
c         26/01/2010 added nfiles and edited for user supplied models 
c         14/07/2018 extensive revision to allow suppression
c
c      m: dimension of bl, bu, p
c      n: dimension of y0 = number of equations so m >= n
c nfiles: number of data files
c     bl: lower parameter limits
c     bu: upper paramter limits
c      p: parameter starting estimates
c     y0: initial conditions
c fnames: data files
c  abort: success indicator
c
c
      implicit none
c
c arguments
c       
      integer,             intent (in)    :: m, n, nfiles
      double precision,    intent (inout) :: bl(m), bu(m),
     +                                       p(m), y0(n)
      character (len = *), intent (in)    :: fnames(nfiles)
      logical,             intent (out)   :: abort
c
c allocatables
c     
      double precision, allocatable :: bl1(:),  bu1(:), p1(:)
c
c locals 
c      
      integer    icolor, numhdr
      parameter (icolor = 7, numhdr = 20)
      integer    numbld(numhdr)
      integer    i, ierr, j, npar, nx
      character (len = 100) option, temp, text(numhdr), trim100
      character (len = 1  ) blank, pcent
      parameter (blank = ' ', pcent = '%')
      logical    first, there
      external   eofexp, answer, trim100, putfat
      save       first
      data       first / .true. / 
      data       numbld /numhdr*0 /
c
c initialise abort 
c      
      abort = .true.
      if (m.lt.1 .or. n.lt.1 .or. nfiles.lt.1) return
      if (m.lt.n) then
         call putfat ('m < n in call to DEQEXP')
         return
      endif   
      if (n.lt.nfiles) then
         call putfat ('n < nfiles in call to DEQEXP')
         return
      endif     
c
c check for first file that exists
c        
      there = .false.
      do i = 1, nfiles        
         j = i
         if (fnames(j).ne.blank .and. fnames(j).ne.pcent) then
            inquire (file = fnames(j), exist = there) 
            if (there) exit
         endif
      enddo
      if (.not.there) return        
      ierr = 0
      if (allocated(bl1)) deallocate(bl1, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(bu1)) deallocate(bu1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(p1)) deallocate(p1, stat = ierr)
      if (ierr.ne.0) return
      nx = m           
      allocate (bl1(nx), stat = ierr)
      if (ierr.ne.0) return
      allocate (bu1(nx), stat = ierr)
      if (ierr.ne.0) return
      allocate (p1(nx), stat = ierr)
      if (ierr.ne.0) return
c
c check for expert mode
c        
      call eofexp (npar, nx,
     +             bl1, p1, bu1,
     +             fnames(j), 
     +             abort)
      if (.not.abort .and. npar.ge.m) then
         do i = 1, m
            bl(i) = bl1(i)
            bu(i) = bu1(i)
            p(i) = p1(i)
         enddo  
         j = m - n 
         do i = 1, n
            j = j + 1
            y0(i) = p1(j)
         enddo  
      else
         if (abort .and. first) then
            temp = trim100(fnames(j))
            write (text,100) temp
            write (option,200)
            numbld(1) = 1
            numbld(20) = 1
            call answer (icolor, numbld, numhdr, 
     +                   text, option, 
     +                   first)
            first = .not.first                        
         endif           
      endif
      deallocate (bl1, stat = ierr)        
      deallocate (bu1, stat = ierr)        
      deallocate (p1, stat = ierr) 
c
c format statements
c       
  100 format (
     + 'Parameter starting estimates and limits in program DEQSOL'
     +/
     +/'To simulate n differential equations you must define m + n'
     +/'variable parameters (m >= 0, n > 0) where the last n values are'
     +/'the intial conditions. This can be done using values set by a'
     +/'library model, a user-supplied model file containing default'
     +/'values, or by input of a separate parameter file.'
     +/'Such a default set of m parameters and n initial condition'
     +/'can then be edited interactively as required.'
     +/
     +/'For curve-fitting it is also necessary to set parameter limits'
     +/'using a library model, a user-supplied model, a parameter' 
     +/'limits file, or by adding a begin{limits}...end{limits} section'  
     +/'to the first active data file to be fitted, so over-riding the'
     +/'current defaults. To avoid ambiguity you can be warned if the'
     +/'first data file does not have a begin{limits}...end{limits}'
     +/'section, in which case the current defaults will be used.'
     +/
     +/'No begin{limits}...end{limits} section was found in the file'
     +/a)
  200 format ('Suppress this advice during the current session')    
      end
c
c

C
C----------------------------------------------------------------------
C
      SUBROUTINE VCOVAR (IADDUP, INDEX1, INDX, IRELAB, ISTATE,
     +                   IW, LIW, M, METHOD, MODEL, MPED, N, NFREE, 
     +                   NHESS, NMOD, NOUT, NPMAX, NTMAX, NWORK, NPTBIG,
     +                   NUMPNT, NYMAX,
     +                   CORR, CV, DIAGV, DOFDOM, 
     +                   FACTOR, FJACC, HESSEX, HESSIN, PARNEW,
     +                   RTOL, SDATA, SIGMA, TOL, W, X, XEND,
     +                   XSTART, Y, YCOM, YVAL, YPREV, Y0,
     +                   FREE, STATS, TIMER, USER)
      USE MODULE_DEQSOL, ONLY : ICOUNT, IP, NIP
C
C ACTION : estimate the variance covariance matrix, etc.
C AUTHOR : W. G. Bardsley, UNIVERSITY OF MANCHESTER, U.K., 05/10/1989
C          Now returns STATS = .FALSE. if covariance matrix is rank deficient
C          28/12/2009 adapted from VCOVAR of QNFIT for DEQSOL  
C          15/11/2021 changed PARNEW(M) to PARNEW(NPMAX) and Y0(M) tp Y0(NYMAX)	

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: IADDUP, IRELAB, IW, LIW,
     +                                       M, METHOD, MODEL, MPED, N,
     +                                       NHESS, NMOD, NOUT, NPMAX, 
     +                                       NTMAX, NYMAX  
      INTEGER,             INTENT (IN)    :: INDX(NTMAX,N), NPTBIG,
     +                                       NUMPNT(N)
      INTEGER,             INTENT (INOUT) :: NFREE
      INTEGER,             INTENT (INOUT) :: INDEX1(M), NWORK(LIW)
      INTEGER,             INTENT (IN)    :: ISTATE(M)
      DOUBLE PRECISION,    INTENT (IN)    :: DOFDOM, RTOL, TOL, 
     +                                       XEND, XSTART
      DOUBLE PRECISION,    INTENT (IN)    :: SDATA(NTMAX,N)
      DOUBLE PRECISION,    INTENT (INOUT) :: CORR(NHESS,NHESS),
     +                                       CV(NHESS,NHESS), DIAGV(M),
     +                                       FACTOR(M),
     +                                       FJACC(NTMAX,M),
     +                                       HESSEX(NHESS,NHESS),
     +                                       HESSIN(NHESS,NHESS), 
     +                                       PARNEW(NPMAX),
     +                                       SIGMA, 
     +                                       W(IW), X(M),
     +                                       Y(NYMAX), YCOM(NTMAX,N),
     +                                       YPREV(NYMAX),
     +                                       YVAL(NTMAX,N), Y0(NYMAX) 
      LOGICAL,             INTENT (IN)    :: TIMER, USER
      LOGICAL,             INTENT (INOUT) :: FREE(M), STATS
C
C Locals
C      
      INTEGER    I, ICOL, IFAIL, IROW, J, K, L, NFILE
      INTEGER    COLOUR
      DOUBLE PRECISION CPU, DUMMY, H, SCALE1, SUM1
      DOUBLE PRECISION ZERO, EPSI, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-06, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      CHARACTER  TEXT(100)*100
      LOGICAL    WAIT
      EXTERNAL   QNINV1, WAITER, ACTION
      EXTERNAL   TABLE1
      INTRINSIC  ABS, MAX, SQRT
        
      IF (STATS) THEN
C
C ISEND = 1: Calculate the covariance matrix
C        
         WAIT = .TRUE.
         CALL WAITER (WAIT)
C
C First save the current solution by transferring YVAL into YCOM
C
         DO I = 1, N
            DO J = 1, IADDUP
              YCOM(J,I) = YVAL(J,I)
            ENDDO    
         ENDDO  
C
C Build the Jacobian using simple forward differences
C Note: N = number of equations 
C         = number of data files 
C         = number of initial conditions
C       M = number of variables including initial conditions 
C
         DO I = 1, M
C
C Start of outer loop over all parameters
C           
            IF (ISTATE(I).GT.0) THEN  
C
C Parameter i is varied so add a bit to X(i) and calulate new integrals
C              
               H = EPSI*(ONE + EPSI*ABS(X(I)))
               X(I) = X(I) + H
C
C Re-set the new parameters and initial conditions
C
               DO L = 1, M 
                  PARNEW(L) = FACTOR(L)*X(L)
               ENDDO
               J = M - N
               DO L = 1, N
                  J = J + 1
                  Y0(L) = PARNEW(J)
               ENDDO
C
C Integrate the equations
C
               ICOUNT = 1
               IFAIL = 1
               CALL ACTION (IFAIL, IP, IRELAB, IW, M, METHOD, MODEL,
     +                      MPED, N, NIP, NMOD, NPMAX, NWORK, NYMAX,
     +                      CPU, PARNEW, TOL, W, XEND, XSTART, Y,
     +                      YPREV, Y0,
     +                      TIMER, USER) 

C
C Restore X(i)
C
               X(I) = X(I) - H
            ENDIF   
C
C Construct column I of the Jacobian as (f(x + h) - f(x))/h
C
            K = 0
            DO NFILE = 1, N
C
C Start of inner loop over all files
C              
               IF (NUMPNT(NFILE).GT.0) THEN
                  IF (ISTATE(I).GT.0) THEN
                     DO J = 1, NUMPNT(NFILE)
                        K = K + 1
                        L = INDX(J,NFILE)
                        FJACC(K,I) = (YVAL(L,NFILE) - YCOM(L,NFILE))/
     +                               (H*SDATA(J,NFILE))
                     ENDDO
                  ELSE
                     DO J = 1, NUMPNT(NFILE)
                        K = K + 1
                        FJACC(K,I) = ZERO
                     ENDDO
                  ENDIF
               ENDIF   
C
C End of inner loop over all files
C               
            ENDDO
C
C End of outer loop over all parameters
C            
         ENDDO
C
C Construct J^T*J
C
         DO I = 1, M
            DO J = 1, I
               SUM1 = ZERO
               DO K = 1, NPTBIG
                  SUM1 = SUM1 + FJACC(K,I)*FJACC(K,J)
               ENDDO
               CORR(I,J) = TWO*SUM1
               CORR(J,I) = CORR(I,J)
            ENDDO
         ENDDO
C
C Construct the projected Hessian
C
         NFREE = 0
         DO I = 1, M
            FREE(I) = .FALSE.
            IF (ISTATE(I).GT.0) THEN
                FREE(I) = .TRUE.
                NFREE = NFREE + 1
                INDEX1(NFREE) = I
            ENDIF
         ENDDO
         DO I = 1, NFREE
            DO J = 1, I
               DUMMY = CORR(INDEX1(I),INDEX1(J))
               HESSIN(I,J) = DUMMY/DOFDOM
               HESSIN(J,I) = HESSIN(I,J)
               HESSEX(I,J) = DUMMY/(FACTOR(INDEX1(I))*FACTOR(INDEX1(J)))
               HESSEX(J,I) = HESSEX(I,J)
            ENDDO
         ENDDO
C
C Do the matrix inversion .. if QNINV1 fails it returns all elements = 1
C
         CALL QNINV1 (NHESS, NFREE, NOUT, 
     +                HESSEX, CV)
         STATS = .FALSE.
         SCALE1 = TWO*SIGMA
         DO I = 1, NFREE
            DO J = 1, I
               IF (ABS(ONE - CV(I,J)).GE.EPSI) STATS = .TRUE.
               CV(I,J) = SCALE1*CV(I,J)
               IF (I.NE.J) CV(J,I) = CV(I,J)
            ENDDO
         ENDDO
         WAIT = .FALSE.
         CALL WAITER (WAIT)
C
C Get the diagonal elements
C
         NFREE = 0
         ICOUNT = 0
         DO I = 1, M
            IF (FREE(I)) THEN
               NFREE = NFREE + 1
               DIAGV(I) = CV(NFREE,NFREE)
            ELSE
               DIAGV(I) = ZERO
               IF (ISTATE(I).NE.0) THEN 
                  ICOUNT = ICOUNT + 1
                  WRITE (TEXT(ICOUNT),100) I
               ENDIF   
            ENDIF
         ENDDO
         IF (ICOUNT.GT.0) THEN
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = 0
            DO I = 1, ICOUNT
               CALL TABLE1 (COLOUR, TEXT(I))
            ENDDO
            CALL TABLE1 (COLOUR, 'CLOSE')
         ENDIF
C
C Create the correlation matrix
C
         IF (NFREE.GT.1) THEN
            IROW = 0
            DO I = 1, M
               IF (FREE(I)) IROW = IROW + 1
               ICOL = 0
               DO J = 1, I - 1
                  IF (FREE(J)) ICOL = ICOL + 1
                  IF (FREE(I) .AND. FREE(J)) THEN
                     DUMMY = SQRT(ABS(CV(ICOL,ICOL)*CV(IROW,IROW)))
                     CORR(I,J) = CV(IROW,ICOL)/MAX(DUMMY,RTOL)
                     IF (CORR(I,J).LT.- ONE) CORR(I,J) = - ONE
                     IF (CORR(I,J).GT.  ONE) CORR(I,J) =   ONE
                  ELSE
                     CORR(I,J) = ZERO
                  ENDIF
               ENDDO
            ENDDO
C
C Pad out the covariance matrix
C
            IF (NFREE.LT.M) THEN
               DO I = 1, M
                  DO J = 1, I
                     IF (I.EQ.J) THEN
                        CV(J,J) = DIAGV(J)
                     ELSE
                        IF (FREE(I) .AND. FREE(J)) THEN
                           CV(I,J) = CORR(I,J)*SQRT(DIAGV(I)*DIAGV(J))
                        ELSE
                           CV(I,J) = ZERO
                        ENDIF
                        CV(J,I) = CV(I,J)
                     ENDIF
                  ENDDO
               ENDDO
            ENDIF
         ENDIF
C
C Restore YVAL
C
         DO I = 1, N
            DO J = 1, IADDUP
              YVAL(J,I) = YCOM(J,I)
            ENDDO    
         ENDDO  
      ENDIF
C
C Format statements
C      
  100 FORMAT (1X,'WARNING : Ignore Std. err. for parameter',I3)
      END
C
C----------------------------------------------------------------------
C   
      SUBROUTINE VUCORR (IW, M, NFREE, NHESS, NOUT, NPMAX,  
     +                   CORR, EIGVAL, HESSIN, RTOL, W, 
     +                   RECORD,
     +                   DEQLGL, FIRST, FREE, STATS)
C
C ACTION : view correlation matrix
C AUTHOR : W. G. Bardsley, UNIVERSITY OF MANCHESTER, U.K., 05/10/1989
C          28/12/2009 adapted from VCOVAR of QNFIT for DEQSOL  
C          12/12/2016 increased correlation matrix to 5 significant figures 

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: IW, M, NHESS, NOUT, NPMAX 
      INTEGER,             INTENT (IN)    :: NFREE
      DOUBLE PRECISION,    INTENT (IN)    :: RTOL  
      DOUBLE PRECISION,    INTENT (INOUT) :: CORR(NHESS,NHESS),
     +                                       EIGVAL(M), 
     +                                       HESSIN(NHESS,NHESS), 
     +                                       W(IW)
      CHARACTER (LEN = *), INTENT (INOUT) :: RECORD(NPMAX,M)
      LOGICAL,             INTENT (IN)    :: DEQLGL(2), FIRST, FREE(M),
     +                                       STATS
C
C Locals
C      
      INTEGER    I, IFAIL, J, NTEMP
      INTEGER    IADD7
      PARAMETER (IADD7 = 7)
      INTEGER    COLOUR, NSTART, NSTOP
      DOUBLE PRECISION TEMP
      CHARACTER (LEN = 120) LINE, TEXT(100)
      CHARACTER (LEN = 32 ) EXTRA
      CHARACTER (LEN = 9  ) D9(12), FORM09
      CHARACTER (LEN = 9  ) DOTS, PFIXED
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ', DOTS = '    .....', PFIXED = '    *****')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    YES
      EXTERNAL   E_FORMATS, FORM09
      EXTERNAL   F02AAF$
      EXTERNAL   MATCOR
      EXTERNAL   PUTIFA, TABLE1, PUTADV
      INTRINSIC  MIN, TRIM
      E_NUMBERS = E_FORMATS()  
      IF (STATS) THEN
C
C ISEND = 2: Display the correlation matrix if required
C
         IF (NFREE.LE.1 .OR. M.LE.1) RETURN
         NTEMP = 1
         YES = DEQLGL(NTEMP)  
         IF (YES) THEN
            DO I = 1, M
               DO J = 1, I - 1
                  IF (FREE(I) .AND. FREE(J)) THEN
                     WRITE (RECORD(I,J),400) CORR(I,J)
                  ELSE
                     WRITE (RECORD(I,J),500) PFIXED
                  ENDIF
               ENDDO
               RECORD(I,I) = DOTS
               DO J = I + 1, M
                  RECORD(I,J) = BLANK
               ENDDO   
            ENDDO
            IF (NFREE.LT.M) THEN
               EXTRA = '(fixed parameters *****)'
            ELSE
               EXTRA = BLANK
            ENDIF
            WRITE (NOUT,600) BLANK
            WRITE (LINE,700) EXTRA
            CALL MATCOR (NPMAX, M, NOUT, 
     +                   RECORD, LINE, 
     +                   FIRST)
         ENDIF
C
C Display eigenvalues if required
C
         NTEMP = 2
         YES = DEQLGL(NTEMP)
         LINE = ' '
         IF (YES) THEN
            I = NHESS
            J = NFREE
            IFAIL = 1
            CALL F02AAF$(HESSIN, I, J, EIGVAL, W, IFAIL)
            IF (IFAIL.NE.0) THEN
               CALL PUTIFA (IFAIL, NOUT, 'F02AAF/VCOVAR')
               RETURN
            ENDIF
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            WRITE (TEXT,900)
            IF (FIRST) WRITE (NOUT,900)
            COLOUR = 4
            DO I = 1, 3
               CALL TABLE1 (COLOUR, TEXT(I))
            ENDDO
            COLOUR = 0
            NSTART = 1
            DO WHILE (NSTART.LE.NFREE)
               NSTOP = MIN(NSTART + IADD7,NFREE)
               IF (NSTOP.GT.12) NSTOP = 12
               IF (E_NUMBERS) THEN  
                  WRITE (LINE,1000) (EIGVAL(I), I = NSTART, NSTOP)
               ELSE
                  DO I = NSTART, NSTOP 
                     D9(I) = FORM09(EIGVAL(I))
                  ENDDO
                  WRITE (LINE,1050) (D9(I), I = NSTART, NSTOP)   
               ENDIF  
               IF (FIRST) WRITE (NOUT,'(A)') LINE
               CALL TABLE1 (COLOUR, LINE)
               NSTART = NSTOP + 1
            ENDDO
            IF (EIGVAL(1).GT.RTOL) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,1100) EIGVAL(NFREE)/EIGVAL(1)
               ELSE
                  TEMP = EIGVAL(NFREE)/EIGVAL(1)
                  D9(1) = FORM09(TEMP)
                  WRITE (LINE,1150) D9(1) 
               ENDIF  
               IF (FIRST) WRITE (NOUT,'(A)') LINE
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
            CALL TABLE1 (COLOUR, 'CLOSE')
         ENDIF
      ELSE
         CALL PUTADV (
     +'Not configured to calculate the Variance/Covariance matrix')  
      ENDIF
C
C Format statements
C      
  400 FORMAT (F9.5)
  500 FORMAT (A9)
  600 FORMAT (A)
  700 FORMAT (1X,'Parameter correlation matrix',1X,A)
  900 FORMAT (/1X,'Eigenvalues of Hessian matrix (for i =< 12)'/)
 1000 FORMAT (1P,12E10.3)
 1050 FORMAT (12(A9,1X))
 1100 FORMAT (1X,'Condition number =',1P,E10.3)
 1150 FORMAT (1X,'Condition number =',1X,A)
      END
C
C----------------------------------------------------------------------
C      
      SUBROUTINE VUSTDEV (N, NOUT,
     +                    BL, BU, DIAGV, DOFDOM, EPSI, X,
     +                    FIRST, FREE, STATS) 
C
C Action: display parameters and standard errors
C Author: w.g.bardsley, university of manchester, u.k., 03/01/2010
C     
      IMPLICIT NONE
C
C Arguments
C          
      INTEGER,          INTENT (IN) :: N, NOUT
      DOUBLE PRECISION, INTENT (IN) :: BL(N), BU(N), DIAGV(N), DOFDOM,
     +                                 EPSI, X(N)
      LOGICAL,          INTENT (IN) :: FIRST, FREE(N), STATS
C
C Locals
C      
      INTEGER    I, ICOLOR, IFAIL 
      DOUBLE PRECISION PAR, PROB, RATIO, STDEV, TEMP, TVAL
      DOUBLE PRECISION G01EBF$, G01FBF$
      DOUBLE PRECISION ZERO, PNT95, PNT05
      PARAMETER (ZERO = 0.0D+00, PNT95 = 0.95D+00, PNT05 = 0.05D+00)
      CHARACTER (LEN = 13) D13(6), SHOWRJ
      CHARACTER (LEN = 120) LINE
      CHARACTER  SYMBOL*10
      CHARACTER  BLANK*5, FIX*5, STAR*5
      PARAMETER (BLANK = '     ', FIX = 'fixed', STAR = '  *  ')
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PUTIFA, PUTADV, TABLE1
      EXTERNAL   G01EBF$, G01FBF$   
      INTRINSIC  SQRT
      E_NUMBERS = E_FORMATS()
      IF (STATS) THEN
C
C Covariance matrix seems OK
C        
         IFAIL = 1
         TVAL = G01FBF$('C', PNT95, DOFDOM, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G01FBF/VUSTDEV')
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         WRITE (LINE,100)
         ICOLOR = 4
         CALL TABLE1 (ICOLOR, LINE)
         IF (FIRST) THEN
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,100)
         ENDIF   
         ICOLOR = 0  
         DO I = 1, N
            PAR = X(I)
            IF (FREE(I) .AND. DIAGV(I).GT.ZERO) THEN
               STDEV = SQRT(DIAGV(I))
               RATIO = PAR/STDEV
               IFAIL = 1 
               PROB = G01EBF$('S', RATIO, DOFDOM, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01EBF/VUSTDEV')
C
C Set SYMBOL = STAR for ill-defined parameters
C               
               IF (PROB.GT.PNT05) THEN
                  SYMBOL = STAR
               ELSE
                  SYMBOL = BLANK
               ENDIF  
C
C Over-write SYMBOL if parameter is at limits
C               
               IF (ABS(BL(I) - PAR).LE.EPSI) THEN
                  SYMBOL = 'Low-Limit' 
               ELSEIF (ABS(BU(I) - PAR).LE.EPSI) THEN
                  SYMBOL = 'High-Limit'
               ENDIF 
               IF (E_NUMBERS) THEN 
                  WRITE (LINE,200) I, BL(I), BU(I), PAR, STDEV,
     +                             PAR - TVAL*STDEV,
     +                             PAR + TVAL*STDEV, PROB, SYMBOL
               ELSE        
                  D13(1) = SHOWRJ(BL(I))
                  D13(2) = SHOWRJ(BU(I))
                  D13(3) = SHOWRJ(PAR)
                  D13(4) = SHOWRJ(STDEV)
                  TEMP = PAR - TVAL*STDEV
                  D13(5) = SHOWRJ(TEMP)
                  TEMP = PAR + TVAL*STDEV
                  D13(6) = SHOWRJ(TEMP) 
                  WRITE (LINE,250) I, D13(1), D13(2), D13(3), D13(4),
     +                             D13(5), D13(6), PROB, SYMBOL 
               ENDIF
            ELSE 
               SYMBOL = FIX
               IF (E_NUMBERS) THEN
                  WRITE (LINE,300) I, BL(I), BU(I), PAR, SYMBOL
               ELSE
                  D13(1) = SHOWRJ(BL(I))
                  D13(2) = SHOWRJ(BU(I))
                  D13(3) = SHOWRJ(PAR) 
                  WRITE (LINE,350) I, D13(1), D13(2), D13(3), SYMBOL 
               ENDIF  
            ENDIF
            CALL TABLE1 (ICOLOR, LINE)
            IF (FIRST) WRITE (NOUT,'(A)') LINE  
         ENDDO    
         CALL TABLE1 (ICOLOR, 'CLOSE')
      ELSE
C
C No or rank-deficient covariance matrix
C        
         CALL PUTADV (
     +'Not configured to calculate the Variance/Covariance matrix')   
      ENDIF   
C
C Format statements
C      
  100 FORMAT ('Number     Low-Limit    High-Limit     Parameter',
     +        '     Std.Error    Lower95%cl    Upper95%cl    p')
  200 FORMAT (I6,1P,6(1X,E13.5),0P,F8.4,2X,A)  
  250 FORMAT (I6,1P,6(1X,A13),F8.4,2X,A)        
  300 FORMAT (I6,1P,3(1X,E13.5),2X,A)
  350 FORMAT (I6,1P,3(1X,A13),2X,A)
      END
C
C           