C
C DEQSOL8.FOR
C ===========
C
C CONTRL
C FUNCT2
C FUNCT3
C D02PAR
C D02SOL
C

C
C-----------------------------------------------------------------------
C
      SUBROUTINE CONTRL (IRELAB, METHOD, MPED, NHEAD, NOUT1, NYMAX,
     +                   ASWAP, DTOL, TOL,
     +                   ANAME, ATITLE, HEADER, OTYPE, RELABS,
     +                   COVAR, ISWAP, READY, REFRESH, SWAPIT, 
     +                   USE_D02CJF, USE_D02EJF,
     +                   USE_E04JYF, USE_E04KZF, USE_E04UFF,
     +                   USE_JACOBIAN,
     +                   USE_NAG)
C
C ACTION: Set IRELAB, MPED and TOL, etc. to control calculations in D02EBF
C AUTHOR: w.g.bardsley, university of manchester, u.k.
C
C METHOD = 1: BDF
C METHOD = 2: ADAMS 
C   MPED = 1: JACOBIAN
C   MPED = 2: NO JACOBIAN
C IRELAB = 0: MIXED
C IRELAB = 1: ABSOLUTE
C IRELAB = 2: RELATIVE
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NHEAD, NOUT1, NYMAX
      INTEGER,             INTENT (INOUT) :: IRELAB, METHOD, MPED
      DOUBLE PRECISION,    INTENT (INOUT) :: ASWAP(NYMAX,NYMAX), DTOL,
     +                                       TOL
      CHARACTER (LEN = *), INTENT (INOUT) :: ANAME, ATITLE, OTYPE,
     +                                       RELABS
      CHARACTER (LEN = *), INTENT (OUT)   :: HEADER(NHEAD)
      LOGICAL,             INTENT (INOUT) :: COVAR, ISWAP, READY,
     +                                       SWAPIT(NYMAX)
      LOGICAL,             INTENT (IN)    :: REFRESH
      LOGICAL,             INTENT (IN)    :: USE_NAG
      LOGICAL,             INTENT (INOUT) :: USE_D02CJF, USE_D02EJF,
     +                                       USE_E04JYF, USE_E04KZF,
     +                                       USE_E04UFF, USE_JACOBIAN  
C
C Locals
C      
      INTEGER    N1, N2, N3, N4
      PARAMETER (N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 0,
     +           NSTART = 12)
      INTEGER    NUMBLD(30), NUMPOS(20)
      INTEGER    ISAV1, ISAV2, ISAV3
      INTEGER    I, IERR, IOS, J, K, NROW, NCOL
      DOUBLE PRECISION XA, XJ, XK
      DOUBLE PRECISION TOLVAL, TOLSAV
      DOUBLE PRECISION EPSI, ONE, ZERO
      PARAMETER (EPSI = 1.0D-10, ONE = 1.0D+00, ZERO = 0.0D+00)
      CHARACTER (LEN = 13) D13, SHOWLJ
      CHARACTER  LINE*100, TEXT(30)*100, TITLE*80
      CHARACTER  TRIM80*80, CHOP80*80
      CHARACTER  JACOBIAN*30, OPTIMISER*6, SOLVER*6, STD_ERR*20,
     +           TYPE1*5, TYPE2*8
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   GETDGE, PUTADV, PUTFAT, OFILES, CHECKF, LBOX01, LBOX02,
     +           TRIM80, CHOP80  
      EXTERNAL   D02PAR     
      INTRINSIC  ABS, NINT, TRIM
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
        
      E_NUMBERS = E_FORMATS() 
      ISAV1 = METHOD
      ISAV2 = MPED
      ISAV3 = IRELAB
      TOLSAV = TOL
      IF (.NOT.USE_NAG) THEN
C
C Make sure NAG is switched off if USE_NAG = .FALSE.
C        
         USE_D02CJF = .FALSE.
         USE_D02EJF = .FALSE.
         USE_E04JYF = .FALSE.
         USE_E04KZF = .FALSE.
         USE_E04UFF = .FALSE.
      ELSEIF (USE_D02CJF .OR. USE_D02EJF) THEN
         TOLSAV = DTOL   
      ENDIF
        
   20 CONTINUE
C
C Covariance matrix
C
      IF (COVAR) THEN
         STD_ERR = 'To be estimated'
      ELSE
         STD_ERR = 'Not being estimated'    
      ENDIF   
C
C The Jacobian
C
      IF (MPED.EQ.1) THEN
         USE_JACOBIAN = .TRUE.
         JACOBIAN = '(Jacobian provided)'
      ELSE
         MPED = 2
         USE_JACOBIAN = .FALSE.
         IF (METHOD.EQ.1) THEN
            JACOBIAN = '(Jacobian estimated)'
         ELSE
            JACOBIAN = '(Jacobian not required)' 
         ENDIF      
      ENDIF
C
C The solver
C     
      IF (USE_D02CJF) THEN
         SOLVER = 'D02CJF'
         TYPE1 = 'Adams'
      ELSEIF (USE_D02EJF) THEN
         SOLVER = 'D02EJF'
         TYPE1 = 'BDF'
      ELSE
         SOLVER = 'DVODE'
         IF (METHOD.EQ.1) THEN
            TYPE1 = 'BDF'
         ELSE
            TYPE1 = 'Adams'
         ENDIF           
      ENDIF
C
C Error test
C
      IF (USE_D02CJF .OR. USE_D02EJF) THEN
         TOLVAL = DTOL
         IF (RELABS.EQ.'M') THEN
            TYPE2 = '   Mixed'
         ELSEIF (RELABS.EQ.'A') THEN
            TYPE2 = 'Absolute' 
         ELSEIF (RELABS.EQ.'R') THEN
            TYPE2 = 'Relative'
         ELSE
            TYPE2 = 'Default'        
         ENDIF 
      ELSE  
         TOLVAL = TOL
         IF (IRELAB.EQ.0) THEN
            TYPE2 = '   Mixed'
         ELSEIF (IRELAB.EQ.1) THEN
            TYPE2 = 'Absolute'
         ELSE
            IRELAB = 2
            TYPE2 = 'Relative'
         ENDIF 
      ENDIF   
C
C Optimiser
C      
      IF (USE_E04JYF) THEN
         OPTIMISER = 'E04JYF'
      ELSEIF (USE_E04KZF) THEN
         OPTIMISER = 'E04KZF'
      ELSEIF (USE_E04UFF) THEN
         OPTIMISER = 'E04UFF'
      ELSE
         OPTIMISER = 'LBFGSB'
      ENDIF
C
C The swap file
C      
      LINE = TRIM80(ANAME)
      TITLE = CHOP80(ATITLE)
      IF (E_NUMBERS) THEN 
         WRITE (TEXT,100) STD_ERR, SOLVER, TYPE1, JACOBIAN, TYPE2,
     +                    SOLVER, TOLVAL, OPTIMISER, LINE, TITLE, SOLVER
      ELSE
         D13 = SHOWLJ(TOLVAL)
         WRITE (TEXT,150) STD_ERR, SOLVER, TYPE1, JACOBIAN, TYPE2,
     +                    SOLVER, D13, OPTIMISER, LINE, TITLE, SOLVER 
      ENDIF  
      DO I = N1, N4
         HEADER(I) = TEXT(N2 + I)
      ENDDO
      
      IF (REFRESH) RETURN
 
      IF (USE_NAG) THEN
         NUMOPT = 10
      ELSE
         NUMOPT = 8
         DO I = 17, 19
            TEXT(I) = TEXT(I + 2)
         ENDDO   
      ENDIF     
      NUMDEC = NUMOPT
      NTEXT = NSTART + NUMOPT - 1
      NUMBLD(1) = 4
      NUMBLD(8) = 1
      NUMBLD(10) = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +             NUMOPT, NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NUMDEC.GE.6 .AND. .NOT.USE_NAG) NUMDEC = NUMDEC + 2
       
   40 CONTINUE
      CLOSE (UNIT = NOUT1)
      IF (NUMDEC.EQ.1) THEN
C
C Covariance matrix
C
         COVAR = .NOT.COVAR
         IF (COVAR) THEN
            WRITE (LINE,200) 'will'
         ELSE    
            WRITE (LINE,200) 'will not'
         ENDIF   
         CALL PUTADV (LINE)
         READY = .FALSE.
         GOTO 20
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Choose the method
C
         WRITE (TEXT,300)
         NUMOPT = 3
         IF (METHOD.EQ.1) THEN
            IF (MPED.EQ.0) THEN
               NUMDEC = 2
            ELSE
               NUMDEC = 1
            ENDIF
         ELSE
            NUMDEC = 3
         ENDIF
         CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, NUMOPT, NUMPOS,
     +                TEXT)
         IF (NUMDEC.EQ.1) THEN
            METHOD = 1
            MPED = 1
         ELSEIF (NUMDEC.EQ.2) THEN
            METHOD = 1
            MPED = 0
         ELSE
            METHOD = 2
            MPED = 0
         ENDIF
         IF (METHOD.NE.ISAV1) READY = .FALSE.
         IF (MPED.NE.ISAV2) READY = .FALSE.
         GOTO 20
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Choose the error test
C
         WRITE (TEXT,400)
         NUMOPT = 3
         NUMDEC = IRELAB + 1
         CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, NUMOPT, NUMPOS,
     +                TEXT)
         IRELAB = NUMDEC - 1
         IF (IRELAB.NE.ISAV3) READY = .FALSE.
         GOTO 20
      ELSEIF (NUMDEC.EQ.4) THEN
C
C Choose the TOL value
C
         IF (E_NUMBERS) THEN
            WRITE (LINE,500) SOLVER, TOLVAL
         ELSE
            D13 = SHOWLJ(TOLVAL)
            WRITE (LINE,550) SOLVER, TRIM(D13)
         ENDIF  
         CALL GETDGE (TOLVAL, EPSI,
     +                LINE)
         IF (USE_D02CJF .OR. USE_D02EJF) THEN
            DTOL = TOLVAL
         ELSE
            TOL = TOLVAL
         ENDIF      
         IF (ABS(TOLVAL - TOLSAV).GT.EPSI) READY = .FALSE.
         GOTO 20
      ELSEIF (NUMDEC.EQ.5) THEN
C
C Choose the optimiser precision
C
         WRITE (TEXT,600)
         NUMDEC = 2
         NUMOPT = 3
         CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, NUMOPT, NUMPOS,
     +                TEXT)
         IF (NUMDEC.EQ.1) THEN
            OTYPE = 'low'
         ELSEIF (NUMDEC.EQ.3) THEN
            OTYPE = 'high'
         ELSE
            OTYPE = 'medium'
         ENDIF
         GOTO 20         
      ELSEIF (NUMDEC.EQ.6) THEN
C
C Change solver
C      
         IF (USE_NAG) THEN
            CALL D02PAR (DTOL,
     +                   RELABS,
     +                   USE_D02CJF, USE_D02EJF, USE_JACOBIAN)            
            READY = .FALSE.         
         ELSE
            CALL PUTFAT ('No valid NAG library DLLs')
         ENDIF 
         GOTO 20       
      ELSEIF (NUMDEC.EQ.7) THEN
C
C Change optimiser
C      
         IF (USE_NAG) THEN
            WRITE (TEXT,700)
            IF (USE_E04JYF) THEN
               NUMDEC = 2
            ELSEIF (USE_E04KZF) THEN
               NUMDEC = 3
            ELSEIF (USE_E04UFF) THEN
               NUMDEC = 4   
            ELSE
               NUMDEC = 1
            ENDIF         
            NUMOPT = 4
            CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, NUMOPT, NUMPOS,
     +                   TEXT)
            IF (NUMDEC.EQ.1) THEN
               USE_E04JYF = .FALSE.
               USE_E04KZF = .FALSE.
               USE_E04UFF = .FALSE.
            ELSEIF (NUMDEC.EQ.2) THEN
               USE_E04JYF = .TRUE.
               USE_E04KZF = .FALSE.
               USE_E04UFF = .FALSE.
            ELSEIF (NUMDEC.EQ.3) THEN
               USE_E04JYF = .FALSE.
               USE_E04KZF = .TRUE.
               USE_E04UFF = .FALSE.   
            ELSE
               USE_E04JYF = .FALSE.
               USE_E04KZF = .FALSE.
               USE_E04UFF = .TRUE.   
            ENDIF          
            READY = .FALSE.           
         ELSE
            CALL PUTFAT ('No valid NAG library DLLs')
         ENDIF
         GOTO 20           
      ELSEIF (NUMDEC.EQ.8 .OR. NUMDEC.EQ.9) THEN
C
C Re-set A = the identity matrix
C
         READY = .FALSE.
         DO I = 1, NYMAX
            SWAPIT(I) = .FALSE.
            DO J = 1, NYMAX
               IF (I.EQ.J) THEN
                  ASWAP(J,I) = ONE
               ELSE
                  ASWAP(J,I) = ZERO
               ENDIF
            ENDDO
         ENDDO
         IF (NUMDEC.EQ.8) THEN
            ISWAP = .FALSE.
            ANAME = 'No current transformation matrix'
            ATITLE = 'The identity matrix'
            GOTO 20
         ELSEIF (NUMDEC.EQ.9) THEN
C
C Set NUMDEC = 5 so that if a crash then re-set ASWAP etc.
C
            NUMDEC = 5
            ISWAP = .TRUE.
            CLOSE (UNIT = NOUT1)
            CALL OFILES (N3, NOUT1, ANAME, ABORT)
            CLOSE (UNIT = NOUT1)
            IF (ABORT) GOTO 40
            OPEN (UNIT = NOUT1, FILE = ANAME)
            IERR = 1
            READ (NOUT1,'(A)',END=60,ERR=60,IOSTAT=IOS) ATITLE
            IF (IOS.NE.0) GOTO 60
            CLOSE (UNIT = NOUT1)
            CALL CHECKF (ANAME, ATITLE, ABORT)
            IF (ABORT) GOTO 40
            OPEN (UNIT = NOUT1, FILE = ANAME)
            IERR = 1
            READ (NOUT1,'(A)',END=60,ERR=60,IOSTAT=IOS) ATITLE
            IF (IOS.NE.0) GOTO 60
            IERR = 2
            READ (NOUT1,*,END=60,ERR=60,IOSTAT=IOS) NROW, NCOL
            IF (IOS.NE.0) GOTO 60
            IF (NROW.LT.1 .OR. NROW.GT.NYMAX) THEN
               CALL PUTFAT (
     +        'Wrong number of rows requested for matrix A')
               GOTO 60
            ENDIF
            IF (NCOL.NE.3) THEN
               CALL PUTFAT ('File must have three columns')
               GOTO 60
            ENDIF
            DO I = 1, NROW
               IERR = IERR + 1
               READ (NOUT1,*,END=60,ERR=60,IOSTAT=IOS) XJ, XK, XA
               IF (IOS.NE.0) GOTO 60
               J = NINT(XJ)
               K = NINT(XK)
               IF (I.LT.1 .OR. I.GT.NYMAX) GOTO 60
               IF (J.LT.1 .OR. J.GT.NYMAX) GOTO 60
               ASWAP(J,K) = XA
               SWAPIT(J) = .TRUE.
            ENDDO
            CLOSE (UNIT = NOUT1)
            GOTO 20
         ENDIF
      ELSE
         RETURN
      ENDIF
   60 CONTINUE
C
C Crash
C
      WRITE (LINE,800) IERR
      CALL PUTADV (LINE)
      NUMDEC = 5
      GOTO 40
C
C Format statements
C      
  100 FORMAT (
     + 'DEQSOL configuration options'
     +/
     +/'Covariance matrix status:',1X,A
     +/'ODE solver:',1X,A,', Method:',1X,A,1X,A
     +/'ODE error test:',1X,A,1X,', ',A,' TOL =',1P,E10.3
     +/'Optimiser:',1X,A
     +/'Current transformation file:'
     +/A
     +/'Current transformation matrix A:'
     +/A
     +/
     +/'Change: covariance matrix calculation'
     +/'Change: DVODE solver method'
     +/'Change: DVODE solver error test'
     +/'Change: ',A,' solver TOL value'
     +/'Change: LBFGSB optimiser precision'
     +/'Change: solver routine'
     +/'Change: optimiser routine'
     +/'Change: transform: Cancel(set A = I)'
     +/'Change: transform: Input a new matrix A'
     +/'Apply')
  150 FORMAT (
     + 'DEQSOL configuration options'
     +/
     +/'Covariance matrix status:',1X,A
     +/'ODE solver:',1X,A,', Method:',1X,A,1X,A
     +/'ODE error test:',1X,A,1X,', ',A,' TOL =',1X,A
     +/'Optimiser:',1X,A
     +/'Current transformation file:'
     +/A
     +/'Current transformation matrix A:'
     +/A
     +/
     +/'Change: covariance matrix calculation'
     +/'Change: DVODE solver method'
     +/'Change: DVODE solver error test'
     +/'Change: ',A,' solver TOL value'
     +/'Change: LBFGSB optimiser precision'
     +/'Change: solver routine'
     +/'Change: optimiser routine'
     +/'Change: transform: Cancel(set A = I)'
     +/'Change: transform: Input a new matrix A'
     +/'Apply')     
  200 FORMAT ('Covariance matrix,',A,' be calculated')
  300 FORMAT (
     + 'BDF (supplied Jacobian)'
     +/'BDF (estimated Jacobian)'
     +/'Adams (no Jacobian)')
  400 FORMAT (
     + 'Mixed error test (Both)'
     +/'Decimal error test (Absolute)'
     +/'Digit error test (Relative)')
  500 FORMAT (A,' TOL value required (current =',1P,E10.3,')')
  550 FORMAT (A,' TOL value required (current =',1X,A,')')
  
  600 FORMAT (
     + 'Optimiser precision: low'
     +/'Optimiser precision: medium'
     +/'Optimiser precision: high')
  700 FORMAT (
     + 'LBFGSB (quasi-Newton)'
     +/'E04JYF (quasi-Newton)'
     +/'E04KZF (modified-Newton)'
     +/'E04UFF (reverse communication SQP)')      
  800 FORMAT ('Error in the file ... Check the file at line',I3)
      END
C
C----------------------------------------------------------------------
C


C
C----------------------------------------------------------------------
C
CFTN95$OPTIONS (SILENT)
      SUBROUTINE FUNCT2 (N, XC, FC, IUSER, USER)
C
C ACTION: Calls FUNCT1 for use by E04JYF
C AUTHOR: w.g.bardsley, university of manchester, u.k.
C      
      IMPLICIT NONE
      INTEGER,          INTENT (IN)    :: N
      INTEGER,          INTENT (INOUT) :: IUSER(*)
      DOUBLE PRECISION, INTENT (IN)    :: XC(N)
      DOUBLE PRECISION, INTENT (INOUT) :: USER(*)
      DOUBLE PRECISION, INTENT (OUT)   :: FC
      EXTERNAL FUNCT1
      CALL FUNCT1 (N, 
     +             XC, FC)
      END
C
C----------------------------------------------------------------------
C
CFTN95$OPTIONS (SILENT)
      SUBROUTINE FUNCT3 (N, XC, FC, GC, IUSER, USER)

C
C ACTION: Calls FUNCT1 for use by E04KZF
C AUTHOR: w.g.bardsley, university of manchester, u.k.
C      
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N
      INTEGER,          INTENT (INOUT) :: IUSER(*)
      DOUBLE PRECISION, INTENT (IN)    :: XC(N)
      DOUBLE PRECISION, INTENT (INOUT) :: USER(*)
      DOUBLE PRECISION, INTENT (OUT)   :: FC, GC(N)
C
C Locals
C      
      INTEGER    I
      INTEGER    INFORM
      LOGICAL    TPOINT
      PARAMETER (TPOINT = .FALSE.)
      EXTERNAL   FUNCT1, QNGRD1
      CALL QNGRD1 (FUNCT1,
     +             INFORM, N,
     +             GC, USER, XC,
     +             TPOINT)     
      CALL FUNCT1 (N, 
     +             XC, FC)
      END      
C 
C-----------------------------------------------------------------------
C
      SUBROUTINE D02PAR (D02TOL,
     +                   RELABS, 
     +                   USE_D02CJF, USE_D02EJF, USE_JACOBIAN) 
C
C ACTION: parameters for D02
C AUTHOR: w.g.bardsley, university of manchester, u.k.
C
C D02TOL: TOL for D02 routines                     
C RELABS: RELABS for D02 routines
C  USE_*: Routine selection
C 
      IMPLICIT NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (INOUT) :: D02TOL
      CHARACTER (LEN = *), INTENT (INOUT) :: RELABS
      LOGICAL,             INTENT (INOUT) :: USE_D02CJF, USE_D02EJF,
     +                                       USE_JACOBIAN 
C
C Locals
C      
      INTEGER    NDEC, NUMDEC
      INTEGER    NUMOPT
      PARAMETER (NUMOPT = 4) 
      DOUBLE PRECISION TOLMAX, TOLMIN, ZERO
      PARAMETER (TOLMAX = 1.0D-01, TOLMIN = 1.0D-10, ZERO = 0.0D+00)
      CHARACTER  TEXT(NUMOPT)*100
      EXTERNAL   LISTBX, GETDM1, PUTFAT, PUTWAR
C
C Configure the ODE interface
C        
      WRITE (TEXT,100)

      IF (USE_D02CJF) THEN
         NUMDEC = 2
      ELSEIF (USE_D02EJF .AND. USE_JACOBIAN) THEN
         NUMDEC = 3 
      ELSEIF (USE_D02EJF .AND. .NOT.USE_JACOBIAN) THEN    
         NUMDEC = 4
      ELSE
         NUMDEC = 1
      ENDIF  
            
      CALL LISTBX (NUMDEC, NUMOPT,
     +             TEXT)
     
      IF (NUMDEC.EQ.1) THEN
         USE_D02CJF = .FALSE.
         USE_D02EJF = .FALSE. 
      ELSEIF (NUMDEC.EQ.2) THEN
         USE_D02CJF = .TRUE.
         USE_D02EJF = .FALSE.
      ELSEIF (NUMDEC.EQ.3) THEN
         USE_D02CJF = .FALSE.
         USE_D02EJF = .TRUE.
         USE_JACOBIAN = .TRUE.
      ELSE
         USE_D02CJF = .FALSE.
         USE_D02EJF = .TRUE.
         USE_JACOBIAN = .FALSE.
      ENDIF
         
      IF (NUMDEC.GT.1) THEN
           
         CALL GETDM1 (TOLMIN, D02TOL, TOLMAX,
     +               'D02CJF/EJF TOL value required')
     
         IF (RELABS.EQ.'M') THEN
            NDEC = 1 
         ELSEIF (RELABS.EQ.'A') THEN
            NDEC = 2 
         ELSEIF (RELABS.EQ.'R') THEN
            NDEC = 3
         ELSEIF (RELABS.EQ.'D') THEN
            NDEC = 4  
         ELSE
            NDEC = 1
         ENDIF 
         WRITE (TEXT,200)
         CALL LISTBX (NDEC, NUMOPT,
     +                TEXT)             
         RELABS = TEXT(NDEC)(1:1)
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Use DVODE'
     +/'Use D02CJF: Adams method'   
     +/'use D02EJF: BDF method (supplied explicit Jacobian)'
     +/'Use D02EJF: BDF method (finite difference Jacobian)')
  200 FORMAT (
     + 'Mixed error test'
     +/'Absolute error test'
     +/'Relative error test'
     +/'Default error test')   
  300 FORMAT ('IFAIL =',I3,1X,'on exit from the D02 routine')   
      END
C 
C-----------------------------------------------------------------------
C
      SUBROUTINE D02SOL (D02FCN, D02JAC, 
     +                   IFAIL, N, 
     +                   D02TOL, XSTART, XSTOP, Y,
     +                   RELABS, 
     +                   USE_D02CJF, USE_D02EJF, USE_JACOBIAN) 
C
C ACTION: integrate using D02
C AUTHOR: w.g.bardsley, university of manchester, u.k.
C
C D02TOL: TOl for D02 routines                     
C XSTART: start point
C  XSTOP: end point
C      Y: initial conditions then integrals
C RELABS: RELABS for D02 routines
C
C 
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: N
      INTEGER,             INTENT (INOUT) :: IFAIL 
      DOUBLE PRECISION,    INTENT (IN)    :: XSTART, XSTOP, Y(N)
      DOUBLE PRECISION,    INTENT (IN)    :: D02TOL
      CHARACTER (LEN = *), INTENT (IN)    :: RELABS
      LOGICAL,             INTENT (IN)    :: USE_D02CJF, USE_D02EJF,
     +                                       USE_JACOBIAN 
C
C Allocatable
C      
      DOUBLE PRECISION, ALLOCATABLE :: W(:)
C
C Locals
C      
      INTEGER    IERR, iW
      DOUBLE PRECISION X, XEND
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  LINE*100
      EXTERNAL   PUTFAT, PUTWAR
      EXTERNAL   D02WGB, OUTPUT
      EXTERNAL   D02FCN, D02JAC
      
C
C Check then call the integrator
C                           
      IF (XSTART.GE.XSTOP) THEN
         CALL PUTFAT ('D02SOL called with XSTART >= XSTOP')
         RETURN
      ELSE 
         X = XSTART
         XEND = XSTOP    
      ENDIF  
      IF (D02TOL.LE.ZERO) THEN
         CALL PUTFAT ('D02SOL called with TOL =< 0')
         RETURN
      ENDIF  
      IF (N.LE.0) THEN
         CALL PUTFAT ('D02SOL called with N =< 0')
         RETURN
      ENDIF  
      IF (RELABS.NE.'M' .AND. RELABS.NE.'A'.AND.
     +    RELABS.NE.'R' .AND. RELABS.NE.'D') THEN 
         CALL PUTFAT ('D02SOL called with RELABS not M,A,R, or D')
         RETURN
      ENDIF    
         
C
C Allocate workspace
C         
      IW = N*(12 + N) + 50
      IERR = 0
      IF (ALLOCATED(W)) DEALLOCATE (W, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      ALLOCATE (W(IW), STAT = IERR)
      IF (IERR.NE.0) RETURN    
C
C Call the solvers  
C
      IF (USE_D02CJF) THEN
         CALL D02WGB ('D02CJF',
     +                X, XEND, N, Y, D02FCN, D02JAC, D02TOL,
     +                RELABS, OUTPUT, W, IW, IFAIL)
      ELSEIF (USE_D02EJF .AND. USE_JACOBIAN) THEN
         CALL D02WGB ('D02EJF_EXPLICIT',
     +                X, XEND, N, Y, D02FCN, D02JAC, D02TOL,
     +                RELABS, OUTPUT, W, IW, IFAIL)
       ELSEIF (USE_D02EJF .AND. .NOT.USE_JACOBIAN) THEN
         CALL D02WGB ('D02EJF_FINITE',
     +                X, XEND, N, Y, D02FCN, D02JAC, D02TOL,
     +                RELABS, OUTPUT, W, IW, IFAIL)
      ENDIF 
      IF (IFAIL.NE.0) THEN
         WRITE (LINE,100) IFAIL
         CALL PUTWAR (LINE)
      ENDIF         
      DEALLOCATE (W, STAT = IERR)
  100 FORMAT ('IFAIL =',I3,1X,'on exit from the D02 routine')   
      END
C
C      
          