C
C DEQSOL9.FOR ... The differential equation routines for NAG
C ===========
C Note: this version uses KMAX_A, KMAX_F, KMAX_J and KMAX_Y to dimension
C       the call to DEQMOD
C
C In order to silence ftn95 several dummy assignments have been made.
C These can all be commented out in the final version.
C
C DEQ001: D02_DEQF01 ... 1 eqn.
C         D02_DEQJ01
C DEQ002: D02_DEQF02 ... 2 eqn.
C         D02_DEQJ02
C DEQ003: D02_DEQF03 ... 3 eqn.
C         D02_DEQJ03
C DEQ004: D02_DEQF04 ... 4 eqn.
C         D02_DEQJ04
C DEQ005: D02_DEQF05 ... 5 eqn.
C         D02_DEQJ05
C DEQUSE: D02_USEDEQ ... user-supplied
C         D02_USEJAC
C
C----------------------------------------------------------------------
C
      SUBROUTINE D02_DEQF01 (T, Y, F)
      USE MODULE_DEQSOL, ONLY : N, PARNEW, IP
C
C ACTION : The differential equations for NEQ = 1
C ADVICE : D02 version
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: T, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: F(N)
      EXTERNAL DEQF01
      CALL DEQF01 (N, T, Y, F, PARNEW, IP)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE D02_DEQJ01 (X, Y, PW)
      USE MODULE_DEQSOL, ONLY : N, PARNEW, IP, ML, MU
C
C ACTION : The Jacobian matrix for NEQ = 1
C ADVICE : D02 version
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: X, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: PW(N,N)
      EXTERNAL DEQJ01
      CALL DEQJ01 (N, X, Y, ML, MU, PW, N, PARNEW, IP)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE D02_DEQF02 (T, Y, F)
      USE MODULE_DEQSOL, ONLY : N, PARNEW, IP
C
C ACTION : The differential equations for N = 2
C ADVICE : D02 version
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: T, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: F(N)
      EXTERNAL DEQF02 
      CALL DEQF02 (N, T, Y, F, PARNEW, IP)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE D02_DEQJ02 (X, Y, PW)
      USE MODULE_DEQSOL, ONLY : N, PARNEW, IP, ML, MU
C
C ACTION : The Jacobian matrix for N = 2
C ADVICE : D02 version
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: X, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: PW(N,N)
      EXTERNAL DEQJ02 
      CALL DEQJ02 (N, X, Y, ML, MU, PW, N, PARNEW, IP)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE D02_DEQF03 (T, Y, F)
      USE MODULE_DEQSOL, ONLY : N, PARNEW, IP
C
C ACTION : The differential equations for N = 3
C ADVICE : D02 version
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: T, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: F(N)
      EXTERNAL DEQF03 
      CALL DEQF03 (N, T, Y, F, PARNEW, IP)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE D02_DEQJ03 (X, Y, PW)
      USE MODULE_DEQSOL, ONLY : N, PARNEW, IP, ML, MU
C
C ACTION : The Jacobian matrix for N = 3
C ADVICE : D02 version
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: X, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: PW(N,N)
      EXTERNAL DEQJ03 
      CALL DEQJ03 (N, X, Y, ML, MU, PW, N, PARNEW, IP)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE D02_DEQF04 (T, Y, F)
      USE MODULE_DEQSOL, ONLY : N, PARNEW, IP
C
C ACTION : The differential equations for N = 4
C ADVICE : D02 version
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: T, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: F(N)
      EXTERNAL DEQF04 
      CALL DEQF04 (N, T, Y, F, PARNEW, IP)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE D02_DEQJ04 (X, Y, PW)
      USE MODULE_DEQSOL, ONLY : N, PARNEW, IP, ML, MU
C
C ACTION : The Jacobian matrix for N = 4
C ADVICE : D02 version
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: X, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: PW(N,N)
      EXTERNAL DEQJ04 
      CALL DEQJ04 (N, X, Y, ML, MU, PW, N, PARNEW, IP)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE D02_DEQF05 (T, Y, F)
      USE MODULE_DEQSOL, ONLY : N, PARNEW, IP
C
C ACTION : The differential equations for N = 5
C ADVICE : D02 version
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: T, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: F(N)
      EXTERNAL DEQF05 
      CALL DEQF05 (N, T, Y, F, PARNEW, IP)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE D02_DEQJ05 (X, Y, PW)
      USE MODULE_DEQSOL, ONLY : N, PARNEW, IP, ML, MU 
C
C ACTION : The Jacobian matrix for N = 5
C ADVICE : D02 version
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: X, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: PW(N,N)
      EXTERNAL DEQJ05 
      CALL DEQJ05 (N, X, Y, ML, MU, PW, N, PARNEW, IP)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE D02_USEDEQ (T, Y, F)
      USE MODULE_DEQSOL, ONLY : N, PARNEW, IP
C
C ACTION : The differential equations for user supplied model
C ADVICE : D02 version
C          PW(NYMAX**2) in this version
C
      IMPLICIT   NONE
C
C Arguments
C   
      DOUBLE PRECISION, INTENT (IN)  :: T, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: F(N)
      EXTERNAL USEDEQ 
      CALL USEDEQ (N, T, Y, F, PARNEW, IP)
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE D02_USEJAC (X, Y, PW)
      USE MODULE_DEQSOL, ONLY : N, PARNEW, IP, ML, MU 
C
C ACTION : The Jacobian matrix for user supplied models
C ADVICE : D02 version
C          12/01/1998 Dimensioned F(NYMAX) since estimation of Jacobian
C                     could involve calculation of F
C          04/09/2009 minor editing and introduced YJA
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: X, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: PW(N,N)
      EXTERNAL USEJAC 
      CALL USEJAC (N, X, Y, ML, MU, PW, N, PARNEW, IP)
      END
C
C
