C
C These two subroutines MUST be loaded when linking all Simfit programs
C =====================================================================
C
C These subroutines are used to check if the executables and dlls are
C consistent. When the SIMFIT package is compiled you have to edit the
C DLLNUM, DLLMAT, DLLMEN, DLLGRA, DLLSIM, DLLMOD and DLLHLP subroutines in the
C corresponding DLL codes. Then the details are edited in these subroutines
C which are then compiled and linked into the executables via the .lnk
C scripts. When each executable is fired up it will check if the data in
C SIMVER is consistent with the data in the DLLs. Note that the version
C (xver) and release (yver) must be correct to 1 and 0 decimal places
C respectively.
C
C SIMVER: the simfit version and release details
C DLLCHK: checks for consistency with the DLLs
C
C
      SUBROUTINE SIMVER (XVER, YVER,
     +                   DVER)
C
C ACTION: Set release details
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 12/02/2000
C         10/04/2000 Use 3 decimal places from now on
C         07/03/2005 Use the release number only from now on
C         27/07/2005 Added the call to DLLNAG to define DVER
C         24/05/2007 Added INTENTS and now only 1 decimal place
C         12/12/2012 revised in line with 64-bit version
C         24/10/2015 used ISALF to decide between 32-bit and 64-bit
C
C         XVER: (output) version number
C         YVER: (output) release number
C         DVER: (output) description
C
      IMPLICIT NONE
C
C Arguments
C
      DOUBLE PRECISION,    INTENT (OUT) :: XVER, YVER
      CHARACTER (LEN = *), INTENT (OUT) :: DVER
C
C Locals
C
      INTEGER    IVER, MARK
      INTEGER    ISALF
      CHARACTER (LEN = 1 ) BLANK, DOT, ZERO
      CHARACTER (LEN = 3 ) WORD3
      CHARACTER (LEN = 4 ) WORD4
      CHARACTER (LEN = 12) WORD12
      CHARACTER (LEN = 15) FORM15, WORD15
      PARAMETER (BLANK = ' ', DOT = '.', ZERO = '0')
      LOGICAL    NAG
      EXTERNAL   DLLNAG, FORM15, SCCLIB
      INTRINSIC  ADJUSTL, ADJUSTR, NINT
C
C part 1: initialise XVER and YVER as follows
C =======
C XVER = current version
C YVER = current release
C**********************************************
      XVER = 8.0D+00
      YVER = 8.0D+00
C***********************************************
C

C
C Part 2: initialise DVER (the release descriptor)
C =======
C
      CALL SCCLIB (ISALF)
      WORD15 = FORM15(XVER)
      WORD4 = WORD15(1:4)
      IF (LEN_TRIM(WORD4).EQ.1) THEN
         WORD4(2:2) = DOT
         WORD4(3:3) = ZERO
      ENDIF    
      
      IVER = NINT(YVER)
      IF (IVER.LT.10) THEN
         WRITE (WORD3,'(A1,I1,1X)') DOT, IVER
      ELSE
         WRITE (WORD3,'(A1,I2)') DOT, IVER
      ENDIF
      CALL DLLNAG (MARK,
     +             NAG)
      IF (MARK.GE.20) THEN
         IF (NAG) THEN
            WORD12 = BLANK
         ELSE
            WORD12 = '*NO LICENCE*'     
         ENDIF   
         WRITE (DVER,100) ADJUSTR(WORD4), WORD3, MARK, WORD12
      ELSE
         IF (ISALF.GT.0) THEN
            WRITE (DVER,200) ADJUSTR(WORD4), WORD3
         ELSE 
            WRITE (DVER,300) ADJUSTR(WORD4), WORD3
         ENDIF     
      ENDIF
      DVER = ADJUSTL(DVER)
C
C NOTE: formats 100 and 200 must initialise DVER to less than
C       or equal to the default length, currently 30 characters
C
  100 FORMAT (A4,A3,'NAG Mark',I3,A)
  200 FORMAT (A4,A3,'Academic 32-bit')
  300 FORMAT (A4,A3,'Academic 64-bit')
      END
C
C
C
C
      SUBROUTINE DLLCHK (XVER, YVER,
     +                   DVER, PVER,
     +                   ABORT, SHOW)
C
C ACTION : Check the DLLs
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 3/8/98
C          01/10/1998 removed () from C_EXTERNAL statement
C          17/11/1999 changed warning for version 5.2 and added notes
C                     to help translators. Note that windows.ins is not
C                     'included' in this version to make it self-contained
C                     as a further help to translators.
C          12/02/2000 edited for version 5.3
C          10/04/2000 increased no. of significant figures in test procedure
C                     to 2 decimal places for version (xver) and 3 for
C                     release (yver)
C          25/01/2002 added no_minbox to %ww
C          14/02/2002 added dble, w_syspar and size1
C          17/02/2004 added w_help.dll
C          12/02/2005 changed Date to Description in format 200
C          07/03/2005 added iver and ifixed to output just the integer
C                     part in of the release number in format 300
C          28/07/2005 increased DFIXED to length = 30 
C          24/05/2007 new version using PATCH1  
C          18/06/2007 added call to w_clearwin.dll
C          13/08/2010 prevented error message when linked to NAG DLLs
C          24/10/2015 used ISALF to decide between 32-bit and 64-bit
C          15/11/2015 added call to CLRLIB to get ICLEAR 
C
C          XVER: (input/unchanged) current SIMFIT version
C          YVER: (input/unchanged) current SIMFIT release
C          DVER: (input/unchanged) current SIMFIT details
C         PNAME: (input/unchanged) program name
C         ABORT: (output) error indicator so display if .TRUE.
C          SHOW: (input/unchanged) always display if .TRUE.
C
C          ISALF = SALFLIBC.DLL version number obtained from salflibc.dll
C          KSALF = SALFLIBC.DLL version number (current minimum value)
C          KTXT  = number of lines in error message
C
      IMPLICIT   NONE
C
C Arguments
C
      DOUBLE PRECISION,    INTENT (IN)  :: XVER, YVER
      CHARACTER (LEN = *), INTENT (IN)  :: DVER, PVER
      LOGICAL,             INTENT (IN)  :: SHOW
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Current value for KSALF ... the signature for salflibc.dll
C            
      INTEGER    KCLEAR
      PARAMETER (KCLEAR = 7601830) 
      INTEGER    KSALF
      PARAMETER (KSALF = 19270) 
C
C Locals
C      
      INTEGER    K0, K1, K2, K4, KNUM, KTXT, MAXTXT
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K4 = 4, KNUM = 7, KTXT = 14,
     +           MAXTXT = 30) 
      INTEGER    ICOLOR, IX, IY, LSHADE
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 0) 
      INTEGER    I, ICLEAR, ISALF, J, K, L, NUMTXT
      INTEGER    NUMBLD(MAXTXT), IFIXED(KNUM), IVER
      DOUBLE PRECISION XFIXED(KNUM), YFIXED(KNUM)
      DOUBLE PRECISION EPSIX, EPSIY
      PARAMETER (EPSIX = 0.00999D+00, EPSIY = 0.000999D+00)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER (LEN = 1 ) BLANK
      PARAMETER (BLANK = ' ') 
      CHARACTER (LEN = 8 ) WORD8
      CHARACTER (LEN = 12) FORM12, WORD12(4) 
      CHARACTER (LEN = 15) FORM15, WORD15 
      CHARACTER  DFIXED(KNUM)*30, DFIX2*30
      CHARACTER  DLL(KNUM)*15
      CHARACTER  LINES(KTXT)*100, TEXT(MAXTXT)*100  
      LOGICAL    NAG, TEST, X86_VERSION
      LOGICAL    FIXED
      PARAMETER (FIXED = .TRUE.)
      EXTERNAL   DLLMAT, DLLNUM, DLLMEN, DLLGRA, DLLSIM, DLLMOD,
     +           SCCLIB, PATCH1, DLLCLR, LCASE1, FORM12, FORM15,
     +           CLRLIB 
      INTRINSIC  ADJUSTR, INDEX
C
C*****Retain commented out for possible future use
C*****Replaced by call to scc_lib_version@
C*****C_EXTERNAL SCC_LIB_VERSION '_scc_lib_version': INTEGER*4
C*****24/05/2007 Replaced by call to scclib
C
      INTRINSIC  ABS, NINT
C
C Start by initialising ABORT
C
      ABORT = .FALSE.
C
C Define the DLL names
C
      DLL(1) = 'w_numbers.dll'
      DLL(2) = 'w_maths.dll'
      DLL(3) = 'w_menus.dll'
      DLL(4) = 'w_graphics.dll'
      DLL(5) = 'w_clearwin.dll'
      DLL(6) = 'w_simfit.dll'
      DLL(7) = 'w_models.dll'
      
C
C Find out which SIMFIT dlls are in use by calling the DLLS
C
      CALL DLLNUM (XFIXED(1), YFIXED(1), DFIXED(1))
      CALL DLLMAT (XFIXED(2), YFIXED(2), DFIXED(2))
      CALL DLLMEN (XFIXED(3), YFIXED(3), DFIXED(3))
      CALL DLLGRA (XFIXED(4), YFIXED(4), DFIXED(4)) 
      CALL DLLCLR (XFIXED(5), YFIXED(5), DFIXED(5))
      CALL DLLSIM (XFIXED(6), YFIXED(6), DFIXED(6))
      CALL DLLMOD (XFIXED(7), YFIXED(7), DFIXED(7))
     
C
C Check that the executable is consistent with all the dlls
C Also calculate the integer part of the release number
C The NAG DLLs are not tested for release details
C
      IVER = NINT(YVER)
      DO I = K1, KNUM
         TEST = .TRUE.
         IF (I.EQ.K2) THEN
            NAG = .FALSE.
            IF (XFIXED(2).LE.ZERO .AND. YFIXED(2).LE.ZERO) THEN
               NAG = .TRUE.
               TEST = .FALSE.
            ELSE  
               DFIX2 = DFIXED(2)
               CALL LCASE1 (DFIX2)
               IF (INDEX(DFIX2,'mark'   ).GT.0 .OR.
     +             INDEX(DFIX2,'fldll'  ).GT.0 .OR.
     +             INDEX(DFIX2,'license').GT.0 .OR.
     +             INDEX(DFIX2,'licence').GT.0) THEN
                  NAG = .TRUE. 
                  TEST = .FALSE.
               ENDIF
            ENDIF                        
         ENDIF
         IF (TEST) THEN      
            IF (ABS(XFIXED(I) - XVER).GE.EPSIX) ABORT = .TRUE.
            IF (ABS(YFIXED(I) - YVER).GE.EPSIY) ABORT = .TRUE.
         ENDIF 
         IFIXED(I) = NINT(YFIXED(I))
      ENDDO
C
C Check that an up-to-date salflibc.dll has been accessed
C
C*****ISALF = SCC_LIB_VERSION()
C*****ISALF = SCC_LIB_VERSION@()
      CALL SCCLIB (ISALF)
      CALL CLRLIB (ICLEAR)
      IF (ISALF.GT.0) THEN 
         X86_VERSION = .TRUE.
         IF (ISALF.LT.KSALF .OR.
     +       ICLEAR.LT.KCLEAR) ABORT = .TRUE.
      ELSE
         X86_VERSION = .FALSE.
         RETURN
      ENDIF      
      
C
C Display if required
C
      IF (ABORT .OR. SHOW) THEN 
         DO I = K1, MAXTXT
            NUMBLD(I) = K0
         ENDDO
            
         NUMTXT = K1
         WRITE (TEXT(NUMTXT),100) 
         NUMBLD(NUMTXT) = K4
         
         NUMTXT = NUMTXT + K1
         WRITE (TEXT(NUMTXT),200)
       
         WORD12(1) = FORM12(ISALF)
         IF (X86_VERSION) THEN
            WORD12(2) = FORM12(KSALF)
         ELSE
            RETURN
         ENDIF      
         I = LEN_TRIM(WORD12(1))
         J = LEN_TRIM(WORD12(2))
         
         WORD12(3) = FORM12(ICLEAR)
         IF (X86_VERSION) THEN
            WORD12(4) = FORM12(KCLEAR)
         ELSE
            RETURN
         ENDIF      
         K = LEN_TRIM(WORD12(3))
         L = LEN_TRIM(WORD12(4))         

         NUMTXT = NUMTXT + K1
         IF (X86_VERSION) THEN
            WRITE (TEXT(NUMTXT),300) WORD12(1)(1:I), WORD12(2)(1:J)  
            NUMTXT = NUMTXT + 1
            WRITE (TEXT(NUMTXT),325) WORD12(3)(1:K), WORD12(4)(1:L)  
         ELSE   
            WRITE (TEXT(NUMTXT),350) WORD12(1)(1:I), WORD12(2)(1:J)
            NUMTXT = NUMTXT + 1
            WRITE (TEXT(NUMTXT),375) WORD12(3)(1:K), WORD12(4)(1:L)  
         ENDIF 
         NUMTXT = NUMTXT + K1
         TEXT(NUMTXT) = BLANK     
         NUMTXT = NUMTXT + K1
         WRITE (TEXT(NUMTXT),400)
         NUMBLD(NUMTXT) = K1
         
         NUMTXT = NUMTXT + K1
         WORD15 = FORM15(XVER)
         WORD8 = WORD15(1:8)
         IF (LEN_TRIM(WORD8).EQ.1) WORD8(2:3) = '.0'
         WRITE (TEXT(NUMTXT),500) PVER, ADJUSTR(WORD8), IVER, DVER 
         
         DO I = K1, KNUM
            NUMTXT = NUMTXT + K1
            IF (I.EQ.K2 .AND. NAG) THEN
               WRITE (TEXT(NUMTXT),'(A15,A8,A9,2X,A)') DLL(I),
     +                             '     NAG', '      NAG', DFIXED(I)               
            ELSE  
               WORD15 = FORM15(XFIXED(I))
               WORD8 = WORD15(1:8)
               IF (LEN_TRIM(WORD8).EQ.1) WORD8(2:3) = '.0'
               WRITE (TEXT(NUMTXT),500) DLL(I), ADJUSTR(WORD8),
     +                                  IFIXED(I), DFIXED(I)
            ENDIF
         ENDDO      
         
         NUMBLD(NUMTXT + K1) = K1 
         
         IF (ABORT) THEN
C
C An error has been detected
C           
            WRITE (LINES,600)  
            DO I = K1, KTXT
               NUMTXT = NUMTXT + K1
               TEXT(NUMTXT) = LINES(I)
            ENDDO
         ELSE
C
C All seems to be ok
C            
            NUMTXT = NUMTXT + K1 
            WRITE (TEXT(NUMTXT),700)
         ENDIF 
C
C Display the outcome
C                
         CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                TEXT,
     +                FIXED)         
      ENDIF
  100 FORMAT ('Simfit program and dynamic link libraries')
  200 FORMAT (' ')  
  300 FORMAT (
     +'Current salflibc.dll version: ',A,' (must be >= ',A,')')
  325 FORMAT (
     +'Current clearwin version:     ',A,' (must be >= ',A,')')   
  350 FORMAT (
     +'Current salflibc64.dll version: ',A,' (must be >= ',A,')')     
  375 FORMAT (
     +'Current clearwin_64 version:    ',A,' (must be >= ',A,')')        
C
C Translator: this next spacing must be preserved as a table header
C =========== in the monospaced Courier font. Your translation must
C             line up to make a sensible table heading.
C
  400 FORMAT ('Program files   Version  Release  Description')
  500 FORMAT (A15,A8,I9,2X,A)
C
C Translator: If you change the number of lines you must change KTXT
C =========== in the parameter statement. Try not to increase the number
C             of lines or the control will overflow with some displays.
C
  600 FORMAT (
     + 'Warning: These programs are NOT self-consistent.'
     +/
     +/'To avoid problems you should upgrade your Simfit binaries,'
     +/'i.e. reload all executables and dynamic link libraries'
     +/'using the installation program.'
     +/
     +/'Check that all Simfit executables and dlls in the Simfit'
     +/'folder have the same date stamp.'
     +/
     +/'Check that salflibc.dll is a recent version.'
     +/
     +/'Have you upgraded Simfit without upgrading salflibc.dll?'
     +/
     +/'Do you have multiple versions of any Simfit binaries?')
  700 FORMAT ('These programs are self-consistent')
      END
C
C
