C
C FTN95 version
C =============
C
C
      PROGRAM MAIN
C
C VERSION : set by SIVER/DLLCHK
C FORTRAN : 95, Double precision
C DETAILS : This is a version of EDITFL calling EDFLXX
C INPUT   : File with TITLE, NPTS, X, Y, S, NTEXT, TEXT
C OUTPUT  : New file after editing ready for curve fitting
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C REVISED : 13/12/1989 OFILES
C           08/11/1990 JOIN AND COMPRESS FILES
C           16/11/1990 DATTIN
C           24/04/1991 SCREEN AND GRFGK1
C           22/05/1991 GKS001
C           17/02/1993 GET???, PUT??? and compressed
C           15/06/1994 DBOS version 
C           15/02/1995 Added histogram output
C           17/02/1995 Version for Salamanca
C           17/02/1997 Win32 version
C           28/10/1997 Introduced call to W_EDITOR
C           17/03/1998 Introduced ITYPE and command line options
C           07/08/1998 added dllchk
C           03/10/1998 FTN95 version
C           13/09/1999 added call to WINDOW
C           29/09/1999 only called window for normal operation not when
C                      called after curve fitting
C           06/12/1999 Defined NIN and NOUT to assign default values
C           12/02/2000 added SIMVER
C           23/03/2001 revised
C           05/06/2002 re-set FNAME(1) and FNAME(2) if ABORT = .TRUE.
C           15/12/2002 completely new version calling EDFLXX
C           25/03/2008 edited for version 6
C           17/03/2018 added call to EDFL18 to add a parameter limits section 
C
      IMPLICIT   NONE
      INTEGER    ISEND, ITYPE, NIN, NOUT
      PARAMETER (ISEND = 1, ITYPE = 1, NIN = 3, NOUT = 4)
      DOUBLE PRECISION XVER, YVER
      CHARACTER  FNAME(2)*1024, TITLE*100
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_editfl.exe')
      CHARACTER  PNAME*6
      PARAMETER (PNAME = 'EDITFL')
      LOGICAL    ABORT, ACTION, SHOW
C
C Externals
C
      EXTERNAL ADVISE
      EXTERNAL STOPGO, EDFLXX
      EXTERNAL DLLCHK, WINDOW, SIMVER
C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
C
      CALL SIMVER (XVER, YVER,
     +             DVER)
C
C Uncomment the next lines to overwrite the effect of SIMVER
C =========
C
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER, 
     +             DVER, PVER, 
     +             ABORT, SHOW)
C
C Checking is completed so now proceed to the main program
C======================================================================
C

C
C Initialise
C
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL ADVISE (DVER,
     +             ABORT)
      DO WHILE (.NOT.ABORT)
C
C Calll editing code in the simfit dll
C        
         CALL EDFLXX (ITYPE, NIN, NOUT,
     +                FNAME)
C
C Ask if another run is required
C     
         CALL STOPGO (FNAME(1), FNAME(2), PNAME,
     +                ABORT)
      ENDDO

C
C======================================================================
C The program is finished so we can close down the background window
C
      ACTION = .FALSE.
      CALL WINDOW (ISEND, 
     +             TITLE,
     +             ACTION)
      END
C
C======================================================================
C

C
C----------------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 7, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_EDITFL
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (HEADER,100) DVER
         ISEND = 1
         CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                HEADER, OPTION)
         IF (ISEND.EQ.1) THEN
            CALL HELP_EDITFL ('editfl')
            REPEET = .TRUE.
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
        ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `EDITFL'
     +/'        `      '
     +/'Action  `Takes in a curve-fit type file with x,y and s to'
     +/'        `edit, rearrange, scale, transform or weight.'
     +/'        `Also creates files for plots with error bars.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
