C
C*******************************************
C EDITMT.FOR: Contains the following code:
C MODULE = MODULE_EDITMT
C MAIN = EDITMT, and subroutine
C ADVISE
C*******************************************
C This module is for the matrix manipulation routine SUB09                  
C
      MODULE MODULE_EDITMT
         IMPLICIT NONE
         INTEGER  NCMAX1, NCOL1, NRMAX1, NROW1
         INTEGER  NCSAV1, NRSAV1
         DOUBLE PRECISION, ALLOCATABLE :: A1(:,:), B1(:,:), C1(:,:),
     +                                    V1(:), W1(:)
      END MODULE MODULE_EDITMT
C
C********************************************
C
C     INCLUDE 'editmt1.for'
C     INCLUDE 'editmt2.for'
C     INCLUDE 'editmt3.for'
C     INCLUDE 'c:\simfit5\work\dllchk.for'
      PROGRAM MAIN
C
C VERSION : set by SIMVER/DLLCHK
C FORTRAN : Double precision ... minimum memory requirement
C INPUT   : File with TITLE, NROW, NCOL, NTEXT, TEXT
C OUTPUT  : New file after editing ready for statistics etc.
C AUTHOR  : W. G. Bardsley, 24/09/1990
C           16/11/1990 MATTIN, VECCIN
C           25/11/1990 MATOUT
C           24/04/1991 Option to omit TITLE etc.
C           29/07/1992 ENDALL, CHECKT, GETNUM, GETCHR
C           12/08/1992 VECTRN
C           23/02/1993 GET???, PUT??? and compressed
C           27/09/1994 DBOS version ...
C           17/02/1995 Version for Salamanca
C           10/02/1997 Win32 version
C           07/08/1998 added dllchk
C           03/10/1998 FTN95 version
C           14/12/1998 replaced TUTORS by TUTOR1
C           12/08/1999 new version of DSPLAY
C           13/09/1999 added call to WINDOW
C           12/02/2000 added call to SIMVER
C           23/03/2001 revised
C           26/11/2001 revised and increased NBIG to 1000
C           05/06/2002 re-set FNAME(1) and FNAME(2) = BLANK if ABORT = .TRUE.
C           18/12/2002 replaced TRIM80*80 etc by TRIM60*60 etc
C           12/02/2005 moved help to DLL and added CHECKF
C           27/07/2005 added DVER to argument list for ADVISE
C           01/06/2006 made NSIGF a parameter, now overwrites TITLE and PHRASE
C           19/06/2006 introduced MODULE_EDITMT and allocatable arrays
C           25/03/2008 edited for version 6
C
      USE MODULE_EDITMT
      IMPLICIT   NONE
C
C Allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:), VCSAV(:), VRSAV(:)
      DOUBLE PRECISION, ALLOCATABLE :: B(:,:), U(:), V(:), W(:)
      ChARACTER (LEN = 80), ALLOCATABLE :: PHRASE(:)
C
C Nonallocatable variables
C
      INTEGER    NIN, NUNIT1, NUNIT2
      PARAMETER (NIN = 3, NUNIT1 = 11, NUNIT2 = 12)
      INTEGER    ICOLOR, IXL, IYL
      PARAMETER (ICOLOR = 4, IXL = 4, IYL = 4)
      INTEGER    I, IERR, IOS, ISEND, J, NCMAX, NRMAX
      INTEGER    NCOL, NCSAV, NLINES, NROW, NRSAV
      INTEGER    NCOL_1, NROW_1, NLINES_1
      INTEGER    NBIG
      DOUBLE PRECISION XVER, YVER
      CHARACTER  FNAME(2)*1024, TEXT(30)*100, TITLE*80
      CHARACTER  SIM256*1024
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_editmt.exe')
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  PNAME*6
      PARAMETER (PNAME = 'EDITMT')
      LOGICAL    ABORT, ACTION, APPLY, INNER, OUTER, SHOW
      INTRINSIC  MAX
      EXTERNAL   STOPGO, YESNO2, MAT2IN
      EXTERNAL   ADVISE, SUBAA, SUB00, SUB01, SUB02, SUB03, SUB04,
     +           SUB05, SUB06, SUB07, SUB08, SUB09, SUB10, SUB11
      EXTERNAL   DLLCHK, WINDOW, SIMVER, SIM256, PUTERR, PUTADV

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
C Note: ISEND = 4 in case called from SIMSTAT which will already have
C       called WINDOW with ISEND = 1
C
      ISEND = 4
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)

C
C Checking completed so now proceed to the main program
C =====================================================
C

      INNER = .TRUE.
      OUTER = .TRUE.
      CALL ADVISE (DVER,
     +             ABORT)
      IF (ABORT) THEN
C
C Exit
C        
         OUTER = .FALSE.
      ELSE
C
C Initialise 
C        
         NCOL = 3
         NROW = 4
         FNAME(1) = SIM256('editmt.tf1')
         FNAME(2) = BLANK
         TITLE = 'SIMFIT test file for EDITMT'
      ENDIF

C
C *******************
C Start of outer loop
C *******************
C

      DO WHILE (OUTER)

C
C Deallocate all workspaces
C
         IERR = 0
         
         IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
         CALL PUTERR (IERR, 'D')  
         IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
         CALL PUTERR (IERR, 'D')  
         IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
         CALL PUTERR (IERR, 'D')  
         IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
         CALL PUTERR (IERR, 'D')  
         IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
         CALL PUTERR (IERR, 'D')  
         IF (ALLOCATED(VCSAV)) DEALLOCATE(VCSAV, STAT = IERR)
         CALL PUTERR (IERR, 'D')  
         IF (ALLOCATED(VRSAV)) DEALLOCATE(VRSAV, STAT = IERR)
         CALL PUTERR (IERR, 'D')  
         IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
         CALL PUTERR (IERR, 'D')  
         IF (ALLOCATED(B1)) DEALLOCATE(B1, STAT = IERR)
         CALL PUTERR (IERR, 'D')  
         IF (ALLOCATED(C1)) DEALLOCATE(C1, STAT = IERR)
         CALL PUTERR (IERR, 'D')  
         IF (ALLOCATED(V1)) DEALLOCATE(V1, STAT = IERR)
         CALL PUTERR (IERR, 'D')  
         IF (ALLOCATED(W1)) DEALLOCATE(W1, STAT = IERR)
         CALL PUTERR (IERR, 'D') 
         
         IF (IERR.NE.0) EXIT 

C
C Get a matrix type file and an output file
C

         CALL SUBAA (NCMAX, NCOL, NCSAV, NLINES, NRMAX, NROW,
     +               NRSAV,
     +               FNAME, TITLE,
     +               ABORT)

         IF (ABORT) THEN
C
C Failure to declare files so terminate
C
            FNAME(1) = BLANK
            FNAME(2) = BLANK
            INNER = .FALSE.
            OUTER = .FALSE.
         ELSE
C
C Success so allocate space and read in the starting matrix A
C Note: on successful exit from SUBAA the following arguments are set
C       NCMAX = NCOL = no. of columns
C       NCSAV = -1
C       NLINES = no. of trailing lines (after the counter integer )
C       NRMAX = NROW = no. of rows
C       NRSAV = -1
C       FNAME(1) = Input file  
C       FNAME(2) = Output file
C       TITLE = Input file title
C       ABORT = .FALSE.
C
            IERR = 0
            
            IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
            CALL PUTERR (IERR, 'D')  
            IF (IERR.EQ.0) ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
            IF (IERR.EQ.0) THEN  
               CALL MAT2IN (NIN, NCMAX, NCOL, NRMAX, NROW,
     +                      A,
     +                      FNAME(1), TITLE,
     +                      ABORT)
            ELSE
               CALL PUTERR (IERR, 'A')
               ABORT = .TRUE.
            ENDIF   
            IF (ABORT) THEN
               INNER = .FALSE.
            ELSE
               INNER = .TRUE.
            ENDIF
         ENDIF

C
C *******************
C Start of inner loop
C ********************
C

         DO WHILE (INNER)

            IERR = 0

C
C Select an option: ONLY ISEND and TEXT are changed by SUB00
C
            CALL SUB00 (ISEND, NCOL, NCSAV, NROW, NRSAV,
     +                  FNAME, TEXT)
     
            IF (ISEND.EQ.1) THEN
C
C ISEND = 1: edit/transform ... only A and TITLE are changed by SUB01
C ==========
C
               CALL SUB01 (NCMAX, NCOL, NRMAX, NROW,
     +                     A,
     +                     TITLE)
     
            ELSEIF (ISEND.EQ.2) THEN
            
C
C ISEND = 2: rows ... insert but increase NRMAX if necessary
C ==========          Only NROW, A, and V are changed by SUB02
C
               IERR = 0
               
               IF (NROW.GE.NRMAX) THEN
                  IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
                  CALL PUTERR (IERR, 'D')
                  IF (IERR.EQ.0) THEN  
                     ALLOCATE(B(NROW,NCOL), STAT = IERR)
                     CALL PUTERR (IERR, 'A')
                  ENDIF
                  IF (IERR.NE.0) EXIT
                  DO J = 1, NCOL
                     DO I = 1, NROW
                        B(I,J) = A(I,J)
                     ENDDO
                  ENDDO
                  IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
                  CALL PUTERR (IERR, 'D')  
                  NRMAX = NRMAX + 1
                  IF (IERR.EQ.0) THEN
                     ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
                     CALL PUTERR (IERR, 'A')
                  ENDIF
                  IF (IERR.NE.0) EXIT
                  DO J = 1, NCOL
                     DO I = 1, NROW
                       A(I,J) = B(I,J)
                     ENDDO
                  ENDDO
                  DEALLOCATE(B, STAT = IERR)
                  CALL PUTERR (IERR, 'D')
                  IF (ALLOCATED(VCSAV)) DEALLOCATE(VCSAV, STAT = IERR)
                  CALL PUTERR (IERR, 'D')
               ENDIF

               IF (IERR.EQ.0) THEN
                  IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
                  CALL PUTERR (IERR, 'D')  
                  IF (IERR.EQ.0) THEN
                     ALLOCATE(V(NCOL), STAT = IERR)
                     CALL PUTERR (IERR, 'A')
                  ENDIF   
                  IF (.NOT.ALLOCATED(VRSAV)) THEN
                     NRSAV = 0
                     ALLOCATE(VRSAV(NCMAX), STAT = IERR)
                     CALL PUTERR (IERR, 'A')
                  ENDIF
               ENDIF   
               
               IF (IERR.EQ.0) CALL SUB02 (NCMAX, NCOL, NRMAX, NROW,
     +                                    NRSAV,
     +                                    A, V, VRSAV)
     
               IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
               CALL PUTERR (IERR, 'D')
               
            ELSEIF (ISEND.EQ.3) THEN
            
C
C ISEND = 3: rows ... delete
C ==========          Only NROW, A, and VRSAV are changed by SUB03
C

               IERR = 0
               
               IF (.NOT.ALLOCATED(VRSAV)) THEN
                  NRSAV = 0
                  ALLOCATE(VRSAV(NCMAX), STAT = IERR)
                  CALL PUTERR (IERR, 'A')
               ENDIF
               
               IF (IERR.EQ.0) CALL SUB03 (NCMAX, NCOL, NRMAX, NROW,
     +                                    NRSAV,
     +                                    A, VRSAV)
     
            ELSEIF (ISEND.EQ.4) THEN
            
C
C ISEND = 4: rows ... interchange
C ==========          Only A, U, V, and W are changed by SUB04
C

               IERR = 0
               
               IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               ALLOCATE(U(NCOL), STAT = IERR)
               CALL PUTERR (IERR, 'A')  
               ALLOCATE(V(NCOL), STAT = IERR)
               CALL PUTERR (IERR, 'A')  
               ALLOCATE(W(NCOL), STAT = IERR)
               CALL PUTERR (IERR, 'A')
               
               IF (IERR.EQ.0) CALL SUB04 (NCMAX, NCOL, NRMAX, NROW,
     +                                    A, U, V, W)
     
               DEALLOCATE(U, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               DEALLOCATE(V, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               DEALLOCATE(W, STAT = IERR)
               CALL PUTERR (IERR, 'D')
               
            ELSEIF (ISEND.EQ.5) THEN
            
C
C ISEND = 5: columns ... insert but increase NCMAX if necessary
C ==========             Only NCOL, A, and V are changed by SUB05 
C
 
                IERR = 0
                
                IF (NCOL.GE.NCMAX) THEN
                  IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
                  CALL PUTERR (IERR, 'D')  
                  IF (IERR.EQ.0) THEN
                     ALLOCATE(B(NROW,NCOL), STAT = IERR)
                     CALL PUTERR (IERR, 'A')
                  ENDIF
                  IF (IERR.NE.0) EXIT
                  DO J = 1, NCOL
                     DO I = 1, NROW
                        B(I,J) = A(I,J)
                     ENDDO
                  ENDDO
                  IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
                  CALL PUTERR (IERR, 'D')  
                  NCMAX = NCMAX + 1
                  IF (IERR.EQ.0) THEN
                     ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
                     CALL PUTERR (IERR, 'A')
                  ENDIF
                  IF (IERR.NE.0) EXIT
                  DO J = 1, NCOL
                     DO I = 1, NROW
                       A(I,J) = B(I,J)
                     ENDDO
                  ENDDO
                  DEALLOCATE(B, STAT = IERR)
                  CALL PUTERR (IERR, 'D')
                  IF (ALLOCATED(VCSAV)) DEALLOCATE(VCSAV, STAT = IERR)
                  CALL PUTERR (IERR, 'D')
               ENDIF

               IF (IERR.EQ.0) THEN
                  IF (.NOT.ALLOCATED(VCSAV)) THEN
                     NCSAV = 0
                     ALLOCATE(VCSAV(NRMAX), STAT = IERR)
                     CALL PUTERR (IERR, 'A')
                  ENDIF
                  IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
                  CALL PUTERR (IERR, 'D') 
                  IF (IERR.EQ.0) THEN 
                     ALLOCATE(V(NROW), STAT = IERR)
                     CALL PUTERR (IERR, 'A')
                  ENDIF
               
                  IF (IERR.EQ.0) CALL SUB05 (NCMAX, NCOL, NCSAV, NRMAX,
     +                                       NROW,
     +                                       A, V, VCSAV)
     
               ENDIF
               IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
               CALL PUTERR (IERR, 'D')
               
            ELSEIF (ISEND.EQ.6) THEN
            
C
C ISEND = 6: columns ... delete
C ==========             Only NCOL, NCSAV, A, and VCSAV are changed by SUB06
C

               IERR = 0
               
               IF (.NOT.ALLOCATED(VCSAV)) THEN
                  NCSAV = 0
                  ALLOCATE(VCSAV(NRMAX), STAT = IERR)
                  CALL PUTERR (IERR, 'A')
               ENDIF
               
               IF (IERR.EQ.0) CALL SUB06 (NCMAX, NCOL, NCSAV, NRMAX,
     +                                    NROW,
     +                                    A, VCSAV)
     
            ELSEIF (ISEND.EQ.7) THEN
            
C
C ISEND = 7: columns ... interchange
C ==========             Only A, U, V, and W are changed by SUB07
C

               IERR = 0
               
               IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
               ALLOCATE(U(NROW), STAT = IERR)
               CALL PUTERR (IERR, 'A')  
               ALLOCATE(V(NROW), STAT = IERR)
               CALL PUTERR (IERR, 'A')  
               ALLOCATE(W(NROW), STAT = IERR)
               CALL PUTERR (IERR, 'A')
               
               IF (IERR.EQ.0) CALL SUB07 (NCMAX, NCOL, NRMAX, NROW,
     +                                    A, U, V, W)
     
               DEALLOCATE(U, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               DEALLOCATE(V, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               DEALLOCATE(W, STAT = IERR)
               CALL PUTERR (IERR, 'D')
               
            ELSEIF (ISEND.EQ.8) THEN
            
C
C ISEND = 8: view ... No arguments are changed by SUB08
C ==========
C

               IF (NCOL.LT.1 .OR. NCOL.GT.NCMAX .OR.
     +             NROW.LT.1 .OR. NROW.GT.NRMAX) THEN
                   CALL PUTADV (
     +'Inconsistent dimensions in call to SUB08')      
               ELSE    
                  CALL SUB08 (NCMAX, NCOL, NRMAX, NROW,
     +                        A,
     +                        TITLE)
                ENDIF
     
            ELSEIF (ISEND.EQ.9) THEN
            
C
C ISEND = 9: matrix manipulations
C ==========
C Matrix manipulations Part 1: copy current data into MODULE_EDITMT
C ----------------------------
C

               IERR = 0

               IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               IF (ALLOCATED(B1)) DEALLOCATE(B1, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               IF (ALLOCATED(C1)) DEALLOCATE(C1, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               IF (ALLOCATED(V1)) DEALLOCATE(V1, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               IF (ALLOCATED(W1)) DEALLOCATE(W1, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               NCOL1 = NCOL
               NCMAX1 = NCMAX
               NRMAX1 = NRMAX
               NROW1 = NROW
               NCSAV1 = NCSAV
               NRSAV1 = NRSAV
               ALLOCATE(A1(NRMAX1,NCMAX1), STAT = IERR)
               CALL PUTERR (IERR, 'A')
               IF (IERR.EQ.0) THEN
                  DO J = 1, NCOL
                     DO I = 1, NROW
                        A1(I,J) = A(I,J)
                     ENDDO
                  ENDDO
C
C Matrix manipulations Part 2: call subroutine SUB09
C ----------------------------
C

                  CLOSE (UNIT = NUNIT1)
                  CLOSE (UNIT = NUNIT2) 
                      
                  CALL SUB09 (NUNIT1, NUNIT2,
     +                        FNAME, TEXT,
     +                        APPLY)
     
                  CLOSE (UNIT = NUNIT1)
                  CLOSE (UNIT = NUNIT2)
     
C
C Matrix manipulations Part 3: copy data back from MODULE_EDITMT
C ----------------------------
C
                  IF (APPLY) THEN
                     NCSAV = 0
                     NRSAV = 0
                     IF (ALLOCATED(VCSAV)) DEALLOCATE(VCSAV, STAT=IERR)
                     CALL PUTERR (IERR, 'D')  
                     IF (ALLOCATED(VRSAV)) DEALLOCATE(VRSAV, STAT=IERR)
                     CALL PUTERR (IERR, 'D')  
                     DEALLOCATE(A, STAT = IERR)
                     CALL PUTERR (IERR, 'D')
                     NCOL = NCOL1
                     NROW = NROW1
                     NCMAX = NCOL 
                     NRMAX = NROW 
                     ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
                     CALL PUTERR (IERR, 'A')
                     DO J = 1, NCOL
                        DO I = 1, NROW
                           A(I,J) = A1(I,J)
                        ENDDO
                     ENDDO
                  ENDIF
                  
                  IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
                  CALL PUTERR (IERR, 'D')  
                  IF (ALLOCATED(B1)) DEALLOCATE(B1, STAT = IERR)
                  CALL PUTERR (IERR, 'D')  
                  IF (ALLOCATED(C1)) DEALLOCATE(C1, STAT = IERR)
                  CALL PUTERR (IERR, 'D')  
                  IF (ALLOCATED(V1)) DEALLOCATE(V1, STAT = IERR)
                  CALL PUTERR (IERR, 'D')  
                  IF (ALLOCATED(W1)) DEALLOCATE(W1, STAT = IERR)
                  CALL PUTERR (IERR, 'D')  
                  IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
                  CALL PUTERR (IERR, 'D')  
                  IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
                  CALL PUTERR (IERR, 'D')  
                  IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
                  CALL PUTERR (IERR, 'D')  
                  IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
                  CALL PUTERR (IERR, 'D')
               ENDIF   
               
            ELSEIF (ISEND.EQ.10) THEN
            
C
C ISEND = 10: save simfit file
C ===========
C

               IERR = 0
                
               IF (ALLOCATED(PHRASE)) DEALLOCATE(PHRASE, STAT = IERR)
               CALL PUTERR (IERR, 'D')  
               NBIG = MAX(1,NLINES) + 100
               IF (IERR.EQ.0) THEN
                  ALLOCATE(PHRASE(NBIG), STAT = IERR)
                  CALL PUTERR (IERR, 'A')
               ENDIF
               IF (IERR.EQ.0) THEN   
                  IF (NLINES.LT.1) THEN
                     NLINES = 1
                     PHRASE(1) = 'Default line'
                  ELSE
                     CLOSE (UNIT = NIN)
                     OPEN (UNIT = NIN, FILE = FNAME(1), IOSTAT = IOS)
                     READ (NIN,'(A)',IOSTAT=IOS) PHRASE(1)
                     READ (NIN,*,IOSTAT=IOS) NROW_1, NCOL_1
                     IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
                     CALL PUTERR (IERR, 'D')  
                     IF (IERR.EQ.0) THEN
                        ALLOCATE(U(NCOL_1), STAT = IERR)  
                        CALL PUTERR (IERR, 'A')
                     ENDIF   
                     DO I = 1, NROW_1
                        READ (NIN,*,IOSTAT=IOS) (U(J), J = 1, NCOL_1)
                     ENDDO
                     DEALLOCATE(U, STAT = IERR)
                     CALL PUTERR (IERR, 'D')
                     READ (NIN,*,IOSTAT=IOS) NLINES_1   
                     DO I = 1, NLINES_1
                        READ (NIN,'(A)',IOSTAT=IOS) PHRASE(I)
                     ENDDO
                     CLOSE (UNIT = NIN)
                  ENDIF
                  DO I = NLINES + 1, NBIG
                     PHRASE(I) = BLANK
                  ENDDO
               ENDIF   
               
               IF (IERR.EQ.0) CALL SUB10 (NBIG, NCMAX, NCOL, NLINES,
     +                                    NRMAX, NROW,
     +                                    A,
     +                                    FNAME(2), PHRASE, TITLE)
     
               IF (ALLOCATED(PHRASE)) DEALLOCATE(PHRASE, STAT = IERR)
               CALL PUTERR (IERR, 'D')
               INNER = .FALSE.
               
            ELSEIF (ISEND.EQ.11) THEN
            
C
C ISEND = 11: save non-simfit file
C ===========
C
               ABORT = .FALSE.
               CALL YESNO2 (ICOLOR, IXL, IYL,
     +'Such a file cannot be used again by SIMFIT ... Proceed ?', ABORT)
                IF (ABORT) THEN
                  
                  CALL SUB11 (NCMAX, NCOL, NRMAX, NROW,
     +                        A,
     +                        FNAME(2))
     
                  INNER = .FALSE.
               ENDIF
            ENDIF
C
C *****************
C End of inner loop
C *****************
C

         ENDDO

C
C Request another go
C
         CALL STOPGO (FNAME(1), FNAME(2), PNAME,
     +                ABORT)
         IF (ABORT) THEN
            OUTER = .FALSE.
            INNER = .FALSE.
         ELSE
            OUTER = .TRUE.
            INNER = .TRUE.
         ENDIF
C
C *****************
C End of outer loop
C *****************
C

      ENDDO

      IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
      IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
      IF (ALLOCATED(VCSAV)) DEALLOCATE(VCSAV, STAT = IERR)
      IF (ALLOCATED(VRSAV)) DEALLOCATE(VRSAV, STAT = IERR)
      IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
      IF (ALLOCATED(B1)) DEALLOCATE(B1, STAT = IERR)
      IF (ALLOCATED(C1)) DEALLOCATE(C1, STAT = IERR)
      IF (ALLOCATED(V1)) DEALLOCATE(V1, STAT = IERR)
      IF (ALLOCATED(W1)) DEALLOCATE(W1, STAT = IERR)

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 4
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      END

C
C-----------------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT)
C
C Advise user
C
C  DVER: (input/unchanged) version indicator
C ABORT: (output) error indicator
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER  DVER*(*)
      LOGICAL    ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 7, NUMHDR = 11, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_EDITMT
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / 1, 1, 1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (HEADER,100) DVER
         ISEND = 1
         CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                HEADER, OPTION)
         IF (ISEND.EQ.1) THEN
            CALL HELP_EDITMT ('editmt')
            REPEET = .TRUE.
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package`SIMFIT'
     +/'       `      '
     +/'Program`EDITMT'
     +/'       `      '
     +/'Action `Edit a matrix/vector type of SIMFIT file'
     +/'       `Input: Existing file with a matrix of values'
     +/'       `Output: New file with edited/transformed data'
     +/'       `      '
     +/'Version`',A
     +/'       `      '
     +/'Author `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
