C
C EDITMT1.INS: subroutines
C ROWCOL
C SUBAA
C SUB00
C
C----------------------------------------------------------------------
C
      SUBROUTINE ROWCOL (NCOL, NCSAV, NROW, NRSAV,
     +                   TEXT)
C
C Write current dimensions etc. onto internal record stored in TEXT
C
C  NCOL: (input/unchanged) current column dimension
C NCSAV: (input/unchanged) current saved column dimension
C  NROW: (input/unchanged) current row dimension
C NRSAV: (input/unchanged) curent saved row dimension
C  TEXT: (output) current details
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: NCOL, NCSAV, NROW, NRSAV
      CHARACTER (LEN = *), INTENT (OUT) :: TEXT(*)
C
C Locals
C
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER  LINE*100, TEMP(2)*100
      EXTERNAL   FORM12
      WRITE (TEMP,100)
      TEXT(1) = TEMP(1)
      TEXT(2) = TEMP(2)
      IF (NCOL.EQ.1) THEN
         IF (NROW.EQ.1) THEN
            WRITE (LINE,200)
         ELSE
            I12(1) = FORM12(NROW)
            WRITE (LINE,300) TRIM(I12(1))
         ENDIF
      ELSEIF (NROW.EQ.1) THEN
         I12(1) = FORM12(NCOL)
         WRITE (LINE,400) TRIM(I12(1))
      ELSE
         I12(1) = FORM12(NROW)
         I12(2) = FORM12(NCOL)
         WRITE (LINE,500) TRIM(I12(1)), TRIM(I12(2))
      ENDIF
      TEXT(3) = LINE
      IF (NRSAV.GT.0) THEN
         I12(1) = FORM12(NRSAV)
         WRITE (LINE,600) TRIM(I12(1))
      ELSE
         WRITE (LINE,700)
      ENDIF
      TEXT(4) = LINE
      IF (NCSAV.GT.0) THEN
         I12(1) = FORM12(NCSAV)
         WRITE (LINE,800) TRIM(I12(1))
      ELSE
         WRITE (LINE,700)
      ENDIF
      TEXT(5) = LINE 
      WRITE (TEXT(6),700)   
C
C Format statements
C      
  100 FORMAT (
     + 'Editmt data editing options'
     +/)
  200 FORMAT ('Data set is a single element')
  300 FORMAT ('Data set is a column vector v(1) to v(',A,')')
  400 FORMAT ('Data set is a row vector a(1,1) to a(1,',A,')')
  500 FORMAT ('Data set has',1X,A,1X,'rows and',1X,A,1X,'columns')
  600 FORMAT ('Last deleted row stored with',1X,A,1X,'components')
  700 FORMAT (' ')
  800 FORMAT ('Last deleted column stored with',1X,A,1X,'components')
      END
C
C---------------------------------------------------------------------
C
      SUBROUTINE SUBAA (NCMAX, NCOL, NCSAV, NLINES, NRMAX, NROW,
     +                  NRSAV,
     +                  FNAME, TITLE,
     +                  ABORT)
C
C Read in a data file and define an output file
C
C  NCMAX: (output) max. column dimension
C   NCOL: (output) current column dimension
C  NCSAV: (output) initialised saved column dimension
C NLINES: (output) number of extra text lines
C  NRMAX: (output) max. row dimension
C   NROW: (output) current row dimension
C  NRSAV: (output) initialised saved row dimension
C  FNAME: (output) the two file names if successful
C  TITLE: (output) current title
C  ABORT: (output) error indicator
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (INOUT) :: NCMAX, NCOL, NLINES,
     +                                       NRMAX, NROW
      INTEGER,             INTENT (OUT)   :: NCSAV, NRSAV
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME(2), TITLE
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Allocatable array
C  
      DOUBLE PRECISION, ALLOCATABLE :: ROWVEC(:)    
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    I, IERR, IOS, ISEND, J, NIN, NOUT, NTEMP
      CHARACTER  HEADER*80, TFILE*12, TEMP*80
      PARAMETER (HEADER = 'Input matrix file for editing',
     +           TFILE = 'editmt.tf1')
      EXTERNAL   MAT5IN, OFILES, PUTADV
C
C Part 1: open an input file and read the details
C =======
C
      TEMP = TITLE!to silence NAGfor
      TITLE = TEMP
      NCSAV = - N1
      NRSAV = - N1
      ISEND = N2
      NIN = N3
      CALL PUTADV ('Now open a file with the data to be edited')
      CLOSE (UNIT = NIN)
      CALL MAT5IN (NCOL, NIN, NROW,
     +             FNAME(1), HEADER, TFILE, TITLE,
     +             ABORT)
      CLOSE (UNIT = NIN)
      IF (ABORT) THEN
         FNAME(1) = 'None'
         NCOL = 0
         NROW = 0
         TITLE = 'None'
         RETURN
      ENDIF
C
C Define NCMAX and NRMAX
C
      NCMAX = NCOL
      NRMAX = NROW
C
C Resume reading trailer
C
      ABORT = .TRUE.
      OPEN (UNIT = NIN, FILE = FNAME(1), IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF   
      READ (NIN,'(A)',IOSTAT=IOS) TITLE
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF   
      READ (NIN,*,IOSTAT=IOS) NROW, NCOL
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF   
      IERR = N0
      IF (ALLOCATED(ROWVEC)) DEALLOCATE(ROWVEC, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(ROWVEC(NCOL), STAT = IERR)
      IF (IERR.NE.N0) RETURN    
      DO I = N1, NROW 
         READ (NIN,*,IOSTAT=IOS) (ROWVEC(J), J = N1, NCOL)
         IF (IOS.NE.N0) THEN
            CLOSE (UNIT = NIN)
            RETURN
         ENDIF   
      ENDDO
      DEALLOCATE(ROWVEC, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      READ (NIN,*,IOSTAT=IOS) NLINES
      IF (IOS.NE.N0 .OR. NLINES.LT.1) THEN
         NLINES = N0
         IOS = -1
      ENDIF
      IF (IOS.EQ.N0) THEN
         NTEMP = NLINES
         NLINES = N0
         DO I = N1, NTEMP
            READ (NIN,'(A)',IOSTAT=IOS) TEMP
            IF (IOS.NE.N0) EXIT
            NLINES = NLINES + N1
         ENDDO
      ENDIF
      CLOSE (UNIT = NIN)
C
C Part 2: open an output file for the edited matrix
C =======
C
      CALL PUTADV (
     +'Now specify a file to receive the data after editing')
      ISEND = N1
      NOUT = N4
      CLOSE (UNIT = NOUT)
      CALL OFILES (ISEND, NOUT,
     +             FNAME(2),
     +             ABORT)
      IF (ABORT) FNAME(2) = 'None'
      CLOSE (UNIT = NOUT)
      END

C
C--------------------------------------------------------------
C
      SUBROUTINE SUB00 (ISEND, NCOL, NCSAV, NROW, NRSAV,
     +                  FNAME, TEXT)
C
C Choose option
C
C ISEND is returned as the option selected
C TEXT is returned with the current details from ROWCOL
C Other arguments are (input/unchanged)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (OUT) :: ISEND
      INTEGER,             INTENT (IN)  :: NCOL, NCSAV, NROW, NRSAV
      CHARACTER (LEN = *), INTENT (IN)  :: FNAME(2)
      CHARACTER (LEN = *), INTENT (OUT) :: TEXT(*)
C
C Locals
C
      INTEGER    I
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 11,
     +           NSTART = 7, NTEXT = 21)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      CHARACTER  TEMP(30)*100, TRIM60*60
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   ROWCOL
      EXTERNAL   LBOX01, TRIM60
      DATA NUMBLD / NTEXT*0 /
      DATA NUMPOS / NUMOPT*1 /
      CALL ROWCOL (NCOL, NCSAV, NROW, NRSAV,
     +             TEXT)
      WRITE (TEMP,100)
      DO I = 1, 15
         TEXT(I + 6) = TEMP(I)
      ENDDO
      TEXT(19) = TRIM60(FNAME(1))
      TEXT(21) = TRIM60(FNAME(2))
      NUMBLD(1) = 1
      NUMBLD(2) = 1
      NUMBLD(3) = 1
      NUMBLD(19) = 1
      NUMBLD(21) = 1
      ISEND = 8
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, ISEND, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
C
C Format statement
C     
  100 FORMAT (
     + 'Edit/transform'
     +/'Rows: Insert new/previously-deleted'
     +/'Rows: Delete then store'
     +/'Rows: Interchange or transform'
     +/'Columns: Insert new/previously-deleted'
     +/'Columns: Delete then store'
     +/'Columns: Interchange or transform'
     +/'Current matrix: View'
     +/'Current matrix: manipulations'
     +/'Exit/Save: file + header and trailer'
     +/'Exit/Save: file - header and trailer'
     +/'Input file:'
     +/
     +/'Output file:'
     +/)
      END
C
C
