C
C EDITMT2.INS: contains subroutines
C SUB01
C SUB02
C SUB03
C SUB04
C SUB05
C SUB06
C SUB07
C SUB08
C
      SUBROUTINE SUB01 (NCMAX, NCOL, NRMAX, NROW,
     +                  A,
     +                  FILES)
C
C Alter an element/row/column of the data : no change to NCOL, NROW
C 15/06/2006 changed arguments to MATTRN
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NCOL, NRMAX, NROW
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FILES
C
C Locals
C
      INTEGER    ISEND
      PARAMETER (ISEND = 4)
      EXTERNAL MATTRN
      CALL MATTRN (ISEND, NCOL, NRMAX, NROW,
     +             A,
     +             FILES)
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE SUB02 (NCMAX, NCOL, NRMAX, NROW, NRSAV,
     +                  A, V, VRSAV)
C
C Insert a new row of data: NROW increases, no change to NCOL
C 15/06/2006 edited
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NCMAX, NCOL, NRMAX, NRSAV
      INTEGER,          INTENT (INOUT) :: NROW
      DOUBLE PRECISION, INTENT (IN)    :: VRSAV(NCOL)
      DOUBLE PRECISION, INTENT (INOUT) :: A(NRMAX,NCMAX), V(NCOL)
C
C Locals
C
      INTEGER    N0, N1, N10
      PARAMETER (N0 = 0, N1 = 1, N10 = 10)
      INTEGER    I, J, K, L, LNEW, NRP1
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4)
      DOUBLE PRECISION CONST
      CHARACTER  CHAR1*80, CHAR2*80
      LOGICAL    ABORT, DONE, FIXNPT, LABEL, YES
      EXTERNAL   PUTADV, GETJM1, WPARAM, VEC1IN, YESNO2
      IF (NROW.GE.NRMAX) THEN
         CALL PUTADV ('Too many rows to insert')
         RETURN
      ENDIF
      DONE = .FALSE.
      NRP1 = NROW + N1
      IF (NCOL.EQ.N1) THEN
         LNEW = N0
         CALL GETJM1 (N0, LNEW, NRP1,
     +'Number for the new component (0 = Cancel)')
         IF (LNEW.EQ.N0) RETURN
      ELSE
         LNEW = N0
         CALL GETJM1 (N0, LNEW, NRP1,
     +'Row number for the new row (0 = Cancel)')
         IF (LNEW.EQ.N0) RETURN
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +'Set the new row vector to a chosen fixed value ?',
     +                YES)
         IF (YES) THEN
            CALL WPARAM (CONST)
            DO I = N1, NCOL
               V(I) = CONST
            ENDDO
            DONE = .TRUE.
         ENDIF
      ENDIF
      IF (NCOL.EQ.NRSAV .AND. .NOT.DONE) THEN
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +'Insert the last deleted row in this position ?',
     +                YES)
         IF (YES) THEN
            DO I = N1, NRSAV
               V(I) = VRSAV(I)
            ENDDO
            DONE = .TRUE.
         ENDIF
      ENDIF
      IF (.NOT.DONE) THEN
         IF (NCOL.EQ.N1) THEN
            CALL WPARAM (V(1))
         ELSE
            I = - N1
            J = N10
            K = NCOL
            L = NCOL
            FIXNPT = .TRUE.
            LABEL = .FALSE.
            CALL VEC1IN (I, J, K, L,
     +                   V,
     +                   CHAR1, CHAR2,
     +                   ABORT, FIXNPT, LABEL)
            CLOSE (UNIT = J)
            IF (ABORT) RETURN
         ENDIF
      ENDIF
      DO I = NROW, LNEW, - N1
         J = I + N1
         DO K = N1, NCOL
            A(J,K) = A(I,K)
         ENDDO
      ENDDO
      DO I = N1, NCOL
         A(LNEW,I) = V(I)
      ENDDO
      IF (LNEW.LE.NROW) THEN
         CALL PUTADV ('Rows have been re-numbered')
      ENDIF
      NROW = NROW + N1
      END
C
C--------------------------------------------------------
C
      SUBROUTINE SUB03 (NCMAX, NCOL, NRMAX, NROW, NRSAV,
     +                  A, VRSAV)
C
C Delete a row of data: NROW decreases, no change to NCOL
C 15/06/2006 edited
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NCMAX, NCOL, NRMAX
      INTEGER,          INTENT (INOUT) :: NROW, NRSAV
      DOUBLE PRECISION, INTENT (INOUT) :: A(NRMAX,NCMAX), VRSAV(NCOL)
C
C Locals
C
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    I, J, K, NPURGE
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 4, IX = 4, IY = 4)
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER  LINE*100
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    YES
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PUTADV, GETJM1, PUTWAR, YESNO2
      INTRINSIC  TRIM
      IF (NROW.EQ.1) THEN
         CALL PUTADV ('The last row cannot be deleted')
         RETURN
      ENDIF
      E_NUMBERS = E_FORMATS()
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, IX, IY,
     +'Are you sure you want to delete ?',
     +             YES)
      IF (.NOT.YES) RETURN
      NPURGE = N0
      CALL GETJM1 (N0, NPURGE, NROW,
     +'Number of the row to be deleted (0 = Cancel)')
      IF (NPURGE.EQ.N0) RETURN
      NRSAV = NCOL
      DO I = N1, NRSAV
         VRSAV(I) = A(NPURGE,I)
      ENDDO
      I12 = FORM12(NPURGE)
      IF (NCOL.EQ.N1) THEN
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) TRIM(I12), A(NPURGE,1)
         ELSE
            D13(1) = SHOWLJ(A(NPURGE,1))
            WRITE (LINE,150) TRIM(I12), D13(1)
         ENDIF  
      ELSE
         IF (E_NUMBERS) THEN
            WRITE (LINE,200) TRIM(I12), A(NPURGE,1), A(NPURGE,NCOL)
         ELSE
            D13(1) = SHOWLJ(A(NPURGE,1))
            D13(2) = SHOWLJ(A(NPURGE,NCOL)) 
            WRITE (LINE,250) TRIM(I12), TRIM(D13(1)), D13(2)
         ENDIF  
      ENDIF
      DO I = NPURGE, NROW - N1
         J = I + N1
         DO K = N1, NCOL
            A(I,K) = A(J,K)
         ENDDO
      ENDDO
      IF (NROW.EQ.N2) THEN
         CALL PUTWAR ('There is only one row left now')
      ELSEIF (NPURGE.LT.NROW) THEN
         CALL PUTWAR ('Rows have now been re-numbered')
      ENDIF
      CALL PUTADV (LINE)
      NROW = NROW - N1
C
C Format statements
C      
  100 FORMAT ('Deleted/saved: v(',A,') =',1P,E13.5)
  150 FORMAT ('Deleted/saved: v(',A,') =',1X,A)  
  200 FORMAT ('Deleted/saved: Row',1X,A,',',1P,E13.5,' to',E13.5)
  250 FORMAT ('Deleted/saved: Row',1X,A,',',1X,A,' to',1X,A)
      END
C
C------------------------------------------------------------------
C
      SUBROUTINE SUB04 (NCMAX, NCOL, NRMAX, NROW,
     +                  A, U, V, W)
C
C Interchange/calculate with 2 rows: no change to NCOL or NROW
C 15/06/2006 edited
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NCMAX, NCOL, NRMAX, NROW
      DOUBLE PRECISION, INTENT (INOUT) :: A(NRMAX,NCMAX), U(NCOL),
     +                                    V(NCOL), W(NCOL)
C
C Locals
C
      INTEGER    M0, M1
      PARAMETER (M0 = 0, M1 = 1)
      INTEGER    I, N1, N2
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER  LINE*100
      LOGICAL    ABORT
      EXTERNAL   FORM12
      EXTERNAL   PUTADV, GETJM1, NXYTRN
      INTRINSIC  TRIM
      IF (NROW.EQ.M1) THEN
         CALL PUTADV ('This option requires > 1 row')
         RETURN
      ENDIF
      N1 = M0
      CALL GETJM1 (M0, N1, NROW,
     +'Number of 1st. row to be transformed (0 = Cancel)')
      IF (N1.EQ.M0) RETURN
      N2 = M0
      CALL GETJM1 (M0, N2, NROW,
     +'Number of 2nd. row to be transformed (0 = Cancel)')
      IF (N2.EQ.M0) RETURN
      IF (N1.EQ.N2) THEN
         CALL PUTADV ('This option requires two distinct rows')
         RETURN
      ENDIF
      I12(1) = FORM12(N1)
      I12(2) = FORM12(N2) 
      IF (NCOL.EQ.M1) THEN
         WRITE (LINE,100) TRIM(I12(1)), TRIM(I12(2))
      ELSE
         WRITE (LINE,200) TRIM(I12(1)), I12(2)
      ENDIF
      CALL PUTADV (LINE)
      DO I = M1, NCOL
         V(I) = A(N1,I)
         W(I) = A(N2,I)
      ENDDO
      CALL NXYTRN (NCOL,
     +             U, V, W,
     +             ABORT)
      IF (.NOT.ABORT) THEN
         DO I = M1, NCOL
            A(N1,I) = V(I)
            A(N2,I) = W(I)
         ENDDO
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     +'In the next menu: x means v(',A,'), and y means v(',A,')')
  200 FORMAT (
     +'In the next menu: x means row',1X,A,',and y means row',1X,A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE SUB05 (NCMAX, NCOL, NCSAV, NRMAX, NROW,
     +                  A, V, VCSAV)
C
C Insert a new column of data: NCOL increases, NROW unchanged
C 15/06/2006 edited
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NCMAX, NCSAV, NRMAX, NROW
      INTEGER,          INTENT (INOUT) :: NCOL
      DOUBLE PRECISION, INTENT (IN)    :: VCSAV(NROW)
      DOUBLE PRECISION, INTENT (INOUT) :: A(NRMAX,NCMAX), V(NROW)
C
C Locals
C
      INTEGER    N0, N1, N10
      PARAMETER (N0 = 0, N1 = 1, N10 = 10)
      INTEGER    I, J, K, KNEW, L, NCP1
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4)
      DOUBLE PRECISION CONST
      CHARACTER  CHAR1*80, CHAR2*80
      LOGICAL    ABORT, DONE, FIXNPT, LABEL, YES
      EXTERNAL   PUTADV, GETJM1, WPARAM, VEC1IN, YESNO2
      IF (NCOL.EQ.NCMAX) THEN
         CALL PUTADV ('Too many columns to insert')
         RETURN
      ENDIF
      DONE = .FALSE.
      NCP1 = NCOL + N1
      KNEW = N0
      CALL GETJM1 (N0, KNEW, NCP1,
     +'Column number for the new column vector (0 = Cancel)')
      IF (KNEW.EQ.N0) RETURN
      IF (NROW.GT.N1) THEN
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +'Set new column vector equal to a fixed value ?',
     +                YES)
         IF (YES) THEN
            CALL WPARAM (CONST)
            DO I = N1, NROW
               V(I) = CONST
            ENDDO
            DONE = .TRUE.
         ENDIF
      ENDIF
      IF (NROW.EQ.NCSAV .AND. .NOT.DONE) THEN
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +'Insert the last deleted column vector here ?',
     +                YES)
         IF (YES) THEN
            DO I = N1, NROW
               V(I) = VCSAV(I)
            ENDDO
            DONE = .TRUE.
         ENDIF
      ENDIF
      IF (.NOT.DONE) THEN
         IF (NROW.EQ.1) THEN
            CALL WPARAM (V(1))
         ELSE
            I = - N1
            J = N10
            K = NROW
            L = NROW
            FIXNPT = .TRUE.
            LABEL = .FALSE.
            CALL VEC1IN (I, J, K, L,
     +                   V,
     +                   CHAR1, CHAR2,
     +                   ABORT, FIXNPT, LABEL)
            CLOSE (UNIT = J)
            IF (ABORT) RETURN
         ENDIF
      ENDIF
      DO I = NCOL, KNEW, - N1
         J = I + N1
         DO K = N1, NROW
            A(K,J) = A(K,I)
         ENDDO
      ENDDO
      DO I = N1, NROW
         A(I,KNEW) = V(I)
      ENDDO
      IF (KNEW.LE.NCOL) THEN
         CALL PUTADV ('The columns have been re-numbered')
      ENDIF
      NCOL = NCOL + N1
      END
C
C-----------------------------------------------------------------
C
      SUBROUTINE SUB06 (NCMAX, NCOL, NCSAV, NRMAX, NROW,
     +                  A, VCSAV)
C
C Delete a column of data: NCOL decreases, NROW unchanged
C 15/06/2006 edited
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NCMAX, NRMAX, NROW
      INTEGER,          INTENT (INOUT) :: NCOL, NCSAV  
      DOUBLE PRECISION, INTENT (INOUT) :: A(NRMAX,NCMAX), VCSAV(NROW)
C
C locals
C
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    I, J, K, NPURGE
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 4, IX = 4, IY = 4)
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER  LINE*100
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    YES
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PUTADV, GETJM1, PUTWAR, YESNO2
      INTRINSIC  TRIM
      IF (NCOL.EQ.N1) THEN
         CALL PUTADV ('The last column cannot be deleted')
         RETURN
      ENDIF
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, IX, IY,
     +'Are you sure you want to delete ?',
     +             YES)
      IF (.NOT.YES) RETURN
      NPURGE = N0
      CALL GETJM1 (N0, NPURGE, NCOL,
     +'Number of the column to be deleted (0 = Cancel)')
      IF (NPURGE.EQ.N0) RETURN
      NCSAV = NROW
      DO I = N1, NCSAV
         VCSAV(I) = A(I,NPURGE)
      ENDDO
      E_NUMBERS = E_FORMATS()
      I12 = FORM12(NPURGE)
      D13(1) = SHOWLJ(A(1,NPURGE))
      IF (NROW.EQ.N1) THEN
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) TRIM(I12), A(1,NPURGE)
         ELSE
            WRITE (LINE,150) TRIM(I12), D13(1)
         ENDIF  
      ELSE
         IF (E_NUMBERS) THEN
            WRITE (LINE,200) TRIM(I12), A(1,NPURGE), A(NROW,NPURGE)
         ELSE
            D13(2) = SHOWLJ(A(NROW,NPURGE)) 
            WRITE (LINE,250) TRIM(I12), TRIM(D13(1)), D13(2)
         ENDIF  
      ENDIF
      DO I = NPURGE, NCOL - N1
         J = I + N1
         DO K = N1, NROW
            A(K,I) = A(K,J)
         ENDDO
      ENDDO
      IF (NCOL.EQ.N2) THEN
         CALL PUTWAR ('There is only one column left')
      ELSEIF (NPURGE.LT.NCOL) THEN
         CALL PUTWAR ('The columns have been re-numbered')
      ENDIF
      CALL PUTADV (LINE)
      NCOL = NCOL - N1
C
C Format statements
C      
  100 FORMAT ('Deleted/saved: a(1,',I8,') =',1P,E13.5)
  150 FORMAT ('Deleted/saved: a(1,',A,') =',1X,A)  
  200 FORMAT ('Deleted/saved: Column',I8,',',1P,E13.5,' to',E13.5)
  250 FORMAT ('Deleted/saved: Column',1X,A,',',1X,A,' to',1X,A)
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE SUB07 (NCMAX, NCOL, NRMAX, NROW,
     +                  A, U, V, W)
C
C Interchange/calculate with 2 columns: NCOL and NROW unchanged
C 15/06/2006 edited
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NCMAX, NCOL, NRMAX, NROW
      DOUBLE PRECISION, INTENT (INOUT) :: A(NRMAX,NCMAX), U(NROW),
     +                                    V(NROW), W(NROW)
C
C Locals
C
      INTEGER    M0, M1
      PARAMETER (M0 = 0, M1 = 1)
      INTEGER    I, N1, N2
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER  LINE*100
      LOGICAL    ABORT
      EXTERNAL   FORM12
      EXTERNAL   PUTADV, GETJM1, NXYTRN
      IF (NCOL.EQ.M1) THEN
         CALL PUTADV ('This option requires > 1 column')
         RETURN
      ENDIF
      N1 = M0
      CALL GETJM1 (M0, N1, NCOL,
     +'Number of 1st. column to be transformed (0 = Cancel)')
      IF (N1.EQ.M0) RETURN
      N2 = M0
      CALL GETJM1 (M0, N2, NCOL,
     +'Number of 2nd. column to be transformed (0 = Cancel)')
      IF (N2.EQ.M0) RETURN
      IF (N1.EQ.N2) THEN
         CALL PUTADV ('This option requires two distinct columns')
         RETURN
      ENDIF
      I12(1) = FORM12(N1)
      I12(2) = FORM12(N2) 
      IF (NROW.EQ.M1) THEN
         WRITE (LINE,100) TRIM(I12(1)), TRIM(I12(2))
      ELSE
         WRITE (LINE,200) TRIM(I12(1)), I12(2)
      ENDIF
      CALL PUTADV (LINE)
      DO I = M1, NROW
         V(I) = A(I,N1)
         W(I) = A(I,N2)
      ENDDO
      CALL NXYTRN (NROW,
     +             U, V, W,
     +             ABORT)
      IF (.NOT.ABORT) THEN
         DO I = M1, NROW
            A(I,N1) = V(I)
            A(I,N2) = W(I)
         ENDDO
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     +'In next menu: x means a(1,',A,'), and y means a(1,',A,')')
  200 FORMAT (
     +'In next menu: x means column',1X,A,1X,',and y means column',1X,A)
      END
C
C---------------------------------------------------------------------
C
      SUBROUTINE SUB08 (NCMAX, NCOL, NRMAX, NROW,
     +                  A,
     +                  TITLE)
C
C Display
C 15/06/2006 edited
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NCMAX, NCOL, NRMAX, NROW
      DOUBLE PRECISION,    INTENT (IN) :: A(NRMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (IN) :: TITLE
C
C Locals
C
      INTEGER    NF, NTYPE
      PARAMETER (NF = -1, NTYPE = 3)
      CHARACTER  LINE*100
      LOGICAL    FILEIT
      PARAMETER (FILEIT = .FALSE.)
      EXTERNAL   DSPLAY, PUTADV
      IF (NCOL.LT.1 .OR. NCOL.GT.NCMAX .OR.
     +    NROW.LT.1 .OR. NROW.GT.NRMAX) THEN        
         WRITE (LINE,100) NCOL, NCMAX, NROW, NRMAX
         CALL PUTADV (LINE)
      ELSE 
         CALL DSPLAY (NCMAX, NCOL, NF, NRMAX, NROW, NTYPE,         
     +                A, 
     +                TITLE, FILEIT)
      ENDIF
  100 FORMAT ('In call to SUB08: NCOL, NCMAX, NROW, NRMAX =',4I6)      
      END
C
C