C
C EDITMT3.FOR: contains subroutines
C SUB09
C SUB10
C SUB11
C

C
C************************************
C The matrix manipulation subroutine
C************************************
C
      SUBROUTINE SUB09 (NUNIT1, NUNIT2, 
     +                  FNAME, TEXT,
     +                  APPLY)
C
C Matrix manipulations
C 15/06/2006 extensive revision
C
C FNAME(1): (input/unchanged) Current input data file 
C FNAME(2): (input/unchanged) Current output data file 
C     TEXT: (input/output)
C    APPLY: (output)
C
C Note: NCOL1, NROW1, and A1,  must be defined before this rouitne is called 
C
      USE MODULE_EDITMT
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NUNIT1, NUNIT2
      CHARACTER (LEN = *), INTENT (IN)    :: FNAME(2)
      CHARACTER (LEN = *), INTENT (INOUT) :: TEXT(*)
      LOGICAL,             INTENT (OUT)   :: APPLY
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N10
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N10 = 10)
      INTEGER    I, ISEND, J, K, L, LV, NDEC, NCTEMP, NC1, NC2
      INTEGER    NEWCOL, NEWROW, NFILE, NIN, NLINK, NR1, NR2
      INTEGER    IERR, NPTS, NRTEMP, NTCOL, NTROW
      INTEGER    NCMTMP, NRMTMP
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 50, IY = 4, LSHADE = 1)
      INTEGER    NUMBLD(30), NUMPOS(20)
      CHARACTER (LEN = 12) I12(2), FORM12 
      CHARACTER  CHAR1*1024, CHAR2*80, LINE*100, TITLE1*80, TEX(1)*1
      CHARACTER  TEMP(30)*100, TITLE*80
      PARAMETER (TITLE = 'Current matrix manipulation data')
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    HEADER
      PARAMETER (HEADER = .TRUE.)
      LOGICAL    ABORT, FIXCOL, FIXNPT, FIXROW, LABEL, OK, REPEET
      EXTERNAL   FORM12
      EXTERNAL   PUTADV, GETIM1, VEC2IN, VEC3IN, MATTIN, MAT2IN,
     +           MAT3IN, MATOUT, SRTVEC, PUTCAU, ROWCOL, FNAMES, LBOX01,
     +           PUTERR  
      EXTERNAL   SUB08
      DATA NUMBLD / 30*0 /
      DATA NUMPOS / 20*1 /
C
C Initialise
C      
      APPLY = .   FALSE.
      REPEET = .TRUE.
C---------------------------------------------------------------
C Start of main loop
C---------------------------------------------------------------
      DO WHILE (REPEET)
        
C
C Make sure NUNIT1 and NUNIT2 are closed
C
      CLOSE (UNIT = NUNIT1)
      CLOSE (UNIT = NUNIT2)

C
C Make sure B1, C1, V1, and w1 are deallocated 
C
      IERR = 0
      
      IF(ALLOCATED(B1)) DEALLOCATE(B1, STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'D')
         CLOSE (UNIT = NUNIT1)
         CLOSE (UNIT = NUNIT2)
         RETURN
      ENDIF
      
      IF(ALLOCATED(C1)) DEALLOCATE(C1, STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'D')
         CLOSE (UNIT = NUNIT1)
         CLOSE (UNIT = NUNIT2)
         RETURN
      ENDIF
      
      IF(ALLOCATED(V1)) DEALLOCATE(V1, STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'D')
         CLOSE (UNIT = NUNIT1)
         CLOSE (UNIT = NUNIT2)
         RETURN
      ENDIF    

      IF(ALLOCATED(W1)) DEALLOCATE(W1, STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'D')
         CLOSE (UNIT = NUNIT1)
         CLOSE (UNIT = NUNIT2)
         RETURN
      ENDIF                 

      CALL ROWCOL (NCOL1, NCSAV1, NROW1, NRSAV1,
     +             TEXT)
      WRITE (TEMP,100)
      DO I = 1, 13
         TEXT(I + 6) = TEMP(I)
      ENDDO
      NUMBLD(1) = 1
      NUMBLD(2) = 1
      NUMBLD(3) = 1
      NUMOPT = 11
      NSTART = 9
      NTEXT = NSTART + NUMOPT - N1
      NDEC = NUMOPT - N2
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NUMBLD(1) = 0
      NUMBLD(2) = 0
      NUMBLD(3) = 0

      IERR = 0
      
C
C Check for consistent decision
C
      OK = .TRUE.
      IF (NCOL1.EQ.N1) THEN
         IF (NDEC.EQ.4) THEN
C
C Cannot reflect a vector left/right
C
            CALL PUTADV ('This option is only for matrices')
            NDEC = N0
         ENDIF
      ELSE
         IF (NDEC.EQ.7 .OR. NDEC.EQ.8) THEN
C
C Cannot insert vectors or rearrange matrices
C
            CALL PUTADV ('This option is only for column vectors')
            NDEC = N0
         ENDIF
      ENDIF

      IF (NDEC.EQ.2 .OR. NDEC.EQ.7) THEN
C
C Prevent users trying to use the the output file for Open ...
C        
         OPEN (UNIT = NUNIT2, FILE = FNAME(2))
      ENDIF
      
      IF (NDEC.EQ.5) THEN
C
C Prevent users trying to use the input/output files for Save As...
C        
         OPEN (UNIT = NUNIT1, FILE = FNAME(1))
         OPEN (UNIT = NUNIT2, FILE = FNAME(2))
      ENDIF      
C
C NDEC = 1: Transpose the current matrix
C =========
C
      IF (NDEC.EQ.1) THEN
C
C Step 1: allocate B1 then copy A1^T into B1 ... Allocates B1 then reallocates A1
C
         IERR = 0
        
         ALLOCATE(B1(NCOL1,NROW1), STAT = IERR)
         IF (IERR.NE.0) THEN
            CALL PUTERR (IERR, 'A')
            CLOSE (UNIT = NUNIT1)
            CLOSE (UNIT = NUNIT2)            
            RETURN
         ENDIF   
         DO I = N1, NCOL1
            DO J = N1, NROW1
               B1(I,J) = A1(J,I)
            ENDDO
         ENDDO
C
C Step 2: re-allocate to swap dimensions of A1
C
         IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
         IF (IERR.NE.0) THEN
            CALL PUTERR (IERR, 'D')
            CLOSE (UNIT = NUNIT1)
            CLOSE (UNIT = NUNIT2)            
            RETURN
         ENDIF                
         ALLOCATE(A1(NCMAX1,NRMAX1), STAT = IERR)
         IF (IERR.NE.0) THEN
            CALL PUTERR (IERR, 'A')
            CLOSE (UNIT = NUNIT1)
            CLOSE (UNIT = NUNIT2)            
            RETURN
         ENDIF            
         NCTEMP = NCMAX1
         NRTEMP = NRMAX1
         NCMAX1 = NRTEMP
         NRMAX1 = NCTEMP
         NCTEMP = NCOL1
         NRTEMP = NROW1
         NCOL1 = NRTEMP
         NROW1 = NCTEMP
C
C Step 3: copy B1 back into A1 
C
         DO J = N1, NCOL1
            DO I = N1, NROW1
               A1(I,J) = B1(I,J)
            ENDDO
         ENDDO
         CALL PUTADV ('The matrix has been transposed')
C
C NDEC = 2: Insert a matrix
C =========
C
      ELSEIF (NDEC.EQ.2) THEN
         OK = .TRUE.
         I12(1) = FORM12(NROW1)
         I12(2) = FORM12(NCOL1)
         WRITE (TEMP,200) I12(1), I12(2)
         NUMOPT = 6
         NSTART = 11
         NTEXT = NSTART + NUMOPT - N1
         NDEC = NUMOPT
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEMP,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NDEC.EQ.1) THEN
            NCMTMP = N0
            NRMTMP = NROW1
            NRTEMP = NROW1
            FIXROW = .TRUE.
            FIXCOL = .FALSE.
         ELSEIF (NDEC.EQ.2) THEN
            NCMTMP = NCOL1
            NCTEMP = NCOL1
            NRMTMP = N0
            FIXROW = .FALSE.
            FIXCOL = .TRUE.
         ELSEIF (NDEC.GE.3 .AND. NDEC.LE.5) THEN
            FIXROW = .FALSE.
            FIXCOL = .FALSE.
         ELSE
            NDEC = N0
            OK = .FALSE.
         ENDIF

         IF (OK .AND. NDEC.GT.N0) THEN
            NIN = N10
            CLOSE (UNIT = NIN)
            IF (NDEC.LT.3) THEN
               IF (NDEC.EQ.1) THEN
                  I12(1) = FORM12(NROW1)
                  WRITE (LINE,300) 'rows', I12(1)
               ELSE
                  I12(1) = FORM12(NCOL1)
                  WRITE (LINE,300) 'columns', I12(1)
               ENDIF
               CALL PUTADV (LINE)
               ISEND = N2
               CALL MAT3IN (ISEND, NCTEMP, NIN, NRTEMP,
     +                      CHAR1, CHAR2,
     +                      ABORT, FIXCOL, FIXROW, LABEL)
               IF (ABORT) THEN
                  NDEC = N0
                  OK = .FALSE.
               ELSE
                  IF (NDEC.EQ.1) THEN
                     NCMTMP = NCTEMP
                  ELSE
                     NRMTMP = NRTEMP
                  ENDIF
                  ALLOCATE(B1(NRMTMP,NCMTMP), STAT = IERR)
                  IF (IERR.NE.0) THEN
                     CALL PUTERR (IERR, 'A')
                     CLOSE (UNIT = NUNIT1)
                     CLOSE (UNIT = NUNIT2)                     
                     RETURN
                  ENDIF                     
                  CALL MAT2IN (NIN, NCMTMP, NCTEMP, NRMTMP, NRTEMP,
     +                         B1,
     +                         CHAR1, CHAR2,
     +                         ABORT)
                  IF (ABORT) THEN
                     NDEC = N0
                     OK = .FALSE.
                  ENDIF
               ENDIF
            ELSE
               ALLOCATE(B1(NROW1,NCOL1), STAT = IERR)
               IF (IERR.NE.0) THEN
                  CALL PUTERR (IERR, 'A')
                  CLOSE (UNIT = NUNIT1)
                  CLOSE (UNIT = NUNIT2)                  
                  RETURN
               ENDIF                  
               ALLOCATE(W1(1), STAT = IERR)
               IF (IERR.NE.0) THEN
                  CALL PUTERR (IERR, 'A')
                  CLOSE (UNIT = NUNIT1)
                  CLOSE (UNIT = NUNIT2)                  
                  RETURN
               ENDIF                   
               I12(1) = FORM12(NROW1)
               I12(2) = FORM12(NCOL1)
               WRITE (LINE,400) TRIM(I12(1)), I12(2)
               CALL PUTADV (LINE)
               ISEND = N2
               CALL MATTIN (ISEND, NCOL1, NCTEMP, NIN, NROW1, NRTEMP,
     +                      B1, W1,
     +                      CHAR1, CHAR2,
     +                      ABORT, FIXCOL, FIXROW, LABEL)
               CLOSE (UNIT = NIN)
               CLOSE (NUNIT2)
               IF (ABORT) THEN
                  NDEC = N0
                  OK = .FALSE.
               ENDIF
            ENDIF
            IF (NDEC.EQ.1) THEN
               NTCOL = NCOL1 + NCTEMP
               NTROW = NROW1
               CALL GETIM1 (N1, NEWCOL, NCOL1 + 1,
     +'Column number where new data is to start')
            ELSEIF (NDEC.EQ.2) THEN
               NTCOL = NCOL1
               NTROW = NROW1 + NRTEMP
               CALL GETIM1 (N1, NEWROW, NROW1 + 1,
     +'Row number where new data is to start')
            ELSEIF (NDEC.GE.3 .AND. NDEC.LE.5) THEN
               NTCOL = NCOL1
               NTROW = NROW1
               IF (NCTEMP.GT.NCOL1) THEN
                  CALL PUTADV ('Matrix too wide to insert/over-write')
                  NDEC = N0
                  OK = .FALSE.
               ELSEIF (NCTEMP.EQ.NCOL1) THEN
                  NEWCOL = N1
               ELSE   
                  I = NCOL1 - NCTEMP + 1
                  CALL GETIM1 (N1, NEWCOL, I,
     +'Column number where new data is to start')
               ENDIF
               IF (NRTEMP.GT.NROW1) THEN
                  CALL PUTADV ('Matrix too long to insert/over-write')
                  NDEC = N0
                  OK = .FALSE.
               ELSEIF (NRTEMP.EQ.NROW1) THEN
                  NEWROW = N1
               ELSE   
                  I = NROW1 - NRTEMP + 1
                  CALL GETIM1 (N1, NEWROW, I,
     +'Row number where new data is to start')
               ENDIF
            ENDIF
            IF (OK .AND. NDEC.GE.1 .AND. NDEC.LE.2) THEN
               ALLOCATE (C1(NRMAX1,NCMAX1), STAT = IERR)
               IF (IERR.NE.0) THEN
                  CALL PUTERR (IERR, 'A')
                  CLOSE (UNIT = NUNIT1)
                  CLOSE (UNIT = NUNIT2)                  
                  RETURN
               ENDIF  
               DO J = 1, NCOL1
                  DO I = 1, NROW1
                     C1(I,J) = A1(I,J)
                  ENDDO
               ENDDO
               DEALLOCATE(A1, STAT = IERR)
               IF (IERR.NE.0) THEN
                  CALL PUTERR (IERR, 'D')
                  CLOSE (UNIT = NUNIT1)
                  CLOSE (UNIT = NUNIT2)                  
                  RETURN
               ENDIF                           
               IF (NDEC.EQ.1) THEN
                   NCMAX1 = NCOL1 + NCMTMP 
               ELSE
                   NRMAX1 = NROW1 + NRMTMP 
               ENDIF
               ALLOCATE(A1(NRMAX1,NCMAX1), STAT = IERR)
               IF (IERR.NE.0) THEN
                  CALL PUTERR (IERR, 'A')
                  CLOSE (UNIT = NUNIT1)
                  CLOSE (UNIT = NUNIT2)                  
                  RETURN
               ENDIF                       
               DO J = 1, NCOL1
                  DO I = 1, NROW1
                     A1(I,J) = C1(I,J)
                  ENDDO
               ENDDO
            ENDIF
            IF (NDEC.EQ.1) THEN
               DO I = NCOL1, NEWCOL, - 1
                  J = I + NCTEMP
                  DO K = 1, NROW1
                     A1(K,J) = A1(K,I)
                  ENDDO
               ENDDO
               DO I = NEWCOL, NEWCOL + NCTEMP - 1
                  J = I - NEWCOL + 1
                  DO K = 1, NROW1
                     A1(K,I) = B1(K,J)
                  ENDDO
               ENDDO
            ELSEIF (NDEC.EQ.2) THEN
               DO I = NROW1, NEWROW, - 1
                  J = I + NRTEMP
                  DO K = 1, NCOL1
                     A1(J,K) = A1(I,K)
                  ENDDO
               ENDDO
               DO I = NEWROW, NEWROW + NRTEMP - 1
                  J = I - NEWROW + 1
                  DO K = 1, NCOL1
                     A1(I,K) = B1(J,K)
                  ENDDO
               ENDDO
            ELSEIF (NDEC.EQ.3) THEN
               J = NEWCOL - 1
               DO I = 1, NCTEMP
                   J = J + 1
                   K = NEWROW - 1
                   DO L = 1, NRTEMP
                      K = K + 1
                      A1(K,J) = B1(L,I)
                   ENDDO
               ENDDO
            ELSEIF (NDEC.EQ.4) THEN
               J = NEWCOL - 1
               DO I = 1, NCTEMP
                   J = J + 1
                   K = NEWROW - 1
                   DO L = 1, NRTEMP
                      K = K + 1
                      A1(K,J) = A1(K,J) + B1(L,I)
                   ENDDO
               ENDDO
            ELSEIF (NDEC.EQ.5) THEN
               J = NEWCOL - 1
               DO I = 1, NCTEMP
                   J = J + 1
                   K = NEWROW - 1
                   DO L = 1, NRTEMP
                      K = K + 1
                      A1(K,J) = A1(K,J) - B1(L,I)
                   ENDDO
               ENDDO               
            ENDIF
              
            IF (OK) THEN
               NROW1 = NTROW
               NCOL1 = NTCOL
               CALL PUTADV ('The matrix has been changed')
            ENDIF
         ENDIF
C
C NDEC = 3: Reflect top to bottom
C =========
C
      ELSEIF (NDEC.EQ.3) THEN
         IF (NROW1.EQ.1) THEN
            CALL PUTADV ('Impossible')
         ELSE
            ALLOCATE(B1(NRMAX1,NCMAX1), STAT = IERR)
            IF (IERR.NE.0) THEN
               CALL PUTERR (IERR, 'A')
               CLOSE (UNIT = NUNIT1)
               CLOSE (UNIT = NUNIT2)               
               RETURN
            ENDIF                    
            DO I = 1, NCOL1
               J = NROW1 + 1
               DO K = 1, NROW1
                  J = J - 1
                  B1(K,I) = A1(J,I)
               ENDDO
            ENDDO
            DO I = 1, NCOL1
               DO J = 1, NROW1
                  A1(J,I) = B1(J,I)
               ENDDO
            ENDDO
            CALL PUTADV ('The matrix has been turned upside down')
         ENDIF
C
C NDEC = 4: reflect left to right
C =========
C
      ELSEIF (NDEC.EQ.4) THEN
         IF (NCOL1.EQ.1) THEN
            CALL PUTADV ('Impossible')
         ELSE
            ALLOCATE(B1(NRMAX1,NCMAX1), STAT = IERR)
            IF (IERR.NE.0) THEN
               CALL PUTERR (IERR, 'A')
               CLOSE (UNIT = NUNIT1)
               CLOSE (UNIT = NUNIT2)                
               RETURN
            ENDIF                    
            J = NCOL1 + 1
            DO I = 1, NCOL1
                  J = J - 1
               DO K = 1, NROW1
                  B1(K,I) = A1(K,J)
               ENDDO
            ENDDO
            DO I = 1, NCOL1
               DO J = 1, NROW1
                  A1(J,I) = B1(J,I)
               ENDDO
            ENDDO
            CALL PUTADV ('The matrix has been turned left to right')
         ENDIF
C
C NDEC = 5: Write a sub-matrix to a file
C =========
C
      ELSEIF (NDEC.EQ.5) THEN
         ALLOCATE(B1(NRMAX1,NCMAX1), STAT = IERR)
         IF (IERR.NE.0) THEN
            CALL PUTERR (IERR, 'A')
            CLOSE (UNIT = NUNIT1)
            CLOSE (UNIT = NUNIT2)             
            RETURN
         ENDIF                 
         CALL GETIM1 ( N1, NR1, NROW1, 'Starting row number required')
         CALL GETIM1 (NR1, NR2, NROW1, 'Stopping row number required')
         CALL GETIM1 ( N1, NC1, NCOL1,
     +'Starting column number required')
         CALL GETIM1 (NC1, NC2, NCOL1, 
     +'Stopping column number required')
         NEWCOL = NC2 - NC1 + 1
         NEWROW = NR2 - NR1 + 1
         J = NC1 - 1
         DO I = 1, NEWCOL
            J = J + 1
            K = NR1 - 1
            DO L = 1, NEWROW
               K = K + 1
               B1(L,I) = A1(K,J)
            ENDDO
         ENDDO
         ISEND = N1
         NFILE = N10
         TEX(1) = ' '   
         TITLE1 = 'Sub-matrix'
         CALL MATOUT (ISEND, NEWCOL, NFILE, NRMAX1, NEWROW, N1,
     +                B1,
     +                CHAR1, TEX, TITLE1,
     +                ABORT, HEADER, HEADER, HEADER)
         CLOSE (UNIT = NFILE)
         IF (.NOT.ABORT) THEN
            ISEND = 2
            CALL FNAMES (ISEND,
     +                   CHAR1)
         ENDIF
C
C NDEC = 6: Change sign of row, column, or all matrix
C =========
C
      ELSEIF (NDEC.EQ.6) THEN
         OK = .TRUE.
         WRITE (TEMP,500)
         NSTART = 1
         NDEC = 3
         NUMOPT = 4
         NTEXT = NSTART + NUMOPT - 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                TEMP,
     +                BORDER, FLASH, HIGH)
         IF (NDEC.EQ.1) THEN
            CALL GETIM1 (N1, NEWROW, NROW1,
     +                  'Number of the row for a sign change')
            DO I = 1, NCOL1
               A1(NEWROW,I) = - A1(NEWROW,I)
            ENDDO
         ELSEIF (NDEC.EQ.2) THEN
            CALL GETIM1 (N1, NEWCOL, NCOL1,
     +                  'Number of the column for a sign change')
            DO I = 1, NROW1
               A1(I,NEWCOL) = - A1(I,NEWCOL)
            ENDDO
         ELSEIF (NDEC.EQ.3) THEN
            DO J = 1, NCOL1
               DO I = 1, NROW1
                  A1(I,J) = - A1(I,J)
               ENDDO   
            ENDDO     
         ELSE
            OK = .FALSE.
         ENDIF
         IF (OK) CALL PUTADV ('The sign has been changed')
C
C NDEC = 7: Insert a vector into a vector
C =========
C
      ELSEIF (NDEC.EQ.7) THEN
         OK = .TRUE.
         I12(1) = FORM12(NROW1)
         WRITE (TEMP,600) I12(1)
         NUMOPT = 5
         NDEC = NUMOPT
         NSTART = 9
         NTEXT = NSTART + NUMOPT - 1
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEMP,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NDEC.EQ.1) THEN
            NRTEMP = NROW1 + 1
         ELSEIF (NDEC.GE.2 .AND. NDEC.LE.4) THEN
            NRTEMP = NROW1
         ELSE
            NDEC = 0
            OK = .FALSE.
         ENDIF
         IF (OK) THEN
            CALL GETIM1 (N1, NLINK, NRTEMP,
     +'Position of first inserted component in new vector')
            I = N3
            J = N10
            FIXNPT = .FALSE.
            LABEL = .FALSE.
            CLOSE (UNIT = J)
            CALL VEC3IN (I, J, LV,
     +                   CHAR1, CHAR2,
     +                   ABORT, FIXNPT, LABEL)
            CLOSE (UNIT = J)
            IF (.NOT.ABORT .AND. LV.GT.0) THEN
               ALLOCATE(V1(LV), STAT = IERR)
               IF (IERR.NE.0) THEN
                  CALL PUTERR (IERR, 'A')
                  CLOSE (UNIT = NUNIT1)
                  CLOSE (UNIT = NUNIT2)                   
                  RETURN
               ENDIF                       
               CALL VEC2IN (J, LV, LV,
     +                      V1,
     +                      CHAR1, CHAR2,
     +                      ABORT)
               CLOSE (UNIT = J)
               IF (.NOT.ABORT) THEN
                  IF (NDEC.EQ.1) THEN
                     ALLOCATE (B1(NROW1,1), STAT = IERR)
                     IF (IERR.NE.0) THEN
                        CALL PUTERR (IERR, 'A')
                        CLOSE (UNIT = NUNIT1)
                        CLOSE (UNIT = NUNIT2)                          
                        RETURN
                     ENDIF                             
                     DO I = 1, NROW1
                        B1(I,1) = A1(I,1)
                     ENDDO
                     DEALLOCATE(A1, STAT = IERR)
                     IF (IERR.NE.0) THEN
                        CALL PUTERR (IERR, 'D')
                        CLOSE (UNIT = NUNIT1)
                        CLOSE (UNIT = NUNIT2)                          
                        RETURN
                     ENDIF                          
                     NPTS = NROW1 + LV
                     NRMAX1 = NPTS
                     ALLOCATE(A1(NPTS,1), STAT = IERR)
                     IF (IERR.NE.0) THEN
                        CALL PUTERR (IERR, 'A')
                        CLOSE (UNIT = NUNIT1)
                        CLOSE (UNIT = NUNIT2)                          
                        RETURN
                     ENDIF                             
                     DO I = 1, NROW1
                        A1(I,1) = B1(I,1)
                     ENDDO
                     DO I = NROW1, NLINK, - 1
                        J = I + LV
                        A1(J,1) = A1(I,1)
                     ENDDO
                     NROW1 = NPTS
                     J = NLINK - 1
                     DO I = 1, LV
                        J = J + 1
                        A1(J,1) = V1(I)
                     ENDDO
                     CALL PUTCAU ('Vector now contains inserted vector')
                  ELSE
                     J = NLINK - 1
                     DO I = 1, LV
                        J = J + 1
                        IF (NDEC.EQ.2) THEN
                           A1(J,1) = V1(I)
                        ELSEIF (NDEC.EQ.3) THEN
                           A1(J,1) = A1(J,1) + V1(I)
                        ELSE   
                           A1(J,1) = A1(J,1) - V1(I)
                        ENDIF      
                     ENDDO
                     CALL PUTCAU ('Vector has been changed')
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
C
C NDEC = 8: Rearrange vector into order
C =========
C
      ELSEIF (NDEC.EQ.8) THEN
         ALLOCATE(V1(NROW1), STAT = IERR)
         IF (IERR.NE.0) THEN
            CALL PUTERR (IERR, 'A')
            CLOSE (UNIT = NUNIT1)
            CLOSE (UNIT = NUNIT2)                   
            RETURN
         ENDIF                       
         CALL SRTVEC (NCOL1, NROW1, NRMAX1,
     +                A1, V1)
C
C NDEC = NUMOPT - 2: view
C ==================
C
      ELSEIF (NDEC.EQ.NUMOPT - 2) THEN
         IF (NCOL1.LT.1 .OR. NCOL1.GT.NCMAX1 .OR.
     +       NROW1.LT.1 .OR. NROW1.GT.NRMAX1) THEN
            CALL PUTADV ('Inconsistent dimensions in call to SUB08')            
         ELSE          
            CALL SUB08 (NCMAX1, NCOL1, NRMAX1, NROW1,
     +                  A1,
     +                  TITLE)
      ENDIF 
C
C NDEC = NUMOPT - 1: accept
C ==================
C
      ELSEIF (NDEC.EQ.NUMOPT - 1) THEN
         CALL PUTADV ('Matrix manipulations have been accepted')
         APPLY = .TRUE.
         REPEET = .FALSE.
C
C NDEC = NUMOPT: cancel
C =============
C
      ELSEIF (NDEC.EQ.NUMOPT) THEN
         CALL PUTADV ('Matrix manipulations have been rejected')
         APPLY = .FALSE.
         REPEET = .FALSE.
      ENDIF

C------------------------------------------------------------
C End of main loop
C
      ENDDO
C-------------------------------------------------------------
      CLOSE (UNIT = NUNIT1)
      CLOSE (UNIT = NUNIT2)
C
C Format statments
C      
  100 FORMAT (
     + ' '
     +/' '
     +/'Matrix or Vector: Transpose'
     +/'Matrix or Vector: Insert/overwrite/add/subtract from file'
     +/'Matrix or Vector: Reflect top to bottom'
     +/'Matrix only: Reflect left to right'
     +/'Matrix or Vector: Select sub-matrix for Save As ...'
     +/'Matrix or Vector: Change sign of row/column/all'
     +/'Vector only: insert/overwrite/add/subtract from file'
     +/'Vector only: put into increasing/decreasing order'
     +/'View'
     +/'Apply'
     +/'Cancel')
  200 FORMAT (
     + 'Matrix file-insert/overwrite/add/subtract options'
     +/
     +/'You can expand the current matrix, or over-write'
     +/'a sub-matrix and preserve current dimensions.'
     +/
     +/'You must have a file with a matrix of consistent'
     +/'dimensions for insertion into the current matrix'
     +/'before you can use these options.'
     +/'Current number of rows =',1X,A
     +/'Current numbere of columns =',1X,A
     +/'Insert new matrix: Increase number of columns'
     +/'Insert new matrix: Increase number of rows'
     +/'Maintain shape: Over-write a sub-matrix'
     +/'Maintain shape: Add to a sub-matrix' 
     +/'Maintain shape: Subtract from a sub-matrix'
     +/'Cancel ... no action')
  300 FORMAT ('Now input a file with number. of',1X,A,1X,'=',1X,A)
  400 format ('Now input a file with number of rows =<',1X,A,
     +', and number of columns =<',1X,A)
  500 FORMAT (
     + 'Change sign for a chosen row'
     +/'Change sign for a chosen column'
     +/'Change sign for all rows and columns'
     +/'Cancel ... no action')
  600 FORMAT (
     + 'Vector file-insert/overwrite/add/subtract options'
     +/
     +/'You can expand the current vector, or over-write'
     +/'a sub-vector and preserve current dimensions.'
     +/
     +/'You must have a vector file of consistent dimension'
     +/'before you can over-write a sub-vector.'
     +/'The current dimension =',1X,A
     +/'Increase dimension: Insert new vector'
     +/'Preserve dimension: Over-write a sub-vector'
     +/'Preserve dimension: Add to a sub-vector'
     +/'Preserve dimension: Subtract from a sub-vector'
     +/'Cancel ... no action')
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE SUB10 (NBIG, NCMAX, NCOL, NLINES, NRMAX, NROW,
     +                  A,
     +                  FNAME, PHRASE, TITLE)
C
C Write a new data file
C 15/06/2006 edited
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NBIG, NCMAX, NCOL, 
     +                                       NRMAX, NROW
      INTEGER,             INTENT (INOUT) :: NLINES
      DOUBLE PRECISION,    INTENT (IN)    :: A(NRMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (IN)    :: FNAME  
      CHARACTER (LEN = *), INTENT (INOUT) :: PHRASE(NBIG), TITLE
C
C Locals
C
      INTEGER    N3, N4
      PARAMETER (N3 = 3, N4 = 4)
      LOGICAL    ABORT
      LOGICAL    HEADER, QTEXT, QTITLE
      PARAMETER (HEADER = .TRUE., QTEXT = .FALSE., QTITLE = .FALSE.)
      EXTERNAL EDITTT, MATOUT
      CALL EDITTT (NBIG, NLINES,
     +             PHRASE, TITLE)
      CLOSE (UNIT = N4)
      OPEN (UNIT = N4, FILE = FNAME)
      CALL MATOUT (N3, NCOL, N4, NRMAX, NROW, NLINES,
     +             A,
     +             FNAME, PHRASE, TITLE,
     +             ABORT, HEADER, QTEXT, QTITLE)
      CLOSE (UNIT = N4)
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE SUB11 (NCMAX, NCOL, NRMAX, NROW,
     +                  A,
     +                  FNAME)
C
C Write a new data file with no header/trailer
C 15/06/2006 edited
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NCMAX, NCOL, NRMAX, NROW
      DOUBLE PRECISION,    INTENT (IN) :: A(NRMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (IN) :: FNAME
C
C Locals
C
      INTEGER    NBIG
      PARAMETER (NBIG = 1)
      INTEGER    N3, N4
      PARAMETER (N3 = 3, N4 = 4)
      CHARACTER  PHRASE(NBIG)*1, TITLE*1
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT
      LOGICAL    HEADER, QTEXT, QTITLE
      PARAMETER (HEADER = .FALSE., QTEXT = .FALSE., QTITLE = .FALSE.)
      EXTERNAL   MATOUT
      PHRASE(1) = BLANK
      TITLE = BLANK
      CLOSE (UNIT = N4)
      OPEN (UNIT = N4, FILE = FNAME)
      CALL MATOUT (N3, NCOL, N4, NRMAX, NROW, NBIG,
     +             A,
     +             FNAME, PHRASE, TITLE, ABORT, HEADER,
     +             QTEXT, QTITLE)
      CLOSE (UNIT = N4)
      END
C
C
