C
C
C EDITPS2.FOR : DECIDE, LPTCOM, PS2PLT, REPLOT, TXT2PS
C ============================================================
C
C
      SUBROUTINE EDITPS_DECIDE (ISEND)
C
C Choose action
C
      IMPLICIT   NONE
C
C Argument
C      
      INTEGER, INTENT (INOUT) :: ISEND
C
C Locals
C      
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT, N1, N2
      PARAMETER (ICOLOR = 7, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 13,
     +           NSTART = 11, NTEXT = 23, N1 = 1, N2 = 2)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      CHARACTER  TEXT(NTEXT)*100
      LOGICAL    TAB_TOP, TAB_MID, TAB_BOT
      PARAMETER (TAB_TOP = .FALSE., TAB_MID = .FALSE.,
     +           TAB_BOT = .FALSE.)
      LOGICAL    ABORT, AGAIN, FIRST
      PARAMETER (FIRST = .FALSE.)
      EXTERNAL   EDITPS_ADVISE, PSCODE$
      EXTERNAL   LBOX01
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      AGAIN = .TRUE.
      WRITE (TEXT,100)
      DO WHILE (AGAIN)
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, ISEND, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, TEXT,
     +               TAB_TOP, TAB_MID, TAB_BOT)
         IF (ISEND.EQ.NUMOPT - N2) THEN
            CALL PSCODE$
            AGAIN = .TRUE.
         ELSEIF (ISEND.EQ.NUMOPT - N1) THEN
            CALL EDITPS_ADVISE (ABORT, FIRST)
            AGAIN = .TRUE.
         ELSE
            AGAIN = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'You must supply EPSF standard PostScript .eps files with'
     +/'accurate BoundingBoxes, such as Simfit .eps files.'
     +/'Note the following facts about the options provided.'
     +/'[Edit] rotates or re-sizes but editing plot titles and'
     +/'legends only works with Simfit files. [Stack] mode will'
     +/'automatically re-size/rearrange into a k-column collage'
     +/'with sub-plot labels and extra text. [Overlay] mode can'
     +/'re-size/drag-drop into arbitrary collages. The [Create]'
     +/'option writes your typed-in data into a .eps file, while'
     +/'[Transform] makes targets without altering source files.'
     +/'Edit: 1 file (rotate/re-size/view/print)'
     +/'Stack: n files/library (ordered collage)'
     +/'Overlay: n files/library (arbitrary collage)'
     +/'Create: .eps file from text'
     +/'Transform: .eps into .jpg file'
     +/'Transform: .eps into .pcx file'
     +/'Transfrom: .eps into .bmp file'
     +/'Transform: .eps into .tif file'
     +/'Transform: .eps into .png file'
     +/'Transform: .eps into .pdf file'
     +/'View: PostScript fonts/codes'
     +/'Help'
     +/'Quit ... Exit DLL version of program EDITPS')
      END
C
C-------------------------------------------------------------------------------
C
      SUBROUTINE EDITPS_LPTCOM (NOUT, 
     +                          INFO,
     +                          ABORT)
C
C ACTION : Hardcopy/view/save-file
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 29/3/98
C
C          07/04/2003 added quotes around filename passed to GSVIEW
C          16/08/2003 deleted reference to printer 4
C          17/11/2003 deleted reference to printer 3 and replaced
C                     STARTP and quotes etc. by call to RUN_GSVIEW
C          02/02/2008 added INTENTS
C          07/01/2009 renamed EDITPS_LPTCOM 
C
C          INFO = 'OPEN': decide from a menu then open a temporary file
C          INFO = 'VIEW': prepare a temporary file for viewing
C          INFO = 'FILE': prepare a file for saving
C
C          After one of these options there is a return to create the
C          file and the NUMDEC is saved so that on the next entry
C          the hardcopy, etc. results
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NOUT
      CHARACTER (LEN = *), INTENT (IN)  :: INFO
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, NUMOPT = 6)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    JSEND
      PARAMETER (JSEND = 1)
      INTEGER    ERROR_CODE
      CHARACTER  INFO1*4
      CHARACTER  FILEX*1024, TNAME*1024
      CHARACTER  TEXT(30)*100
      LOGICAL    ASKIF, THERE
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   LBOX02, OFILES, FPRINT, GETTMP, DELEET, RUN_GSVIEW,
     +           DOTEPS, TRIML1, UCASE1
      SAVE       NUMDEC, FILEX
      DATA       NUMPOS / NUMOPT*1 /
      ABORT = .FALSE.
      INFO1 = INFO
      CALL TRIML1 (INFO1)
      CALL UCASE1 (INFO1)
      IF (INFO1.EQ.'OPEN') THEN
C
C Decide what to do from the menu
C
         ABORT = .TRUE.
         WRITE (TEXT,100)
         NUMDEC = 4
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                TEXT)
         IF (NUMDEC.LT.5) THEN
C
C NUMDEC = 1, 2, 3, 4 ... Open temporary file to write/copy-to-printer
C
            CALL GETTMP (ERROR_CODE,
     +                   FILEX)
            CLOSE (UNIT = NOUT)
            OPEN (UNIT = NOUT, FILE = FILEX)
            ABORT = .FALSE.
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5 ... Open a file to contain the final PostScript
C
            CLOSE (UNIT = NOUT)
            CALL OFILES (JSEND, NOUT, 
     +                   TNAME,
     +                   ABORT)
            IF (.NOT.ABORT) CALL DOTEPS (TNAME,
     +                                   ABORT)
            IF (ABORT) CLOSE (UNIT = NOUT)
         ELSE
C
C NUMDEC = 6 ... Return to main program
C
            ABORT = .TRUE.
         ENDIF
         RETURN
      ELSEIF (INFO1.EQ.'VIEW') THEN
C
C By pass the menu and go directly to creating a temporary file for GSview
C

         CALL GETTMP (ERROR_CODE,
     +                FILEX)
         CLOSE (UNIT = NOUT)
         OPEN (UNIT = NOUT, FILE = FILEX)
         ABORT = .FALSE.
         NUMDEC = 4
         RETURN
      ELSEIF (INFO1.EQ.'FILE') THEN
C
C By pass the menu and go directly to creating a file for saving
C
         CLOSE (UNIT = NOUT)
         CALL OFILES (JSEND, NOUT,
     +                TNAME, 
     +                ABORT)
         IF (.NOT.ABORT) CALL DOTEPS (TNAME, 
     +                                ABORT)
         IF (ABORT) CLOSE (UNIT = NOUT)
         NUMDEC = 5
         RETURN
      ELSE
         CLOSE (UNIT = NOUT)
         IF (NUMDEC.EQ.3) NUMDEC = 0
      ENDIF
C
C View or copy file to port
C

      IF (NUMDEC.EQ.4) THEN
         CALL RUN_GSVIEW (FILEX)
      ELSEIF (NUMDEC.NE.5) THEN
         CALL FPRINT (NUMDEC,
     +                FILEX)
      ENDIF
      CALL DELEET (FILEX, 
     +             ASKIF, THERE)
C
C Format statement
C     
  100 FORMAT (
     + 'PostScript Printer 1'
     +/'Postscript Printer 2'
     +/'Default PostScript Printer'
     +/'View'
     +/'File'
     +/'Cancel')
      END
C
C---------------------------------------------------------------------
C
      SUBROUTINE EDITPS_PS2PLT (ICOUNT, NHIGH, NIN, NLEG, NMAX, NWIDE,
     +                          CAPTION, FNAME, LEGEND, TITLE,
     +                          FULL)
C
C ACTION : Read in possible files and check them
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/12/95
C          10/01/2000 added PS2LIB to allow library files
C          24/02/2001 added PFILES
C          02/02/2008 added INTENTS 
C          07/01/2009 renamed EDITPS_PS2PLT   
C
C          ICOUNT = no. of files selected
C          If NMAX = 1 then just select 1 file
C
C          FULL = .TRUE. then also ask for caption/title/text
C          There is now no need to call with FULL = .TRUE. as a
C          better mechanism is used. Code is retained just in case.
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NHIGH, NIN, NMAX,
     +                                       NWIDE
      INTEGER,             INTENT (INOUT) :: ICOUNT, NLEG
      CHARACTER (LEN = *), INTENT (INOUT) :: CAPTION(NMAX),
     +                                       LEGEND(NHIGH),
     +                                       TITLE
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME(NMAX)
      LOGICAL,             INTENT (IN)    :: FULL
C
C Locals
C
      INTEGER    ICOLOR, ISEND, ITYPE, IX, IY, LSHADE, NOUT10,
     +           NSTART, NTEXT, NUMDEC, NUMOPT, N0, N1, N2, N3, N4
      PARAMETER (ICOLOR = 9, ISEND = 3, ITYPE = 6, IX = 4, IY = 4,
     +           LSHADE = 1, NOUT10 = 10, NSTART = 11,
     +           N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    NUMBLD(30), NUMPOS(20)
      INTEGER    I, IPREV, NFILES, NMAX1, NBEGIN
      DOUBLE PRECISION X1, X2, Y1, Y2
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  BLANK*1, QUEST*1, TNAME*1024
      PARAMETER (BLANK = ' ', QUEST = '?')
      LOGICAL    IHELPU
      LOGICAL    ABORT, ACCEPT(200), FIRST, FRAME, IWARNU, YES
      PARAMETER (IWARNU = .TRUE., FRAME = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   OFILES, GETTXT, PUTADV, YESNO2, EDITTX, LBOX01, LBOX02,
     +           PATCH1, PFILES
      EXTERNAL   STRCHK$
      EXTERNAL   ISITPS, EDITPS_PS2LIB
      SAVE       IHELPU
      DATA       IHELPU / .TRUE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
C
C Initialise. Note that ICOUNT is zeroised if only 1 file is required.
C
      IF (NMAX.EQ.N1) ICOUNT = N0
      NFILES = N0
      NMAX1 = NMAX
      NBEGIN = N1
      FIRST = .TRUE.
      YES = .TRUE.
C
C Main loop
C
      DO WHILE (ICOUNT.LT.NMAX .AND. YES)
         IF (NMAX.GT.N1) THEN
C
C If more than 1 file expected and first time then try options
C
            IF (FIRST) THEN
               FIRST = .FALSE.
               WRITE (TEXT,100)
               NUMOPT = 5
               NUMDEC = 4
               CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                      TEXT)
               IF (NUMDEC.LE.N2) ICOUNT = N0
            ENDIF
            IF (NUMDEC.LE.N2) THEN
               CLOSE (UNIT = NIN)
               CALL EDITPS_PS2LIB (NFILES, NIN, NMAX1,
     +                             FNAME(NBEGIN), 
     +                             ABORT)
               CLOSE (UNIT = NIN)
               IF (ABORT) THEN
C
C Return with no files ... not a PS or library file
C
                  ICOUNT = N0
                  RETURN
               ELSEIF (NFILES.EQ.N1) THEN
C
C Just 1 PS file so carry on with 1 file at a time
C
                  ICOUNT = ICOUNT + N1
                  NBEGIN = NBEGIN + N1
                  NMAX1 = N1
C
C Next code for FULL = .TRUE. is probably redundant
C
                  IF (FULL) THEN
                     WRITE (LINE,100) 
                     CALL GETTXT (LINE,
     +                            CAPTION(ICOUNT))
                     IF (CAPTION(ICOUNT).EQ.QUEST)
     +                   CAPTION(ICOUNT) = BLANK
                     CALL STRCHK$(CAPTION(ICOUNT))
                  ENDIF
               ELSE
C
C The library file referenced NFILES PS files so set ICOUNT then return
C
                  ICOUNT = NFILES
                  RETURN
               ENDIF
            ELSEIF (NUMDEC.EQ.N3) THEN
C
C Multi-selection by project then return whatever the outcome
C
               CLOSE (UNIT = NIN)
               CLOSE (UNIT = NOUT10)
               IPREV = ITYPE
               NFILES = ICOUNT
               CALL PFILES (IPREV, ITYPE, NFILES, NIN, NMAX, NOUT10,
     +                      FNAME,
     +                      ACCEPT)
               ICOUNT = NFILES
               CLOSE (UNIT = NIN)
               CLOSE (UNIT = NOUT10)
               RETURN
            ELSEIF (NUMDEC.EQ.N4) THEN
C
C Help
C
               FIRST = .TRUE.
               WRITE (TEXT,200)
               NTEXT = 21
               NUMBLD(1) = N1
               CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +                      TEXT,
     +                      FRAME)
            ELSE
C
C Cancel
C
               RETURN
            ENDIF
         ELSE
C
C Just select 1 file
C
            NUMDEC = N2
            IF (IHELPU) THEN
               IHELPU = .FALSE. 
               CALL PUTADV (
     +'Input an EPSF standard PostScript file (like simfig1.ps)')
            ENDIF
            CLOSE (UNIT = NIN)
            CALL OFILES (ISEND, NIN,
     +                   TNAME, 
     +                   ABORT)
            IF (.NOT.ABORT) THEN
               CALL ISITPS (NIN,
     +                      X1, X2, Y1, Y2,
     +                      ABORT, IWARNU)
               IF (.NOT.ABORT) THEN
                  ICOUNT = N1
                  FNAME(ICOUNT) = TNAME
C
C Next code for FULL = .TRUE. is probably redundant
C
                  IF (FULL) THEN
                     WRITE (LINE,300) ICOUNT
                     CALL GETTXT (LINE, 
     +                            CAPTION(ICOUNT))
                     IF (CAPTION(ICOUNT).EQ.QUEST)
     +                   CAPTION(ICOUNT) = BLANK
                     CALL STRCHK$(CAPTION(ICOUNT))
                  ENDIF
                  RETURN
               ELSE
                  ICOUNT = N0
               ENDIF
            ENDIF
         ENDIF
         CLOSE (UNIT = NIN)
C
C See if the user wants to try again
C
         IF (YES .AND. ICOUNT.LT.NMAX .AND. NUMDEC.NE.4) THEN
            CALL YESNO2 (ICOLOR, IX, IY,
     +     'Do you want to select another ps file ?',
     +                   YES)
         ENDIF
      ENDDO
C
C Warn if no files have been selected
C
      IF (ICOUNT.LT.N1) THEN
         CALL PUTADV (
     +  'You must have at least one file for this option')
         RETURN
      ENDIF
C
C Next code for FULL = .TRUE. is probably redundant
C Get title and legends ... note STRCHK$ to check for parentheses
C
      IF (FULL) THEN
         WRITE (TEXT,400)
         NUMDEC = 3
         NUMBLD(1) = 1
         NUMOPT = 4
         NTEXT = 14
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.1 .OR. NUMDEC.EQ.3) THEN
            CALL GETTXT ('Short overall plot title (< 72 characters ?)',
     +                    TITLE)
            CALL STRCHK$(TITLE)
            IF (TITLE.EQ.QUEST) TITLE = BLANK
         ELSE
            TITLE = BLANK
         ENDIF
         IF (NUMDEC.EQ.2 .OR. NUMDEC.EQ.3) THEN
            CALL EDITTX (NHIGH, NLEG, NWIDE,
     +                   LEGEND)
            IF (NLEG.GT.N0) THEN
               DO I = 1, NLEG
                  CALL STRCHK$(LEGEND(I))
               ENDDO
            ENDIF
         ELSE
            NLEG = N0
         ENDIF
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Input a library file'
     +/'Input n files individually'
     +/'Input n files as a project'
     +/'Help'
     +/'Cancel')
  200 FORMAT (
     + 'Selecting Encapsulated PostScript files (.ps, .eps)'/
     +/'This program now requires you to input a set of Postscript'
     +/'files to compose a figure. All files must conform to the'
     +/'EPSF convention and must have correct BoundingBoxes.'
     +/'The possible ways to supply such files are as follows.'
     +/'1)`Supply a library file created by program MAKLIB with a'
     +/'  `list of all the files required. This is the best method.'
     +/'2)`You select individual files using the SIMFIT single file'
     +/'  `selection procedure. This technique should be used when'
     +/'  `you only need a few files that have been recently created'
     +/'  `by SIMFIT and that can therefore be taken from the Files'
     +/'  `Created List. Files are tested individually for conformance'
     +/'  `to the EPSF standard as they are selected.'
     +/'3)`You open a multiselection project. This technique generates'
     +/'  `an archive file (p_current.cfg) with all the files you have'
     +/'  `recently selected and is ideal when you wish to select sets'
     +/'  `of files from a set of stored files. Files are tested after'
     +/'  `a project set has been selected, but the current project set'
     +/'  `can be edited and selections can be added to the archive.'
     +/'  `This is a very powerful technique for experienced users')
  300 FORMAT (
     +'Short caption (< 50 characters ?) to go underneath plot',I3)
  400 FORMAT ('Adding a title and text to the collage'/
     +/'You can specify a title and/or text to be placed underneath'
     +/'the collage. If you want a title it will consist of just one'
     +/'line in a large bold font. If you want any extra text, just'
     +/'fill in the editor as required. However, make no attempt to'
     +/'justify the text as this program transforms what you type'
     +/'into ragged right PostScript format with a width that depends'
     +/'upon the dimensions of the collage.'/
     +/'Title only'
     +/'Text only'
     +/'Title and text'
     +/'Nothing')
      END
C
C----------------------------------------------------------------------------
C
      SUBROUTINE EDITPS_REPLOT (NHIGH, NIN, NFILES, NMAX, NOUT, NWIDE,
     +                          BBOXX, BBOXY, XTRANS, YTRANS, ZSCALE,
     +                          CAPTION, FNAME, LEGEND, XTRA1, XTRA2,
     +                          XTRA3)
C
C ACTION : Stack PostScript files in free-style mode
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/12/95
C          12/06/2000 added PSADD1
C          02/02/2008 added INTENTS
C          07/01/2009 renamed EDITPS_REPLOT
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NHIGH, NIN, NMAX,
     +                                       NOUT, NWIDE
      INTEGER,             INTENT (INOUT) :: NFILES
      DOUBLE PRECISION,    INTENT (INOUT) :: BBOXX(2,NMAX + 1), 
     +                                       BBOXY(2,NMAX + 1),
     +                                       XTRANS(NMAX + 1),
     +                                       YTRANS(NMAX + 1), 
     +                                       ZSCALE(NMAX + 1)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: CAPTION(NMAX),
     +                                       LEGEND(NHIGH)
      CHARACTER (LEN = *), INTENT (INOUT) :: XTRA1
      CHARACTER (LEN = *), INTENT (INOUT) :: XTRA2(NHIGH),
     +                                       XTRA3(10*NHIGH)
C
C Locals
C      
      INTEGER    I, IBOT, IMID, IOS, ISEND, ITOP, NLEG
      INTEGER    IXBB1, IXBB2, IYBB1, IYBB2, NFILE1
      INTEGER    N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, NUMOPT = 10)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION XTEMP1, XTEMP2, X1, X2, YTEMP1, YTEMP2, Y1, Y2
      DOUBLE PRECISION XADD, XDIFF, YADD, YDIFF
      DOUBLE PRECISION XSAV, YSAV, ZSAV
      DOUBLE PRECISION F72, ZERO, ONE
      PARAMETER (F72 = 72.0D+00, ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  LINE*120, TEXT(NUMOPT)*100, TITLE*1
      LOGICAL    ABORT, EXTRA
      LOGICAL    FIRST, FULL, IWARNU
      PARAMETER (FIRST = .FALSE., FULL = .FALSE., IWARNU = .TRUE.)
      EXTERNAL   EDITPS_LPTCOM, EDITPS_PS2PLT, EDITPS_ADVISE 
      EXTERNAL   TRIML1, YESNO2, LBOX02, GETJM1, GETD01, W_PLOTSQ
      EXTERNAL   ISITPS, EDITPS_PSADD1
      INTRINSIC  NINT, DBLE
      SAVE       IMID
      DATA       IMID / 1 /
      DATA       NUMPOS / NUMOPT*1 /
C
C SECTION 1: Read in possible files and check them
C ==========
C
      CALL EDITPS_PS2PLT (NFILES, NHIGH, NIN, NLEG, NMAX, NWIDE,
     +                    CAPTION, FNAME, LEGEND, TITLE,
     +                    FULL)
      IF (NFILES.LT.1) RETURN
      DO I = N1, NFILES
C
C Open file and find BoundingBox coordinates
C
         CLOSE (UNIT = NIN)
         OPEN (UNIT = NIN, FILE = FNAME(I))
         CALL ISITPS (NIN, XTEMP1, XTEMP2, YTEMP1, YTEMP2, ABORT,
     +                IWARNU)
         CLOSE (UNIT = NIN)
C
C Make corrections for the scaling factors
C
         BBOXX(N1,I) = XTEMP1
         BBOXX(N2,I) = XTEMP2
         BBOXY(N1,I) = YTEMP1
         BBOXY(N2,I) = YTEMP2
      ENDDO
C
C Create the extra text file but suppress it
C
      ISEND = 10
      CALL EDITPS_PSADD1 (ISEND, IXBB1, IXBB2, IYBB1, IYBB2,
     +                    NHIGH, NOUT, NWIDE,
     +                    XTRA1, XTRA2, XTRA3,
     +                    EXTRA)
      NFILE1 = NFILES + N1
      XSAV = XTRANS(NFILE1)
      YSAV = YTRANS(NFILE1)
      ZSAV = ZSCALE(NFILE1)
      XTRANS(NFILE1) = ZERO
      YTRANS(NFILE1) = ZERO
      ZSCALE(NFILE1) = ONE
      BBOXX(N1,NFILE1) = DBLE(IXBB1)
      BBOXX(N2,NFILE1) = DBLE(IXBB2)
      BBOXY(N1,NFILE1) = DBLE(IYBB1)
      BBOXY(N2,NFILE1) = DBLE(IYBB2)
      FNAME(NFILE1) = XTRA1
      NFILE1 = NFILES
C
C SECTION 2: Main loop to drive printer or write file as required
C ==========
C
   20 CONTINUE
      WRITE (TEXT,100)
      NUMDEC = NUMOPT - 4
      CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
      IF (NUMDEC.EQ.NUMOPT) THEN
         LINE = 'This action will release selected files ... Proceed ?'
         ABORT = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY, LINE, ABORT)
         IF (ABORT) THEN
            NFILE1 = NFILES + N1
            XTRANS(NFILE1) = XSAV
            YTRANS(NFILE1) = YSAV
            ZSCALE(NFILE1) = ZSAV
            RETURN
         ELSE
            GOTO 20
         ENDIF
      ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
         CALL EDITPS_ADVISE (ABORT, FIRST)
         GOTO 20
      ELSEIF (NUMDEC.LT.NUMOPT - 6) THEN
         IF (NFILE1.GT.1) THEN
            WRITE (LINE,200)
            IBOT = N1
            ITOP = NFILE1
            IF (IMID.LT.IBOT .OR. IMID.GT.ITOP) IMID = IBOT
            CALL GETJM1 (IBOT, IMID, ITOP, LINE)
         ELSE
            IMID = N1
         ENDIF
         IF (NUMDEC.EQ.1) THEN
            WRITE (LINE,300) XTRANS(IMID)
            CALL GETD01 (XTRANS(IMID), LINE)
         ELSEIF (NUMDEC.EQ.2) THEN
            WRITE (LINE,400) YTRANS(IMID)
            CALL GETD01 (YTRANS(IMID), LINE)
         ELSE
            WRITE (LINE,500) ZSCALE(IMID)
            CALL GETD01 (ZSCALE(IMID), LINE)
         ENDIF
         GOTO 20
      ELSEIF (NUMDEC.EQ.NUMOPT - 5) THEN
         ISEND = N2
         CALL EDITPS_PSADD1 (ISEND, IXBB1, IXBB2, IYBB1, IYBB2,
     +                       NHIGH, NOUT, NWIDE,
     +                       XTRA1, XTRA2, XTRA3,
     +                       EXTRA)
         BBOXX(N1,NFILES + N1) = DBLE(IXBB1)
         BBOXX(N2,NFILES + N1) = DBLE(IXBB2)
         BBOXY(N1,NFILES + N1) = DBLE(IYBB1)
         BBOXY(N2,NFILES + N1) = DBLE(IYBB2)
         IF (EXTRA) THEN
            NFILE1 = NFILES + N1
         ELSE
            NFILE1 = NFILES
         ENDIF
         GOTO 20
      ELSEIF (NUMDEC.LT.NUMOPT - 4) THEN
         CALL W_PLOTSQ (NFILE1, 
     +                  BBOXX, BBOXY, XTRANS, YTRANS, ZSCALE)
         NUMDEC = NUMOPT - 4
         GOTO 20
      ENDIF
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
      IF (NUMDEC.EQ.NUMOPT - 4) THEN
         CALL EDITPS_LPTCOM (NOUT, 'VIEW', ABORT)
      ELSEIF (NUMDEC.EQ.NUMOPT - 3) THEN
         CALL EDITPS_LPTCOM (NOUT, 'OPEN', ABORT)
      ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
         CALL EDITPS_LPTCOM (NOUT, 'FILE', ABORT)
      ENDIF
      IF (ABORT) GOTO 20
C
C SECTION 3: Bounding Box and other coordinates then switch off showpage
C =========
C
      DO I = 1, NFILE1
C
C Make corrections for the scaling factors
C
         XADD = F72*XTRANS(I)
         YADD = F72*YTRANS(I)
         XTEMP1 = BBOXX(N1,I)
         XTEMP2 = BBOXX(N2,I)
         YTEMP1 = BBOXY(N1,I)
         YTEMP2 = BBOXY(N2,I)
         XDIFF = ZSCALE(I)*(XTEMP2 - XTEMP1)
         YDIFF = ZSCALE(I)*(YTEMP2 - YTEMP1)
         XTEMP1 = XTEMP1 + XADD
         XTEMP2 = XTEMP1 + XDIFF
         YTEMP1 = YTEMP1 + YADD
         YTEMP2 = YTEMP1 + YDIFF
C
C Find the extreme positions for the overall BoundingBox
C
         IF (I.EQ.1) THEN
            X1 = XTEMP1
            X2 = XTEMP2
            Y1 = YTEMP1
            Y2 = YTEMP2
         ELSE
            IF (XTEMP1.LT.X1) X1 = XTEMP1
            IF (XTEMP2.GT.X2) X2 = XTEMP2
            IF (YTEMP1.LT.Y1) Y1 = YTEMP1
            IF (YTEMP2.GT.Y2) Y2 = YTEMP2
         ENDIF
      ENDDO
C
C Write the overall BoundingBox coordinates to the file
C
      WRITE (NOUT,600) NINT(X1), NINT(Y1), NINT(X2), NINT(Y2)
C
C SECTION 4: Loop over each file selected
C ==========
C
      DO I = 1, NFILE1
C
C Open file and discard first line
C
         CLOSE (UNIT = NIN)
         OPEN (UNIT = NIN, FILE = FNAME(I))
         READ (NIN,700) LINE
C
C Save, translate then scale each file
C
         XADD =  F72*XTRANS(I) + BBOXX(N1,I)*(ONE - ZSCALE(I))
         YADD =  F72*YTRANS(I) + BBOXY(N1,I)*(ONE - ZSCALE(I))
         WRITE (NOUT,800) NINT(XADD), NINT(YADD),
     +                    ZSCALE(I), ZSCALE(I)
         IOS = 0
C
C Read in from NIN and write out to NOUT until EOF
C
         DO WHILE (IOS.EQ.0)
            READ (NIN,700,END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            CALL TRIML1 (LINE)
            IF (LINE(1:14).NE.'%%BoundingBox:') WRITE (NOUT,700) LINE
         ENDDO
C
C Restore then close down the file on NIN
C
   40    CONTINUE
         WRITE (NOUT,900)
         CLOSE (UNIT = NIN)
      ENDDO
C
C SECTION 5: Loop has gone through all files so switch showpage on again
C ==========
C
      WRITE (NOUT,1000)
C
C SECTION 8: Drive the printer by copying the file on NOUT
C ==========
C
      CALL EDITPS_LPTCOM (NOUT,
     +                    'CLOSE',
     +                    ABORT)
      GOTO 20
C
C Format statements
C      
  100 FORMAT (
     + 'X-translation (numerical editing)'
     +/'Y-translation (numerical editing)'
     +/'Scaling factor (numerical editing)'
     +/'Translate/Scale (graphical editing)'
     +/'Edit/Include/Suppress extra text'
     +/'View'
     +/'Print'
     +/'File'
     +/'Help'
     +/'Cancel')
  200 FORMAT ('Number of the file for editing')
  300 FORMAT ('Value for X-translation in inches: current value =',F8.3)
  400 FORMAT ('Value for Y-translation in inches: current value =',F8.3)
  500 FORMAT ('Value for scaling factor: current value =',F8.3)
  600 FORMAT (
     + '%!PS-Adobe-3.0 EPSF-3.0'
     +/'%%BoundingBox:',4I6
     +/'%%Creator: bill.bardsley@manchester.ac.uk'
     +/'%%Title: editps/simfit (6.09)'
     +/'%%EndComments'
     +/'save %save before switching off showpage'
     +/'/switchoffshowpage 20 dict def'
     +/'switchoffshowpage begin'
     +/'/showpage {} def')
  700 FORMAT (A)
  800 FORMAT ('save ',2I6,' translate',2f8.3,' scale')
  900 FORMAT ('restore')
 1000 FORMAT (
     +'end %end of switchoffshowpage dictionary'
     +/'restore %restore to switch showpage back on'
     +/'showpage')
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE EDITPS_TXT2PS (NHIGH, NOUT, NWIDE,
     +                          X_MARGIN, Y_HEIGHT, Z_SCALE, Z_WIDE,
     +                          LEGEND, TXTNEW)
C
C ACTION: Create a PS text file
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 18/05/2000
C         02/02/2008 added INTENTS
C         07/01/2009 renamed EDITS_TXT2PS 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NHIGH, NOUT, NWIDE
      DOUBLE PRECISION,    INTENT (INOUT) :: X_MARGIN, Y_HEIGHT,
     +                                       Z_SCALE, Z_WIDE
      CHARACTER (LEN = *), INTENT (INOUT) :: LEGEND(NHIGH),
     +                                       TXTNEW(10*NHIGH)
C
C Locals
C      
      INTEGER    N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, NUMOPT = 9)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    IX1BB, IX2BB, IY1BB, IY2BB
      INTEGER    JFONT, KFONT
      INTEGER    I, J, L, LEN200, NLEG, NNEW
      DOUBLE PRECISION YSPACE, YSTOP
      PARAMETER       (YSPACE = 16.0D+00, YSTOP = 36.0D+00)
      DOUBLE PRECISION X, XDIFF, Y, YTEMP
      DOUBLE PRECISION PNT01
      PARAMETER (PNT01 = 0.01D+00)
      DOUBLE PRECISION F12, F14, F72
      PARAMETER (F12 = 12.0D+00, F14 = 14.0D+00, F72 = 72.0D+00)
      CHARACTER  LINE*120, TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, FIRST
      PARAMETER (FIRST = .FALSE.)
      LOGICAL    WRAP, WRAP1
      PARAMETER (WRAP1 = .TRUE.)
      EXTERNAL   LBOX02, GETDGE, LEN200, EDITTX
      EXTERNAL   STRCHK$, STRPRN$, PSCODE$
      EXTERNAL   EDITPS_ADVISE, EDITPS_LPTCOM
      EXTERNAL   EDITPS_PSCHOP, EDITPS_PSCURL
      INTRINSIC  NINT
      SAVE       NLEG
      DATA       NUMPOS / NUMOPT*1 /
      DATA       NLEG / 0 /
      NUMDEC = N2
   20 CONTINUE
      WRITE (TEXT,100) X_MARGIN, Y_HEIGHT, Z_WIDE, Z_SCALE
      CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +             TEXT)
      IF (NUMDEC.EQ.2) THEN
         CALL EDITTX (NHIGH, NLEG, NWIDE,
     +                LEGEND)
         IF (NLEG.GT.0) THEN
            DO I = 1, NLEG
               CALL STRCHK$(LEGEND(I))
            ENDDO
         ENDIF
         GOTO 20
      ELSEIF (NUMDEC.EQ.3) THEN
         WRITE (LINE,200) X_MARGIN
         CALL GETDGE (X_MARGIN, PNT01,
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.4) THEN
         WRITE (LINE,300) Y_HEIGHT
         CALL GETDGE (Y_HEIGHT, PNT01,
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.5) THEN
         WRITE (LINE,400) Z_WIDE
         CALL GETDGE (Z_WIDE, PNT01,
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.6) THEN
         WRITE (LINE,500) Z_SCALE
         CALL GETDGE (Z_SCALE, PNT01,
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.7) THEN
         CALL PSCODE$
         GOTO 20
      ELSEIF (NUMDEC.EQ.8) THEN
         CALL EDITPS_ADVISE (ABORT, FIRST)
         GOTO 20
      ELSEIF (NUMDEC.EQ.NUMOPT) THEN
         RETURN
      ENDIF
C
C Calculate PostScript parameters ... First X and Y
C
      X = X_MARGIN*F72
      Y = Y_HEIGHT*F72
C
C Now XDIFF etc.
C

      YTEMP = Y - NINT(Z_SCALE*YSPACE)
      XDIFF = Z_WIDE*F72
      IX1BB = NINT(X)
      IX2BB = NINT(X + XDIFF)
      IY1BB = NINT(Y)
      IY1BB = IY1BB - (NLEG + N1)*NINT(Z_SCALE*YSPACE)
      IY2BB = NINT(Y)
      JFONT = NINT(F14*Z_SCALE)
      KFONT = NINT(F12*Z_SCALE)
C
C Main loop to drive printer or write file as required
C
      CALL EDITPS_LPTCOM (NOUT, 'OPEN', ABORT)
      IF (ABORT) GOTO 20
C
C Bounding Box and other coordinates
C
      WRITE (NOUT,600) IX1BB, IY1BB, IX2BB, IY2BB
      WRAP = WRAP1
      IF (WRAP) THEN
C
C Initialise STRPRN$ to print strings
C
         CALL STRPRN$(JFONT, IX1BB, IX2BB, NINT(YTEMP), NOUT,
     +                BLANK, 'OPEN')
C
C Initialise PSCURL to print {commands}
C
         L = 0
         CALL EDITPS_PSCURL (KFONT, L, NOUT,
     +                       LINE)
C
C Chop out {commands}
C
         CALL EDITPS_PSCHOP (NHIGH, NNEW,
     +                       TXTNEW, LEGEND)
         DO I = 1, NNEW
            LINE = TXTNEW(I)
            L = LEN200(LINE)
            IF (LINE(1:1).EQ.'{' .AND. LINE(L:L).EQ.'}' .AND.
     +          L.GT.2) THEN
C
C Print {command} using PSCURL
C
               CALL EDITPS_PSCURL (KFONT, L, NOUT,
     +                             LINE)
            ELSE
C
C Print ragged right using STRPRN$
C
               CALL STRPRN$(JFONT, IX1BB, IX2BB, NINT(YTEMP), NOUT,
     +                      TXTNEW(I), BLANK)
            ENDIF
         ENDDO
      ELSE
         DO I = 1, NLEG
            IF (LEGEND(I).NE.BLANK .AND. YTEMP.GE.YSTOP) THEN
               J = LEN200(LEGEND(I))
               WRITE (NOUT,700) KFONT, NINT(X), NINT(YTEMP),
     +                           LEGEND(I)(1:J)
            ENDIF
            YTEMP = YTEMP - Z_SCALE*YSPACE
         ENDDO
      ENDIF
      WRITE (NOUT,800)
C
C Drive the printer by copying the file on NOUT
C
      CALL EDITPS_LPTCOM (NOUT,
     +                    'CLOSE',
     +                    ABORT)
C
C Return to main branch point
C
      GOTO 20
C
C Format statements
C      
  100 FORMAT (
     + 'Print/view/file'
     +/'Edit the text'
     +/'Set X-margin [',F8.3,' in]'
     +/'Set Y-height [',F8.3,' in]'
     +/'Set line width[',F8.3,' in]'
     +/'Set scaling factor [',F8.3,']'
     +/'Display PS fonts and octal codes'
     +/'Help'
     +/'Cancel')
  200 FORMAT (
     + 'New X-margin required ( > 0.01 ): Current value =',F8.4)
  300 FORMAT (
     + 'New Y-height required ( > 0.01 ): Current value =',F8.4)
  400 FORMAT (
     + 'New line width required ( > 0.01 ): Current value =',F8.4)
  500 FORMAT (
     + 'New scaling factor required ( > 0.01 ): Current value =',F8.4)
  600 FORMAT (
     + '%!PS-Adobe-3.0 EPSF-3.0'
     +/'%%BoundingBox:',4I6
     +/'%%Creator: bill.bardsley@manchester.ac.uk'
     +/'%%Title: editps/simfit (6.09)'
     +/'%%EndComments')
  700 FORMAT (
     +'/Times-Roman findfont',I5,' scalefont setfont'
     +/2I8,' moveto'
     +/'(',A,') show')
  800 FORMAT (
     +'showpage')
      END
C
C
