C
C EDITPS3.INS : RESIZE, PS2LIB
C ============================
C
      SUBROUTINE EDITPS_RESIZE (NIN, NOUT)
C
C ACTION : Re-size and edit a PostScript file
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 13/12/95
C          15/03/2000 surrounded file names by " ... "
C          25/02/2001 replaced PUTDOS by direct in-line copying
C          07/01/2009 renamed EDITPS_RESIZE
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN) :: NIN, NOUT
C
C Locals
C      
      INTEGER    IOS, JOS, NFILES, NLEG
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 7, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 10,
     +           NSTART = 9, NTEXT = 18)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    NHIGH, NMAX, NWIDE
      PARAMETER (NHIGH = 1, NMAX = 1, NWIDE = 1)
      INTEGER    IERROR, IFAIL
      INTEGER    LEN200
      INTEGER    N0, N1, N10
      PARAMETER (N0 = 0, N1 = 1, N10 = 10)
      DOUBLE PRECISION X1, X2, Y1, Y2
      DOUBLE PRECISION XX1, XX2, XX3, XX4, YY1, YY2, YY3, YY4
      DOUBLE PRECISION X2_START, Y2_START
      DOUBLE PRECISION CTHETA, STHETA
      DOUBLE PRECISION THETA, THETA1, XSCALE, XTRANS, YSCALE, YTRANS
      DOUBLE PRECISION XSAV1, XSAV2, XTEMP, YSAV1, YSAV2, YTEMP, ZTEMP
      DOUBLE PRECISION EPSI, F72, F360
      PARAMETER (EPSI = 1.0D-04, F72 = 72.0D+00, F360 = 360.0D+00)
      DOUBLE PRECISION PIBY2, TWOPI
      PARAMETER (PIBY2 = 1.5707963D+00, TWOPI = 6.2831853D+00)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  FNAME(NMAX)*1024
      CHARACTER  FILEX*1024, FILE10*1024
      CHARACTER  LINE*1024, TEXT(30)*100
      CHARACTER  ARRAY*120, SEARCH*72, STRNG*120
      CHARACTER  CAPTION(NMAX)*(NWIDE), LEGEND(NHIGH)*(NWIDE),
     +           TITLE*(NWIDE)
      CHARACTER  STATUS*18
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, ASKIF, THERE
      PARAMETER (ASKIF = .FALSE.)
      LOGICAL    FIRST, FULL, IWARNU
      PARAMETER (FIRST = .FALSE., FULL = .FALSE., IWARNU = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    SHEAR
      EXTERNAL   EDITPS_PS2PLT, EDITPS_LPTCOM, EDITPS_ADVISE
      EXTERNAL   TRIML1, LBOX01, GETD02, GETDM1, GETTMP, LEN200,
     +           YESNO2, DELEET
      EXTERNAL   ISITPS
      EXTERNAL   PUTFAT$, STRGET$, GETTXT$, STREDI$
      INTRINSIC  ABS, NINT, COS, SIN, ATAN, SQRT, MIN, MAX
      SAVE       SHEAR, THETA, XSCALE, XTRANS, YSCALE, YTRANS
      DATA       SHEAR  / .FALSE. /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       THETA,    XSCALE,  XTRANS,  YSCALE, YTRANS
     +         / 0.0D+00, 1.0D+00, 1.0D+00, 1.0D+00, 1.0D+00 /
C
C SECTION 1: Read in possible files and check them
C ==========
C
      NFILES = 0
      NLEG = 0
      CAPTION(1) = BLANK
      FNAME(1) = BLANK
      LEGEND(1) = BLANK
      TITLE = BLANK
      CALL EDITPS_PS2PLT (NFILES, NHIGH, NIN, NLEG, NMAX, NWIDE,
     +                    CAPTION, FNAME, LEGEND, TITLE, 
     +                    FULL)
      IF (NFILES.LT.N1) RETURN
      IOS = N0
C
C Copy Postscript file to temporary file FILEX
C
      IERROR = 1
C
C Connect PS file to NIN and FILEX to N10
C
      CALL GETTMP (IFAIL,
     +             FILEX)
      IF (IFAIL.NE.N0) GOTO 60
      CLOSE (UNIT = NIN)
      OPEN (UNIT = NIN, FILE = FNAME(1), IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NIN)
         GOTO 60
      ENDIF
      CLOSE (UNIT = N10)
      OPEN (UNIT = N10, FILE = FILEX, IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = N10)
         GOTO 60
      ENDIF
C
C Copy PS file to FILEX
C
      JOS = 0
      DO WHILE (IOS.EQ.N0 .AND. JOS.EQ.N0)
         READ (NIN,200,IOSTAT=IOS) LINE
         IF (IOS.EQ.N0) WRITE (N10,200,IOSTAT=JOS) LINE
      ENDDO
      IOS = N0
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = N10)
C
C Copy Postscript file to temporary file FILE10
C
      IERROR = 2
C
C Connect PS file to NIN and FILE10 to UNIT10
C
      CALL GETTMP (IFAIL, FILE10)
      IOS = IFAIL
      IF (IFAIL.NE.N0) GOTO 60
      CLOSE (UNIT = NIN)
      OPEN (UNIT = NIN, FILE = FNAME(1), IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NIN)
         GOTO 60
      ENDIF
      CLOSE (UNIT = N10)
      OPEN (UNIT = N10, FILE = FILE10, IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = N10)
         GOTO 60
      ENDIF
C
C Copy PS file to FILE10
C
      JOS = N0
      DO WHILE (IOS.EQ.N0 .AND. JOS.EQ.N0)
         READ (NIN,200,IOSTAT=IOS) LINE
         IF (IOS.EQ.N0) WRITE (N10,200,IOSTAT=JOS) LINE
      ENDDO
      IOS = N0
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = N10)
C
C Open file and find bounding box coordinates
C
      IERROR = 3

      OPEN (UNIT = NIN, FILE = FILEX, STATUS = 'OLD', IOSTAT = IOS)
      IF (IOS.NE.N0) GOTO 60

      IERROR = 4

      CALL ISITPS (NIN, XSAV1, XSAV2, YSAV1, YSAV2, ABORT, IWARNU)
      IF (ABORT) GOTO 60

      IERROR = 5

      IF (XSAV1.GT.XSAV2 .OR. YSAV1.GT.YSAV2) GOTO 60
      CLOSE (UNIT = NIN)
      NUMDEC = 6
C
C LABEL 20: At this point NIN/FILEX is ready for repeated editing
C =========
C
   20 CONTINUE

      IERROR = 6

      IF (SHEAR) THEN
         STATUS = 'S*R*T: shearing'
      ELSE
         STATUS = 'R*S*T: no shearing'
      ENDIF
      NUMDEC = 6
      WRITE (TEXT,300) XTRANS, YTRANS, XSCALE, YSCALE, THETA, STATUS
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NUMDEC.EQ.1) THEN
         WRITE (LINE,400) XTRANS, YTRANS
         CALL GETD02 (XTRANS, YTRANS, 
     +               LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.2) THEN
         WRITE (LINE,500) XSCALE, YSCALE
         XTEMP = XSCALE
         YTEMP = YSCALE
         CALL GETD02 (XTEMP, YTEMP,
     +                LINE)
         IF (XTEMP.LT.EPSI .OR. YTEMP.LT.EPSI) THEN
            CALL PUTFAT$('Value(s) too small ... Try again')
         ELSE
            XSCALE = XTEMP
            YSCALE = YTEMP
         ENDIF
         GOTO 20
      ELSEIF (NUMDEC.EQ.3) THEN
         WRITE (LINE,600) THETA
         CALL GETDM1 (- F360, THETA, F360, 
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.4) THEN
         SHEAR = .NOT.SHEAR
         GOTO 20
      ELSEIF (NUMDEC.EQ.5) THEN
C
C Find the string/array pair to be edited
C
         CALL GETTXT$('Graphics text string to be edited', SEARCH)
         CALL STRGET$(NIN, N10,
     +                ARRAY, FILEX, FILE10, SEARCH(1:LEN200(SEARCH)),
     +                STRNG,
     +                ABORT)
         IF (.NOT.ABORT) THEN
C
C Edit the string/array then replace in FILE10/N10
C
            CALL STREDI$(ARRAY, STRNG)

            IERROR = 7

            BACKSPACE (UNIT = N10, ERR = 60, IOSTAT = IOS)
            IF (IOS.NE.N0) GOTO 60

            IERROR = 8

            BACKSPACE (UNIT = N10, ERR = 60, IOSTAT = IOS)

            IERROR = 9

            WRITE (N10,200,ERR=60,IOSTAT=IOS) STRNG(1:LEN200(STRNG))
            IF (IOS.NE.N0) GOTO 60

            IERROR = 10

            WRITE (N10,200,ERR=60,IOSTAT=IOS) ARRAY(1:LEN200(ARRAY))
            IF (IOS.NE.N0) GOTO 60
            IOS = N0

            IERROR = 11
C
C Carry on reading NIN and writing to N10
C
            JOS = N0
            DO WHILE (IOS.EQ.N0 .AND. JOS.EQ.N0)
               READ (NIN,200,IOSTAT=IOS) LINE
               IF (IOS.EQ.N0) WRITE (N10,200,IOSTAT=JOS) LINE
            ENDDO
C
C Now use FILE10/N10 to overwrite FILEX/NIN
C
            REWIND (UNIT = NIN)
            REWIND (UNIT = N10)
            IOS = N0

            IERROR = 12

            JOS = N0
            DO WHILE (IOS.EQ.N0 .AND. JOS.EQ.N0)
               READ (N10,200,IOSTAT=IOS) LINE
               IF (IOS.EQ.N0) WRITE (NIN,200,IOSTAT=JOS) LINE
            ENDDO
            CLOSE (UNIT = NIN)
            CLOSE (UNIT = N10)
         ENDIF
         GOTO 20
      ELSEIF (NUMDEC.EQ.9) THEN
         CALL EDITPS_ADVISE (ABORT, FIRST)
         GOTO 20
      ELSEIF (NUMDEC.EQ.NUMOPT) THEN
         ABORT = .FALSE.
         CALL YESNO2 (ICOLOR, IXL, IYL,
     +'This will end editing and restore the current file. Proceed ?',
     +   ABORT)
         IF (.NOT.ABORT) GOTO 20
         CALL DELEET (FILEX,
     +                ASKIF, THERE)
         CALL DELEET (FILE10,
     +                ASKIF, THERE)
         RETURN
      ENDIF
C
C SECTION 2: Main loop to drive printer or write file as required
C ==========
C
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
      IF (NUMDEC.EQ.6) THEN
         CALL EDITPS_LPTCOM (NOUT,
     +                       'VIEW',
     +                       ABORT)
      ELSEIF (NUMDEC.EQ.7) THEN
         CALL EDITPS_LPTCOM (NOUT,
     +                       'OPEN',
     +                       ABORT)
      ELSEIF (NUMDEC.EQ.8) THEN
         CALL EDITPS_LPTCOM (NOUT,
     +                       'FILE',
     +                       ABORT)
      ENDIF
      IF (ABORT) GOTO 20
C
C SECTION 3: Bounding Box and other coordinates then switch off showpage
C =========
C
      IF (ABS(THETA).LE.EPSI) THEN
C
C No rotation
C
         X1 = F72*XTRANS
         X2 = X1 + XSCALE*(XSAV2 - XSAV1)
         Y1 = F72*YTRANS
         Y2 = Y1 + YSCALE*(YSAV2 - YSAV1)
         WRITE (NOUT,700) NINT(X1), NINT(Y1), NINT(X2), NINT(Y2),
     +                    XSCALE, YSCALE,
     +                    F72*XTRANS/XSCALE - XSAV1,
     +                    F72*YTRANS/YSCALE - YSAV1
      ELSE
         IF (SHEAR) THEN
C
C Theta
C
            THETA1 = TWOPI*THETA/F360
            CTHETA = COS(THETA1)
            STHETA = SIN(THETA1)
C
C Initialise
C
            X2_START = XSAV2 - XSAV1
            Y2_START = YSAV2 - YSAV1
C
C Rotate
C
            XX1 = ZERO
            XX2 = CTHETA*X2_START
            XX3 = CTHETA*X2_START - STHETA*Y2_START
            XX4 = - STHETA*Y2_START
            YY1 = ZERO
            YY2 = STHETA*X2_START
            YY3 = STHETA*X2_START + CTHETA*Y2_START
            YY4 = CTHETA*Y2_START
C
C Scale
C
            XX2 = XSCALE*XX2
            XX3 = XSCALE*XX3
            XX4 = XSCALE*XX4
            YY2 = YSCALE*YY2
            YY3 = YSCALE*YY3
            YY4 = YSCALE*YY4
C
C Translate
C
             XX1 = XX1 + F72*XTRANS
             XX2 = XX2 + F72*XTRANS
             XX3 = XX3 + F72*XTRANS
             XX4 = XX4 + F72*XTRANS
             YY1 = YY1 + F72*YTRANS
             YY2 = YY2 + F72*YTRANS
             YY3 = YY3 + F72*YTRANS
             YY4 = YY4 + F72*YTRANS
         ELSE
            XX1 = F72*XTRANS
            YY1 = F72*YTRANS
            XTEMP = XSCALE*(XSAV2 - XSAV1)
            YTEMP = YSCALE*(YSAV2 - YSAV1)
            ZTEMP = SQRT(XTEMP**2 + YTEMP**2)
            THETA1 = TWOPI*THETA/F360
            XX2 = XX1 + XTEMP*COS(THETA1)
            YY2 = YY1 + XTEMP*SIN(THETA1)
            THETA1 = ATAN(YTEMP/XTEMP) + TWOPI*THETA/F360
            XX3 = XX1 + ZTEMP*COS(THETA1)
            YY3 = YY1 + ZTEMP*SIN(THETA1)
            THETA1 = PIBY2 + TWOPI*THETA/F360
            XX4 = XX1 + YTEMP*COS(THETA1)
            YY4 = YY1 + YTEMP*SIN(THETA1)
         ENDIF
         X1 = MIN(XX1, XX2, XX3, XX4)
         X2 = MAX(XX1, XX2, XX3, XX4)
         Y1 = MIN(YY1, YY2, YY3, YY4)
         Y2 = MAX(YY1, YY2, YY3, YY4)
C
C Write parameters to the file
C
         IF (SHEAR) THEN
            WRITE (NOUT,800) NINT(X1), NINT(Y1), NINT(X2), NINT(Y2),
     +                       F72*XTRANS, F72*YTRANS,
     +                       XSCALE, YSCALE,
     +                       THETA,
     +                       -XSAV1, -YSAV1
         ELSE
            WRITE (NOUT,900) NINT(X1), NINT(Y1), NINT(X2), NINT(Y2),
     +                       F72*XTRANS, F72*YTRANS,
     +                       THETA,
     +                       XSCALE, YSCALE,
     +                       -XSAV1, -YSAV1
         ENDIF
      ENDIF
C
C
C SECTION 4: Loop over file selected
C ==========
C

C
C Open file and discard first two lines
C
      CLOSE (UNIT = NIN)

      IERROR = 13

      OPEN (UNIT=NIN,FILE=FILEX,STATUS='OLD',ERR=60,IOSTAT=IOS)
      IF (IOS.NE.N0) GOTO 60

      IERROR = 14

      READ (NIN,200,END=60,ERR=60,IOSTAT=IOS) LINE
      IF (IOS.NE.N0) GOTO 60
      IOS = N0
C
C Read in from NIN and write out to NOUT until EOF
C
      IERROR = 15

      DO WHILE (IOS.EQ.N0)
         READ (NIN,200,END=40,ERR=40,IOSTAT=IOS) LINE
         IF (IOS.NE.N0) GOTO 40
         CALL TRIML1 (LINE)
         IF (LINE(1:14).NE.'%%BoundingBox:')
     +      WRITE (NOUT,200,ERR=40,IOSTAT=IOS) LINE
         IF (IOS.NE.N0) GOTO 40
      ENDDO
C
C LABEL 40: Close down the file on NIN
C =========
C
   40 CONTINUE
      CLOSE (UNIT = NIN)
C
C SECTION 5: Loop has gone through the file so switch showpage on again
C ==========
C
      IERROR = 16

      WRITE (NOUT,1000,ERR=60,IOSTAT=IOS)
      IF (IOS.NE.N0) GOTO 60
C
C SECTION 6: Drive the printer by copying the file on NOUT
C ==========
C
      CALL EDITPS_LPTCOM (NOUT,
     +                    'CLOSE', 
     +                    ABORT)
      GOTO 20
C
C LABEL 60: Crash
C =========
C
   60 CONTINUE
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = N10)
      WRITE (LINE,1100) IERROR, IOS
      CALL PUTFAT$(LINE)
C
C Format statements
C      
  200 FORMAT (A)
  300 FORMAT (
     + 'Current X-translation =',F8.2,' (inches)'
     +/'Current Y-translation =',F8.2,' (inches)'
     +/'Current X-scale factor =',F8.2
     +/'Current Y-scale factor =',F8.2
     +/'Current Rotation Angle =',F8.2,' (degrees)'
     +/'Current RST sequence =',4X,A
     +/'(T = translate, R = rotate, S = scale, * = concatenate)'
     +/
     +/'Change X,Y translation (margins)'
     +/'Change scaling factors (size)'
     +/'Change rotation angle (orientation)'
     +/'Change shearing status (perspective)'
     +/'Edit title/text/legend (Simfit files)'
     +/'View'
     +/'Print'
     +/'File'
     +/'Help'
     +/'Cancel')
  400 FORMAT ('X-, Y-translation required: current values',
     +F9.3,',',F9.3)
  500 FORMAT ('X-scale, Y-scale required: current values',
     +F9.3,',',F9.3)
  600 FORMAT ('Rotation angle required: current value', F9.3,' degrees')
  700 FORMAT (
     + '%!PS-Adobe-3.0 EPSF-3.0'
     +/'%%BoundingBox:',4I6
     +/'%%Creator: bill.bardsley@manchester.ac.uk'
     +/'%%Title: editps/simfit (6.09)'
     +/'%%EndComments'
     +/'save %save before switching off showpage'
     +/'/switchoffshowpage 20 dict def'
     +/'switchoffshowpage begin'
     +/'/showpage {} def'
     +/2F9.2,' scale'
     +/2F9.2,' translate')
C
C Next format gives a shear rotation
C
  800 FORMAT (
     + '%!PS-Adobe-3.0 EPSF-3.0'
     +/'%%BoundingBox:',4I6
     +/'%%Creator: bill.bardsley@manchester.ac.uk'
     +/'%%Title: editps/simfit (6.09))'
     +/'%%EndComments'
     +/'save %save before switching off showpage'
     +/'/switchoffshowpage 20 dict def'
     +/'switchoffshowpage begin'
     +/'/showpage {} def'
     +/2F9.2,' translate'
     +/2F9.2,' scale'
     +/F9.2,' rotate'
     +/2F9.2,' translate')
C
C Next format gives straight rotation
C
  900 FORMAT (
     + '%!PS-Adobe-3.0 EPSF-3.0'
     +/'%%BoundingBox:',4I6
     +/'%%Creator: bill.bardsley@manchester.ac.uk'
     +/'%%Title: editps/simfit (6.09)'
     +/'%%EndComments'
     +/'save %save before switching off showpage'
     +/'/switchoffshowpage 20 dict def'
     +/'switchoffshowpage begin'
     +/'/showpage {} def'
     +/2F9.2,' translate'
     +/F9.2,' rotate'
     +/2F9.2,' scale'
     +/2F9.2,' translate')
 1000 FORMAT (
     +'end %end of switchoffshowpage dictionary'
     +/'restore %restore to switch showpage back on'
     +/'showpage')
 1100 FORMAT ('Error number',I3,', IOSTAT =',I4,' in RESIZE')
      END
C
C------------------------------------------------------------------------------
C
      SUBROUTINE EDITPS_PS2LIB (NFILES, NIN, NSMALL, 
     +                          FSAV,
     +                          ABORT)
C
C ACTION: Use a library file to read in a set of PS files
C         Returns PS files in FSAV(NFILES)
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         10/01/2000 derived from LIBFIL
C         29/11/2001 added VU2CHK and FNLIB
C         08/01/2007 added call to SIMDIR
C         24/07/2007 changed SIMDIR to DEMDIR and trapped blank lines 
C         02/02/2008 added INTENTS
C         07/01/2009 renamed EDITPS_PS2LIB  
C
C         ABORT = .TRUE. if library file not usable
C         If NSMALL = 1 then just return a PS file  
C
C NFILES: (output) number of EPS files selected
C    NIN: (input/unchanged) unconnected unit for reading files
C NSMALL: (input/unchanged) dimension
C   FSAV: (output) Postscript files
C  ABORT: (output) error indicator
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NIN, NSMALL  
      INTEGER,             INTENT (OUT) :: NFILES 
      CHARACTER (LEN = *), INTENT (OUT) :: FSAV(NSMALL)
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    N0, N1, N3
      PARAMETER (N0 = 0, N1 = 1, N3 = 3)
      INTEGER    I, IADD1, IOS, ISEND, K, L, LEN200
      DOUBLE PRECISION X1, X2, Y1, Y2
      CHARACTER  LINE*100, TITLE*100
      CHARACTER  FNAME*1024, FNLIB*1024, SIMFIT*1024, TEMP*1024
      CHARACTER  BLANK*1, BSLASH*1
      PARAMETER (BLANK = ' ', BSLASH = '\')
      LOGICAL    IWARNU, YES
      PARAMETER (IWARNU = .FALSE.)
      EXTERNAL   CHECKF, OFILES, PUTADV, PUTFAT, TXT2FN, ISITPS, VU2CHK,
     +           DEMDIR, TRIML1, LEN200      
      INTRINSIC  INDEX   
C
C Part 1: First initialise ABORT and NFILES
C ======
C
      ABORT = .TRUE.
      NFILES = N0
      IF (NSMALL.LT.N1) RETURN
      DO I = N1, NSMALL
         FSAV(I) = BLANK
      ENDDO   
C
C Part 2: Check that the file seems to be a library file
C ======
C
      ISEND = N3
      CLOSE (UNIT = NIN)
      CALL OFILES (ISEND, NIN, 
     +             FNAME,
     +             ABORT)
      CLOSE (UNIT = NIN)
      IF (ABORT) RETURN
C
C Is it PS file ? ... if so then return silently
C
      OPEN (UNIT = NIN, FILE = FNAME)
      CALL ISITPS (NIN, 
     +             X1, X2, Y1, Y2, 
     +             ABORT, IWARNU)
      CLOSE (UNIT = NIN)
      IF (.NOT.ABORT) THEN
         NFILES = N1
         FSAV(N1) = FNAME
         RETURN
      ENDIF
      IF (NSMALL.EQ.N1) RETURN
C
C Is it a library file ?
C
      OPEN (UNIT = NIN, FILE = FNAME)
      FNLIB = FNAME
      READ (NIN,'(A)',IOSTAT=IOS) TITLE
      IF (IOS.NE.N0) THEN  
         WRITE (LINE,100)
         CALL PUTFAT (LINE) 
         CLOSE (UNIT = NIN)
         CALL VU2CHK (FNLIB)
         RETURN
      ENDIF
      CLOSE (UNIT = NIN)
      CALL CHECKF (FNAME, TITLE, 
     +             ABORT)
      IF (ABORT) THEN
         RETURN
      ELSE
         OPEN (UNIT = NIN, FILE = FNAME)
         READ (NIN,'(A)',IOSTAT=IOS) TITLE
      ENDIF
C
C Read in the file names
C
      IADD1 = N0
      IOS = N0
      DO WHILE (IOS.EQ.N0 .AND. IADD1.LT.NSMALL)
         ABORT = .TRUE.
         READ (NIN,'(A)',IOSTAT=IOS) FNAME
         IF (IOS.EQ.N0) THEN
            IF (FNAME.EQ.BLANK) THEN
               IOS = - N1
            ELSE   
               CALL TXT2FN (FNAME, 
     +                      ABORT)
               IF (ABORT) THEN                
                  WRITE (LINE,200)
                  CALL PUTFAT (LINE)
                  WRITE (LINE,300) I + N1
                  CALL PUTADV (LINE)
                  CLOSE (UNIT = NIN)
                  CALL VU2CHK (FNLIB)
                  RETURN
               ELSE
                  IADD1 = IADD1 + N1
                  FSAV(IADD1) = FNAME
               ENDIF
            ENDIF   
         ENDIF
      ENDDO
      CLOSE (UNIT = NIN)
      ABORT = .TRUE.
C
C Part 3: Check for files existing and PS format
C ======
C
      IF (IADD1.LE.N0) THEN    
         WRITE (LINE,400)
         CALL PUTFAT (LINE) 
         CALL VU2CHK (FNLIB)
         RETURN
      ENDIF 
      CALL DEMDIR (L,
     +             SIMFIT)       
      DO I = N1, IADD1
         INQUIRE (FILE = FSAV(I), EXIST = YES, IOSTAT = IOS)
         IF (L.GT.0 .AND. .NOT.YES .AND. 
     +       INDEX(FSAV(I),BSLASH).LT.N1) THEN
            TEMP = FSAV(I)
            CALL TRIML1 (TEMP)
            K = LEN200(TEMP)
            FSAV(I) = SIMFIT(N1:L)//TEMP(N1:K)
            INQUIRE (FILE = FSAV(I), EXIST = YES, IOSTAT = IOS)
         ENDIF   
         IF (YES .AND. IOS.EQ.N0) THEN
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FSAV(I))
            CALL ISITPS (NIN,
     +                   X1, X2, Y1, Y2, 
     +                   ABORT, IWARNU)
            IF (ABORT) THEN
               WRITE (LINE,300) I
               CALL PUTFAT (LINE)
               CLOSE (UNIT = NIN)
               RETURN
            ENDIF
            NFILES = NFILES + N1
            FSAV(NFILES) = FSAV(I)
         ELSE
            IOS = N1 
            WRITE (LINE,500)
            CALL PUTFAT (LINE)
         ENDIF
         IF (IOS.NE.N0) THEN
            WRITE (LINE,300) I + N1
            CALL PUTADV (LINE)
            ABORT = .TRUE.
            CLOSE (UNIT = NIN)
            CALL VU2CHK (FNLIB)
            RETURN
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
      CLOSE (UNIT = NIN)
C
C Set ABORT = .FALSE. if at least one file is satisfactory
C
      IF (NFILES.GT.N0) ABORT = .FALSE.
C
C Format statements
C      
  100 FORMAT ('Title not defined in supposed library file')
  200 FORMAT ('Filename not consistent with Operating System')
  300 FORMAT ('Not PS/EPS ... Check your library file at line',I4)
  400 FORMAT ('No files in library file')
  500 FORMAT ('File referenced in library file not found')
      END
C
C
