C
C EDITPS4.INS: PSADD1, PSCAPS, PSCHOP, PSCURL
C ===================================
C
C
C
      SUBROUTINE EDITPS_PSADD1 (ISEND, IX1BB, IX2BB, IY1BB, IY2BB,
     +                          NHIGH, NOUT, NWIDE, FNAME,
     +                          LEGEND, TXTNEW,
     +                          EXTRA)
C
C ACTION: Create a PS text file
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 18/05/2000
C         17/11/2003 replaced STARTP by RUN_GSVIEW
C         02/02/2008 added INTENTS 
C         07/01/2009 renamed EDITPS_PSADD1
C
C         ISEND = 1: View
C         ISEND = 2: Edit
C         ISEND = 3: X_margin
C         ISEND = 4: Y_margin
C         ISEND = 5: Width
C         ISEND = 6: Z_scale
C         ISEND = 7: PScodes
C         ISEND = 8: Help
C         ISEND = 9: include
C         ISEND = 10: suppress
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, NHIGH, NOUT,
     +                                       NWIDE
      INTEGER,             INTENT (INOUT) :: IX1BB, IX2BB, 
     +                                       IY1BB, IY2BB
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
      CHARACTER (LEN = *), INTENT (INOUT) :: LEGEND(NHIGH),
     +                                       TXTNEW(10*NHIGH)      
      LOGICAL,             INTENT (INOUT) :: EXTRA
C
C Locals
C      
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, NUMOPT = 10)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    JFONT, KFONT
      INTEGER    I, J, L, LEN200, NLEG, NNEW
      DOUBLE PRECISION X_MARGIN, Y_MARGIN, Z_SCALE, Z_WIDE
      DOUBLE PRECISION YSPACE, YSTOP
      PARAMETER       (YSPACE = 16.0D+00, YSTOP = 36.0D+00)
      DOUBLE PRECISION X, XDIFF, Y, YTEMP
      DOUBLE PRECISION PNT01
      PARAMETER (PNT01 = 0.01D+00)
      DOUBLE PRECISION F12, F14, F72
      PARAMETER (F12 = 12.0D+00, F14 = 14.0D+00, F72 = 72.0D+00)
      CHARACTER  LINE*120, TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, AGAIN, FILE, FIRST, READY
      PARAMETER (FIRST = .FALSE.)
      LOGICAL    WRAP, WRAP1
      PARAMETER (WRAP1 = .TRUE.)
      EXTERNAL   LBOX02, GETDGE, EDITTX, PUTADV, LEN200
      EXTERNAL   STRCHK$, STRPRN$, PSCODE$
      EXTERNAL   EDITPS_ADVISE, EDITPS_PSCHOP, EDITPS_PSCURL
      EXTERNAL   RUN_GSVIEW
      INTRINSIC  NINT, DBLE
      SAVE       NLEG, X_MARGIN, Y_MARGIN, Z_WIDE, Z_SCALE, READY
      DATA       NUMPOS / NUMOPT*1 /
      DATA       NLEG / 0 /
      DATA       X_MARGIN, Y_MARGIN / 3.5D+00, 0.5D+00 /
      DATA       Z_WIDE / 2.0D+00 /
      DATA       Z_SCALE / 1.0D+00 /
      DATA       READY / .FALSE. /
      IF (ISEND.LT.N1 .OR. ISEND.GT.NUMOPT) THEN
         RETURN
      ELSE
         NUMDEC = ISEND
      ENDIF
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         IF (ISEND.LT.NUMOPT - N2) THEN
            WRITE (TEXT,100) X_MARGIN, Y_MARGIN, Z_WIDE, Z_SCALE
            CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
         ENDIF
         IF (NUMDEC.EQ.1) THEN
C
C View
C
            IF (READY) THEN
               CALL RUN_GSVIEW (FNAME)
            ELSE
               CALL PUTADV ('File has not yet been created')
            ENDIF
            FILE = .FALSE.
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Edit
C
            CALL EDITTX (NHIGH, NLEG, NWIDE, LEGEND)
            IF (NLEG.GT.N0) THEN
               DO I = N1, NLEG
                 CALL STRCHK$(LEGEND(I))
                ENDDO
            ENDIF
            FILE =.TRUE.
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.3) THEN
C
C X_margin
C
            WRITE (LINE,200) 'X-start (in)', X_MARGIN
            CALL GETDGE (X_MARGIN, PNT01, LINE)
            FILE = .TRUE.
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Y-margin
C
            WRITE (LINE,200) 'Y-start (in)', Y_MARGIN
            CALL GETDGE (Y_MARGIN, PNT01, LINE)
            FILE = .TRUE.
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Linewidth
C
            WRITE (LINE,200) 'Linewidth (in)', Z_WIDE
            CALL GETDGE (Z_WIDE, PNT01, LINE)
            FILE = .TRUE.
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Scale
C
            WRITE (LINE,200) 'Scaling factor', Z_SCALE
            CALL GETDGE (Z_SCALE, PNT01, LINE)
            FILE = .TRUE.
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Show pscodes
C
            CALL PSCODE$
            FILE = .FALSE.
            NUMDEC = 2
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Help
C
            CALL EDITPS_ADVISE (ABORT, FIRST)
            FILE = .FALSE.
            NUMDEC = 2
         ELSE
C
C Proceed
C
            IF (NUMDEC.EQ.NUMOPT - N1) THEN
               EXTRA = .TRUE.
            ELSE
               EXTRA = .FALSE.
            ENDIF
            AGAIN = .FALSE.
            FILE = .TRUE.
         ENDIF
C
C Calculate PostScript parameters ... First X and Y
C
         IF (FILE) THEN
            X = X_MARGIN*F72
            Y = DBLE(NLEG + N2)*Z_SCALE*YSPACE + Y_MARGIN*F72
C
C Now XDIFF etc.
C

            YTEMP = Y - Z_SCALE*YSPACE
            XDIFF = Z_WIDE*F72*Z_SCALE
            IX1BB = NINT(X)
            IX2BB = NINT(X + XDIFF)
            IY2BB = NINT(Y)
            IY1BB = IY2BB - (NLEG + N2)*NINT(Z_SCALE*YSPACE)
            JFONT = NINT(F14*Z_SCALE)
            KFONT = NINT(F12*Z_SCALE)
C
C Main loop to drive printer or write file as required
C
            CLOSE (UNIT = NOUT)
            OPEN (UNIT = NOUT, FILE = FNAME)
C
C Bounding Box and other coordinates
C
            WRITE (NOUT,300) IX1BB, IY1BB, IX2BB, IY2BB
            WRAP = WRAP1
            IF (WRAP) THEN
C
C Initialise STRPRN$ to print strings
C
               CALL STRPRN$(JFONT, IX1BB, IX2BB, NINT(YTEMP), NOUT,
     +                      BLANK, 'OPEN')
C
C Initialise PSCURL to print {commands}
C
               L = 0
               CALL EDITPS_PSCURL (KFONT, L, NOUT, LINE)
C
C Chop out {commands}
C
               CALL EDITPS_PSCHOP (NHIGH, NNEW, TXTNEW, LEGEND)
               DO I = 1, NNEW
                  LINE = TXTNEW(I)
                  L = LEN200(LINE)
                  IF (LINE(1:1).EQ.'{' .AND. LINE(L:L).EQ.'}' .AND.
     +                L.GT.2) THEN
C
C Print {command} using PSCURL
C
                     CALL EDITPS_PSCURL (KFONT, L, NOUT, LINE)
                  ELSE
C
C Print ragged right using STRPRN$
C
                     CALL STRPRN$(JFONT, IX1BB, IX2BB, NINT(YTEMP),
     +                            NOUT, TXTNEW(I), BLANK)
                  ENDIF
               ENDDO
            ELSE
               DO I = 1, NLEG
                  IF (LEGEND(I).NE.BLANK .AND. YTEMP.GE.YSTOP) THEN
                     J = LEN200(LEGEND(I))
                     WRITE (NOUT,400) KFONT, NINT(X), NINT(YTEMP),
     +                                 LEGEND(I)(1:J)
                  ENDIF
                  YTEMP = YTEMP - Z_SCALE*YSPACE
               ENDDO
            ENDIF
            WRITE (NOUT,500)
C
C Close the file
C
            CLOSE (UNIT = NOUT)
C
C Return to main branch point
C
            READY = .TRUE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'View'
     +/'Edit'
     +/'Set X-start [',F8.3,' in]'
     +/'Set Y-start [',F8.3,' in]'
     +/'Set line width [',F8.3,' in]'
     +/'Set scale factor [',F8.3,']'
     +/'Display PS fonts and octal codes'
     +/'Help'
     +/'Accept (include extra file in overlay)'
     +/'Cancel (exclude extra file from overlay)')
  200 FORMAT (
     + 'New ',A,' required ( > 0.01 ): Current value =',F8.4)
  300 FORMAT (
     + '%!PS-Adobe-3.0 EPSF-3.0'
     +/'%%BoundingBox:',4I6
     +/'%%Creator: bill.bardsley@manchester.ac.uk'
     +/'%%Title: editps/simfit (Version 6.09)'
     +/'%%EndComments')
  400 FORMAT (
     +'/Times-Roman findfont',I5,' scalefont setfont'
     +/2I8,' moveto'
     +/'(',A,') show')
  500 FORMAT (
     +'showpage')
      END
C
C---------------------------------------------------------------------
C
      SUBROUTINE EDITPS_PSCAPS (NFILES,
     +                          CAPTSAV, CAPTION,
     +                         NEWDAT)
C
C ACTION: Edit collage captions
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 18/05/2000
C         02/02/2008 added INTENTS
C         07/01/2009 renamed EDITPS_PSCAPS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NFILES
      CHARACTER (LEN = *), INTENT (INOUT) :: CAPTSAV(NFILES),
     +                                       CAPTION(NFILES)      
      LOGICAL,             INTENT (IN)    :: NEWDAT
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N26, N30, N96
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N7 = 7, N26 = 26,
     +           N30 = 30, N96 = 96)
      INTEGER    ICOLOR, IX, IY, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, NUMOPT = 8)
      INTEGER    NUMPOS(N30)
      INTEGER    I, L, NDEC, NEXT, NFP1, NUMDEC
      INTEGER    LEN200
      CHARACTER  PREFIX*70, TEXT(N30)*100, CIPHER(N5)*11, WORD2*2
      CHARACTER  WORD72*72
      CHARACTER  BLANK*1, SELECT*10
      PARAMETER (BLANK = ' ', SELECT = '[Selected]')
      LOGICAL    AGAIN
      EXTERNAL   GETSTR, LBOX02, LEN200, TRIML1, PUTADV
      EXTERNAL   STRCHK$
      INTRINSIC  CHAR, MIN
      SAVE       CIPHER, PREFIX, NEXT
      DATA       NUMPOS / N30*N1 /
      DATA       CIPHER / N4*BLANK, N1*SELECT /
      DATA       PREFIX / 'Fig.' /
      DATA       NEXT / N1 /
      IF (NEWDAT) THEN
C
C Initialise if NEWDAT = .TRUE.
C
         DO I = N1, N4
            CIPHER(I) = BLANK
         ENDDO
         CIPHER(N5) = SELECT
         DO I = N1, NFILES
            CAPTION(I) = BLANK
         ENDDO
         NEXT = N1
         RETURN
      ENDIF
C
C o/w User chooses from a menu
C
      AGAIN = .TRUE.
      NUMDEC = NUMOPT
      DO WHILE (AGAIN)
         L = LEN200(PREFIX)
         IF (L.GT.N0) THEN
            WORD72 = '['//PREFIX(N1:L)//']'
         ELSE
            WORD72 = BLANK
         ENDIF
         WRITE (TEXT,100) (CIPHER(I), I = N1, N4), WORD72, CIPHER(N5)
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
         AGAIN = .TRUE.
         IF (NFILES.GT.N26) THEN
            IF (NUMDEC.EQ.N3 .OR. NUMDEC.EQ.N4) THEN
               CALL PUTADV ('There are only 26 letters in the alphabet')
            ENDIF
         ENDIF
         IF (NUMDEC.GE.N2.AND.NUMDEC.LE.N5 .OR. NUMDEC.EQ.N7) THEN
            DO I = N1, N5
               CIPHER(I) = BLANK
            ENDDO
         ENDIF
         IF (NUMDEC.EQ.N1) THEN
C
C Edit users captions
C
            IF (NEXT.GE.NFILES) NEXT = N1
            DO I = N1, NFILES
               WRITE (TEXT(I),200) I, CAPTSAV(I)
            ENDDO
            NFP1 = NFILES + N1
            TEXT(NFP1) = 'Cancel'
            NDEC = NEXT
            CALL LBOX02 (ICOLOR, IX, IY, NDEC, NFP1, NUMPOS, TEXT)
            IF (NDEC.LE.NFILES) THEN
               NEXT = NDEC + N1
               I = NDEC
               CALL GETSTR ('New figure caption required', CAPTSAV(I))
               CALL STRCHK$(CAPTION(I))
            ENDIF
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Users captions
C
            DO I = N1, NFILES
               CAPTION(I) = CAPTSAV(I)
            ENDDO
            CIPHER(N1) = SELECT
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Prefix-capitals
C
            L = LEN200(PREFIX)
            DO I = N1, MIN(N26,NFILES)
               IF (L.GT.N0) THEN
                  WRITE (CAPTION(I),300) PREFIX(N1:L), CHAR(64 + I)
               ELSE
                  WRITE (CAPTION(I),400) CHAR(64 + I)
               ENDIF
            ENDDO
            CIPHER(N2) = SELECT
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C Prefix-letters
C
            L = LEN200(PREFIX)
            DO I = N1, MIN(N26,NFILES)
               IF (L.GT.N0) THEN
                  WRITE (CAPTION(I),300) PREFIX(N1:L), CHAR(N96 + I)
               ELSE
                  WRITE (CAPTION(I),400) CHAR(N96 + I)
               ENDIF
            ENDDO
            CIPHER(N3) = SELECT
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C Pre-fix numbers
C
            L = LEN200(PREFIX)
            DO I = N1, NFILES
               WRITE (WORD2,500) I
               CALL TRIML1 (WORD2)
               IF (L.GT.N0) THEN
                  WRITE (CAPTION(I),300) PREFIX(N1:L), WORD2
               ELSE
                  WRITE (CAPTION(I),400) WORD2
               ENDIF
            ENDDO
            CIPHER(N4) = SELECT
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C Edit prefix
C
            CALL GETSTR ('New prefix required', PREFIX)
            CALL STRCHK$(PREFIX)
            DO I = N1, N4
               CIPHER(I) = BLANK
            ENDDO
            DO I = N1, NFILES
               CAPTION(I) = BLANK
            ENDDO
            CIPHER(N5) = SELECT
            CALL PUTADV (
     +'Now choose the caption type required for this new prefix')
            AGAIN = .TRUE.
            DO I = N1, N5
               IF (CIPHER(I).NE.BLANK) THEN
                  IF (I.LT.N5) THEN
                     NUMDEC = I + N1
                  ELSE
                     NUMDEC = N7
                  ENDIF
               ENDIF
            ENDDO
         ELSEIF (NUMDEC.EQ.N7) THEN
C
C Suppress captions
C
            DO I = N1, NFILES
               CAPTION(I) = BLANK
            ENDDO
            CIPHER(N5) = SELECT
            NUMDEC = NUMOPT
         ELSE
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Edit your captions'
     +/'Use your captions ',A
     +/'Use prefix-capitals ',A
     +/'Use prefix-lower case ',A
     +/'Use prefix-numbers ',A
     +/'Edit caption prefix ',A
     +/'Suppress all captions ',A
     +/'Apply')
  200 FORMAT (I2,':',A)
  300 FORMAT (A,1X,A)
  400 FORMAT (A)
  500 FORMAT (I2)
      END
C
C--------------------------------------------------------------------------------------
C
      SUBROUTINE EDITPS_PSCHOP (NMAX, NNEW, 
     +                          TXTNEW, TXTOLD)
C
C ACTION: Chop a string into pieces at {anything} for PS printing
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 11/05/2000
C         02/02/2008 added INTENTS
C         07/01/2009 renamed EDITPS_PSCHOP
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NMAX
      INTEGER,             INTENT (OUT)   :: NNEW
      CHARACTER (LEN = *), INTENT (IN)    :: TXTOLD(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: TXTNEW(10*NMAX)
C
C Locals
C      
      INTEGER    I, IADD1, L, NSTART, NSTOP
      INTEGER    NBIG
      PARAMETER (NBIG = 500)
      CHARACTER  STRNG*100, TEMP*100, TXTCPY(NBIG)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      INTRINSIC  INDEX, LEN
C
C Initialise NNEW then copy the text except for blank lines
C
      NNEW = 0
      IADD1 = 0
      DO I = 1, NMAX
         IF (TXTOLD(I).NE.BLANK) THEN
            IADD1 = IADD1 + 1
            TXTCPY(IADD1) = TXTOLD(I)
         ENDIF
      ENDDO
C
C Return if no blank lines
C
      IF (IADD1.EQ.0) RETURN
C
C Parse the strings
C
      L = LEN(TXTOLD(1))
      DO I = 1, IADD1
         STRNG = TXTCPY(I)
         NSTART = INDEX(STRNG, '{')
         NSTOP = INDEX(STRNG, '}')
         DO WHILE (NSTOP.GT.NSTART)
            IF (NSTART.GT.1) THEN
               TEMP = STRNG(1:NSTART - 1)
               IF (TEMP.NE.BLANK) THEN
                  NNEW = NNEW + 1
                  TXTNEW(NNEW) = TEMP
               ENDIF
            ENDIF
            NNEW = NNEW + 1
            TXTNEW(NNEW) = STRNG(NSTART:NSTOP)
            IF (NSTOP.LT.L) THEN
               TEMP = STRNG(NSTOP + 1:L)
               STRNG = TEMP
               NSTART = INDEX(STRNG, '{')
               NSTOP = INDEX(STRNG, '}')
            ELSE
               STRNG = BLANK
               NSTART = 0
               NSTOP = 0
            ENDIF
         ENDDO
         IF (STRNG.NE.BLANK) THEN
            NNEW = NNEW + 1
            TXTNEW(NNEW) = STRNG
         ENDIF
      ENDDO
      END
C
C--------------------------------------------------------------------
C
      SUBROUTINE EDITPS_PSCURL (KFONT, L, NOUT,
     +                          TEXT)
C
C ACTION : Print curly brackets from PSCHOP
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 16/05/2000
C          07.01/2009 renamed EDITPS_PSCURL
C          L <= 0: write the font information to NOUT
C          L > 0 : Write {command} to NOUT
C
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: KFONT, L, NOUT
      CHARACTER (LEN = *), INTENT (IN) :: TEXT
C
C Locals
C      
      CHARACTER LINE*100, STRNG*100
      IF (L.LE.0) THEN
C
C Part 1: initialise the PS file by writing out the header
C =======
C
         WRITE (NOUT,100) KFONT
         WRITE (NOUT,200)
         WRITE (NOUT,300)
         WRITE (NOUT,400)
         WRITE (NOUT,500)
         WRITE (NOUT,600)
         WRITE (NOUT,700)
         WRITE (NOUT,800)
         WRITE (NOUT,900)
         WRITE (NOUT,1000)
         WRITE (NOUT,1100)
         WRITE (NOUT,1200)
         WRITE (NOUT,1300)
      ELSE
C
C Part 2: build up the output file
C =======
C
         LINE = TEXT
C
C newline...
C
         IF (LINE(1:L).EQ.'{newline}') THEN
            WRITE (NOUT,'(A)') ' newline '
C
C fonts...
C
         ELSEIF (LINE(1:L).EQ.'{roman}') THEN
            WRITE (NOUT,'(A)') ' roman '
         ELSEIF (LINE(1:L).EQ.'{bold}') THEN
            WRITE (NOUT,'(A)') ' bold '
         ELSEIF (LINE(1:L).EQ.'{italic}') THEN
            WRITE (NOUT,'(A)') ' italic '
         ELSEIF (LINE(1:L).EQ.'{helvetica}') THEN
            WRITE (NOUT,'(A)') ' helvetica '
         ELSEIF (LINE(1:L).EQ.'{helveticabold}') THEN
            WRITE (NOUT,'(A)') ' helveticabold '
         ELSEIF (LINE(1:L).EQ.'{helveticaoblique}') THEN
            WRITE (NOUT,'(A)') ' helveticaoblique '
         ELSEIF (LINE(1:L).EQ.'{symbol}') THEN
            WRITE (NOUT,'(A)') ' symbol '
         ELSEIF (LINE(1:L).EQ.'{zapfchancery}') THEN
            WRITE (NOUT,'(A)') ' zapfchancery '
         ELSEIF (LINE(1:L).EQ.'{zapfdingbats}') THEN
            WRITE (NOUT,'(A)') ' zapfdingbats '
         ELSEIF (LINE(1:L).EQ.'{isolatin1}') THEN
            WRITE (NOUT,'(A)') ' isolatin1 '
C
C coordinates...
C
         ELSEIF (LINE(1:L).EQ.'{increase}') THEN
            WRITE (NOUT,'(A)') ' increase '
         ELSEIF (LINE(1:L).EQ.'{decrease}') THEN
            WRITE (NOUT,'(A)') ' decrease '
         ELSEIF (LINE(1:L).EQ.'{raise}') THEN
            WRITE (NOUT,'(A)') ' raise '
         ELSEIF (LINE(1:L).EQ.'{lower}') THEN
            WRITE (NOUT,'(A)') ' lower '
         ELSEIF (LINE(1:L).EQ.'{expand}') THEN
            WRITE (NOUT,'(A)') ' expand '
         ELSEIF (LINE(1:L).EQ.'{contract}') THEN
            WRITE (NOUT,'(A)') ' contract '
C
C { and }...
C
         ELSEIF (LINE(1:L).EQ.'{left}') THEN
            WRITE (NOUT,'(A)') '({)p'
         ELSEIF (LINE(1:L).EQ.'{right}') THEN
            WRITE (NOUT,'(A)') '(})p'
C
C plotting symbols...
C
         ELSEIF (LINE(1:L).EQ.'{ce}') THEN
            WRITE (NOUT,'(A)') ' ce '
         ELSEIF (LINE(1:L).EQ.'{ch}') THEN
            WRITE (NOUT,'(A)') ' ch '
         ELSEIF (LINE(1:L).EQ.'{cf}') THEN
            WRITE (NOUT,'(A)') ' cf '
         ELSEIF (LINE(1:L).EQ.'{te}') THEN
            WRITE (NOUT,'(A)') ' te '
         ELSEIF (LINE(1:L).EQ.'{th}') THEN
            WRITE (NOUT,'(A)') ' th '
         ELSEIF (LINE(1:L).EQ.'{tf}') THEN
            WRITE (NOUT,'(A)') ' tf '
         ELSEIF (LINE(1:L).EQ.'{se}') THEN
            WRITE (NOUT,'(A)') ' se '
         ELSEIF (LINE(1:L).EQ.'{sh}') THEN
            WRITE (NOUT,'(A)') ' sh '
         ELSEIF (LINE(1:L).EQ.'{sf}') THEN
            WRITE (NOUT,'(A)') ' sf '
         ELSEIF (LINE(1:L).EQ.'{de}') THEN
            WRITE (NOUT,'(A)') ' de '
         ELSEIF (LINE(1:L).EQ.'{dh}') THEN
            WRITE (NOUT,'(A)') ' dh '
         ELSEIF (LINE(1:L).EQ.'{df}') THEN
            WRITE (NOUT,'(A)') ' df '
C
C lines...
C
         ELSEIF (LINE(1:L).EQ.'{li}') THEN
            WRITE (NOUT,'(A)') ' li '
         ELSEIF (LINE(1:L).EQ.'{da}') THEN
            WRITE (NOUT,'(A)') ' da '
         ELSEIF (LINE(1:L).EQ.'{do}') THEN
            WRITE (NOUT,'(A)') ' do '
         ELSEIF (LINE(1:L).EQ.'{dd}') THEN
            WRITE (NOUT,'(A)') ' dd '
C
C currency...
C
         ELSEIF (LINE(1:L).EQ.'{dollar}') THEN
            WRITE (NOUT,'(A)') ' dollar '
         ELSEIF (LINE(1:L).EQ.'{sterling}') THEN
            WRITE (NOUT,'(A)') ' sterling '
         ELSEIF (LINE(1:L).EQ.'{yen}') THEN
            WRITE (NOUT,'(A)') ' yen '
C
C maths...
C
         ELSEIF (LINE(1:L).EQ.'{divide}') THEN
            WRITE (NOUT,'(A)') ' divide '
         ELSEIF (LINE(1:L).EQ.'{multiply}') THEN
            WRITE (NOUT,'(A)') ' multiply '
         ELSEIF (LINE(1:L).EQ.'{plusminus}') THEN
            WRITE (NOUT,'(A)') ' plusminus '
C
C units...
C
         ELSEIF (LINE(1:L).EQ.'{Angstrom}') THEN
            WRITE (NOUT,'(A)') ' Angstrom '
         ELSEIF (LINE(1:L).EQ.'{degree}') THEN
            WRITE (NOUT,'(A)') ' degree '
         ELSEIF (LINE(1:L).EQ.'{micron}') THEN
            WRITE (NOUT,'(A)') ' micron '
C
C punctuation...
C
         ELSEIF (LINE(1:L).EQ.'{section}') THEN
            WRITE (NOUT,'(A)') ' section '
         ELSEIF (LINE(1:L).EQ.'{dagger}') THEN
            WRITE (NOUT,'(A)') ' dagger '
         ELSEIF (LINE(1:L).EQ.'{daggerdbl}') THEN
            WRITE (NOUT,'(A)') ' daggerdbl '
         ELSEIF (LINE(1:L).EQ.'{questiondown}') THEN
            WRITE (NOUT,'(A)') ' questiondown '
C
C continental...
C

         ELSEIF (LINE(1:L).EQ.'{Aacute}') THEN
            WRITE (NOUT,'(A)') ' Aacute '
         ELSEIF (LINE(1:L).EQ.'{agrave}') THEN
            WRITE (NOUT,'(A)') ' agrave '
         ELSEIF (LINE(1:L).EQ.'{aacute}') THEN
            WRITE (NOUT,'(A)') ' aacute '
         ELSEIF (LINE(1:L).EQ.'{acircumflex}') THEN
            WRITE (NOUT,'(A)') ' acircumflex '
         ELSEIF (LINE(1:L).EQ.'{atilde}') THEN
            WRITE (NOUT,'(A)') ' atilde '
         ELSEIF (LINE(1:L).EQ.'{adieresis}') THEN
            WRITE (NOUT,'(A)') ' adieresis '
         ELSEIF (LINE(1:L).EQ.'{aring}') THEN
            WRITE (NOUT,'(A)') ' aring '
         ELSEIF (LINE(1:L).EQ.'{ae}') THEN
            WRITE (NOUT,'(A)') ' ae '
         ELSEIF (LINE(1:L).EQ.'{ccedilla}') THEN
            WRITE (NOUT,'(A)') ' ccedilla '
         ELSEIF (LINE(1:L).EQ.'{egrave}') THEN
            WRITE (NOUT,'(A)') ' egrave '
         ELSEIF (LINE(1:L).EQ.'{eacute}') THEN
            WRITE (NOUT,'(A)') ' eacute '
         ELSEIF (LINE(1:L).EQ.'{ecircumflex}') THEN
            WRITE (NOUT,'(A)') ' ecircumflex '
         ELSEIF (LINE(1:L).EQ.'{edieresis}') THEN
            WRITE (NOUT,'(A)') ' edieresis '
         ELSEIF (LINE(1:L).EQ.'{ecircumflex}') THEN
            WRITE (NOUT,'(A)') ' ecircumflex '
         ELSEIF (LINE(1:L).EQ.'{edieresis}') THEN
            WRITE (NOUT,'(A)') ' edieresis '
         ELSEIF (LINE(1:L).EQ.'{igrave}') THEN
            WRITE (NOUT,'(A)') ' igrave '
         ELSEIF (LINE(1:L).EQ.'{iacute}') THEN
            WRITE (NOUT,'(A)') ' iacute '
         ELSEIF (LINE(1:L).EQ.'{icircumflex}') THEN
            WRITE (NOUT,'(A)') ' icircumflex '
         ELSEIF (LINE(1:L).EQ.'{idieresis}') THEN
            WRITE (NOUT,'(A)') ' idieresis '
         ELSEIF (LINE(1:L).EQ.'{ntilde}') THEN
            WRITE (NOUT,'(A)') ' ntilde '
         ELSEIF (LINE(1:L).EQ.'{ograve}') THEN
            WRITE (NOUT,'(A)') ' ograve '
         ELSEIF (LINE(1:L).EQ.'{oacute}') THEN
            WRITE (NOUT,'(A)') ' oacute '
         ELSEIF (LINE(1:L).EQ.'{ocircumflex}') THEN
            WRITE (NOUT,'(A)') ' ocircumflex '
         ELSEIF (LINE(1:L).EQ.'{otilde}') THEN
            WRITE (NOUT,'(A)') ' otilde '
         ELSEIF (LINE(1:L).EQ.'{adieresis}') THEN
            WRITE (NOUT,'(A)') ' odieresis '
         ELSEIF (LINE(1:L).EQ.'{ugrave}') THEN
            WRITE (NOUT,'(A)') ' ugrave '
         ELSEIF (LINE(1:L).EQ.'{uacute}') THEN
            WRITE (NOUT,'(A)') ' uacute '
         ELSEIF (LINE(1:L).EQ.'{ucircumflex}') THEN
            WRITE (NOUT,'(A)') ' ucircumflex '
         ELSEIF (LINE(1:L).EQ.'{udieresis') THEN
            WRITE (NOUT,'(A)') ' udieresis '
C
C symbol font...
C
         ELSEIF (LINE(1:L).EQ.'{alpha}') THEN
            WRITE (NOUT,'(A)') ' alpha '
         ELSEIF (LINE(1:L).EQ.'{beta}') THEN
            WRITE (NOUT,'(A)') ' beta '
         ELSEIF (LINE(1:L).EQ.'{chi}') THEN
            WRITE (NOUT,'(A)') ' chi '
         ELSEIF (LINE(1:L).EQ.'{delta}') THEN
            WRITE (NOUT,'(A)') ' delta '
         ELSEIF (LINE(1:L).EQ.'{epsilon}') THEN
            WRITE (NOUT,'(A)') ' epsilon '
         ELSEIF (LINE(1:L).EQ.'{phi}') THEN
            WRITE (NOUT,'(A)') ' phi '
         ELSEIF (LINE(1:L).EQ.'{gamma}') THEN
            WRITE (NOUT,'(A)') ' gamma '
         ELSEIF (LINE(1:L).EQ.'{eta}') THEN
            WRITE (NOUT,'(A)') ' eta '
         ELSEIF (LINE(1:L).EQ.'{kappa}') THEN
            WRITE (NOUT,'(A)') ' kappa '
         ELSEIF (LINE(1:L).EQ.'{lambda}') THEN
            WRITE (NOUT,'(A)') ' lambda '
         ELSEIF (LINE(1:L).EQ.'{mu}') THEN
            WRITE (NOUT,'(A)') ' mu '
         ELSEIF (LINE(1:L).EQ.'{nu}') THEN
            WRITE (NOUT,'(A)') ' nu '
         ELSEIF (LINE(1:L).EQ.'{pi}') THEN
            WRITE (NOUT,'(A)') ' pi '
         ELSEIF (LINE(1:L).EQ.'{theta}') THEN
            WRITE (NOUT,'(A)') ' theta '
         ELSEIF (LINE(1:L).EQ.'{rho}') THEN
            WRITE (NOUT,'(A)') ' rho '
         ELSEIF (LINE(1:L).EQ.'{sigma}') THEN
            WRITE (NOUT,'(A)') ' sigma '
         ELSEIF (LINE(1:L).EQ.'{tau}') THEN
            WRITE (NOUT,'(A)') ' tau '
         ELSEIF (LINE(1:L).EQ.'{omega}') THEN
            WRITE (NOUT,'(A)') ' omega '
         ELSEIF (LINE(1:L).EQ.'{psi}') THEN
            WRITE (NOUT,'(A)') ' psi '
C
C L > 4
C =====
C
         ELSEIF (L.GT.4) THEN
            IF (LINE(2:3).EQ.'%!') THEN
C
C PostScript...
C
               STRNG = ' '//LINE(4:L - 1)//' '
               WRITE (NOUT,'(A)') STRNG
            ELSEIF (LINE(2:4).EQ.'pmb') THEN
C
C poor man's bold...
C
               STRNG = '('//LINE(5:L - 1)//')pmb'
               WRITE (NOUT,'(A)') STRNG
            ELSE
C
C literal (L > 4)
C ===============
C
               STRNG = '('//LINE(2:L - 1)//')p'
               WRITE (NOUT,'(A)') STRNG
           ENDIF
         ELSE
C
C literal (L < = 4)
C =================
C
           STRNG = '('//LINE(2:L - 1)//')p'
           WRITE (NOUT,'(A)') STRNG
         ENDIF
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     +/'%parameters'
     +/'/si',I4,' def                                %font size'
     +/'/fo /Times-Roman def                       %define font'
     +/'/in {fo findfont si scalefont setfont} def %install font')
  200 FORMAT (
     +/'%fonts'
     +/'/roman {/fo /Times-Roman def in} def'
     +/'/bold {/fo /Times-Bold def in} def'
     +/'/italic {/fo /Times-Italic def in} def'
     +/'/helvetica {/fo /Helvetica def in} def'
     +/'/helveticabold {/fo /Helvetica-Bold def in} def'
     +/'/helveticaoblique {/fo /Helvetica-Oblique def in} def'
     +/'/symbol {/fo /Symbol def in} def'
     +/'/zapfchancery {/fo /ZapfChancery def in} def'
     +/'/zapfdingbats {/fo /ZapfDingbats def in} def'
     +/'%ISOLatin1Encoding'
     +/'/isolatin1 {/ISOLatin1Encoding where'
     +/'           {pop fo findfont dup length dict begin'
     +/'           {1 index /FID ne {def} {pop pop} ifelse} forall'
     +/'            /Encoding ISOLatin1Encoding def currentdict end'
     +/'            /ISO exch definefont pop'
     +/'            /ISO findfont si scalefont setfont} if} def')
  300 FORMAT (
     +/'%coordinates'
     +/'/increase {si 1 add /si exch def in} def'
     +/'/decrease {si 1 sub /si exch def in} def'
     +/'/raise {0 lineheight 7 div rmoveto} def'
     +/'/lower {0 lineheight 7 div neg rmoveto} def'
     +/'/expand {lineheight 1 add /lineheight exch def} def'
     +/'/contract {lineheight 1 sub /lineheight exch def} def')
  400 FORMAT (
     +/'%poor man''s bold'
     +/'/pmb {dup stringwidth pop /x exch def dup p'
     +/'      x -.95 mul 0 rmoveto dup show'
     +/'      x -1.025 mul x -.025 mul rmoveto show'
     +/'      x .025 mul dup rmoveto} def')
  500 FORMAT (
     +/'%symbols'
     +/'/c1 {(M) stringwidth pop 2 div /z exch def /r z .75 mul def'
     +/'     z r rmoveto currentpoint /y exch def /x exch def} def'
     +/'/c2 {c1 gsave newpath x y r 0 360 arc stroke} def'
     +/'/c3 {z r neg rmoveto} def'
     +/'/ce {c2 grestore c3} def'
     +/'/ch {c2 newpath x y r 270 90 arc fill grestore c3} def'
     +/'/cf {c2 newpath x y r 0 360 arc fill grestore c3} def'
     +/'/t1 {c1 r r mul 4 mul 3 div sqrt /u exch def x u sub /a exch'
     +/'     def y r sub /b exch def r 2 mul /c exch def} def'
     +/'/t2 {t1 gsave newpath a b moveto u c rlineto u c neg rlineto'
     +/'     closepath stroke} def'
     +/'/t3 {grestore x y moveto c3} def'
     +/'/t4 {u c neg rlineto closepath fill t3} def'
     +/'/te {t2 t3} def'
     +/'/th {t2 newpath x b moveto 0 c rlineto t4} def'
     +/'/tf {t2 newpath a b moveto u c rlineto t4} def')
  600 FORMAT (
     + '/s1 {c1 r 2 mul /c exch def gsave newpath x r sub y r sub',
     +' moveto'
     +/'     0 c rlineto c 0 rlineto 0 c neg rlineto closepath',
     +' stroke} def'
     +/'/se {s1 t3} def'
     +/'/sh {s1 newpath x y r sub moveto 0 c rlineto r 0 rlineto 0 c',
     +' neg'
     +/'     rlineto closepath fill t3} def'
     +/'/sf {s1 newpath x r sub y r sub moveto 0 c rlineto c 0',
     +' rlineto 0'
     +/'     c neg rlineto closepath fill t3} def'
     +/'/d1 {c1 gsave newpath x y r sub moveto r neg r rlineto r r',
     +' rlineto'
     +/'     r r neg rlineto r neg dup rlineto closepath stroke} def'
     +/'/de {d1 t3} def'
     +/'/dh {d1 newpath x y r sub moveto 0 r 2 mul rlineto r r neg'
     +/'     rlineto closepath fill t3} def'
     +/'/df {d1 newpath x y r sub moveto r neg r rlineto r r rlineto'
     +/'     r r neg rlineto closepath fill t3} def')
  700 FORMAT (
     +/'%lines'
     +/'/l1 {(MM) stringwidth pop /d exch def d 4 div .75 mul /r exch'
     +/'     def currentpoint r add /y1 exch def /x1 exch def /x2 {x1 d'
     +/'     add} def /y2 y1 def gsave newpath x1 y1 moveto} def'
     +/'/l2 {x2 y2 lineto stroke grestore x2 y2 r sub moveto} def'
     +/'/li {l1 l2} def'
     +/'/da {l1 [4.5 3] 0 setdash l2} def'
     +/'/do {l1 [1.5 3] 0 setdash l2} def'
     +/'/dd {l1 [4.5 3 1.5 3] 0 setdash l2} def')
  800 FORMAT (
     +/'%currency'
     +/'/f1 {isolatin1} def'
     +/'/f2 {show in} def'
     +/'/dollar   {f1 (\044) f2} def'
     +/'/sterling {f1 (\243) f2} def'
     +/'/yen      {f1 (\245) f2} def'
     +/
     +/'%maths'
     +/'/divide    {f1 (\367) f2} def'
     +/'/multiply  {f1 (\327) f2} def'
     +/'/plusminus {f1 (\261) f2} def'
     +/
     +/'%units'
     +/'/Angstrom {f1 (\305) f2} def'
     +/'/degree   {f1 (\260) f2} def'
     +/'/micron   {f1 (\265) f2} def')
  900 FORMAT (
     +/'%punctuation'
     +/'/section      {f1 (\247) f2} def'
     +/'/dagger       {f1 (\262) f2} def'
     +/'/daggerdbl    {f1 (\263) f2} def'
     +/'/paragraph    {f1 (\266) f2} def'
     +/'/questiondown {f1 (\277) f2} def')
 1000 FORMAT (
     +/'%continental'
     +/'/Aacute       {f1 (\301) f2} def'
     +/'/agrave       {f1 (\340) f2} def'
     +/'/aacute       {f1 (\341) f2} def'
     +/'/acircumflex  {f1 (\342) f2} def'
     +/'/atilde       {f1 (\343) f2} def'
     +/'/adieresis    {f1 (\344) f2} def'
     +/'/aring        {f1 (\345) f2} def'
     +/'/ae           {f1 (\346) f2} def'
     +/'/ccedilla     {f1 (\347) f2} def')
 1100 FORMAT (
     + '/egrave       {f1 (\350) f2} def'
     +/'/eacute       {f1 (\351) f2} def'
     +/'/ecircumflex  {f1 (\352) f2} def'
     +/'/edieresis    {f1 (\353) f2} def'
     +/'/igrave       {f1 (\354) f2} def'
     +/'/iacute       {f1 (\355) f2} def'
     +/'/icircumflex  {f1 (\356) f2} def'
     +/'/idieresis    {f1 (\357) f2} def'
     +/'/ntilde       {f1 (\361) f2} def'
     +/'/ograve       {f1 (\362) f2} def'
     +/'/oacute       {f1 (\363) f2} def'
     +/'/ocircumflex  {f1 (\364) f2} def'
     +/'/otilde       {f1 (\365) f2} def'
     +/'/odieresis    {f1 (\366) f2} def'
     +/'/ugrave       {f1 (\371) f2} def'
     +/'/uacute       {f1 (\372) f2} def'
     +/'/ucircumflex  {f1 (\373) f2} def'
     +/'/udieresis    {f1 (\374) f2} def')
 1200 FORMAT (
     +/'%symbol'
     +/'/g1 {/font fo def symbol} def'
     +/'/g2 {show /fo font def in} def'
     +/'/alpha   {g1 (\141) g2} def'
     +/'/beta    {g1 (\142) g2} def'
     +/'/chi     {g1 (\143) g2} def'
     +/'/delta   {g1 (\144) g2} def'
     +/'/epsilon {g1 (\145) g2} def'
     +/'/phi     {g1 (\146) g2} def'
     +/'/gamma   {g1 (\147) g2} def'
     +/'/eta     {g1 (\150) g2} def'
     +/'/kappa   {g1 (\153) g2} def'
     +/'/lambda  {g1 (\154) g2} def'
     +/'/mu      {g1 (\155) g2} def'
     +/'/nu      {g1 (\156) g2} def'
     +/'/pi      {g1 (\160) g2} def'
     +/'/theta   {g1 (\161) g2} def'
     +/'/rho     {g1 (\162) g2} def'
     +/'/sigma   {g1 (\163) g2} def'
     +/'/tau     {g1 (\164) g2} def'
     +/'/omega   {g1 (\167) g2} def'
     +/'/psi     {g1 (\171) g2} def')
 1300 FORMAT (
     +/'%initialise'
     +/'in 1 setlinewidth'
     +/' '
     +/'%data'/)
      END
C
C
