C
C
C     INCLUDE 'dllchk.for'
C
C
      PROGRAM MAIN
C
C
C VERSION: details from SIMVER/DLLCHK
C ACTION : Gather together SIMFIT ps files
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,28/3/95
C          05/11/1995 Added 1, 2 3 columnn mode, x_start, y_height, z_scale
C          20/12/1995 Added text editing and key editing
C          09/02/1996 Changed switchoffshowpage 1 to 20
C          26/07/1997 win32 version
C          29/01/1998 Turned off topmost and added interface to GSview
C          01/04/1998 Sorted out BoundingBox calculation
C          07/08/1998 added dllchk
C          05/09/1998 added ps2??? routines
C          14/12/1998 replaced TUTORS by TUTOR1
C          13/09/1999 added call to WINDOW
C          09/01/2000 added PS2LIB for library file option
C          12/02/2000 added call to SIMVER
C          11/05/2000 added TXTNEW and PSCHOP to COL123
C          03/06/2000 added EPHELP and PSCURL and extensive revision
C          08/07/2000 added formatting to captions and title
C          25/02/2001 added calls to PFILES to access project files
C                     and separated FNAMES into FNAME1 and FNAME2
C          01/03/2002 reverted to %ww[maxmise,no_minbox,topmost]
C          07/04/2003 added quotes to GSVIEW filename
C          28/07/2005 increased DVER to *30 and added in call to ADVISE
C          01/02/2008 minor editing
C          07/01/2009 renamed and moved extra code into DLL 
C          04/04/2009 added PS2SVG      
C
C
      IMPLICIT   NONE
      INTEGER    NIN, NMAX, NOUT, N0, N1, N2
      PARAMETER (NIN = 3, NMAX = 50, NOUT = 4, N0 = 0, N1 = 1, N2 = 2)
      INTEGER    NHIGH, NWIDE
      PARAMETER (NHIGH = 2*NMAX + 4, NWIDE = 80)
      INTEGER    NTITLE
      PARAMETER (NTITLE = 5)
      INTEGER    ISEND, NFILES, NSAV1, NSAV2
      INTEGER    IXCAPT(NMAX), IYCAPT(NMAX)
      DOUBLE PRECISION W_START, X_START, Y_START, Z_START
      PARAMETER (W_START = 5.50D+00, X_START = 1.125D+00,
     +           Y_START = 10.75D+00, Z_START = 1.0D+00)
      DOUBLE PRECISION ZERO, HALF, ONE
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00)
      DOUBLE PRECISION BBOXX(N2,NMAX + N1), BBOXY(N2,NMAX + N1),
     +                 XTRANS(NMAX + N1),
     +                 YTRANS(NMAX + N1), ZSCALE(NMAX + N1)
      DOUBLE PRECISION X_MARGIN, Y_HEIGHT, Z_SCALE
      DOUBLE PRECISION XX_MARGIN, YY_HEIGHT, ZZ_SCALE, ZZ_WIDE
      DOUBLE PRECISION XVER, YVER
      CHARACTER  FNAME1(NMAX)*1024, FNAME2(NMAX)*1024, FNAME3*1024
      CHARACTER  CAPTION(NMAX)*(NWIDE), LEGEND(NHIGH)*(NWIDE),
     +           TITLE(NTITLE)*(NWIDE)
      CHARACTER  CAPTSAV(NMAX)*(NWIDE), TXTNEW(10*NHIGH)*(NWIDE)
      CHARACTER  TXTCPY(NHIGH)*(NWIDE)
      CHARACTER  OLDTXT(NHIGH)*(NWIDE), NEWTXT(10*NHIGH)*(NWIDE)
      CHARACTER  XTRA1*1024
      CHARACTER  XTRA2(NHIGH)*(NWIDE), XTRA3(10*NHIGH)*(NWIDE)
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_editps.exe')
      CHARACTER  BLANK*1, PNAME*6
      PARAMETER (BLANK = ' ', PNAME = 'EDITPS')
      LOGICAL    ABORT, ACTION, AGAIN, FIRST, SHOW, THERE  
      LOGICAL    ASKIF, SUPPLY
      PARAMETER (ASKIF = .FALSE., SUPPLY = .FALSE.)
      EXTERNAL   EDITPS_COL12N, EDITPS_REPLOT, EDITPS_TXT2PS,
     +           EDITPS_RESIZE
      EXTERNAL   ADVISE, EDITPS_DECIDE, PS2JPG, PS2SVG,
     +           PS2PCX, PS2BMP, PS2TIF, PS2PNG, PS2PDF, DELEET 
      EXTERNAL   DLLCHK, WINDOW, SIMVER, GETTMP
      SAVE       X_MARGIN, Y_HEIGHT, Z_SCALE


C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = N1
      ACTION = .TRUE.
      TITLE(1) = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND, 
     +             TITLE(1), 
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C


      FIRST = .TRUE.
      CALL ADVISE (DVER,
     +             ABORT, FIRST)
      IF (ABORT) THEN
C
C User selects EXit
C
         AGAIN = .FALSE.
      ELSE
C
C User requires to run program so initialise
C
         AGAIN = .TRUE.
         NFILES = N0
         NSAV1 = N0
         NSAV2 = N0
         X_MARGIN = X_START
         Y_HEIGHT = Y_START
         Z_SCALE = Z_START
         XX_MARGIN = X_START
         YY_HEIGHT = Y_START
         ZZ_SCALE = Z_START
         ZZ_WIDE = W_START
         XTRANS(N1) = ZERO
         YTRANS(N1) = ZERO
         ZSCALE(N1) = ONE
         DO ISEND = N2, NMAX + N1
            XTRANS(ISEND) = XTRANS(ISEND - N1) + HALF
            YTRANS(ISEND) = XTRANS(ISEND - N1) + HALF
            ZSCALE(ISEND) = ONE
         ENDDO
         DO ISEND = N1, NMAX
            IXCAPT(ISEND) = - N1
            IYCAPT(ISEND) = - N1
            CAPTION(ISEND) = BLANK
            CAPTSAV(ISEND) = BLANK
         ENDDO
         DO ISEND = N1, NHIGH
            LEGEND(ISEND) = BLANK
            OLDTXT(ISEND) = BLANK
            XTRA2(ISEND) = BLANK
            TXTCPY(ISEND) = BLANK
         ENDDO
         DO ISEND = N1, 10*NHIGH
            TXTNEW(ISEND) = BLANK
            NEWTXT(ISEND) = BLANK
            XTRA3(ISEND) = BLANK
         ENDDO
         XTRA2(N1) = 'Page ?'
         DO ISEND = N1, NTITLE
            TITLE(ISEND) = BLANK
         ENDDO
         ISEND = 13
      ENDIF
C
C The main loop
C
      DO WHILE (AGAIN)
         CALL EDITPS_DECIDE (ISEND)
         IF (ISEND.EQ.1) THEN
C
C  Edit mode
C
            CALL EDITPS_RESIZE (NIN, NOUT)
         ELSEIF (ISEND.EQ.2) THEN
C
C Stack mode
C
            NFILES = NSAV1
            CALL EDITPS_COL12N (IXCAPT, IYCAPT, NFILES, NHIGH, NIN, 
     +                          NMAX, NOUT, NTITLE, NWIDE,
     +                          X_MARGIN, Y_HEIGHT, Z_SCALE,
     +                          CAPTSAV, CAPTION, FNAME1, LEGEND, TITLE,
     +                          TXTCPY, TXTNEW)
             NSAV1 = NFILES
         ELSEIF (ISEND.EQ.3) THEN
C
C Overlay mode
C
            CALL GETTMP (ISEND, XTRA1)
            NFILES = NSAV2
            CALL EDITPS_REPLOT (NHIGH, NIN, NFILES, NMAX, NOUT, NWIDE,
     +                          BBOXX, BBOXY, XTRANS, YTRANS, ZSCALE,
     +                          CAPTION, FNAME2, LEGEND, XTRA1, XTRA2,
     +                          XTRA3)
            NSAV2 = NFILES
            CALL DELEET (XTRA1,
     +                   ASKIF, THERE)           
         ELSEIF (ISEND.EQ.4) THEN
C
C Create mode
C
            CALL EDITPS_TXT2PS (NHIGH, NOUT, NWIDE,
     +                          XX_MARGIN, YY_HEIGHT, ZZ_SCALE, ZZ_WIDE,
     +                          OLDTXT, NEWTXT)
         ELSEIF (ISEND.EQ.5) THEN
C
C Transform mode
C
            CALL PS2JPG (FNAME3,
     +                   SUPPLY)            
         ELSEIF (ISEND.EQ.6) THEN
            CALL PS2PCX (FNAME3,
     +                   SUPPLY)            
         ELSEIF (ISEND.EQ.7) THEN
            CALL PS2BMP (FNAME3,
     +                   SUPPLY)             
         ELSEIF (ISEND.EQ.8) THEN
            CALL PS2TIF (FNAME3,
     +                   SUPPLY)            
         ELSEIF (ISEND.EQ.9) THEN
            CALL PS2PNG (FNAME3,
     +                   SUPPLY)             
         ELSEIF (ISEND.EQ.10) THEN
            CALL PS2PDF (FNAME3,
     +                   SUPPLY)  
         ELSEIF (ISEND.EQ.11) THEN          
            CALL PS2SVG (FNAME3,
     +                   SUPPLY) 
         ELSE
            AGAIN = .FALSE.
         ENDIF
      ENDDO

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = N1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C

      END
C
C---------------------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    I, ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 7, NUMHDR = 8, NUMOPT = 3)
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_EDITPS
C
C Initialise
C
      DO I = N1, NUMHDR
         NUMBLD(I) = N0
      ENDDO
      DO I = N1, NUMOPT
         NUMPOS(I) = N1
      ENDDO
      WRITE (HEADER,100) DVER
      WRITE (OPTION,200)
      ABORT = .FALSE.
      REPEET = .TRUE.
C
C Title page and/or Help
C
      DO WHILE (REPEET)
         IF (FIRST) THEN
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_EDITPS ('editps')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'Program `EDITPS'
     +/'Action  `Takes in PostScript files to re-scale, rotate,'
     +/'        `edit (fonts/title/legends), make collages or'
     +/'        `overlays then view, print, file or transform.'
     +/'Version `',A
     +/'Graphics`Uses the GSview/Ghostscript package'
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
  200 FORMAT (
     + 'Provide details'
     +/'Run the program'
     +/'Quit  ...  Exit' )
      END
C
C
      