C
C FTN95 version
C =============
C
C This version requires extra source code
C
C EOQSOL1.FOR : SUB00, SUB01, SUB02, SUB03, SUB04, SUB05
C EOQSOL2.FOR : DERIV1, FUNCT, FUNCT1, PLOTIT, TABNOW, XSOLVE,
C               YSOLVE, FD, FQ, FW
C EOQSOL3.FOR : MODELS, TCHECK, library of models
C
C Now include the extra source code
C =================================
C
C     INCLUDE 'eoqsol1.for', NOLIST
C     INCLUDE 'eoqsol2.for', NOLIST
C     INCLUDE 'eoqsol3.for', NOLIST
C     INCLUDE 'dllchk.for'
C
C

C***********************************
C Start of module for program EOQSOL
C***********************************

      MODULE MODULE_EOQSOL
      
      IMPLICIT NONE
      
      INTEGER    KOUT
      PARAMETER (KOUT = 4)
      INTEGER    NMAX
      PARAMETER (NMAX = 5000)
      INTEGER    NPAR
      PARAMETER (NPAR = 10)
      INTEGER    LIW, LW, MODNUM, NPHI, NSAV, NTHETA, NTVAR
      INTEGER    NDIS, NOUT, NPDF, NPTS, NTAB, NWTS, NXIN
      INTEGER    IW(NMAX/8 + 2)
      
      DOUBLE PRECISION A, B, EPSABS, EPSREL, SCALE1, S0, S1, TOLX
      DOUBLE PRECISION FBOT, FTOP
      DOUBLE PRECISION THETA(NPAR), XMU, XSIGMA, XSTART, XSTOP
      DOUBLE PRECISION SUMF, W(NMAX), XPTS(NMAX)
      DOUBLE PRECISION WEIGHT
      DOUBLE PRECISION FACT(NPAR), PHI(NPAR), QSAVE
      DOUBLE PRECISION ENEG, EPOS, EPSI, RTOL
      DOUBLE PRECISION THETA_REF(NPAR), SCALE1_REF, SUMF_REF, 
     +                 WEIGHT_REF, XMU_REF, XSIGMA_REF, XSTART_REF,
     +                 XSTOP_REF

      SAVE
      
      END MODULE MODULE_EOQSOL

C*********************************
C End of module for program EOQSOL
C*********************************  
    
C
C
C

      PROGRAM MAIN

      USE MODULE_EOQSOL, ONLY : NPAR, NTVAR, KOUT,
     +                          FACT, PHI, THETA       

C
C PACKAGE : SIMFIT
C PROGRAM : EOQSOL
C VERSION : details from SIMVER/DLLCHK
C NAG     : C05AZF, D01AJF, E04ABF, E04JAF, X02AJF, X02AMF
C SUPPLY  : MODEL FUNCTIONS G1, G2
C ADJUST  : SCALE IN FUNCT1 TO KEEP FCN OF ORDER UNITY AT THE SOLUTION
C INPUT   : CHOICE OF DISTRIBUTIONS, WEIGHTS ETC.
C OUTPUT  : EXPECTED VALUE OF MINIMUM OF SUM (S) OR INTEGRAL (Q) OF
C           W(X)*(G2(THETA,X) - G1(PHI,X))**2 WITH RESPECT TO PHI
C           THE PROBABILITY MASS OR DENSITY FUNCTIONS ARE :-
C               WEIGHT = 1.0/NPTS          ...   (FOR S(N))
C           OR  WEIGHT = 1.0/SUMF          ...   (FOR Q(THETA))
C SUB00   : SET CALCULATION PARAMETERS
C SUB01   : CHOOSE TYPE OF CALCULATION REQUIRED
C SUB02   : INPUT THETA THEN SET VALUES FOR XSTART AND XSTOP
C SUB03   : CALCULATE THE X VALUES REQUIRED FOR S(N)
C SUB04   : SET THE TYPE OF WEIGHTS REQUIRED
C SUB05   : OPTIMISATION
C
C           NMAX = ARRAY DIMENSION FOR NPTS AND D01AJF
C           LW = NMAX
C           LIW = NMAX/8 + 2
C           NPAR = ARRAY DIMENSION FOR PARAMETERS PHI AND THETA
C           A, B = LIMITS FOR E04ABF AND E04JAF
C           EPSABS, EPSREL = TOLERANCES FOR E04ABF AND D01AJF
C           TOLX = TOLERANCE FOR C05AZF
C           NPHI, NTHETA = CURRENT DIMENSIONS FOR PARAMETER VECTORS
C           SCALE = SCALING FACTOR TO KEEP OBJ. FUN. = 1 IN E04ABF/E04JAF
C           FBOT, FTOP = LOWEST, HIGHEST VALUE FOR G2(X)
C           NDIS, NOUT, NPDF, NTAB, NTVAR, NWTS, NXIN = CONTROL INTEGERS
C           NPTS = CURRENT N IN S(N) AND R(N)
C           XMU, XSIGMA = PARAMETERS OF TRUNCATED NORMAL DISTRIBUTION
C           SUMF = CURRENT SUM OR INTEGRAL FOR NORMALISING
C           IW, W = WORKSPACES FOR D01AJF
C           XPTS = CURRENT DESIGN POINTS
C           WEIGHT = CURRENT WEIGHT
C           FACT = FACTORS TO KEEP PHI = 1 IN E04ABF AND E04JAF
C           QSAVE = CURRENT Q-VALUE
C           ISEND = CONTROL INTEGER
C           MODNUM = MODEL NUMBER
C AUTHOR  : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U. K., 27/4/87
C REVISED : 28/11/1991 FIRST PC VERSION WITH EOQHL1
C           05/12/1991 IMPROVEMENTS TO PROGRAM CONTROL
C                      CORRECTED LIMITS FOR XSTART, XSTOP WITH MODELS 5 AND 6
C                      ENDALL, GETKEY, GETCHR
C           10/06/1992 GKST02
C           17/03/1993 GET???, PUT??? and compressed
C           17/06/1993 RESFIL
C           10/11/1997 win32 version using QNFIT1/LBFGS not E04. This involved
C                      declaring the QNFIT1 variables in the main program and
C                      passing them as arguments to SUB05 to prevent a stack
C                      fault.
C           07/08/1998 added dllchk
C           14/12/1998 replaced TUTORS by TUTOR1
C           13/09/1999 added call to WINDOW
C           05/12/1999 increased dimension LW1
C           12/02/2000 added SIMVER
C           23/03/2001 revised
C           28/07/2005 increased DVER to *30 and added to call to ADVISE
C           15/02/2008 revised for version 6
C
      IMPLICIT   NONE
C
C NPAR1 must be >= NPAR in MODULE_EOQSOL
C      
      INTEGER    NPAR1
      PARAMETER (NPAR1 = 20)
      INTEGER    N10, LIW1, LW1, LW2, NF1
      PARAMETER (N10 = 10,
     +           LIW1 = 3*NPAR1,
     +           LW1 = 2*(2*NPAR1*N10 + 4*NPAR1 + 11*N10**2 +
     +                 8*N10*NPAR1),
     +           LW2 = 3*NPAR1,
     +           NF1 = 4)
      INTEGER    ISEND
      INTEGER    IFAIL, IW1(LIW1), N, NBD(NPAR1), NPTS1
      DOUBLE PRECISION BL(NPAR1), BU(NPAR1), F, G(NPAR1), W1(LW1),
     +                 W2(LW2), X(NPAR1)
      DOUBLE PRECISION XVER, YVER
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  QNTYPE*11, QNPREC*6
      PARAMETER (QNTYPE = 'approximate', QNPREC = 'medium')
      CHARACTER  TITLE*80
      CHARACTER  FNAME*1024
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_eoqsol.exe')
      CHARACTER  BLANK*1, PNAME*6
      PARAMETER (BLANK = ' ', PNAME = 'EOQSOL')
      LOGICAL    ABORT, ACTION, LOOP1, LOOP2, SHOW
      EXTERNAL   FNAMES
      EXTERNAL   ADVISE, SUB00, SUB01, SUB02, SUB03, SUB04, SUB05
      EXTERNAL   DLLCHK, WINDOW, SIMVER
      INTRINSIC  MIN

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C


C
C     ... INITIALISE
C
      IFAIL = 0
      N = 0
      NPTS1 = 0
      NTVAR = 1
      DO ISEND = 1, MIN(NPAR,NPAR1)
         NBD(ISEND) = 2
         BL(ISEND) = ZERO
         BU(ISEND) = ONE
         G(ISEND) = ONE
         X(ISEND) = ONE
         FACT(ISEND) = ONE
         PHI(ISEND) = ONE
         THETA(ISEND) = ONE
      ENDDO
      F = ONE
      FNAME = BLANK

C
C Advice/run/quit 
C        
      CALL ADVISE (DVER,
     +             ABORT)
      IF (ABORT) THEN 
         LOOP1 = .FALSE.
         LOOP2 = .FALSE.
      ELSE
         LOOP1 = .TRUE.
         LOOP2 = .TRUE.
      ENDIF      
      DO WHILE (LOOP1)
C
C SUB00: Set up main parameter options or quit
C        
         IF (LOOP2) THEN
            CALL SUB00 (ABORT,
     +                  FNAME)
            IF (ABORT) THEN
               LOOP1 = .FALSE.
               LOOP2 = .FALSE.
            ENDIF
         ENDIF         
         DO WHILE (LOOP2) 
C
C SUB01: Check that Q-reference exists
C        
            CALL SUB01
C
C SUB02: input theta, calculate x_start, x_stop
C
            CALL SUB02
C
C SUB03: calculate sumf and xpts
C            
            CALL SUB03
C
C SUB04: calculate weight
C            
            CALL SUB04
C            
C SUB05: optimisation then tables and graphs           
C
            CALL SUB05 (ISEND,
     +                  IFAIL, IW1, LIW1, LW1, LW2, N, NBD, NF1, NPTS1,
     +                  BL, BU, F, G, W1, W2, X,
     +                  QNTYPE, QNPREC)
            IF (ISEND.EQ.1) THEN
C
C Carry on with same option ... so now stay in LOOP2 and call sub01 
C              
               LOOP2 = .TRUE.
            ELSEIF (ISEND.EQ.2) THEN
C
C Start a new procedure ... so now exit LOOP2 and call sub00
C            
               EXIT
            ELSE
C
C Exit ... Quit both LOOP1 and LOOP2
C              
               LOOP1 = .FALSE.
               LOOP2 = .FALSE.   
               EXIT
            ENDIF
         ENDDO
      ENDDO
      
      IFAIL = 4
      CLOSE (UNIT = IFAIL)
      ISEND = 2
      CALL FNAMES (ISEND,
     +             FNAME)


C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND, 
     +             TITLE,
     +             ACTION)
C
C======================================================================
C

      CLOSE (UNIT = KOUT)
      END
C
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 14, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    FIRST, REPEET
      EXTERNAL   TITLES, HELP_EOQSOL, LISTBX
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 3
            CALL LISTBX (ISEND, NUMOPT,
     +                   OPTION)
         ENDIF            
         IF (ISEND.EQ.1) THEN
            CALL HELP_EOQSOL ('eoqsol')
            REPEET = .TRUE.
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
      FIRST = .FALSE.
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `EOQSOL'
     +/'        `      '
     +/'Action  `Optimal design for model discrimination. Choosing'
     +/'        `best design point spacing for scientific models.'
     +/'        `References: J. theor. Biol. (1989) 139, 85-102;'
     +/'        `Computers Chem. (1996) 20, 145-157'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
