C
C EOQSOL1.FOR
C ============
C SUB00: Display options
C SUB01: Check for Q-reference
C SUB02: Input theta/Xstart/Xstop
C SUB03: Calculate SUMF/XPTS
C SUB04: Calculate weights
C SUB05: Optimise
C
C
      SUBROUTINE SUB00 (ABORT,
     +                  FNAME)

      USE MODULE_EOQSOL
C
C     ...   MACHINE CONSTANTS, DISPLAY DETAILS, CHOOSE OPTIONS
C
      IMPLICIT   NONE
C
C Arguments
C      
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    MODSAV, NDEC, NPSAV, NWSAV
      INTEGER    I, KMOD, KPDF, KWTS, KXIN
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(28), NUMPOS(15)
      DOUBLE PRECISION FB, FT, TA, TB, TE, TR, TS, TX, Z0, Z1
      DOUBLE PRECISION FBSAV, FTSAV, S0SAV, S1SAV
      PARAMETER (FB = 1.0D-01, FT = 9.0D-01,
     +           TA = 1.0D-04, TB = 1.0D+04,
     +           TE = 1.0D-06, TR = 1.0D-03,
C**************************************************************
C*Changed TS to prevent problems with lbfgs/setulb/mainlb/formk
C*then call to dpofa in linpack
C****+           TS = 1.0D3,
C**************************************************************
     +           TS = 1.0D+06,
     +           TX = 1.0D-04,
     +           Z0 = 2.5D-03, Z1 = 2.5D-03)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION X02AJF$, X02AMF$
      CHARACTER  IWARNU*24
      PARAMETER (IWARNU = '... Changed from default')
      CHARACTER (LEN = 13) D13(20), SHOWLJ
      CHARACTER  QREF*(31), SYMBOL(9)*24
      CHARACTER  CNWTS(3)*17, CNPDF(7)*33, MODEL*65
      CHARACTER  LINE*100, TEXT28(28)*100, TEXT15(15)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    FIRST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   SHOWLJ, E_FORMATS
      EXTERNAL   X02AJF$, X02AMF$
      EXTERNAL   RESFIL, GETDL1, GETDL2, LBOX01, LBOX02, PUTADV, GETJM1,
     +           REVPRO, HELP_EOQSOL
      EXTERNAL   MODELS
      INTRINSIC  ABS, LOG
      SAVE KMOD, KPDF, KWTS, KXIN, MODSAV, NPSAV, NWSAV
      SAVE FBSAV, FTSAV, S0SAV, S1SAV
      SAVE CNWTS, CNPDF
      SAVE FIRST
      SAVE MODEL
      DATA CNPDF / 'Uniform distribution of  x-values',
     +             'Geometric with increasing spacing',
     +             'Geometric with decreasing spacing',
     +             'Linear with increasing spacing   ',
     +             'Linear with decreasing spacing   ',
     +             'Normal truncated at Xstart, Xstop',
     +             'Uniform on g2 with dg2/dx as f(x)' /
      DATA CNWTS / 'Constant variance',
     +             'Const. rel. error',
     +             'Mixed  error type' /
      DATA FIRST / .TRUE. /
      DATA NUMBLD / 28*0 /
      DATA NUMPOS / 15*1 /
C
C     ... FIRST TIME SET UP DEFAULTS
C
      E_NUMBERS = E_FORMATS()
      ABORT = .FALSE.
      BORDER = .FALSE.
      IF (FIRST) THEN
         FIRST = .FALSE.
         CALL RESFIL (KOUT,
     +                FNAME,
     +                ABORT)
         IF (ABORT) THEN
            FNAME = BLANK
            RETURN
         ENDIF
         WRITE (KOUT,100)
         RTOL = 1.0D+09*X02AMF$()
         ENEG = LOG(RTOL)
         EPOS = - ENEG
         EPSI = X02AJF$()
         LW = NMAX
         LIW = NMAX/8 + 2
         WRITE (LINE,200) 'model equations  g2 and g1'
         CALL PUTADV (LINE)
         CALL MODELS (MODNUM, NPHI, NTHETA, MODEL)
         KMOD = MODNUM
         MODSAV = MODNUM
         NDIS = 0
         WRITE (TEXT28,300) 'distribution function f(x)'
         NSTART = 2
         NUMOPT = 7
         NTEXT = NSTART + NUMOPT - 1
         NPDF = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NPDF, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT28, 
     +                BORDER, FLASH, HIGH)
         KPDF = NPDF
         NPSAV = NPDF
         WRITE (TEXT28,400) 'weighting  function  w(x)'
         NSTART = 2
         NUMOPT = 3
         NTEXT = NSTART + NUMOPT - 1
         NWTS = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NWTS, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT28,
     +                BORDER, FLASH, HIGH)
         KWTS = NWTS
         NWSAV = NWTS
         KXIN = 3
         NXIN = KXIN
         A = TA
         B = TB
         EPSABS = TE
         EPSREL = TR
         IF (MODNUM.EQ.5 .OR. MODNUM.EQ.6) THEN
            FBOT = FT
            FTOP = FB
         ELSE
            FBOT = FB
            FTOP = FT
         ENDIF
         FBSAV = FBOT
         FTSAV = FTOP
         SCALE1 = TS
         TOLX = TX
         S0 = Z0
         S1 = Z1
         S0SAV = S0
         S1SAV = S1
         XMU = ZERO
         XSIGMA = ONE
         XSTART = ZERO
         XSTOP = ONE
         NOUT = 1
         NTAB = 0
      ENDIF
C
C     ... DISPLAY CURRENT OPTIONS AND MAKE ANY CHANGES REQUESTED
C     ... SET NDIS = 0 IF ANY CHANGES REQUIRE RECALCULATION OF QSAVE
C
   20 CONTINUE
      IF (MODNUM.EQ.5 .OR. MODNUM.EQ.6) THEN
         IF (FTOP.GE.FBOT) THEN
            NDEC = 6
            GOTO 40
         ENDIF
      ELSEIF (FBOT.GE.FTOP) THEN
         NDEC = 6
         GOTO 40
      ENDIF
      DO I = 1, 9
         SYMBOL(I)  = BLANK
      ENDDO
      IF (ABS(TA - A).GT.EPSI) SYMBOL(1) = IWARNU
      IF (ABS(TB - B).GT.EPSI) SYMBOL(1) = IWARNU
      IF (ABS(TE - EPSABS).GT.EPSI) SYMBOL(2) = IWARNU
      IF (ABS(TR - EPSREL).GT.EPSI) SYMBOL(2) = IWARNU
      IF (ABS(TX - TOLX  ).GT.EPSI) SYMBOL(2) = IWARNU
      IF (ABS(TS - SCALE1).GT.EPSI) SYMBOL(3) = IWARNU
      IF (ABS(Z0 - S0).GT.EPSI) SYMBOL(4) = IWARNU
      IF (ABS(Z1 - S1).GT.EPSI) SYMBOL(4) = IWARNU
      IF (KMOD.NE.MODNUM) SYMBOL(5) = IWARNU
      IF (ABS(FB - FBOT).GT.EPSI) SYMBOL(6) = IWARNU
      IF (ABS(FT - FTOP).GT.EPSI) SYMBOL(6) = IWARNU
      IF (KXIN.NE.NXIN) SYMBOL(7) = IWARNU
      IF (KPDF.NE.NPDF) SYMBOL(8) = IWARNU
      IF (KWTS.NE.NWTS) SYMBOL(9) = IWARNU
      IF (E_NUMBERS) THEN  
         WRITE (TEXT28,500) MODEL, CNPDF(NPDF), CNWTS(NWTS), 
     +                      NPHI, NTHETA,
     +                      A, TA, B, TB, EPSABS, TE,
     +                      EPSREL, TR, SCALE1, TS, TOLX, TX, S0, Z0,
     +                      S1, Z1, FBOT, FB, FTOP, FT
      ELSE
         D13(1) = SHOWLJ(A)
         D13(2) = SHOWLJ(TA)
         D13(3) = SHOWLJ(B)
         D13(4) = SHOWLJ(TB)
         D13(5) = SHOWLJ(EPSABS)
         D13(6) = SHOWLJ(TE)
         D13(7) = SHOWLJ(EPSREL)
         D13(8) = SHOWLJ(TR)
         D13(9) = SHOWLJ(SCALE1)
         D13(10) = SHOWLJ(TS)
         D13(11) = SHOWLJ(TOLX)
         D13(12) = SHOWLJ(TX)
         D13(13) = SHOWLJ(S0)
         D13(14) = SHOWLJ(Z0)
         D13(15) = SHOWLJ(S1)
         D13(16) = SHOWLJ(Z1)
         D13(17) = SHOWLJ(FBOT)
         D13(18) = SHOWLJ(FB)
         D13(19) = SHOWLJ(FTOP)
         D13(20) = SHOWLJ(FT)
          WRITE (TEXT28,550) MODEL, CNPDF(NPDF), CNWTS(NWTS), 
     +                       NPHI, NTHETA,
     +                       (D13(I), I = 1, 20)
      ENDIF  
      IF (MODNUM.NE.MODSAV) NDIS = 0
      IF (NPDF.NE.NPSAV) NDIS = 0
      IF (NWTS.NE.NWSAV) NDIS = 0
      IF (ABS(FBOT - FBSAV).GT.EPSI) NDIS = 0
      IF (ABS(FTOP - FTSAV).GT.EPSI) NDIS = 0
      IF (ABS(S0 - S0SAV).GT.EPSI) NDIS = 0
      IF (ABS(S1 - S1SAV).GT.EPSI) NDIS = 0
      IF (NDIS.EQ.0) THEN
         QREF = 'Q-ref must be calculated'
      ELSE
         QREF = 'Q-ref has been calculated'
      ENDIF
      WRITE (TEXT15,600) QREF, (SYMBOL(I), I = 1, 9)
      DO I = 1, 15
         TEXT28(13 + I) = TEXT15(I)
      ENDDO
      NSTART = 14
      NUMOPT = 15
      NTEXT = NSTART + NUMOPT - 1
      NDEC = 1
      BORDER = .TRUE.
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT28,
     +             BORDER, FLASH, HIGH)
      BORDER = .FALSE.
   40 CONTINUE
      IF (NDEC.LE.3) THEN
C
C NDEC =< 3: set NDIS
C NDIS  < 1: force calculation of a new Q-reference
C NDEC  = 1: Q-reference
C NDEC  = 2: Q(1-theta varied)
C NDEC  = 3: S(N), R(N)
C        
         IF (NDIS.LT.1 .OR. NDIS.GT.3) THEN
            NDIS = 0
         ELSE   
            NDIS = NDEC
         ENDIF   
         NSAV = 0
C
C If NDIS > 0 then restore THETA = Q-Ref THETA and all parameters involved
C         
         IF (NDIS.GT.1) THEN
           DO I = 1, NTHETA
              THETA(I) = THETA_REF(I)
            ENDDO 
            SUMF = SUMF_REF
            SCALE1 = SCALE1_REF
            WEIGHT = WEIGHT_REF
            XMU = XMU_REF
            XSIGMA = XSIGMA_REF
            XSTART = XSTART_REF
            XSTOP = XSTOP_REF
         ENDIF    
C
C If NDIS = 2 find the number of the theta to be varied
C         
         IF (NDIS.EQ.2) THEN
            IF (NTHETA.EQ.1) THEN
               NTVAR = 1
            ELSE
               I = 1
               IF (NTVAR.LT.1) THEN
                  NTVAR = 1
               ELSEIF (NTVAR.GT.NTHETA) THEN
                  NTVAR = NTHETA
               ENDIF      
               CALL GETJM1 (I, NTVAR, NTHETA,
     +                     'No. i of the theta(i) to be varied')
            ENDIF
         ENDIF   
C
C Write details to results file
C        
         IF (E_NUMBERS) THEN 
            WRITE (KOUT,700) MODEL, CNPDF(NPDF), CNWTS(NWTS), FBOT, FTOP
         ELSE
            D13(1) = SHOWLJ(FBOT)
            D13(2) = SHOWLJ(FTOP)
            WRITE (KOUT,750) MODEL, CNPDF(NPDF), CNWTS(NWTS),
     +                       D13(1), D13(2) 
         ENDIF  
         IF (NWTS.EQ.3) THEN
            IF (E_NUMBERS) THEN
               WRITE (KOUT,800) S0, S1
            ELSE
               D13(1) = SHOWLJ(S0)
               D13(2) = SHOWLJ(S1) 
               WRITE (KOUT,850) TRIM(D13(1)), D13(2)
            ENDIF
         ENDIF        
         WRITE (KOUT,900)
         MODSAV = MODNUM
         NPSAV = NPDF
         NSAV = 0
         NWSAV = NWTS
         FBSAV = FBOT
         FTSAV = FTOP
         S0SAV = S0
         S1SAV = S1
         ABORT = .FALSE.
         RETURN
      ELSEIF (NDEC.EQ.4) THEN
C
C NDEC = 4: set A, B where B > A
C      
         CALL GETDL2 (1.0D+01*EPSI, -1.0D+20, A, B, 1.0D+20,
     +               'Values required for A, B (B > A)')
         GOTO 20
      ELSEIF (NDEC.EQ.5) THEN
C
C NDEC = 5: set EPSABS, EPSREL, TOLX
C      
         CALL GETDL1 (EPSI, EPSABS, 1.0D+02, 'Value for EPSABS (> 0)')
         CALL GETDL1 (EPSI, EPSREL, 1.0D+02, 'Value for EPSREL (> 0)')
         CALL GETDL1 (EPSI, TOLX, 1.0D+02, 'Value for TOLX (> 0)')
         GOTO 20
      ELSEIF (NDEC.EQ.6) THEN
C
C NDEC = 6: set SCALE1
C      
         CALL GETDL1 (RTOL, SCALE1, 1.0D+30, 'Value for SCALE (> 0)')
         GOTO 20
      ELSEIF (NDEC.EQ.7) THEN
C
C NDEC = 7: set S0, S1
C      
         CALL GETDL1 (EPSI, S0, 1.0D+10, 'Value for S0 (> 0)')
         CALL GETDL1 (EPSI, S1, 1.0D+10, 'Value for S1 (> 0)')
         S0 = S0**2
         S1 = S1**2
         GOTO 20
      ELSEIF (NDEC.EQ.8) THEN
C
C NDEC = 8: set G1, G2
C      
         CALL MODELS (MODNUM, NPHI, NTHETA, MODEL)
         GOTO 20
      ELSEIF (NDEC.EQ.9) THEN
C
C NDEC = 9: set limits for g2(xstart), g2(xstop)
C      
         IF (MODNUM.EQ.5 .OR. MODNUM.EQ.6) THEN
            CALL GETDL2 (1.0D+02*EPSI, EPSI, FTOP, FBOT, 1.0D+00 - EPSI,
     +    'g2(Xstop),g2(Xstart) (epsi<g2(Xstop) << g2(Xstart)<1-epsi)')
         ELSE
            CALL GETDL2 (1.0D+02*EPSI, EPSI, FBOT, FTOP, 1.0D+00 - EPSI,
     +    'g2(Xstart),g2(Xstop) (epsi<g2(Xstart) << g2(Xstop)<1-epsi)')
         ENDIF
         GOTO 20
      ELSEIF (NDEC.EQ.10) THEN
C
C NDEC = 10: set method uses to calculate g2(xstart), g2(xstop)
C      
         WRITE (TEXT28,1000)
         NSTART = 1
         NUMOPT = 3
         NTEXT = NSTART + NUMOPT - 1
         NXIN = 3
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT28,
     +                BORDER, FLASH, HIGH)
         IF (NDEC.LT.3) CALL PUTADV (
     +'Options 1 and 2 have been temporarily disabled in this version')            
         GOTO 20
      ELSEIF (NDEC.EQ.11) THEN
C
C  NDEC = 11: set distribution
C      
         WRITE (TEXT15,300) BLANK
         DO I = 1, 7
            TEXT15(I) = TEXT15(I + 1)
         ENDDO
         NUMOPT = 7
         NPDF = 1
         CALL LBOX02 (ICOLOR, IXL, IYL, NPDF, NUMOPT, NUMPOS,
     +                TEXT15)
         GOTO 20
      ELSEIF (NDEC.EQ.12) THEN
C
C NDEC = 12: set variance type
C      
         WRITE (TEXT15,400) BLANK
         DO I = 1, 3
            TEXT15(I) = TEXT15(I + 1)
         ENDDO
         NUMOPT = 3
         NWTS = 1
         CALL LBOX02 (ICOLOR, IXL, IYL, NWTS, NUMOPT, NUMPOS,
     +                TEXT15)
         GOTO 20
      ELSEIF (NDEC.EQ.NUMOPT - 2) THEN
C
C NDEC = 13: results
C      
         CALL REVPRO (KOUT)
         GOTO 20
      ELSEIF (NDEC.EQ.NUMOPT - 1) THEN
C
C NDEC = 14: help
C      
         CALL HELP_EOQSOL ('eoqsol')
         GOTO 20
      ELSE
C
C NDEC = 15: Exit
C        
         ABORT = .TRUE.
         RETURN          
      ENDIF
C
C Format statements
C      
  100 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : EOQSOL'
     +/1X,'ACTION  : Q(theta), S(n) and R(n)'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  200 FORMAT ('Now choose the',1X,A26,1X,
     + 'as default for this run')
  300 FORMAT ('Now choose the',1X,A26,1X,
     + 'as default for this run'
     +/'Uniform distribution for x-values'
     +/'Geometric with increasing spacing'
     +/'Geometric with decreasing spacing'
     +/'Linear with increasing spacing'
     +/'Linear with decreasing spacing'
     +/'Normal truncated at Xstart, Xstop'
     +/'Uniform on g2 with dg2/dx as f(x)')
  400 FORMAT ('Now choose the',1X,A26,1X,
     + 'as default for this run'
     +/'Constant variance, V(y) = S0^2'
     +/'Const. rel. error, V(y) = (S1*y)^2'
     +/'Mixed  error type, V(y) = S0^2 + (S1*y)^2')
  500 FORMAT ('Model :',1X,A
     +/'pdf',3X,':',1X,A33,', Weight :',1X,A17,
     +/'NPHI =',I3,', NTHETA =',I3,8X,'Default values'
     +/'A',10X,'=',1P,E10.2,E16.2
     +/'B',10X,'=',E10.2,E16.2
     +/'EPSABS',5X,'=',E10.2,E16.2
     +/'EPSREL',5X,'=',E10.2,E16.2
     +/'SCALE',6X,'=',E10.2,E16.2
     +/'TOLX',7X,'=',E10.2,E16.2
     +/'S0^2',7X,'=',E10.2,E16.2
     +/'S1^2',7X,'=',E10.2,E16.2
     +/'g2(Xstart) =',E10.2,E16.2
     +/'g2(Xstop)  =',E10.2,E16.2)
  550 FORMAT ('Model :',1X,A
     +/'pdf',3X,':',1X,A33,', Weight :',1X,A17,
     +/'NPHI =',I3,', NTHETA =',I3,5X,'Default values'
     +/'A',10X,'=',1X,A13,1X,A13
     +/'B',10X,'=',1X,A13, 1X,A13
     +/'EPSABS',5X,'=',1X,A13,1X,A13
     +/'EPSREL',5X,'=',1X,A13,1X,A13
     +/'SCALE',6X,'=',1X,A13,1X,A13
     +/'TOLX',7X,'=',1X,A13, 1X,A13
     +/'S0^2',7X,'=',1X,A13,1X,A13
     +/'S1^2',7X,'=',1X,A13,1X,A13
     +/'g2(Xstart) =',1X,A13,1X,A13
     +/'g2(Xstop)  =',1X,A13,1X,A13)   
  600 FORMAT (
     + 'Calculate Q(all theta varied)',4X,A
     +/'Calculate Q(one theta varied)'
     +/'Calculate R(n) and S(n) given Q-ref'
     +/'Change parameter limits: A, B ',4X,A
     +/'Change EPSABS, EPSREL and TOLX',4X,A
     +/'Change SCALE, so Obj. Fun. = 1',4X,A
     +/'Change parameters:  S0^2, S1^2',4X,A
     +/'Change model, i.e. g2 and g1  ',4X,A
     +/'Change g2(Xstart) and g2(Xstop)',3X,A
     +/'Change method for Xstart,Xstop',4X,A
     +/'Change distribution of  points',4X,A
     +/'Change type of  weighting used',4X,A
     +/'Results'
     +/'Help'
     +/'Quit  ...  Exit program EOQSOL')
  700 FORMAT (/1X,'Model :',1X,A65
     +/1X,'pdf',3X,':',1X,A33,', Weight :',1X,A17
     +/1X,'g2(Xstart) =',1P,E10.2,', g2(Xstop) =',E10.2)
  750 FORMAT (/1X,'Model :',1X,A65
     +/1X,'pdf',3X,':',1X,A33,', Weight :',1X,A17
     +/1X,'g2(Xstart) =',1X,A13,', g2(Xstop) =',1X,A13)   
  800 FORMAT (1X,'S0^2 =',1P,E9.2,', S1^2 =',E9.2)
  850 FORMAT (1X,'S0^2 =',1X,A,', S1^2 =',1X,A)
  900 FORMAT (1X,'-*-')
 1000 FORMAT (
     + '1. You input the known values for Xstart, Xstop'
     +/'2. Calculated (You supply  appropriate interval)'
     +/'3. Calculated (Interval estimated automatically)'
     +/'Usually option 3 is preferred so  Xstart, Xstop'
     +/'are fixed automatically by g2(Xstart), g2(Xstop).'
     +/'Option 2  may be necessary with difficult cases.'
     +/'Option 1  is only selected when you want to see'
     +/'what happens when the integral in Q or sum in S'
     +/'is evaluated over fixed ranges of x rather than'
     +/'limits dictated by g2(Xstart) and g2(Xstop).'
     +/'Option 1 changes g2(Xstart) and g2(Xstop) each'
     +/'time that theta is varied. If you do use option'
     +/'1, check that g2(Xstart) and g2(Xstop) are what'
     +/'you really want if you return to the usual mode.'
     +/'Be sure you know what you are doing'
     +/'before selecting options 1 or 2.')
      END
C
C----------------------------------------------------------------
C
      SUBROUTINE SUB01

      USE MODULE_EOQSOL, ONLY : NDIS
C
C     ...   MAKE SURE A Q-REFERENCE IS CALCULATED
C
      IMPLICIT   NONE
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NTEXT
      PARAMETER (IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20)
      CHARACTER  TEXT(30)*100
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL PATCH1
      DATA NUMBLD / 20*0 /
      IF (NDIS.LT.1) THEN
C
C A new Q_reference must be calculated
C        
         NDIS = 1
         WRITE (TEXT,100)
         NTEXT = 20
         ICOLOR = 9
         CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTEXT, 
     +                TEXT,
     +                BORDER)
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Either you have just started the program or you have'
     +/'made changes that invalidate the current Q-reference.'
     +/'So you must now calculate a new Q-reference.'
     +/
     +/'To do this you simply choose a set of parameters and'
     +/'set of starting estimates, then calculate Q. Each time'
     +/'you calculate a Q it becomes a new reference, and you'
     +/'can plot the corresponding g2(x) and best-fit g1(x).'
     +/
     +/'After a new Q-reference has been calculated you can'
     +/'a)`Choose new models/weightings/pdf/limits/controls'
     +/'b)`Calculate Q with just one selected theta varied'
     +/'c)`Calculate S(n) and R(n) given a Q-reference'
     +/
     +/'Calculating a new Q-reference automatically cancels'
     +/'stored values of Q(1-theta varied), R(n) and S(n).'
     +/'Note that when at least three successive values of'
     +/'Q(1-theta varied), or R(n)have been accumulated, you' 
     +/'can choose to plot the accumulated results, i.e.'
     +/'Q(one-theta-varied) or R(n).')
      END
C
C--------------------------------------------------------------------
C
      SUBROUTINE SUB02

      USE MODULE_EOQSOL, ONLY : KOUT, 
     +                          NDIS, MODNUM, NPDF, NSAV, NTHETA, NTVAR, 
     +                          NXIN,
     +                          EPSI, FBOT, FTOP, THETA, XMU, 
     +                          XSIGMA, XSTOP,
     +                          XSTART 
C
C     ...   INPUT THETA(I), INPUT/CALCULATE XSTART, XSTOP
C
      IMPLICIT   NONE
      INTEGER    I
      DOUBLE PRECISION RESUL, XDIFF, XSUM
      DOUBLE PRECISION G2
      CHARACTER  LINE*100
      LOGICAL    ABORT
      EXTERNAL G2
      EXTERNAL GETR01, GETDL2, PUTADV
      EXTERNAL XSOLVE, TCHECK
   20 CONTINUE
      IF (NDIS.EQ.1) THEN
         DO I = 1, NTHETA
            WRITE (LINE,100) I
            CALL GETR01 (THETA(I), LINE)
        ENDDO
      ELSEIF (NDIS.EQ.2) THEN
         WRITE (LINE,100) NTVAR
         CALL GETR01 (THETA(NTVAR), LINE)
      ELSE
         IF (NSAV.EQ.0) WRITE (KOUT,200) XSTART, XSTOP
         RETURN
      ENDIF
      CALL TCHECK (MODNUM, NTHETA, 
     +             EPSI, THETA, 
     +             ABORT)
      IF (ABORT) GOTO 20
      IF (NXIN.EQ.1) THEN
         CALL GETDL2 (1.0D+01*EPSI, EPSI, XSTART, XSTOP, 1.0D+30,
     +               'Values for Xstart, Xstop (0 < Xstart < Xstop)')
         FBOT = G2(XSTART)
         FTOP = G2(XSTOP)
         WRITE (LINE,200) XSTART, XSTOP
         CALL PUTADV (LINE)
         WRITE (KOUT,200) XSTART, XSTOP
         WRITE (LINE,300) FBOT, FTOP
         CALL PUTADV (LINE)
         WRITE (KOUT,300) FBOT, FTOP
      ELSE
         I = 1
         CALL XSOLVE (I,
     +                FBOT, RESUL)
         XSTART = RESUL
         I = 2
         CALL XSOLVE (I, 
     +                FTOP, RESUL)
         XSTOP  = RESUL
         WRITE (KOUT,200) XSTART, XSTOP
      ENDIF
      IF (NPDF.EQ.6) THEN
         XDIFF = XSTOP - XSTART
         XSUM = XSTART + XSTOP
         XMU = XSUM/2.0D+00
         XSIGMA = XDIFF/4.0D+00
      ENDIF
C
C Format statements
C      
  100 FORMAT ('Value required for parameter theta(',I2,')')
  200 FORMAT (1X,'Xstart =',1P,E10.2,', Xstop =',E10.2)
  300 FORMAT (1X,'g2(Xstart) =',1P,E10.2,', g2(Xstop) =',E10.2)
      END
C
C------------------------------------------------------------------
C
      SUBROUTINE SUB03

      USE MODULE_EOQSOL, ONLY : KOUT, 
     +                          IW, LIW, LW, NDIS, NMAX, NPTS, NTAB,
     +                          EPSABS, EPSREL, RTOL, SUMF, W,
     +                          XPTS, XSTART, XSTOP
C
C     ...   CALCULATE SUMF FOR CHOSEN DISTRIBUTION FUNCTION AND XPTS(I)
C
      IMPLICIT   NONE
      INTEGER    NXPTS
      PARAMETER (NXPTS = 500)
      INTEGER    I, J, IFAIL
      INTEGER    ICOLOR, IXL, IYL
      PARAMETER (IXL = 4, IYL = 4)
      DOUBLE PRECISION ABSERR, FIX, RESUL, SPACE, X1, X2
      DOUBLE PRECISION FD
      CHARACTER  LINE*100
      LOGICAL    YES
      EXTERNAL  FD
      EXTERNAL  D01AJF$
      EXTERNAL  PUTIFA, PUTFAT, GETIM1, YESNO2, TABLE1
      EXTERNAL  YSOLVE
      INTRINSIC MIN, DBLE
      IF (NDIS.LT.3) THEN
         X1 = XSTART
         X2 = XSTOP
         IFAIL = 1
         CALL D01AJF$(FD, X1, X2, EPSABS, EPSREL, RESUL, ABSERR, W,
     +                LW, IW, LIW, IFAIL)
         CALL PUTIFA (IFAIL, KOUT, 'D01AJF/SUB03')
         SUMF = RESUL
         IF (SUMF.LT.RTOL) THEN
            CALL PUTFAT ('SUMF too small ... Choose new parameters')
            SUMF = RTOL
         ENDIF
      ELSE
         I = 2
         CALL GETIM1 (I, NPTS, NMAX, 'Value of n required for S(n)')
         XPTS(1) = XSTART
         XPTS(NPTS) = XSTOP
         SPACE = SUMF/(DBLE(NPTS) - 1.0D+00)
         DO I = 2, NPTS - 1
            J = I
            FIX = XPTS(I - 1)
            CALL YSOLVE (J,
     +                   FIX, SPACE, RESUL, XSTOP)
            XPTS(I) = RESUL
         ENDDO
         IF (NTAB.EQ.1) THEN
            IF (NPTS.LE.NXPTS) THEN
               WRITE (LINE,200) NPTS
            ELSE
               WRITE (LINE,300) NXPTS
            ENDIF
            YES = .FALSE.
            ICOLOR = 9
            CALL YESNO2 (ICOLOR, IXL, IYL,
     +                   LINE,
     +                   YES)
            IF (YES) THEN
               J = MIN(NPTS, NXPTS)
               ICOLOR = 15
               CALL TABLE1 (ICOLOR, 'OPEN')
               ICOLOR = 0
               DO I = 1, J
                  WRITE (LINE,400) XPTS(I)
                  CALL TABLE1 (ICOLOR, LINE)
               ENDDO
               CALL TABLE1 (ICOLOR, 'CLOSE')
            ENDIF
         ENDIF
      ENDIF
C
C Format statements
C      
  200 FORMAT ('Display',I4,1X,'x-values ?')
  300 FORMAT ('Display first',I4,1X,'x-values ?')
  400 FORMAT (1P,E11.3)
      END
C
C--------------------------------------------------------------------
C
      SUBROUTINE SUB04

      USE MODULE_EOQSOL, ONLY : NDIS, NPTS,
     +                          RTOL, SUMF, WEIGHT
C
C     ...   CALCULATE THE PARAMETER WEIGHT FOR SUM OR INTEGRAL
C
      IMPLICIT   NONE
      EXTERNAL PUTFAT
      INTRINSIC DBLE
      IF (NDIS.LT.3) THEN
         WEIGHT = 1.0D+00/SUMF
      ELSE
         WEIGHT = 1.0D+00/DBLE(NPTS)
      ENDIF
      IF (WEIGHT.LT.RTOL) THEN
         CALL PUTFAT ('WEIGHT too small ... Choose new parameters')
         WEIGHT = RTOL
      ENDIF
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE SUB05 (ISEND,
     +                  IFAIL, IW1,  LIW1, LW1, LW2, N, NBD, NF1, NPTS1,
     +                  BL, BU, F, G, W1, W2, X,
     +                  QNTYPE, QNPREC)

      USE MODULE_EOQSOL, ONLY : MODNUM, NDIS, NOUT, NPHI, NPTS, NSAV, 
     +                          NTAB, NTHETA, NTVAR, 
     +                          A, B, EPSI, FACT, PHI, QSAVE, RTOL,
     +                          SCALE1, WEIGHT,
     +                          THETA, THETA_REF, SCALE1, SUMF,
     +                          XMU, XSIGMA, XSTART, XSTOP,
     +                          SUMF_REF, SCALE1_REF, WEIGHT_REF, 
     +                          XMU_REF, XSIGMA_REF, XSTART_REF, 
     +                          XSTOP_REF       

C
C This subroutine caused a lot of trouble moving from NAG to QNFIT1/LBFGS.
C In the end I commented out all the NAG code and added all the arguments
C to QNFIT1 as arguments to SUB05 to force saving in the main program.
C My final conclusion was that there is must be an obscure bug in ftn77
C leading to some of the variables becoming undefined and causing a stack
C fault.
C The code to call the NAG routines has been left commented out for ease
C of restoration. 14/11/97
C
C
C     ...   OPTIMISE USING E04ABF OR E04JAF OR QNFIT1/LBFGS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    ISEND,
     +           IFAIL, IW1(*),  LIW1, LW1, LW2, N, NBD(*), NF1, NPTS1
      DOUBLE PRECISION BL(*), BU(*), F, G(*), W1(*), W2(*), X(*)
      CHARACTER  QNTYPE*(*), QNPREC*(*)
C
C Locals
C      
      INTEGER    JSAV
      PARAMETER (JSAV = 250)
      INTEGER    KOUT
      PARAMETER (KOUT = 4)
Cnag**INTEGER    LIWORK, LWORK
Cnag**PARAMETER (LIWORK = 12, LWORK = 145)
Cnag**INTEGER    IWORK(LIWORK)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NTEXT, NSTART,
     +           NUMCOL, NUMROW
      PARAMETER (IXL = 4, IYL = 4, LSHADE = 1, NUMCOL = 0, NUMROW = 0)
      INTEGER    NUMBLD(20), NUMPOS(10)
      INTEGER    I, ITRY
Cnag**INTEGER    IBOUND, MAXCAL
Cnag**DOUBLE PRECISION FMAX, FMIN
Cnag**PARAMETER (FMAX = 1.0D+04, FMIN = 1.0D+00/FMAX)
      DOUBLE PRECISION ASTOP, BSTOP, QVAL, R
Cnag**DOUBLE PRECISION AVAL, BVAL
Cnag**DOUBLE PRECISION E1, E2, F, FDOWN, FUP, XTEMP
Cnag**DOUBLE PRECISION WORK(LWORK)
      DOUBLE PRECISION QSAV(JSAV), TSAV(JSAV), U(JSAV), V(JSAV)
      CHARACTER  (LEN = 13) D13(2), SHOWLJ
      CHARACTER  QNAME*1
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  SHOW_THETA*10, SHOW_X*10
Cnag**LOGICAL    FIRST
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    REPEET, YES
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
Cnag**EXTERNAL  E04ABF, E04JAF, FUNCT
      EXTERNAL  E_FORMATS, SHOWLJ
      EXTERNAL  QNFIT1, DERIV1, FUNCT1, HELP_EOQSOL, REVPRO
      EXTERNAL  TABNOW, PLOTIT
      EXTERNAL  GETD01, PUTFAT, PUTWAR, TABLE1, LBOX01, YESNO1, PUTADV
      INTRINSIC ABS, MAX
C global SAVE at this point will force saving all local variables
C****************************************************************
      SAVE
Cnag**SAVE      QSAV, TSAV
      DATA      NUMBLD / 20*0 /
      DATA      NUMPOS / 10*1 /
Cnag**FIRST = .TRUE.
C**20 CONTINUE


      E_NUMBERS = E_FORMATS()
C
C Get the NPHI starting estimates for PHI
C
      DO I = 1, NPHI
         WRITE (LINE,100) I
         CALL GETD01 (FACT(I), LINE)
      ENDDO
C
C     ... SET UP MAXCAL, FDOWN, FUP THEN LIMITS AVAL AND BVAL
C

C***********************************************************************
Cnag**IF (FIRST) THEN
C        FIRST = .FALSE.
C        MAXCAL = 50
C        FDOWN = 1.0D+00
C        FUP = 1.0D+00
C     ELSE
C        MAXCAL = 100
C        FDOWN = FDOWN/1.0D+01
C        FUP = FUP*1.0D+01
C     ENDIF
C     AVAL = A*FDOWN
C     BVAL = B*FUP
C
C     ... USE E04ABF FOR OPTIMISATION IF NPHI .EQ. 1
C
C     IF (NPHI.EQ.1)THEN
C        E1 = EPSREL
C        E2 = EPSABS
C        XTEMP = 1.0
C        IFAIL = 1
C        CALL E04ABF (FUNCT, E1, E2, AVAL, BVAL, MAXCAL, XTEMP, F,
C    +                IFAIL)
C        X(1) = XTEMP
C        PHI(1) = FACT(1)*X(1)
C        IF (IFAIL.NE.0) THEN
C           WRITE (*,200) IFAIL, PHI(1), F/SCALE
C           CALL GETYES (YES)
C           IF (YES) GOTO 20
C        ENDIF
C
C     ... USE E04JAF FOR OPTIMISATION IF NPHI .GT. 1
C
C     ELSE
C        N = NPHI
C        DO 2 I = 1, NPHI
C           BL(I) = AVAL
C           BU(I) = BVAL
C           X(I) = 1.0D+00
C   2    CONTINUE
C        IBOUND = 2
C        IFAIL = 1
C        CALL E04JAF (N, IBOUND, BL, BU, X, F, IWORK, LIWORK,
C    +                WORK, LWORK, IFAIL)
C        IF (IFAIL.NE.0.AND.IFAIL.NE.5) THEN
C           WRITE (*,300) IFAIL, F/SCALE
C           CALL GETYES (YES)
C           IF (YES) GOTO 20
C        ENDIF
Cnag**ENDIF
C***********************************************************************

C
C Next code for qnfit1
C***********************************************************************
      N = NPHI
      DO I = 1, NPHI
         NBD(I) = 2
         BL(I) = A
         BU(I) = B
         X(I) = 1.0D+00
      ENDDO
      IFAIL = 0
      NPTS1 = 0
      CALL QNFIT1 (DERIV1, FUNCT1,
     +             IFAIL, IW1, LIW1, LW1, LW2, N, NBD, NF1, NPTS1,
     +             BL, BU, F, G, W1, W2, X,
     +             QNTYPE, QNPREC)
C***********************************************************************

C
C     FURTHER CALCULATIONS ON RESULTS FROM OPTIMISATION
C
      QVAL = F/SCALE1
      IF (NDIS.LT.3) THEN
         QNAME = 'Q'
      ELSE
         QNAME = 'S'
      ENDIF
      ASTOP = A + 2.0D+00*EPSI
      BSTOP = B - 2.0D+00*EPSI
      ITRY = 0
C
C Check for parameters at limits
C      
      DO I = 1, NPHI
         IF (ABS(X(I)).LE.ASTOP) THEN
            ITRY = 1
            WRITE (LINE,400) I, 'lower'
            CALL PUTWAR (LINE)
         ELSEIF (ABS(X(I)).GE.BSTOP) THEN
            ITRY = 1
            WRITE (LINE,400) I, 'upper'
            CALL PUTWAR (LINE)
         ENDIF
      ENDDO

Cnag**IF (ITRY.EQ.1) THEN
C        WRITE (*,500) QNAME, QVAL
C        CALL GETYES (YES)
C        IF (YES) GOTO 20
C     ENDIF
C     IF (F.LT.FMIN .OR. F.GT.FMAX) THEN
C        WRITE (*,600) F, QNAME, QVAL, SCALE, QNAME
C        CALL PROMPT
Cnag**ENDIF
C

C
C Open the table ... OUTPUT RESULTS FROM OPTIMISATION
C
      IF (NOUT.EQ.1) THEN
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         ICOLOR = 0
      ENDIF   
      
      IF (NDIS.EQ.1) THEN
C
C Output Q-reference
C        
         QSAVE = QVAL
         DO I = 1, NTHETA
            THETA_REF(I) = THETA(I)
         ENDDO   
         SCALE1_REF = SCALE1
         SUMF_REF = SUMF
         WEIGHT_REF = WEIGHT
         XMU_REF = XMU
         XSIGMA_REF = XSIGMA
         XSTART_REF = XSTART
         XSTOP_REF = XSTOP
         IF (NOUT.EQ.1) THEN
            DO I = 1, NTHETA
               IF (E_NUMBERS) THEN
                  WRITE (LINE,700) I, THETA(I)
               ELSE 
                 D13(1) = SHOWLJ(THETA(I))
                 WRITE (LINE,750) I, D13(1)  
               ENDIF  
               CALL TABLE1 (ICOLOR, LINE)
            ENDDO
         ENDIF
         DO I = 1, NTHETA
            IF (E_NUMBERS) THEN
               WRITE (KOUT,700) I, THETA(I)
            ELSE
               D13(1) = SHOWLJ(THETA(I)) 
               WRITE (KOUT,750) I, D13(1)
            ENDIF     
         ENDDO
      ELSEIF (NDIS.EQ.2) THEN
C
C Store/output Q(1-theta varied)
C      
         IF (NSAV.LT.JSAV) THEN
            NSAV = NSAV + 1
            QSAV(NSAV) = QVAL
            TSAV(NSAV) = THETA(NTVAR)
         ELSE
            CALL PUTFAT ('Store full ... No more Q will be saved')
         ENDIF
         IF (NOUT.EQ.1) THEN
            DO I = 1, NTHETA
               IF (E_NUMBERS) THEN
                  WRITE (LINE,700) I, THETA(I)
               ELSE
                  D13(1) = SHOWLJ(THETA(I))  
                  WRITE (LINE,750) I, D13(1)
               ENDIF    
               CALL TABLE1 (ICOLOR, LINE)
            ENDDO
         ENDIF
         DO I = 1, NTHETA
            IF (E_NUMBERS) THEN
               WRITE (KOUT,700) I, THETA(I)
            ELSE
               D13(1) = SHOWLJ(THETA(I))
               WRITE (KOUT,700) I, D13(1)
            ENDIF      
         ENDDO         
      ELSE
C
C Store/output R(n)
C        
         IF (NSAV.LT.JSAV) THEN
            NSAV = NSAV + 1
            R = ABS((QSAVE - QVAL)/MAX(RTOL,QSAVE))
            QSAV(NSAV) = R
            TSAV(NSAV) = NPTS
         ELSE
            CALL PUTFAT ('Store full ... No more R, S will be saved')
         ENDIF
         IF (NSAV.EQ.1) THEN
            DO I = 1, NTHETA
               IF (E_NUMBERS) THEN
                  WRITE (KOUT,700) I, THETA(I)
               ELSE
                  D13(1) = SHOWLJ(THETA(I)) 
                  WRITE (KOUT,750) I, D13(1)
               ENDIF     
            ENDDO   
         ENDIF
      ENDIF
C
C Calculate PHI in external coordinates
C      
      DO I = 1, NPHI
         PHI(I) = FACT(I)*X(I)
      ENDDO
 
      IF (NOUT.EQ.1) THEN
         DO I = 1, NPHI
            IF (E_NUMBERS) THEN
               WRITE (LINE,900) I, PHI(I)
            ELSE
               D13(1) = SHOWLJ(PHI(I))  
               WRITE (LINE,950) I, D13(1)
            ENDIF    
            CALL TABLE1 (ICOLOR, LINE)
         ENDDO
      ENDIF 
      
      DO I = 1, NPHI
         IF (E_NUMBERS) THEN
           WRITE (KOUT,900) I, PHI(I)
         ELSE
            D13(1) = SHOWLJ(PHI(I)) 
            WRITE (KOUT,950) I, D13(1)
         ENDIF    
      ENDDO           
      
      IF (NDIS.LT.3) THEN
C
C Output Q results
C        
         IF (NOUT.EQ.1) THEN
           IF (E_NUMBERS) THEN
              WRITE (LINE,800) QVAL
           ELSE
              D13(1) = SHOWLJ(QVAL) 
              WRITE (LINE,850) D13(1)
           ENDIF     
           CALL TABLE1 (ICOLOR, LINE)
         ENDIF
         IF (E_NUMBERS) THEN   
            WRITE (KOUT,800) QVAL
         ELSE
            D13(1) = SHOWLJ(QVAL)
            WRITE (KOUT,850) D13(1)
         ENDIF      
      ELSE
C
C Output R results
C       
         IF (NOUT.EQ.1) THEN
            IF (E_NUMBERS) THEN
               WRITE (TEXT,1000) NPTS, QVAL, NPTS, R
            ELSE
               D13(1) = SHOWLJ(QVAL)
               D13(2) = SHOWLJ(R)
               WRITE (TEXT,1050) NPTS, D13(1), NPTS, D13(2)
            ENDIF  
            DO I = 1, 3
               CALL TABLE1 (ICOLOR, TEXT(I))
            ENDDO
         ENDIF 
         IF (E_NUMBERS) THEN  
            WRITE (KOUT,1000) NPTS, QVAL, NPTS, R
         ELSE 
            D13(1) = SHOWLJ(QVAL)
            D13(2) = SHOWLJ(R)  
            WRITE (KOUT,1050) NPTS, D13(1), NPTS, D13(2)
         ENDIF   
      ENDIF
C
C Close down the table
C      
      IF (NOUT.EQ.1) CALL TABLE1 (ICOLOR, 'CLOSE')
      
C
C     ... DECIDE NEXT COURSE OF ACTION
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NOUT.EQ.1) THEN
            SHOW_THETA = '[Yes]'
         ELSE
            NOUT = 0
            SHOW_THETA = '[No]'
         ENDIF
         IF (NTAB.EQ.1) THEN
            SHOW_X = '[Yes]'
         ELSE
            NTAB = 0 
            SHOW_X = '[No]'
         ENDIF 
         D13(1) = SHOWLJ(QSAVE)           
         IF (NDIS.EQ.1) THEN
            NUMOPT = 7
            IF (E_NUMBERS) THEN
               WRITE (TEXT,1100) QSAVE, SHOW_THETA
            ELSE
               WRITE (TEXT,1150) D13(1), SHOW_THETA  
            ENDIF  
         ELSEIF (NDIS.EQ.2) THEN
            NUMOPT = 7
            IF (E_NUMBERS) THEN
               WRITE (TEXT,1200) QSAVE, SHOW_THETA
            ELSE  
               WRITE (TEXT,1250) D13(1), SHOW_THETA
            ENDIF  
         ELSE
            NUMOPT = 8
            IF (E_NUMBERS) THEN
               WRITE (TEXT,1300) QSAVE, SHOW_X, SHOW_THETA
            ELSE 
               WRITE (TEXT,1350) D13(1), SHOW_X, SHOW_THETA  
            ENDIF   
         ENDIF
         ICOLOR = 3
         NSTART = 4
         NTEXT = NSTART + NUMOPT - 1
         ITRY = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, ITRY, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         REPEET = .FALSE. 
         IF (ITRY.EQ.2 .AND. NSAV.GT.0) THEN
            WRITE (TEXT,1400) NSAV, QNAME
            LINE = 'Proceed with this option ?'
            YES = .FALSE.
            ICOLOR = 9
            NTEXT = 2
            CALL YESNO1 (ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW, 
     +                   NTEXT,
     +                   LINE, TEXT, 
     +                   BORDER, FLASH, HIGH,
     +                   YES)
            REPEET = .NOT.YES
         ELSEIF (ITRY.EQ.3 .AND. NDIS.EQ.3) THEN 
            IF (NTAB.EQ.1) THEN
               NTAB = 0
            ELSE
               NTAB = 1
            ENDIF
            REPEET = .TRUE.       
         ELSEIF (ITRY.EQ.NUMOPT - 4) THEN
            IF (NOUT.EQ.1) THEN
               NOUT = 0
            ELSE
               NOUT = 1
            ENDIF
            REPEET = .TRUE.
         ELSEIF (ITRY.EQ.NUMOPT - 3) THEN
            IF (NDIS.EQ.1) THEN
               CALL TABNOW (MODNUM, NDIS, NPTS, 
     +                      SUMF, XSTART, XSTOP)
            ELSE
              IF (NSAV.GT.2) THEN
                 CALL PLOTIT (NDIS, NSAV, NTVAR,
     +                        QSAV, RTOL, TSAV, U, V)
               ELSE
                  CALL PUTADV ('Must have > 2 values accumulated')
               ENDIF
            ENDIF 
            REPEET = .TRUE.  
         ELSEIF (ITRY.EQ.NUMOPT - 2) THEN
            CALL REVPRO (KOUT)
            REPEET = .TRUE.   
         ELSEIF (ITRY.EQ.NUMOPT - 1) THEN   
            CALL HELP_EOQSOL ('eoqsol')
            REPEET = .TRUE.
         ENDIF
      ENDDO
C
C Set the return value for ISEND
C      
      ISEND = ITRY
C
C Format statements
C      
  100 FORMAT ('Starting estimate for phi(',I2,')')
C*200 FORMAT (1X,'WARNING : IFAIL =',I2,1X,'from E04ABF/SUB05'
C    +/11X,'phi(1) =',1P,E10.2,', Q-value =',E9.2
C    +/11X,'Try again ? (Y/N)')
C 300 FORMAT (1X,'WARNING : IFAIL =',I2,1X,'from E04JAF/SUB05'
C    +/11X,'Q-value =',1P,E9.2
C****+/11X,'Try again ? (Y/N)')
  400 FORMAT ('Parameter',I3,' has reached ',A5,' limit')
C*500 FORMAT (A1,'-value =',1P,E9.2 /11X,'Try again ? (Y/N)')
C 600 FORMAT ('WARNING : Obj. fun. =',1P,E9.2,',',1X,A1,1X,'=',
C    +E9.2,', SCALE =',E9.2
C    +/'SUGGEST : Change SCALE (to 1/',A1,') ?)',1X,
C    +'to keep Obj. fun. of order unity'
C****+/'for more reliable computation')
  700 FORMAT (1X,'theta(',I2,') =',1P,E11.3)
  750 FORMAT (1X,'theta(',I2,') =',1X,A13)
  
  800 FORMAT (1X,'Q-value =',1P,E10.3)
  850 FORMAT (1X,'Q-value =',1X,A13)
  
  900 FORMAT (1X,'phi(',I2,') =',1P,E11.3)
  950 FORMAT (1X,'phi(',I2,') =',1X,A13)
  
 1000 FORMAT (1X,'S(',I4,') =',1P,E10.3
     +/       1X,'R(',I4,') =',   E10.3
     +/)
 1050 FORMAT (1X,'S(',I4,') =',1X,A13
     +/       1X,'R(',I4,') =',1X,A13 
     +/)    

     
 1100 FORMAT ('Mode: calculate Q-value then set Q-ref = current Q'
     +/'Variables: all theta values varied'
     +/'New Q-reference =',1P,E10.3
     +/'Change theta value(s), calculate new Q(theta)'
     +/'Return for new model/pdf/wts/mode/stop'
     +/'Display intermediate results',2X,A
     +/'View current g2(x), g1(x)'
     +/'Results'
     +/'Help'
     +/'Exit ... Quit program EOQSOL')
 1150 FORMAT ('Mode: calculate Q-value then set Q-ref = current Q'
     +/'Variables: all theta values varied'
     +/'New Q-reference =',1X,A13
     +/'Change theta value(s), calculate new Q(theta)'
     +/'Return for new model/pdf/wts/mode/stop'
     +/'Display intermediate results',2X,A
     +/'View current g2(x), g1(x)'
     +/'Results'
     +/'Help'
     +/'Exit ... Quit program EOQSOL')
     
 1200 FORMAT ('Mode: calculate set of Q(1-theta)'
     +/'Variables: one theta value varied'
     +/'Current Q-reference =',1P,E10.3
     +/'Change same theta parameter, calculate new Q'
     +/'Return for new model/pdf/wts/mode/stop'
     +/'Display intermediate results',2X,A
     +/'View current Q(theta)'
     +/'Results'
     +/'Help'
     +/'Exit ... Quit program EOQSOL')
 1250 FORMAT ('Mode: calculate set of Q(1-theta)'
     +/'Variables: one theta value varied'
     +/'Current Q-reference =',1X,A13
     +/'Change same theta parameter, calculate new Q'
     +/'Return for new model/pdf/wts/mode/stop'
     +/'Display intermediate results',2X,A
     +/'View current Q(theta)'
     +/'Results'
     +/'Help'
     +/'Exit ... Quit program EOQSOL') 
         
 1300 FORMAT ('Mode: calculate S(n) and R(n)'
     +/'Variables: no. of points n'
     +/'Current Q-reference =',1P,E10.3
     +/'Change n, re-calculate S, R (using same Q-ref)'
     +/'Return for new model/pdf/wts/mode/stop'
     +/'Option to view discrete X-values',2X,A
     +/'Display intermediate results',2X,A
     +/'View current R(n)'     
     +/'Results'
     +/'Help'
     +/'Exit ... Quit program EOQSOL')
 1350 FORMAT ('Mode: calculate S(n) and R(n)'
     +/'Variables: no. of points n'
     +/'Current Q-reference =',1X,A13
     +/'Change n, re-calculate S, R (using same Q-ref)'
     +/'Return for new model/pdf/wts/mode/stop'
     +/'Option to view discrete X-values',2X,A
     +/'Display intermediate results',2X,A
     +/'View current R(n)'     
     +/'Results'
     +/'Help'
     +/'Exit ... Quit program EOQSOL')   
       
 1400 FORMAT (
     + 'The Q-reference value will not be lost but, with this option,'
     +/'the',I3,1X,'stored values for',1X,A1,1X,'will be discarded.')
      END
C
C
