C
C EOQSOL2.FOR
C ===========
C DERIV1: Derivative for objective function
C FUNCT : Objective function when NPHI = 1
C FUNCT1: Objective function
C PLOTIT: Plot
C TABNOW: Table
C XSOLVE: Interval
C YSOLVE: Intervals
C FD    : Main function
C FQ    : Main function
C FW    : Main function
C
C
C
C
      subroutine deriv1 (funct, n, g, w, x)
c
c action : finite difference approximation to derivatives using qngrd1
c
      implicit   none
c
c arguments
c      
      integer,          intent (in)    :: n
      double precision, intent (inout) :: g(n), w(3*n), x(n)
c
c locals
c      
      integer    inform
      logical    tpoint
      parameter (tpoint = .false.)
      external   funct, qngrd1
      call qngrd1 (funct, inform, n, g, w, x, tpoint)
      end
C
C-------------------------------------------------------------------
C
      SUBROUTINE FUNCT (XC, FC)
C
C     ...   EVALUATE OBJECTIVE FUNCTION WHEN NPHI = 1
C
      IMPLICIT NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN)  :: XC
      DOUBLE PRECISION, INTENT (OUT) :: FC
C
C Locals
C      
      INTEGER  N
      DOUBLE PRECISION X(1)
      EXTERNAL FUNCT1
      X(1) = XC
      N = 1
      CALL FUNCT1 (N, 
     +             X, FC)
      END
C
C---------------------------------------------------------------------------
C
      SUBROUTINE FUNCT1 (N,
     +                   XC, FC)

      USE MODULE_EOQSOL, ONLY : KOUT,
     +                          IW, LIW, LW, NDIS, NPHI, NPTS, 
     +                          EPSABS, EPSREL, FACT, PHI, SCALE1, W, 
     +                          XPTS, XSTART, XSTOP       
C
C     ...   EVALUATE OBJECTIVE FUNCTION
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      DOUBLE PRECISION, INTENT (IN)  :: XC(N)
      DOUBLE PRECISION, INTENT (OUT) :: FC
C
C Locals
C           
      INTEGER    I, IFAIL
      DOUBLE PRECISION ABSERR, X1, X2
      DOUBLE PRECISION FQ
      EXTERNAL FQ
      EXTERNAL D01AJF$
      EXTERNAL PUTIFA
      DO I = 1, NPHI
         PHI(I) = FACT(I)*XC(I)
      ENDDO
      IF (NDIS.LT.3) THEN
         X1 = XSTART
         X2 = XSTOP
         IFAIL = 1
         CALL D01AJF$(FQ, X1, X2, EPSABS, EPSREL, FC, ABSERR, W,
     +                LW, IW, LIW, IFAIL)
         CALL PUTIFA (IFAIL, KOUT, 'D01AJF/FUNCT1')
      ELSE
         FC = 0.0D+00
         DO I = 1, NPTS
            FC = FC + FQ(XPTS(I))
         ENDDO
      ENDIF
      FC = FC*SCALE1
      END
C
C---------------------------------------------------------------------
C
      SUBROUTINE PLOTIT (NDIS, NSAV, NTVAR,
     +                   QSAV, RTOL, TSAV, U, V)
C
C     ... PLOT Q/THETA, LOG(Q)/LOG(THETA), S(N) OR LOG(S)/LOG(N)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    NDIS, NSAV, NTVAR
      DOUBLE PRECISION QSAV(NSAV), RTOL, TSAV(NSAV), U(NSAV), V(NSAV)
C
C Locals
C      
      INTEGER    L0, L1, L3
      PARAMETER (L0 = 0, L1 = 1, L3 = 3)
      INTEGER    ICOLOR, IXL, IYL, NUMOPT
      PARAMETER (IXL = 4, IYL = 4, NUMOPT = 3)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    I, NDEC
      CHARACTER  PTITLE*29, XTITLE*15, YTITLE*8
      CHARACTER  RECORD*15, Q*1
      CHARACTER  TEXT(NUMOPT)*100
      LOGICAL    AXES
      PARAMETER (AXES = .TRUE.)
      LOGICAL    YES
      EXTERNAL   ABSORT, LBOX02, GKS004
      INTRINSIC  LOG10, MAX
      DATA       NUMPOS / NUMOPT*1 /
      IF (NDIS.LT.3) THEN
         Q = 'Q'
      ELSE
         Q = 'R'
      ENDIF
C      WRITE (LINE,100) NSAV, Q
C      YES = .TRUE.
C      ICOLOR = 9
C      CALL YESNO2 (ICOLOR, IXL, IYL, LINE, YES)
C      IF (.NOT.YES) RETURN
      YES = .TRUE.
      CALL ABSORT (NSAV, TSAV, QSAV)
   20 CONTINUE
      IF (NDIS.LT.3) THEN
         WRITE (TEXT,200) NTVAR, NTVAR
      ELSE
         WRITE (TEXT,300)
      ENDIF
      NDEC = 1
      ICOLOR = 3
      CALL LBOX02 (ICOLOR, IXL, IYL, NDEC, NUMOPT, NUMPOS,
     +             TEXT)
      IF (NDEC.EQ.1) THEN
         DO I = 1, NSAV
            U(I) = QSAV(I)
            V(I) = TSAV(I)
         ENDDO
         IF (NDIS.LT.3) THEN
            PTITLE = Q//' as a function of theta'
            YTITLE = Q//'(theta)'
            WRITE (RECORD, 400) NTVAR
         ELSE
            PTITLE = '  '//Q//' as a function of n  '
            YTITLE = '  '//Q//'(n)  '
            WRITE (RECORD, 500)
         ENDIF
      ELSEIF (NDEC.EQ.2) THEN
         DO I = 1, NSAV
            U(I) = LOG10(MAX(QSAV(I),RTOL))
            V(I) = LOG10(MAX(TSAV(I),RTOL))
         ENDDO
         YTITLE = 'log('//Q//')'
         IF (NDIS.LT.3) THEN
            PTITLE = 'log('//Q//') against log(theta)'
            WRITE (RECORD, 600) NTVAR
         ELSE
            PTITLE = '  log('//Q//') against log(n)  '
            WRITE (RECORD, 700)
         ENDIF
      ENDIF
      IF (NDEC.LT.3) THEN
         XTITLE = RECORD
         YES = .TRUE.
         CALL GKS004 (L0, L1, L0, L0, L0, L3, L0, L0,
     +                NSAV, NSAV, NSAV, NSAV,
     +                V, V, V, V,
     +                U, U, U, U,
     +                PTITLE, XTITLE, YTITLE,
     +                AXES, YES)
         GOTO 20
      ELSE
         RETURN
      ENDIF
C
C Format statements
C      
C  100 FORMAT ('Plot the',1X,I3,1X,'stored',1X,A1,1X,'values ?')
  200 FORMAT ('Plot of Q against theta(',I2,')'
     +/'Log10(Q) vs log10(theta(',I2,'))'
     +/'Quit')
  300 FORMAT ('Plot of R against n'
     +/'Log10(R) vs log10(n)'
     +/'Quit')
  400 FORMAT ('  theta(',I2,' )   ')
  500 FORMAT ('       n       ')
  600 FORMAT ('log(theta(',I2,' ))')
  700 FORMAT ('    log(n)     ')
       END
C
C--------------------------------------------------------------------------
C
      SUBROUTINE TABNOW (MODNUM, NDIS, NPTS,
     +                   SUMF, XSTART, XSTOP)
C
C     ...   TABLES/GRAPHS FOR X, G2(X), G1(X) IF REQUIRED
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    MODNUM, NDIS, NPTS
      DOUBLE PRECISION SUMF, XSTART, XSTOP
C
C Locals
C      
      INTEGER    NGRAPH, NLINES
      PARAMETER (NGRAPH = 80, NLINES = NGRAPH)
      INTEGER    L0, L1, L2
      PARAMETER (L0 = 0, L1 = 1, L2 = 2)
      INTEGER    I, J, NUMBER, NMIN1
      INTEGER    ICOLOR, IXL, IYL
      PARAMETER (IXL = 4, IYL = 4)
      DOUBLE PRECISION FIX, RESUL, RNMIN1, SPACE, TA, TB, TC, TD, TE
      DOUBLE PRECISION FQ, G1, G2,TEMP
      DOUBLE PRECISION T1(NGRAPH), T2(NGRAPH), TG1(NGRAPH), TG2(NGRAPH)
      CHARACTER (LEN = 13) D13(5), SHOWRJ
      CHARACTER  PTITLE*28, XTITLE*8, YTITLE*15
      CHARACTER  LINE*100
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AXES
      PARAMETER (AXES = .TRUE.)
      LOGICAL    YES
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   FQ, G1, G2
      EXTERNAL   GETIM1, TABLE1, YESNO2, GKS004
      EXTERNAL   YSOLVE
      INTRINSIC  MIN, DBLE
      I = MODNUM!to silence ftn95 
      E_NUMBERS = E_FORMATS()
      WRITE (LINE,100)
      YES = .FALSE.
      ICOLOR = 9
      CALL YESNO2 (ICOLOR, IXL, IYL,
     +             LINE,
     +             YES)
      IF (YES) THEN
         IF (NDIS.LT.3) THEN
C***********WRITE (*,200) NLINES
            I = 2
            CALL GETIM1 (I, NUMBER, NLINES,
     +                  'Number of lines for table (> 1)')
         ELSE
            NUMBER = MIN(NPTS, NLINES)
         ENDIF
         IF (NUMBER.LT.2) NUMBER = 2
         T1(1) = XSTART
         T1(NUMBER) = XSTOP
         NMIN1 = NUMBER - 1
         RNMIN1 = NMIN1
         SPACE = SUMF/RNMIN1
         DO I = 2, NMIN1
            J = I
            FIX = T1(I - 1)
            CALL YSOLVE (J, FIX, SPACE, RESUL, XSTOP)
            T1(I) = RESUL
         ENDDO
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         ICOLOR = 4
         WRITE (LINE,300)
         CALL TABLE1 (ICOLOR, LINE)
         ICOLOR = 0
         DO I = 1, NUMBER
            TA = T1(I)
            IF (E_NUMBERS) THEN
               TB = G2(TA)
               TC = G1(TA)
               TD = (G2(TA) - G1(TA))**2
               TE = FQ(TA)
               WRITE (LINE,400) TA, TB, TC, TD, TE
            ELSE
                D13(1) = SHOWRJ(T1(I))
                D13(2) = SHOWRJ(G2(TA))
                D13(3) = SHOWRJ(G1(TA))
                TEMP = (G2(TA) - G1(TA))**2
                D13(4) = SHOWRJ(TEMP)
                D13(5) = SHOWRJ(FQ(TA))
                WRITE (LINE,450) (D13(J), J = 1, 5)
            ENDIF  
            CALL TABLE1 (ICOLOR, LINE)
         ENDDO
         CALL TABLE1 (ICOLOR, 'CLOSE')
      ENDIF
      WRITE (LINE,500)
      ICOLOR = 9
      YES = .TRUE.
      CALL YESNO2 (ICOLOR, IXL, IYL,
     +             LINE, 
     +             YES)
      IF (YES) THEN
         SPACE = (XSTOP - XSTART)/(DBLE(NGRAPH) - 1.0D+00)
         DO I = 1, NGRAPH
            IF (I.EQ.1) THEN
               T1(I) = XSTART
            ELSEIF (I.EQ.NGRAPH) THEN
               T1(I) = XSTOP
            ELSE
               T1(I) = T1(I - 1) + SPACE
            ENDIF
            T2(I) = T1(I)
            TG1(I) = G1(T1(I))
            TG2(I) = G2(T2(I))
         ENDDO
         PTITLE = 'g2 (solid), g1 (dashed line)'
         XTITLE = 'x-values'
         YTITLE = 'g2(x) and g1(x)'
         CALL GKS004 (L1, L2, L0, L0, L0, L0, L0, L0,
     +                NGRAPH, NGRAPH, NGRAPH, NGRAPH,
     +                T2, T1, T1, T1, TG2, TG1, TG1, TG1,
     +                PTITLE, XTITLE, YTITLE, AXES, YES)
      ENDIF
C
C Format statements
C      
  100 FORMAT ('Display tables of x, g2(x), g1(x) ?')
C*200 FORMAT (/11X,'Max. lines in table =',I4)
  300 FORMAT (13X,'x',9X,'g2(x)',9X,'g1(x)',5X,'(g2-g1)^2',
     +5X,'Integrand')
  400 FORMAT (1P,5(1X,E13.5))
  450 FORMAT (5(1X,A13))
  500 FORMAT ('Display graphs of x, g1(x), g2(x) ?')
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE XSOLVE (ITIME,
     +                   CONST, RESUL)

      USE MODULE_EOQSOL, ONLY : KOUT,
     +                          NXIN,
     +                          TOLX       
C
C     ...   CALCULATE XSTART, XSTOP WHERE G2(XSTART OR XSTOP) = CONST
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    ITIME
      DOUBLE PRECISION CONST, RESUL
C
C Locals
C      
      INTEGER    LC
      PARAMETER (LC = 17)
      INTEGER    ICOUNT, IFAIL, IND, IR
      DOUBLE PRECISION FX, GX1, GX2, X1, X2
      DOUBLE PRECISION C(LC)
      DOUBLE PRECISION G2
      DOUBLE PRECISION XMAX, XMIN, ZERO
      PARAMETER (XMAX = 1.0D+30, XMIN = 0.0D+00, ZERO = 0.0D+00)
      CHARACTER  LINE*80
      EXTERNAL G2
      EXTERNAL GETRL2, PUTIFA, PUTADV
      EXTERNAL C05AZF$
      IF (NXIN.EQ.3 ) GOTO 2
    1 CONTINUE
      IF (ITIME.EQ.1) THEN
         CALL GETRL2 (XMIN, ZERO, X1, X2, XMAX,
     +               'Upper-, lower-estimates for Xstart')
      ELSE
         CALL GETRL2 (XMIN, ZERO, X1, X2, XMAX,
     +               'Upper-, lower-estimates for Xstop')
      ENDIF
      GX1 = G2(X1)
      GX2 = G2(X2)
      IF ((GX1 - CONST)*(GX2 - CONST).GT.ZERO) THEN
         WRITE (LINE,100) GX1, GX2
         CALL PUTADV (LINE)
         GOTO 1
      ENDIF
      GOTO 4
    2 CONTINUE
      ICOUNT = 0
      X1 = 0.0D+00
      X2 = 1.0D-06
    3 CONTINUE
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.10) THEN
         WRITE (LINE,100) GX1, GX2
         CALL PUTADV (LINE)
         RESUL = 0.0D+00
         RETURN
      ENDIF
      X2 = 1.0D+03*X2
      GX1 = G2(X1)
      GX2 = G2(X2)
      IF ((GX1 - CONST)*(GX2 - CONST).GT.0.0D+00) GOTO 3
    4 CONTINUE
      IR = 2
      IND = 1
      IFAIL = 1
    5 CONTINUE
      CALL C05AZF$(X1, X2, FX, TOLX, IR, C, IND, IFAIL)
      IF (IND.EQ.0) GOTO 6
      FX = G2(X1) - CONST
      GOTO 5
    6 CONTINUE
      RESUL = X1
      CALL PUTIFA (IFAIL, KOUT, 'C05AZF/XSOLVE')
C
C Format statement
C      
  100 FORMAT ('FAILURE : g2(x1) = ',1P,E11.3,', g2(x2) = ',E11.3)
      END
C
C----------------------------------------------------------------------------
C
      SUBROUTINE YSOLVE (J, 
     +                   FIX, SPACE, RESUL, XSTOP)

      USE MODULE_EOQSOL, ONLY : KOUT,
     +                          IW, LIW, LW,  
     +                          EPSABS, EPSREL, TOLX, W
C
C     ...   CALCULATE DISCRETE INTERVALS FOR XPTS(I)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    J
      DOUBLE PRECISION FIX, SPACE, RESUL, XSTOP
C
C Locals
C      
      INTEGER    LC
      PARAMETER (LC = 17)
      INTEGER    IFAIL, IND, IR, JFAIL
      DOUBLE PRECISION ABSERR, AREA, FD, FX, X1, X2
      DOUBLE PRECISION C(LC)
      CHARACTER   LINE*100
      EXTERNAL C05AZF$, D01AJF$, PUTWAR
      EXTERNAL FD
      X1 = FIX
      X2 = XSTOP
      IR = 2
      IND = 1
      IFAIL = 1
    1 CONTINUE
      CALL C05AZF$(X1, X2, FX, TOLX, IR, C, IND, IFAIL)
      IF (IND.EQ.0) GOTO 2
      JFAIL = 1
      CALL D01AJF$(FD, FIX, X1, EPSABS, EPSREL, AREA, ABSERR, W,
     +             LW, IW, LIW, JFAIL)
      IF (JFAIL.NE.0) THEN
         WRITE (LINE,100) JFAIL, J
         WRITE (KOUT,100) JFAIL, J
         CALL PUTWAR (LINE)
      ENDIF
      FX = SPACE - AREA
      GOTO 1
    2 CONTINUE
      RESUL = X1
      IF (IFAIL.NE.0) THEN
         WRITE (LINE,200) IFAIL, J
         WRITE (KOUT,200) IFAIL, J
         CALL PUTWAR (LINE)
      ENDIF
C
C Format statements
C      
  100 FORMAT (1X,'IFAIL =',I2,', J =',I2,' D01AJF/YSOLVE')
  200 FORMAT (1X,'IFAIL =',I2,', J =',I2,' C05AZF/YSOLVE')
      END
C
C----------------------------------------------------------------
C
      FUNCTION FD (X)

      USE MODULE_EOQSOL, ONLY : NPDF,
     +                          ENEG, RTOL, XMU, XSIGMA, XSTART, XSTOP 
C
C     ...   DENSITY FUNCTIONS (UN-NORMALISED)
C
      IMPLICIT   NONE
C
C Argument
C
      DOUBLE PRECISION, INTENT (IN) :: X
C
C Locals
C      
      DOUBLE PRECISION HALF, ONE
      PARAMETER (HALF = 0.5D+00, ONE = 1.0D+00)
      DOUBLE PRECISION ARG
      DOUBLE PRECISION DG2DX, FD
      EXTERNAL  DG2DX
      INTRINSIC EXP
      IF (NPDF.EQ.1) THEN
         FD = ONE
      ELSEIF (NPDF.EQ.2) THEN
         ARG = X
         IF (ARG.LT.RTOL) ARG = RTOL
         FD = ONE/ARG
      ELSEIF (NPDF.EQ.3) THEN
         ARG = XSTART + XSTOP - X
         IF (ARG.LT.RTOL) ARG = RTOL
         FD = ONE/ARG
      ELSEIF (NPDF.EQ.4) THEN
         FD = XSTOP - X
      ELSEIF (NPDF.EQ.5) THEN
         FD = X - XSTART
      ELSEIF (NPDF.EQ.6) THEN
         ARG = - HALF*((X - XMU)/XSIGMA)**2
         IF (ARG.LT.ENEG) ARG = ENEG
         FD =  EXP(ARG)
      ELSEIF (NPDF.EQ.7) THEN
         FD = DG2DX(X)
      ELSE
         FD = 0.0D+00
      ENDIF
      END
C
C---------------------------------------------------------
C
      FUNCTION FQ (X)

      USE MODULE_EOQSOL, ONLY : NDIS,
     +                          WEIGHT     
C
C     ...   INTEGRAND/SUMMAND FOR THE Q/S-FUNCTION
C
      IMPLICIT NONE
C
C Argument
C      
      DOUBLE PRECISION, INTENT (IN) :: X
C
C Locals
C      
      DOUBLE PRECISION WT
      DOUBLE PRECISION FD, FW, G1, G2
      DOUBLE PRECISION FQ
      EXTERNAL FD, FW, G1, G2
      IF (NDIS.LT.3) THEN
         WT = FW(X)*FD(X)*WEIGHT
      ELSE
         WT = FW(X)*WEIGHT
      ENDIF
      FQ = WT*((G2(X) - G1(X))**2)
      END
C
C-------------------------------------------------------------------
C
      FUNCTION FW (X)

      USE MODULE_EOQSOL, ONLY : NWTS,
     +                          RTOL, S1, S0   
C
C     ...   WEIGHT FUNCTIONS (UN-NORMALISED)
C
      IMPLICIT   NONE
C
C Argument
C      
      DOUBLE PRECISION, INTENT (IN) :: X
C
C Locals
C      
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      DOUBLE PRECISION ARG
      DOUBLE PRECISION FW
      DOUBLE PRECISION G2
      EXTERNAL G2
      IF (NWTS.EQ.1) THEN
         FW = ONE
      ELSEIF (NWTS.EQ.2) THEN
         ARG = G2(X)**2
         IF (ARG.LT.RTOL) ARG = RTOL
         FW = ONE/ARG
      ELSE
         ARG = S0 + S1*(G2(X)**2)
         IF (ARG.LT.RTOL) ARG = RTOL
         FW = ONE/ARG
      ENDIF
      END
C
C
