C
C
C This version of EXFIT also requires the following source files
C ===============================================================
C
C EXFIT1.FOR: ADVISE, DATAIN, DATFIT, DATOUT
C EXFIT2.FOR: DETAIL, LSFUN1, LSFUN2, RANDOM
C EXFIT3.FOR: VMATRX, FMOD, RANNUM
C EXFIT4.FOR: LMFUNC, LSJAC1, JMOD
C
C These must now be included
C ==========================
C
C     INCLUDE 'exfit1.for', NOLIST
C     INCLUDE 'exfit2.for', NOLIST
C     INCLUDE 'exfit3.for', NOLIST
C     INCLUDE 'exfit4.for', NOLIST
C     INCLUDE 'dllchk.for'
C

C-----------------------------------------
C Start of Module to replace common blocks
C-----------------------------------------
      MODULE MODULE_EXFIT
      
      IMPLICIT NONE
         
      INTEGER    IOVER, ITIME, IUNDER, NMAX, NPTS, NRMAX
      DOUBLE PRECISION ENEG, EPOS, EPSI, ETOL, RTOL, XBIG, YBIG
      LOGICAL    CIN, TYPE12, TYPE34, TYPE56
        
      DOUBLE PRECISION, ALLOCATABLE :: ERRY(:), THEORY(:), XVAL(:),
     +                                 YVAL(:)
      LOGICAL,          ALLOCATABLE :: EQUAL(:)
         
      END MODULE MODULE_EXFIT
C---------------------------------------
C End of module to replace common blocks
C---------------------------------------      

C
C
      PROGRAM MAIN
C
C VERSION : details from SIMVER/DLLCHK
C FORTRAN : 95, double precision
C NAG     : E04FDF, E04YCF, G01EDF, G01FDF, G05CAF, G05CCF, G05DDF,
C           X02AJF, X02ALF, X02AMF
C INPUT   : File with TITLE, NPTS, X, Y, Standard error in Y.
C ACTION  : Best fit unconstrained exponential function using the
C           NAG Gauss-Newton routine E04FDF, then an F test.
C           X- and Y-data transformed to 'order unity' internally.
C MODELS  : 1. Summation A(I)*EXP( - K(I)*T)
C           2. Summation A(I)*EXP( - K(I)*T) + C
C           3. Summation B(I)*(1.0 - EXP( - K(I)*T))
C           4. Summation B(I)*(1.0 - EXP( - K(I)*T)) + C
C           5. As 1 with A(N) = A(N-1)
C           6. As 2 with A(N) = A(N-1)
C OUTPUT  : Wtd. sums of squares, F statistics, parameters, errors
C           and residuals as requested. Details can be written to a file
C ADVICE  : Make sure that the standard errors in Y are > 0.0.
C           NN = maximum no. of exponentials
C           NX = maximum no. of parameters
C           NMAX = maximum no. of data points
C           NCMAX = maximum no. of columns (= NX)
C           NRMAX = maximum no. of rows (= NMAX)
C           NF = output unit
C           NIN = input unit
C           COMMON blocks are required to communicate with the model
C AUTHOR  : W. G. Bardsley, 9/12/86
C REVISED : 05/04/1990 GRAF2A, OFILES, PROBRS, PROMPT
C           06/05/1991 GRFGK2/3, RES001, extensive use of W
C           22/05/1991 GKS002/3, RESGKS
C           19/05/1992 CHECKT, ENDALL, REPEAT, GETNUM, GETCHR, GKSR01
C           12/06/1992 CHECKW, GKST02
C           16/06/1992 DIVIDE
C           22/06/1992 SYMBOL and random search explores UP/DOWN and DOWN/UP curves
C           11/01/1993 Added GET??? and PUT??? and compressed
C           08/04/1993 Added GKST04
C           09/04/1993 Added models 5 and 6 and extensive changes to RANDOM
C           14/06/1993 RESFIL
C           13/04/1994 DBOS version
C           20/02/1995 Salamanca version
C           23/10/1995 Split into EXFIT.FOR, EXFIT1.INS, EXFIT2.INS. EXFIT3.INS
C                      and replaced all direct calls to DBOS routines
C           30/08/1997 win32 version using LMFIT1/MINPACK instead of E04FDF
C           20/03/1998 Introduced GOGOGO for in-line editing
C           01/10/1998 added dllchk
C           14/12/1998 replaced TUTORS by TUTOR1
C           18/08/1999 revised control
C           13/09/1999 added call to WINDOW
C           12/02/2000 added SIMVER
C           23/03/2001 revised
C           04/05/2001 added call to GDCON0 for deconvolution
C           18/05/2001 increased dimension of NOUT to allow call to PCVTST
C           16/06/2001 added ARRPAR to DATOUT to rearrange parameters
C           03/01/2005 added relaxation fitting when TYPE56 = .TRUE.
C           29/07/2005 increased DVEr to *30 and added to call to ADVISE
C           24/10/2007 edited to replace COMMON by MODULE_EXFIT and for version 6
C           23/04/2010 replaced FNAME1(4), NCOL(4), NROW(4) by FNAME1, NCOL, NROW
C

      USE MODULE_EXFIT

      IMPLICIT   NONE
      INTEGER    NN, NX, N0, N1, N10
      PARAMETER (NN = 6, NX = 2*NN + 1, N0 = 0, N1 = 1, N10 = 10)
      INTEGER    NCMAX
      PARAMETER (NCMAX = NX)
      INTEGER    NF, NIN
      PARAMETER (NF = 4, NIN = 3)
      INTEGER    NGRAF
      PARAMETER (NGRAF = 200)
      INTEGER    IPVT(NCMAX)
      INTEGER    NRAND, NSTART, NSTOP
      INTEGER    NDOF, NPAR(NN)
      INTEGER    NPSAV(NN), NSSAV
      INTEGER    I, IERR, ISEND, IOS, J, ITYPE, ITYPE_SAV
      INTEGER    I_STATUS, I_LENGTH,ITEMP 
      INTEGER    NCOL, NROW
      DOUBLE PRECISION, ALLOCATABLE :: FJAC(:,:), FVEC(:), W(:)
      
      DOUBLE PRECISION CV(NCMAX,NCMAX), P(NCMAX), SE(NCMAX),
     +                 TSIG(NCMAX), WSSQ(NN), X(NCMAX)
      DOUBLE PRECISION WSSAV(NN)
      DOUBLE PRECISION XT, YT, Y0, YN
      DOUBLE PRECISION XGRAF1(NGRAF), XGRAF2(NGRAF), YGRAF(NGRAF),
     +                 YSAV(NGRAF)
      DOUBLE PRECISION X02AJF$, X02ALF$, X02AMF$
      DOUBLE PRECISION XVER, YVER
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  FNAME1*1024, FNAME2*1024, TITLE*100
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_exfit.exe')
      CHARACTER  BLANK*1, LETTER*1, PNAME*5
      PARAMETER (BLANK = ' ', PNAME = 'EXFIT')
      CHARACTER (LEN =30) COMMAND
      CHARACTER  MESSAGE*80, RELFIT*80
      PARAMETER (MESSAGE = 'Relaxation fitting will now be tried',
     +           RELFIT = 'Results for relaxation fit')
      LOGICAL    ABORT, ACTION, DOIT, JUMP, REPEET, SHOW
      LOGICAL    FIRST, ISTOP, NEW, NOUT(N10), UPDOWN
      DATA       ITYPE_SAV / 0 / 
      EXTERNAL   G05CCF$, X02AJF$, X02AMF$, X02ALF$
      EXTERNAL   ADVISE, DATAIN, DETAIL, RANDOM, DATFIT, VMATRX,
     +           DATOUT, GOGOGO, M_FITONE, PUTADV
      EXTERNAL   DLLCHK, WINDOW, SIMVER
      INTRINSIC  LOG, SQRT

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C
C
C First check the command line to initialise ISEND and JUMP
C
      ITEMP = COMMAND_ARGUMENT_COUNT()  
      IF (ITEMP.EQ.N1) THEN
         CALL GET_COMMAND_ARGUMENT (N1, COMMAND, I_LENGTH, I_STATUS)
         IF (I_LENGTH.GE.N1 .AND. I_STATUS.EQ.N0) THEN
C
C 29/10/2023
C Replaced non-integer characters by blanks to interpret '0' as 0 which causes trouble otherwise
C It appears that 'i' is passed by run_program and returned as such by command argument 
C retrieval and read accurately except for '0' which is not read as 0 even if the quotes are 
C removed. Is it being read as a C string terminator ? So 0 is changed to 11 to call sv_simstat. 
C         
            do i = 1, i_length
               letter = command(i:i)
               j = ichar(letter)
               if (j.lt.48 .or. j.gt.57) command(i:i) = blank
            enddo  
             
            READ (COMMAND,*,IOSTAT=IOS) I
             
            IF (IOS.EQ.N0) THEN
               IF (I.GE.N1 .AND. I.LE.N10) THEN
                  ITEMP = I
               ELSE
                  ITEMP = N0
               ENDIF
            ELSE
               ITEMP = N0
            ENDIF
         ELSE
            ITEMP = N0
         ENDIF      
      ENDIF
      IF (ITEMP.EQ.N0) THEN
         JUMP = .FALSE.
      ELSE
         JUMP = .TRUE.
      ENDIF
C
C Advise user
C
      FIRST = .TRUE.
      IF (JUMP) THEN
         ISTOP = .FALSE.
      ELSE   
         CALL ADVISE (DVER,
     +                ISTOP, FIRST)
      ENDIF
      IF (ISTOP) THEN
         DOIT = .FALSE.
      ELSE
         DOIT = .TRUE.
      ENDIF
      IF (DOIT) THEN
C
C Initialise ... Assign EPSI and RTOL, etc.
C
         EPSI = X02AJF$()
         RTOL = 1.0D+09*X02AMF$()
         ENEG = 0.125D+00*LOG(RTOL)
         EPOS = - ENEG/2.0D+00
         ETOL = SQRT(RTOL)
         XBIG = X02ALF$()/1.0D+09
         YBIG = SQRT(XBIG)
         DO I = 1, NCMAX
            X(I) = ZERO
         ENDDO
         DO I = 1, NN
            NPAR(I) = 0
            WSSQ(I) = ZERO
         ENDDO
C
C Initialise NEW, NCOL, NROW and FNAME1 (one set for each mode)
C
         NEW = .TRUE.
         ITYPE = 0
         FNAME1 = BLANK
         TITLE = BLANK
         NCOL = 0
         NROW = 0
         FNAME2 = BLANK
C
C Initialise output types
C nout(1)  ... display analysis table
C nout(2)  ... display starting estimates
C nout(3)  ... display random search
C nout(4)  ... plot    best fit curves
C nout(5)  ... plot    residuals
C nout(6)  ... display residuals table
C nout(7)  ... file    residuals table
C nout(8)  ... store/test parameters/covariance matrix
C nout(9)  ... proceed to relaxation fit
c nout(10) ... deconvolution 
C
         NOUT(1) = .TRUE.
         NOUT(2) = .FALSE.
         NOUT(3) = .FALSE.
         NOUT(4) = .TRUE.
         NOUT(5) = .FALSE.
         NOUT(6) = .TRUE.
         NOUT(7) = .FALSE.
         NOUT(8) = .FALSE.
         NOUT(9) = .TRUE.
         IF (JUMP) NOUT(9) = .FALSE.
         NOUT(10) = .TRUE.
         NRAND = 1
         NSTART = 1
         NSTOP = 2
C
C Initialise random number generator
C
         CALL G05CCF$
C
C End of initialisation ... start of main loop
C
         REPEET = .TRUE.
         DO WHILE (REPEET)
C
C Select model type required as follows:
C ITYPE = argument to M_FITONE
C
            ISEND = 1
            CALL DETAIL (ISEND, NF, NN, NRAND, NSTART, NSTOP, N10,
     +                   CIN, ISTOP, JUMP, NOUT, TYPE12, TYPE34, TYPE56)
            IF (TYPE12) THEN
C
C Models 1 and 2
C              
               ITYPE = 7
            ELSEIF (TYPE34) THEN
C
C Models 3 and 4
C            
               ITYPE = 8
            ELSEIF (TYPE56) THEN
C
C Models 5 and 6
C            
               IF (CIN) THEN
                  ITYPE = 10
               ELSE
                  ITYPE = 9
               ENDIF      
            ENDIF         
            IF (ISTOP) THEN
               DOIT = .FALSE.
            ELSE
               DOIT = .TRUE.
            ENDIF
C---------------------------------------------------------------------            
C 22/11/2023 If ITYPE has been changed then force the call to M_FITONE
C  
            IF (ITYPE.NE.ITYPE_SAV) THEN
               NEW = .TRUE.
               ITYPE_SAV = ITYPE
               NCOL = 0
               NROW = 0
            ENDIF    
C---------------------------------------------------------------------
C     
           IF (DOIT .AND. NEW) THEN
C
C Locate a new data set
C              
               CALL M_FITONE (ITYPE, NCOL, NIN, NROW,
     +                        FNAME1, TITLE)
               IF (NROW.GT.2) THEN
                  NEW = .FALSE.
                  NPTS = NROW                
                  IERR = 0
                  IF (ALLOCATED(ERRY)) DEALLOCATE(ERRY, STAT = IERR)
                  IF (IERR.NE.0) EXIT   
                  IF (ALLOCATED(THEORY)) DEALLOCATE(THEORY, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(XVAL)) DEALLOCATE(XVAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(YVAL)) DEALLOCATE(YVAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(EQUAL)) DEALLOCATE(EQUAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(FJAC)) DEALLOCATE(FJAC, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(FVEC)) DEALLOCATE(FVEC, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
                  IF (IERR.NE.0) EXIT      
                  NMAX = NPTS
                  NRMAX = NMAX
                  ALLOCATE(ERRY(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  ALLOCATE(THEORY(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(XVAL(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(YVAL(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(EQUAL(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(FJAC(NRMAX,NCMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(FVEC(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(W(10*NRMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  
               ELSE
                  DOIT = .FALSE.     
               ENDIF     
            ENDIF   
            IF (DOIT) THEN
C
C Read in the data
C
               CALL DATAIN (NF, NIN, NPTS, NRMAX,
     +                      ERRY, RTOL, XT, XVAL, YN, YT, YVAL, Y0,
     +                      FNAME1, FNAME2,
     +                      EQUAL, ISTOP, JUMP, NEW)
               IF (ISTOP) THEN
                  DOIT = .FALSE.
                  FNAME1 = BLANK
               ELSE
C
C Select mode of operation required
C                 
                  ISEND = 2
                  CALL DETAIL (ISEND, NF, NN, NRAND, NSTART, NSTOP, N10,
     +                         CIN, ISTOP, JUMP, NOUT, TYPE12, TYPE34,
     +                         TYPE56)
                  IF (ISTOP) THEN
                     DOIT = .FALSE.
                  ELSE   
                     DOIT = .TRUE.
                  ENDIF   
               ENDIF
            ENDIF
            IF (DOIT) THEN
               IF (TYPE56) THEN
                  UPDOWN = .TRUE.
               ELSE
                  UPDOWN = .FALSE.
               ENDIF
C
C Loop over the model orders required
C
               DO ITIME = NSTART, NSTOP
                  IF (UPDOWN) THEN
                     IF (ITIME.EQ.1) THEN
                        TYPE12 = .TRUE.
                        TYPE56 = .FALSE.
                     ELSE
                        TYPE12 = .FALSE.
                        TYPE56 = .TRUE.
                     ENDIF
                  ENDIF
C
C Generate starting estimates
C
                  CALL RANDOM (IOVER, ITIME, IUNDER, NCMAX, NDOF, NF,
     +                         NN, NPAR, NPTS, NRAND, NRMAX, N10,
     +                         EPSI, W, WSSQ, X, XT, YN, YT,
     +                         CIN, ISTOP, NOUT, TYPE12, TYPE34, TYPE56)
C
C Fit the model
C
                  CALL DATFIT (IOVER, IPVT, ITIME, IUNDER, NCMAX, NDOF,
     +                         NF, NN, NPAR, NPTS, NRMAX, N10,
     +                         CV, FJAC, FVEC, W, WSSQ, X, XT, YT,
     +                         CIN, ISTOP, NOUT, TYPE12, TYPE34)
C
C Parameter standard errors
C
                  CALL VMATRX (ITIME, IOVER, IUNDER, NCMAX, NDOF, NF,
     +                         NN, NPAR,
     +                         CV, ETOL, P, SE, TSIG, X, XT, YT,
     +                         CIN, ISTOP, TYPE12, TYPE34)
C
C Output the results
C
                  CALL DATOUT (ITIME, NCMAX, NF, NGRAF, NN, NPAR, NPTS,
     +                         NRMAX, NSTART, N10,
     +                         CV, ENEG, EPOS, ERRY, P, RTOL, SE,
     +                         THEORY, TSIG, W, WSSQ, XGRAF1,
     +                         XGRAF2, XT, XVAL, YGRAF, YSAV, YT, YVAL,
     +                         CIN, ISTOP, NOUT, TYPE12, TYPE34)
C
C Special action for TYPE56 ... inform users then try relaxation fitting
C
                  IF (ITIME.GT.1 .AND. TYPE56 .AND. NOUT(9)) THEN
                     CALL PUTADV (MESSAGE)
                     WRITE (NF,'(A)') BLANK
                     WRITE (NF,'(A)') RELFIT
                     WRITE (NF,'(A)') BLANK
                     TYPE12 = .TRUE.
                     TYPE56 = .FALSE.
                     NPSAV(ITIME - 1) = NPAR(ITIME - 1)
                     NPSAV(ITIME) = NPAR(ITIME)
                     NPAR(ITIME - 1) = NPAR(ITIME)
                     NPAR(ITIME) = NPAR(ITIME) + 1
                     WSSAV(ITIME - 1) = WSSQ(ITIME - 1)
                     WSSAV(ITIME) = WSSQ(ITIME)
                     WSSQ(ITIME - 1) = WSSQ(ITIME)
                     NSSAV = NSTART
                     NSTART = ITIME - 1
C
C Adjust parameters
C
                     DO I = 2*ITIME, ITIME + 1, -1
                        X(I) = X(I - 1)
                     ENDDO
                     X(ITIME) = - X(ITIME - 1)
C
C Fit the model
C
                     CALL DATFIT (IOVER, IPVT, ITIME, IUNDER, NCMAX,
     +                            NDOF, NF, NN, NPAR, NPTS, NRMAX, N10,
     +                            CV, FJAC, FVEC, W, WSSQ, X, XT, YT,
     +                            CIN, ISTOP, NOUT, TYPE12, TYPE34)
C
C Parameter standard errors
C
                     CALL VMATRX (ITIME, IOVER, IUNDER, NCMAX, NDOF,
     +                            NF, NN, NPAR,
     +                            CV, ETOL, P, SE, TSIG, X, XT, YT,
     +                            CIN, ISTOP, TYPE12, TYPE34)
C
C Output the results
C
                     CALL DATOUT (ITIME, NCMAX, NF, NGRAF, NN, NPAR,
     +                            NPTS, NRMAX, NSTART, N10,
     +                            CV, ENEG, EPOS, ERRY, P, RTOL, SE,
     +                            THEORY, TSIG, W, WSSQ, XGRAF1,
     +                            XGRAF2, XT, XVAL, YGRAF, YSAV, YT,
     +                            YVAL,
     +                            CIN, ISTOP, NOUT, TYPE12, TYPE34)


                     TYPE12 = .FALSE.
                     TYPE56 = .TRUE.
                     NPAR(ITIME - 1) = NPSAV(ITIME - 1)
                     NPAR(ITIME) = NPSAV(ITIME)
                     WSSQ(ITIME - 1) = WSSAV(ITIME - 1)
                     WSSQ(ITIME) = WSSAV(ITIME)
                     NSTART = NSSAV
                  ENDIF
               ENDDO
            ENDIF
C
C Another go ?
C
            CALL GOGOGO (NF,
     +                   FNAME1, FNAME2, PNAME,
     +                   ISTOP, NEW)
            IF (ISTOP) THEN
               REPEET = .FALSE.
            ELSE
               REPEET = .TRUE.
            ENDIF
         ENDDO
      ENDIF

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND, 
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NF)
      END
C
C
