C
C EXFIT1.FOR: ADVISE, DATAIN, DATFIT, DATOUT
C ===========
C
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT, N0
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 4, N0 = 0)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, EXPDEM, HELP_EXFIT
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help            ',
     +'Display examples',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_EXFIT ('exfit')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            CALL EXPDEM (N0)
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.4) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `EXFIT'
     +/'        `     ' 
     +/'Action  `Unconstrained weighted least squares regression'
     +/'        `using one exponential function or a sequence of'
     +/'        `sums of increasing numbers of exponentials'
     +/'        `     ' 
     +/'Version `',A
     +/'        `     ' 
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `     ' 
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE DATAIN (NF, NIN, NPTS, NRMAX,
     +                   ERRY, RTOL, XT, XVAL, YN, YT, YVAL, Y0,
     +                   FNAME1, FNAME2,
     +                   EQUAL, ISTOP, JUMP, NEW)
C
C Read X, Y, S, NPTS, calculate XT, YN, YT, Transform to internal coordinates
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NF, NIN, NRMAX
      INTEGER,             INTENT (INOUT) :: NPTS  
      DOUBLE PRECISION,    INTENT (IN)    :: RTOL
      DOUBLE PRECISION,    INTENT (OUT)   :: ERRY(NRMAX), XT,
     +                                       XVAL(NRMAX), YN, YT,
     +                                       YVAL(NRMAX), Y0
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME1, FNAME2
      LOGICAL,             INTENT (IN)    :: JUMP, NEW
      LOGICAL,             INTENT (OUT)   :: EQUAL(NRMAX), ISTOP
C
C Locals
C
      INTEGER    ICOUNT
      INTEGER    I
      DOUBLE PRECISION ZERO, TWO
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION ABSVAL, XTEST
      CHARACTER (LEN = 100) LINE
      CHARACTER (LEN = 80 ) TFILE, TITLE, TRIM80
      LOGICAL    OK
      EXTERNAL   DATFIL, DATCHK, PUTFAT, RESFIL, DATSXY,
     +           PUTADV, TRIM80
      INTRINSIC  ABS
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      ISTOP = .FALSE.
C
C Read in and check data
C
      IF (NEW) THEN
         CALL PUTADV (
     +  'Now input a file with exponential data (like exfit.tf?)')
         CLOSE (UNIT = NIN)
         CALL DATFIL (NIN, NRMAX, NPTS,
     +                ERRY, XVAL, YVAL,
     +                FNAME1, TITLE,
     +                ISTOP)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ELSE
         CLOSE (UNIT = NIN)
         CALL DATSXY (NIN, NRMAX, NPTS,
     +                ERRY, XVAL, YVAL,
     +                FNAME1, TITLE,
     +                ISTOP)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ENDIF
      CALL DATCHK (NPTS,
     +             ERRY, XVAL, YVAL,
     +             ISTOP)
      IF (ISTOP) RETURN
C
C Further checks on input data
C
      IF (NPTS.LT.3) THEN
         CALL PUTFAT ('Must be at least 3 t-values')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      OK = .TRUE.
      DO I = 1, NPTS
         IF (XVAL(I).LT.ZERO .OR. YVAL(I).LT.ZERO) THEN
            IF (OK) THEN
               WRITE (LINE,100) I
               CALL PUTFAT (LINE)
               OK = .FALSE.
            ENDIF
         ENDIF
      ENDDO
      IF (.NOT.OK) THEN
         WRITE (LINE,200)
         CALL PUTADV (LINE)
      ENDIF
C
C Open output file for results and write out program declaration
C
      IF (ICOUNT.EQ.0) THEN
         CALL RESFIL (NF,
     +                FNAME2,
     +                ISTOP)
         IF (ISTOP) RETURN
         IF (JUMP) THEN  
            WRITE (NF,350)
         ELSE   
            WRITE (NF,300)
         ENDIF   
      ENDIF
      ICOUNT = ICOUNT + 1
C
C Transform data (Allowing for y, t < O in future revision)
C
      XT = ABS(XVAL(1))
      YT = ABS(YVAL(1))
      EQUAL(1) = .FALSE.
      DO I = 2, NPTS
         ABSVAL = ABS(XVAL(I))
         IF (ABSVAL.GT.XT) XT = ABSVAL
         ABSVAL = ABS(YVAL(I))
         IF (ABSVAL.GT.YT) YT = ABSVAL
         XTEST = XVAL(I - 1)
         IF (XVAL(I).GT.XTEST) THEN
            EQUAL(I) = .FALSE.
         ELSEIF (XVAL(I).LT.XTEST) THEN
            EQUAL(I) = .FALSE.
         ELSE
            EQUAL(I) = .TRUE.
         ENDIF
      ENDDO
      IF (XT.LE.RTOL .OR. YT.LE.RTOL) THEN
         CALL PUTFAT ('All y, or all t are equal in value')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      XT = XT/TWO
      Y0 = YVAL(1)/YT
      YN = YVAL(NPTS)/YT
      DO I = 1, NPTS
         ERRY(I) = ERRY(I)/YT
         XVAL(I) = XVAL(I)/XT
         YVAL(I) = YVAL(I)/YT
      ENDDO
C
C Identify the data set
C
      TFILE = TRIM80(FNAME1)
      WRITE (NF,400) ICOUNT, TFILE, TITLE
C
C Format statements
C      
  100 FORMAT (
     +'t or y < 0 at data point',I6,
     +'  ...  EXFIT is designed to work with positive data values')
  200 FORMAT (
     +'Expect a bad fit',
     +'  ...  Edit to change the baseline and run with t and y >= 0')
  300 FORMAT (/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : EXFIT'
     +/1X,'MODEL   : Fit a sum of 1 to n exponentials'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  350 FORMAT (/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : SV_EXFIT'
     +/1X,'MODEL   : Fit a sum of 1 to n exponentials'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.') 
  400 FORMAT (/1X,'Analysis number',I4/1X,'==================='
     +/1X,'File name'/1X,A/1X,'Data title'/1X,A)
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE DATFIT (IOVER, IPVT, ITIME, IUNDER, NCMAX, NDOF,
     +                   NF, NN, NPAR, NPTS, NRMAX, N10,
     +                   CV, FJAC, FVEC, W, WSSQ, X, XT, YT,
     +                   CIN, ISTOP, NOUT, TYPE12, TYPE34)
C
C Curve fitting by LMFIT1 and calculate internal parameter covariance matrix
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NCMAX, NN, NRMAX, N10
      INTEGER,          INTENT (IN)    :: ITIME, NDOF, NF, NPAR(NN), 
     +                                    NPTS
      INTEGER,          INTENT (OUT)   :: IOVER, IPVT(NCMAX), IUNDER
      DOUBLE PRECISION, INTENT (IN)    :: XT, YT
      DOUBLE PRECISION, INTENT (INOUT) :: WSSQ(NN), X(NCMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: CV(NCMAX,NCMAX),
     +                                    FJAC(NRMAX,NCMAX),
     +                                    FVEC(NRMAX), W(10*NRMAX) 
      LOGICAL,          INTENT (IN)    :: CIN, ISTOP, NOUT(N10),
     +                                    TYPE12,
     +                                    TYPE34
C
C Locals
C      
      INTEGER    I, IFAIL, IRANK, LW, M, N
      INTEGER    COLOUR
      DOUBLE PRECISION FSUMSQ, TEMP
      CHARACTER (LEN = 9) WORD9, FORM09
      CHARACTER  LINE*100
      LOGICAL    IWARNU
      PARAMETER (IWARNU = .TRUE.)
      EXTERNAL   LMFIT1, LMFUNC
      EXTERNAL   CHECKW, TABLE1, FORM09
      IF (ISTOP) RETURN
C
C Set up parameters for curve-fitting
C
      M = NPTS
      N = NPAR(ITIME)
      IF (NOUT(2)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         WRITE (LINE,100)
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         COLOUR = 0
      ENDIF
      WRITE (NF,100)
      IF (TYPE12 .OR. TYPE34) THEN
         DO I = 1, 2*ITIME
            IF (I.LE.ITIME) THEN
               IF (TYPE12) THEN
                  TEMP = X(I)*YT
                  WORD9 = FORM09(TEMP)
C                  IF (NOUT(2)) WRITE (LINE,200) I, X(I)*YT
C                  WRITE (NF,200) I, X(I)*YT
                  IF (NOUT(2)) WRITE (LINE,200) I, WORD9
                  WRITE (NF,200) I, WORD9
               ELSE
                  TEMP = X(I)*YT
                  WORD9 = FORM09(TEMP)                 
C                  IF (NOUT(2)) WRITE (LINE,300) I, X(I)*YT
C                  WRITE (NF,300) I, X(I)*YT
                  IF (NOUT(2)) WRITE (LINE,300) I, WORD9
                  WRITE (NF,300) I, WORD9                  
               ENDIF
            ELSE
               TEMP = X(I)/XT
               WORD9 = FORM09(TEMP)
C               IF (NOUT(2)) WRITE (LINE,400) I - ITIME, X(I)/XT
C               WRITE (NF,400) I - ITIME, X(I)/XT
               IF (NOUT(2)) WRITE (LINE,400) I - ITIME, WORD9
               WRITE (NF,400) I - ITIME, WORD9               
            ENDIF
            IF (NOUT(2)) CALL TABLE1 (COLOUR, LINE)
         ENDDO
      ELSE
         DO I = 1, 2*ITIME
            IF (I.LE.ITIME - 1) THEN
               TEMP = X(I)*YT
               WORD9 = FORM09(TEMP)
C               IF (NOUT(2)) WRITE (LINE,200) I, X(I)*YT
C               WRITE (NF,200) I, X(I)*YT
               IF (NOUT(2)) WRITE (LINE,200) I, WORD9
               WRITE (NF,200) I, WORD9               
            ELSEIF (I.EQ.ITIME) THEN
               TEMP = - X(I - 1)/XT
               WORD9 = FORM09(TEMP)
C               IF (NOUT(2)) WRITE (LINE,200) I, -X(I - 1)*YT
C               WRITE (NF,200) I, -X(I - 1)*YT
               IF (NOUT(2)) WRITE (LINE,200) I, WORD9
               WRITE (NF,200) I, WORD9
            ELSE
               TEMP = X(I - 1)/XT
               WORD9 = FORM09(TEMP) 
C               IF (NOUT(2)) WRITE (LINE,400) I - ITIME, X(I - 1)/XT
C               WRITE (NF,400) I - ITIME, X(I - 1)/XT
               IF (NOUT(2)) WRITE (LINE,400) I - ITIME, WORD9
               WRITE (NF,400) I - ITIME, WORD9
            ENDIF
            IF (NOUT(2)) CALL TABLE1 (COLOUR, LINE)
         ENDDO
      ENDIF
      IF (CIN) THEN
         TEMP = X(N)*YT
         WORD9 = FORM09(TEMP)
         IF (NOUT(2)) THEN
C            WRITE (LINE,500) X(N)*YT
            WRITE (LINE,500) WORD9            
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
C         WRITE (NF,500) X(N)*YT
         WRITE (NF,500) WORD9         
      ENDIF
      IF (NOUT(2)) CALL TABLE1 (COLOUR, 'CLOSE')
      CALL CHECKW (NDOF,
     +             WSSQ(ITIME))
      IOVER = 0
      IUNDER = 0
C
C Enter curve fitting routine
C
      LW = 5*N + M
      CALL LMFIT1 (LMFUNC, IFAIL, IPVT, IRANK, LW, M, N, NCMAX, NF,
     +             NRMAX,
     +             CV, FJAC, FVEC, X, W, FSUMSQ,
     +             IWARNU)
C
C Define WSSQ and proceed to check IFAIL
C
      WSSQ(ITIME) = FSUMSQ
C
C Format statements
C      
  100 FORMAT ('Parameter starting estimates')
C  200 FORMAT ('A(',I1,') =',1P,E11.3)
C  300 FORMAT ('B(',I1,') =',1P,E11.3)
C  400 FORMAT ('k(',I1,') =',1P,E11.3)
C  500 FORMAT ('   C =',1P,E11.3)
  200 FORMAT ('A(',I1,') =',1X,A)
  300 FORMAT ('B(',I1,') =',1X,A)
  400 FORMAT ('k(',I1,') =',1X,A)
  500 FORMAT ('   C =',1X,A)
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE DATOUT (ITIME, NCMAX, NF, NGRAF, NN, NPAR, NPTS,
     +                   NRMAX, NSTART, N10,
     +                   CV, ENEG, EPOS, ERRY, P, RTOL, SE, THEORY,
     +                   TSIG, W, WSSQ, XGRAF1, XGRAF2, XT, XVAL,
     +                   YGRAF, YSAV, YT, YVAL,
     +                   CIN, ISTOP, NOUT, TYPE12, TYPE34)
C
C Output printed and written to a file
C NOTE: this version defines ISEND and INDEXX and calls ARRPAR to rearrange
C parameters into increasing order of amplitude factors
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NCMAX, NGRAF, NN, NRMAX, N10
      INTEGER,          INTENT (IN)    :: ITIME, NF, NPAR(NN), NSTART
      INTEGER,          INTENT (INOUT) :: NPTS
      DOUBLE PRECISION, INTENT (IN)    :: ENEG, EPOS, RTOL,
     +                                    THEORY(NRMAX), XT, YT
      DOUBLE PRECISION, INTENT (IN)    :: ERRY(NRMAX), WSSQ(NN),
     +                                    XVAL(NRMAX), YVAL(NRMAX)
      DOUBLE PRECISION, INTENT (INOUT) :: P(NCMAX)
      DOUBLE PRECISION, INTENT (INOUT) :: SE(NCMAX), TSIG(NCMAX), 
     +                                    YSAV(NGRAF)     
      DOUBLE PRECISION, INTENT (INOUT) :: CV(NCMAX,NCMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: W(10*NRMAX), XGRAF1(NGRAF),
     +                                    XGRAF2(NGRAF), YGRAF(NGRAF)
      LOGICAL,          INTENT (IN)    :: CIN, ISTOP, NOUT(N10), TYPE12,
     +                                    TYPE34
C
C Locals
C      
      INTEGER    L0, L1, L2, L3, L8
      PARAMETER (L0 = 0, L1 = 1, L2 = 2, L3 = 3, L8 = 8)
      INTEGER    I, IADD1, IFAIL, J, K, M, N
      INTEGER    NP1, NP2, NP3, NP4, NP5
      INTEGER    NTEXT, NTITLE
      PARAMETER (NTEXT = 30, NTITLE = 2)
      INTEGER    ISEND, INDEXX(50), JTOTAL(50), NTOTAL
      PARAMETER (ISEND = 3)
      DOUBLE PRECISION ZERO, ONE, TWO, PNT05, PNT975
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           PNT05 = 0.05D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION TEMP
      DOUBLE PRECISION A, ARG, AUC, B, FA, FB, T, XSTART, XSTOP
      DOUBLE PRECISION ALPHA, FI, FJ, PSIG, STDERR, TVAL, VAREST
      DOUBLE PRECISION FMOD
      DOUBLE PRECISION G01EBF$, G01FBF$
      DOUBLE PRECISION ASYMP, XTEMP1(L2), XTEMP2(L2), YTEMP1(L2),
     +                 YTEMP2(L2)
      CHARACTER (LEN = 13) D13(5), SHOWLJ, SHOWRJ
      CHARACTER  SYMBOL(NTEXT)*2
      CHARACTER  PTITLE*37, XTITLE*1, YTITLE*1
      CHARACTER  LINE1*100, LINE2(2)*100, TEXT(NTEXT)*100,
     +           TITLE1(NTITLE)*80,TITLE2(NTITLE)*80
      CHARACTER  LINENN(NTEXT)*100, TTOTAL(50)*100
      LOGICAL    OK
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      EXTERNAL   E_FORMATS
      EXTERNAL   SHOWLJ, SHOWRJ
      EXTERNAL   FMOD
      EXTERNAL   G01FBF$, G01EBF$
      EXTERNAL   PUTIFA, GKSR01, FTESTS, DIVIDE, GKST04, TABLE6, MIDDLE,
     +           GDCON0, ARRPAR, PCVTST
      INTRINSIC  ABS, DBLE, EXP, SQRT
      IF (ISTOP) RETURN
      E_NUMBERS = E_FORMATS()  
C
C Assign M and N
C
      M = NPTS
      N = NPAR(ITIME)
C
C Rearrange the results from VMATRX
C
      IF (ITIME.GT.1 .AND. (TYPE12 .OR. TYPE34)) THEN
         CALL ARRPAR (ISEND, INDEXX, ITIME, NCMAX,
     +                N, CV, P, W)
         DO I = 1, N
            W(I) = SE(INDEXX(I))
         ENDDO
         DO I = 1, N
            SE(I) = W(I)
         ENDDO
         DO I = 1, N
            W(I) = TSIG(INDEXX(I))
         ENDDO
         DO I = 1, N
            TSIG(I) = W(I)
         ENDDO
      ENDIF
C
C Calculate SYMBOL
C
      DO I = 1, N
         IF (TSIG(I).GT.PNT05) THEN
            SYMBOL(I) = ' *'
         ELSE
            SYMBOL(I) = '  '
         ENDIF
      ENDDO
C
C The t statistic then output parameters
C
      DO I = 1, 50
         JTOTAL(I) = 0
      ENDDO   
      IFAIL = 1
      T = G01FBF$('Lower-tail', PNT975, DBLE(M - N), IFAIL)
      CALL PUTIFA (IFAIL, NF, 'G01FBF/DATOUT')
      WRITE (LINE2,50) ITIME
      WRITE (NF,50) ITIME
      TITLE1(1) = LINE2(1)(1:80)
      TITLE1(2) = LINE2(2)(1:80)
      
      IF (E_NUMBERS) THEN
         WRITE (LINE2,100)
         TITLE2(1) = LINE2(1)(1:80)
         TITLE2(2) = LINE2(2)(1:80)
         WRITE (NF,100)
      ELSE 
         WRITE (LINE2,105)
         TITLE2(1) = LINE2(1)(1:80)
         TITLE2(2) = LINE2(2)(1:80)
         WRITE (NF,105)  
      ENDIF
      
      IF (TYPE12) THEN
        
         IF (E_NUMBERS) THEN
            WRITE (LINENN,200) (I, P(I), SE(I), P(I) - SE(I)*T,
     +                          P(I) + SE(I)*T,
     +                          TSIG(I), SYMBOL(I), I = 1, ITIME)
            DO I = 1, ITIME
              TEXT(I) = LINENN(I)
            ENDDO
            WRITE (NF,200) (I, P(I), SE(I), P(I) - SE(I)*T,
     +                      P(I) + SE(I)*T,
     +                      TSIG(I), SYMBOL(I), I = 1, ITIME)
         ELSE
            DO I = 1, ITIME
               D13(1) = SHOWRJ(P(I)) 
               D13(2) = SHOWRJ(SE(I)) 
               TEMP = P(I) - SE(I)*T
               D13(3) = SHOWRJ(TEMP) 
               TEMP = P(I) + SE(I)*T
               D13(4) = SHOWRJ(TEMP) 
               WRITE (LINENN(I),205) I, D13(1), D13(2), D13(3), D13(4),
     +                               TSIG(I), SYMBOL(I)
               TEXT(I) = LINENN(I)
               WRITE (NF,'(A)') LINENN(I)
            ENDDO   
         ENDIF
         
      ELSEIF (TYPE34) THEN
         IF (E_NUMBERS) THEN
            WRITE (LINENN,300) (I, P(I), SE(I), P(I) - SE(I)*T, 
     +                          P(I) + SE(I)*T,
     +                          TSIG(I), SYMBOL(I), I = 1, ITIME)
            DO I = 1, ITIME
               TEXT(I) = LINENN(I)
            ENDDO
         WRITE (NF,300) (I, P(I), SE(I), P(I) - SE(I)*T, P(I) + SE(I)*T,
     +                   TSIG(I), SYMBOL(I), I = 1, ITIME)
         ELSE
            DO I = 1, ITIME
               D13(1) = SHOWRJ(P(I))
               D13(2) = SHOWRJ(SE(I))
               TEMP = P(I) - SE(I)*T
               D13(3) = SHOWRJ(TEMP)
               TEMP = P(I) + SE(I)*T
               D13(4) = SHOWRJ(TEMP) 
               WRITE (LINENN(I),305) I, D13(1), D13(2), D13(3), D13(4),
     +                               TSIG(I), SYMBOL(I) 
               WRITE (NF,'(A)') LINENN(I)
               TEXT(I) = LINENN(I)
            ENDDO   
         ENDIF  
     
      ELSE

         IF (E_NUMBERS) THEN
            WRITE (LINENN,200) (I, P(I), SE(I), P(I) - SE(I)*T, 
     +                          P(I) + SE(I)*T,
     +                          TSIG(I), SYMBOL(I), I = 1, ITIME - 1)
            DO I = 1, ITIME - 1
               TEXT(I) = LINENN(I)
            ENDDO
            WRITE (TEXT(ITIME),400) ITIME, -P(ITIME - 1)
            WRITE (NF,200) (I, P(I), SE(I), P(I) - SE(I)*T,
     +                      P(I) + SE(I)*T,
     +                      TSIG(I), SYMBOL(I), I = 1, ITIME - 1)
            WRITE (NF,400) ITIME, -P(ITIME - 1)
         ELSE
            DO I = 1, ITIME - 1 
               D13(1) = SHOWRJ(P(I))
               D13(2) = SHOWRJ(SE(I))
               TEMP = P(I) - SE(I)*T
               D13(3) = SHOWRJ(TEMP)
               TEMP = P(I) + SE(I)*T
               D13(4) = SHOWRJ(TEMP)   
               WRITE (LINENN(I),205) I, D13(1), D13(2), D13(3), D13(4),
     +                               TSIG(I), SYMBOL(I)
               TEXT(I) = LINENN(I)
               WRITE (NF,'(A)') LINENN(I)
            ENDDO
            D13(1) = SHOWRJ( - P(ITIME - 1))  
            WRITE (TEXT(ITIME),405) ITIME, D13(1)        
            WRITE (NF,'(A)') TEXT(ITIME)    
         ENDIF  
         
      ENDIF
      
      IF (TYPE12 .OR. TYPE34) THEN
         IF (E_NUMBERS) THEN
            WRITE (LINENN,500) (I - ITIME, P(I), SE(I), P(I) - SE(I)*T,
     +                          P(I) + SE(I)*T, TSIG(I), SYMBOL(I),
     +                          I = ITIME + 1, 2*ITIME)
            WRITE (NF,500) (I - ITIME, P(I), SE(I), P(I) - SE(I)*T,
     +                      P(I) + SE(I)*T, TSIG(I), SYMBOL(I),
     +                      I = ITIME + 1, 2*ITIME)
         ELSE
            DO I = ITIME + 1, 2*ITIME
               D13(1) = SHOWRJ(P(I))
               D13(2) = SHOWRJ(SE(I))
               TEMP = P(I) - SE(I)*T
               D13(3) = SHOWRJ(TEMP)
               TEMP = P(I) + SE(I)*T
               D13(4) = SHOWRJ(TEMP)
               WRITE (LINENN(I - ITIME),505) I - ITIME, D13(1), D13(2),
     +                                       D13(3), D13(4),  TSIG(I),
     +                                       SYMBOL(I)
               WRITE (NF,'(A)') LINENN(I - ITIME)
            ENDDO  
         ENDIF
     
      ELSE
         IF (E_NUMBERS) THEN
            WRITE (LINENN,500) (I - ITIME + 1, P(I), SE(I), 
     +                          P(I) - SE(I)*T,
     +                          P(I) + SE(I)*T, TSIG(I), SYMBOL(I),
     +                          I = ITIME, 2*ITIME - 1)
            WRITE (NF,500) (I - ITIME + 1, P(I), SE(I), P(I) - SE(I)*T,
     +                      P(I) + SE(I)*T, TSIG(I), SYMBOL(I),
     +                      I = ITIME, 2*ITIME - 1)
         ELSE
            J = 0
            DO I = ITIME, 2*ITIME - 1 
               J = J + 1
               D13(1) = SHOWRJ(P(I))
               D13(2) = SHOWRJ(SE(I))
               TEMP = P(I) - SE(I)*T
               D13(3) = SHOWRJ(TEMP)
               TEMP = P(I) + SE(I)*T
               D13(4) = SHOWRJ(TEMP)
               WRITE (LINENN(J),505) I - ITIME + 1,  D13(1), D13(2),
     +                               D13(3), D13(4), TSIG(I), SYMBOL(I)
               WRITE (NF,'(A)') LINENN(J)
            ENDDO   
         ENDIF  
      ENDIF
      DO I = ITIME + 1, 2*ITIME
         TEXT(I) = LINENN(I - ITIME)
      ENDDO
      IADD1 = 2*ITIME
C
C Extra parameter if constant required
C
      IF (CIN) THEN
         IADD1 = IADD1 + 1
         IF (E_NUMBERS) THEN
            WRITE (TEXT(IADD1),600) P(N), SE(N), P(N) - SE(N)*T,
     +                              P(N) + SE(N)*T,
     +                              TSIG(N), SYMBOL(N)
            WRITE (NF,600) P(N), SE(N), P(N) - SE(N)*T,
     +                     P(N) + SE(N)*T,
     +                     TSIG(N), SYMBOL(N)
         ELSE
            D13(1) = SHOWRJ(P(N))
            D13(2) = SHOWRJ(SE(N))
            TEMP = P(N) - SE(N)*T
            D13(3) = SHOWRJ(TEMP) 
            TEMP = P(N) + SE(N)*T
            D13(4) = SHOWRJ(TEMP)
            WRITE (TEXT(IADD1),605) D13(1), D13(2), D13(3), D13(4),
     +                              TSIG(N), SYMBOL(N)
            WRITE (NF,'(A)') TEXT(IADD1)
         ENDIF
      ENDIF
C
C Calculate AUC from 0 to infinity if it exists
C
      IF (.NOT.TYPE34 .AND. .NOT.CIN) THEN
         OK = .TRUE.
         AUC = ZERO
         VAREST = ZERO
         IF (ITIME.EQ.1) THEN
            IF (P(2).GT.RTOL) THEN
               AUC = P(1)/P(2)
            ELSE
               OK = .FALSE.
            ENDIF
            IF (OK) THEN
               FI = ONE/P(2)
               FJ = - P(1)/(P(2)**2)
               VAREST = (FI**2)*CV(1,1) + (FJ**2)*CV(2,2) +
     +                  TWO*FI*FJ*CV(2,1)
            ENDIF
         ELSEIF (TYPE12) THEN
            DO K = 1, ITIME
               A = P(K)
               B = P(ITIME + K)
               IF (B.GT.RTOL) THEN
                  AUC = AUC + A/B
               ELSE
                  OK = .FALSE.
               ENDIF
            ENDDO
            IF (OK) THEN
               DO I = 1, ITIME
                  J = ITIME + I
                  FI = ONE/P(J)
                  FJ = - P(I)/(P(J)**2)
                  VAREST = VAREST + (FI**2)*CV(I,I) + (FJ**2)*CV(J,J)
               ENDDO
               DO I = 2, 2*ITIME
                  DO J = 1, I - 1
                     IF (I.LE.ITIME) THEN
                        FI = ONE/P(ITIME + I)
                     ELSE
                        FI = - P(I - ITIME)/(P(I)**2)
                     ENDIF
                     IF (J.LE.ITIME) THEN
                        FJ = ONE/P(ITIME + J)
                     ELSE
                        FJ = - P(J - ITIME)/(P(J)**2)
                     ENDIF
                     VAREST = VAREST + TWO*FI*FJ*CV(I,J)
                  ENDDO
               ENDDO
            ENDIF
         ELSE
            DO K = 1, ITIME - 1
               A = P(K)
               B = P(ITIME + K - 1)
               IF (B.GT.RTOL) THEN
                  AUC = AUC + A/B
               ELSE
                  OK = .FALSE.
               ENDIF
            ENDDO
            A = P(ITIME - 1)
            B = P(2*ITIME  - 1)
            IF (B.GT.RTOL) THEN
               AUC = AUC - A/B
            ELSE
               OK = .FALSE.
            ENDIF
            IF (OK) THEN
               DO I = 1, ITIME - 1
                  J = ITIME + I  - 1
                  FI = ONE/P(J)
                  FJ = - P(I)/(P(J)**2)
                  VAREST = VAREST + (FI**2)*CV(I,I) + (FJ**2)*CV(J,J)
               ENDDO
               I = ITIME - 1
               J = 2*ITIME - 1
               FI = - ONE/P(J)
               FJ =  P(I)/(P(J)**2)
               VAREST = VAREST + (FI**2)*CV(I,I) + (FJ**2)*CV(J,J)
               DO I = 2, 2*ITIME - 1
                  DO J = 1, I - 1
                     IF (I.LT.ITIME - 1) THEN
                        FI = ONE/P(ITIME + I - 1)
                     ELSEIF (I.EQ.ITIME - 1) THEN
                        FI = ONE/P(2*ITIME - 2) - ONE/P(2*ITIME - 1)
                     ELSEIF (I.LT.2*ITIME - 1) THEN
                        FI = - P(I - ITIME  + 1)/(P(I)**2)
                     ELSE
                        FI = P(ITIME - 1)/(P(I)**2)
                     ENDIF
                     IF (J.LT.ITIME - 1) THEN
                        FJ = ONE/P(ITIME + J - 1)
                     ELSEIF (J.EQ.ITIME - 1) THEN
                        FJ = ONE/P(2*ITIME - 2) - ONE/P(2*ITIME - 1)
                     ELSEIF (J.LT.2*ITIME - 1) THEN
                        FJ = - P(J - ITIME  + 1)/(P(J)**2)
                     ELSE
                        FJ = P(ITIME - 1)/(P(J)**2)
                     ENDIF
                     VAREST = VAREST + TWO*FI*FJ*CV(I,J)
                  ENDDO
               ENDDO
            ENDIF
         ENDIF
C
C Output AUC if successful
C
         IF (OK .AND. VAREST.GT.ZERO) THEN
            IADD1 = IADD1 + 1
            STDERR = SQRT(VAREST)
            TVAL = ABS(AUC)/STDERR
            IFAIL = 1
            ALPHA = ONE - G01EBF$('Lower Tail', TVAL, DBLE(M - N),
     +              IFAIL)
            CALL PUTIFA (IFAIL, NF, 'G01EBF/DATOUT')
            PSIG = TWO*ALPHA
            IF (PSIG.GT.PNT05) THEN
               SYMBOL(NTEXT) = ' *'
            ELSE
               SYMBOL(NTEXT) = '  '
            ENDIF
            
            IF (T*STDERR.GT.ABS(AUC)) THEN
               IF (E_NUMBERS) THEN
                  WRITE (TEXT(IADD1),625) AUC
                  WRITE (NF,625) AUC
               ELSE
                  D13(1) = SHOWRJ(AUC)
                  WRITE (TEXT(IADD1),630) D13(1)
                  WRITE (NF,630) D13(1) 
               ENDIF  
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (TEXT(IADD1),650) AUC, STDERR, AUC - T*STDERR,
     +                                    AUC + T*STDERR, PSIG,
     +                                    SYMBOL(NTEXT)
                  WRITE (NF,650) AUC, STDERR, AUC - T*STDERR,
     +                           AUC + T*STDERR, PSIG,
     +                           SYMBOL(NTEXT)
               ELSE
                  D13(1) = SHOWRJ(AUC)
                  D13(2) = SHOWRJ(STDERR)
                  TEMP = AUC - T*STDERR
                  D13(3) = SHOWRJ(TEMP)
                  TEMP = AUC + T*STDERR
                  D13(4) = SHOWRJ(TEMP)
                  WRITE (TEXT(IADD1),655) D13(1), D13(2), D13(3),
     +                                    D13(4), PSIG, SYMBOL(NTEXT)
                  WRITE (NF,655) D13(1), D13(2), D13(3),
     +                           D13(4), PSIG, SYMBOL(NTEXT)

               ENDIF  
            ENDIF
            
            IADD1 = IADD1 + 1
            TEXT(IADD1) =
     +     ' AUC is the area under the curve from t = 0 to t = infinity'
            WRITE (NF,'(A)')
     +     ' AUC is the area under the curve from t = 0 to t = infinity'
         ENDIF
      ENDIF
C
C Calculate AUC from A to B
C
      OK = .TRUE.
      A = XVAL(1)*XT
      B = XVAL(NPTS)*XT
      FA = ZERO
      FB = ZERO
      IF (TYPE12 .OR. (.NOT.TYPE34.AND.ITIME.EQ.1)) THEN
         DO J = 1, ITIME
            K = ITIME + J
            IF (ABS(P(K)).GT.RTOL) THEN
               ARG = - P(K)*A
               CALL MIDDLE (ENEG, ARG, EPOS)
               FA = FA - P(J)*EXP(ARG)/P(K)
               ARG = - P(K)*B
               CALL MIDDLE (ENEG, ARG, EPOS)
               FB = FB - P(J)*EXP(ARG)/P(K)
            ELSE
               OK = .FALSE.
            ENDIF
         ENDDO
      ELSEIF (TYPE34) THEN
         DO J = 1, ITIME
            K = ITIME + J
            IF (ABS(P(K)).GT.RTOL) THEN
               ARG = - P(K)*A
               CALL MIDDLE (ENEG, ARG, EPOS)
               FA = FA + P(J)*A + P(J)*EXP(ARG)/P(K)
               ARG = - P(K)*B
               CALL MIDDLE (ENEG, ARG, EPOS)
               FB = FB + P(J)*B + P(J)*EXP(ARG)/P(K)
            ELSE
               OK = .FALSE.
            ENDIF
         ENDDO
      ELSE
         DO J = 1, ITIME - 1
            K = ITIME + J - 1
            IF (ABS(P(K)).GT.RTOL) THEN
               ARG = - P(K)*A
               CALL MIDDLE (ENEG, ARG, EPOS)
               FA = FA - P(J)*EXP(ARG)/P(K)
               ARG = - P(K)*B
               CALL MIDDLE (ENEG, ARG, EPOS)
               FB = FB - P(J)*EXP(ARG)/P(K)
            ELSE
               OK = .FALSE.
            ENDIF
         ENDDO
         J = ITIME - 1
         K = 2*ITIME - 1
         IF (ABS(P(K)).GT.RTOL) THEN
            ARG = - P(K)*A
            CALL MIDDLE (ENEG, ARG, EPOS)
            FA = FA + P(J)*EXP(ARG)/P(K)
            ARG = - P(K)*B
            CALL MIDDLE (ENEG, ARG, EPOS)
            FB = FB + P(J)*EXP(ARG)/P(K)
         ELSE
            OK = .FALSE.
         ENDIF
      ENDIF
C
C Output area, etc. if successful
C
      IF (OK .AND. ABS(B - A).GT.RTOL) THEN
         AUC = FB - FA
         IF (CIN) AUC = AUC + (B - A)*P(N)
         IF (E_NUMBERS) THEN  
            WRITE (LINENN,675) A, B, AUC, AUC/(B - A)
            WRITE (NF,675) A, B, AUC, AUC/(B - A)
         ELSE
            D13(1) = SHOWLJ(A)
            D13(2) = SHOWLJ(B)
            D13(3) = SHOWLJ(AUC)
            TEMP = AUC/(B - A)
            D13(4) = SHOWLJ(TEMP)
            WRITE (LINENN(1),681) D13(1)
            WRITE (LINENN(2),682) D13(2)
            WRITE (LINENN(3),683) D13(3)
            WRITE (LINENN(4),684) D13(4)
            WRITE (NF,681) D13(1)
            WRITE (NF,682) D13(2)
            WRITE (NF,683) D13(3)
            WRITE (NF,684) D13(4)
         ENDIF  
         DO I = 1, 4
            IADD1 = IADD1 + 1
            TEXT(IADD1) = LINENN(I)
         ENDDO
      ENDIF
      NTOTAL = 0
      DO I = 1, NTITLE
         NTOTAL = NTOTAL + 1
         TTOTAL(NTOTAL) = TITLE1(I)
      ENDDO  
      DO I = 1, NTITLE
         NTOTAL = NTOTAL + 1
         TTOTAL(NTOTAL) = TITLE2(I)
      ENDDO    
      DO I = 1, IADD1
         NTOTAL = NTOTAL + 1
         TTOTAL(NTOTAL) = TEXT(I)
      ENDDO    
C
C Output correlation matrix
C
      WRITE (LINE2,700)
      WRITE (NF,700)
      K = 0
      DO I = 1, N
         IF (ITIME.LE.5) THEN
            WRITE (LINE1,800) (CV(I,J)/(SE(I)*SE(J)), J = 1, I)
            WRITE (NF,800) (CV(I,J)/(SE(I)*SE(J)), J = 1, I)
         ELSE
            WRITE (LINE1,900) (CV(I,J)/(SE(I)*SE(J)), J = 1, I)
            WRITE (NF,900) (CV(I,J)/(SE(I)*SE(J)), J = 1, I)
         ENDIF
         K = K + 1
         TEXT(K) = LINE1
      ENDDO
      DO I = 1, 2
         NTOTAL = NTOTAL + 1
         TTOTAL(NTOTAL) = LINE2(I)
      ENDDO
      JTOTAL(4) = 4
      JTOTAL(NTOTAL) = 4   
      DO I = 1, K 
         NTOTAL = NTOTAL + 1
         TTOTAL(NTOTAL) = TEXT(I)
      ENDDO   
      CALL TABLE6 (JTOTAL, NTOTAL,
     +             TTOTAL)       

C
C
C W(        1 -->  NPTS) = OLDE
C W( NPTS + 1 --> 2NPTS) = OLDX
C W(2NPTS + 1 --> 3NPTS) = OLDY
C W(3NPTS + 1 --> 4NPTS) = THEORY
C W(4NPTS + 1 --> 5NPTS) = RESID
C W(5NPTS + 1 --> 6NPTS) = WRESID
C
C all in external coordinates and call RES001, FTESTS
C
      NP1 = M + 1
      NP2 = 2*M + 1
      NP3 = 3*M + 1
      NP4 = 4*M + 1
      NP5 = 5*M + 1
      DO I = 1, M
         W(I) = ERRY(I)*YT
         W(M + I) = XVAL(I)*XT
         W(NP2 + I - 1) = YVAL(I)*YT
         W(NP3 + I - 1) = THEORY(I)*YT
      ENDDO
      CALL GKSR01 (NF, N, M,
     +             W(NP4), W(1), W(NP3), W(NP5), W(NP1), W(NP2),
     +             NOUT(7), SAVEIT, NOUT(5), NOUT(6), NOUT(1))
      IF (ITIME.GT.NSTART) THEN
         CALL FTESTS (NPAR(ITIME - 1), NPAR(ITIME), NF, M,
     +                WSSQ(ITIME - 1), WSSQ(ITIME), 
     +                SAVEIT, NOUT(1))
      ENDIF
      IF (NOUT(4)) THEN
         XSTART = W(NP1)
         XSTOP = W(NP2 - 1)
         CALL DIVIDE (NGRAF, 
     +                XGRAF1, XSTART, XSTOP)
         DO I = 1, NGRAF
            XGRAF2(I) = XGRAF1(I)
         ENDDO
         DO I = 1, NGRAF
            YGRAF(I) = FMOD(N, P, XGRAF1(I))
         ENDDO
         DO I = 1, L2
            XTEMP1(I) = ONE
            XTEMP2(I) = ONE
            YTEMP1(I) = ONE
            YTEMP2(I) = ONE
         ENDDO
         ASYMP = -ONE
         XTITLE = 't'
         YTITLE = 'y'
         IF (ITIME.EQ.NSTART) THEN
            PTITLE = 'Experimental Data and Best-Fit Curve'
            CALL GKST04 (L0, L1, L0, L0, 
     +                   L8, L0, L0, L0,
     +                   M, NGRAF, L2, L2, ASYMP,
     +                   W(NP1), XGRAF1, XTEMP1, XTEMP2,
     +                   W(NP2), YGRAF, YTEMP1, YTEMP2,
     +                   PTITLE, XTITLE, YTITLE, 
     +                   SAVEIT, SAVEIT)
         ELSE
            PTITLE = 'Data, Best-Fit Curve and Previous Fit'
            CALL GKST04 (L0, L1, L3, L0, 
     +                   L8, L0, L0, L0,
     +                   M, NGRAF, NGRAF, L2, ASYMP,
     +                   W(NP1), XGRAF1, XGRAF2, XTEMP1,
     +                   W(NP2), YGRAF, YSAV, YTEMP1,
     +                   PTITLE, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)
         ENDIF
C
C Save best-fit curve
C
         DO I = 1, NGRAF
            YSAV(I) = YGRAF(I)
         ENDDO
C----------------------------------------------------------------------
C Start of graphical deconvolution (note new EXTERNAL subroutine GDCON0)
C
         IF (NOUT(10)) THEN
            IF (TYPE12) THEN
               I = 1
            ELSEIF (TYPE34) THEN
               I = 2
            ELSE
               I = 3
            ENDIF
            J = 1
            CALL GDCON0 (I, ITIME, J, N, M, NGRAF,
     +                   P, W(NP1), XGRAF1, W(NP2), YGRAF)
         ENDIF
C
C End of graphical deconvolution
C----------------------------------------------------------------------
      ENDIF
C
C Save/test parameters/covariance matrix
C
      IF (NOUT(8)) THEN
         I = 1
         CALL PCVTST (I, NF, N, M, NCMAX,
     +                CV, P)
      ENDIF      
C
C Format statements
C      
   50 FORMAT (
     +/1X,'For best-fit',I2,'-exponential function')
     
  100 FORMAT (/1X,'Parameter    Value       Std.Error   Lower95%cl',
     +'   Upper95%cl',4X,'p')
     
  105 FORMAT (/1X,'Parameter     Value       Std.Error    Lower95%cl',
     +'    Upper95%cl',4X,'p')
     
  200 FORMAT (4X,'A(',I1,')',1X,1P,E13.5,E13.5,2E13.5,0P,F8.4,A2)
  205 FORMAT (4X,'A(',I1,')',4(1X,A13),F8.4,A2)
  
  300 FORMAT (4X,'B(',I1,')',1X,1P,E13.5,E13.5,2E13.5,0P,F8.4,A2)
  305 FORMAT (4X,'B(',I1,')',4(1X,A13),F8.4,A2)
  
  400 FORMAT (4X,'A(',I1,')',1X,1P,E13.5,3X,'(fixed)')
  405 FORMAT (4X,'A(',I1,')',1X,A13,3X,'(fixed)')
   
  500 FORMAT (4X,'k(',I1,')',1X,1P,E13.5,E13.5,2E13.5,0P,F8.4,A2)
  505 FORMAT (4X,'k(',I1,')',4(1X,A13),0P,F8.4,A2)
  
  600 FORMAT (6X,'C ',       1X,1P,E13.5,E13.5,2E13.5,0P,F8.4,A2)
  605 FORMAT (6X,'C ',       4(1X,A13),0P,F8.4,A2)
  
  625 FORMAT (4X,'AUC',2X,1P,E13.5)
  630 FORMAT (4X,'AUC',1X,A13)
  
  650 FORMAT (4X,'AUC',2X,1P,E13.5,E13.5,2E13.5,0P,F8.4,A2)
  655 FORMAT (4X,'AUC',1X,4(1X,A13),F8.4,A2)
  
  675 FORMAT (
     + 1X,'Initial time point (A)   =',1P,E13.5
     +/1X,'Final time point   (B)   =',1P,E13.5
     +/1X,'Area over range (A,B)    =',1P,E13.5
     +/1X,'Average over range (A,B) =',1P,E13.5)
  681 FORMAT (1X,'Initial time point (A)   =',1X,A13)
  682 FORMAT (1X,'Final time point   (B)   =',1X,A13)
  683 FORMAT (1X,'Area over range (A,B)    =',1X,A13)
  684 FORMAT (1X,'Average over range (A,B) =',1X,A13)   
  700 FORMAT (/1X,'Parameter correlation matrix')
  800 FORMAT (12F8.4)
  900 FORMAT (14F7.4)
      END
C
C
