C
C EXFIT2.FOR: DETAIL, LSFUN1, LSFUN2, RANDOM
C ===========
C
C
C
C----------------------------------------------------------------
C
      SUBROUTINE DETAIL (ISEND, NF, NN, NRAND, NSTART, NSTOP, N10,
     +                   CIN, ISTOP, JUMP, NOUT, TYPE12, TYPE34, TYPE56)
C
C Read model, orders, sig. level, output, set CIN, ITYPE
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (IN)    :: ISEND, NF, NN, N10
      INTEGER, INTENT (INOUT) :: NRAND, NSTART, NSTOP
      LOGICAL, INTENT (INOUT) :: CIN, ISTOP, NOUT(N10), TYPE12, TYPE34,
     +                           TYPE56
      LOGICAL, INTENT (IN)    :: JUMP
C
C Locals
C
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    ITYPE, NUMOPT 
      INTEGER    ICOLOR, IX, IY, LSHADE, LSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1)
      INTEGER    NUMBLD(30), NUMPOS(20)
      CHARACTER (LEN = 100) TEXT(30)
      CHARACTER (LEN = 50 ) FTYPE
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, REPEET
      LOGICAL    FIRST
      PARAMETER (FIRST = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   ADVISE, EXPDEM
      EXTERNAL   LBOX01
      EXTERNAL   DETAIL_EXFIT, HELP_EXFIT
      SAVE       ITYPE, FTYPE
      DATA       ITYPE / 1 /
      DATA       FTYPE / BLANK /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
      IF (ISTOP) RETURN
C
C Check if same models are to be used
C
      IF (ISEND.EQ.1) THEN
C
C ISEND = 1: Choose model type
C 
     
         REPEET = .TRUE.
C----------------------------------------------------------         
         DO WHILE (REPEET) 
           
            WRITE (TEXT,100)
            NUMOPT = 9
            LSTART = 1
            NTEXT = 20
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, ITYPE,
     +                   NUMOPT, NUMPOS, LSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            CIN = .FALSE.
            TYPE12 = .FALSE.
            TYPE34 = .FALSE.
            TYPE56 = .FALSE.
            REPEET = .FALSE.
            IF (ITYPE.EQ.1) THEN
               FTYPE = 'a summation of A(i)exp[-k(i)t]'
               TYPE12 = .TRUE.
            ELSEIF (ITYPE.EQ.2) THEN
               FTYPE = 'a summation of A(i)exp[-k(i)t] + C'
               CIN = .TRUE.
               TYPE12 = .TRUE.
            ELSEIF (ITYPE.EQ.3) THEN
               FTYPE = 'a summation of B(i){1 - exp[-k(i)t]}'
               TYPE34 = .TRUE.
            ELSEIF (ITYPE.EQ.4) THEN
               FTYPE = 'a summation of B(i){1 - exp[-k(i)t]} + C'
               CIN = .TRUE.
               TYPE34 = .TRUE.
            ELSEIF (ITYPE.EQ.5) THEN
               FTYPE = 'A(n-1){exp[-k(n-1)t] - exp[-k(n)t]} +...+ etc.'
               TYPE56 = .TRUE.
            ELSEIF (ITYPE.EQ.6) THEN
               FTYPE =
     +         'A(n-1){exp[-k(n-1)t] - exp[-k(n)t]} +...+ etc. + C'
               CIN = .TRUE.
               TYPE56 = .TRUE.
            ELSEIF (ITYPE.EQ.7) THEN
              CALL EXPDEM (N0)
              REPEET = .TRUE.
            ELSEIF (ITYPE.EQ.NUMOPT - 1) THEN
              IF (JUMP) THEN
                 CALL HELP_EXFIT ('exfit')
              ELSE   
                 CALL ADVISE (BLANK,
     +                        ABORT, FIRST)
              ENDIF
              REPEET = .TRUE.
            ELSEIF (ITYPE.EQ.NUMOPT) THEN
               ISTOP = .TRUE.
               RETURN
            ENDIF
         ENDDO
C----------------------------------------------------------         
      ELSE   
C
C ISEND not 1: choose runtime options
C        
         IF (ITYPE.GE.5) THEN
            IF (NSTART.EQ.N1) NSTART = N2
            IF (NSTOP.LT.NSTART) NSTOP = NSTART
         ENDIF 
         CALL DETAIL_EXFIT (ITYPE, N10, NN, NRAND, 
     +                      NSTART, NSTOP,
     +                      FTYPE,  
     +                      NOUT)
         IF (ITYPE.GE.5) THEN
            IF (NSTART.EQ.N1) NSTART = N2
            IF (NSTOP.LT.NSTART) NSTOP = NSTART
         ENDIF    
         WRITE (NF,200) FTYPE   
      ENDIF   
C
C Format statements
C      
  100 FORMAT (
     + 'Type 1. Monotonic decline to zero baseline'
     +/'Type 2. Monotonic decline to nonzero baseline'
     +/'Type 3. Monotonic monomolecular growth from zero baseline'
     +/'Type 4. Monotonic monomolecular growth from nonzero baseline'
     +/'Type 5. Up-Down Pharmacokinetic Response with zero asymptote'
     +/'Type 6. Down-Up Pharmocokinetic Response with nonzero asymptote'
     +/'Plot examples to illustrate Types 1 to 6'
     +/'Help'
     +/'Quit ... Exit program EXFIT'
     +/'Use 1`if f(t) decreases monotonically to zero'
     +/'     `Example: elimination after bolus injection'
     +/'Use 2`for decrease as 1 but from constant at t = 0 to'
     +/'     `a nonzero baseline as t tends to infifnity'
     +/'Use 3`if f(t) increases monotonically from zero at t = 0'
     +/'     `Example: monomoecular growth curve.'
     +/'Use 4`for increase as 3 but from a nonzero baseline'
     +/'Use 5`for increase from zero then return to zero.'
     +/'     `Example: elimination following an oral dose.'
     +/'Use 6`for decrease from a nonzero baseline to a low value'
     +/'     `then increase back to baseline as t tends to infinity')
  200 FORMAT (
     + '...'
     +/1X,'Model fitted is',1X,A/)
      END
C
C--------------------------------------------------------------------------
C
      SUBROUTINE DETAIL_EXFIT (ITYPE, KLOG, NN, NRAND, 
     +                         NSTART, NSTOP,
     +                         FTYPE,  
     +                         NOUT)
C
C Read orders, scaling, output, set types
C 14/08/2017 new version with nlog = 10 and calling w_get00x
C 05/02/2020 added the option to switch off as follows:
C            increased numopt from 23 to 24 
C            introduced new logical variable switch_off
C            edited the main format statement 
C            added code to track the value for switch_off  
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ITYPE, KLOG, NN
      INTEGER,             INTENT (INOUT) :: NRAND, NSTART, NSTOP
      CHARACTER (LEN = *), INTENT (IN)    :: FTYPE
      LOGICAL,             INTENT (INOUT) :: NOUT(KLOG)  
C
C locals
C        
     
      integer    numopt, numsta, numtxt, n1, n2
      parameter (numopt = 24, numsta = 1, numtxt = numopt,
     +           n1 = 1, n2 = 2)
      integer    i, icolor, ixl, iyl, j, kvalue(numopt), lshade,
     +           numbld(numopt), numpos(numopt), kvlim_1(numopt),
     +           kvlim_2(numopt)
      parameter (icolor = 7, ixl = 0, iyl = 0, lshade = 0)
      double precision xvalue(numopt) 
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 100) svalue(numopt), text_in(numopt)
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    fixed, full, high
      parameter (fixed = .false., full = .true., high = .true.)
      logical    switch_off
      external   get00x, putfat  
      intrinsic  max, min 
      save       switch_off
      data       switch_off / .false. /
c
c check
c      
      if (switch_off) return
      if (klog.ne.10) then
         call putfat ('KLOG must be 10 in call to DETAIL')
         return
      endif
      if (nstart.lt.1 .or. nstart.gt.nstop .or. nstop.gt.nn) then 
         call putfat (
     +'Must have 1 =< NSTART =< NSTOP =< NN in call to DETAIL_EXFIT')
         return
      endif 
      if (nrand.lt.1 .or. nrand.gt.4) then
         call putfat ('Must have 1 =< NRAND =< 4 in call to DETAIL')
         return
      endif      
c
c initialise all local variables
c 
      do i = 1, numopt
         numbld(i) = 0
         numpos(i) = 0
         kvalue(i) = 0
         kvlim_1(i) = 0
         kvlim_2(i) = 0
         xvalue(i) = zero
         svalue(i) = blank
      enddo
c
c set parameters for nstart and nstop and default nrand
c      
      if (itype.ge.5) then
         kvlim_1(1) = 2
         kvlim_1(2) = 2
      else
         kvlim_1(1) = 1
         kvlim_1(2) = 1
      endif      
      kvlim_2(2) = nn
      kvlim_1(3) = 1
      kvlim_2(3) = nn
      kvalue(2) = nstart
      kvalue(3) = nstop
      do i = 1, 4
         if (nrand.eq.i) kvalue(i + 5) = 1
      enddo
c
c create the text array
c      
      if (itype.lt.5) then
         write (text_in,100) n1, nn, itype, ftype
      else   
         write (text_in,100) n2, nn, itype, ftype
      endif   
      numpos(1) = 8 
         numbld(1) = 1!blue text
      numpos(2) = 9
      numpos(3) = 9
      numpos(4) = 8
      numpos(5) = 8
         numbld(5) = 1!blue text
      numpos(6) = 6
      numpos(7) = 6 
      numpos(8) = 6
      numpos(9) = 6
      numpos(10) = 8
      numpos(11) = 8
         numbld(11) = 1!blue text
      numpos(12) = 4
      numpos(13) = 4
      numpos(14) = 4 
      numpos(15) = 4
      numpos(16) = 4
      numpos(17) = 4
      numpos(18) = 4
      numpos(19) = 4
      numpos(20) = 4
      numpos(21) = 4
      numpos(22) = 4
      numpos(23) = 8
         numbld(24) = 1!blue
      numpos(24) = 8   
C
C set logical parameters
C nout(1)  ... display analysis table
C nout(2)  ... display starting estimates
C nout(3)  ... display random search
C nout(4)  ... plot    best fit curves
C nout(5)  ... plot    residuals
C nout(6)  ... display residuals table
C nout(7)  ... file    residuals table
C nout(8)  ... high precision convergence test
C nout(9)  ... parameters and covariance matrix
C nout(10) ... graphical deconvolution
C
      j = 11
      do i = 1, klog
         j = j + 1
         if (nout(i)) kvalue(j) = 1
      enddo  
      if (switch_off) kvalue(j + 1) = 0
c
c loop over the options
c      
         kvalue(numopt - 1) = 0
         kvalue(numopt) = 0
         call get00x (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +                lshade, numbld, numopt, numpos, numsta, numtxt,
     +                xvalue,
     +                svalue, text_in,
     +                fixed, full, high)
c
c define nstart, nstop
c     
         nstart = min(kvalue(2),kvalue(3))
         nstop = max(kvalue(2),kvalue(3))
c
c define nrand
c         
         j = 0
         do i = 6, 9
            j = j + 1
            if (kvalue(i).eq.1) then
               nrand = j
            endif
         enddo  
c
c assign logical variables
c
         j = 11
         do i = 1, klog
            j = j + 1
            if (kvalue(j).eq.1) then
               nout(i) = .true.
            else
               nout(i) = .false.
            endif   
         enddo  
         if (kvalue(j + 1).eq.1) switch_off = .true.
c
c format statement
c   
  100 FORMAT (
     + 'Choose the sequence of exponential functions required'      !1
     +/'Lowest order (>=',i2,')'                                    !2
     +/'Highest order (=<',i2,')'                                   !3
     +/                                                             !4
     +/'Choose the method to use for parameter starting estimates'  !5 
     +/'Short Random search'                                        !6
     +/'Medium Random search'                                       !7
     +/'Extensive Random search'                                    !8 
     +/'You input starting estimates'                               !9
     +/                                                             !10
     +/'Choose the procedures required for this analysis'           !11 
     +/'Display the goodness of fit analysis'                       !12
     +/'Display values of starting estimates'                       !13
     +/'Display details of any random search'                       !14
     +/'Plot the best fit curves and data'                          !15 
     +/'Provide options to plot residuals'                          !16
     +/'Display tables of (wtd.) residuals'                         !17
     +/'Write residuals to results log file'                        !18
     +/'Store/test parameters/covariance-matrix'                    !19
     +/'Use the relaxation technique for Models 5 and 6'            !20
     +/'Display graphical deconvolution for order > 1'              !21
     +/'Do not ask again this session'                              !22
     +/                                                             !23 
     +/'Model',i2,':',1x,a)                                         !24
      END
C
C--------------------------------------------------------------------------
C
      SUBROUTINE LSFUN1 (M, N,
     +                   XC, FVECC)
C
C Model subroutine for E04FDF
C Note: the definition of FVECC must be consistent with the Jacobian definition 
C

      USE MODULE_EXFIT, ONLY : EQUAL, THEORY, ERRY, XVAL, YVAL

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: M, N
      DOUBLE PRECISION, INTENT (IN)  :: XC(N)
      DOUBLE PRECISION, INTENT (OUT) :: FVECC(M)
C
C Locals
C      
      INTEGER    I
      DOUBLE PRECISION FMOD
      EXTERNAL FMOD
      DO I = 1, M
         IF (EQUAL(I)) THEN
            THEORY(I) = THEORY(I - 1)
         ELSE
            THEORY(I) = FMOD(N,
     +                       XC, XVAL(I))
         ENDIF
C
C The sign must be consistent with the sign used to  
C define the Jacobian in subroutine LSJAC1   
C     
C         FVECC(I) = (YVAL(I) - THEORY(I))/ERRY(I)
         FVECC(I) = (THEORY(I) - YVAL(I))/ERRY(I)
      ENDDO
      END
C
C--------------------------------------------------------------------------

C
      SUBROUTINE LSFUN2 (M, 
     +                   FVECC, WSSQ)
C
C Calculate WSSQ given FVECCC: XBIG, YBIG prevent overflow during random search
C

      USE MODULE_EXFIT, ONLY : YBIG, XBIG       

      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: M
      DOUBLE PRECISION, INTENT (IN)  :: FVECC(M)
      DOUBLE PRECISION, INTENT (OUT) :: WSSQ
C
C Locals
C      
      INTEGER  I
      
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      WSSQ = ZERO
      DO I = 1, M
         IF (FVECC(I).LT.YBIG .AND. WSSQ.LT.XBIG) THEN
            WSSQ = WSSQ + FVECC(I)*FVECC(I)
         ELSE
            WSSQ = XBIG
            RETURN
         ENDIF
      ENDDO
      END
C
C--------------------------------------------------------------------------

C
      SUBROUTINE RANDOM (IOVER, ITIME, IUNDER, NCMAX, NDOF, NF, NN,
     +                   NPAR, NPTS, NRAND, NRMAX, N10,
     +                   EPSI, W, WSSQ, X, XT, YN, YT,
     +                   CIN, ISTOP, NOUT, TYPE12, TYPE34, TYPE56)
C
C NRAND <= 3 : Random search
C NRAND  = 4 : User inputs starting estimates
C Revised 9/7/92 for updown/downup
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NCMAX, NN, NRMAX, N10
      INTEGER,          INTENT (IN)    :: ITIME, NF, NPTS, NRAND
      INTEGER,          INTENT (OUT)   :: IOVER, IUNDER, NDOF
      INTEGER,          INTENT (INOUT) :: NPAR(NN)
      DOUBLE PRECISION, INTENT (IN)    :: EPSI, XT, YN, YT
      DOUBLE PRECISION, INTENT (INOUT) :: WSSQ(NN), X(NCMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: W(10*NRMAX)
      LOGICAL,          INTENT (IN)    :: CIN, NOUT(N10), TYPE12,
     +                                    TYPE34, TYPE56
      LOGICAL,          INTENT (INOUT) :: ISTOP
C
C Locals
C      
      INTEGER    NTOTAL
      PARAMETER (NTOTAL = 3)
      INTEGER    MAXIT1, MAXIT2, MAXIT3
      PARAMETER (MAXIT1 = 1024, MAXIT2 = 2048, MAXIT3 = 8192)
      INTEGER    MINIT
      PARAMETER (MINIT = 128)
      INTEGER    NUMBER(NTOTAL)
      INTEGER    I, J, K, L, M, N, NUMA, NUMAPI, NUMAP1
      INTEGER    ICOUNT, ITIMEH, ITIME1, ITIME2
      INTEGER    NREPS, NTYPES
      INTEGER    COLOUR
      DOUBLE PRECISION ONE, FOUR, TEN, ZERO
      PARAMETER (ONE = 1.0D+00, FOUR = 4.0D+00, TEN = 10.0D+00,
     +           ZERO = 0.0D+00)
      DOUBLE PRECISION PNT1, PNT2
      PARAMETER (PNT1 = 0.1D+00, PNT2 = 0.2D+00)
      DOUBLE PRECISION STORES(20)
      DOUBLE PRECISION A, B, BMINA, DUMMY, FBEST, FSAV, FTRY, GUESS,
     +                 SUMMIT, XMIN
      DOUBLE PRECISION RANNUM
      DOUBLE PRECISION G05CAF$
      CHARACTER (LEN = 9) D09(2), FORM09 
      CHARACTER  SYMBOL(NTOTAL)*6
      CHARACTER  LINE*100, LINE3(3)*100
      LOGICAL    POSTIV(20)
      EXTERNAL   FORM09
      EXTERNAL   RANNUM, LSFUN1, LSFUN2
      EXTERNAL   PUTFAT, XSTART, TABLE1
      EXTERNAL   G05CAF$
      INTRINSIC  ABS, MOD
      IF (ISTOP) RETURN
C
C Set NPAR, NDOF etc.
C
      ITIMEH = ITIME/2
      ITIME1 = ITIME + 1
      ITIME2 = 2*ITIME
      NPAR(ITIME) = ITIME2
      NUMA = ITIME
      IF (TYPE56) THEN
         NPAR(ITIME) = NPAR(ITIME) - 1
         NUMA = NUMA - 1
      ENDIF
      NUMAPI = NUMA + ITIME
      NUMAP1 = NUMA + 1
      IF (CIN) NPAR(ITIME) = NPAR(ITIME) + 1
      NDOF = NPTS - NPAR(ITIME)
      IF (NDOF.LE.0) THEN
         CALL PUTFAT ('Insufficient data ... Analysis terminated')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      M = NPTS
      N = NPAR(ITIME)
      IOVER = 0
      IUNDER = 0
C
C Omit random search if NRAND = 4 and go to manual input
C
      IF (NRAND.EQ.4) GOTO 20
C
C First of all guess coefficients
C
      IF (CIN) THEN
         GUESS = (ONE - YN)/ITIME
         X(N) = YN
      ELSE
         GUESS = ONE/ITIME
      ENDIF
      DO I = 1, NUMAPI
         IF (I.LE.NUMA) THEN
            STORES(I) = GUESS
         ELSE
            STORES(I) = ONE
         ENDIF
      ENDDO
      IF (CIN) STORES(N) = X(N)
      CALL LSFUN1 (M, N, STORES, W)
      CALL LSFUN2 (M, W, FBEST)
      FSAV = FBEST
      COLOUR = 15
      CALL TABLE1 (COLOUR, 'OPEN')
      IF (NOUT(3)) THEN
         WRITE (LINE,200) ITIME
         WRITE (NF,200) ITIME
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         COLOUR = 0
      ENDIF
      NREPS = 2**(N + 2)
      IF (NRAND.EQ.1) THEN
         IF (NREPS.GT.MAXIT1) NREPS = MAXIT1
      ELSEIF (NRAND.EQ.2) THEN
         NREPS = 4*NREPS
         IF (NREPS.GT.MAXIT2) NREPS = MAXIT2
      ELSE
         NREPS = 16*NREPS
         IF (NREPS.GT.MAXIT3) NREPS = MAXIT3
      ENDIF
      IF (NREPS.LT.MINIT) NREPS = MINIT
      ICOUNT = 0
C
C Global random search from a fixed point for monotonic curves, A > 0
C
      A = ONE
      B = ZERO
      DO 107 I = 1, NRAND
         B = B + FOUR
         BMINA = B - A
         DO 106 J = 1, NREPS
            ICOUNT = ICOUNT + 1
            SUMMIT = ZERO
            DO 101 K = 1, NUMA
               X(K) = A + BMINA*G05CAF$(DUMMY)
               SUMMIT = SUMMIT + X(K)
  101       CONTINUE
            SUMMIT = SUMMIT*(TEN**(PNT1*RANNUM()))
            DO 102 K = 1, NUMA
               X(K) = X(K)/SUMMIT
  102       CONTINUE
            XMIN = B
            DO 103 K = NUMAP1, NUMAPI
               X(K) = A + BMINA*G05CAF$(DUMMY)
               IF (X(K).LT.XMIN) XMIN = X(K)
  103       CONTINUE
            XMIN = XMIN*(TEN**(PNT2*RANNUM()))
            DO 104 K = NUMAP1, NUMAPI
               X(K) = X(K)/XMIN
  104       CONTINUE
            IF (CIN) X(N) = YN*(TEN**(PNT1*RANNUM()))
            CALL LSFUN1 (M, N, X, W)
            CALL LSFUN2 (M, W, FTRY)
            IF (FTRY.LT.FBEST) THEN
               FBEST = FTRY
               IF (NOUT(3)) THEN
                  D09(1) = FORM09(FBEST)
C                  WRITE (LINE,300) ICOUNT, FBEST
C                  WRITE (NF,300) ICOUNT, FBEST
                  WRITE (LINE,300) ICOUNT, D09(1)
                  WRITE (NF,300) ICOUNT, D09(1)
                  COLOUR = 0
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
               DO 105 K = 1, N
                  STORES(K) = X(K)
  105          CONTINUE
            ENDIF
  106    CONTINUE
         IF (NOUT(3)) THEN
            WRITE (LINE,400) I
            WRITE (NF,400) I
            COLOUR = 4
            CALL TABLE1 (COLOUR, LINE)
            COLOUR = 0
         ENDIF
  107 CONTINUE
C
C Global random search from a fixed point with A(I) of either sign
C
      B = ONE
      DO 207 I = 1, NRAND
         B = FOUR*B
         A = -B
         BMINA = 2.0*B
         DO 206 J = 1, NREPS
            ICOUNT = ICOUNT + 1
            SUMMIT = ZERO
            DO 201 K = 1, NUMA
               X(K) = A + BMINA*G05CAF$(DUMMY)
               SUMMIT = SUMMIT + X(K)
  201       CONTINUE
            SUMMIT = SUMMIT*(TEN**(PNT2*RANNUM()))
            IF (ABS(SUMMIT).LT.EPSI) SUMMIT = EPSI
            DO 202 K = 1, NUMA
               X(K) = X(K)/SUMMIT
  202       CONTINUE
            XMIN = B
            DO 203 K = NUMAP1, NUMAPI
               X(K) = A + BMINA*G05CAF$(DUMMY)
               IF (X(K).LT.XMIN) XMIN = X(K)
  203       CONTINUE
            XMIN = XMIN*(TEN**(PNT2*RANNUM()))
            DO 204 K = NUMAP1, NUMAPI
               X(K) = X(K)/XMIN
  204       CONTINUE
            IF (CIN) X(N) = YN*(TEN**(PNT2*RANNUM()))
            CALL LSFUN1 (M, N, X, W)
            CALL LSFUN2 (M, W, FTRY)
            IF (FTRY.LT.FBEST) THEN
               FBEST = FTRY
               IF (NOUT(3)) THEN
                  D09(1) = FORM09(FBEST)
C                  WRITE (LINE,300) ICOUNT, FBEST
C                  WRITE (NF,300) ICOUNT, FBEST
                  WRITE (LINE,300) ICOUNT, D09(1)
                  WRITE (NF,300) ICOUNT, D09(1)
                  COLOUR = 0
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
               DO 205 K = 1, N
                  STORES(K) = X(K)
  205          CONTINUE
            ENDIF
  206    CONTINUE
         IF (NOUT(3)) THEN
             WRITE (LINE,400) NRAND + I
             WRITE (NF,400) NRAND + I
             COLOUR = 4
             CALL TABLE1 (COLOUR, LINE)
             COLOUR = 0
         ENDIF
  207 CONTINUE
C
C Search for up down and down up types of curve if ITIME > 1
C
      IF (ITIME.GT.1) THEN
         IF (TYPE12 .OR. TYPE34) THEN
C
C Up down type of curve
C
            A = ONE
            B = ZERO
            SUMMIT = ZERO
            DO 306 I = 1, NRAND
               B = B + FOUR
               SUMMIT = SUMMIT + ONE
               BMINA = B - A
               DO 305 J = 1, NREPS
                  ICOUNT = ICOUNT + 1
                  L = 0
                  DO 301 K = 1, ITIMEH
                     L = L + 1
                     X(L) = TEN**(SUMMIT*RANNUM())
                     L = L + 1
                     X(L) =  - X(L - 1)
  301             CONTINUE
                  IF (MOD(ITIME,2).EQ.1) X(ITIME) =
     +                TEN**(SUMMIT*RANNUM())
                  XMIN = B
                  DO 302 K = ITIME1, ITIME2
                     X(K) = A + BMINA*G05CAF$(DUMMY)
                     IF (X(K).LT.XMIN) XMIN = X(K)
  302             CONTINUE
                  XMIN = XMIN*(TEN**(PNT2*RANNUM()))
                  DO 303 K = ITIME1, ITIME2
                     X(K) = X(K)/XMIN
  303             CONTINUE
                  IF (CIN) X(N) = YN*(TEN**(PNT1*RANNUM()))
                  CALL LSFUN1 (M, N, X, W)
                  CALL LSFUN2 (M, W, FTRY)
                  IF (FTRY.LT.FBEST) THEN
                     FBEST = FTRY
                     IF (NOUT(3)) THEN
                        D09(1) = FORM09(FBEST)
C                        WRITE (LINE,300) ICOUNT, FBEST
C                        WRITE (NF,300) ICOUNT, FBEST
                        WRITE (LINE,300) ICOUNT, D09(1)
                        WRITE (NF,300) ICOUNT, D09(1)
                        COLOUR = 0
                        CALL TABLE1 (COLOUR, LINE)
                     ENDIF
                     DO 304 K = 1, N
                        STORES(K) = X(K)
  304                CONTINUE
                  ENDIF
  305          CONTINUE
  306       CONTINUE
            IF (NOUT(3)) THEN
               WRITE (LINE,400) 2*NRAND + 1
               WRITE (NF,400) 2*NRAND + 1
               COLOUR = 4
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = 0
            ENDIF
C
C Down up type of curve
C
            A = ONE
            B = ZERO
            SUMMIT = ZERO
            DO 406 I = 1, NRAND
               B = B + FOUR
               SUMMIT = SUMMIT + ONE
               DO 405 J = 1, NREPS
                  ICOUNT = ICOUNT + 1
                  L = 0
                  DO 401 K = 1, ITIMEH
                     L = L + 1
                     X(L) = TEN**(SUMMIT*RANNUM())
                     L = L + 1
                     X(L) =  - X(L - 1)
  401             CONTINUE
                  IF (MOD(ITIME,2).EQ.1) X(ITIME) =
     +               -TEN**(SUMMIT*RANNUM())
                  XMIN = B
                  DO 402 K = ITIME1, ITIME2
                     X(K) = A + BMINA*G05CAF$(DUMMY)
                     IF (X(K).LT.XMIN) XMIN = X(K)
  402             CONTINUE
                  XMIN = XMIN*(TEN**(PNT2*RANNUM()))
                  DO 403 K = ITIME1, ITIME2
                     X(K) = X(K)/XMIN
  403             CONTINUE
                  IF (CIN) X(N) = TEN**(PNT1*RANNUM())
                  CALL LSFUN1 (M, N, X, W)
                  CALL LSFUN2 (M, W, FTRY)
                  IF (FTRY.LT.FBEST) THEN
                     FBEST = FTRY
                     IF (NOUT(3)) THEN
                        D09(1) = FORM09(FBEST)
C                        WRITE (LINE,300) ICOUNT, FBEST
C                        WRITE (NF,300) ICOUNT, FBEST
                        WRITE (LINE,300) ICOUNT, D09(1)
                        WRITE (NF,300) ICOUNT, D09(1)
                        COLOUR = 0
                        CALL TABLE1 (COLOUR, LINE)
                     ENDIF
                     DO 404 K = 1, N
                        STORES(K) = X(K)
  404                CONTINUE
                  ENDIF
  405          CONTINUE
  406       CONTINUE
            IF (NOUT(3)) THEN
               WRITE (LINE,400) 2*NRAND + 1
               WRITE (NF,400) 2*NRAND + 1
               COLOUR = 4
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = 0
            ENDIF
         ENDIF
      ENDIF
C
C Local intelligent search from a moving point
C
      DO 604 I = 1, 2*NREPS
         ICOUNT = ICOUNT + 1
         DO 601 J = 1, NUMA
            X(J) = STORES(J)*(TEN**(PNT2*RANNUM()))
  601    CONTINUE
         DO 602 J = NUMAP1, N
            X(J) = STORES(J)*(TEN**(PNT1*RANNUM()))
  602    CONTINUE
         CALL LSFUN1 (M, N, X, W)
         CALL LSFUN2 (M, W, FTRY)
         IF (FTRY.LT.FBEST) THEN
            FBEST = FTRY
            IF (NOUT(3)) THEN
               D09(1) = FORM09(FBEST)
C               WRITE (LINE,300) ICOUNT, FBEST
C               WRITE (NF,300) ICOUNT, FBEST
               WRITE (LINE,300) ICOUNT, D09(1)
               WRITE (NF,300) ICOUNT, D09(1)
               COLOUR = 0
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
            DO 603 J = 1, N
               STORES(J) = X(J)
  603       CONTINUE
         ENDIF
  604 CONTINUE
      IF (NOUT(3)) THEN
         WRITE (LINE,500)
         WRITE (NF,500)
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         D09(1) = FORM09(FSAV)
         D09(2) = FORM09(FBEST)
C         WRITE (LINE3,600) ICOUNT, FSAV, FBEST
C         WRITE (NF,600) ICOUNT, FSAV, FBEST
         WRITE (LINE3,600) ICOUNT, D09(1), D09(2)
         WRITE (NF,600) ICOUNT, D09(1), D09(2)
         COLOUR = 0
         DO I = 1, 3
            LINE = LINE3(I)
            CALL TABLE1 (COLOUR, LINE)
         ENDDO
      ENDIF
C*****IF (.NOT.NOUT(3)) THEN
C        WRITE (LINE,700)
C        COLOUR = 0
C        CALL TABLE1 (COLOUR, LINE)
C*****ENDIF
      CALL TABLE1 (COLOUR, 'CLOSE')
      DO 605 I = 1, N
         X(I) = STORES(I)
  605 CONTINUE
      GOTO 40
C
C Enter here to input starting estimates if NRAND = 4
C
   20 CONTINUE
      NTYPES = 2
      NUMBER(1) = NUMA
      NUMBER(2) = ITIME
      IF (TYPE12 .OR. TYPE56) THEN
         SYMBOL(1) = '     A'
      ELSE
         SYMBOL(1) = '     B'
      ENDIF
      SYMBOL(2) = '     k'
      IF (CIN) THEN
         NTYPES = 3
         NUMBER(3) = 1
         SYMBOL(3) = '     C'
      ENDIF
      DO 701 I = 1, N
         POSTIV(I) = .FALSE.
  701 CONTINUE
      CALL XSTART (N, NTYPES, NUMBER, STORES, SYMBOL, POSTIV)
      DO 702 I = 1, NUMA
         X(I) = STORES(I)/YT
  702 CONTINUE
      DO 703 I = NUMAP1, NUMAPI
         X(I) = STORES(I)*XT
  703 CONTINUE
      IF (CIN) X(N) = STORES(N)/YT
   40 CONTINUE
      CALL LSFUN1 (M, N,
     +             X, W)
      CALL LSFUN2 (M, W,
     +             WSSQ(ITIME))
C
C Format statements
C      
C 100 FORMAT ('Wait',3X,'...',3X,'Random search in progress')
  200 FORMAT (1X,'Iteration   WSSQ(',I1,' exponential(s))')
C  300 FORMAT (1X,I9,1P,E13.5)
  300 FORMAT (1X,I9,1X,A) 	
  400 FORMAT (1X,'End of search number',I3)
  500 FORMAT (1X,'End of local search')
  600 FORMAT (1X,'Total Number of iterations used =',I8
C     +/1X,'Before random search WSSQ =',1P,E10.3
C     +/1X,'After  random search WSSQ =',1P,E10.3)
     +/1X,'Before random search WSSQ =',1X,A
     +/1X,'After  random search WSSQ =',1X,A)
C 700 FORMAT ('Done',3X,'...',3X,'Random search is finished')
      END
C
C
