C
C EXFIT3.FOR: VMATRX, FMOD, RANNUM
C ==========
C
C
      SUBROUTINE VMATRX (ITIME, IOVER, IUNDER, NCMAX, NDOF, NF,
     +                   NN, NPAR,
     +                   CV, ETOL, P, SE, TSIG, X, XT, YT,
     +                   CIN, ISTOP, TYPE12, TYPE34)
C
C Transform to external parameters and covariance matrix
C Calculate standard errors and t significance levels
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NCMAX, NN
      INTEGER,          INTENT (IN)    :: ITIME, IOVER, IUNDER, NDOF,
     +                                    NF, NPAR(NN)
      DOUBLE PRECISION, INTENT (IN)    :: ETOL, X(NCMAX), XT, YT
      DOUBLE PRECISION, INTENT (INOUT) :: CV(NCMAX,NCMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: P(NCMAX), SE(NCMAX),
     +                                    TSIG(NCMAX)
      LOGICAL,          INTENT (IN)    :: CIN, ISTOP, TYPE12, TYPE34
C 
C Locals
C      
      INTEGER    I, IFAIL, J
      DOUBLE PRECISION F(20)
      DOUBLE PRECISION ALPHA, FX, FY, T
      DOUBLE PRECISION G01EBF$
      DOUBLE PRECISION ONE, TWO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00)
      CHARACTER  LINE*100
      EXTERNAL   G01EBF$
      EXTERNAL   PUTIFA, PUTWAR
      INTRINSIC  ABS, SQRT, DBLE
      IF (ISTOP) RETURN
      IF (IOVER.GT.0) THEN
         WRITE (LINE,100) IOVER
         CALL PUTWAR (LINE)
         WRITE (NF,100) IOVER
      ENDIF
      IF (IUNDER.GT.0) THEN
         WRITE (LINE,200) IUNDER
         CALL PUTWAR (LINE)
         WRITE (NF,200) IUNDER
      ENDIF
      FX = ONE/XT
      FY = YT
      IF (TYPE12 .OR. TYPE34) THEN
         DO I = 1, ITIME
            F(I) = FY
         ENDDO
         DO I = ITIME + 1, 2*ITIME
            F(I) = FX
         ENDDO
      ELSE
         DO I = 1, ITIME - 1
            F(I) = FY
         ENDDO
         DO I = ITIME, 2*ITIME - 1
            F(I) = FX
         ENDDO
      ENDIF
      IF (CIN) F(NPAR(ITIME)) = FY
      DO I = 1, NPAR(ITIME)
         P(I) = F(I)*X(I)
      ENDDO
      DO J = 1, NPAR(ITIME)
         DO I = J, NPAR(ITIME)
            CV(I,J) = F(I)*F(J)*CV(I,J)
            IF (I.GT.J) CV(J,I) = CV(I,J)
         ENDDO
      ENDDO
      DO I = 1, NPAR(ITIME)
         SE(I) = SQRT(CV(I,I))
         IF (SE(I).LT.ETOL) SE(I) = ETOL
         T = ABS(P(I))/SE(I)
         IFAIL = 1
         ALPHA = ONE - G01EBF$('Lower-tail', T, DBLE(NDOF), IFAIL)
         CALL PUTIFA (IFAIL, NF, 'G01EBF/VMATRX')
         TSIG(I) = TWO*ALPHA
      ENDDO
C
C Format statements
C      
  100 FORMAT (I8,1X,
     +'Exponential overflows. Model/Data probably inconsistent ?')
  200 FORMAT (I8,1X,
     +'Exponential underflows. Model/Data probably inconsistent ?')
      END
C
C--------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION FMOD(N,
     +                               X, T)
C
C Exponential functions as determined by ITYPE and CIN
C

      USE MODULE_EXFIT, ONLY : ITIME, ENEG, IUNDER, EPOS, IOVER, TYPE12,
     +                         TYPE34, CIN, TYPE56 

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N
      DOUBLE PRECISION, INTENT (IN) :: X(N), T
C
C Locals
C      
      INTEGER    I, J
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION E(20)
      INTRINSIC EXP
      IF (TYPE56) THEN
         J = ITIME - 1
      ELSE
         J = ITIME
      ENDIF
      DO I = 1, ITIME
         J = J + 1
         E(I) = - T*X(J)
         IF (E(I).LT.ENEG) THEN
            E(I) = ENEG
            IUNDER = IUNDER + 1
         ENDIF
         IF (E(I).GT.EPOS) THEN
            E(I) = EPOS
            IOVER = IOVER + 1
         ENDIF
      ENDDO
      FMOD = ZERO
      IF (TYPE12) THEN
         DO I = 1, ITIME
            FMOD = FMOD + X(I)*EXP(E(I))
         ENDDO
      ELSEIF (TYPE34) THEN
         DO I = 1, ITIME
            FMOD = FMOD + X(I)*(ONE - EXP(E(I)))
         ENDDO
      ELSE
         J = ITIME - 1
         DO I = 1, J
            FMOD = FMOD + X(I)*EXP(E(I))
         ENDDO
         FMOD = FMOD - X(J)*EXP(E(ITIME))
      ENDIF
      IF (CIN) FMOD = FMOD + X(N)
      END
C
C--------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION RANNUM()
C
C Normal variate (RMEAN, SIGMA) truncated at +/- 2 SIGMA
C
      IMPLICIT   NONE
      DOUBLE PRECISION RMEAN, SIGMA
      PARAMETER (RMEAN = 0.0D+00, SIGMA = 1.0D+00)
      DOUBLE PRECISION BOT, TOP
      PARAMETER (BOT = RMEAN - 2.0D+00*SIGMA,
     +           TOP = RMEAN + 2.0D+00*SIGMA)
      DOUBLE PRECISION G05DDF$
      EXTERNAL   G05DDF$
   20 CONTINUE
      RANNUM = G05DDF$(RMEAN, SIGMA)
      IF (RANNUM.LT.BOT .OR. RANNUM.GT.TOP) GOTO 20
      END
C
C
