C
C EXFIT4.FOR: LMFUNC, LSJAC1, JMOD
C ==========
C
C
      SUBROUTINE LMFUNC (M, N, X, FVEC, FJAC, LDFJAC, IFLAG)
C
C ACTION : Subroutine for MINPACK
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 26/8/97
C
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: IFLAG, LDFJAC, M, N
      DOUBLE PRECISION, INTENT (INOUT) :: FVEC(M), FJAC(LDFJAC,N), X(N)
C
C Locals
C      
      EXTERNAL LSFUN1, LSJAC1
      IF (IFLAG.EQ.1) THEN
         CALL LSFUN1 (M, N, X, FVEC)
      ELSEIF (IFLAG.EQ.2) THEN
         CALL LSJAC1 (M, N, LDFJAC, X, FJAC)
      ENDIF
      END
C
C-----------------------------------------------------------------
C
      SUBROUTINE LSJAC1 (M, N, NRMAX, 
     +                   XC, FJACC)
C
C Jacobian subroutine for LMFIT1/LMFUNC
C Note that the Jacobian is fjac(i,j) = - z(j)/erry(i) if F = (yval - theory)/erry
C                                 but =   z(j)/erry(i) if F = (theory - yval)/erry
C

      USE MODULE_EXFIT, ONLY : EQUAL, XVAL, ERRY

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: M, N, NRMAX
      DOUBLE PRECISION, INTENT (IN)  :: XC(N)
      DOUBLE PRECISION, INTENT (OUT) :: FJACC(NRMAX,N)
C
C Locals
C      
      INTEGER    I, J
      DOUBLE PRECISION Z(20)
      EXTERNAL JMOD
      DO I = 1, M
         IF (.NOT.EQUAL(I)) CALL JMOD (N,
     +                                 XC, XVAL(I), Z)
         DO J = 1, N
C           
C The sign must be consistent with the sign used   
C for FVECC in subroutine LSFUN1         
C
C            FJACC(I,J) = - Z(J)/ERRY(I)
            FJACC(I,J) = Z(J)/ERRY(I)
         ENDDO
      ENDDO
      END
C
C--------------------------------------------------------------------
C
      SUBROUTINE JMOD (N,
     +                 X, T, Z)
C
C Exponential functions as determined by ITYPE and CIN
C Note: the derivatives are returned in Z but then the Jacobian
C has to be calculated as FJAC(i,j) = -Z(j)/ERRY(i) in LSJAC1
C

      USE MODULE_EXFIT, ONLY : TYPE56, ITIME, ENEG, IUNDER, EPOS, IOVER,
     +                         TYPE12, CIN, TYPE34       

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      DOUBLE PRECISION, INTENT (IN)  :: X(N), T
      DOUBLE PRECISION, INTENT (OUT) :: Z(N)
C
C Locals
c      
      INTEGER    I, J
      DOUBLE PRECISION RESUL
      DOUBLE PRECISION E(20)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      INTRINSIC EXP
      IF (TYPE56) THEN
         J = ITIME - 1
      ELSE
         J = ITIME
      ENDIF
      DO I = 1, ITIME
         J = J + 1
         E(I) = - T*X(J)
         IF (E(I).LT.ENEG) THEN
            E(I) = ENEG
            IUNDER = IUNDER + 1
         ENDIF
         IF (E(I).GT.EPOS) THEN
            E(I) = EPOS
            IOVER = IOVER + 1
         ENDIF
      ENDDO
      IF (TYPE12) THEN
         DO I = 1, ITIME
            RESUL = EXP(E(I))
            Z(I) = RESUL
            Z(ITIME + I) = - X(I)*T*RESUL
         ENDDO
      ELSEIF (TYPE34) THEN
         DO I = 1, ITIME
            RESUL = EXP(E(I))
            Z(I) = ONE - RESUL
            Z(ITIME + I) = X(I)*T*RESUL
         ENDDO
      ELSE
         J = ITIME - 1
         DO I = 1, J
            RESUL = EXP(E(I))
            Z(I) = RESUL
            Z(J + I) = - X(I)*T*RESUL
         ENDDO
         RESUL = EXP(E(ITIME))
         Z(J) = Z(J) - RESUL
         Z(ITIME + J) = X(J)*T*RESUL
      ENDIF
      IF (CIN) Z(N) = ONE
      END
C
C
