c
c =========================
c for2f95.for: w.g.bardsley
c =========================  
c
c WARNING: This program is designed to transform fixed format code in *.for 
c ======== files into free format code in *.f95 files. It is only guaranteed
c          to work with codes written by bill.bardsley@manchester.ac.uk and
c          may not work with code by others. It should work with any fixed
c          form fortran77 source code, but in particular it may screw up 
c          Holleriths and some non-standard constructs used by other 
c          programmers.
c 
c Revised 16/01/2002
c Revised 20/11/2002 to ignore numbers in column 1, remove final ampersands
c                    from continuation lines and preserve comment lines in
c                    full. Code is truncated at column 73 with either a blank
c                    or an ampersand 
c Revised 20/08/2006 Introduced parameters lmax and nmax and subroutine inspec.
c                    Made all lines lmax characters wide where lmax >= 72 and
c                    dealt with ampersands on continuation lines. Note that
c                    the number of stored lines in each category must =< nmax.
c                    Lines are now trucated at position lmax and not 
c                    necessarily at position 72. 
c Revised 11/08/2007 moved continuation ampersands to column 73, not column 74
c                    as this was leaving unwanted characters in column 73
c Revised 03/04/2008 moved comment exclamation marks to column 74 in case
c                    continuation characters are needed between end of code 
c                    and start of exclamation mark comments
c Revised 02/01/2012 option for either free or fixed/free 
c
c Summary
c =======
c A fortran 77 program to take in *.for or *.ins and create *.f95 files.
c This program will not overwrite any existing files and the output file
c will be *.f95 whether it was *.for or *.ins. So you can always rename
c the *.f95 to *.ins (after saving the original *.ins file) if you want
c to retain a distinction between main programs and include files.
c
c Definitions
c ===========
c  INPUT: *.for = a fixed format fortran77 file (in my simfit ftn77 style)
c  INPUT: *.ins = a fixed format fortran77 file (in my simfit ftn77 style)
c OUTPUT: *.f95 = a free  format fortran95 file (in free or hybrid style)
c
c Advice
c ======
c The for or ins file must be in my simfit ftn77 style. for2f95 does
c check if line(1:1) is a C, * or !, etc. but it does not check if
c line(6:6) is + or any other possibility. 
c Comment lines are preserved in full.
c Exclamation = char(30) starting comments not in column 1 are all moved 
c over with the comment string to new starting position in column 74 to
c prevent ambiguities in continuation lines for fixed/free hybrid output files.
c It may cause problems with Holleriths, multiple commands on one line and
c constructs used by other programmers but not by me. In particular,
c this version will not overwrite any existing *.f95 file.
c
c
      program    main
      implicit   none
      integer    isend, lmax, nmax, nout
      parameter (isend = 3, lmax = 256, nmax = 20000, nout = 4)
      integer    itype(nmax)
      integer    i, icount, ierror, ios, l1, l2, len200, nlines
      integer    icode, icomm, icont
      character (len = lmax) codes(nmax), comm(nmax), cont(nmax),
     +                       final(nmax), line
      character (len = 1024) file1, file2
      character (len = 40  ) word40, trim40
      character (len = 6   ) word6
      character (len = 4   ) word4
      character (len = 1   ) amper, blank, exclam, letter
      parameter (amper = '&', blank = ' ', exclam = '!')
      character  error(10)*100
      logical    abort, free, repeet, start, there 
      external   adjust_line, inspec, type_required 
      external   ofiles, putfat, len200, lcase1, putadv, closer, trim40
     
      repeet = .true.
      do while (repeet)
         ierror = 1
         error(ierror) = 'ierror = 1: must have lmax >= 73'
c
c choose type required
c         
         call type_required (i)
         if (i.eq.1) then
            free = .true.
         elseif (i.eq.2) then
            free = .false.   
         else
            stop
         endif      
c
c first of all check nmax and lmax ... these errors should never occur
c                                  
         i = nmax
         if (i.lt.10000) call putadv ('Suggest nmax should be >= 10000')
         i = lmax
         if (i.lt.73) then
            call putfat (error(1))
            stop
         elseif (i.lt.132) then
            call putadv ('Suggest lmax should be >= 132')
         endif   
c
c part1: get a *.for or *.ins file and make a *.f95 filename
c =====
c
         call closer (nout)
         call ofiles (isend, nout, 
     +                file1,
     +                abort)
         call closer (nout)
         ierror = 2
         error(ierror) = 'ierror = 2: failure to open file'
         if (abort) goto 20
         l2 = len200(file1)
         ierror = 3
         error(ierror) = 'ierror = 3: filename too short'
         if (l2.lt.5) goto 20
         l1 = l2 - 3
         word4 = file1(l1:l2)
         call lcase1 (word4)
         ierror = 4
         error(ierror) = 'ierror = 4: not a *.for or *.ins file'
         if (word4.ne.'.for' .and. word4.ne.'.ins') goto 20
c
c a *.for or *.ins file has been located so copy file1 into file2
c and .for or .ins to .f95
c
         file2 = file1
         file2(l1:l2) = '.f95'
         inquire (file = file2, exist = there, iostat = ios)
         ierror = 5
         error(ierror) =
     +'ierror = 5: corresponding *.f95 file already exists'
         if (ios.eq.0 .and. there) goto 20
         icount = 0
         icode = 0
         icomm = 0
         icont = 0     
         line = blank
         do i = 1, nmax    
            comm(i) = line
            cont(i) = line
            final(i) = line  
         enddo   
         start = .false.
c
c part2: open file1 and read data
c ======
c
         open (unit = nout, file = file1, iostat = ios)
         ierror = 6
         error(ierror)  = 'ierror = 6: failure in open operation'
         if (ios.ne.0) goto 20
         ios = 0
         do while (ios.eq.0)
            read (nout,'(a)',iostat=ios) line 
            if (ios.eq.0) then 
               call inspec (line)
               icount = icount + 1
               letter = line(1:1)
c
c check column 1
c
               if (letter.eq.'C' .or.
     +             letter.eq.'c' .or.
     +             letter.eq.exclam) then
c
c a comment line has been identified by either a 'C', 'c' or '!'
c
                  itype(icount) = 1
                  line(1:1) = exclam
                  icomm = icomm + 1
                  comm(icomm) = line
               elseif (letter.ne.blank .and.
     +                 letter.ne.'0'   .and.
     +                 letter.ne.'1'   .and.
     +                 letter.ne.'2'   .and.
     +                 letter.ne.'3'   .and.
     +                 letter.ne.'4'   .and.
     +                 letter.ne.'5'   .and.
     +                 letter.ne.'6'   .and.
     +                 letter.ne.'7'   .and.
     +                 letter.ne.'8'   .and.
     +                 letter.ne.'9') then
c
c a comment line has been identified since not 0, 1, 2, 3, 4, 5, 6, 7, 8, 9
c
                  itype(icount) = 1
                  line(1:1) = exclam
                  icomm = icomm + 1
                  comm(icomm) = line
               else
c
c column 1 is a blank or 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 so now check column 6
c
                  letter = line(6:6)
                  if (letter.ne.blank) then
c
c a continuation line has been identified
c                                       
                     line(6:6) = amper
                     itype(icount) = 2
                     if (.not.start) then
                        start = .true.
                        codes(icode)(73:73) = amper
                     endif
                     icont = icont + 1
                     cont(icont) = line
                     cont(icont)(73:73) = amper
                  else
c
c a normal code line has been identified
c
                     itype(icount) = 0
                     icode = icode + 1
                     if (start)then
                        start = .false.
                        cont(icont)(73:73) = blank
                     endif
                     codes(icode) = line
                  endif
               endif
            endif
         enddo
c
c make sure the last continuation line does not end with an ampersand
c
         if (start) cont(icont)(73:73) = blank
         close (unit = nout)
         ierror = 7
         error(ierror)  = 'ierror = 7: nlines = 0'
         nlines = icount
         if (nlines.le.0) goto 20
c
c part 3: data has been read in OK so start to write the output data
c =======
c
         icode = 0
         icomm = 0
         icont = 0
         ierror = 8
         error(ierror)  = 'ierror = 8: failure in final open operation'
         do i = 1, nlines
            if (itype(i).eq.0) then
               icode = icode + 1
               final(i) = codes(icode)
            elseif (itype(i).eq.1) then
               icomm = icomm + 1
               final (i) = comm(icomm)
            else
               icont = icont + 1
               final(i) = cont(icont)
            endif
         enddo
         open (unit = nout, file = file2, iostat = ios)
         if (ios.ne.0) goto 20
         if (free) then
            do i = 1, nlines
               call adjust_line (lmax, 
     +                           final(i))
               write (nout,'(a)') final(i)
            enddo
         else   
            do i = 1, nlines
               write (nout,'(a)') final(i)
            enddo
         endif 
c
c all has gone well so set ierror = 0
c           
         ierror = 0
c
c label 20: crash point or normal exit
c =======+
c
   20    continue
         close (unit = nout)
         if (ierror.ne.0) then
            call putfat (error(ierror))
         else
            l1 = 1
            l2 = len200(file2)
            write (word6,'(i6)') nlines
            if (l2.le.40) then
               line = file2(l1:l2)//' created: nlines = '//word6
            else
               word40 = trim40(file2)
               line = word40//' created: nlines = '//word6
            endif     
            call putadv (line)
         endif
      enddo
      end
c
c---------------------------------------------------------------
c 
      subroutine adjust_line (lmax, 
     +                        line)
c
c adjust from fixed/free to free
c      
      implicit none  
c
c argument
c         
      integer,                intent (in)    :: lmax 
      character (len = lmax), intent (inout) :: line
c
c locals
c     
      integer    nstart, nstop
      character (len = 1) amper, blank, exclam, letter
      character (len = lmax) new_line
      parameter (amper = '&', blank = ' ', exclam = '!')
c
c check column 1
c      
      letter = line(1:1)
      if (letter.eq.exclam) return
c
c check column 6
c  
      letter = line(6:6) 
      if (letter.eq.amper) line(6:6) = blank
c
c check column 73
c   
      letter = line(73:73)
      if (letter.eq.amper) then
         nstart = len_trim(line(1:72)) 
         nstop = 73
         if (nstart.lt.nstop) then
            new_line = line(1:nstart)//blank//line(nstop:lmax)
            line = new_line
         endif  
      endif 
      end            
c
c---------------------------------------------------------------
c
      subroutine inspec (line)
c
c check for an exclamation mark used for comments 
c      
      implicit none
c
c argument 
c         
      character (len = *), intent (inout) :: line
c
c locals
c       
      integer    i, l, len200, n, n1, n2 
      character  exclam*1, letter*1, line1*264, quote1*1, quote2*1,
     +           piece*132, word66*66   
      character  blank*1
      parameter (blank = ' ')
      logical    start 
      external   len200
      intrinsic  char, index 
c
c check if there is an exclamation mark in the line of code
c                     
      exclam = char(33) 
      word66 = line(7:72)
      n = index(word66, exclam)
      if (n.le.0) return
      n = n + 6
c
c check if it is inside a character string
c                                      
      l = len200 (line) 
      quote1 = char(39)
      quote2 = char(34)   
      n1 = index(word66, quote1) 
      n2 = index(word66, quote2) 
      if (n1.gt.0 .or. n2.gt.0) then
c
c the substring has character variables
c      
         start = .false.
         n = 0
         i = 6
         do while (i.ge.6 .and. i.lt.l .and. n.eq.0)
            i = i + 1
            letter = line(i:i)
            if (letter.eq.quote1 .or. letter.eq.quote2) then
               start = .not.start
            elseif (letter.eq.exclam) then  
               if (.not.start) n = i
            endif
         enddo 
      endif  
      if (n.gt.0) then 
c
c the exclamation mark is not inside a character variable
c      
         line1 = line  
         n1 = 74
         n2 = l - n + 74
         piece = blank
         piece = line(n:l)
         line1(n1:n2) = piece
         do i = n, 73
            line1(i:i) = blank
         enddo 
         line = line1
      endif  
      end
c
c-------------------------------------------------
c
      subroutine type_required (itype)
      implicit none
c
c argument
c         
       integer, intent (out) :: itype
c
c locals
c
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 4, numsta = 12)
      integer    numbld(30)
      character (len = 80) text(30)
      logical    repeet 
      external   lstbox, patch2
      data       numbld / 30*0 / 
      itype = 3
      numdec = 3
      repeet = .true.
      do while (repeet)
         write (text,100)
         numtxt = numsta + numopt - 1 
         numbld(1) = 4
         numbld(6) = 1
         numbld(7) = 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)  
         numbld(1) = 4
         numbld(6) = 0
         numbld(7) = 0
         repeet = .false.
         itype = numdec
         if (numdec.eq.numopt - 1) then
            repeet = .true.
            numdec = numopt
            write (text,200)
            numbld(1) = 1
            numtxt = 21
            call patch2 (numbld, numtxt,
     +                   text)
            numbld(1) = 0            
         endif
      enddo             
  100 format (
     + 'Creating *.f95 files from *.for files'
     +/
     +/'This program reads in fixed format *.for source code'
     +/'files and creates *.f95 output in one of two formats:'
     +/
     +/'[free] i.e. Fortran95 style, or'
     +/'[both] i.e. the Fortran77 and Fortran95 style.'
     +/
     +/'It will not alter the original *.for file'        
     +/'It will not over-write an existing *.f95 file'        
     +/        
     +/'Output in [free] format'
     +/'Output in [both] format'
     +/'Help'        
     +/'Exit program for2f95')        
  200 format (
     + 'The program FOR2F95'  
     +/       
     +/'This program is specifically designed to handle source code'     
     +/'files writen in the strict Simfit style. It will not handle'       
     +/'Holleriths or a few other obsolete constructs found in some'       
     +/'obscure legacy programs.'       
     +/       
     +/'Simfit source code was written in fixed format because for a'       
     +/'long time is was checked by both FTN77 and FTN95 and uses BLAS,'       
     +/'LAPACK and other public domain code written in fixed format.'         
     +/'Another reason is that the numerical analysis code is based'        
     +/'on the NAG Fortran77 library calling conventions.'       
     +/       
     +/'There are many advantages in transforming fixed format code'       
     +/'into [both], i.e. fixed/free format, as it can then be compiled'      
     +/'by all Fortran compilers and, in particular, include directives'       
     +/'will be consistent when including [both] type files into [free]'
     +/       
     +/'Nevertheless, continuation ampersands in both columns 6 and 73,'       
     +/'restricting to columns 7 to 72, and other features of [both]'       
     +/'format are obsolete, so you may wish to select the [free] type')       
      end
c
c             
       