
C
C FTN95 version
C =============
C
C FTEST: MAIN, ADVISE, ARGUIN
C        CDFVAL, DETAIL, INVERT, PARAMS, PDFVAL, CDF, CDFINV, PDF
C
C
C     INCLUDE 'dllchk.for'
      PROGRAM MAIN
C
C VERSION : details from SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C NAG     : G01ED4, G01FDF, G04ADF, G04AEF, G08AEF, G08AFF, S14ABF, X02AMF
C INPUT   : Degrees of freedom, arguments, test statistics
C           or sums of squares
C OUTPUT  : PDF, CDF, ALPHA, Inverses for F distribution
C           Maps F's onto uniform (0, 1) then performs Kolmogorov
C           Smirnov and chi-square tests (? cells) for F d'bn.
C           Also performs F test on sums of squares.
C AUTHOR  : W. G. Bardsley, 18/4/85
C REVISED : 28/06/1990 Replaced NAG sorting and Kolmogorov-Smirnov
C           07/07/1990 (Re-named FTEST)
C           20/07/1990 Replaced S14AAE by S14ABF
C           11/02/1991 CHISQD, KSTEST, NXSORT, IAXOUT, TESTDC
C           11/03/1993 GET???, PUT??? and compressed
C           17/06/1993 RESFIL
C           31/08/1994 DBOS version 
C           01/02/1995 Added analysis of variance
C           13/11/1995 Split source and upgraded for nag mark 16 and
C                      also new argument LIBFIL added to call to VECFIL
C           16/12/1996 Transferred ANOVA routines to DLL
C           25/04/1997 win32 version ... COMMON used by functions only
C           07/08/1998 added dllchk
C           14/12/1998 replaced TUTORS by TUTOR1
C           09/08/1999 moved TESTFS to SIMFIT.DLL
C           13/09/1999 added call to WINDOW
C           20/12/1999 added call to NONCEN
C           12/02/2000 added call to SIMVER
C           28/03/2001 revised
C           21/09/2003 increased dimension of IWRK from NSMALL to 3*NRMAX,
C                      added A2 and A3 and new argument list for ANOVA0
C           28/07/2005 increased DVER to *30 and added to call to ADVISE
C           10/01/2006 deleted A2 and A3 from declaration and call to ANOVA0
C           16/01/2006 deleted B, C, X, Y, Z  from call to ANOVA0
C           03/04/2004 replaced ANOVA0 by M_ANOVA0
C           16/09/2007 edited for version 6 
C           05/07/2022 added E_NUMBERS and E_FORMATS and extensive revision and added X_DOFDOT      
C
      IMPLICIT   NONE
      INTEGER    NIN, NOUT4, NPAR
      PARAMETER (NIN = 3, NOUT4 = 4, NPAR = 8)
      INTEGER    ISEND, JSEND, NOUT, NTYPE, NZ
      DOUBLE PRECISION X02AMF$
      DOUBLE PRECISION EPOS, EXPON1, EXPON2, FACTOR, RATIO, RTOL
      DOUBLE PRECISION XVER, YVER
      DOUBLE PRECISION DBLE_M, DBLE_N, PAR(NPAR)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  FNAME*1024, TITLE*80
      CHARACTER  FNAMEZ*1024, TITLEZ*80
      CHARACTER  PTITLE*37
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_ftest.exe')
      CHARACTER  BLANK*1, PNAME*5
      PARAMETER (BLANK = ' ', PNAME = 'FTEST')
      LOGICAL    DANGER, NOPDF, OP
      LOGICAL    ABORT, ACTION, AGAIN, FIRST, SHOW
      EXTERNAL   X02AMF$
      EXTERNAL   RESFIL, FNAMES, PUTADV, M_ANOVA0, REVPRO,
     +           NONCEN, M_ONEVEC
      EXTERNAL   ADVISE, DETAIL, ARGUIN, PDFVAL, CDFVAL, INVERT, TESTFS
      EXTERNAL   DLLCHK, WINDOW, SIMVER
      INTRINSIC  LOG

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C Note ISEND = 2 since may be called from SIMSTAT which has already
C called WINDOW with ISEND = 1
C
      ISEND = 2
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

      FIRST = .TRUE.
      CALL ADVISE (DVER,
     +             ABORT, FIRST)
      IF (ABORT) THEN
         AGAIN = .FALSE.
      ELSE
         PTITLE = BLANK
         FNAME = BLANK
         NOUT = NOUT4
         CALL RESFIL (NOUT,
     +                FNAME,
     +                ABORT)
         IF (ABORT) THEN
            AGAIN = .FALSE.
         ELSE
            AGAIN = .TRUE.
            WRITE (NOUT,100)
            RTOL = 1.0D+09*X02AMF$()
            EPOS = - LOG(RTOL)
C
C First set M < 1 and N < 1 to make sure M and N are initialised
C
            DBLE_M = ZERO
            DBLE_N = ZERO
            NZ = 0
            FNAMEZ = BLANK
            TITLEZ = BLANK
         ENDIF
      ENDIF
C
C Main loop
C      
      DO WHILE (AGAIN)
         CALL DETAIL (ISEND,
     +                DBLE_M, DBLE_N, 
     +                PTITLE)
         IF (ISEND.EQ.1) THEN
C
C ISEND = 1: define parameters
C           
            CALL ARGUIN (NOUT, NPAR, 
     +                   DBLE_M, DBLE_N, EPOS, EXPON1, EXPON2, FACTOR,
     +                   PAR, RATIO, RTOL, 
     +                   PTITLE,
     +                   DANGER, NOPDF)
         ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: calculate pdf
C         
            CALL PDFVAL (NOUT, 
     +                   DBLE_M, DBLE_N, EPOS, EXPON1, EXPON2, FACTOR,
     +                   RATIO, RTOL, 
     +                   DANGER, NOPDF)
         ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: calculate cdf
C         
            CALL CDFVAL (NOUT,
     +                   DBLE_M, DBLE_N, RTOL)
         ELSEIF (ISEND.EQ.4) THEN
C
C ISEND = 4: invert
C         
            CALL INVERT (NOUT,
     +                   DBLE_M, DBLE_N)
         ELSEIF (ISEND.EQ.5) THEN
C
C ISEND = 5: test for F distribution
C         
            IF (DBLE_M.LE.ZERO .OR. DBLE_N.LE.ZERO) THEN
               CALL PUTADV ('First choose option 1 to input M and N')
            ELSE
               JSEND = 2
               CALL M_ONEVEC (JSEND, NIN, NOUT, NPAR, NZ,
     +                        PAR,
     +                        FNAMEZ, TITLEZ)                     
            ENDIF
         ELSEIF (ISEND.EQ.6) THEN
C
C ISEND = 6: F test on SSQ
C         
            CALL TESTFS (NOUT,
     +                   RTOL)
         ELSEIF (ISEND.EQ.7) THEN
C
C ISEND = 7: ANOVA
C         
            CALL M_ANOVA0 (NIN, NOUT)
         ELSEIF (ISEND.EQ.8) THEN
C
C ISEND = 8: non-central F
C         
            NTYPE = 4
            CALL NONCEN (NOUT, NTYPE)
         ELSEIF (ISEND.EQ.9) THEN
C
C ISEND = 9: help
C         
            FIRST = .FALSE.
            CALL ADVISE (DVER,
     +                   ABORT, FIRST)
         ELSEIF (ISEND.EQ.10) THEN
C
C ISEND = 10: results
C         
            CALL REVPRO (NOUT)
         ELSE
C
C ISEND = 11: quit
C           
            AGAIN = .FALSE.
            CLOSE (UNIT = NOUT)
            ISEND = 2
            CALL FNAMES (ISEND,
     +                   FNAME)
         ENDIF
      ENDDO

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 2
      ACTION = .FALSE.
      CALL WINDOW (ISEND, 
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      INQUIRE (UNIT = NOUT, OPENED = OP)
      IF (OP) CLOSE (UNIT = NOUT)
C
C Format statement
C
  100 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : FTEST'
     +/1X,'ACTION  : F test/distribution and ANOVA'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_FTEST
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_FTEST ('ftest')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `FTEST'
     +/'        `      '
     +/'Action  `The F(m,n) distribution. Supply m,n then calculate'
     +/'        `pdf/cdf/critical-values. Input data then test for'
     +/'        `F(m,n), F test or 1,2,3-way Analysis of Variance.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ARGUIN (NOUT, NPAR,
     +                   DBLE_M, DBLE_N, EPOS, EXPON1, EXPON2, FACTOR,
     +                   PAR, RATIO, RTOL, 
     +                   PTITLE, 
     +                   DANGER, NOPDF)
C
C Enter degrees of freedom M and N then calculate constants
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NOUT, NPAR
      DOUBLE PRECISION, INTENT (IN)    :: RTOL
      DOUBLE PRECISION, INTENT (INOUT) :: DBLE_M, DBLE_N, EPOS, EXPON1,
     +                                    EXPON2, FACTOR, PAR(NPAR),
     +                                    RATIO
C
C Locals
C     
      INTEGER    ISEND
      PARAMETER (ISEND = 0)
      INTEGER    NBIG, NCDF, NPDF, NTYPE, N0, N1
      PARAMETER (NBIG = 1000000, NCDF = 100, NPDF = 160, NTYPE = 3,
     +           N0 = 0, N1 = 1)
      INTEGER    LEN200, LM, LN
      INTEGER    IFAIL
      DOUBLE PRECISION XCDF(NCDF), XPDF(NPDF), YCDF(NCDF), YPDF(NPDF)
      DOUBLE PRECISION ZERO, EPSI, ONE, TWO, FIVE, XBIG
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-06, ONE = 1.0D+00, 
     +           TWO = 2.0D+00, FIVE = 5.0D+00)
      DOUBLE PRECISION ARG, GAMMA1, GAMMA2, GAMMA3, RMO2, RNO2, SUM1
      DOUBLE PRECISION A, B
      DOUBLE PRECISION S14ABF$
      CHARACTER (LEN = 1) CIPHER
      PARAMETER (CIPHER = 'L')
      CHARACTER  PTITLE*(*), VALUEM*10, VALUEN*10, XTITLE*1, YTITLE*17
      CHARACTER  NOTAT0*60, NOTPDF*30
      PARAMETER (
     +NOTAT0 = 'Singular case: pdf will only be approximate at F = 0',
     +NOTPDF = 'pdf cannot be calculated')
      LOGICAL    DANGER, NOPDF, YESNO
      EXTERNAL   GETDM1, PUTIFA, PUTADV, LEN200, GETL01
      EXTERNAL   PDFCDF
      EXTERNAL   S14ABF$
      EXTERNAL   X_DOFDOT
      INTRINSIC  LOG, EXP, DBLE
C
C Define the parameters
C      
      XBIG = ONE/RTOL
      IF (DBLE_M.LE.ZERO) DBLE_M = TWO
      A = EPSI
      B = DBLE(NBIG)  
      CALL GETDM1 (A, DBLE_M, B,
     +         'Degrees of freedom required for numerator')
      IF (DBLE_N.LE.ZERO) DBLE_N = FIVE
      CALL GETDM1 (A, DBLE_N, B,
     +         'Degrees of freedom required for denominator')
      IF (DBLE_M.LE.TWO) THEN
         DANGER = .TRUE.
      ELSE
         DANGER = .FALSE.
      ENDIF
      RMO2 = DBLE_M/TWO
      RNO2 = DBLE_N/TWO
      RATIO = RMO2/RNO2
      SUM1 = RMO2 + RNO2
      EXPON1 = RMO2 - ONE
      EXPON2 = - SUM1
      NOPDF = .FALSE.
      IFAIL = N1
      GAMMA1 = S14ABF$(RMO2, IFAIL)
      IF (IFAIL.NE.N0) THEN
         CALL PUTIFA (IFAIL, NOUT, 'S14ABF/ARGUIN')
         CALL PUTADV (NOTPDF)
         GAMMA1 = ONE
         NOPDF = .TRUE.
      ENDIF
      IFAIL = N1
      GAMMA2 = S14ABF$(RNO2, IFAIL)
      IF (IFAIL.NE.N0) THEN
         CALL PUTIFA (IFAIL, NOUT, 'S14ABF/ARGUIN')
         CALL PUTADV (NOTPDF)
         GAMMA2 = ONE
         NOPDF = .TRUE.
      ENDIF
      IFAIL = N1
      GAMMA3 = S14ABF$(SUM1, IFAIL)
      IF (IFAIL.NE.N0) THEN
         CALL PUTIFA (IFAIL, NOUT, 'S14ABF/ARGUIN')
         CALL PUTADV (NOTPDF)
         GAMMA3 = ONE
         NOPDF = .TRUE.
      ENDIF
      ARG = GAMMA3 - GAMMA1 - GAMMA2 + RMO2*LOG(RATIO)
      IF (ARG.GT.EPOS) THEN
         CALL PUTADV (NOTPDF)
         NOPDF = .TRUE.
      ENDIF
      FACTOR = EXP(ARG)
      IF (DANGER) THEN
         CALL PUTADV (NOTAT0)
         A = RTOL
      ELSE
         A = ZERO
      ENDIF
      B = XBIG
C
C Store the parameters
C      
      PAR(1) = DBLE_M
      PAR(2) = DBLE_N
      PAR(3) = EPOS
      PAR(4) = EXPON1
      PAR(5) = EXPON2
      PAR(6) = FACTOR
      PAR(7) = RATIO
      PAR(8) = RTOL
C
C Initialise PTITLE
C      
      WRITE (VALUEM,'(F10.2)') DBLE_M
      CALL X_DOFDOT (ISEND,
     +               CIPHER, VALUEM)
      WRITE (VALUEN,'(F10.2)') DBLE_N
      CALL X_DOFDOT (ISEND,
     +               CIPHER, VALUEN)  
      LM = LEN200 (VALUEM)
      LN = LEN200 (VALUEN)
      PTITLE =
     +'F distribution: m = '//VALUEM(N1:LM)//', n = '//VALUEN(N1:LN)
      IF (NOPDF) THEN
C
C Plot not allowed        
C
         RETURN
      ELSE
C
C Plot pdf and cdf
C           
         YESNO = .FALSE.
         CALL GETL01 ('Plot pdf(x)and cdf(x)',
     +                 YESNO) 
         IF (YESNO) THEN       
            XTITLE = 'x'
            YTITLE = 'cdf(x) and pdf(x)'
            CALL PDFCDF (NCDF, NOUT, NPAR, NPDF, NTYPE,
     +                   PAR, A, XCDF, XPDF, B, YCDF, YPDF,
     +                   PTITLE, XTITLE, YTITLE)
         ENDIF
      ENDIF
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE CDFVAL (NOUT,
     +                   DBLE_M, DBLE_N, RTOL)
C
C Evaluate CDF
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_M, DBLE_N, RTOL
C
C Locals
C      
      INTEGER    I, NFVALS
      INTEGER    KMAX, KMIN, K1, K2, K3
      PARAMETER (KMAX = 20, KMIN = 0, K1 = 1, K2 = 2, K3 = 3)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION ALPHA, BETA, F
      DOUBLE PRECISION CDF_F
      DOUBLE PRECISION ZERO, ONE, XBOT, XTOP, XTEMP(3)
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, XBOT = 0.0D+00)
      CHARACTER (LEN = 13) D13, SHOWRJ
      CHARACTER (LEN = 90) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   GETJM1, PUTADV, TABLE4
      EXTERNAL   PARAMS, CDF_F
      SAVE       NFVALS
      DATA       NFVALS / 1 /
      XTOP = ONE/RTOL
      IF (DBLE_M.LE.ZERO .OR. DBLE_N.LE.ZERO) THEN
         CALL PUTADV ('First choose option 1 to input M and N')
         RETURN
      ENDIF
      CALL GETJM1 (KMIN, NFVALS, KMAX,
     +            'Number of cdf(x) values required')
      IF (NFVALS.LT.K1) RETURN
      E_NUMBERS = E_FORMATS()
      CALL PARAMS (NOUT,
     +             DBLE_M, DBLE_N)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      XTEMP(K1) = XBOT
      XTEMP(K3) = XTOP
      DO I = K1, NFVALS
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETRL1')
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP,
     +                'x-value required for cdf(x)')
         F = XTEMP(K2)
         BETA = CDF_F (NOUT, 
     +                 DBLE_M, DBLE_N, F)
         ALPHA = ONE - BETA
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) F, BETA, ALPHA
            WRITE (NOUT,100) F, BETA, ALPHA
         ELSE
            D13 = SHOWRJ(F)  
            WRITE (LINE,150) D13, BETA, ALPHA
            WRITE (NOUT,150) D13, BETA, ALPHA
         ENDIF   
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statement
C
   50 FORMAT (13X,'x',8X,'cdf(x)',6X,'1-cdf(x)')    
  100 FORMAT (1X,1P,E13.5,2X,0P,F12.6,2X,F12.6)
  150 FORMAT (1X,A13,2X,F12.6,2X,F12.6)         
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE DETAIL (ISEND, 
     +                   DBLE_M, DBLE_N,
     +                   PTITLE)
C
C Decide option required
C
      IMPLICIT   NONE
C
C Arguments
C      
      
      INTEGER,             INTENT (INOUT) :: ISEND 
      DOUBLE PRECISION,    INTENT (IN)    :: DBLE_M, DBLE_N
      CHARACTER (LEN = *), INTENT (IN)    :: PTITLE
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT, N1
      PARAMETER (ICOLOR = 9, IX = 12, IY = 8, LSHADE = 1, NUMOPT = 11,
     +           NSTART = 3, NTEXT = 15, N1 = 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    ISAV
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01
      SAVE ISAV
      DATA ISAV / 9 /
      DATA NUMBLD / NTEXT*0 /
      DATA NUMPOS / NUMOPT*1 /
      WRITE (TEXT,100)
      IF (DBLE_M.GT.ZERO .AND. DBLE_N.GT.ZERO) THEN
         LINE = PTITLE
      ELSE
         WRITE (LINE,200)
      ENDIF
      TEXT(NTEXT) = LINE
      ISEND = ISAV
      NUMBLD(N1) = N1
      NUMBLD(NTEXT) = N1
      CALL LBOX01(ICOLOR, IX, IY, LSHADE, NUMBLD, ISEND, NUMOPT,
     +            NUMPOS, NSTART, NTEXT,
     +            TEXT, 
     +            BORDER, FLASH, HIGH)
      ISAV = ISEND
C
C Format statement
C      
  100 FORMAT (
     + 'Options for program FTEST'
     +/
     +/'Input: current parameters m and n'
     +/'Input: x-value then output pdf(x)'
     +/'Input: x-value then output cdf(x)'
     +/'Input: alpha then calculate x-critical'
     +/'Input: sample then test distributed F(m,n)'
     +/'Input: sums of squares then perform F test'
     +/'Do 1,2,3-way Analysis of Variance'
     +/'Calculate non-central F distribution values'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit program FTEST'
     +/)
  200 FORMAT ('F parameters m, n have not yet been initialised')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE INVERT (NOUT,
     +                   DBLE_M, DBLE_N)
C
C Invert F distribution
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_M, DBLE_N
C
C Locals
C      
      INTEGER    I, NPVALS
      INTEGER    KMAX, KMIN, K1, K2, K3
      PARAMETER (KMAX = 20, KMIN = 0, K1 = 1, K2 = 2, K3 = 3)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION ZERO, ONE, PCMAX, PCMIN, CENT
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, PCMAX = 99.99D+00,
     +           PCMIN = 0.01D+00, CENT = 100.0D+00)
      DOUBLE PRECISION ALPHA, BETA, CDFINV_F, FSTAT
      DOUBLE PRECISION PCENT
      DOUBLE PRECISION XTEMP(3)
      CHARACTER (LEN = 13) D13, SHOWRJ
      CHARACTER (LEN = 90) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   CDFINV_F
      EXTERNAL   GETJM1, PUTADV, TABLE4
      EXTERNAL   PARAMS
      SAVE       NPVALS
      DATA       NPVALS / 1 /
      IF (DBLE_M.LE.ZERO .OR. DBLE_N.LE.ZERO) THEN
         CALL PUTADV ('First choose option 1 to input M and N')
         RETURN
      ENDIF
      CALL GETJM1 (KMIN, NPVALS, KMAX,
     +            'Number of percentage points required')
      IF (NPVALS.LT.K1) RETURN
      E_NUMBERS = E_FORMATS()  
      CALL PARAMS (NOUT,
     +             DBLE_M, DBLE_N)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      XTEMP(K1) = PCMIN
      XTEMP(K3) = PCMAX
      DO I = K1, NPVALS
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETRL1')
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP,
     +               'Percentage point (i.e. 100*alpha) required')
         PCENT = XTEMP(K2)
         ALPHA = PCENT/CENT
         BETA = ONE - ALPHA
         FSTAT = CDFINV_F (NOUT,
     +                     DBLE_M, DBLE_N, BETA)
         IF (E_NUMBERS) THEN
           WRITE (LINE,100) FSTAT, BETA, ALPHA
           WRITE (NOUT,100) FSTAT, BETA, ALPHA
         ELSE 
            D13 = SHOWRJ(FSTAT) 
            WRITE (LINE,150) D13, BETA, ALPHA
            WRITE (NOUT,150) D13, BETA, ALPHA 
         ENDIF   
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statementS
C      
   50 FORMAT (13X,'x',10X,'beta',9X,'alpha')   
  100 FORMAT (1X,1P,E13.5,5X,0P,F9.6,5X,F9.6)
  150 FORMAT (1X,A13,5X,F9.6,5X,F9.6)       
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE PARAMS (NOUT,
     +                   DBLE_M, DBLE_N)
C
C Output current parameters to results file
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_M, DBLE_N
C
C Locals
C      
      INTEGER    ISEND
      PARAMETER (ISEND = 0)
      INTEGER    LEN200, LM, LN, L1
      PARAMETER (L1 = 1)
      CHARACTER (LEN = 1) CIPHER
      PARAMETER (CIPHER = 'L')
      CHARACTER (LEN = 10) VALUEM, VALUEN
      EXTERNAL   LEN200, X_DOFDOT
      WRITE (VALUEM,'(F10.2)') DBLE_M
      CALL X_DOFDOT (ISEND,
     +               CIPHER, VALUEM)
      WRITE (VALUEN,'(F10.2)') DBLE_N
      CALL X_DOFDOT (ISEND,
     +               CIPHER, VALUEN)
      LM = LEN200 (VALUEM)
      LN = LEN200 (VALUEN)
      WRITE (NOUT,100) VALUEM(L1:LM), VALUEN(L1:LN)
C
C Format statement
C      
  100 FORMAT ('Current F parameters: m = ',A,', n = ',A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE PDFVAL (NOUT,  
     +                   DBLE_M, DBLE_N, EPOS, EXPON1, EXPON2, FACTOR,
     +                   RATIO, RTOL, 
     +                   DANGER, NOPDF)
C
C Calculate PDF(F) given F
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_M, DBLE_N, EPOS, EXPON1,
     +                                 EXPON2, FACTOR, RATIO, RTOL
      LOGICAL,          INTENT (IN) :: DANGER, NOPDF
C
C Locals
C      
      INTEGER    I, NFVALS
      INTEGER    KMAX, KMIN, K1, K2, K3
      PARAMETER (KMAX = 20, KMIN = 0, K1 = 1, K2 = 2, K3 = 3)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION F, PDF_F, VALUE
      DOUBLE PRECISION ZERO, ONE, XBOT, XTOP, XTEMP(3)
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, XBOT = 0.0D+00)
      CHARACTER (LEN = 13) D13(2), SHOWRJ
      CHARACTER (LEN = 90) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PDF_F
      EXTERNAL   GETJM1, PUTADV, TABLE4
      EXTERNAL   PARAMS
      SAVE       NFVALS
      DATA       NFVALS / 1 /
      XTOP = ONE/RTOL
      IF (DBLE_M.LE.ZERO .OR. DBLE_N.LE.ZERO) THEN
         CALL PUTADV ('First choose option 1 to input M and N')
         RETURN
      ENDIF
      IF (NOPDF) THEN
         CALL PUTADV ('pdf cannot be calculated')
         RETURN
      ENDIF
      CALL GETJM1 (KMIN, NFVALS, KMAX,
     +            'Number of pdf(x) values required')
      IF (NFVALS.LT.K1) RETURN
      E_NUMBERS = E_FORMATS()
      CALL PARAMS (NOUT,
     +             DBLE_M, DBLE_N)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      XTEMP(K1) = XBOT
      XTEMP(K3) = XTOP
      DO I = K1, NFVALS
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETRL1')
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'x required for pdf(x)')
         F = XTEMP(K2)
         IF (DANGER .AND. F.LE.RTOL) F = RTOL
         VALUE = PDF_F (EPOS, EXPON1, EXPON2, FACTOR, RATIO, RTOL, F)
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) F, VALUE
            WRITE (NOUT,100) F, VALUE
         ELSE
            D13(1) = SHOWRJ(F)
            D13(2) = SHOWRJ(VALUE)  
            WRITE (LINE,150) D13(1), D13(2)
            WRITE (NOUT,150) D13(1), D13(2)
         ENDIF    
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statements
C  
   50 FORMAT (13X,'x',9X,'pdf(x)')
  100 FORMAT (1X,1P,E13.5,2X,E13.5)
  150 FORMAT (1X,A13,2X,A13)    
      END
C
C
