C
C GCFIT requires the following extra source files
C ===============================================
C
C GCFIT1.FOR: ADVISE, DATAIN, DSDT, FMOD, FJAC, THALF, THERR, GCFREV, GCFORD
C GCFIT2.FOR: DATFIT, DATOUT
C GCFIT3.FOR: DETAIL, GOFFIT, LMFUNC, LSFUN1, LSJAC1, SUMMIT
C
C These must be included now
C ==========================
C
C     INCLUDE 'gcfit1.for'
C     INCLUDE 'gcfit2.for'
C     INCLUDE 'gcfit3.for'
C     INCLUDE 'dllchk.for'
C

C------------------------------------------------------------------
C MODULE_GCFIT replaces the previous COMMOn blocks in GCFIT
C------------------------------------------------------------------

      MODULE MODULE_GCFIT
      
      IMPLICIT   NONE
      
      INTEGER    N0, N1, N10
      PARAMETER (N0 = 0, N1 = 1, N10 = 10)
      INTEGER    IOS, I_LENGTH, I_STATUS 
      INTEGER    NAUX, NMAX
      PARAMETER (NAUX = 3)
      INTEGER    ITIME
      DOUBLE PRECISION AUX(NAUX), ENEG, EPOS, EPSI, RTOL
      LOGICAL    GROWTH

      LOGICAL    AMPLITUDE_VARIED
      
      INTEGER    TIME_LENGTH 
      DOUBLE PRECISION TIME_SUM
      CHARACTER (LEN = 25) TIME_FORMAT
      LOGICAL    TIME_REVERSED
      
      INTEGER,             ALLOCATABLE :: IC(:) 
      DOUBLE PRECISION,    ALLOCATABLE :: A(:,:), P(:), W(:) 
      DOUBLE PRECISION,    ALLOCATABLE :: EN(:), SN(:), TN(:)
      DOUBLE PRECISION,    ALLOCATABLE :: ORD(:)
      
      CHARACTER (LEN = 4), ALLOCATABLE :: QUAL(:)
      LOGICAL,             ALLOCATABLE :: EQUAL(:)

      DATA AMPLITUDE_VARIED / .TRUE. /
      DATA TIME_LENGTH / 0 / 
      DATA TIME_SUM / 0.0D+00 /
      DATA TIME_FORMAT / '                        '/
      DATA TIME_REVERSED / .FALSE. /
      
      SAVE 

      END MODULE MODULE_GCFIT
      
C--------------------------------------------------------------------      
C
C
      PROGRAM MAIN
C
C VERSION        :  details from SIMVER/DLLCHK
C GROWTH MODELS  :  1. Exponential
C                   2. Monomolecular
C                   3. Logistic
C                   4. Gompertz
C                   5. Von Bertalannfy 2/3
C                   6. Logistic with constant term
C                   7. Gompertz with constant term
C                   8. Von Bertalannfy 2/3 with constatnt term
C                   9. Von Bertalannfy variable M (Richards)
C                  10. Preece and Baines (First model)
C SURVIVAL MODELS:  1. Exponential
C                   2. Weibull
C                   3. Gompertz
C                   4. Log-logistic
C ONE SAMPLE     : Kaplan-Meier/Weibull
C TWO SAMPLES    : Mantel-Haenszel (log-rank) test
C GLM OPTIONS    : Survival analysis
C
C ADVICE  : SIZE >= 0, TIME >= 0, ERROR > 0, Time points increasing
C           Start estimates for model 10 in DATFIT in internal coordinates
C           Set array dimension using parameter NMAX
C AUTHOR  : W. G. Bardsley, 30/5/89
C REVISED : 06/09/1989 To include Von Bertalannfy 2/3 and DS/DT
C           03/03/1991 Include Richards M and extensive use of W
C           20/03/1992 Corrected DI, DJ, etc., CHECKT, MIDDLE, REPEAT
C           24/03/1992 Swap from WSSQ to SSQ when ERRORS = 1, Plot DS/DT
C           05/05/1992 CORCOF and RSQUARED, 13/5/92 BIG and SMALL in DATAIN
C           15/06/1992 CHECKW, 22/6/92 minor changes
C           12/01/1993 GET???, PUT??? and compressed
C           16/06/1993 RESFIL
C           25/04/1994 DBOS version
C           20/02/1995 Salamanca version
C           30/10/1995 Split source code and upgraded to nag mark 16
C           16/04/1996 Added survival models
C           15/05/1996 Added Mantel Heinzel test etc. (subroutine SURVIV)
C           02/09/1997 win32 version ... replaced E04FDF/E0YCF by LMFIT1
C           21/03/1998 Added GOGOGO and NEW
C           07/08/1998 added dllchk
C           18/11/1998 added Shapiro-Wilks test on weighted resdiduals
C           14/12/1998 replaced TUTORS by TUTOR1
C           04/02/1999 added plot of (1/S)dS/dt
C           19/08/1999 revised control
C           13/09/1999 added call to WINDOW
C           12/02/2000 added call to SIMVER
C           08/09/2000 added THALF and THERR calculations for t-half
C           02/10/2000 added SBIG for asymptote plotting
C           28/03/2001 revised
C           20/05/2001 added call to PCVTST
C           02/05/2002 added call to LDLC50
C           12/07/2002 replaced call to LDLC50 by call to GLMINI
C           29/08/2002 added IWRK for call to GLMINI
C           28/07/2003 revised interface to survival analysis
C           28/07/2005 increased DVER to *30 and added to call to ADVISE
C           09/01/2006 deleted V in call to GLMINI
C           24/04/2006 replaced call to GLMINI by call to M_GLMINI
C           04/10/2007 added MODULE_GCFIT, removed COMMON and edited for version 6
C           11/03/2013 added options to reverse growth data if in size-descending  
C                      order and to fit an amplitude factor with survival models
C           13/09/2017 used just one call to TABLE1 for results and residuals
C                      and a revised version of subroutine DETAIL calling GET00X
C                      and GOFFIT calling GKSR04   
C           17/06/2021 introduced I, J, and ONE in order to initialise XSAV   
C

      USE MODULE_GCFIT
      
      IMPLICIT   NONE
      
      INTEGER    NGRAF, NOPT, NSURV, NX
      PARAMETER (NGRAF = 200, NOPT = 10, NSURV = 4, NX = 5)
      INTEGER    NCMAX
      PARAMETER (NCMAX = NX)
      INTEGER    MTYPE, NIN, NF
      PARAMETER (MTYPE = 1, NIN = 3, NF = 4)
      INTEGER    NLOOP, NRMAX
      INTEGER    IRANK, NBAD, NCOL, NDIST, NDOF, NFLY, NPAR, NPTS, NTYPE
      INTEGER    IERR, ISEND, ITEMP, LWRK
      INTEGER    I, J
      
      DOUBLE PRECISION TSIG(NX), TVAL(NX), XGRAF(NGRAF), XLOG(NGRAF),
     +                 YLOG(NGRAF)
      DOUBLE PRECISION CV(NCMAX,NCMAX), PARAM(NCMAX), STDERR(NCMAX),
     +                 X(NCMAX), XSAV(3:5,3)
      DOUBLE PRECISION DI, DJ, DT, SBIG, SI, SJ, SMAX, SZERO, TI, TJ,
     +                 TMAX, TMIN, WSSQ
      DOUBLE PRECISION AVRR, STATS(NOPT,9), YABS
      DOUBLE PRECISION X02AJF$, X02AMF$
      DOUBLE PRECISION XVER, YVER
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER (LEN = 100) COMMAND
      CHARACTER  FNAME1*1024, FNAME2*1024, TITLE*80
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_gcfit.exe')
      CHARACTER  BLANK, LETTER, PNAME*5
      PARAMETER (BLANK = ' ', PNAME = 'GCFIT')
      
      LOGICAL    AGAIN, ISTOP, NOUT(4), OMIT(NOPT), PLOT(3), WEIGHT
      LOGICAL    DOIT, FIRST, NEW, REPEET
      LOGICAL    ABORT, ACTION, SHOW
      LOGICAL    JUMP
   
      EXTERNAL  X02AMF$, X02AJF$
      EXTERNAL  GOGOGO, FNAMES, GOSTOP
      EXTERNAL  LMFUNC
      EXTERNAL  ADVISE, DATAIN, DETAIL, DATFIT, DATOUT, GOFFIT, SUMMIT,
     +          M_SURVIV, RESFIL, M_GLMINI, M_FITONE
      EXTERNAL  DLLCHK, WINDOW, SIMVER
      
      INTRINSIC LOG

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER, 
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C
C
C First check the command line to initialise ISEND and JUMP
C
      ITEMP = COMMAND_ARGUMENT_COUNT()  
      IF (ITEMP.EQ.N1) THEN
         CALL GET_COMMAND_ARGUMENT (N1, COMMAND, I_LENGTH, I_STATUS)
         IF (I_LENGTH.GE.N1 .AND. I_STATUS.EQ.N0) THEN
C
C 29/10/2023
C Replaced non-integer characters by blanks to interpret '0' as 0 which causes trouble otherwise
C It appears that 'i' is passed by run_program and returned as such by command argument 
C retrieval and read accurately except for '0' which is not read as 0 even if the quotes are 
C removed. Is it being read as a C string terminator ? So 0 is changed to 11 to call sv_simstat. 
C         
            do i = 1, i_length
               letter = command(i:i)
               j = ichar(letter)
               if (j.lt.48 .or. j.gt.57) command(i:i) = blank
            enddo  
             
            READ (COMMAND,*,IOSTAT=IOS) I
             
            IF (IOS.EQ.N0) THEN
               IF (I.GE.N1 .AND. I.LE.N10) THEN
                  ITEMP = I
               ELSE
                  ITEMP = N0
               ENDIF
            ELSE
               ITEMP = N0
            ENDIF
         ELSE
            ITEMP = N0
         ENDIF      
      ENDIF
      IF (ITEMP.EQ.N0) THEN
         JUMP = .FALSE.
      ELSE
         JUMP = .TRUE.
      ENDIF

C
C Initialise and define NTYPE and GROWTH
C
      FIRST = .TRUE.
      DO I = 3,5
         DO J = 1, 3
            XSAV(I,J) = ONE
         ENDDO  
      ENDDO   
      IF (JUMP) THEN
         NTYPE = N1
         ISTOP = .FALSE.
         FIRST = .TRUE.
      ELSE   
         CALL ADVISE (NTYPE,
     +                DVER,
     +                ISTOP, FIRST)
      ENDIF
      IF (ISTOP) THEN
         DOIT = .FALSE.
      ELSE
         NCOL = 0
         NPTS = 0
         DOIT = .TRUE.
         FNAME1 = BLANK
         FNAME2 = BLANK
         TITLE = BLANK
         RTOL = 1.0D+09*X02AMF$()
         ENEG = 0.25D+00*LOG(RTOL)
         EPOS = - ENEG/2.0D+00
         EPSI = X02AJF$()
         SBIG = - 1.0D+00
         NEW = .TRUE.
         DO ITIME = 1, NCMAX
            PARAM(ITIME) = - 1.0D+00
            STDERR(ITIME) = - 1.0D+00
            X(ITIME) = - 1.0D+00
         ENDDO
         DO ITIME = 1, NOPT
            OMIT(ITIME) = .TRUE.
         ENDDO
         NOUT(1) = .TRUE.
         NOUT(2) = .FALSE.
         NOUT(3) = .FALSE.
         NOUT(4) = .FALSE.
         PLOT(1) = .TRUE.
         PLOT(2) = .FALSE.
         PLOT(3) = .FALSE.
         IF (NTYPE.EQ.1) THEN
C
C NTYPE = 1: Fit growth curves (NTYPE = 1, GROWTH = .TRUE.)
C
            NLOOP = NOPT
            OMIT(1) = .FALSE.
            OMIT(2) = .FALSE.
            OMIT(3) = .FALSE.
            GROWTH = .TRUE.
         ELSEIF (NTYPE.EQ.2) THEN
C
C NTYPE = 2: Fit survival curves (NTYPE = 2, GROWTH = .FALSE.)
C
            NLOOP = NSURV
            OMIT(1) = .FALSE.
            OMIT(2) = .FALSE.
            GROWTH = .FALSE.
         ELSEIF (NTYPE.EQ.3) THEN
C
C NTYPE = 3: Analyse survival times (NTYPE = 3) then stop
C
            CALL RESFIL (NF,
     +                   FNAME2,
     +                   ISTOP)
            IF (.NOT.ISTOP) WRITE (NF,100)
            AGAIN = .TRUE.
            DO WHILE (AGAIN)  
               CALL M_SURVIV (NIN, NF)
               CALL GOSTOP (NF,
     +                      BLANK, FNAME2, PNAME,
     +                      ISTOP)
               IF (ISTOP) AGAIN = .FALSE.
            ENDDO                  
            CLOSE (UNIT = NF)
            ISEND = 2
            CALL FNAMES (ISEND,
     +                   FNAME2)            
            DOIT = .FALSE.
         ELSE
C
C NTYPE not 1, 2, or 3: Survival, Dose response and LD50 using GLM
C
            CALL RESFIL (NF,
     +                   FNAME2,
     +                   ISTOP)
            IF (.NOT.ISTOP) WRITE (NF,100)
            AGAIN = .TRUE.
            DO WHILE (AGAIN) 
               CALL M_GLMINI (MTYPE, NIN, NF)
               CALL GOSTOP (NF,
     +                      BLANK, FNAME2, PNAME,
     +                      ISTOP)
               IF (ISTOP) AGAIN = .FALSE.
            ENDDO                   
            CLOSE (UNIT = NF)
            ISEND = 2
            CALL FNAMES (ISEND,
     +                   FNAME2)             
            DOIT = .FALSE.
         ENDIF
      ENDIF
C
C NTYPE = 1 or 2: Main branch point for growth/survival curve fitting
C
      IF (DOIT) THEN
         REPEET = .TRUE.
         DO WHILE (REPEET)
            IF (NEW) THEN
               ISEND = NTYPE
               CALL M_FITONE (ISEND, NCOL, NIN, NPTS,
     +                        FNAME1, TITLE)
               IF (NPTS.GT.1 .AND. NCOL.GE.2 .AND. NCOL.LE.3) THEN
                  IERR = 0
                  IF (ALLOCATED(IC)) DEALLOCATE(IC, STAT = IERR)
                  IF (IERR.NE.0) EXIT 
                  IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(P)) DEALLOCATE(P, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
                  IF (IERR.NE.0) EXIT 
                  IF (ALLOCATED(EN)) DEALLOCATE(EN, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(SN)) DEALLOCATE(SN, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(TN)) DEALLOCATE(TN, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(QUAL)) DEALLOCATE(QUAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(EQUAL)) DEALLOCATE(EQUAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(ORD)) DEALLOCATE(ORD, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                    
                  NMAX = NPTS
                  NRMAX = NMAX
                  
                  ALLOCATE(IC(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(A(NMAX,5), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(P(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(EN(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(SN(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(TN(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT 
                  ALLOCATE(QUAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(EQUAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(ORD(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  
C
C The minimum workspace requirement is LWRK = 7*NMAX + NGRAF
C
                  LWRK = 10*NMAX + 2*NGRAF  
                  ALLOCATE(W(LWRK), STAT = IERR)
                  IF (IERR.NE.0) EXIT   
                                   
                  NEW = .FALSE.
                  
               ELSE
                  ISTOP = .TRUE.
               ENDIF   
            ENDIF  
            IF (ISTOP) THEN
               DOIT = .FALSE.
               FNAME1 = BLANK
            ELSE
C
C Data input phase ... Note that files are now read in using M_FITONE when NEW = .TRUE.
C              
               DOIT = .TRUE.
               NRMAX = NMAX
               CALL DATAIN (NDIST, NIN, NF, NMAX, NPTS, NTYPE,
     +                      DI, DJ, DT, EN, EPSI, RTOL, SI, SJ, SMAX,
     +                      SN, SZERO, TI, TJ, TMAX, TMIN, TN,
     +                      FNAME1, FNAME2,
     +                      EQUAL, GROWTH, ISTOP, JUMP, NEW, WEIGHT)
            ENDIF
            IF (DOIT) THEN
C
C Decide the type of analysis required
C              
               CALL DETAIL (NDIST, NGRAF, NOPT, NTYPE,
     +                      TMAX, TMIN, XGRAF,
     +                      GROWTH, ISTOP, NOUT, OMIT, PLOT)
               IF (ISTOP) THEN
                  DOIT = .FALSE.
               ELSE
                  DOIT = .TRUE.
               ENDIF
            ENDIF
            IF (DOIT) THEN
               DO ITIME = 1, NLOOP
C
C Fit the data set
C                 
                  CALL DATFIT (LMFUNC,
     +                         IC, IRANK, ITIME, LWRK, NCMAX, NDOF, NF,
     +                         NPAR, NPTS, NRMAX,
     +                         CV, DI, DJ, DT, ENEG, EPOS, A, P, PARAM,
     +                         RTOL, SI, SJ, SMAX, STDERR, SZERO, TI,
     +                         TJ, TMAX, W, WSSQ, X, XSAV,
     +                         GROWTH, OMIT)
C
C Output main results
C     
                  CALL DATOUT (ITIME, LWRK, NAUX, NBAD, NCMAX, NDOF, NF,
     +                         NFLY, NGRAF, NPAR, NPTS, NRMAX,
     +                         AUX, AVRR, CV, EN, EPSI, PARAM, RTOL,
     +                         SBIG, SMAX, SN, STDERR, TMAX, TN, TSIG,
     +                         TVAL, W, XGRAF, YABS, QUAL,
     +                         EQUAL, GROWTH, ISTOP, NOUT, OMIT, WEIGHT)
C
C Goodness of fit and graphics 
C     
                  CALL GOFFIT (ITIME, LWRK, NAUX, NBAD, NCMAX, NDOF, NF,
     +                         NFLY, NGRAF, NOPT, NPAR, NPTS, NTYPE,
     +                         AUX, AVRR, CV, PARAM, RTOL, SBIG, STATS,
     +                         W, WSSQ, XGRAF, XLOG, YABS, YLOG,
     +                         GROWTH, NOUT, OMIT, PLOT, WEIGHT)
               ENDDO
C
C Summary
C               
               IF (.NOT.ISTOP) CALL SUMMIT (NF, NOPT,
     +                                      STATS,
     +                                      OMIT, WEIGHT)
            ENDIF
C
C Another go ?
C
            CALL GOGOGO (NF,
     +                   FNAME1, FNAME2, PNAME,
     +                   ISTOP, NEW)
            IF (ISTOP) THEN
               REPEET = .FALSE.
            ELSE
               REPEET = .TRUE.
            ENDIF
         ENDDO
      ENDIF
C
C Terminate program
C

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE, 
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NF)
C
C Format statement
C
  100 FORMAT (
     +/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : GCFIT'
     +/1X,'ACTION  : Fit growth/decay/survival/GLM models'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
      END
C
C
