C
C
C GCFIT1.FOR
C ==========
C ADVISE
C DATAIN
C DSDT
C FMOD
C FJAC
C THALF
C THERR
C GCFREV
C GCFORD
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE ADVISE (NTYPE,
     +                   DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (INOUT) :: NTYPE
      CHARACTER (LEN = *), INTENT (IN)    :: DVER
      LOGICAL,             INTENT (IN)    :: FIRST
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    I, ISEND
      INTEGER    ICOLOR, NUMHDR, NUMHD9, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMHD9 = 9, NUMOPT = 5)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_GCFIT
      DATA       NUMBLD / NUMHDR*0 /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            OPTION(1) = 'Help           '
            OPTION(2) = 'Run the program'
            OPTION(3) = 'Quit  ...  Exit'
            ISEND = 1
            DO I = 1, NUMOPT
               NUMPOS(I) = 1
            ENDDO
            I = 3
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, I, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_GCFIT ('gcfit')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .TRUE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            WRITE (HEADER,200)
            OPTION(1) = 'Fit growth/decay curves'
            OPTION(2) = 'Fit survival curves'
            OPTION(3) = 'Analyse survival times'
            OPTION(4) = 'Use GLM techniques'
            OPTION(5) = 'Quit ... Exit GCFIT'
            DO I = 1, NUMOPT
               IF (I.LT.3) THEN
                  NUMPOS(I) = 5
               ELSE   
                  NUMPOS(I) = 1
               ENDIF   
            ENDDO
            NTYPE = 1
            CALL TITLES (ICOLOR, NUMBLD, NTYPE, NUMHD9, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
            IF (NTYPE.LE.4) THEN
               ABORT = .FALSE.
            ELSE
               ABORT = .TRUE.
            ENDIF
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      ' 
     +/'Program `GCFIT'
     +/'        `      ' 
     +/'Action  `Growth/decay/dose-response/survival curves, and'
     +/'        `censored survival times. Estimates t-half, LD50,'
     +/'        `and statistics to select the best fit model.'
     +/'        `      ' 
     +/'Version `',A
     +/'        `      ' 
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      ' 
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
  200 FORMAT (
     + 'This program can be run in one of four distinct modes.'
     +/
     +/'Mode 1:`Fit growth models to increasing data (or else'
     +/'       `decreasing data by reversing the time order)'
     +/'Mode 2:`Fit survival models for decreasing proportions'
     +/'       `or decay as a function of time.'
     +/'Mode 3:`Perform survival analysis on censored data.'
     +/'Mode 4:`Estimate EC50, LD50 etc. using GLM techniques'
     +/'       `Choose the mode required for this run.')
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE DATAIN (NDIST, NIN, NF, NMAX, NPTS, NTYPE,
     +                   DI, DJ, DT, EN, EPSI, RTOL, SI, SJ, SMAX, SN,
     +                   SZERO, TI, TJ, TMAX, TMIN, TN,
     +                   FNAME1, FNAME2,
     +                   EQUAL, GROWTH, ISTOP, JUMP, NEW, WEIGHT)
      USE MODULE_GCFIT, ONLY : ORD, TIME_FORMAT, TIME_LENGTH, TIME_SUM,
     +                         TIME_REVERSED, AMPLITUDE_VARIED 
C
C Read-in/check data, SMAX and TMAX then normalise TN, SN
C and EN, calculate SI, SJ, TI, TJ and DT for starting estimates in DATFIT
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NIN, NF, NMAX, NTYPE
      INTEGER,             INTENT (OUT)   :: NDIST, NPTS
      DOUBLE PRECISION,    INTENT (IN)    :: EPSI, RTOL
      DOUBLE PRECISION,    INTENT (OUT)   :: DI, DJ, DT, EN(NMAX), SI,
     +                                       SJ, SMAX, SN(NMAX), SZERO,
     +                                       TI, TJ, TMAX, TMIN,
     +                                       TN(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME1, FNAME2
      LOGICAL,             INTENT (IN)    :: GROWTH, JUMP, NEW
      LOGICAL,             INTENT (OUT)   :: EQUAL(NMAX), ISTOP, WEIGHT
C
C Locals
C      
      INTEGER    I, NHIGH, NLOW, NUMBER
      INTEGER    ISEND
      PARAMETER (ISEND = 1)
      DOUBLE PRECISION BIG, SMALL
      PARAMETER (SMALL = 0.075D+00, BIG = 1.0D+00 - SMALL)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION SABS, SMIN, THIGH, TLOW, WMIN, WMAX
      CHARACTER (LEN = 100) LINE
      CHARACTER (LEN = 80 ) TRIM80, WORD80, TITLE 
      CHARACTER (LEN = 25 ) FORM25
      EXTERNAL   PUTFAT, PUTWAR, PUTADV, GCFREV
      EXTERNAL   DATFIL, DATCHK, RESFIL, DATSXY, TRIM80, FORM25
      INTRINSIC  ABS, MAX, MIN, DBLE, LEN_TRIM
      SAVE       NUMBER
      DATA       NUMBER / 0 /
      WMIN = ONE - EPSI
      WMAX = ONE + EPSI
C
C Read in and check data
C
      IF (NEW) THEN
         CLOSE (UNIT = NIN)
         CALL DATFIL (NIN, NMAX, NPTS,
     +                EN, TN, SN, 
     +                FNAME1, TITLE,
     +                ISTOP)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ELSE
         CLOSE (UNIT = NIN)
         CALL DATSXY (NIN, NMAX, NPTS,
     +                EN, TN, SN,
     +                FNAME1, TITLE,
     +                ISTOP)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ENDIF
      CALL DATCHK (NPTS,
     +             EN, TN, SN, 
     +             ISTOP)
      IF (ISTOP) RETURN
C
C Further checks on input data, calculate NDIST and EQUAL
C
      NDIST = 1
      SABS = MAX(RTOL, ABS(SN(1)))
      SMAX = SABS
      SMIN = SABS
      TMAX = TN(1)
      TMIN = TN(1)
      EQUAL(1) = .FALSE.
      DO I = 2, NPTS
         SABS = ABS(SN(I))
         IF (SABS.GT.SMAX) SMAX = SABS
         IF (SABS.LT.SMIN) SMIN = SABS
         IF (TN(I).GT.TMAX) TMAX = TN(I)
         IF (TN(I).LT.TMIN) TMIN = TN(I) 
         IF (TN(I).GT.TN(I - 1) .OR. TN(I).LT.TN(I - 1)) THEN
            NDIST = NDIST + 1
            EQUAL(I) = .FALSE.
         ELSE
            EQUAL(I) = .TRUE.
         ENDIF
      ENDDO
      IF (TMIN.LT.ZERO) THEN
         CALL PUTFAT ('Time must be nonnegative')
         ISTOP = .TRUE.
         RETURN
      ENDIF   
      IF (SMIN.LT.ZERO) THEN
         CALL PUTFAT ('Size or proportion must be nonnegative')
         ISTOP = .TRUE.
         RETURN
      ENDIF   
      IF (NDIST.LT.3) THEN
         CALL PUTFAT ('Must be at least 3 distinct t-values')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      
      TIME_REVERSED = .FALSE.
      TIME_SUM = TN(1) + TN(NPTS)
           
      IF (GROWTH) THEN
         IF (SN(1).GT.SN(NPTS)) THEN
            DO I = 1, NPTS
               ORD(I) = DBLE(I)
            ENDDO 
            TIME_REVERSED = .TRUE.
            CALL GCFREV (ISEND, NPTS,
     +                   EN, ORD, TN, TIME_SUM, SN,
     +                   ISTOP)
            TIME_FORMAT = FORM25(TIME_SUM)
            TIME_LENGTH = LEN_TRIM(TIME_FORMAT)
            IF (ISTOP) RETURN 
            CALL PUTADV (
     +'First size > last size ... Data set reversed (see gcfit.tf7)')    
         ENDIF        
      ENDIF  
         
C
C Special action if fitting survival curves (NTYPE = 2)
C
      IF (NTYPE.EQ.2) THEN
         IF (SMAX.GT.ONE .AND. .NOT.AMPLITUDE_VARIED) THEN
            CALL PUTFAT (
     +'Must have proportion =< 1 ... choose to vary the amplitude')
            ISTOP = .TRUE.
            RETURN
         ENDIF
      ENDIF
C
C Use SMAX and TMAX to normalise data so that 0 =< SN =< 1, 0 =< TN =< 1
C
      WEIGHT = .FALSE.
      DO I = 1, NPTS
         IF (.NOT.WEIGHT) THEN
            IF (EN(I).LT.WMIN .OR. EN(I).GT.WMAX) WEIGHT = .TRUE.
         ENDIF
         EN(I) = EN(I)/SMAX
         SN(I) = SN(I)/SMAX
         TN(I) = TN(I)/TMAX
         IF (EN(I).LT.RTOL .OR. SN(I).LT.ZERO .OR. TN(I).LT.ZERO) THEN
            WRITE (LINE,100) I
            CALL PUTFAT (LINE)
            ISTOP = .TRUE.
            RETURN
         ENDIF
      ENDDO
C
C Now find two extreme mean points SI, SJ, TI, TJ to be used by DATFIT
C if growth curves are being fitted (NTYPE = 1)
C
      IF (GROWTH) THEN
         NHIGH = 0
         NLOW = 0
         SI = ZERO
         SJ = ZERO
         TI = ZERO
         TJ = ZERO
         THIGH = TN(NPTS) - 0.15D+00*(TN(NPTS) - TN(1))
         TLOW = TN(1) + 0.15D+00*(TN(NPTS) - TN(1))
         DO I = 1, NPTS
            IF (TN(I).GE.THIGH) THEN
               NHIGH = NHIGH + 1
               SJ = SJ + SN(I)
               TJ = TJ + TN(I)
            ENDIF
            IF (TN(I).LE.TLOW) THEN
               NLOW = NLOW + 1
               SI = SI + SN(I)
               TI = TI + TN(I)
            ENDIF
         ENDDO
         SI = MAX(SMALL, SI/NLOW)
         SJ = MIN(BIG, SJ/NHIGH)
         TI = MAX(SMALL, TI/NLOW)
         TJ = MIN(BIG, TJ/NHIGH)
         IF ((SI + SMALL).GE.SJ .OR. (TI + SMALL).GE.TJ) THEN
            CALL PUTWAR ('Bad data ... Poor starting estimates')
            SI = 0.15D+00
            SJ = 0.85D+00
            TI = 0.15D+00
            TJ = 0.85D+00
         ENDIF
         DI = ONE - SI/1.25D+00
         DJ = ONE - SJ/1.25D+00
         DT = TJ - TI
         SZERO = MAX(SMIN/SMAX, EPSI)
         IF (SZERO.GT.0.5D+00) THEN
            CALL PUTWAR ('Bad data ... Curve may be ill-defined')
         ENDIF
      ENDIF
C
C Open output file for results and write out program declaration
C
      IF (NUMBER.EQ.0) THEN
         CALL RESFIL (NF, FNAME2, ISTOP)
         IF (ISTOP) RETURN
         IF (JUMP) THEN
            WRITE (NF,150)
         ELSE    
            WRITE (NF,200)
         ENDIF   
      ENDIF
      NUMBER = NUMBER + 1
      WORD80 = TRIM80(FNAME1)
      WRITE (NF,300) NUMBER, WORD80, TITLE
C
C Warn if necessary
C
      IF (GROWTH) THEN
         IF (SN(1).GT.SN(NPTS)) CALL PUTWAR (
     +'Growth data should really be an increasing function of time')
      ELSE
         IF (SN(1).LT.SN(NPTS)) CALL PUTWAR (
     +'Survival data should really be a decreasing function of time')
      ENDIF
C
C Format statements
C      
  100 FORMAT ('S or t < 0 at data point',I6)
  150 FORMAT (/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : SV_GCFIT'
     +/1X,'ACTION  : Fit growth models'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  200 FORMAT (/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : GCFIT'
     +/1X,'ACTION  : Fit growth/decay/survival/GLM models'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  300 FORMAT (/1X,'Analysis number',I4/1X,'==================='
     +/1X,'File name'/1X,A/1X,'Data title'/1X,A)
      END
C
C-----------------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION DSDT(K,
     +                               P, S, T)
C
C Function for DS/DT ... Use Z = S so S is unchanged in main program
C 13/03/2013 K = NPAR is increased in survival models if the amplitude is varied
C

      USE MODULE_GCFIT, ONLY : ITIME, ENEG, EPOS, EPSI, RTOL, GROWTH
      
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: K
      DOUBLE PRECISION, INTENT (IN) :: P(K), S, T
C
C Locals
C      
      DOUBLE PRECISION ZERO, TWOTHD, ONE
      PARAMETER (ZERO = 0.0D+00, TWOTHD = 2.0D+00/3.0D+00,
     +           ONE = 1.0D+00)
      DOUBLE PRECISION ARG0, ARG1, HT, H1, SUMD, SUMN, S0, S1,
     +                 TEMP, TH
      DOUBLE PRECISION BOT, TOP
      DOUBLE PRECISION T0, T1, Z
      EXTERNAL         MIDDLE
      INTRINSIC        ABS, EXP, LOG
C
C Set DSDT = 0 and Z = S, T is unchanged by this subroutine
C
      DSDT = ZERO
      Z = S
C
C Branch to appropriate model
C
      IF (ITIME.EQ.1) THEN
         GOTO 10
      ELSEIF (ITIME.EQ.2) THEN
         GOTO 20
      ELSEIF (ITIME.EQ.3) THEN
         GOTO 30
      ELSEIF (ITIME.EQ.4) THEN
         GOTO 40
      ELSEIF (ITIME.EQ.5) THEN
         GOTO 50
      ELSEIF (ITIME.EQ.6) THEN
         GOTO 60
      ELSEIF (ITIME.EQ.7) THEN
         GOTO 70
      ELSEIF (ITIME.EQ.8) THEN
         GOTO 80
      ELSEIF (ITIME.EQ.9) THEN
         GOTO 90
      ELSEIF (ITIME.EQ.10) THEN
         GOTO 100
      ENDIF
   10 CONTINUE
      IF (GROWTH) THEN
         DSDT = P(2)*Z
      ELSE
         ARG0 = - P(1)*Z
         CALL MIDDLE (ENEG, ARG0, EPOS)
         DSDT = - P(1)*EXP(ARG0)
         IF (K.EQ.2) DSDT = P(2)*DSDT
      ENDIF
      RETURN
   20 CONTINUE
      IF (GROWTH) THEN
         DSDT = P(3)*(P(1) - Z)
      ELSE
         TEMP = P(1)*T
         IF (TEMP.LT.ZERO) RETURN
         ARG0 = - TEMP**P(2)
         CALL MIDDLE (ENEG, ARG0, EPOS)
         DSDT = - P(1)*P(2)*EXP(ARG0)*TEMP**(P(2) - ONE)
         IF (K.EQ.3) DSDT = P(3)*DSDT     
      ENDIF
      RETURN
   30 CONTINUE
      IF (GROWTH) THEN
         IF (P(1).LT.RTOL) RETURN
         DSDT = P(3)*Z*(P(1) - Z)/P(1)
      ELSE
         IF (P(1).LT.RTOL) RETURN
         ARG0 = P(1)*T
         CALL MIDDLE (ENEG, ARG0, EPOS)
         ARG1 = - P(2)*(EXP(ARG0) - ONE)/P(1)
         CALL MIDDLE (ENEG, ARG1, EPOS)
         DSDT = - P(2)*EXP(ARG0)*EXP(ARG1)
         IF (K.EQ.3) DSDT = P(3)*DSDT
      ENDIF
      RETURN
   40 CONTINUE
      IF (GROWTH) THEN
         IF (P(1).LT.RTOL .OR. Z.LT.RTOL) RETURN
         DSDT = P(3)*Z*(LOG(P(1)) - LOG(Z))
      ELSE
         TEMP = P(1)*T
         IF (TEMP.LT.ZERO) RETURN
         TOP = - P(1)*P(2)*TEMP*(P(2) - ONE)
         BOT = (ONE + TEMP**P(2))**2
         DSDT = TOP/BOT
         IF (K.EQ.3) DSDT = P(3)*DSDT
      ENDIF
      RETURN
   50 CONTINUE
      IF (Z.LT.RTOL) RETURN
      DSDT = P(1)*(Z**TWOTHD) - P(2)*Z
      RETURN
   60 CONTINUE
      Z = Z - P(4)
      GOTO 30
   70 CONTINUE
      Z = Z - P(4)
      GOTO 40
   80 CONTINUE
      Z = Z - P(4)
      GOTO 50
   90 CONTINUE
      IF (Z.LT.RTOL .AND. P(4).LT.ZERO) RETURN
      ARG0 = ONE - P(4)
      IF (ABS(ARG0).LE.EPSI) THEN
         IF (ARG0.LE.0) THEN
            ARG0 = - EPSI
         ELSE
            ARG0 = EPSI
         ENDIF
      ENDIF
      ARG1 = - P(3)*T
      CALL MIDDLE (ENEG, ARG1, EPOS)
      IF (ARG0.LT.ZERO) THEN
         TEMP = - ABS(P(2))
      ELSE
         TEMP = ABS(P(2))
      ENDIF
      DSDT = P(3)*(Z**P(4))*TEMP*EXP(ARG1)/ARG0
      RETURN
  100 CONTINUE
      H1 = P(1)
      HT = P(2)
      S0 = P(3)
      S1 = P(4)
      TH = P(5)
      ARG0 = S0*(T - TH)
      IF (ARG0.LT.ENEG) ARG0 = ENEG
      IF (ARG0.GT.EPOS) RETURN
      ARG1 = S1*(T - TH)
      IF (ARG1.LT.ENEG) ARG1 = ENEG
      IF (ARG1.GT.EPOS) RETURN
      T0 = EXP(ARG0)
      T1 = EXP(ARG1)
      SUMN = S0*T0 + S1*T1
      SUMD = T0 + T1
      IF (SUMD.LT.RTOL) RETURN
      TEMP = SUMN/SUMD
      TEMP = 2.0D+00*(H1 - HT)*TEMP
      DSDT = TEMP/SUMD
      END
C
C-----------------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION FMOD(K, L,
     +                               P, Q, Z)
C
C Function for LSFUN1 ... Z is Time T in this subroutine
C 13/03/2013 K = NPAR is increased in survival models if the amplitude is varied
C
      
      USE MODULE_GCFIT, ONLY : ITIME, ENEG, EPOS, RTOL, GROWTH
      
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: K, L
      DOUBLE PRECISION, INTENT (IN) :: P(K), Q(L), Z
C
C Locals
C      
      DOUBLE PRECISION ARG, BOT, TEMP, TOP, ZDIFF
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      INTRINSIC  MAX
      EXTERNAL   MIDDLE
      INTRINSIC  EXP
      IF (ITIME.EQ.1) THEN
         IF (GROWTH) THEN
C
C p(1)exp[p(2)t]
C
            ARG = P(2)*Z
            CALL MIDDLE (ENEG, ARG, EPOS)
            FMOD = P(1)*EXP(ARG)
         ELSE
C
C exp[ - p(1)t ]
C
            ARG = - P(1)*Z
            CALL MIDDLE (ENEG, ARG, EPOS)
            FMOD = EXP(ARG)
            IF (K.EQ.2) FMOD = P(2)*FMOD
         ENDIF
      ELSEIF (ITIME.EQ.2) THEN
         IF (GROWTH) THEN
C
C p(1){1 - p(2)exp[-p(3)t]}
C
            ARG = - P(3)*Z
            CALL MIDDLE (ENEG, ARG, EPOS)
            FMOD = P(1)*(ONE - P(2)*EXP(ARG))
         ELSE
C
C exp{ - [p(1)t]^p(2) }
C
            TEMP = P(1)*Z
            IF (TEMP.GE.RTOL) THEN
               ARG = - TEMP**P(2)
               CALL MIDDLE (ENEG, ARG, EPOS)
               FMOD = EXP(ARG)
            ELSE
               FMOD = ONE
            ENDIF
            IF (K.EQ.3) FMOD = P(3)*FMOD
         ENDIF
      ELSEIF (ITIME.EQ.3 .OR. ITIME.EQ.6) THEN
         IF (GROWTH) THEN
C
C p(1)/{1 + p(2)exp[-p(3)t]} + p(4)
C
            ARG = - P(3)*Z
            CALL MIDDLE (ENEG, ARG, EPOS)
            BOT = MAX(RTOL, ONE + P(2)*EXP(ARG))
            FMOD = P(1)/BOT
            IF (ITIME.EQ.6) FMOD = FMOD + P(4)
         ELSE
C
C exp{ -p(2)/p(1)[ exp{p(1)t} - 1 ]}
C
            ARG = P(1)*Z
            CALL MIDDLE (ENEG, ARG, EPOS)
            TEMP = - P(2)*(EXP(ARG) - ONE)/MAX(RTOL, P(1))
            CALL MIDDLE (ENEG, TEMP, EPOS)
            FMOD = EXP(TEMP)
            IF (K.EQ.3) FMOD = P(3)*FMOD
         ENDIF
      ELSEIF (ITIME.EQ.4 .OR. ITIME.EQ.7) THEN
         IF (GROWTH) THEN
C
C p(1)exp{ - p(2)exp[ - p(3)t ] }
C
            ARG = - P(3)*Z
            CALL MIDDLE (ENEG, ARG, EPOS)
            TEMP = EXP(ARG)
            ARG = - P(2)*TEMP
            CALL MIDDLE (ENEG, ARG, EPOS)
            FMOD = P(1)*EXP(ARG)
            IF (ITIME.EQ.7) FMOD = FMOD + P(4)
         ELSE
C
C 1/{ 1 + (p(1)t)^p(2) }
C
            TEMP = P(1)*Z
            IF (TEMP.GE.RTOL) THEN
               FMOD = ONE/(ONE + TEMP**P(2))
            ELSE
               FMOD = ONE
            ENDIF
            IF (K.EQ.3) FMOD = P(3)*FMOD
         ENDIF
      ELSEIF (ITIME.EQ.5 .OR. ITIME.EQ.8) THEN
C
C {p(1)/p(2) - [p(1)/p(2) - p(3)^(1/3)]exp[ -p(2)t/3 ]}^3
C
         ARG = - Q(3)*Z
         CALL MIDDLE (ENEG, ARG, EPOS)
         FMOD = (Q(1) - Q(2)*EXP(ARG))**3
         IF (ITIME.EQ.8) FMOD = FMOD + P(4)
      ELSEIF (ITIME.EQ.9) THEN
C
C {p(1)^[1 - p(4)] - p(2)exp[ - p(3)t ]}^[1/(1 - p(4))]
C
         ARG = - P(3)*Z
         CALL MIDDLE (ENEG, ARG, EPOS)
         ZDIFF = Q(1) - Q(2)*EXP(ARG)
         IF (ZDIFF.LE.RTOL) THEN
            FMOD = ZERO
         ELSE
            FMOD = ZDIFF**Q(3)
         ENDIF
      ELSEIF (ITIME.EQ.10) THEN
C
C p(1) - 2[p(1) - p(2)]/{exp[p(3)(t - p(5))] + exp[p(4)(t - p(5))]
C
         ZDIFF = Z - P(5)
         ARG = P(3)*ZDIFF
         CALL MIDDLE (ENEG, ARG, EPOS)
         BOT = EXP(ARG)
         ARG = P(4)*ZDIFF
         CALL MIDDLE (ENEG, ARG, EPOS)
         BOT = BOT + EXP(ARG)
         TOP = TWO*(P(1) - P(2))
         FMOD = P(1) - TOP/MAX(RTOL, BOT)
      ENDIF
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE FJAC (K, L,
     +                 P, Q, Z, ZJAC)
C
C Subroutine for LSJAC1 ... Z is Time T in this subroutine
C                       ... ZJAC are jacobian elements
C 13/03/2013 K = NPAR is increased in survival models if the amplitude is varied
C
      
      USE MODULE_GCFIT, ONLY : ITIME, ENEG, EPOS, RTOL, GROWTH 
      
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: K, L
      DOUBLE PRECISION, INTENT (IN)  :: P(K), Q(L), Z 
      DOUBLE PRECISION, INTENT (OUT) :: ZJAC(*)
C
C locals
C      
      DOUBLE PRECISION ARG, BOT, BOT2, DUMMY, FMOD, PDIFF, P1, P2, TEMP,
     +                 ZDIFF
      DOUBLE PRECISION ANSWER, E3, E4, RESUL
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, POWER
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, POWER = - TWO/THREE)
      EXTERNAL   MIDDLE
      INTRINSIC  ABS, EXP, LOG, MAX
      IF (ITIME.EQ.1) THEN
         IF (GROWTH) THEN
            ARG = P(2)*Z
            CALL MIDDLE (ENEG, ARG, EPOS)
            RESUL = EXP(ARG)
            ZJAC(1) = RESUL
            ZJAC(2) = P(1)*Z*RESUL
         ELSE
            ARG = - P(1)*Z
            CALL MIDDLE (ENEG, ARG, EPOS)
            FMOD = EXP(ARG)
            ZJAC(1) = - Z*FMOD
            IF (K.EQ.2) THEN
              ZJAC(1) = P(2)*ZJAC(1)
              ZJAC(2) = FMOD
            ENDIF    
         ENDIF
      ELSEIF (ITIME.EQ.2) THEN
         IF (GROWTH) THEN
            ARG = - P(3)*Z
            CALL MIDDLE (ENEG, ARG, EPOS)
            RESUL = EXP(ARG)
            ZJAC(1) = ONE - P(2)*RESUL
            ZJAC(2) = - P(1)*RESUL
            ZJAC(3) = P(1)*P(2)*Z*RESUL
         ELSE
            TEMP = P(1)*Z
            IF (TEMP.GE.RTOL) THEN
               ARG = - TEMP**P(2)
               CALL MIDDLE (ENEG, ARG, EPOS)
               RESUL = EXP(ARG)
               ZJAC(1) = - RESUL*Z**P(2)*P(2)*P(1)**(P(2) - ONE)
               ZJAC(2) = RESUL*LOG(TEMP)*ARG
            ELSE
               ZJAC(1) = ZERO
               ZJAC(2) = ZERO
            ENDIF
            IF (K.EQ.3) THEN
               ZJAC(1) = P(3)*ZJAC(1)
               ZJAC(2) = P(3)*ZJAC(2)
               TEMP = P(1)*Z
               IF (TEMP.GE.RTOL) THEN
                  ARG = - TEMP**P(2)
                  CALL MIDDLE (ENEG, ARG, EPOS)
                  FMOD = EXP(ARG)
               ELSE
                  FMOD = ONE
               ENDIF
               ZJAC(3) = FMOD
            ENDIF   
         ENDIF
      ELSEIF (ITIME.EQ.3 .OR. ITIME.EQ.6) THEN
         IF (GROWTH) THEN
            ARG = - P(3)*Z
            CALL MIDDLE (ENEG, ARG, EPOS)
            RESUL = EXP(ARG)
            BOT = MAX(RTOL, ONE + P(2)*RESUL)
            BOT2 = MAX(RTOL, BOT*BOT)
            ZJAC(1) = ONE/BOT
            ZJAC(2) = - P(1)*RESUL/BOT2
            ZJAC(3) = - P(2)*Z*ZJAC(2)
            IF (ITIME.EQ.6) ZJAC(4) = ONE
         ELSE
            ARG = P(1)*Z
            CALL MIDDLE (ENEG, ARG, EPOS)
            DUMMY = EXP(ARG)
            P1 = MAX(RTOL, P(1))
            TEMP = - P(2)*(DUMMY - ONE)/P1
            CALL MIDDLE (ENEG, TEMP, EPOS)
            RESUL = EXP(TEMP)
            ZJAC(1) = - RESUL*(TEMP + P(2)*Z*DUMMY)/P1
            ZJAC(2) = RESUL*(ONE - DUMMY)/P1
            IF (K.EQ.3) THEN
               ZJAC(1) = P(3)*ZJAC(1)
               ZJAC(2) = P(3)*ZJAC(2) 
               ARG = P(1)*Z
               CALL MIDDLE (ENEG, ARG, EPOS)
               TEMP = - P(2)*(EXP(ARG) - ONE)/MAX(RTOL, P(1))
               CALL MIDDLE (ENEG, TEMP, EPOS)
               FMOD = EXP(TEMP)
               ZJAC(3) = FMOD
            ENDIF  
         ENDIF
      ELSEIF (ITIME.EQ.4 .OR. ITIME.EQ.7) THEN
         IF (GROWTH) THEN
            ARG = - P(3)*Z
            CALL MIDDLE (ENEG, ARG, EPOS)
            RESUL = EXP(ARG)
            ARG = - P(2)*RESUL
            CALL MIDDLE (ENEG, ARG, EPOS)
            ANSWER = EXP(ARG)
            ZJAC(1) = ANSWER
            ZJAC(2) = - P(1)*RESUL*ZJAC(1)
            ZJAC(3) =  - P(2)*Z*ZJAC(2)
            IF (ITIME.EQ.7) ZJAC(4) = ONE
         ELSE
            TEMP = P(1)*Z
            IF (TEMP.GE.RTOL) THEN
               RESUL = TEMP**P(2)
               BOT = ONE + RESUL
               BOT2 = BOT*BOT
               ZJAC(1) = - P(2)*P(1)**(P(2) - ONE)*Z**P(2)/BOT2
               ZJAC(2) = - LOG(TEMP)*RESUL/BOT2
            ELSE
               ZJAC(1) = ZERO
               ZJAC(2) = ZERO
            ENDIF
            IF (K.EQ.3) THEN
               ZJAC(1) = P(3)*ZJAC(1)
               ZJAC(2) = P(3)*ZJAC(2) 
               TEMP = P(1)*Z
               IF (TEMP.GE.RTOL) THEN
                  FMOD = ONE/(ONE + TEMP**P(2))
               ELSE
                  FMOD = ONE
               ENDIF
               ZJAC(3) = FMOD
            ENDIF  
         ENDIF
      ELSEIF (ITIME.EQ.5 .OR. ITIME.EQ.8) THEN
         ARG = - Q(3)*Z
         CALL MIDDLE (ENEG, ARG, EPOS)
         RESUL = EXP(ARG)
         TEMP = (Q(1) - Q(2)*RESUL)**2
         IF (ABS(P(2)).LE.RTOL) THEN
            IF (P(2).LT.ZERO) THEN
               P2 = - RTOL
            ELSE
               P2 = RTOL
            ENDIF
         ELSE
            P2 = P(2)
         ENDIF
         DUMMY = (ONE - RESUL)/P2
         ZJAC(1) = THREE*TEMP*DUMMY
         ZJAC(2) = TEMP*Z*Q(2)*RESUL - Q(1)*ZJAC(1)
         IF (P(3).GT.RTOL) THEN
            ZJAC(3) = TEMP*P(3)**POWER*RESUL
         ELSE
            ZJAC(3) = TEMP*P(3)*RESUL
         ENDIF
         IF (ITIME.EQ.8) ZJAC(4) = ONE
      ELSEIF (ITIME.EQ.9) THEN
         ARG = - P(3)*Z
         CALL MIDDLE (ENEG, ARG, EPOS)
         RESUL = EXP(ARG)
         ZDIFF = MAX(RTOL, Q(1) - Q(2)*RESUL)
         P1 = MAX(RTOL, P(1))
         DUMMY = P(4)*Q(3)
         TEMP = ZDIFF**Q(3)
         ANSWER = P1**(-P(4))
         ZJAC(1) = ANSWER*ZDIFF**DUMMY
         ZJAC(2) = - RESUL*Q(3)*ZDIFF**DUMMY
         ZJAC(3) = - P(2)*Z*ZJAC(2)
         ZJAC(4) = TEMP*Q(3)*(Q(3)*LOG(ZDIFF) - Q(1)*LOG(P1)/ZDIFF)
      ELSEIF (ITIME.EQ.10) THEN
         PDIFF = P(1) - P(2)
         ZDIFF = Z - P(5)
         ARG = P(3)*ZDIFF
         CALL MIDDLE (ENEG, ARG, EPOS)
         E3 = EXP(ARG)
         ARG = P(4)*ZDIFF
         CALL MIDDLE (ENEG, ARG, EPOS)
         E4 = EXP(ARG)
         BOT = E3 + E4
         TEMP = TWO/MAX(RTOL, BOT)
         ZJAC(1) = ONE - TEMP
         ZJAC(2) = TEMP
         TEMP = TEMP/MAX(RTOL, BOT)
         DUMMY = TEMP*PDIFF*ZDIFF
         ZJAC(3) = DUMMY*E3
         ZJAC(4) = DUMMY*E4
         ZJAC(5) = - TEMP*PDIFF*(P(3)*E3 + P(4)*E4)
      ENDIF
      END
C
C-----------------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION THALF (ITIME,
     +                                 P, 
     +                                 GROWTH, UP)
C
C ACTION: calculate half-times
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: ITIME
      DOUBLE PRECISION, INTENT (IN) :: P(*)
      LOGICAL,          INTENT (IN) :: GROWTH, UP
C
C Locals
C      
      DOUBLE PRECISION A, ATHIRD, B, FK, TEMP
      DOUBLE PRECISION RTOL, ONE, ONETHD, TWO, THREE, ZERO
      PARAMETER (RTOL = 1.0D-250, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, ONETHD = ONE/THREE, ZERO = 0.0D+00)
      DOUBLE PRECISION F1, F2
      INTRINSIC  ABS, LOG
C
C Initialise THALF < 0 ... positive value returned only if successful
C
      THALF = - TWO
      IF (GROWTH) THEN
C
C Growth models
C
         IF (ITIME.EQ.1 .AND. .NOT.UP) THEN
            FK = - P(2)
            THALF = LOG(TWO)/FK
         ELSEIF (ITIME.GE.2 .AND. ITIME.LE.5 .AND.
     +           ABS(P(3)).GT.RTOL) THEN
            IF (ITIME.EQ.2) THEN
               B = P(2)
               FK = P(3)
               IF (UP) THEN
                  TEMP = TWO*B
               ELSE
                  TEMP = TWO*B/(ONE + B)
               ENDIF
               IF (TEMP.GT.RTOL) THALF = LOG(TEMP)/FK
            ELSEIF (ITIME.EQ.3) THEN
               B = P(2)
               FK = P(3)
               IF (UP) THEN
                  TEMP = B
               ELSE
                  TEMP = B/(ONE + TWO*B)
               ENDIF
               IF (TEMP.GT.RTOL) THALF = LOG(TEMP)/FK
            ELSEIF (ITIME.EQ.4) THEN
               B = P(2)
               FK = P(3)
               IF (UP) THEN
                  TEMP = B/LOG(TWO)
               ELSE
                  TEMP = B/(LOG(TWO) + B)
               ENDIF
               IF (TEMP.GT.RTOL) THALF = LOG(TEMP)/FK
            ELSEIF (ITIME.EQ.5) THEN
               F1 = (ONE/TWO)**ONETHD
               F2 = ONE - F1
               IF (ABS(P(2)).GT.RTOL) THEN
                  TEMP = P(1)/P(2)
               ELSE
                  TEMP = - TWO
               ENDIF
               IF (TEMP.GT.RTOL .AND. P(3).GT.RTOL) THEN
                  ATHIRD = TEMP
                  IF (P(3).GT.ZERO) THEN
                     B = TEMP - P(3)**ONETHD
                  ELSE
                     B = TEMP - ABS(P(3))**ONETHD
                  ENDIF
                  FK = P(2)/THREE
                  IF (UP) THEN
                     TEMP = B/(ATHIRD*F2)
                  ELSE
                     TEMP = B/(F2*ATHIRD + F1*B)
                  ENDIF
                  IF (TEMP.GT.RTOL) THALF = LOG(TEMP)/FK
               ENDIF
            ENDIF
         ENDIF
      ELSE
C
C Survival models if P(1) > 0
C
         IF (P(1).GT.RTOL) THEN
            IF (ITIME.EQ.1) THEN
               A = P(1)
               THALF = LOG(TWO)/A
            ELSEIF (ITIME.EQ.2) THEN
               A = P(1)
               B = P(2)
               IF (B.GT.RTOL) THEN
                  TEMP = ONE/B
               ELSE
                  TEMP = - TWO
               ENDIF
               IF (TEMP.GT.RTOL) THALF = (LOG(TWO)**TEMP)/A
            ELSEIF (ITIME.EQ.3) THEN
               A = P(1)
               B = P(2)
               IF (B.GT.RTOL) THEN
                  TEMP = ONE + A*LOG(TWO)/B
               ELSE
                  TEMP = - TWO
               ENDIF
               IF (TEMP.GT.RTOL) THALF = LOG(TEMP)/A
            ELSEIF (ITIME.EQ.4) THEN
               A = P(1)
               THALF = ONE/A
            ENDIF
         ENDIF
      ENDIF
      END
C
C-----------------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION THERR (ITIME,
     +                                 P, S, V,
     +                                 GROWTH, UP)
C
C ACTION: calculate half-time standard errors using variances and covariances
C 13/03/2013 Note that:
C            Adding an amplitude factor to survival models does not require any
C            additional partial dervariances, variances or covariances, as the
C            time dependence does not depend on the amplitude factor, like with
C            growth models 1 to 4   
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: ITIME
      DOUBLE PRECISION, INTENT (IN) :: P(*), S(*), V(*)
      LOGICAL,          INTENT (IN) :: GROWTH, UP
C
C Locals
C      
      DOUBLE PRECISION A, B, D1, D2, D3, ELOG2, P2DIV3, P3ONE, P3TWO,
     +                 FK, TEMP, TERM1, TERM2, TERM3, V1, V2, V3, VT
      DOUBLE PRECISION RTOL, ONE, ONETHD, TWO, TWOTHD, THREE
      PARAMETER (RTOL = 1.0D-250, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, ONETHD = ONE/THREE,
     +           TWOTHD = TWO/THREE)
      DOUBLE PRECISION F1, F2
      INTRINSIC  ABS, LOG, SQRT
C
C Initialise THERR = 1 ... THERR value returned only if successful
C
      THERR = ONE
      IF (GROWTH) THEN
C
C Growth models
C
         IF (ITIME.EQ.1 .AND. .NOT.UP) THEN
             FK = - P(2)
             THERR = S(2)*LOG(TWO)/FK**2
         ELSEIF (ITIME.GE.2 .AND. ITIME.LE.5 .AND.
     +           ABS(P(3)).GT.RTOL) THEN
            IF (ITIME.EQ.2) THEN
               B = P(2)
               IF (UP) THEN
                  TEMP = TWO*B
               ELSE
                  TEMP = TWO*B/(ONE + B)
               ENDIF
               IF (TEMP.GT.RTOL) THEN
                  FK = P(3)
                  D1 = (- ONE/FK**2)*LOG(TEMP)
                  IF (UP) THEN
                     D2 = (ONE/FK)*(ONE/B)
                  ELSE
                     D2 = (ONE/FK)*(ONE/(B*(ONE - B)))
                  ENDIF
                  V1 = S(3)**2
                  V2 = S(2)**2
                  VT = (D1**2)*V1 + (D2**2)*V2
                  VT = VT + TWO*D1*D2*V(1)
                  IF (VT.GT.RTOL) THERR = SQRT(VT)
               ENDIF
            ELSEIF (ITIME.EQ.3) THEN
               B = P(2)
               IF (UP) THEN
                  TEMP = B
               ELSE
                  TEMP = B/(ONE + TWO*B)
               ENDIF
               IF (TEMP.GT.RTOL) THEN
                  FK = P(3)
                  D1 = (- ONE/FK**2)*LOG(TEMP)
                  IF (UP) THEN
                     D2 = (ONE/FK)*(ONE/B)
                  ELSE
                     D2 = (ONE/FK)*(ONE/(B*(ONE + TWO*B)))
                  ENDIF
                  V1 = S(3)**2
                  V2 = S(2)**2
                  VT = (D1**2)*V1 + (D2**2)*V2
                  VT = VT + TWO*D1*D2*V(1)
                  IF (VT.GT.RTOL) THERR = SQRT(VT)
               ENDIF
            ELSEIF (ITIME.EQ.4) THEN
               B = P(2)
               ELOG2 = LOG(TWO)
               IF (UP) THEN
                  TEMP = ELOG2/B
               ELSE
                  TEMP = (ELOG2 + B)/B
               ENDIF
               IF (TEMP.GT.RTOL) THEN
                  FK = P(3)
                  D1 = (ONE/FK**2)*LOG(TEMP)
                  IF (UP) THEN
                     D2 = (ONE/FK)*(ONE/B)
                  ELSE
                     D2 = (ONE/FK)*(ELOG2/(B*(ELOG2 + B)))
                  ENDIF
                  V1 = S(3)**2
                  V2 = S(2)**2
                  VT = (D1**2)*V1 + (D2**2)*V2
                  VT = VT + TWO*D1*D2*V(1)
                  IF (VT.GT.RTOL) THERR = SQRT(VT)
               ENDIF
            ELSEIF (ITIME.EQ.5) THEN
               F1 = (ONE/TWO)**ONETHD
               F2 = ONE - F1
               IF (ABS(P(1)).GT.RTOL .AND. ABS(P(2)).GT.RTOL .AND.
     +             P(3).GT.RTOL) THEN
C
C [3/p(2)]{log[p(1) - p(2)*p(3)^(1/3)] - log[p(1)*(1 - (1/2)^(1/3))]}
c or
C [3/p(2)]{log[p(1) - p(2)*p(3)^(1/3)] - log[p(1) - (1/2)^(1/3)*p(2)*p(3)^(1/3)]}
C
                  P2DIV3 = P(2)/THREE
                  P3ONE = P(3)**ONETHD
                  P3TWO = P(3)**TWOTHD
                  TERM1 = THREE/P(2)
                  TERM2 = P(1) - P(2)*P3ONE
                  IF (UP) THEN
                     TERM3 = P(1)*F2
                  ELSE
                     TERM3 = P(1) - F1*P(2)*P3ONE
                  ENDIF
                  IF (ABS(TERM2).GT.RTOL .AND. ABS(TERM3).GT.RTOL) THEN
                     TEMP = TERM2/TERM3
                     IF (TEMP.LT.RTOL) TEMP = - TWO
                  ELSE
                     TEMP = - TWO
                  ENDIF
                  IF (TEMP.GT.RTOL) THEN
                     IF (UP) THEN
                        D1 = TERM1*(ONE/TERM2 - ONE/P(1))
                        D2 = - TERM1*LOG(TEMP)/P(2)
     +                       - TERM1*P3ONE/TERM2
                        D3 = - TERM1*P2DIV3/(TERM2*P3TWO)
                     ELSE
                        D1 = TERM1*(ONE/TERM2 - ONE/TERM3)
                        D2 = - TERM1*LOG(TEMP)/P(2)
     +                       - TERM1*P3ONE/TERM2
     +                       + TERM1*F1*P3ONE/TERM3
                        D3 = - TERM1*P2DIV3/(TERM2*P3TWO)
     +                       + TERM1*F1*P2DIV3/(TERM3*P3TWO)
                     ENDIF
                     V1 = S(1)**2
                     V2 = S(2)**2
                     V3 = S(3)**2
                     VT = (D1**2)*V1 + (D2**2)*V2 + (D3**2)*V3
                     VT = VT +
     +                    TWO*(D1*D2*V(1) + D1*D3*V(2) + D2*D3*V(3))
                     IF (VT.GT.RTOL) THERR = SQRT(VT)
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
      ELSE
C
C Survival models if P(1) > 0
C
         IF (P(1).GT.RTOL) THEN
            A = P(1)
            IF (ITIME.EQ.1) THEN
               ELOG2 = LOG(TWO)
               D1 = (- ONE/A**2)*ELOG2
               V1 = S(1)**2
               VT = (D1**2)*V1
               IF (VT.GT.RTOL) THERR = SQRT(VT)
            ELSEIF (ITIME.EQ.2) THEN
               B = P(2)
               IF (B.GT.RTOL) THEN
                  TEMP = ONE/B
               ELSE
                  TEMP = - TWO
               ENDIF
               IF (TEMP.GT.RTOL) THEN
                  ELOG2 = LOG(TWO)
                  D1 = (- ONE/A**2)*(ELOG2**TEMP)
                  V1 = S(1)**2
                  D2 = (ONE/A)*(LOG(ELOG2))*(ELOG2**TEMP)*
     +                 (- ONE/B**2)
                  V2 = S(2)**2
                  VT = (D1**2)*V1 + (D2**2)*V2
                  VT = VT + TWO*D1*D2*V(1)
                  IF (VT.GT.RTOL) THERR = SQRT(VT)
               ENDIF
            ELSEIF (ITIME.EQ.3) THEN
               B = P(2)
               ELOG2 = LOG(TWO)
               IF (B.GT.RTOL) THEN
                  TEMP = ONE + A*ELOG2/B
               ELSE
                  TEMP = - TWO
               ENDIF
               IF (TEMP.GT.RTOL) THEN
                  D1 = (- ONE/A**2)*LOG(TEMP) +
     +                 (ONE/A)*(ELOG2/(B + A*ELOG2))
                  V1 = S(1)**2
                  D2 = (ONE/A)*(- A*ELOG2/B)/(B + A*ELOG2)
                  V2 = S(2)**2
                  VT = (D1**2)*V1 + (D2**2)*V2
                  VT = VT + TWO*D1*D2*V(1)
                  IF (VT.GT.RTOL) THERR = SQRT(VT)
               ENDIF
            ELSEIF (ITIME.EQ.4) THEN
               A = P(1)
               D1 = (- ONE/A**2)
               V1 = S(1)**2
               VT = (D1**2)*V1
               IF (VT.GT.RTOL) THERR = SQRT(VT)
            ENDIF
         ENDIF
      ENDIF
      END
C
C-----------------------------------------------------------------------------
c
      subroutine gcfrev (isend, n,
     +                   e, ord, x, xsum, y, 
     +                   abort)
c
c action: reflect/restore data according to x values and xsum
c author: w.g.bardsley, university of manchester, u.k., 10/03/2013
c
c Note: When data for xmin =< x =< xmax are input with isend = 1 then x
c       is returned in reversed order using x_transformed = xmax + xmin - x
c       and y re-ordered to match. That is, data are reflected.
c       When the reflected data are input with isend = 2 and the original
c       xsum then x is reversed to the original values if there are no other
c       intervening editing changes. That is, data are restored.
c       Any other errors or isend out of range cause exit with abort = .true.
c       The order within replicates is conserved
c 
c isend: action as follows
c        isend = 1 ... reverse the original order and return xsum
c        isend = 2 ... input xmax and return original order  
c     n: dimension
c     e: std errors for weighting
c   ord: original order from 1 to n
c     x: independent variable  
c  xsum: xmax + xmin to restore transformation
c     y: measured response
c abort: returned .false. if successful
c
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: isend, n
      double precision,    intent (inout) :: ord(n)
      double precision,    intent (inout) :: e(n), x(n), y(n)
      double precision,    intent (inout) :: xsum
      logical,             intent (out)   :: abort 
c
c locals
c       
      integer    i, n_sav
      double precision dn, xmax, xmax_high, xmax_low, xmin, xmin_high,
     +                 xmin_low, xsum_high, xsum_low
      double precision epsi, one, zero
      parameter (epsi = 1.0d-14, one = 1.0d+00, zero = 0.0d+00)
      logical    x_rev
      external   hpsort, gcford, putfat
      intrinsic  dble
      save       n_sav
      save       x_rev
      save       xmax_high, xmax_low, xmin_high, xmin_low
      save       xsum_high, xsum_low
      data       xmax_high, xmax_low / zero, zero /
      data       xmin_high, xmin_low / zero, zero /
      data       xsum_high, xsum_low / zero, zero /
      data       x_rev / .false. /
      data       n_sav / 0 /
c
c initialise and check
c      
      abort = .true.
      if (n.lt.2) then
         call putfat (
     +'N less than 2 in call to GCFREV')          
         return
      endif   
      if (isend.lt.1 .or. isend.gt.2) then
         call putfat (
     +'ISEND out of range in call to GCFREV')          
         return  
      endif   
      do i = 2, n
         if (x(i).lt. x(i - 1)) then
            call putfat (
     +'Data must be in nondecreasing order in calls to GFCREV') 
            return
         endif
      enddo 
      
      if (isend.eq.1) then 
c
c isend = 1: reverse the order and return xsum but reverse then restore ord
c              
         xmax = x(n)
         xmin = x(1) 
         xmax_high = xmax + epsi
         xmax_low = xmax - epsi
         xmin_high = xmin + epsi
         xmin_low = xmin - epsi
         xsum = xmax + xmin
         xsum_high = xsum + epsi
         xsum_low = xsum - epsi
         dn = dble(n)
         do i = 1, n
            x(i) = xsum - x(i)
            ord(i) = dn - ord(i) + one
         enddo
         call hpsort (n,
     +                x, y, e, ord)
         call gcford (n,
     +                e, ord, x, y) 
         do i = 1, n
            ord(i) = dn - ord(i) + one
         enddo   
         n_sav = n
         x_rev = .true.
      elseif (isend.eq.2) then
c
c isend = 2: reverse things after a call with isend = 1 but use original ord
c      
         if (n.ne.n_sav) then
            call putfat (
     +'N has been changed since the call to GCFREV with ISEND = 1')
             return
         endif                
         if (.not.x_rev) then
            call putfat (
     +'Data have not been reversed by a call to GCFREV with ISEND = 1')
            return
         endif                
         if (xsum.lt.xsum_low .or. xsum.gt.xsum_high) then
            call putfat (
     +'XSUM has been changed since the call to GCFREV with ISEND = 1')
            return
         endif
         xmin = x(1) 
         if (xmin.lt.xmin_low .or. xmin.gt.xmin_high) then
            call putfat (
     +'XMIN has been changed since the call to GCFREV with ISEND = 1')
            return
         endif
         xmax = x(n)
         if (xmax.lt.xmax_low .or. xmax.gt.xmax_high) then
            call putfat (
     +'XMAX has been changed since the call to GCFREV with ISEND = 1')
            return
         endif   
         do i = 1, n
            x(i) =  xsum - x(i)
         enddo  
         call hpsort (n,
     +                ord, e, x, y)  
         call gcford (n,
     +                e, ord, x, y) 
         n_sav = 0 
         x_rev = .false.  
      endif            
      abort = .false.
      end
c 
C-------------------------------------------------------------------------------
C
      SUBROUTINE GCFORD (N,
     +                   E, ORDER, X, Y)
C
C ACTION : Restore order within replicates after call to GCFREV with ISEND = 1
C ADVICE : The X-values must be in increasing order
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 24/03/1997
C          10/03/2013 derived from ORDERS for for GCFIT
C
      IMPLICIT  NONE
C
C arguments
C      
      INTEGER,          INTENT (IN)    :: N
      DOUBLE PRECISION, INTENT (IN)    :: ORDER(N)
      DOUBLE PRECISION, INTENT (INOUT) :: E(N), X(N), Y(N)
C
C locals
C      
      INTEGER   I, ICOUNT, J, NREPS
      DOUBLE PRECISION EPSI, X02AJF$
      EXTERNAL  HPSORT, PUTFAT
      EXTERNAL  X02AJF$
      INTRINSIC ABS
      LOGICAL  DOSUMS
      IF (N.LT.2) RETURN
      DO I = 2, N
         IF (X(I).LT.X(I - 1)) THEN
            CALL PUTFAT ('Data to GCFORD not in increasing order')
            RETURN
         ENDIF
      ENDDO
      EPSI = X02AJF$()*(X(N) - X(1))
      NREPS = 1
      DO I = 2, N
         IF (ABS(X(I) - X(I - 1)).LE.EPSI) THEN
            DOSUMS = .FALSE.
            NREPS = NREPS + 1
            IF (I.EQ.N) THEN
               DOSUMS = .TRUE.
               ICOUNT = 0
            ENDIF
         ELSE
            IF (NREPS.EQ.1) THEN
               DOSUMS = .FALSE.
            ELSE
               DOSUMS = .TRUE.
               ICOUNT = 1
            ENDIF
         ENDIF
         IF (DOSUMS) THEN
            J = I - NREPS + 1 - ICOUNT
            CALL HPSORT (NREPS, ORDER(J), E(J), X(J), Y(J))
            NREPS = 1
         ENDIF
      ENDDO
      END
C
C
     