C
C
C GCFIT2.FOR
C ==========
C DATFIT
C DATOUT
C
C------------------------------------------------------------------------------
C
      SUBROUTINE DATFIT (LMFUNC,
     +                   IPVT, IRANK, ITIME, LWRK, NCMAX, NDOF, NF,
     +                   NPAR, NPTS, NRMAX,
     +                   CV, DI, DJ, DT, ENEG, EPOS, FJAC, FVEC, PARAM,
     +                   RTOL, SI, SJ, SMAX, STDERR, SZERO, TI, TJ,
     +                   TMAX, W, WSSQ, X, XSAV,
     +                   GROWTH, OMIT)
      USE MODULE_GCFIT, ONLY : AMPLITUDE_VARIED
C
C Parameters H1, HTHETA, S0, S1 and THETA should be set in internal
C coordinates, e.g. from table 7 of Preece and Baines for boys growth to
C age 24,H1 = 1.0, HTHETA = 0.93, S0 = 2.69, S1 = 29.75, THETA = 0.61
C after normalising to 0 <= S(T) <= 1.0 and 0 <= T <=1.0
C
C 13/03/2013 added fitting an amplitude factor to survival models
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: LWRK, NCMAX, NRMAX
      INTEGER,          INTENT (IN)    :: ITIME, NF, NPTS
      INTEGER,          INTENT (OUT)   :: IPVT(NRMAX), IRANK, NDOF, NPAR
      DOUBLE PRECISION, INTENT (IN)    :: ENEG, EPOS, RTOL
      DOUBLE PRECISION, INTENT (IN)    :: DI, DJ, DT, SI, SJ, SMAX,
     +                                    SZERO, TI, TJ, TMAX 
      DOUBLE PRECISION, INTENT (OUT)   :: CV(NCMAX,NCMAX),
     +                                    FJAC(NRMAX,NCMAX),
     +                                    FVEC(NRMAX), PARAM(NCMAX),
     +                                    STDERR(NCMAX), W(LWRK), WSSQ,
     +                                    X(NCMAX)
      DOUBLE PRECISION, INTENT (INOUT) :: XSAV(3:5,3)
      LOGICAL,          INTENT (IN)    :: GROWTH, OMIT(10)
C
C Locals
C      
      INTEGER    LW
      INTEGER    I, IFAIL, J, M, N, NSAV
      INTEGER    ICOLOR, IX, IY, LSHADE, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NSTART = 9,
     +           NTEXT = 11, NUMOPT = 3)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION ZERO, ONE, TWO, ONETHD
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           ONETHD = 1.0D+00/3.0D+00)
      DOUBLE PRECISION H1, HTHETA, S0, S1, THETA
      PARAMETER (H1 = 1.0D+00, HTHETA = 0.9D+00, S0 = 2.5D+00,
     +           S1 = 30.0D+00, THETA = 0.6D+00)
      DOUBLE PRECISION ARGI, ARGJ, ARGL, ETA, FKAPPA
      CHARACTER  NAME(9)*50
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    IWARNU
      PARAMETER (IWARNU = .TRUE.)
      LOGICAL    YES
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   MIDDLE, GETR01, CHECKW, LBOX01, YESNO2, PATCH1
      EXTERNAL   LMFUNC, LSFUN1
C*****Code if E04FDF is used
C*****EXTERNAL  E04FDF, E04YCF
      EXTERNAL  LMFIT1
      INTRINSIC LOG, EXP, MAX, ABS, SQRT
      DATA NAME /
     +'A (where A^(1-m)=eta/kappa, dS/dt=eta*S^m-kappa*S)',
     +'B (where B=eta/kappa-S(0)^(1-m), S(0)=size at t=0)',
     +'k (where k=kappa*(1-m), dS/dt=eta*S^m-kappa*S)',
     +'m (where m=exponent of S in dS/dt=eta*S^m-kappa*S)',
     +'h1 (i.e. Max. size at the end of growth period)',
     +'htheta (i.e. Size at time = theta)',
     +'k0 (i.e. First  of two rate constants)',
     +'k1 (i.e. Second of two rate constants)',
     +'theta (i.e. Time parameter)' /
      DATA NUMPOS / NUMOPT*1 /
      DATA NUMBLD / NTEXT*0 /
      IF (OMIT(ITIME)) RETURN
C
C Set the starting estimates
C
      IF (ITIME.EQ.1) THEN
         GOTO 10
      ELSEIF (ITIME.EQ.2) THEN
         GOTO 20
      ELSEIF (ITIME.EQ.3) THEN
         GOTO 30
      ELSEIF (ITIME.EQ.4) THEN
         GOTO 40
      ELSEIF (ITIME.EQ.5) THEN
         GOTO 50
      ELSEIF (ITIME.EQ.6) THEN
         GOTO 60
      ELSEIF (ITIME.EQ.7) THEN
         GOTO 70
      ELSEIF (ITIME.EQ.8) THEN
         GOTO 80
      ELSEIF (ITIME.EQ.9) THEN
         GOTO 90
      ELSEIF (ITIME.EQ.10) THEN
         GOTO 100
      ENDIF
   10 CONTINUE
      IF (GROWTH) THEN
         NPAR = 2
         ARGL = SJ/SI
         X(2) = (LOG(ARGL))/DT
         ARGI = - TI*X(2)
         CALL MIDDLE (ENEG, ARGI, EPOS)
         ARGJ = - TJ*X(2)
         CALL MIDDLE (ENEG, ARGJ, EPOS)
         X(1) = (SI*EXP(ARGI) + SJ*EXP(ARGJ))/TWO
      ELSE
         NPAR = 1
         X(1) = ONE
         IF (AMPLITUDE_VARIED) THEN
            NPAR = 2
            X(2) = ONE
         ENDIF   
      ENDIF
      GOTO 4000
   20 CONTINUE
      IF (GROWTH) THEN
         NPAR = 3
         X(1) = 1.25D+00
         ARGL = DI/DJ
         X(3) = (LOG(ARGL))/DT
         ARGI = TI*X(3)
         CALL MIDDLE (ENEG, ARGI, EPOS)
         ARGJ = TJ*X(3)
         CALL MIDDLE (ENEG, ARGJ, EPOS)
         X(2) = (DI*EXP(ARGI) + DJ*EXP(ARGJ))/TWO
      ELSE
         NPAR = 2
         X(1) = ONE
         X(2) = ONE
         IF (AMPLITUDE_VARIED) THEN
            NPAR = 3
            X(3) = ONE
         ENDIF   
      ENDIF
      GOTO 4000
   30 CONTINUE
      IF (GROWTH) THEN
         NPAR = 3
         X(1) = 1.25D+00
         ARGL = DI/DJ
         X(3) = (LOG(ARGL))/DT
         ARGI = TI*X(3)
         CALL MIDDLE (ENEG, ARGI, EPOS)
         ARGJ = TJ*X(3)
         CALL MIDDLE (ENEG, ARGJ, EPOS)
         X(2) = X(1)*((DI/SI)*EXP(ARGI) + (DJ/SJ)*EXP(ARGJ))/TWO
         IF (ITIME.EQ.6) THEN
            NPAR = 4
            X(4) = ZERO
         ENDIF
      ELSE
         NPAR = 2
         X(1) = ONE
         X(2) = ONE
         IF (AMPLITUDE_VARIED) THEN
            NPAR = 3
            X(3) = ONE
         ENDIF   
      ENDIF
      GOTO 4000
   40 CONTINUE
      IF (GROWTH) THEN
         NPAR = 3
         X(1) = 1.25D+00
         ARGL = MAX(RTOL, ABS(LOG(SI/1.25)/LOG(SJ/1.25)))
         X(3) = LOG(ARGL)/DT
         ARGI = TI*X(3)
         CALL MIDDLE (ENEG, ARGI, EPOS)
         ARGJ = TJ*X(3)
         CALL MIDDLE (ENEG, ARGJ, EPOS)
         X(2) = - (LOG(SI/1.25D+00)*EXP(ARGI) + LOG(SJ/1.25)*EXP(ARGJ))
     +            /TWO
         IF (ITIME.EQ.7) THEN
            NPAR = 4
            X(4) = ZERO
         ENDIF
      ELSE
         NPAR = 2
         X(1) = ONE
         X(2) = ONE
         IF (AMPLITUDE_VARIED) THEN
            NPAR = 3
            X(3) = ONE
         ENDIF   
      ENDIF
      GOTO 4000
   50 CONTINUE
      NPAR = 3
      FKAPPA = - 1.5D+00*((LOG(ONE - SI**ONETHD))/TI
     +                    + (LOG(ONE - SJ**ONETHD))/TJ)
      ETA = FKAPPA
      X(1) = ETA
      X(2) = FKAPPA
      X(3) = SZERO
      IF (ITIME.EQ.8) THEN
         NPAR = 4
         X(4) = ZERO
      ENDIF
      GOTO 4000
   60 CONTINUE
      IF (OMIT(3)) GOTO 30
      GOTO 2000
   70 CONTINUE
      IF (OMIT(4)) GOTO 40
      GOTO 2000
   80 CONTINUE
      IF (OMIT(5)) GOTO 50
      GOTO 2000
   90 CONTINUE
      NPAR = 4
      WRITE (TEXT,200)
      IFAIL = 1
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, IFAIL, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (IFAIL.EQ.1) THEN
         X(1) = ONE
         ARGL = DI/DJ
         X(3) = (LOG(ARGL))/DT
         ARGI = TI*X(3)
         CALL MIDDLE (ENEG, ARGI, EPOS)
         ARGJ = TJ*X(3)
         CALL MIDDLE (ENEG, ARGJ, EPOS)
         X(2) = (ABS(DI*EXP(ARGI)) + ABS(DJ*EXP(ARGJ)))/TWO
         X(4) = 0.5D+00
      ELSEIF (IFAIL.EQ.2) THEN
         X(1) = ONE
         ARGL = DI*SJ/(DJ*SI)
         X(3) = (LOG(ARGL))/DT
         ARGI = TI*X(3)
         CALL MIDDLE (ENEG, ARGI, EPOS)
         ARGJ = TJ*X(3)
         CALL MIDDLE (ENEG, ARGJ, EPOS)
         X(2) = - (ABS((DI/SI)*EXP(ARGI)) + ABS((DJ/SJ)*EXP(ARGJ)))/TWO
         X(4) = 1.5D+00
      ELSE
         DO I = 1, NPAR
            WRITE (LINE,300) NAME(I)
            CALL GETR01 (X(I), LINE)
         ENDDO
         X(1) = X(1)/SMAX
         X(2) = X(2)/(SMAX**(ONE - X(4)))
         X(3) = X(3)*TMAX
      ENDIF
      IF (X(4).LT.ONE) THEN
         IF (X(1).LE.ZERO .OR. X(2).LE.ZERO) THEN
            WRITE (TEXT,400)
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +                   TEXT, BORDER)
            GOTO 90
         ENDIF
      ELSEIF (X(4).GT.1.0D+00) THEN
         IF (X(1).LE.ZERO .OR. X(2).GE.ZERO) THEN
            WRITE (TEXT,400)
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +                   TEXT, BORDER)
            GOTO 90
         ENDIF
      ELSE
         WRITE (TEXT,400)
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +                   TEXT, BORDER)
         GOTO 90
      ENDIF
      GOTO 4000
  100 CONTINUE
      NPAR = 5
      WRITE (LINE,450)
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
      IF (YES) THEN
         DO I = 1, NPAR
            J = I + 4
            WRITE (LINE,300) NAME(J)
            CALL GETR01 (X(I), LINE)
         ENDDO
         X(1) = X(1)/SMAX
         X(2) = X(2)/SMAX
         X(3) = X(3)*TMAX
         X(4) = X(4)*TMAX
         X(5) = X(5)/TMAX
      ELSE
         X(1) = H1
         X(2) = HTHETA
         X(3) = S0
         X(4) = S1
         X(5) = THETA
      ENDIF
      GOTO 4000
 2000 CONTINUE
      NPAR = 4
      NSAV = ITIME - 3
      DO I = 1, 3
         X(I) = XSAV(NSAV,I)
      ENDDO
      X(4) = ZERO
C
C NPAR has been set and X contains the starting estimates so curve fit
C
 4000 CONTINUE
      M = NPTS
      N = NPAR
      NDOF = M - N
      CALL LSFUN1 (M, N,
     +             X, W)
      WSSQ = ZERO
      DO I = 1, M
         WSSQ = WSSQ + W(I)*W(I)
      ENDDO
      CALL CHECKW (NDOF,
     +             WSSQ)
C******************************
C Next code if E04FDF is used
C     COLOUR = 15
C     CALL TABLE1 (COLOUR, 'OPEN')
C     WRITE (LINE,500) 'Before', WSSQ
C     COLOUR = 0
C     CALL TABLE1 (COLOUR, LINE)
C     WRITE (LINE,600) ITIME
C     COLOUR = 0
C     CALL TABLE1 (COLOUR, LINE)
C****************************
C     I = 1
C     IFAIL = 1
C     IF (N.EQ.1) THEN
C        J = 9 + 5*M
C     ELSE
C        J = 7*N + N*N + 2*M*N + 3*M + N*(N -1)/2
C     ENDIF
C*****CALL E04FDF (M, N, X, WSSQ, IW, I, W, J, IFAIL)
      LW = 5*N + M
      CALL LMFIT1 (LMFUNC, IFAIL, IPVT, IRANK, LW, M, N, NCMAX, NF,
     +             NRMAX,
     +             CV, FJAC, FVEC, X, W, WSSQ,
     +             IWARNU)
C*************************
C Next code if E04YCF used
C     WRITE (LINE,500) 'After ', WSSQ
C     CALL TABLE1 (COLOUR, LINE)
C     CALL TABLE1 (COLOUR, 'CLOSE')
C     IF (IFAIL.EQ.2) THEN
C        WRITE (LINE,700)
C        YES = .FALSE.
C        CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
C        IF (YES) GOTO 4000
C     ENDIF
C*************************
C     IF (IFAIL.NE.0 .AND. IFAIL.NE.2 .AND. IFAIL.NE.5 .AND. IFAIL.NE.6)
C    +    CALL PUTIFA (IFAIL, NF, 'E04FDF/DATFIT')
C
C Now estimate the covariance matrix
C
C     I = 6*N + 2*M + M*N + 1 + MAX(1,(N*(N - 1)/2))
C     IFAIL = 1
C     J = I + N
C     K = - 1
C     CALL E04YCF (K, M, N, WSSQ, W(I), W(J), N, CJ, W, IFAIL)
C     CALL PUTIFA (IFAIL, NF, 'E04YCF/DATFIT')
C     IF (IFAIL.NE.0) THEN
C        CALL PUTIFA (IFAIL, NF, 'E04YCF/DATFIT')
C        WRITE (LINE,800)
C        CALL PUTWAR (LINE)
C     ENDIF
C     IFAIL = J
C     DO J = 1, N
C        K = N*(J - 1)
C        DO I = J, N
C           CV(I,J) = W(IFAIL + K + I - 1)
C        ENDDO
C*****ENDDO
      DO I = 1, N
         PARAM(I) = X(I)
         IF (CV(I,I).LT.RTOL) CV(I,I) = RTOL
         STDERR(I) = SQRT(CV(I,I))
      ENDDO
      IF (ITIME.EQ.3 .OR. ITIME.EQ.4 .OR. ITIME.EQ.5) THEN
         DO I = 1, NPAR
            XSAV(ITIME,I) = X(I)
         ENDDO
      ENDIF
C
C Format statements
C      
  200 FORMAT ('Special cases of model 9 are'
     +/'m = 0   (model 2 - monomolecular)'
     +/'m = 2   (model 3 - logistic)'
     +/'m = 1   (model 4 - Gompertz)'
     +/'m = 2/3 (model 5 - Von Bertalannfy 2/3)'
     +/'If in doubt, try m < 1, then m > 1 and'
     +/'compare the fits obtained.'/
     +/'Default starting estimates with  m < 1'
     +/'Default starting estimates with  m > 1'
     +/'You input suitable starting estimates')
  300 FORMAT ('Start value for',1X,A)
  400 FORMAT (
     +'Fatal  This model requires       `A > 0 and B > 0 if m < 1'
     +/'                                `A > 0 and B < 0 if m > 1'
     +/'       and also rejects the singular case at  m = 1'//
     +/'Special cases are:-     `m = 0   (model 2)'
     +/'                        `m = 2   (model 3)'
     +/'                        `m = 1   (model 4)'
     +/'                        `m = 2/3 (model 5)'//'... Try again')
  450 FORMAT (
     +'Input start estimates for model 10 ? (usually no)')
C 500 FORMAT (1X,A6,1X,'curve-fitting WSSQ =',1P,E10.3)
C 600 FORMAT ('Wait ... Curve-fitting in progress for model',I3)
C 700 FORMAT ('Maximum iterations used ... Re-enter ? (usually no)')
C*800 FORMAT (
C****+'Rank deficient cov. matrix ... Ignore std.errors etc.')
      END
C
C------------------------------------------------------------------------------
C
      SUBROUTINE DATOUT (ITIME, LWRK, NAUX, NBAD, NCMAX, NDOF, NF, NFLY,
     +                   NGRAF, NPAR, NPTS, NRMAX,
     +                   AUX, AVRR, CV, EN, EPSI, PARAM, RTOL, SBIG,
     +                   SMAX, SN, STDERR, TMAX, TN, TSIG, TVAL, W,
     +                   XGRAF, YABS,
     +                   QUAL,
     +                   EQUAL, GROWTH, ISTOP, NOUT, OMIT, WEIGHT)
      USE MODULE_GCFIT, ONLY : TIME_FORMAT, TIME_LENGTH, TIME_SUM, 
     +                         TIME_REVERSED
C
C Output best-fit parameters and residuals
C
C 13/03/2013 added fitting an amplitude factor to survival models
C 26/02/2015 added NPLOT, DELTA, and XPLOT to increase the accuracy of derivative estimates 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: LWRK, NAUX, NCMAX, NGRAF,
     +                                    NRMAX
      INTEGER,          INTENT (IN)    :: ITIME, NDOF, NF, NPAR, NPTS
      INTEGER,          INTENT (INOUT) :: NBAD, NFLY
      DOUBLE PRECISION, INTENT (INOUT) :: AUX(NAUX), AVRR, 
     +                                    CV(NCMAX,NCMAX), PARAM(NCMAX), 
     +                                    SBIG, STDERR(NCMAX),
     +                                    TSIG(NCMAX), TVAL(NCMAX),
     +                                    YABS, W(LWRK)
      DOUBLE PRECISION, INTENT (IN)    :: EN(NRMAX),
     +                                    EPSI, RTOL, SMAX,
     +                                    SN(NRMAX), TMAX, TN(NRMAX),
     +                                    XGRAF(NGRAF)
      LOGICAL,          INTENT (IN)    :: EQUAL(NRMAX), GROWTH, ISTOP,
     +                                    NOUT(4), OMIT(10), WEIGHT
C
C Locals
C      
      INTEGER    I, IFAIL, J, N1, N2, N3, N4, N5, N6
      INTEGER    IMAX, IMIN, NPLOT
      PARAMETER (NPLOT = 200)
      INTEGER    COLOUR
      DOUBLE PRECISION ZERO, ONE, TWO, ONETHD
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           ONETHD = 1.0D+00/3.0D+00)
      DOUBLE PRECISION PNT05, PNT975
      PARAMETER (PNT05 = 0.05D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION DMAX, DMIN
      PARAMETER (DMAX = 1.0D+300, DMIN = - DMAX)
      DOUBLE PRECISION DERIV, DERIV1, SIZE1, TEMP, TIME, TIME1
      DOUBLE PRECISION ALPHA, ARGVAL, TSTAT
      DOUBLE PRECISION DBIG, DBIG1, R, RATIO, RBIG, RDENOM, RELERR,
     +                 S1, S2, TDER, TDER1, TREL
      DOUBLE PRECISION TERR2, TCOV2(3), TIME2, TSIG2, TVAL2
      DOUBLE PRECISION DSDT, FMOD, THALF, THERR
      DOUBLE PRECISION G01EBF$, G01FBF$
      DOUBLE PRECISION DELTA, XPLOT(NPLOT)
      CHARACTER  QUAL(NRMAX)*(*)
      CHARACTER  CIPHER*14, SYMBOL(20)*8, SYMB2*8, TYPE1(20)*2, TYPE2*20
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 13 ) D13(4), SHOWRJ
      CHARACTER (LEN = 10 ) D10(9), FORM10, SHOW10
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    UP
      EXTERNAL   E_FORMATS, SHOWRJ, FORM10, SHOW10
      EXTERNAL   PUTIFA, CORCOF, TABLE1
      EXTERNAL   G01FBF$, G01EBF$
      EXTERNAL   FMOD, DSDT, THALF, THERR
      INTRINSIC  ABS, MAX, SQRT, DBLE
      IF (ISTOP) RETURN
      IF (OMIT(ITIME)) RETURN
      E_NUMBERS = E_FORMATS()  
C
C Calculate UP = .TRUE. if best fit curve is increasing
C
      SBIG = - ONE
      S1 = FMOD(NPAR, NAUX, PARAM, AUX, TN(1))
      S2 = FMOD(NPAR, NAUX, PARAM, AUX, TN(NPTS))
      IF (S2.GT.S1) THEN
         UP = .TRUE.
      ELSE
         UP = .FALSE.
      ENDIF
C
C Branch to appropriate model
C
      IF (ITIME.EQ.1) THEN
         GOTO 10
      ELSEIF (ITIME.EQ.2) THEN
         GOTO 20
      ELSEIF (ITIME.EQ.3) THEN
         GOTO 30
      ELSEIF (ITIME.EQ.4) THEN
         GOTO 40
      ELSEIF (ITIME.EQ.5) THEN
         GOTO 50
      ELSEIF (ITIME.EQ.6) THEN
         GOTO 60
      ELSEIF (ITIME.EQ.7) THEN
         GOTO 70
      ELSEIF (ITIME.EQ.8) THEN
         GOTO 80
      ELSEIF (ITIME.EQ.9) THEN
         GOTO 90
      ELSEIF (ITIME.EQ.10) THEN
         GOTO 100
      ENDIF
   10 CONTINUE
      IF (GROWTH) THEN
         PARAM(1) = PARAM(1)*SMAX
         PARAM(2) = PARAM(2)/TMAX
         STDERR(1) = STDERR(1)*SMAX
         STDERR(2) = STDERR(2)/TMAX
         SYMBOL(1) = '   A'
         SYMBOL(2) = '   k'
         SBIG = - ONE
      ELSE
         SBIG = SMAX
         PARAM(1) = PARAM(1)/TMAX
         STDERR(1) = STDERR(1)/TMAX
         SYMBOL(1) = '   A'
         IF (NPAR.EQ.2) THEN
            PARAM(2) = PARAM(2)*SMAX
            STDERR(2) = STDERR(2)*SMAX
            SYMBOL(2) = '   S(0)'
         ENDIF   
      ENDIF
      GOTO 2000
   20 CONTINUE
      IF (GROWTH) THEN
         PARAM(1) = PARAM(1)*SMAX
         PARAM(3) = PARAM(3)/TMAX
         STDERR(1) = STDERR(1)*SMAX
         STDERR(3) = STDERR(3)/TMAX
         TCOV2(1) = CV(2,3)/TMAX
         SYMBOL(1) = '   A'
         SYMBOL(2) = '   B'
         SYMBOL(3) = '   k'
         SBIG = PARAM(1)
         IF (ITIME.EQ.6 .OR. ITIME.EQ.7) THEN
            PARAM(4)  = PARAM(4)*SMAX
            STDERR(4) = STDERR(4)*SMAX
            SYMBOL(4) = '   C'
            SBIG = SBIG + PARAM(4)
         ENDIF
      ELSE
         SBIG = SMAX
         PARAM(1) = PARAM(1)/TMAX
         STDERR(1) = STDERR(1)/TMAX
         TCOV2(1) = CV(1,2)/TMAX
         SYMBOL(1) = '   A'
         SYMBOL(2) = '   B'
         IF (NPAR.EQ.3) THEN
            PARAM(3) = PARAM(3)*SMAX
            STDERR(3) = STDERR(3)*SMAX
            SYMBOL(3) = '   S(0)'
         ENDIF   
      ENDIF
      GOTO 2000
   30 CONTINUE
      IF (GROWTH) THEN
         GOTO 20
      ELSE
         SBIG = SMAX
         PARAM(1) = PARAM(1)/TMAX
         PARAM(2) = PARAM(2)/TMAX
         STDERR(1) = STDERR(1)/TMAX
         STDERR(2) = STDERR(2)/TMAX
         TCOV2(1) = CV(1,2)/(TMAX**2)
         SYMBOL(1) = '   A'
         SYMBOL(2) = '   B'
         IF (NPAR.EQ.3) THEN
            PARAM(3) = PARAM(3)*SMAX
            STDERR(3) = STDERR(3)*SMAX
            SYMBOL(3) = '   S(0)'
         ENDIF
         GOTO 2000
      ENDIF
   40 CONTINUE
      IF (GROWTH) THEN
         GOTO 20
      ELSE
         SBIG = SMAX
         PARAM(1) = PARAM(1)/TMAX
         STDERR(1) = STDERR(1)/TMAX
         SYMBOL(1) = '   A'
         SYMBOL(2) = '   B'
         IF (NPAR.EQ.3) THEN
            PARAM(3) = PARAM(3)*SMAX
            STDERR(3) = STDERR(3)*SMAX
            SYMBOL(3) = '   S(0)'
         ENDIF
      ENDIF
      GOTO 2000
   50 CONTINUE
      PARAM(1) = (PARAM(1)*(SMAX**ONETHD))/TMAX
      PARAM(2) = PARAM(2)/TMAX
      PARAM(3) = PARAM(3)*SMAX
      STDERR(1) = (STDERR(1)*(SMAX**ONETHD))/TMAX
      STDERR(2) = STDERR(2)/TMAX
      STDERR(3) = STDERR(3)*SMAX
      TCOV2(1) = CV(1,2)*(SMAX**ONETHD)/(TMAX**2)
      TCOV2(2) = CV(1,3)*SMAX*(SMAX**ONETHD)/TMAX
      TCOV2(3) = CV(2,3)*SMAX/TMAX
      SYMBOL(1) = '  eta'
      SYMBOL(2) = '  kappa'
      SYMBOL(3) = '  S(0)'
      SBIG = (PARAM(1)/PARAM(2))**3
      IF (ITIME.EQ.8) THEN
         PARAM(4)  = PARAM(4)*SMAX
         STDERR(4) = STDERR(4)*SMAX
         SYMBOL(4) = '  C'
         SBIG = SBIG + PARAM(4)
      ENDIF
      GOTO 2000
   60 CONTINUE
      GOTO 20
   70 CONTINUE
      GOTO 20
   80 CONTINUE
      GOTO 50
   90 CONTINUE
      ARGVAL = ONE - PARAM(4)
      IF (ABS(ARGVAL).LE.EPSI) THEN
         IF (ARGVAL.LE.ZERO) THEN
            ARGVAL = - EPSI
         ELSE
            ARGVAL = EPSI
         ENDIF
      ENDIF
      PARAM(1) = ABS(PARAM(1)*SMAX)
      IF (ARGVAL.LE.ZERO) THEN
         PARAM(2) = - ABS(PARAM(2)*(SMAX**ARGVAL))
      ELSE
         PARAM(2) = ABS(PARAM(2)*(SMAX**ARGVAL))
      ENDIF
      PARAM(3) = PARAM(3)/TMAX
      STDERR(1) = STDERR(1)*SMAX
      STDERR(2) = STDERR(2)*(SMAX**ARGVAL)
      STDERR(3) = STDERR(3)/TMAX
      SYMBOL(1) = '   A'
      SYMBOL(2) = '   B'
      SYMBOL(3) = '   k'
      SYMBOL(4) = '   m'
      SBIG = PARAM(1)
      GOTO 2000
  100 CONTINUE
      PARAM(1) = PARAM(1)*SMAX
      PARAM(2) = PARAM(2)*SMAX
      PARAM(3) = PARAM(3)/TMAX
      PARAM(4) = PARAM(4)/TMAX
      PARAM(5) = PARAM(5)*TMAX
      STDERR(1) = STDERR(1)*SMAX
      STDERR(2) = STDERR(2)*SMAX
      STDERR(3) = STDERR(3)/TMAX
      STDERR(4) = STDERR(4)/TMAX
      STDERR(5) = STDERR(5)*TMAX
      SYMBOL(1) = ' h1'
      SYMBOL(2) = ' htheta'
      SYMBOL(3) = ' k0'
      SYMBOL(4) = ' k1'
      SYMBOL(5) = ' theta'
      SBIG = PARAM(1)
      GOTO 2000
C
C Parameters have now been transformed into the original coordinates so
C we can calculate standard errors, confidence limits and t statistics
C
 2000 CONTINUE
      IFAIL = 1
      TSTAT = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
      CALL PUTIFA (IFAIL, NF, 'G01FBF/DATOUT')
      DO I = 1, NPAR
         IF (STDERR(I).LT.RTOL) STDERR(I) = RTOL
         ARGVAL = ABS(PARAM(I)/STDERR(I))
         IFAIL = 1
         ALPHA = ONE - G01EBF$('Lower-tail', ARGVAL, DBLE(NDOF), IFAIL)
         CALL PUTIFA (IFAIL, NF, 'G01EBF/DATOUT')
         TSIG(I) = TWO*ALPHA
         TVAL(I) = TSTAT*STDERR(I)
         IF (TSIG(I).GT.PNT05) THEN
            TYPE1(I) = ' *'
         ELSE
            TYPE1(I) = BLANK
         ENDIF
      ENDDO
      
      IF (TIME_REVERSED) THEN
         WRITE (NF,125) ITIME, TIME_FORMAT(1:TIME_LENGTH)
      ELSE   
         WRITE (NF,150) ITIME
      ENDIF
      
      IF (E_NUMBERS) THEN
         WRITE (NF,200) (SYMBOL(I), PARAM(I), STDERR(I), PARAM(I) -
     +                   TVAL(I), PARAM(I) + TVAL(I), TSIG(I),
     +                   TYPE1(I), I = 1, NPAR)
      ELSE
         DO I = 1, NPAR
            D13(1) = SHOWRJ(PARAM(I))
            D13(2) = SHOWRJ(STDERR(I))
            TEMP = PARAM(I) - TVAL(I) 
            D13(3) = SHOWRJ(TEMP)
            TEMP = PARAM(I) + TVAL(I)
            D13(4) = SHOWRJ(TEMP)
            WRITE (NF,250) SYMBOL(I), D13(1), D13(2), D13(3), D13(4),
     +                     TSIG(I), TYPE1(I)
         
         ENDDO
      ENDIF  
      TIME2 = THALF (ITIME, PARAM, GROWTH, UP)
      IF (TIME2.GT.ZERO) THEN
         TERR2 = THERR (ITIME, PARAM, STDERR, TCOV2, GROWTH, UP)
         IF (TERR2.GT.ZERO) THEN
            SYMB2 = '  t-half'
            ARGVAL = ABS(TIME2/TERR2)
            IFAIL = 1
            ALPHA = ONE - G01EBF$('Lower-tail', ARGVAL, DBLE(NDOF),
     +                             IFAIL)
            CALL PUTIFA (IFAIL, NF, 'G01EBF/DATOUT')
            TSIG2 = TWO*ALPHA
            TVAL2 = TSTAT*TERR2
            IF (TSIG2.GT.PNT05) THEN
               TYPE2 = ' *'
            ELSE
               TYPE2 = BLANK
            ENDIF
            IF (TIME_REVERSED) THEN
               IF (E_NUMBERS) THEN
                  WRITE (NF,200) SYMB2, TIME_SUM - TIME2, TERR2, 
     +                           TIME_SUM - (TIME2 + TVAL2),
     +                           TIME_SUM - (TIME2 - TVAL2),
     +                           TSIG2, TYPE2
               ELSE
                  TEMP = TIME_SUM - TIME2
                  D13(1) = SHOWRJ(TEMP)
                  D13(2) = SHOWRJ(TERR2)
                  TEMP = TIME_SUM - (TIME2 + TVAL2) 
                  D13(3) = SHOWRJ(TEMP)
                  TEMP = TIME_SUM - (TIME2 - TVAL2)
                  D13(4) = SHOWRJ(TEMP)
                  WRITE (NF,250) SYMB2, D13(1), D13(2), D13(3), D13(4),
     +                           TSIG2, TYPE2  
               ENDIF  
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (NF,200) SYMB2, TIME2, TERR2, TIME2 - TVAL2,
     +                           TIME2 + TVAL2, TSIG2, TYPE2
               ELSE
                  D13(1) = SHOWRJ(TIME2)
                  D13(2) = SHOWRJ(TERR2)
                  TEMP = TIME2 - TVAL2
                  D13(3) = SHOWRJ(TEMP)
                  TEMP = TIME2 + TVAL2
                  D13(4) = SHOWRJ(TEMP)
                  WRITE (NF,250) SYMB2, D13(1), D13(2), D13(3), D13(4),
     +                           TSIG2, TYPE2  
               ENDIF  
            ENDIF
         ELSE
            TIME2 = - TWO
         ENDIF
      ENDIF
      WRITE (NF,300)
      DO I = 1, NPAR
         WRITE (NF,400) (CV(I,J)/MAX(RTOL,
     +                   SQRT(ABS(CV(I,I)*CV(J,J)))), J = 1, I)
      ENDDO
      WRITE (NF,'(A)') BLANK
      WRITE (NF,'(A)') ' Residuals and Goodness of Fit'
C
C Open the results display routine TABLE1 
C
      IF (NOUT(1) .OR. NOUT(2)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
      ENDIF
      
      IF (NOUT(1)) THEN
         IF (TIME_REVERSED) THEN
            WRITE (TEXT,125) ITIME, TIME_FORMAT(1:TIME_LENGTH)
         ELSE   
            WRITE (TEXT,150) ITIME
         ENDIF        
         DO I = 1, 4
            IF (I.EQ.4) THEN
               COLOUR = 4
            ELSE
               COLOUR = 0
            ENDIF
            CALL TABLE1 (COLOUR, TEXT(I))
         ENDDO
         IF (E_NUMBERS) THEN
            WRITE (TEXT,200) (SYMBOL(I), PARAM(I), STDERR(I), PARAM(I) -
     +                        TVAL(I), PARAM(I) + TVAL(I), TSIG(I),
     +                        TYPE1(I), I = 1, NPAR)
         ELSE
            DO I = 1, NPAR
               D13(1) = SHOWRJ(PARAM(I))
               D13(2) = SHOWRJ(STDERR(I))
               TEMP = PARAM(I) - TVAL(I) 
               D13(3) = SHOWRJ(TEMP)
               TEMP = PARAM(I) + TVAL(I)
               D13(4) = SHOWRJ(TEMP)
               WRITE (TEXT(I),250) SYMBOL(I), D13(1), D13(2), D13(3), 
     +                             D13(4), TSIG(I), TYPE1(I)
            ENDDO
         ENDIF
         COLOUR = 0
         DO I = 1, NPAR
            CALL TABLE1 (COLOUR, TEXT(I))
         ENDDO
         IF (TIME2.GT.ZERO) THEN
           IF (TIME_REVERSED) THEN
               IF (E_NUMBERS) THEN
                  WRITE (TEXT(1),200) SYMB2, TIME_SUM - TIME2, TERR2, 
     +                           TIME_SUM - (TIME2 + TVAL2),
     +                           TIME_SUM - (TIME2 - TVAL2),
     +                           TSIG2, TYPE2
               ELSE
                  TEMP = TIME_SUM - TIME2
                  D13(1) = SHOWRJ(TEMP)
                  D13(2) = SHOWRJ(TERR2)
                  TEMP = TIME_SUM - (TIME2 + TVAL2) 
                  D13(3) = SHOWRJ(TEMP)
                  TEMP = TIME_SUM - (TIME2 - TVAL2)
                  D13(4) = SHOWRJ(TEMP)
                  WRITE (TEXT(1),250) SYMB2, D13(1), D13(2), D13(3),
     +                                D13(4), TSIG2, TYPE2 

               ENDIF  
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (TEXT(1),200) SYMB2, TIME2, TERR2,
     +                                TIME2 - TVAL2,
     +                                TIME2 + TVAL2, TSIG2, TYPE2
               ELSE
                  D13(1) = SHOWRJ(TIME2)
                  D13(2) = SHOWRJ(TERR2)
                  TEMP = TIME2 - TVAL2
                  D13(3) = SHOWRJ(TEMP)
                  TEMP = TIME2 + TVAL2
                  D13(4) = SHOWRJ(TEMP)
                  WRITE (TEXT(1),250) SYMB2, D13(1), D13(2), D13(3),
     +                                D13(4), TSIG2, TYPE2   
               ENDIF  
            ENDIF
            CALL TABLE1 (COLOUR, TEXT(1))
         ENDIF
         COLOUR = 4
         WRITE (TEXT,300)
         DO I = 1, 2
            CALL TABLE1 (COLOUR, TEXT(I))
         ENDDO
         COLOUR = 0
         DO I = 1, NPAR
            WRITE (LINE,400) (CV(I,J)/MAX(RTOL,
     +                        SQRT(ABS(CV(I,I)*CV(J,J)))), J = 1, I)
            CALL TABLE1 (COLOUR, LINE)
         ENDDO
         CALL TABLE1 (COLOUR, BLANK)
         COLOUR = 4
         CALL TABLE1 (COLOUR, ' Residuals and Goodness of Fit')
         COLOUR = 0 
      ENDIF
C
C Initialise AUX in external coordinates if necessary
C Generate residuals and theory and restore to external coordinates
C Calculate DS/DT and check for quality of fit of theory to data
C
C W(        1 ->  NPTS) = E        ... in original coordinates
C W( NPTS + 1 -> 2NPTS) = S        ...         ''
C W(2NPTS + 1 -> 3NPTS) = T        ...         ''
C W(3NPTS + 1 -> 4NPTS) = THEORY   ...         ''
C W(4NPTS + 1 -> 5NPTS) = RESID    ...         ''
C W(5NPTS + 1 -> 6NPTS) = WRESID   ...         ''
C W(6NPTS + 1 -> 7NPTS) = DSDT     ...         ''
C
C
C Special action for growth models 5, 8 and 9
C
      IF (GROWTH) THEN
         IF (ITIME.EQ.5 .OR. ITIME.EQ.8) THEN
            IF (ABS(PARAM(2)).GT.RTOL) THEN
               AUX(1) = PARAM(1)/PARAM(2)
            ELSE
               AUX(1) = ONE
            ENDIF
            AUX(2) = AUX(1) - ABS(PARAM(3))**ONETHD
            AUX(3) = ONETHD*PARAM(2)
         ELSEIF (ITIME.EQ.9) THEN
            TEMP = ONE - PARAM(4)
            IF (ABS(TEMP).LE.EPSI) THEN
               IF (TEMP.LE.0) THEN
                  TEMP = - EPSI
               ELSE
                  TEMP = EPSI
               ENDIF
            ENDIF
            AUX(1) = ABS(PARAM(1))**TEMP
            IF (TEMP.LT.ZERO) THEN
               AUX(2) = - ABS(PARAM(2))
            ELSE
               AUX(2) = ABS(PARAM(2))
            ENDIF
            AUX(3) = ONE/TEMP
         ENDIF
      ENDIF
C
C Initialise parameters needed to analyse the residuals
C
      NBAD = 0
      NFLY = 0
      N1 = NPTS
      N2 = 2*NPTS
      N3 = 3*NPTS
      N4 = 4*NPTS
      N5 = 5*NPTS
      N6 = 6*NPTS
      AVRR = ZERO
      DBIG = DMIN
      DBIG1 = DMAX
      RBIG = DBIG
      YABS = ZERO
C
C Start of main loop to analyse residuals
C
      DO I = 1, NPTS
         W(I) = EN(I)*SMAX
         W(N1 + I) = SN(I)*SMAX
         W(N2 + I) = TN(I)*TMAX
         YABS = YABS + ABS(W(N1 + I))
         IF (EQUAL(I)) THEN
            W(N3 + I) = W(N3 + I - 1)
            W(N4 + I) = W(N1 + I) - W(N3 + I)
            W(N5 + I) = W(N4 + I)/W(I)
            W(N6 + I) = W(N6 + I - 1)
         ELSE
            W(N3 + I) = FMOD(NPAR, NAUX, PARAM, AUX, W(N2 + I))
            W(N4 + I) = W(N1 + I) - W(N3 + I)
            W(N5 + I) = W(N4 + I)/W(I)
            W(N6 + I)  = DSDT(NPAR, PARAM, W(N3 + I), W(N2 + I))
            IF (W(N6 + I).GT.DBIG) THEN
               DBIG = W(N6 + I)
               TDER = W(N2 + I)
            ENDIF
            IF (W(N6 + I).LT.DBIG1) THEN
               DBIG1 = W(N6 + I)
               TDER1 = W(N2 + I)
            ENDIF
         ENDIF
         RDENOM = (ABS(W(N3 + I)) + ABS(W(N1 + I)))/TWO
         IF (RDENOM.LT.RTOL) THEN
            RELERR = ZERO
         ELSE
            RELERR = ABS(W(N4 + I))/RDENOM
            IF (RELERR.GT.RBIG) THEN
               RBIG = RELERR
               TREL = W(N2 + I)
            ENDIF
         ENDIF
         AVRR = AVRR + RELERR
         IF (RELERR.GT.0.8D+00) THEN
            NBAD = NBAD + 1
            NFLY = NFLY + 1
            QUAL(I) = '****'
         ELSEIF (RELERR.GT.0.4D+00) THEN
            NBAD = NBAD + 1
            NFLY = NFLY + 1
            QUAL(I) = '***'
         ELSEIF (RELERR.GT.0.2D+00) THEN
            NBAD = NBAD + 1
            QUAL(I) = '**'
         ELSEIF (RELERR.GT.0.1D+00) THEN
            NBAD = NBAD + 1
            QUAL(I) = '*'
         ELSE
            QUAL(I) = BLANK
         ENDIF
      ENDDO
C
C Loop is completed so do calculations for output
C
      AVRR = AVRR/NPTS
      YABS = YABS/NPTS
      IF (WEIGHT) THEN
         CIPHER = 'Wtd. Residuals'
      ELSE
         CIPHER = '  Residuals'
      ENDIF
      IF (NOUT(3)) THEN
         WRITE (NF,500)  CIPHER
         IF (TIME_REVERSED) THEN
            IF (E_NUMBERS) THEN
               WRITE (NF,600) (TIME_SUM - W(N2 + I), W(I), W(N1 + I),
     +                         W(N3 + I),
     +                       - W(N6 + I), W(N5 + I), QUAL(I),
     +                        I = 1, NPTS)
            ELSE
               DO I = 1, NPTS
                  TEMP = TIME_SUM - W(N2 + I)
                  D10(1) = SHOW10(TEMP)
                  D10(2) = SHOW10(W(I))
                  D10(3) = SHOW10(W(N1 + I)) 
                  D10(4) = SHOW10(W(N3 + I))
                  D10(5) = SHOW10(-W(N6 + I))
                  D10(6) = SHOW10(W(N5 + I))
                  WRITE (N6,610) D10(1), D10(2), D10(3), D10(4), D10(5),
     +                           D10(6), QUAL(I) 
               ENDDO
            ENDIF  
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (NF,600) (W(N2 + I), W(I), W(N1 + I), W(N3 + I),
     +                         W(N6 + I), W(N5 + I), QUAL(I),
     +                         I = 1, NPTS)
            ELSE
               DO I = 1, NPTS 
                  D10(1) = SHOW10(W(N2 + I))
                  D10(2) = SHOW10(W(I))
                  D10(3) = SHOW10(W(N1 + I))
                  D10(4) = SHOW10(W(N3 + I))
                  D10(5) = SHOW10(W(N6 + I))
                  D10(6) = SHOW10(W(N5 + I))
                  WRITE (NF,610) D10(1), D10(2), D10(3), D10(4), D10(5),
     +                           D10(6), QUAL(I)  
               ENDDO 
            ENDIF  
         ENDIF
         IF (NBAD.GT.0) WRITE (NF,700)
         WRITE (NF,'(A)') BLANK
      ENDIF
      IF (GROWTH) THEN
C
C Check SBIG in case UP = .FALSE. and calculate RATIO
C
         IF (.NOT.UP) SBIG = FMOD(NPAR, NAUX, PARAM, AUX, ZERO)
         IF (ITIME.EQ.1 .AND. UP) THEN
            RATIO = ONE
         ELSE
            RATIO = SMAX/SBIG
         ENDIF
         IF (RATIO.LT.0.5D+00 .OR. RATIO.GT.TWO) WRITE (NF,800)
         IF ((ITIME.EQ.1.AND.PARAM(2).LT.ZERO) .OR. ITIME.GT.1) THEN
            IF (E_NUMBERS) THEN
               WRITE (NF,900) SMAX, SBIG, RATIO
            ELSE
               D10(1) = FORM10(SMAX)
               D10(2) = FORM10(SBIG)
               D10(3) = FORM10(RATIO)
               WRITE (NF,910) D10(1), D10(2), D10(3)   
            ENDIF  
         ELSE
            WRITE (NF,'(A)') BLANK
         ENDIF
      ENDIF
C
C Calculate max/min derivatives
C         
      IMAX = -1
      IMIN = -1
      DERIV = DMIN
      DERIV1 = DMAX
      DO I = 1, NGRAF
         SIZE1 = FMOD(NPAR, NAUX, PARAM, AUX, XGRAF(I))
         TEMP = DSDT(NPAR, PARAM, SIZE1, XGRAF(I))
         IF (TEMP.GT.DERIV) THEN
            DERIV = TEMP
            TIME = XGRAF(I)
            IMAX = I
         ENDIF
         IF (TEMP.LT.DERIV1) THEN
            DERIV1 = TEMP
            TIME1 = XGRAF(I)
            IMIN = I
          ENDIF
      ENDDO
      
C
C Fine tune the min/max derivative estimates
C
      IF (IMAX.GT.1 .AND. IMAX.LT.NGRAF) THEN
         DELTA = (XGRAF(IMAX + 1) - XGRAF(IMAX - 1))/DBLE(NPLOT - 1)   
         XPLOT(1) = XGRAF(IMAX - 1)
         DO I = 2, NPLOT - 1
            XPLOT(I) = XPLOT(I - 1) + DELTA 
         ENDDO
         XPLOT(NPLOT) = XGRAF(IMAX) 
         DO I = 1, NPLOT
            SIZE1 = FMOD(NPAR, NAUX, PARAM, AUX, XPLOT(I))
            TEMP = DSDT(NPAR, PARAM, SIZE1, XPLOT(I))
            IF (TEMP.GT.DERIV) THEN
               DERIV = TEMP
               TIME = XPLOT(I)
            ENDIF
         ENDDO  
      ENDIF  
      IF (IMIN.GT.1 .AND. IMIN.LT.NGRAF) THEN
         DELTA = (XGRAF(IMIN + 1) - XGRAF(IMIN - 1))/DBLE(NPLOT - 1)   
         XPLOT(1) = XGRAF(IMIN - 1)
         DO I = 2, NPLOT - 1
            XPLOT(I) = XPLOT(I - 1) + DELTA 
         ENDDO
         XPLOT(NPLOT) = XGRAF(IMIN) 
         DO I = 1, NPLOT
            SIZE1 = FMOD(NPAR, NAUX, PARAM, AUX, XPLOT(I))
            TEMP = DSDT(NPAR, PARAM, SIZE1, XPLOT(I))
            IF (TEMP.LT.DERIV1) THEN
               DERIV1 = TEMP
               TIME1 = XPLOT(I)
            ENDIF
         ENDDO  
      ENDIF  
     
      CALL CORCOF (NPTS, R, W(N1 + 1), W(N3 + 1))
      IF (GROWTH) THEN
         IF (TIME_REVERSED) THEN
            IF (E_NUMBERS) THEN
               WRITE (NF,1025) - DBIG, - DERIV,
     +                         TIME_SUM - TDER, TIME_SUM - TIME,
     +                         - DBIG1, - DERIV1,
     +                         TIME_SUM - TDER1, TIME_SUM - TIME1,
     +                         TREL, 100.0D+00*RBIG, 100.0D+00*AVRR,
     +                         R**2
            ELSE
               D10(1) = FORM10(-DBIG)
               D10(2) = FORM10(-DERIV)
               TEMP = TIME_SUM - TDER
               D10(3) = FORM10(TEMP)
               TEMP = TIME_SUM - TIME
               D10(4) = FORM10(TEMP)
               D10(5) = FORM10(-DBIG1)
               D10(6) = FORM10(-DERIV1)
               TEMP = TIME_SUM - TDER1
               D10(7) = FORM10(TEMP)
               TEMP = TIME_SUM - TIME1
               D10(8) = FORM10(TEMP)
               D10(9) = FORM10(TREL)
               WRITE (NF,1035) D10(1), D10(2), D10(3), D10(4), D10(5),
     +                         D10(6), D10(7), D10(8), D10(9),
     +                         100.0D+00*RBIG, 100.0D+00*AVRR, R**2    

            ENDIF  
         ELSE  
            IF (E_NUMBERS) THEN 
               WRITE (NF,1050) DBIG, DERIV, TDER, TIME,
     +                         DBIG1, DERIV1, TDER1, TIME1,
     +                         TREL, 100.0D+00*RBIG, 100.0D+00*AVRR,
     +                         R**2
            ELSE
               D10(1) = FORM10(DBIG)
               D10(2) = FORM10(DERIV)
               D10(3) = FORM10(TDER)
               D10(4) = FORM10(TIME)
               D10(5) = FORM10(DBIG1)
               D10(6) = FORM10(DERIV1)
               D10(7) = FORM10(TDER1)
               D10(8) = FORM10(TIME1)
               D10(9) = FORM10(TREL)
               WRITE (NF,1060) D10(1), D10(2), D10(3), D10(4), D10(5),
     +                         D10(6), D10(7), D10(8), D10(9),  
     +                         100.0D+00*RBIG, 100.0D+00*AVRR,  R**2
            ENDIF
         ENDIF
      ELSE
         IF (E_NUMBERS) THEN
            WRITE (NF,1100) TREL, 100.0D+00*RBIG, 100.0D+00*AVRR, R**2,
     +                      DERIV, TIME, DERIV1, TIME1   
         ELSE
            D10(1) = FORM10(TREL)  
            D10(2) = FORM10(DERIV)
            D10(3) = FORM10(TIME)
            D10(4) = FORM10(DERIV1)
            D10(5) = FORM10(TIME1)
            WRITE (NF,1110) D10(1), 100.0D+00*RBIG, 100.0D+00*AVRR,
     +                      R**2, D10(2), D10(3), D10(4), D10(5)
         ENDIF  
      ENDIF
      
      IF (NOUT(2)) THEN
         COLOUR = 4
         WRITE (TEXT,500) CIPHER
         CALL TABLE1 (COLOUR, TEXT(2))
         COLOUR = 0
         IF (TIME_REVERSED) THEN
            IF (E_NUMBERS) THEN
               DO I = 1, NPTS
                  WRITE (LINE,600) TIME_SUM - W(N2 + I), W(I),
     +                             W(N1 + I),  W(N3 + I),
     +                           - W(N6 + I), W(N5 + I), QUAL(I)
              ENDDO
           ELSE
              DO I = 1, NPTS
                 D10(1) = SHOW10(W(N2 + I))
                 D10(2) = SHOW10(W(I))
                 D10(3) = SHOW10(W(N1 + I))
                 D10(4) = SHOW10(W(N3 + I))
                 D10(5) = SHOW10(W(N6 + I))
                 D10(6) = SHOW10(W(N5 + I))
                 WRITE (LINE,610) D10(1), D10(2), D10(3), D10(4),
     +                            D10(5), D10(6), QUAL(I)   
              ENDDO 
           ENDIF  
           CALL TABLE1 (COLOUR, LINE)
         ELSE  
            IF (E_NUMBERS) THEN 
               DO I = 1, NPTS
                  WRITE (LINE,600) W(N2 + I), W(I), W(N1 + I), 
     +                             W(N3 + I), W(N6 + I), W(N5 + I),
     +                             QUAL(I)
               ENDDO
            ELSE
               DO I = 1, NPTS 
                  D10(1) = SHOW10(W(N2 + I))
                  D10(2) = SHOW10(W(I))
                  D10(3) = SHOW10(W(N1 + I))
                  D10(4) = SHOW10(W(N3 + I))
                  D10(5) = SHOW10(W(N6 + I))
                  D10(6) = SHOW10(W(N5 + I))
                  WRITE (LINE,610) D10(1), D10(2), D10(3), D10(4),
     +                             D10(5), D10(6), QUAL(I)  
               ENDDO 
           ENDIF   
           CALL TABLE1 (COLOUR, LINE)
         ENDIF   
         IF (NBAD.GT.0) THEN
            COLOUR = 4
            WRITE (LINE,700)
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
      ENDIF
      IF (NOUT(1)) THEN
         COLOUR = 0
         IF (GROWTH) THEN
            IF (RATIO.LT.0.5D+00 .OR. RATIO.GT.TWO) THEN
               WRITE (TEXT,800)
               DO I = 1, 4
                  CALL TABLE1 (COLOUR, TEXT(I))
               ENDDO
            ENDIF
            IF ((ITIME.EQ.1.AND.PARAM(2).LT.ZERO) .OR. ITIME.GT.1) THEN
               IF (E_NUMBERS) THEN
                  WRITE (TEXT,900) SMAX, SBIG, RATIO
               ELSE
                  D10(2) = FORM10(SBIG)
                  D10(3) = FORM10(RATIO)
                  WRITE (TEXT,910) D10(1), D10(2), D10(3)   
               ENDIF  
               IF (NOUT(2)) CALL TABLE1 (COLOUR, BLANK)
               DO I = 1, 2
                  CALL TABLE1 (COLOUR, TEXT(I))
               ENDDO
            ENDIF
            IF (TIME_REVERSED) THEN
               IF (E_NUMBERS) THEN
                  WRITE (TEXT,1025) - DBIG, - DERIV,
     +                              TIME_SUM - TDER, TIME_SUM - TIME,
     +                              - DBIG1, - DERIV1, 
     +                              TIME_SUM - TDER1, TIME_SUM - TIME1,
     +                              TREL, 100.0D+00*RBIG,
     +                              100.0D+00*AVRR, R**2
               ELSE
                  D10(1) = FORM10(-DBIG)
                  D10(2) = FORM10(-DERIV)
                  TEMP = TIME_SUM - TDER
                  D10(3) = FORM10(TEMP)
                  TEMP = TIME_SUM - TIME
                  D10(4) = FORM10(TEMP)
                  D10(5) = FORM10(-DBIG1)
                  D10(6) = FORM10(-DERIV1)
                  TEMP = TIME_SUM - TDER1
                  D10(7) = FORM10(TEMP)
                  TEMP = TIME_SUM - TIME1
                  D10(8) = FORM10(TEMP)
                  D10(9) = FORM10(TREL)
                  WRITE (TEXT,1035) D10(1), D10(2), D10(3), D10(4), 
     +                              D10(5), D10(6), D10(7), D10(8),
     +                              D10(9), 100.0D+00*RBIG, 
     +                              100.0D+00*AVRR, R**2    
               ENDIF  
            ELSE  
               IF (E_NUMBERS) THEN
                  WRITE (TEXT,1050) DBIG, DERIV, TDER, TIME,
     +                              DBIG1, DERIV1, TDER1, TIME1,
     +                              TREL, 100.0D+00*RBIG,
     +                              100.0D+00*AVRR, R**2
               ELSE
                  D10(1) = FORM10(DBIG)
                  D10(2) = FORM10(DERIV)
                  D10(3) = FORM10(TDER)
                  D10(4) = FORM10(TIME)
                  D10(5) = FORM10(DBIG1)
                  D10(6) = FORM10(DERIV1)
                  D10(7) = FORM10(TDER1)
                  D10(8) = FORM10(TIME1)
                  D10(9) = FORM10(TREL)
                  WRITE (TEXT,1060) D10(1), D10(2), D10(3), D10(4),
     +                              D10(5), D10(6), D10(7), D10(8),
     +                              D10(9), 100.0D+00*RBIG, 
     +                              100.0D+00*AVRR,  R**2 
               ENDIF  
            ENDIF
            DO I = 1, 7
               CALL TABLE1 (COLOUR, TEXT(I))
            ENDDO
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (TEXT,1100) TREL, 100.0D+00*RBIG, 100.0D+00*AVRR,
     +                           R**2, DERIV, TIME, DERIV1, TIME1
            ELSE
               D10(1) = FORM10(TREL)  
               D10(2) = FORM10(DERIV)
               D10(3) = FORM10(TIME)
               D10(4) = FORM10(DERIV1)
               D10(5) = FORM10(TIME1)
               WRITE (TEXT,1110) D10(1), 100.0D+00*RBIG, 100.0D+00*AVRR,
     +                           R**2, D10(2), D10(3), D10(4), D10(5) 
            ENDIF  
            DO I = 1, 7
               CALL TABLE1 (COLOUR, TEXT(I))
            ENDDO
         ENDIF
      ENDIF
C
C Format statements
C          
  125 FORMAT (
     +/1X,'Results for model',I3,
     +': Parameter estimates are for T = (',A,' - time)'
     +/23X,'but note that t-half is in actual time units' 
     +/1X,
     +'Parameter    Value        Std.error    Lower95%cl    Upper95%cl',
     +'    p')
  150 FORMAT (/1X,'Results for model',I3//1X,
     +'Parameter    Value        Std.error    Lower95%cl    Upper95%cl',
     +'    p')
     
  200 FORMAT (A8,1P,E14.5,3E14.5,0P,F8.4,A2)
  250 FORMAT (A8,4(1X,A13),F8.4,A2)
  
  300 FORMAT (/1X,'Parameter correlation matrix')
  400 FORMAT (6F8.4)
  500 FORMAT (/3X,'Time',5X,
     +'Std.err.size    Size',9X,'Theory',7X,'dS/dt',4X,A14)
     
  600 FORMAT (1P,E10.3,5E13.5,A4)
  610 FORMAT (A10,5(3X,A10),A4)
  
  700 FORMAT (1X,'Abs. rel. residuals:-  >10% (*),   >20% (**)',
     +         ',   >40% (***),    >80% (****)')
  800 FORMAT (
     +/' WARNING : Poor agreement between data and predicted asymptote'
     +/' SUSPECT : Bad fit to data  and  a poorly determined asymptote'
     +/' REMEDY  : More (better) data near asymptote or superior model')
     
  900 FORMAT (1X,'Largest observed data value   =',1P,E13.5,2X,
     +'Theoretical asymptote   =',E13.5
     +/1X,'Largest observed/Th.asymptote =',E13.5)
  910 FORMAT (1X,'Largest observed data value   =',1X,A10,4X,
     +'Theoretical asymptote   =',1X,A10
     +/1X,'Largest observed/Th.asymptote =',1X,A10)
     
 1025 FORMAT (1X,'Minimum observed growth rate  =',1P,E13.5,2X,
     +'Best fit curve minimum  =',E13.5
     +/1X,'Time when min. rate observed  =',E13.5,2X,
     +'Best fit curve time     =',E13.5
     +/1X,'Maximum observed growth rate  =',1P,E13.5,2X,
     +'Best fit curve maximum  =',E13.5
     +/1X,'Time when max. rate observed  =',E13.5,2X,
     +'Best fit curve time     =',E13.5
     +/1X,'Time at largest rel. resid.   =',E13.5,
     +/1X,'Largest relative residual (%) =',0P,F9.2,1X,'%'
     +/1X,'Average relative residual (%) =',F9.2,1X,'%',2X,
     +'  R-squared =',F7.4,1X,'(theory,size)')
 1035 FORMAT (1X,'Minimum observed growth rate  =',1X,A10,4X,
     +'Best fit curve minimum  =',1X,A10
     +/1X,'Time when min. rate observed  =',1X,A10,4X,
     +'Best fit curve time     =',1X,A10
     +/1X,'Maximum observed growth rate  =',1X,A10,4X,
     +'Best fit curve maximum  =',1X,A10
     +/1X,'Time when max. rate observed  =',1X,A10,4X,
     +'Best fit curve time     =',1X,A10
     +/1X,'Time at largest rel. resid.   =',1X,A10,
     +/1X,'Largest relative residual (%) =',0P,F9.2,1X,'%'
     +/1X,'Average relative residual (%) =',F9.2,1X,'%',2X,
     +'  R-squared =',F7.4,1X,'(theory,size)')    

     
 1050 FORMAT (1X,'Maximum observed growth rate  =',1P,E13.5,2X,
     +'Best fit curve maximum  =',E13.5
     +/1X,'Time when max. rate observed  =',E13.5,2X,
     +'Best fit curve time     =',E13.5
     +/1X,'Minimum observed growth rate  =',1P,E13.5,2X,
     +'Best fit curve minimum  =',E13.5
     +/1X,'Time when min. rate observed  =',E13.5,2X,
     +'Best fit curve time     =',E13.5
     +/1X,'Time at largest rel. resid.   =',E13.5,
     +/1X,'Largest relative residual (%) =',0P,F9.2,1X,'%'
     +/1X,'Average relative residual (%) =',F9.2,1X,'%',2X,
     +'  R-squared =',F7.4,1X,'(theory,size)')  
 1060 FORMAT (1X,'Maximum observed growth rate  =',1X,A10,4X,
     +'Best fit curve maximum  =',1X,A10
     +/1X,'Time when max. rate observed  =',1X,A10,4X,
     +'Best fit curve time     =',1X,A10
     +/1X,'Minimum observed growth rate  =',1X,A10,4X,
     +'Best fit curve minimum  =',1X,A10
     +/1X,'Time when min. rate observed  =',1X,A10,4X,
     +'Best fit curve time     =',1X,A10
     +/1X,'Time at largest rel. resid.   =',1X,A10,
     +/1X,'Largest relative residual (%) =',0P,F9.2,1X,'%'
     +/1X,'Average relative residual (%) =',F9.2,1X,'%',2X,
     +'  R-squared =',F7.4,1X,'(theory,size)')       

     
 1100 FORMAT (
     + 1X,'Time at largest rel. resid.   =',1P,E13.5,
     +/1X,'Largest relative residual (%) =',0P,F9.2,1X,'%'
     +/1X,'Average relative residual (%) =',F9.2,1X,'%',2X,
     +'  R-squared =',F7.4,1X,'(theory,size)'
     +/1X,'Maximum decay rate dS/dt      =',1P,E13.5,
     +/1X,'Time at maximum decay rate    =',1P,E13.5,
     +/1X,'Minimum decay rate dS/dt      =',1P,E13.5,
     +' (i.e. most rapid decline)'
     +/1X,'Time at minimum decay rate    =',1P,E13.5)
 1110 FORMAT (
     + 1X,'Time at largest rel. resid.   =',1X,A10,
     +/1X,'Largest relative residual (%) =',F9.2,1X,'%'
     +/1X,'Average relative residual (%) =',F9.2,1X,'%',2X,
     +'  R-squared =',F7.4,1X,'(theory,size)'
     +/1X,'Maximum decay rate dS/dt      =',1X,A10,
     +/1X,'Time at maximum decay rate    =',1X,A10,
     +/1X,'Minimum decay rate dS/dt      =',1X,A10,
     +' (i.e. most rapid decline)'
     +/1X,'Time at minimum decay rate    =',1X,A10)    
     
      END
C
C------------------------------------------------------------------------------
C
