C
C
C GCFIT3.FOR
C ==========
C DETAIL
C GOFFIT
C LMFUNC
C LSFUN1
C LSJAC1
C SUMMIT
C GCF004
C
C----------------------------------------------------------------------
C
      SUBROUTINE DETAIL (NDIST, NGRAF, NOPT, NTYPE,
     +                   TMAX, TMIN, XGRAF,
     +                   GROWTH, ISTOP, NOUT, OMIT, PLOT)
      USE MODULE_GCFIT, ONLY : TIME_SUM, TIME_REVERSED, AMPLITUDE_VARIED 
C
C 13/09/2017 new version calling GET00X
C 26/10/2019 corrected code for controlling/saving AMPLITUDE_VARIED (search for the comment ! 26/10/2019)
C
C Details of mode of program operation
C OMIT: models 1, NOPT = number of models (10 or 5)
C NOUT: output type 1 to 4
C PLOT: 1 to 3
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NDIST, NGRAF, NOPT, NTYPE
      DOUBLE PRECISION, INTENT (IN)    :: TMAX, TMIN
      DOUBLE PRECISION, INTENT (OUT)   :: XGRAF(NGRAF)
      LOGICAL,          INTENT (IN)    :: GROWTH
      LOGICAL,          INTENT (INOUT) :: ISTOP, NOUT(4), OMIT(NOPT),
     +                                    PLOT(3)
C
C Locals
C      
      INTEGER    I, J, NFIT
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NUMSTA, NUMTXT
      parameter (icolor = 7, ixl = 0, iyl = 0, lshade = 0, numsta = 1)
      INTEGER    KVALUE(22), KVLIM_1(22), KVLIM_2(22), NUMPOS(22),
     +           NUMBLD(22)
      DOUBLE PRECISION DELTA, T_START, T_STOP, XVALUE(22)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 100) LINE, SVALUE(22), TEXT(30)
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, FIRST1
      LOGICAL    FIXED, FULL
      PARAMETER (FIXED = .FALSE., FULL = .FALSE.)
      LOGICAL    HIGH
      PARAMETER (HIGH = .TRUE.)
      EXTERNAL   PUTFAT
      EXTERNAL   ADVISE
      EXTERNAL   GET00X
      INTRINSIC  DBLE
      DATA       NUMPOS / 22*0 /
      DATA       NUMBLD / 22*0 /
C
C Calculate XGRAF for graphical axes in external coordinates
C
      IF (TIME_REVERSED) THEN
         T_START = TIME_SUM - TMAX
         T_STOP = TIME_SUM - TMIN
      ELSE
         T_START = TMIN
         T_STOP = TMAX
      ENDIF       
      XGRAF(1) = T_START
      DELTA = (T_STOP - T_START)/(DBLE(NGRAF) - ONE)
      DO I = 2, NGRAF - 1
         XGRAF(I) = XGRAF(I - 1) + DELTA
      ENDDO
      XGRAF(NGRAF) = T_STOP
C
C initialiase then decide which models to fit and output required
C
      DO I = 1, 22
         KVALUE(I) = 0
         KVLIM_1(I) = 0
         KVLIM_2(I) = 0
         NUMBLD(1) = 0
         NUMPOS(I) = 8
         XVALUE(I) = ZERO
         SVALUE(I) = BLANK
      ENDDO
   20 CONTINUE
      IF (GROWTH) THEN
C
C Growth curves
C
         WRITE (TEXT,100)
         NUMOPT = 22
         NUMTXT = NUMOPT
         NUMBLD(1) = 1
         NUMBLD(13) = 1
         J = 0
         DO I = 2, 11
            J = J + 1
            IF (.NOT.OMIT(J)) KVALUE(I) = 1
            NUMPOS(I) = 4
         ENDDO 
         J = 0
         DO I = 14, 17
            J = J + 1
            IF (NOUT(J)) KVALUE(I) = 1
            NUMPOS(I) = 4
         ENDDO
         J = 0
         DO I = 18, 20
            J = J + 1
            IF (PLOT(J)) KVALUE(I) = 1
            NUMPOS(I) = 4
         ENDDO   
         NUMPOS(21) = 4
         NUMPOS(22) = 4
         KVALUE(21) = 0
         KVALUE(22) = 0
C
C call subroutine GET00X 
C
         call get00x (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +  l             shade, numbld, numopt, numpos, numsta,
     +                numtxt,
     +                xvalue,
     +                svalue, text,
     +                fixed, full, high)
C
C interpret the output from subroutine GET00X
C              
         J = 0
         DO I = 2, 11
            J = J + 1
            IF (KVALUE(I).EQ.1) THEN
               OMIT(J) = .FALSE.
            ELSE
               OMIT(J) = .TRUE.  
            ENDIF   
         ENDDO 
         J = 0
         DO I = 14, 17
            J = J + 1
            IF (KVALUE(I).EQ.1) THEN 
               NOUT(J) = .TRUE.
            ELSE
               NOUT(J) = .FALSE.
            ENDIF    
         ENDDO
         J = 0
         DO I = 18, 20
            J = J + 1
            IF (KVALUE(I).EQ.1) THEN
               PLOT(J) = .TRUE.
            ELSE   
               PLOT(J) = .FALSE.
            ENDIF   
         ENDDO   
         IF (KVALUE(21).EQ.1) THEN
            FIRST1 = .FALSE.
            CALL ADVISE (IXL, 
     +                   BLANK,
     +                   ABORT, FIRST1)
            GOTO 20
         ELSEIF (KVALUE(22).EQ.1) THEN
            ISTOP = .TRUE.
            RETURN
         ELSE
            ISTOP = .FALSE.
         ENDIF      
      ELSEIF (NTYPE.EQ.2) THEN
C
C Survival curves
C
         WRITE (TEXT,200)
         NUMOPT = 17
         NUMTXT = NUMOPT
         NUMBLD(1) = 1
         NUMBLD(8) = 1
         J = 0
         DO I = 2, 6
            J = J + 1
            IF (.NOT.OMIT(J)) KVALUE(I) = 1
            NUMPOS(I) = 4
         ENDDO 
         J = 0
         DO I = 9, 12
            J = J + 1
            IF (NOUT(J)) KVALUE(I) = 1
            NUMPOS(I) = 4
         ENDDO
         J = 0
         DO I = 13, 15
            J = J + 1
            IF (PLOT(J)) KVALUE(I) = 1
            NUMPOS(I) = 4
         ENDDO   
         NUMPOS(16) = 4
         NUMPOS(17) = 4
         KVALUE(16) = 0
         KVALUE(17) = 0
         
C
C call subroutine GET00X (Note that kvalue(i) corresponds to omit(i - 1)) 
C
         IF (.NOT.AMPLITUDE_VARIED) KVALUE(6) = 1! 26/10/2019
                
         call get00x (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +  l             shade, numbld, numopt, numpos, numsta,
     +                numtxt,
     +                xvalue,
     +                svalue, text,
     +                fixed, full, high)
C
C interpret the output from subroutine GET00X
C              
         J = 0
         DO I = 2, 6
            J = J + 1
            IF (KVALUE(I).EQ.1) THEN
               OMIT(J) = .FALSE.
            ELSE
               OMIT(J) = .TRUE.  
            ENDIF   
         ENDDO 
         J = 0
         DO I = 9, 12
            J = J + 1
            IF (KVALUE(I).EQ.1) THEN 
               NOUT(J) = .TRUE.
            ELSE
               NOUT(J) = .FALSE.
            ENDIF    
         ENDDO
         J = 0
         DO I = 13, 15
            J = J + 1
            IF (KVALUE(I).EQ.1) THEN
               PLOT(J) = .TRUE.
            ELSE   
               PLOT(J) = .FALSE.
            ENDIF   
         ENDDO   
         IF (KVALUE(16).EQ.1) THEN
            FIRST1 = .FALSE.
            CALL ADVISE (IXL, 
     +                   BLANK,
     +                   ABORT, FIRST1)
            GOTO 20
         ELSEIF (KVALUE(17).EQ.1) THEN
            ISTOP = .TRUE.
            RETURN
         ELSE
            ISTOP = .FALSE.
         ENDIF      
         IF (OMIT(5)) THEN
            AMPLITUDE_VARIED = .TRUE.
         ELSE
            AMPLITUDE_VARIED = .FALSE.
         ENDIF 
         OMIT(5) = .TRUE.! 26/10/2019
      ENDIF
C
C Check if sufficient distinct points for model selected
C
      IF (GROWTH .AND. NDIST.LT.6) THEN
         IF (.NOT.OMIT(9)) THEN
            WRITE (LINE,300) 9
            CALL PUTFAT (LINE)
            OMIT(9) = .TRUE.
         ENDIF
         IF (NDIST.LT.5) THEN
            IF (.NOT.OMIT(6)) THEN
               WRITE (LINE,300) 6
               CALL PUTFAT (LINE)
               OMIT(6) = .TRUE.
            ENDIF
            IF (.NOT.OMIT(7)) THEN
               WRITE (LINE,300) 7
               CALL PUTFAT (LINE)
               OMIT(7) = .TRUE.
            ENDIF
            IF (.NOT.OMIT(8)) THEN
               WRITE (LINE,300) 8
               CALL PUTFAT (LINE)
               OMIT(8) = .TRUE.
            ENDIF
         ENDIF
         IF (NDIST.LT.4) THEN
            IF (.NOT.OMIT(2)) THEN
               WRITE (LINE,300) 2
               CALL PUTFAT (LINE)
               OMIT(2) = .TRUE.
            ENDIF
            IF (.NOT.OMIT(3)) THEN
               WRITE (LINE,300) 3
               CALL PUTFAT (LINE)
               OMIT(3) = .TRUE.
            ENDIF
            IF (.NOT.OMIT(4)) THEN
               WRITE (LINE,300) 4
               CALL PUTFAT (LINE)
               OMIT(4) = .TRUE.
            ENDIF
            IF (.NOT.OMIT(5)) THEN
               WRITE (LINE,300) 5
               CALL PUTFAT (LINE)
               OMIT(5) = .TRUE.
            ENDIF
         ENDIF
      ENDIF
C
C How many models are to be fitted ?
C
      NFIT = 0
      DO I = 1, NOPT
         IF (.NOT.OMIT(I)) NFIT = NFIT + 1
      ENDDO
      IF (NFIT.EQ.0) THEN
         ISTOP = .TRUE.
         RETURN
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Select which growth models to fit to the current data'   !1
     +/'Model 1.   The exponential model'                 !2
     +/'Model 2.   The monomolecular model'               !3
     +/'Model 3.   The logistic model'                    !4 
     +/'Model 4.   The Gompertz model'                    !5 
     +/'Model 5.   The Von Bertalannfy 2/3'               !6
     +/'Model 6.   The logistic + C'                      !7
     +/'Model 7.   The Gompertz + C'                      !8
     +/'Model 8.   The Von Bertalannfy 2/3 + C'           !9  
     +/'Model 9.   The Von Bertalannfy m-varied'          !10
     +/'Model 10. The Preece and Baines no. 1'            !11 
     +/                                                   !12
     +/'Select the type of output required for results'   !13
     +/'Display best fit parameters'                      !14
     +/'Display tables of residuals'                      !15
     +/'Write residuals to log-file'                      !16
     +/'Store/test parameters/covariance-matrix'          !17
     +/'Plot best-fit curves'                             !18  
     +/'Plot derivatives/transforms'                      !19  
     +/'Plot residuals'                                   !20 
     +/'Help'                                             !21
     +/'Exit')                                            !22
  200 FORMAT (
     + 'Select which survival models to fit to the current data'   !1
     +/'Model 1. The exponential model'                   !2  
     +/'Model 2. The Weibull model'                       !3
     +/'Model 3. The Gompertz model'                      !4 
     +/'Model 4. The Log-logistic model'                  !5
     +/'S(t = 0) Amplitude fixed at 1'                    !6
     +/                                                   !7  
     +/'Select the type of output required for results'   !8
     +/'Display best fit parameters'                      !9 
     +/'Display tables of residuals'                      !10
     +/'Write residuals to log-file'                      !11 
     +/'Store/test parameters/covariance-matrix'          !12
     +/'Plot best-fit curves'                             !13
     +/'Plot derivatives/transforms'                      !14 
     +/'Plot residuals'                                   !15                 
     +/'Help'                                             !16 
     +/'Exit')                                            !17
  300 FORMAT ('Insufficient data ... Model',I3,1X,'cancelled')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GOFFIT (ITIME, LWRK, NAUX, NBAD, NCMAX, NDOF, NF, NFLY,
     +                   NGRAF, NOPT, NPAR, NPTS, NTYPE,
     +                   AUX, AVRR, CV, PARAM, RTOL, SBIG, STAT, W,
     +                   WSSQ, XGRAF, XLOG, YABS, YLOG,
     +                   GROWTH, NOUT, OMIT, PLOT, WEIGHT)
      USE MODULE_GCFIT, ONLY : TIME_SUM, TIME_REVERSED
C
C Goodness of fit and call to graphics if required
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: LWRK, NAUX, NCMAX, NGRAF, NOPT
      INTEGER,          INTENT (IN)    :: ITIME, NBAD, NDOF, NF, NFLY,
     +                                    NPAR, NPTS, NTYPE
      DOUBLE PRECISION, INTENT (IN)    :: AUX(NAUX), CV(NCMAX,NCMAX),
     +                                    PARAM(NCMAX), RTOL
      DOUBLE PRECISION, INTENT (IN)    :: AVRR, SBIG, YABS, WSSQ
      DOUBLE PRECISION, INTENT (INOUT) :: STAT(NOPT,9), W(LWRK),
     +                                    XGRAF(NGRAF), XLOG(NGRAF),
     +                                    YLOG(NGRAF)
      LOGICAL,          INTENT (IN)    :: GROWTH, NOUT(4), OMIT(NOPT),
     +                                    PLOT(3), WEIGHT
C
C Locals
C      
      INTEGER    L0, L1, L2, L3, L5
      PARAMETER (L0 = 0, L1 = 1, L2 = 2, L3 = 3, L5 = 5)
      INTEGER    N1, N2, N3, N4, N5, N6
      INTEGER    I, IFAIL, ISEND, J, K, L
      INTEGER    NNEG, NPOS, NRUN, NR1, NR5
      INTEGER    ICOLOR, IXL, IYL
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4)
      INTEGER    COLOUR
      INTEGER    NUMDEC, NUMOPT, NUMPOS(5)
      DOUBLE PRECISION PNT01, PNT05, PNT95, PNT99
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00, PNT95 = 0.95D+00,
     +           PNT99 = 0.99D+00)
      DOUBLE PRECISION DMAX, DMIN, TWO, ZERO
      PARAMETER (DMAX = 1.0D+300, DMIN = - 1.0D+300, TWO = 2.0D+00, 
     +           ZERO = 0.0D+00)
      DOUBLE PRECISION CHI95, CHI99, PGCHI, PROBR, PROBS, PROBT,
     +                 VALUE(4)
      DOUBLE PRECISION DSDT, FMOD
      DOUBLE PRECISION G01ECF$, G01FCF$
      DOUBLE PRECISION DERIV(1), SVALUE, TIME(1), VAREST, X0(2), Y0(2)
      DOUBLE PRECISION DW, SSQ
      DOUBLE PRECISION AIC, DNDOF, DNPAR, DNPTS, PW, SC, WSTAT
      CHARACTER (LEN = 10) D10(5), FORM10 
      CHARACTER  SYMBOL(4)*31, WORD*4
      CHARACTER  PTITLE*31, RECORD(2)*10, XTITLE*20, YTITLE*20
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  MSSAGE*16
      CHARACTER (LEN = 10) VERDIC
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    GETVER, GRAPH
      PARAMETER (GETVER = .TRUE., GRAPH = .FALSE.)
      LOGICAL    AXES, SAVEIT, YES
      PARAMETER (AXES = .TRUE., SAVEIT = .TRUE.)
      LOGICAL    ACCEPT, REPEET
      EXTERNAL   E_FORMATS, FORM10
      EXTERNAL   PUTIFA, PROBRS, GKS004, YESNO2, LBOX02, TABLE1, GKSR03,
     +           PUTFAT, PUTADV, LISTBX, HNPLOT, PCVTST, GCF004, GKSR04
      EXTERNAL   G01ECF$, G01FCF$
      EXTERNAL   DSDT, FMOD
      INTRINSIC  SQRT, MAX, DBLE, LOG10, LOG, ABS
      DATA       NUMPOS / 5*1 /
      IF (OMIT(ITIME)) RETURN
C
C initialise
C
      E_NUMBERS = E_FORMATS()
      DNDOF = DBLE(NDOF)
      DNPAR = DBLE(NPAR)
      DNPTS = DBLE(NPTS)
      IF (WEIGHT) THEN
C
C Chi-square test
C
         IFAIL = 1
         PGCHI = G01ECF$('Upper-tail', WSSQ, DNDOF, IFAIL)
         CALL PUTIFA (IFAIL, NF, 'G01ECF/GOFFIT')
         IFAIL = 1
         CHI95 = G01FCF$(PNT95, DNDOF, IFAIL)
         CALL PUTIFA (IFAIL, NF, 'G01FCF/GOFFIT')
         IFAIL = 1
         CHI99 = G01FCF$(PNT99, DNDOF, IFAIL)
         CALL PUTIFA (IFAIL, NF, 'G01FCF/GOFFIT')
         WORD = 'wtd.'
      ELSE
C
C Variance estimate
C
         VAREST = SQRT(WSSQ/DNDOF)
         PGCHI = (100.0D+00*VAREST)/YABS
         WORD = 'the'
      ENDIF
      VALUE(1) = PGCHI
C
C Run test
C
      ISEND = 1
      I = 4*NPTS + 1
      CALL PROBRS (ISEND, NF, NNEG, NPOS, NPTS, NRUN, NR1, NR5, PROBR,
     +             PROBS, PROBT, W(I))
      VALUE(2) = PROBR
      VALUE(3) = PROBT
      VALUE(4) = PROBS
      DO I = 1, 4
         IF (VALUE(I).LT.PNT01) THEN
            SYMBOL(I) = 'Reject at 1% significance level'
         ELSEIF (VALUE(I).LT.PNT05) THEN
            SYMBOL(I) = 'Reject at 5% significance level'
         ELSE
            SYMBOL(I) = ' '
         ENDIF
      ENDDO
C
C Work out DW
C
      DW = ZERO
      J = 4*NPTS + 1
      SSQ = W(J)**2
      DO I = 1, NPTS - 1
         J = J + 1
         DW = DW + (W(J) - W(J - 1))**2
         SSQ = SSQ + W(J)**2
      ENDDO
      DW = DW/MAX(SSQ, RTOL)
      IF (DW.LT.1.5D+00) THEN
         PTITLE = '< 1.5, +ve serial correlation ?'
      ELSEIF (DW.LT.2.5D+00) THEN
         PTITLE = ' '
      ELSE
         PTITLE = '> 2.5, -ve serial correlation ?'
      ENDIF
C
C Shapiro Wilks
C
      J = 5*NPTS + 1
      CALL GKSR03 (NF, NPTS, PW, W(J), WSTAT, MSSAGE, ACCEPT)
C
C AIC and SC
C
      AIC = DNPTS*LOG(MAX(RTOL,WSSQ)) + TWO*DNPAR
      SC = DNPTS*LOG(MAX(RTOL,WSSQ)) + DNPAR*LOG(DNPTS)/TWO
C
C N1: W(        1 ->  NPTS) = E        ... in original coordinates
C N2: W( NPTS + 1 -> 2NPTS) = S        ...         ''
C N3: W(2NPTS + 1 -> 3NPTS) = T        ...         ''
C N4: W(3NPTS + 1 -> 4NPTS) = THEORY   ...         ''
C N5: W(4NPTS + 1 -> 5NPTS) = RESID    ...         ''
C N6: W(5NPTS + 1 -> 6NPTS) = WRESID   ...         ''
C W(6NPTS + 1 -> 7NPTS) = DSDT     ...         ''
C 
       N1 = 1
       N2 = NPTS + 1
       N3 = 2*NPTS + 1
       N4 = 3*NPTS + 1 
       N5 = 4*NPTS + 1
       N6 = 5*NPTS + 1
       CALL GKSR04 (NF, NPAR, NPTS,
     +              W(N5), W(N1), W(N4), W(N6), W(N3), W(N2), 
     +              VERDIC,
     +              GETVER, GRAPH)      
C
C Start output
C
      IF (WEIGHT) THEN
         IF (E_NUMBERS) THEN
            WRITE (NF,100) WSSQ, PGCHI, SYMBOL(1), CHI99, CHI95, NNEG,
     +                     NPOS, NRUN, PROBR, SYMBOL(2), NR1, NR5,
     +                     PROBT, SYMBOL(3), PROBS, SYMBOL(4), DW,
     +                     PTITLE, WSTAT, PW, MSSAGE, AIC, SC, VERDIC
         ELSE
            D10(1) = FORM10(WSSQ)
            D10(2) = FORM10(CHI99)
            D10(3) = FORM10(CHI95)
            D10(4) = FORM10(AIC)
            D10(5) = FORM10(SC) 
            WRITE (NF,150) D10(1), PGCHI, SYMBOL(1), D10(2), D10(3),
     +                     NNEG, NPOS, NRUN, PROBR, SYMBOL(2), NR1, NR5,
     +                     PROBT, SYMBOL(3), PROBS, SYMBOL(4), DW,
     +                     PTITLE, WSTAT, PW, MSSAGE, D10(4), D10(5),
     +                     VERDIC

         ENDIF  
      ELSE
         IF (E_NUMBERS) THEN
            WRITE (NF,200) WSSQ, VAREST, YABS, PGCHI, NNEG, NPOS, NRUN,
     +                     PROBR, SYMBOL(2), NR1, NR5, PROBT, SYMBOL(3),
     +                     PROBS, SYMBOL(4), DW, PTITLE,
     +                     WSTAT, PW, MSSAGE, AIC, SC, VERDIC
         ELSE
            D10(1) = FORM10(WSSQ)
            D10(2) = FORM10(VAREST)
            D10(3) = FORM10(YABS)
            D10(4) = FORM10(AIC)
            D10(5) = FORM10(SC) 
            WRITE (NF,250) D10(1), D10(2), D10(3), PGCHI, NNEG,
     +                     NPOS, NRUN, PROBR, SYMBOL(2), NR1, NR5,
     +                     PROBT, SYMBOL(3), PROBS, SYMBOL(4), DW,
     +                     PTITLE,  WSTAT, PW, MSSAGE, D10(4), D10(5),
     +                     VERDIC
         ENDIF  
      ENDIF
      IF (NOUT(1)) THEN
         IF (WEIGHT) THEN
            IF (E_NUMBERS) THEN
               WRITE (TEXT,100) WSSQ,PGCHI,SYMBOL(1),CHI99,CHI95,NNEG,
     +                          NPOS,NRUN,PROBR,SYMBOL(2),NR1,NR5,
     +                          PROBT,SYMBOL(3),PROBS,SYMBOL(4),DW,
     +                          PTITLE,WSTAT, PW, MSSAGE, AIC, SC,
     +                          VERDIC
            ELSE
               D10(1) = FORM10(WSSQ)
               D10(2) = FORM10(CHI99)
               D10(3) = FORM10(CHI95)
               D10(4) = FORM10(AIC)
               D10(5) = FORM10(SC) 
               WRITE (TEXT,150) D10(1), PGCHI, SYMBOL(1), D10(2),
     +                          D10(3), NNEG, NPOS, NRUN, PROBR,
     +                          SYMBOL(2), NR1, NR5, PROBT, SYMBOL(3),
     +                          PROBS, SYMBOL(4), DW, PTITLE, WSTAT, PW, 
     +                          MSSAGE, D10(4), D10(5), VERDIC

            ENDIF  
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (TEXT,200) WSSQ,VAREST,YABS,PGCHI,NNEG,NPOS,NRUN,
     +                          PROBR,SYMBOL(2),NR1,NR5,PROBT,SYMBOL(3),
     +                          PROBS,SYMBOL(4),DW,PTITLE,
     +                          WSTAT, PW, MSSAGE, AIC, SC, VERDIC
            ELSE
               D10(1) = FORM10(WSSQ)
               D10(2) = FORM10(VAREST)
               D10(3) = FORM10(YABS)
               D10(4) = FORM10(AIC)
               D10(5) = FORM10(SC) 
               WRITE (TEXT,250) D10(1), D10(2), D10(3), PGCHI,
     +                          NNEG, NPOS, NRUN, PROBR, SYMBOL(2), NR1,
     +                          NR5, PROBT, SYMBOL(3), PROBS, SYMBOL(4), 
     +                          DW, PTITLE,  WSTAT, PW, MSSAGE, D10(4),
     +                          D10(5), VERDIC
            ENDIF  
         ENDIF
         COLOUR = 0
         DO I = 1, 17
            CALL TABLE1 (COLOUR, TEXT(I))
         ENDDO
         COLOUR = 4
         CALL TABLE1 (COLOUR, TEXT(18))
      ENDIF
C
C Close the output results display TABLE1
C      
      IF (NOUT(1) .OR. NOUT(2)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF   
      
      X0(1) = W(2*NPTS + 1)
      X0(2) = W(3*NPTS)
      Y0(1) = SBIG
      Y0(2) = SBIG
      L = 0
C
C Graphics: If short output then just ask if S(t) is required
C
      IF (PLOT(1) .AND. .NOT.PLOT(2)) THEN
         IF (PLOT(2)) THEN                              ! 06/11/2023 Nonsense code to prevent 
            WRITE (LINE,300) ITIME                      !            the need to ask if  
            YES = .TRUE.                                !            only S(t) -s required
            CALL YESNO2 (ICOLOR, IXL, IYL, LINE, YES)   !            * 
         ELSE                                           !            * 
            YES = .TRUE.                       
         ENDIF                                          !            *
         IF (YES) THEN
            J = 6*NPTS
            DO I = 1, NGRAF
               W(J + I) = FMOD(NPAR, NAUX, PARAM, AUX, XGRAF(I))
            ENDDO
            PTITLE = 'Data and best-fit curve'
            IF (GROWTH) THEN
               IF (SBIG.GT.ZERO) L = 2
               YTITLE = 'Size'
            ELSE
               YTITLE = 'Fraction Surviving'
            ENDIF
            I = 2*NPTS + 1
            J = NPTS + 1
            K = 6*NPTS + 1
            IF (TIME_REVERSED) THEN
               XTITLE = 'Actual Time'
               CALL GCF004 (L0, L1, L, L0,
     +                      L5, L0, L0, L0,
     +                      NPTS, NGRAF, L2, NGRAF,
     +                      TIME_SUM,
     +                      W(I), XGRAF, X0, XGRAF,
     +                      W(J), W(K), Y0, W(K),
     +                      PTITLE, XTITLE, YTITLE,
     +                      AXES, SAVEIT)
            ELSE
               XTITLE = 'Time'
               CALL GKS004 (L0, L1, L, L0,
     +                      L5, L0, L0, L0,
     +                      NPTS, NGRAF, L2, NGRAF,
     +                      W(I), XGRAF, X0, XGRAF,
     +                      W(J), W(K), Y0, W(K),
     +                      PTITLE, XTITLE, YTITLE,
     +                      AXES, SAVEIT)
            ENDIF
         ENDIF
      ENDIF
C
C Graphics: If full output required ask for type
C
      IF (PLOT(1) .AND. PLOT(2)) THEN
   20    CONTINUE
         IF (GROWTH) THEN
            NUMOPT = 4
            WRITE (TEXT,400)
         ELSE
            NUMOPT = 5
            WRITE (TEXT,500)
         ENDIF
         ISEND = 1
         CALL LBOX02 (ICOLOR, IXL, IYL, ISEND, NUMOPT, NUMPOS, 
     +                TEXT)
         IF (ISEND.EQ.1) THEN
C
C Plot S(t)
C
            J = 6*NPTS
            DO I = 1, NGRAF
               W(J + I) = FMOD(NPAR, NAUX, PARAM, AUX, XGRAF(I))
            ENDDO
            PTITLE = 'Data and best-fit curve'
            IF (GROWTH) THEN
               IF (SBIG.GT.ZERO) L = 2
               YTITLE = 'Size'
            ELSE
               YTITLE = 'Fraction Surviving'
            ENDIF
            I = 2*NPTS + 1
            J = NPTS + 1
            K = 6*NPTS + 1
            IF (TIME_REVERSED) THEN
               XTITLE = 'Actual Time'
               CALL GCF004 (L0, L1, L, L0,
     +                      L5, L0, L0, L0,
     +                      NPTS, NGRAF, L2, NGRAF,
     +                      TIME_SUM,
     +                      W(I), XGRAF, X0, XGRAF,
     +                      W(J), W(K), Y0, W(K),
     +                      PTITLE, XTITLE, YTITLE,
     +                      AXES, SAVEIT)
            ELSE
               XTITLE = 'Time'
               CALL GKS004 (L0, L1, L, L0,
     +                      L5, L0, L0, L0,
     +                      NPTS, NGRAF, L2, NGRAF,
     +                      W(I), XGRAF, X0, XGRAF,
     +                      W(J), W(K), Y0, W(K),
     +                      PTITLE, XTITLE, YTITLE,
     +                      AXES, SAVEIT)
            ENDIF
            GOTO 20
         ELSEIF (ISEND.EQ.2) THEN
C
C Plot dS/dt
C
            IF (TIME_REVERSED) THEN
               DERIV(1) = DMAX
            ELSE     
               DERIV(1) = DMIN
            ENDIF   
            J = 6*NPTS
            DO I = 1, NGRAF
               K = J + I
               SVALUE = FMOD(NPAR, NAUX, PARAM, AUX, XGRAF(I))
               W(K) = DSDT(NPAR, PARAM, SVALUE, XGRAF(I))
               IF (TIME_REVERSED) THEN  
                  W(K) = - W(K)
                  IF (W(K).LT.DERIV(1)) THEN
                     DERIV(1) = W(K)
                     TIME(1) = XGRAF(I)
                   ENDIF
                ELSE   
                   IF (NTYPE.EQ.2) W(K) = - W(K)
                   IF (W(K).GT.DERIV(1)) THEN
                     DERIV(1) = W(K)
                     TIME(1) = XGRAF(I)
                   ENDIF
                ENDIF   
            ENDDO
            IF (TIME_REVERSED) THEN
               WRITE (RECORD(1),'(1P,E10.3)') TIME_SUM - TIME(1)
               WRITE (RECORD(2),'(1P,E10.3)') DERIV(1)
               PTITLE = 'Min. at '//RECORD(1)//','//RECORD(2)
               XTITLE = 'Actual Time'
            ELSE   
               WRITE (RECORD(1),'(1P,E10.3)') TIME(1)
               WRITE (RECORD(2),'(1P,E10.3)') DERIV(1)
               PTITLE = 'Max. at '//RECORD(1)//','//RECORD(2)
               XTITLE = 'Time'
            ENDIF
            IF (GROWTH) THEN
               IF (TIME_REVERSED) THEN
                  YTITLE = 'Decay Rate (dS/dt)'
               ELSE   
                  YTITLE = 'Growth Rate (dS/dt)'
               ENDIF   
            ELSE
               YTITLE = 'pdf (f(t) = -dS/dt)'
            ENDIF
            K = 6*NPTS + 1
            IF (TIME_REVERSED) THEN
               CALL GCF004 (L1, L0, L0, L0,
     +                      L0, L3, L0, L0,
     +                      NGRAF, L1, L1, L1,
     +                      TIME_SUM, 
     +                      XGRAF, TIME, TIME, TIME,
     +                      W(K), DERIV, DERIV, DERIV,
     +                      PTITLE, XTITLE, YTITLE,
     +                      AXES, SAVEIT)
           ELSE
               CALL GKS004 (L1, L0, L0, L0,
     +                      L0, L3, L0, L0,
     +                      NGRAF, L1, L1, L1,
     +                      XGRAF, TIME, TIME, TIME, 
     +                      W(K), DERIV, DERIV, DERIV,
     +                      PTITLE, XTITLE, YTITLE,
     +                      AXES, SAVEIT)
            ENDIF
            GOTO 20
         ELSEIF (ISEND.EQ.3) THEN
            IF (GROWTH) THEN
C
C Plot (1/S)dS/dt
C
               IF (ITIME.EQ.1) THEN
                  CALL PUTADV ('(1/S)dS/dt = -k for this model')
                  GOTO 20
               ENDIF
               IF (TIME_REVERSED) THEN
                  DERIV(1) = DMAX
               ELSE   
                  DERIV(1) = DMIN
               ENDIF
               J = 6*NPTS
               DO I = 1, NGRAF
                  K = J + I
                  SVALUE = FMOD(NPAR, NAUX, PARAM, AUX, XGRAF(I))
                  IF (ABS(SVALUE).LE.RTOL) THEN
                     CALL PUTFAT ('S value too small for 1/S')
                     GOTO 20
                  ENDIF
                  W(K) = DSDT(NPAR, PARAM, SVALUE, XGRAF(I))
                  W(K) = W(K)/SVALUE
                  IF (TIME_REVERSED) THEN
                     W(K) = - W(K)
                     IF (W(K).LT.DERIV(1)) THEN
                        DERIV(1) = W(K)
                        TIME(1) = XGRAF(I)
                     ENDIF
                  ELSE    
                     IF (W(K).GT.DERIV(1)) THEN
                        DERIV(1) = W(K)
                        TIME(1) = XGRAF(I)
                     ENDIF
                  ENDIF    
               ENDDO
               IF (TIME_REVERSED) THEN
                  WRITE (RECORD(1),'(1P,E10.3)') TIME_SUM - TIME(1)
                  WRITE (RECORD(2),'(1P,E10.3)') DERIV(1)
                  PTITLE = 'Min. at '//RECORD(1)//','//RECORD(2)
                  XTITLE = 'Actual Time'
               ELSE   
                  WRITE (RECORD(1),'(1P,E10.3)') TIME(1)
                  WRITE (RECORD(2),'(1P,E10.3)') DERIV(1)
                  PTITLE = 'Max. at '//RECORD(1)//','//RECORD(2)
                  XTITLE = 'Time'
               ENDIF   
               YTITLE = 'Rel. Rate (1/S)dS/dt'
               K = 6*NPTS + 1
               IF (TIME_REVERSED) THEN
                  CALL GCF004 (L1, L0, L0, L0,
     +                         L0, L3, L0, L0,
     +                         NGRAF, L1, L1, L1,
     +                         TIME_SUM,
     +                         XGRAF, TIME, TIME, TIME,
     +                         W(K), DERIV, DERIV, DERIV,
     +                         PTITLE, XTITLE, YTITLE, 
     +                         AXES, SAVEIT)
                ELSE 
                   CALL GKS004 (L1, L0, L0, L0,
     +                         L0, L3, L0, L0,
     +                         NGRAF, L1, L1, L1,
     +                         XGRAF, TIME, TIME, TIME,
     +                         W(K), DERIV, DERIV, DERIV,
     +                         PTITLE, XTITLE, YTITLE, 
     +                         AXES, SAVEIT)
               ENDIF 
            ELSEIF (NTYPE.EQ.2) THEN
C
C Plot h(t)
C
               DERIV(1) = DMIN
               J = 6*NPTS
               DO I = 1, NGRAF
                  K = J + I
                  SVALUE = FMOD(NPAR, NAUX, PARAM, AUX, XGRAF(I))
                  W(K) = - DSDT(NPAR, PARAM, SVALUE, XGRAF(I))/SVALUE
                  IF (W(K).GT.DERIV(1)) THEN
                     DERIV(1) = W(K)
                     TIME(1) = XGRAF(I)
                  ENDIF
               ENDDO
               WRITE (RECORD(1),'(1P,E10.3)') TIME(1)
               WRITE (RECORD(2),'(1P,E10.3)') DERIV(1)
               PTITLE = 'Max. at '//RECORD(1)//','//RECORD(2)
               XTITLE = 'Time'
               YTITLE = 'Hazard [-(dS/dt)/S]'
               K = 6*NPTS + 1
               CALL GKS004 (L1, L0, L0, L0, L0, L3, L0, L0,
     +                      NGRAF, L1, L1, L1,
     +                      XGRAF, TIME, TIME, TIME, W(K), DERIV, DERIV,
     +                      DERIV, PTITLE, XTITLE, YTITLE,
     +                      AXES, SAVEIT)
            ENDIF
            GOTO 20
         ELSEIF (ISEND.EQ.4 .AND. NTYPE.EQ.2) THEN
C
C Plot log[h(t)]
C
            DERIV(1) = DMIN
            J = 6*NPTS
            IFAIL = 0
            DO I = 1, NGRAF
               K = J + I
               SVALUE = FMOD(NPAR, NAUX, PARAM, AUX, XGRAF(I))
               W(K) = - DSDT(NPAR, PARAM, SVALUE, XGRAF(I))/SVALUE
               IF (W(K).GT.RTOL) THEN
                  IFAIL = IFAIL + 1
                  YLOG(IFAIL) = LOG10(W(K))
                  XLOG(IFAIL) = XGRAF(I)
                  IF (YLOG(IFAIL).GT.DERIV(1)) THEN
                     DERIV(1) = YLOG(IFAIL)
                     TIME(1) = XLOG(IFAIL)
                  ENDIF
               ENDIF
            ENDDO
            WRITE (RECORD(1),'(1P,E10.3)') TIME(1)
            WRITE (RECORD(2),'(1P,E10.3)') DERIV(1)
            PTITLE = 'Max. at '//RECORD(1)//','//RECORD(2)
            XTITLE = 'Time'
            YTITLE = 'log(10)[-(dS/dt)/S]'
            K = 6*NPTS + 1
            CALL GKS004 (L1, L0, L0, L0, L0, L3, L0, L0,
     +                   IFAIL, L1, L1, L1,
     +                   XLOG, TIME, TIME, TIME, YLOG, DERIV, DERIV,
     +                   DERIV, PTITLE, XTITLE, YTITLE,
     +                   AXES, SAVEIT)
            GOTO 20
         ENDIF
      ENDIF
C
C Graphics: Residuals plots
C
      IF (PLOT(3)) THEN
         IF (WEIGHT) THEN
            WRITE (TEXT,600) WORD, WORD, WORD
         ELSE   
            WRITE (TEXT,700) 
         ENDIF   
         NUMOPT = 5
         REPEET = .TRUE.
         DO WHILE (REPEET)
            NUMDEC = NUMOPT
            CALL LISTBX (NUMDEC, NUMOPT,
     +                   TEXT)
            IF (NUMDEC.EQ.1) THEN        
               Y0(1) = ZERO
               Y0(2) = ZERO
               I = 2*NPTS + 1
               J = 4*NPTS + 1
               K = 3*NPTS
               X0(1) = W(I)
               X0(2) = W(K)
               PTITLE = 'Residuals Against Time'
               YTITLE = 'Residuals'
               IF (TIME_REVERSED) THEN
                  XTITLE = 'Actual Time'
                  CALL GCF004 (L0, L3, L0, L0,
     +                         L3, L0, L0, L0,
     +                         NPTS, L2, L2, L2,
     +                         TIME_SUM,
     +                         W(I), X0, X0, X0,
     +                         W(J), Y0, Y0, Y0,
     +                         PTITLE, XTITLE, YTITLE, 
     +                         AXES, SAVEIT)
               ELSE
                  XTITLE = 'Time'
                  CALL GKS004 (L0, L3, L0, L0,
     +                         L3, L0, L0, L0,
     +                         NPTS, L2, L2, L2,
     +                         W(I), X0, X0, X0,
     +                         W(J), Y0, Y0, Y0,
     +                         PTITLE, XTITLE, YTITLE, 
     +                         AXES, SAVEIT)
               ENDIF
            ELSEIF (NUMDEC.EQ.2) THEN
               I = 3*NPTS + 1
               X0(1) = W(I)
               X0(2) = W(I)
               J = I - 1
               DO I = 1, NPTS
                  J = J + 1
                  IF (W(J).LT.X0(1)) X0(1) = W(J)
                  IF (W(J).GT.X0(2)) X0(2) = W(J)
               ENDDO
               I = 3*NPTS + 1
               J = 5*NPTS + 1
               IF (WEIGHT) THEN
                  PTITLE = 'Wtd. Residuals Against Best-Fit'
                  YTITLE = 'Wtd. Residuals'
               ELSE
                  PTITLE = 'Residuals Against Best-Fit'
                  YTITLE = 'Residuals'
               ENDIF
               XTITLE = 'Theory'
               CALL GKS004 (L0, L3, L0, L0,
     +                      L3, L0, L0, L0,
     +                      NPTS, L2, L2, L2,
     +                      W(I), X0, X0, X0,
     +                      W(J), Y0, Y0, Y0,
     +                      PTITLE, XTITLE, YTITLE, 
     +                      AXES, SAVEIT)
            ELSEIF (NUMDEC.EQ.3) THEN
               I = 1
               J = 5*NPTS + 1
               CALL HNPLOT (I, NPTS,
     +                      W(J))
            ELSEIF (NUMDEC.EQ.4) THEN
               I = 2
               J = 5*NPTS + 1
               CALL HNPLOT (I, NPTS,
     +                      W(J) )
            ELSE
               REPEET = .FALSE.
            ENDIF                           
         ENDDO
      ENDIF
C
C Now store all the important statistics for subroutine SUMMIT
C
      STAT(ITIME,1) = WSSQ
      STAT(ITIME,2) = NDOF
      STAT(ITIME,3) = PGCHI
      STAT(ITIME,4) = PROBR
      STAT(ITIME,5) = NBAD
      STAT(ITIME,6) = NFLY
      STAT(ITIME,7) = STAT(ITIME,5)/DBLE(NPTS)
      STAT(ITIME,8) = AVRR
      STAT(ITIME,9) = PW
C
C Call PCVTST
C
      IF (NOUT(4)) THEN
         I = 1
         CALL PCVTST (I, NF, NPAR, NPTS, NCMAX,
     +                CV, PARAM)
      ENDIF            
C
C Format statements
C      
  100 FORMAT (1X,'Weighted sum of squares WSSQ  =',1P,E13.5
     +/1X,'p = P(chi-sq. >= WSSQ)        =',0P,F8.4,7X,A31
     +/1X,'1% upper tail chi-sq. value   =',1P,E13.5
     +/1X,'5% upper tail chi-sq. value   =',   E13.5
     +/1X,'No. of negative residuals (m) =',I6
     +/1X,'No. of positive residuals (n) =',I6
     +/1X,'No. of runs observed (r)      =',I6
     +/1X,'p = P(runs =< r given m & n)  =',0P,F8.4,7X,A31
     +/1X,'1% lower tail critical value  =',I6
     +/1X,'5% lower tail critical value  =',I6
     +/1X,'p = P(runs =< r  given m + n) =',   F8.4,7X,A31
     +/1X,'p = P(signs =< obs.) (2 tail) =',   F8.4,7X,A31
     +/1X,'Durbin-Watson test statistic  =',   F8.4,7X,A31
     +/1X,'Shapiro-Wilks W (wtd. res.)   =',   F8.4
     +/1X,'Significance level of W       =',   F8.4,7X,A
     +/1X,'Akaike AIC statistic          =',1P,E13.5
     +/1X,'Schwarz SC statistic          ='   ,E13.5
     +/1X,'Verdict on goodness of fit    =',1X,A)
  150 FORMAT (1X,'Weighted sum of squares WSSQ  =',1X,A10
     +/1X,'p = P(chi-sq. >= WSSQ)        =',0P,F8.4,7X,A31
     +/1X,'1% upper tail chi-sq. value   =',1X,A10
     +/1X,'5% upper tail chi-sq. value   =',1X,A10
     +/1X,'Number of residuals < 0 (m)   =',I6
     +/1X,'Number of residuals >= 0  (n) =',I6
     +/1X,'Number of runs observed (r)   =',I6
     +/1X,'p = P(runs =< r given m & n)  =',0P,F8.4,7X,A31
     +/1X,'1% lower tail critical value  =',I6
     +/1X,'5% lower tail critical value  =',I6
     +/1X,'p = P(runs =< r  given m + n) =',   F8.4,7X,A31
     +/1X,'p = P(signs =< obs.) (2 tail) =',   F8.4,7X,A31
     +/1X,'Durbin-Watson test statistic  =',   F8.4,7X,A31
     +/1X,'Shapiro-Wilks W (wtd. res.)   =',   F8.4
     +/1X,'Significance level of W       =',   F8.4,7X,A
     +/1X,'Akaike AIC statistic          =',1X,A10
     +/1X,'Schwarz SC statistic          =',1X,A10
     +/1X,'Verdict on goodness of fit    =',1X,A)

  200 FORMAT (1X,'Unweighted sum of squares SSQ =',1P,E13.5
     +/1X,'Best-fit variance estimate    =',   E13.5
     +/1X,'Sample average of size values =',   E13.5
     +/1X,'Estimated average coeff.var.% =',0P,F11.4
     +/1X,'No. of negative residuals (m) =',I6
     +/1X,'No. of positive residuals (n) =',I6
     +/1X,'No. of runs observed (r)      =',I6
     +/1X,'p = P(runs =< r given m & n)  =',0P,F8.4,7X,A31
     +/1X,'1% lower tail critical value  =',I6
     +/1X,'5% lower tail critical value  =',I6
     +/1X,'p = P(runs =< r given m + n)  =',   F8.4,7X,A31
     +/1X,'p = P(signs =< obs.) (2 tail) =',   F8.4,7X,A31
     +/1X,'Durbin-Watson test statistic  =',   F8.4,7X,A31
     +/1X,'Shapiro-Wilks W (wtd. res.)   =',   F8.4
     +/1X,'Significance level of W       =',   F8.4,7X,A
     +/1X,'Akaike AIC statistic          =',1P,E13.5
     +/1X,'Schwarz SC statistic          ='   ,E13.5
     +/1X,'Verdict on goodness of fit    =',1X,A)
  250 FORMAT (1X,'Unweighted sum of squares SSQ =',1X,A10
     +/1X,'Best-fit variance estimate    =',1X,A10
     +/1X,'Sample average of size values =',1X,A10
     +/1X,'Estimated average coeff.var.% =',0P,F11.4
     +/1X,'Nunber of residuals < 0 (m)   =',I6
     +/1X,'Number of residuals >= 0  (n) =',I6
     +/1X,'Number of runs observed (r)   =',I6
     +/1X,'p = P(runs =< r given m & n)  =',0P,F8.4,7X,A31
     +/1X,'1% lower tail critical value  =',I6
     +/1X,'5% lower tail critical value  =',I6
     +/1X,'p = P(runs =< r given m + n)  =',   F8.4,7X,A31
     +/1X,'p = P(signs =< obs.) (2 tail) =',   F8.4,7X,A31
     +/1X,'Durbin-Watson test statistic  =',   F8.4,7X,A31
     +/1X,'Shapiro-Wilks W (wtd. res.)   =',   F8.4
     +/1X,'Significance level of W       =',   F8.4,7X,A
     +/1X,'Akaike AIC statistic          =',1X,A10
     +/1X,'Schwarz SC statistic          =',1X,A10
     +/1X,'Verdict on goodness of fit    =',1X,A)
     
  300 FORMAT ('Plot best-fit S(t) curve for model',I3,' ?')
  400 FORMAT ('Plot S(t) [data and best fit curve]'
     +/'Plot dS/dt [just best fit curve]'
     +/'Plot (1/S)dS/dt [relative rate d(logS)/dt]'
     +/'Cancel')
  500 FORMAT ('Plot S(t) [data and best fit curve]'
     +/'Plot f(t) [just best fit curve]'
     +/'Plot h(t) [just best fit curve]'
     +/'Plot log(h) [just best fit curve]'
     +/'Cancel')
  600 FORMAT (
     + 'Plot residuals against time'
     +/'Plot',1X,A4,1X,'residuals against theory'
     +/'Half-normal',1X,A4,1X,'residuals plot'
     +/'Full-normal',1X,A4,1X,'residuals plot'
     +/'Cancel')        
  700 FORMAT (
     + 'Plot residuals against time'
     +/'Plot residuals against theory'
     +/'Half-normal residuals plot'
     +/'Full-normal residuals plot'
     +/'Cancel')
 
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE LMFUNC (M, N, X, FVEC, FJAC, LDFJAC, IFLAG)
C
C ACTION : Subroutine for MINPACK
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 26/8/97
C
      IMPLICIT NONE
      INTEGER  IFLAG, LDFJAC, M, N
      DOUBLE PRECISION FVEC(M), FJAC(LDFJAC,N), X(N)
      EXTERNAL LSFUN1, LSJAC1
      IF (IFLAG.EQ.1) THEN
         CALL LSFUN1 (M, N, X, FVEC)
      ELSEIF (IFLAG.EQ.2) THEN
         CALL LSJAC1 (M, N, LDFJAC, X, FJAC)
      ENDIF
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE LSFUN1 (M, N, XC, FVECC)
C
C Subroutine for E04FDF (Note use of array AUX)
C
      USE MODULE_GCFIT
      IMPLICIT   NONE
      INTEGER    M, N
      INTEGER    I
      DOUBLE PRECISION FVECC(M), XC(N)
      DOUBLE PRECISION ZERO, ONE, ONETHD
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, ONETHD = ONE/3.0D+00)
      DOUBLE PRECISION FMOD, FCNVAL, TEMP
      EXTERNAL  FMOD
      INTRINSIC ABS
      IF (GROWTH) THEN
         IF (ITIME.EQ.5 .OR. ITIME.EQ.8) THEN
            IF (ABS(XC(2)).GT.RTOL) THEN
               AUX(1) = XC(1)/XC(2)
            ELSEIF (XC(2).GE.ZERO) THEN
               AUX(1) = XC(1)/RTOL
            ELSE
               AUX(1) = - XC(1)/RTOL
            ENDIF
            IF (XC(3).GT.RTOL) THEN
               AUX(2) = AUX(1) - XC(3)**ONETHD
            ELSE
               AUX(2) = AUX(1) + ABS(XC(3))**ONETHD
            ENDIF
            AUX(3) = ONETHD*XC(2)
         ELSEIF (ITIME.EQ.9) THEN
            TEMP = ONE - XC(4)
            IF (ABS(TEMP).LE.EPSI) THEN
               IF (TEMP.LE.ZERO) THEN
                  TEMP = - EPSI
               ELSE
                  TEMP = EPSI
               ENDIF
            ENDIF
            IF (XC(1).GT.ZERO) THEN
               AUX(1) = XC(1)**TEMP
            ELSE
               AUX(1) = - ABS(XC(1))**TEMP
            ENDIF
            IF (TEMP.LT.ZERO) THEN
               AUX(2) = - ABS(XC(2))
            ELSE
               AUX(2) = ABS(XC(2))
            ENDIF
            AUX(3) = ONE/TEMP
         ENDIF
      ENDIF
      DO I = 1, M
         IF (.NOT.EQUAL(I)) FCNVAL = FMOD(N, NAUX, XC, AUX, TN(I))
         FVECC(I) = (SN(I) - FCNVAL)/EN(I)
      ENDDO
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE LSJAC1 (M, N, NRMAX, XC, FJACC)
C
C Subroutine for LMFIT1 (Note use of array AUX)
C
      USE MODULE_GCFIT
      IMPLICIT   NONE
      INTEGER    M, N, NRMAX
      INTEGER    I, J
      DOUBLE PRECISION FJACC(NRMAX,N), XC(N)
      DOUBLE PRECISION ZERO, ONE, ONETHD
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, ONETHD = ONE/3.0D+00)
      DOUBLE PRECISION Z(20)
      DOUBLE PRECISION TEMP
      EXTERNAL  FJAC
      INTRINSIC ABS
      IF (GROWTH) THEN
         IF (ITIME.EQ.5 .OR. ITIME.EQ.8) THEN
            IF (ABS(XC(2)).GT.RTOL) THEN
               AUX(1) = XC(1)/XC(2)
            ELSEIF (XC(2).GE.ZERO) THEN
               AUX(1) = XC(1)/RTOL
            ELSE
               AUX(1) = - XC(1)/RTOL
            ENDIF
            IF (XC(3).GT.RTOL) THEN
               AUX(2) = AUX(1) - XC(3)**ONETHD
            ELSE
               AUX(2) = AUX(1) - XC(3)
            ENDIF
            AUX(3) = ONETHD*XC(2)
         ELSEIF (ITIME.EQ.9) THEN
            TEMP = ONE - XC(4)
            IF (ABS(TEMP).LE.EPSI) THEN
               IF (TEMP.LE.0) THEN
                  TEMP = - EPSI
               ELSE
                  TEMP = EPSI
               ENDIF
            ENDIF
            AUX(1) = ABS(XC(1))**TEMP
            IF (TEMP.LT.ZERO) THEN
               AUX(2) = - ABS(XC(2))
            ELSE
               AUX(2) = ABS(XC(2))
            ENDIF
            AUX(3) = ONE/TEMP
         ENDIF
      ENDIF
      DO I = 1, M
         IF (.NOT.EQUAL(I)) CALL FJAC (N, NAUX, XC, AUX, TN(I), Z)
         DO J = 1, N
            FJACC(I,J) = - Z(J)/EN(I)
         ENDDO
      ENDDO
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE SUMMIT (NF, NOPT,
     +                   STAT,
     +                   OMIT, WEIGHT)
C
C Sum it all up
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NF, NOPT
      DOUBLE PRECISION, INTENT (IN) :: STAT(NOPT,9)
      LOGICAL,          INTENT (IN) :: OMIT(NOPT), WEIGHT
C
C locals
C      
      INTEGER    I, NBAD, NDOF, NFLY, NSCORE
      INTEGER    COLOUR
      DOUBLE PRECISION AVRRPC, PGCHI, PROB, VAREST, WSSQ
      CHARACTER  SYMBOL*7, VERDIC(11)*10, WORD*1
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER (LEN = 13) D13(2), SHOWRJ
      LOGICAL    E_FORMATS, E_NUMBERS
      EXTERNAL   E_FORMATS, TABLE1, SHOWRJ
      INTRINSIC  NINT
      DATA VERDIC / '  Terrible',
     +              ' Very  bad',
     +              '       Bad',
     +              ' Very poor',
     +              '      Poor',
     +              '      Fair',
     +              '      Good',
     +              ' Very good',
     +              ' Excellent',
     +              ' Fantastic',
     +              'Incredible' /
      E_NUMBERS = E_FORMATS()
      IF (WEIGHT) THEN
         SYMBOL = 'P(C>=W)'
         WORD = 'W'
      ELSE
         SYMBOL = ' Av.cv%'
         WORD = ' '
      ENDIF
      COLOUR = 15
      CALL TABLE1 (COLOUR, 'OPEN')
      WRITE (NF,100) WORD, WORD, SYMBOL
      WRITE (TEXT,100) WORD, WORD, SYMBOL
      COLOUR = 4
      DO I = 1, 5
         CALL TABLE1 (COLOUR, TEXT(I))
      ENDDO
      COLOUR = 0
      DO I = 1, NOPT
         IF (.NOT.OMIT(I)) THEN
            NSCORE = 1
            IF (WEIGHT) THEN
               IF (STAT(I,3).GT.0.01D+00) NSCORE = NSCORE + 1
               IF (STAT(I,3).GT.0.05D+00) NSCORE = NSCORE + 1
            ELSE
               IF (STAT(I,3).LT.10.0D+00) NSCORE = NSCORE + 1
               IF (STAT(I,3).LT.20.0D+00) NSCORE = NSCORE + 1
            ENDIF
            IF (STAT(I,4).GT.0.01D+00) NSCORE = NSCORE + 1
            IF (STAT(I,4).GT.0.05D+00) NSCORE = NSCORE + 1
            IF (STAT(I,6).LT.1.00D+00) NSCORE = NSCORE + 1
            IF (STAT(I,7).LT.0.10D+00) NSCORE = NSCORE + 1
            IF (STAT(I,7).LT.0.25D+00) NSCORE = NSCORE + 1
            IF (STAT(I,8).LT.0.05D+00) NSCORE = NSCORE + 1
            IF (STAT(I,8).LT.0.10D+00) NSCORE = NSCORE + 1
            IF (STAT(I,9).GT.0.05D+00) NSCORE = NSCORE + 1
            WSSQ = STAT(I,1)
            NDOF = NINT(STAT(I,2))
            VAREST = STAT(I,1)/STAT(I,2)
            PGCHI = STAT(I,3)
            PROB = STAT(I,4)
            NBAD = NINT(STAT(I,5))
            NFLY = NINT(STAT(I,6))
            AVRRPC = 100.0D+00*STAT(I,8)
            
            IF (E_NUMBERS) THEN
               WRITE (LINE,200) I,WSSQ,NDOF,VAREST,PGCHI,PROB,NBAD,
     +                          NFLY,AVRRPC,VERDIC(NSCORE)
               WRITE (NF,200) I, WSSQ, NDOF, VAREST, PGCHI, PROB, NBAD,
     +                        NFLY, AVRRPC, VERDIC(NSCORE)
            ELSE
               D13(1) = SHOWRJ(WSSQ)
               D13(2) = SHOWRJ(VAREST)
               WRITE (LINE,300) I,D13(1),NDOF,D13(2),PGCHI,PROB,NBAD,
     +                          NFLY,AVRRPC,VERDIC(NSCORE)
               WRITE (NF,300) I, D13(1),NDOF,D13(2),PGCHI,PROB,NBAD,
     +                        NFLY,AVRRPC,VERDIC(NSCORE)
            ENDIF
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
      ENDDO
      CALL TABLE1 (COLOUR, 'CLOSE')
C
C Format statements
C      
  100 FORMAT (/1X,'Summary'//1X,'Model',3X,A1,'SSQ',4X,'NDOF',4X,A1,
     +'SSQ/NDOF',3X,A7,2X,'P(R=<r)  NR>10%  NR>40%  Av.r%',4X,
     +'Verdict'/)
  200 FORMAT (I2,1X,1P,E13.5,I5,E13.5,0P,2F9.3,I8,I7,F9.2,2X,A)
  300 FORMAT (I2,1X,A13,I5,A13,2F9.4,I8,I7,F9.2,2X,A)
      END
C
C----------------------------------------------------------------------
C
c
c---------------------------------------------------------
c
      subroutine gcf004 (l1, l2, l3, l4,
     +                   m1, m2, m3, m4,
     +                   n1, n2, n3, n4,
     +                   xsum,
     +                   x1, x2, x3, x4, 
     +                   y1, y2, y3, y4,
     +                   ptitle, xtitle, ytitle,
     +                   axes, gsave)
c
c action: reverse data for plotting by GCFIT
c author: w.g.bardsley, university of manchester, u.k., 11/03/2013
c
c This routine is designed to plot data that has been reversed
c in order to fit decay models by gcfit in mode 1
c xsum is the maximum plus minimum values in the original data set and
c the x, y values are the original data set in reversed order
c It must be the case that x values will all refer to the same time scale
c
      implicit none
c
c arguments
c          
      integer,             intent (in) :: l1, l2, l3, l4,
     +                                    m1, m2, m3, m4,
     +                                    n1, n2, n3, n4 
      double precision,    intent (in) :: xsum,
     +                                    x1(n1), x2(n2),
     +                                    x3(n3), x4(n4),
     +                                    y1(n1), y2(n2),
     +                                    y3(n3), y4(n4)
      character (len = *), intent (in) :: ptitle, xtitle, ytitle
      logical,             intent (in) :: axes, gsave 
c
c allocatables
c
      double precision, allocatable :: u1(:), u2(:), u3(:), u4(:),
     +                                 v1(:), v2(:), v3(:), v4(:)
c
c locals
c  
      integer   i, ierr, k, n
      external  gks004
      intrinsic max
      k = max(n1, n2, n3, n4)
      if (k.lt.1) return
      ierr = 0

      if (allocated(u1)) deallocate(u1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(u2)) deallocate(u2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(u3)) deallocate(u3, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(u4)) deallocate(u4, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(v1)) deallocate(v1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(v2)) deallocate(v2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(v3)) deallocate(v3, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(v4)) deallocate(v4, stat = ierr)
      if (ierr.ne.0) return  

      n = max(n1,1)
      allocate (u1(n), stat = ierr)
      if (ierr.ne.0) return
      allocate (v1(n), stat = ierr)
      if (ierr.ne.0) return
      n = max(n2,1)
      allocate (u2(n), stat = ierr)
      if (ierr.ne.0) return
      allocate (v2(n), stat = ierr)
      if (ierr.ne.0) return
      n = max(n3,1)
      allocate (u3(n), stat = ierr)
      if (ierr.ne.0) return
      allocate (v3(n), stat = ierr)
      if (ierr.ne.0) return  
       n = max(n4,1)
      allocate (u4(n), stat = ierr)
      if (ierr.ne.0) return
      allocate (v4(n), stat = ierr)
      if (ierr.ne.0) return
        
      do i = 1, k
         if (i.le.n1) then
            u1(i) = xsum - x1(n1 - i + 1)
            v1(i) = y1(n1 - i + 1)
         endif  
         if (i.le.n2) then
            u2(i) = xsum - x2(n2 - i + 1)
            v2(i) = y2(n2 - i + 1)
         endif
         if (i.le.n3) then
            u3(i) = xsum - x3(n3 - i + 1)
            v3(i) = y3(n3 - i + 1)
         endif
         if (i.le.n4) then
            u4(i) = xsum - x4(n4 - i + 1)
            v4(i) = y4(n4 - i + 1)
         endif  
      enddo
      call gks004 (l1, l2, l3, l4,
     +             m1, m2, m3, m4,
     +             n1, n2, n3, n4,
     +             u1, u2, u3, u4,
     +             v1, v2, v3, v4,
     +             ptitle, xtitle, ytitle,
     +             axes, gsave) 
      deallocate(u1, stat = ierr) 
      deallocate(u2, stat = ierr) 
      deallocate(u3, stat = ierr) 
      deallocate(u4, stat = ierr) 
      deallocate(v1, stat = ierr) 
      deallocate(v2, stat = ierr) 
      deallocate(v3, stat = ierr) 
      deallocate(v4, stat = ierr) 
      end
c
c                 