C
C HLFIT requires the following extra source files:-
C =================================================
C
C HLFIT1.FOR: ADVISE, DATAIN, DATFIT, DATOUT
C HLFIT2.FOR: DERIV1, DERIV2, 
C DLLCHK.FOR: consistency check
C
C These must now be included
C ==========================
C
C     INCLUDE 'hlfit1.for', NOLIST
C     INCLUDE 'hlfit2.for', NOLIST
C     INCLUDE 'dllchk.for', NOLIST
C
C-----------------------------------------
C Start of Module to replace common blocks
C-----------------------------------------
      MODULE MODULE_HLFIT
      
      IMPLICIT NONE
         
      INTEGER    ITIME, MODE, NMAX, NPTS
      INTEGER    NFACT
      PARAMETER (NFACT = 13)
      DOUBLE PRECISION DOFDOM, FACT(NFACT)
      LOGICAL    CIN
        
      DOUBLE PRECISION, ALLOCATABLE :: ERRY(:), THEORY(:), XVAL(:),
     +                                 YVAL(:)
      LOGICAL,          ALLOCATABLE :: EQUAL(:)
         
      END MODULE MODULE_HLFIT
C---------------------------------------
C End of module to replace common blocks
C---------------------------------------      

C
C the following parameters must be consistent
C NN = 6 
C NFACT = 2*NN + 1
C where NN = maxmimum order, NFACT >= NX = maximum no. of parameters
C
      PROGRAM MAIN
C
C VERSION : details from SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C NAG     : C05AZF, E04JAF, G01EBF, G01FBF, G05CAF, G05CCF, G05DDF,
C           X02AJF, X02AMF
C INPUT   : File with TITLE, NPTS, X, Y, Standard error in Y
C           as prepared by programs MAKFIL, MAKDAT, ADDERR or EDITFL
C ACTION  : Best-fit High/Low affinity sites models.
C           Random search for starting values.
C           Optimisation using a quasi-Newton routine and F test.
C           X- and Y-data transformed to 'order unity' internally.
C MODEL   : Y(X) = Summation  A(I)*K(I)*X/(1.0 + K(I)*X)  +  C
C OUTPUT  : Weighted sums of squares, F statistics, parameters
C           and residuals as requested. All details can be written
C           to a data output file on request
C ADVICE  : Make sure that the standard error in Y > 0.0,
C           and X in increasing order
C           Set parameters : NF   = output unit for data file
C                            NMAX = maximum number of points
C                            NN   = maximum order
C                            NX   = no. of parameters (NX = 2*NN + 1)
C AUTHOR  : W. G. Bardsley, 23/2/90
C           ENDALL, GETNUM, GETCHR, CHECKW, CHECKT, REPEAT, GKSR01,
C           GKST02, GKST03 24/6/92
C           09/01/1993 GET???, PUT??? and compressed
C           08/04/1993 Added GKST04 and diagonal 1 to correlation matrix
C           21/04/1993 Altered VMAXKM
C           14/06/1993 RESFIL
C           08/06/1994 DBOS version 
C           20/02/1995 Salamanca version
C           27/10/1995 Split source file, transformed to NAG 16 and cleaned up
C           14/09/1997 win32 version using QNFIT1 instead of E04JAF
C                      COMMON is used to communicate with the model
C           20/03/1998 Added GOGOGO and NEW
C           07/08/1998 added dllchk
C           03/10/1998 FTN95 version
C           14/12/1998 Replaced TUTORS by TUTOR1
C           19/08/1999 revised control
C           13/09/1999 added call to WINDOW
C           05/12/99 inreased dimension LW1
C           12/02/2000 added call to SIMVER
C           17/08/2000 added MODE for Hot/Cold displacement
C           28/03/2001 revised
C           04/05/2001 added call to GDCON0 for deconvolution
C           18/05/2001 added call to PCVTST
C           16/06/2001 added call to ARRPAR to rearrange parameters
C           30/07/2005 increased DVER to *30 and added to call to ADVISE
C           18/10/2007 replaced common block by module_hlfit and edited for version 6 
C           26/11/2013 increased NGRAF to 200 and introduced TABLE6 to display results
C

      USE MODULE_HLFIT

      IMPLICIT   NONE
      INTEGER    I, IOS, ITEMP, J, I_STATUS, I_LENGTH
      INTEGER    NN, NX, N0, N1, N2
      PARAMETER (NN = 6, NX = 2*NN + 1, N0 = 0, N1 = 1, N2 = 2)
      INTEGER    NF, NIN, N10, NGRAF, NHESS
      PARAMETER (NF = 4, NIN = 3, N10 = 10, NGRAF = 200, NHESS = NX + 1)
      INTEGER    LIW, LW1, LW2
      PARAMETER (LIW = 3*NX,
     +           LW1 = 2*(2*N10*NX + 4*NX + 11*N10*N10 + 8*N10),
     +           LW2 = 3*NX)
      INTEGER    IW(LIW)
      INTEGER    INDEX(NX), ISTATE(NX), NBD(NX)
      INTEGER    NPAR(NN)
      INTEGER    MAXNUM, NBIG, NDOF, NFREE, NRAND, NSMALL, NSTART, NSTOP
      INTEGER    IERR, ISEND, NCOL, NROW
      DOUBLE PRECISION XGRAF(NGRAF), YGRAF(NGRAF)
      DOUBLE PRECISION CORR(NX,NX), CV(NHESS,NHESS), HESSEX(NHESS,NHESS)
      DOUBLE PRECISION BL(NX), BU(NX), DIAGV(NX), ERR(NX), G(NX),
     +                 PAR(NX), STORES(NX), TPER(NX), TL(NX), TU(NX),
     +                 X(NX)
      DOUBLE PRECISION WSSQ(NN)
      DOUBLE PRECISION W1(LW1), W2(LW2)
      DOUBLE PRECISION EPSI, OBJFUN, RTOL, SIGMA, XM, YB, YBDYT, YT
      DOUBLE PRECISION XVER, YVER

      DOUBLE PRECISION, ALLOCATABLE :: RESID(:), WRESID(:), XSAV(:),
     +                                 ZSAV(:)
      DOUBLE PRECISION, ALLOCATABLE :: EE(:), XX(:), YY(:), ZZ(:)
      DOUBLE PRECISION, ALLOCATABLE :: FJACC(:,:)
      LOGICAL,          ALLOCATABLE :: EQSAV(:)
      
      CHARACTER (LEN = 30) COMMAND
      CHARACTER  FNAME1*1024, FNAME2*1024, TITLE*80
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_hlfit.exe')
      CHARACTER  BLANK*1, PNAME*5, LETTER*1
      PARAMETER (BLANK = ' ', PNAME = 'HLFIT')
      LOGICAL    FREE(NX), ISTOP, JUMP, NOUT(10)
      LOGICAL    DOIT, FIRST, NEW, REPEET
      LOGICAL    ABORT, ACTION, SHOW
      EXTERNAL   G05CCF$
      EXTERNAL   GOGOGO, M_FITONE
      EXTERNAL   ADVISE, DATAIN, DETAIL, RANDOM, DATFIT, DATOUT
      EXTERNAL   DLLCHK, WINDOW, SIMVER

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +            DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER, 
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C
C
C
C First check the command line to initialise ISEND and JUMP
C
      ITEMP = COMMAND_ARGUMENT_COUNT()  
      IF (ITEMP.EQ.N1) THEN
         CALL GET_COMMAND_ARGUMENT (N1, COMMAND, I_LENGTH, I_STATUS)
         IF (I_LENGTH.GE.N1 .AND. I_STATUS.EQ.N0) THEN
C
C 29/10/2023
C Replaced non-integer characters by blanks to interpret '0' as 0 which causes trouble otherwise
C It appears that 'i' is passed by run_program and returned as such by command argument 
C retrieval and read accurately except for '0' which is not read as 0 even if the quotes are 
C removed. Is it being read as a C string terminator ? So 0 is changed to 11 to call sv_simstat. 
C         
            do i = 1, i_length
               letter = command(i:i)
               j = ichar(letter)
               if (j.lt.48 .or. j.gt.57) command(i:i) = blank
            enddo  
             
            READ (COMMAND,*,IOSTAT=IOS) I
             
            IF (IOS.EQ.N0) THEN
               IF (I.GE.N1 .AND. I.LE.N10) THEN
                  ITEMP = I
               ELSE
                  ITEMP = N0
               ENDIF
            ELSE
               ITEMP = N0
            ENDIF
         ELSE
            ITEMP = N0
         ENDIF      
      ENDIF
      IF (ITEMP.EQ.N0) THEN
         JUMP = .FALSE.
      ELSE
         JUMP = .TRUE.
      ENDIF
C
C Advise user
C
      FIRST = .TRUE.
      IF (JUMP) THEN
         ISTOP = .FALSE.
         MODE = 1
      ELSE   
         CALL ADVISE (MODE, 
     +                DVER,
     +                ISTOP, FIRST)
      ENDIF
      IF (ISTOP) THEN
         DOIT = .FALSE.
      ELSE
         DOIT = .TRUE.
C
C Initialise random number generator
C
         CALL G05CCF$
         NCOL = 0
         NROW = 0
         NRAND = 1
         FNAME1 = BLANK
         FNAME2 = BLANK
         NEW = .TRUE.
C
C Initialise output types
C nout(1) ... display analysis table
C nout(2) ... display starting estimates
C nout(3) ... display random search
C nout(4) ... plot    best fit curves
C nout(5) ... plot    residuals
C nout(6) ... display residuals table
C nout(7) ... file    residuals table
C nout(8) ... high precision convergence test
C nout(9) ... store/test parameters/covariance matrix
c nout(10) ... deconvolute
C
         NOUT(1) = .TRUE.
         NOUT(2) = .FALSE.
         NOUT(3) = .FALSE.
         NOUT(4) = .TRUE.
         NOUT(5) = .FALSE.
         NOUT(6) = .TRUE.
         NOUT(7) = .FALSE.
         NOUT(8) = .FALSE.
         NOUT(9) = .FALSE.
         NOUT(10) = .TRUE.
         NSTART = N1
         NSTOP = N2
      ENDIF
C
C Branch point for repeated analysis
C
      IF (DOIT) THEN
         REPEET = .TRUE.
         DO WHILE (REPEET)
C
C Get a new data set
C
            IF (NEW) THEN
C
C Get a new data file
C              
               ISEND = MODE + 4
               CALL M_FITONE (ISEND, NCOL, NIN, NROW,
     +                        FNAME1, TITLE) 
               IF (NCOL.GE.2 .AND. NCOL.LE.3 .AND. NROW.GT.1) THEN
                  NPTS = NROW
                  NMAX = MAX(NPTS,NGRAF)
                  ISTOP = .FALSE.
                  NEW = .FALSE.
                  IERR = 0
                  IF (ALLOCATED(ERRY)) DEALLOCATE(ERRY, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(THEORY)) DEALLOCATE(THEORY, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(XVAL)) DEALLOCATE(XVAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(YVAL)) DEALLOCATE(YVAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(EQUAL)) DEALLOCATE(EQUAL, STAT = IERR)
                  IF (IERR.NE.0) EXIT 
                  IF (ALLOCATED(EQSAV)) DEALLOCATE(EQSAV, STAT = IERR)
                  IF (IERR.NE.0) EXIT               
                  ALLOCATE(ERRY(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  ALLOCATE(THEORY(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(XVAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(YVAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(EQUAL(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  ALLOCATE(EQSAV(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT    

                  IF (ALLOCATED(RESID)) DEALLOCATE(RESID, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(WRESID)) DEALLOCATE(WRESID, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(XSAV)) DEALLOCATE(XSAV, STAT = IERR)
                  IF (IERR.NE.0) EXIT  
                  IF (ALLOCATED(ZSAV)) DEALLOCATE(ZSAV, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(EE)) DEALLOCATE(EE, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(XX)) DEALLOCATE(XX, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(YY)) DEALLOCATE(YY, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(ZZ)) DEALLOCATE(ZZ, STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  IF (ALLOCATED(FJACC)) DEALLOCATE(FJACC, STAT = IERR)
                  IF (IERR.NE.0) EXIT  

                  ALLOCATE(RESID(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(WRESID(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(XSAV(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(ZSAV(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(EE(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(XX(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(YY(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT
                  ALLOCATE(ZZ(NMAX), STAT = IERR)
                  IF (IERR.NE.0) EXIT 
                  ALLOCATE(FJACC(NMAX,NX), STAT = IERR)
                  IF (IERR.NE.0) EXIT   
               ELSE
                  ISTOP = .TRUE.
               ENDIF                      
            ENDIF 
            IF (.NOT.ISTOP) THEN 
C
C Initialise the data
C              
               CALL DATAIN (MODE, NF, NIN, NMAX, NPTS,
     +                      EE, EPSI, ERRY, RTOL, XM, XVAL, XX, YB, YT,
     +                      YVAL, YY,
     +                      FNAME1, FNAME2,
     +                      EQUAL, ISTOP, JUMP, NEW)
             ENDIF
            IF (ISTOP) THEN
               DOIT = .FALSE.
               FNAME1 = BLANK
            ELSE
               DOIT = .TRUE.
            ENDIF
C
C Decide what to do
C
            IF (DOIT) THEN
               CALL DETAIL (MAXNUM, NBIG, NN, NRAND, NSMALL, NSTART,
     +                      NSTOP,
     +                      SIGMA, YB, YBDYT, YT,
     +                      CIN, ISTOP, JUMP, NOUT)
               IF (ISTOP) THEN
                  DOIT = .FALSE.
               ELSE
                  DOIT = .TRUE.
               ENDIF
            ENDIF
            IF (DOIT) THEN
C
C Fit successive models
C
               DO ITIME = NSTART, NSTOP
C
C Random starting estimates
C                 
                  CALL RANDOM (ISTATE, ITIME, MAXNUM, MODE, NBIG, NDOF,
     +                         NF, NN, NPAR, NPTS, NRAND, NSMALL, NX,
     +                         DOFDOM, FACT, SIGMA, STORES, WSSQ, X,
     +                         XM, YBDYT, YT,
     +                         CIN, ISTOP, NOUT)
C
C Curve fitting
C     
                  CALL DATFIT (ISTATE, ITIME, IW, LIW, LW1, LW2, MODE,
     +                         NBD, NDOF, NF, NN, NPAR, NPTS, NX,
     +                         BL, BU, DOFDOM, EPSI, FACT, G, OBJFUN,
     +                         WSSQ, W1, W2, X, XM, YT,
     +                         CIN, ISTOP, NOUT)
C
C Output results
C     
                  CALL DATOUT (INDEX, ISTATE, ITIME, LW2, MODE, NDOF,
     +                         NF, NFREE, NGRAF,
     +                         NHESS, NMAX, NN, NPAR, NPTS, NSTART, NX,
     +                         CORR, CV, DIAGV, EE, ERR, ERRY, FACT,
     +                         FJACC, G, HESSEX, OBJFUN, PAR, RESID,
     +                         RTOL, THEORY, TL, TPER, TU, WRESID, WSSQ,
     +                         W2, X, XGRAF, XM, XSAV, XVAL, XX, YGRAF,
     +                         YT, YVAL, YY, ZSAV, ZZ,
     +                         CIN, ISTOP, EQSAV, EQUAL, FREE, NOUT)
               ENDDO
            ENDIF
C
C Another go ?
C
            CALL GOGOGO (NF,
     +                   FNAME1, FNAME2, PNAME,
     +                   ISTOP, NEW)
            IF (ISTOP) THEN
               REPEET = .FALSE.
            ELSE
               REPEET = .TRUE.
            ENDIF
         ENDDO
      ENDIF
C
C Terminate program
C

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE, 
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NF)
      END
C
C
