C
C
C HLFIT1.FOR
C ==========
C ADVISE
C DATAIN
C DATFIT
C DATOUT
C
C
      SUBROUTINE ADVISE (MODE, 
     +                   DVER,
     +                   ABORT, FIRST)
C
C Advise user of HLFIT
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (INOUT) :: MODE
      CHARACTER (LEN = *), INTENT (IN)    :: DVER
      LOGICAL,             INTENT (IN)    :: FIRST
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 4)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_HLFIT
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help        ',
     +'Normal mode ',
     +'Isotope mode',
     +'Quit .. Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_HLFIT ('hlfit')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            MODE = 1
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            MODE = 2
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.4) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `HLFIT'
     +/'        `      '
     +/'Action  `Fit a sum of 1 to n High/Low affinity binding site'
     +/'        `functions plus an optional background constant, by'
     +/'        `constrained, weighted least squares.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG,'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C----------------------------------------------------------------------------      
C
      SUBROUTINE DATAIN (MODE, NF, NIN, NMAX, NPTS,
     +                   EE, EPSI, ERRY, RTOL, XM, XVAL, XX, YB, YT,
     +                   YVAL, YY,
     +                   FNAME1, FNAME2,
     +                   EQUAL, ISTOP, JUMP, NEW)
C
C Read X, Y, Error, NPTS, calculate XT, YT
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: MODE, NF, NIN, NMAX
      INTEGER,             INTENT (INOUT) :: NPTS
      DOUBLE PRECISION,    INTENT (OUT)   :: EE(NMAX), EPSI, ERRY(NMAX),
     +                                       RTOL, XM, XVAL(NMAX),
     +                                       XX(NMAX), YB, YT,
     +                                       YVAL(NMAX), YY(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME1, FNAME2
      LOGICAL,             INTENT (IN)    :: JUMP, NEW
      LOGICAL,             INTENT (OUT)   :: EQUAL(NMAX), ISTOP
C
C Locals
C      
      INTEGER    I, ICOUNT
      DOUBLE PRECISION X02AJF$, X02AMF$
      DOUBLE PRECISION ZERO, FIVE, PNT85
      PARAMETER (ZERO = 0.0D+00, FIVE = 5.0D+00, PNT85 = 0.85D+00)
      CHARACTER  LINE*100, TITLE*80
      CHARACTER (LEN = 80) TRIM80, WORD80 
      EXTERNAL   X02AJF$, X02AMF$
      EXTERNAL   DATFIL, DATCHK, PUTFAT, RESFIL, DATSXY, TRIM80
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
C
C Assign EPSI AND RTOL
C
      EPSI = X02AJF$()
      RTOL = 1.0D+09*X02AMF$()
C
C Read in and check data
C
      IF (NEW) THEN
         CLOSE (UNIT = NIN)
         CALL DATFIL (NIN, NMAX, NPTS,
     +                EE, XX, YY,
     +                FNAME1, TITLE, 
     +                ISTOP)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ELSE
         CLOSE (UNIT = NIN)
         CALL DATSXY (NIN, NMAX, NPTS,
     +                EE, XX, YY,
     +                FNAME1, TITLE, 
     +                ISTOP)
         CLOSE (UNIT = NIN)
      ENDIF
      CALL DATCHK (NPTS,
     +             EE, XX, YY,
     +             ISTOP)
      IF (ISTOP) RETURN
      IF (MODE.EQ.1 .AND. YY(1).GT.YY(NPTS)) THEN
         CALL PUTFAT (
     +'In Normal mode y must be an increasing function of x')
         ISTOP = .TRUE.
         RETURN
      ELSEIF (MODE.EQ.2 .AND. YY(1).LT.YY(NPTS)) THEN
         CALL PUTFAT (
     +'In Isotope mode y must be a decreasing function of x')
         ISTOP = .TRUE.
         RETURN
      ENDIF
C
C Further checks on input data and calculate YT
C
      IF (NPTS.LT.3) THEN
         CALL PUTFAT ('Must be at least 3 X-values')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      YB = YY(1)
      YT = YY(1)
      DO I = 1, NPTS
         IF (XX(I).LT.ZERO .OR. YY(I).LT.ZERO) THEN
            WRITE (LINE,100) I
            CALL PUTFAT (LINE)
            ISTOP = .TRUE.
            RETURN
         ENDIF
         IF (YY(I).LT.YB) YB = YY(I)
         IF (YY(I).GT.YT) YT = YY(I)
      ENDDO
C
C Open output file for results and write out program declaration
C
      IF (ICOUNT.EQ.0) THEN
         CALL RESFIL (NF, FNAME2, ISTOP)
         IF (ISTOP) RETURN
         IF (MODE.EQ.1) THEN
            IF (JUMP) THEN
               WRITE (NF,150)
            ELSE   
               WRITE (NF,200)
            ENDIF   
         ELSE
            WRITE (NF,300)
         ENDIF
      ENDIF
      ICOUNT = ICOUNT + 1
      WORD80 = TRIM80(FNAME1)
      WRITE (NF,400) ICOUNT, WORD80, TITLE
      XM = XX(NPTS)/FIVE
      YB = PNT85*YB
      YT = YT/PNT85
      DO I = 1, NPTS
         ERRY(I) = EE(I)/YT
         XVAL(I) = XX(I)/XM
         YVAL(I) = YY(I)/YT
      ENDDO
      EQUAL(1) = .FALSE.
      DO I = 2, NPTS
         IF (XVAL(I).GT.XVAL(I - 1)) THEN
            EQUAL(I) = .FALSE.
         ELSE
            EQUAL(I) = .TRUE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT ('x or y < 0 at data point',I6,' ... Must be > 0')
  150 FORMAT (/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : SV_HLFIT'
     +/1X,'ACTION  : Wtd. least squares binding curve'
     +/1X,'MODEL   : Fit High/low affinity binding sites model'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U. K.')
  200 FORMAT (/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : HLFIT'
     +/1X,'ACTION  : Wtd. least squares binding curve'
     +/1X,'MODEL   : Fit High/low affinity binding sites model'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U. K.')
  300 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : HLFIT'
     +/1X,'ACTION  : Fit High/Low affinity transporter sites model'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U. K.')
  400 FORMAT (/1X,'Analysis number',I4/1X,'==================='
     +/1X,'File name'/1X,A/1X,'Data title'/1X,A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE DATFIT (ISTATE, ITIME, IW, LIW, LW1, LW2, MODE, NBD,
     +                   NDOF, NF, NN, NPAR, NPTS, NX,
     +                   BL, BU, DOFDOM, EPSI, FACT, G, OBJFUN, WSSQ,
     +                   W1, W2, X, XM, YT,
     +                   CIN, ISTOP, NOUT)
C
C Curve fitting by the quasi-Newton routine QNFIT1
C 23/11/2023 introduced E_NUMBERS and E_FORMATS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: LIW, LW1, LW2, NN, NX
      INTEGER,          INTENT (IN)    :: ITIME, MODE, NDOF, NF,
     +                                    NPAR(NN), NPTS
      INTEGER,          INTENT (OUT)   :: ISTATE(NX), IW(LIW), NBD(NX)
      DOUBLE PRECISION, INTENT (IN)    :: DOFDOM, EPSI, XM, YT
      DOUBLE PRECISION, INTENT (INOUT) :: FACT(NX), WSSQ(NN)
      DOUBLE PRECISION, INTENT (OUT)   :: BL(NX), BU(NX), G(NX),
     +                                    OBJFUN,  W1(LW1), W2(LW2), 
     +                                    X(NX)
      LOGICAL,          INTENT (IN)    :: CIN, ISTOP, NOUT(10)
C
C Locals
C     
      INTEGER    I, IFAIL, K, N
      INTEGER    COLOUR
      DOUBLE PRECISION ZERO, ONE, BLMIN, BUMAX, FMIN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, BLMIN = 1.0D-10,
     +           BUMAX = 1.0D+08, FMIN = 1.0D-10)
      DOUBLE PRECISION TEMP
      CHARACTER  LINE*100
      CHARACTER (LEN = 13) D13, SHOWLJ 
      LOGICAL    E_FORMATS, E_NUMBERS
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   QNFIT1
      EXTERNAL   CHECKW, TABLE1, PUTIFA
      EXTERNAL   DERIV1, DERIV2, FUNCT1, ZMOD
      INTRINSIC  ABS
      IF (ISTOP) RETURN
      E_NUMBERS = E_FORMATS()  
C
C Set up parameters for curve fitting
C
      N = NPAR(ITIME)
      IF (NOUT(2)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         WRITE (LINE,10)
         WRITE (NF,10)
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         COLOUR = 0
      ENDIF
      DO I = 1, 2*ITIME
         NBD(I) = 1
         BL(I) = BLMIN
         BU(I) = BUMAX
         X(I) = ONE
         ISTATE(I) = 1
         IF (FACT(I).LT.FMIN) FACT(I) = FMIN
         IF (NOUT(2)) THEN
            IF (I.LE.ITIME) THEN
               IF (MODE.EQ.1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,20) ' A(', I, FACT(I)*YT
                     WRITE (NF,20) ' A(', I, FACT(I)*YT
                  ELSE
                     TEMP = FACT(I)*YT
                     D13 = SHOWLJ(TEMP)
                     WRITE (LINE,25) ' A(', I, D13
                     WRITE (NF,25) ' A(', I, D13
                  ENDIF  
               ELSE
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,20) ' B(', I, FACT(I)*XM*YT
                     WRITE (NF,20) ' B(', I, FACT(I)*XM*YT
                  ELSE
                     TEMP = FACT(I)*XM*YT
                     D13 = SHOWLJ(TEMP)
                     WRITE (LINE,25) ' B(', I, D13
                     WRITE (NF,25) ' B(', I, D13
                  ENDIF  
               ENDIF
            ELSE
               IF (MODE.EQ.1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,20) 'Ka(', I - ITIME, FACT(I)/XM
                     WRITE (NF,20) 'Ka(', I - ITIME, FACT(I)/XM
                  ELSE
                     TEMP = FACT(I)/XM
                     D13 = SHOWLJ(TEMP)
                     WRITE (LINE,25) 'Ka(', I - ITIME, D13
                     WRITE (NF,25) 'Ka(', I - ITIME, D13 
                  ENDIF  
               ELSE
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,20) ' K(', I - ITIME, FACT(I)/XM
                     WRITE (NF,20) ' K(', I - ITIME, FACT(I)/XM
                  ELSE
                     TEMP = FACT(I)/XM
                     D13 = SHOWLJ(TEMP)
                     WRITE (LINE,25) ' K(', I - ITIME, D13
                     WRITE (NF,25) ' K(', I - ITIME, D13
                  ENDIF  
               ENDIF
            ENDIF
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
      ENDDO
      IF (CIN) THEN
         NBD(N) = 2
         BL(N) = - BUMAX
         BU(N) = BUMAX
         X(N) = ONE
         ISTATE(N) = 1
         IF (ABS(FACT(N)).LT.FMIN) THEN
            IF (FACT(N).LT.ZERO) THEN
               FACT(N) = - FMIN
            ELSE
               FACT(N) = FMIN
            ENDIF
         ENDIF
         IF (NOUT(2)) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,40) FACT(N)*YT
               WRITE (NF,40) FACT(N)*YT
            ELSE
               TEMP = FACT(N)*YT 
               D13 = SHOWLJ(TEMP)
               WRITE (LINE,45) D13
               WRITE (NF,45) D13
            ENDIF     
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
      ELSE
         K = N + 1
         NBD(K) = 2
         BL(K) = ZERO
         BU(K) = ZERO
         X(K) = ZERO
         FACT(K) = ONE
         ISTATE(K) = 0
      ENDIF
      IF (NOUT(2)) CALL TABLE1 (COLOUR, 'CLOSE')
C
C Entry point for curve fitting
C
      CALL CHECKW (NDOF, WSSQ(ITIME))
      IF (E_NUMBERS) THEN
         WRITE (NF,100) WSSQ(ITIME)
      ELSE
         D13 = SHOWLJ(WSSQ(ITIME))
         WRITE (NF,150) D13
      ENDIF       
      IF (NOUT(8)) THEN
         CALL QNFIT1 (DERIV2, FUNCT1,
     +                IFAIL, IW, LIW, LW1, LW2, N, NBD, NF, NPTS,
     +                BL, BU, OBJFUN, G, W1, W2, X,
     +                'exact', 'high')
      ELSE
         CALL QNFIT1 (DERIV1, FUNCT1,
     +                IFAIL, IW, LIW, LW1, LW2, N, NBD, NF, NPTS,
     +                BL, BU, OBJFUN, G, W1, W2, X,
     +                'approximate', 'medium')
      ENDIF
      IF (IFAIL.NE.0 .AND. IFAIL.NE.1 .AND. IFAIL.NE.2)
     +    CALL PUTIFA (IFAIL, NF, 'QNFIT1/DATFIT')
      WSSQ(ITIME) = DOFDOM*OBJFUN
      IF (E_NUMBERS) THEN
         WRITE (NF,200) WSSQ(ITIME)
      ELSE
        D13 = SHOWLJ(WSSQ(ITIME))
        WRITE (NF,250) D13
      ENDIF     
C
C Call ZMOD to make sure THEORY is defined correctly then define ISTATE
C
      CALL ZMOD (X)
      DO I = 1, N
         IF (ISTATE(I).NE.0) THEN
            IF (ABS(X(I) - BL(I)).LE.EPSI) ISTATE(I) = - 2
            IF (ABS(X(I) - BU(I)).LE.EPSI) ISTATE(I) = - 1
         ENDIF
      ENDDO
C
C Format statements
C      
   10 FORMAT (1X,'Parameter start estimates')
   20 FORMAT (1X,A3,I1,') =',1P,E10.3)
   25 FORMAT (1X,A3,I1,') =',1X,A)   
   40 FORMAT (5X,'C =',1P,E10.3)
   45 FORMAT (5X,'C =',1X,A)   
  100 FORMAT (1X,'Before curve-fitting WSSQ =',1P,E10.3)
  150 FORMAT (1X,'Before curve-fitting WSSQ =',1X,A)  
  200 FORMAT (1X,'After  curve-fitting WSSQ =',1P,E10.3)
  250 FORMAT (1X,'After  curve-fitting WSSQ =',1X,A)  
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE DATOUT (INDEX, ISTATE, ITIME, LW2, MODE, NDOF, NF,
     +                   NFREE, NGRAF, NHESS, NMAX, NN, NPAR, NPTS,
     +                   NSTART, NX,
     +                   CORR, CV, DIAGV, EE, ERR, ERRY, FACT, FJACC, G,
     +                   HESSEX, OBJFUN, PAR, RESID, RTOL, THEORY, TL,
     +                   TPER, TU, WRESID, WSSQ, W2, X, XGRAF, XM, XSAV,
     +                   XVAL, XX, YGRAF, YT, YVAL, YY, ZSAV, ZZ,
     +                   CIN, ISTOP, EQSAV, EQUAL, FREE, NOUT)
C
C Output printed or written to a file
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: LW2, NGRAF, NHESS, NMAX, NN,
     +                                    NX
      INTEGER,          INTENT (IN)    :: ITIME, MODE, NDOF, NF,
     +                                    NPAR(NN), NSTART
      INTEGER,          INTENT (OUT)   :: INDEX(NX), NFREE
      INTEGER,          INTENT (INOUT) :: ISTATE(NX), NPTS
      DOUBLE PRECISION, INTENT (IN)    :: EE(NMAX), FACT(NX), OBJFUN,
     +                                    RTOL, XM, XX(NMAX), YT,
     +                                    YY(NMAX)     
      DOUBLE PRECISION, INTENT (OUT)   :: PAR(NX)
      DOUBLE PRECISION, INTENT (INOUT) :: ERRY(NMAX), WSSQ(NN),
     +                                    THEORY(NMAX), X(NX),
     +                                    XGRAF(NGRAF), XVAL(NMAX),
     +                                    YGRAF(NGRAF), YVAL(NMAX)      
      DOUBLE PRECISION, INTENT (OUT)   :: CORR(NX,NX), CV(NHESS,NHESS),
     +                                    DIAGV(NX),  ERR(NX),  
     +                                    FJACC(NMAX,NX), G(NX),
     +                                    HESSEX(NHESS,NHESS),  
     +                                    RESID(NMAX),  TL(NX),
     +                                    TPER(NX), TU(NX),
     +                                    WRESID(NMAX), W2(LW2), 
     +                                    XSAV(NMAX), ZSAV(NMAX), 
     +                                    ZZ(NMAX)
      LOGICAL,          INTENT (IN)    :: ISTOP, CIN, NOUT(10)
      LOGICAL,          INTENT (OUT)   :: EQSAV(NMAX), FREE(NX)
      LOGICAL,          INTENT (INOUT) :: EQUAL(NMAX)
C
C Locals
C      
      INTEGER    L0, L1, L2, L3, L11
      PARAMETER (L0 = 0, L1 = 1, L2 = 2, L3 = 3, L11 = 5)
      INTEGER    I, IFAIL, J, K, MA, N, NA, NSAV, NTEMP
      INTEGER    NTEXT
      INTEGER    ISEND, INDEXX(50), JCOLOR(50)
      PARAMETER (ISEND = 2)
      DOUBLE PRECISION PNT05, PNT975
      PARAMETER (PNT05 = 0.05D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION ALPHA, RATIO, TSTAT, XFIRST, XLAST
      DOUBLE PRECISION VMAX, XA, YA
      DOUBLE PRECISION G01EBF$, G01FBF$
      DOUBLE PRECISION XTEMP1(L2), XTEMP2(L2), YTEMP1(L2), YTEMP2(L2)
      DOUBLE PRECISION ZERO, ONE, TWO, F100
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           F100 = 100.0D+00)
      CHARACTER (LEN = 13) D13(5), SHOWRJ 
      CHARACTER  SYMBOL(20)*2, TEMP(50)*100, TYPE1(20)*20
      CHARACTER  PTITLE*37, XTITLE*1, YTITLE*1
      CHARACTER  LINE*100, TEXT(50)*100
      CHARACTER  AB*2, KA*3
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      EXTERNAL   E_FORMATS
      EXTERNAL   G01EBF$, G01FBF$
      EXTERNAL   PUTIFA, DIVIDE, GKSR01, GKST04, FTESTS, TABLE6, GDCON0,
     +           PCVTST, ARRPAR
      EXTERNAL   FUNCT1, QNCOV1, VMAXKM, ZMOD
      EXTERNAL   SHOWRJ
      INTRINSIC  ABS, SQRT, DBLE
      IF (ISTOP) RETURN
      E_NUMBERS = E_FORMATS()  
C
C Calculate covariance matrix and parameter standard errors
C
      N = NPAR(ITIME)
      CALL QNCOV1 (FUNCT1,
     +             INDEX, ISTATE, NF, NFREE, NHESS, NMAX, N, NPTS,
     +             NX,
     +             CORR, CV, DIAGV, ERRY, FACT, FJACC, G, HESSEX,
     +             OBJFUN, W2, X, XVAL, YVAL, THEORY,
     +             EQUAL, FREE)
      DO I = 1, ITIME
         IF (MODE.EQ.1) THEN
            PAR(I) = FACT(I)*X(I)*YT
            ERR(I) = SQRT(ABS(DIAGV(I)))*YT
         ELSE
            PAR(I) = FACT(I)*X(I)*XM*YT
            ERR(I) = SQRT(ABS(DIAGV(I)))*XM*YT
         ENDIF
         J = ITIME + I
         PAR(J) = FACT(J)*X(J)/XM
         ERR(J) = SQRT(ABS(DIAGV(J)))/XM
      ENDDO
      IF (CIN) THEN
         PAR(N) = FACT(N)*X(N)*YT
         ERR(N) = SQRT(ABS(DIAGV(N)))*YT
      ENDIF
C
C =========================================================================
C New section to reconstitute the covariance matrix and put the parameters
C into increasing order of PAR(I), I = 1, ITIME before printing out and
C saving using PCVTST
C =========================================================================
C Re-scale the covariance matrix
C
      DO I = 1, N
C
C First the diagonals
C
         IF (I.EQ.2*ITIME + 1) THEN
            CV(I,I) = CV(I,I)*YT*YT
         ELSEIF (I.LE.ITIME) THEN
            IF (MODE.EQ.1) THEN
               CV(I,I) = CV(I,I)*YT*YT
            ELSE
               CV(I,I) = CV(I,I)*XM*XM*YT*YT
            ENDIF
         ELSE
            CV(I,I) = CV(I,I)/(XM*XM)
         ENDIF
C
C Now the strict lower triangle
C
         IF (I.GT.1) THEN
            DO J = 1, I - 1
               IF (I.EQ.2*ITIME + 1) THEN
                  CV(I,J) = CV(I,J)*YT
               ELSEIF (I.LE.ITIME) THEN
                  IF (MODE.EQ.1) THEN
                     CV(I,J) = CV(I,J)*YT
                  ELSE
                     CV(I,J) = CV(I,J)*XM*YT
                  ENDIF
               ELSE
                  CV(I,J) = CV(I,J)/XM
               ENDIF
               IF (J.EQ.2*ITIME + 1) THEN
                  CV(I,J) = CV(I,J)*YT
               ELSEIF (J.LE.ITIME) THEN
                  IF (MODE.EQ.1) THEN
                     CV(I,J) = CV(I,J)*YT
                  ELSE
                     CV(I,J) = CV(I,J)*XM*YT
                  ENDIF
               ELSE
                  CV(I,J) = CV(I,J)/XM
               ENDIF
C
C Finally fill in the upper triangle
C
               CV(J,I) = CV(I,J)
            ENDDO
         ENDIF
      ENDDO
C
C==============================================================
C Start of code to put the parameters into increasing order
C==============================================================
C
      IF (ITIME.GT.1) THEN
         CALL ARRPAR (ISEND, INDEXX, ITIME, NHESS, NPAR(ITIME),
     +                CV, PAR, W2)
         DO I = 1, N
            W2(I) = ERR(INDEXX(I))
         ENDDO
         DO I = 1, N
            ERR(I) = W2(I)
         ENDDO
         DO I = 1, N
            INDEX(I) = ISTATE(INDEXX(I))
         ENDDO
         DO I = 1, N
            ISTATE(I) = INDEX(I)
         ENDDO
         DO I = 2, N
            DO J = 1, I - 1
                IF (CV(I,I).GT.RTOL .AND. CV(J,J).GT.RTOL) THEN
                   CORR(I,J) = CV(I,J)/SQRT(CV(I,I)*CV(J,J))
                ELSE
                   CORR(I,J) = ZERO
                ENDIF
                IF (CORR(I,J).LT.-ONE) THEN
                   CORR(I,J) = -ONE
                ELSEIF (CORR(I,J).GT.ONE) THEN
                   CORR(I,J) = ONE
                ENDIF      
                CORR(J,I) = CORR(I,J)      
            ENDDO  
         ENDDO  
         DO I = 1, N
            CORR(I,I) = ONE
         ENDDO   
      ENDIF
C
C =========================================================================
C End of code to rearrange parameters
C =========================================================================
C
      IFAIL = 1
      TSTAT = G01FBF$('lower-tail', PNT975, DBLE(NDOF), IFAIL)
      CALL PUTIFA (IFAIL, NF, 'G01FBF/DATFIT')
      DO I = 1, N
         TU(I) = PAR(I) + TSTAT*ERR(I)
         TL(I) = PAR(I) - TSTAT*ERR(I)
         TPER(I) = ONE
         IF (ISTATE(I).GT.0) THEN
            TYPE1(I) = BLANK
            TPER(I) = ZERO
            IF (ERR(I).GT.RTOL) THEN
               RATIO = ABS(PAR(I)/ERR(I))
               IFAIL = 1
               ALPHA = ONE - G01EBF$('Lower-tail', RATIO, DBLE(NDOF),
     +                               IFAIL)
               CALL PUTIFA (IFAIL, NF, 'G01EBF/DATOUT')
               TPER(I) = TWO*ALPHA
            ENDIF
         ELSEIF (ISTATE(I).EQ.0) THEN
            TYPE1(I) = '[Fixed]'
         ELSEIF (ISTATE(I).EQ.-1) THEN
            TYPE1(I) = '[Upper Limit]'
         ELSEIF (ISTATE(I).EQ.-2) THEN
            TYPE1(I) = '[Lower Limit]'
         ELSE
            TYPE1(I) = BLANK   
         ENDIF   
         IF (TPER(I).GT.PNT05) THEN
            SYMBOL(I) = ' *'
         ELSE
            SYMBOL(I) = '  '
         ENDIF
      ENDDO
C
C Output best-fit parameters
C
      DO I = 1, 50
         JCOLOR(I) = 0
      ENDDO   
      WRITE (TEMP,100) ITIME, ITIME
      NTEXT = 0
      DO I = 1, 4
         NTEXT = NTEXT + 1
         TEXT(I) = TEMP(I)
      ENDDO
      JCOLOR(NTEXT) = 4
      WRITE (NF,100) ITIME, ITIME
      IF (MODE.EQ.1) THEN
         AB = 'A('
         KA = 'Ka('
      ELSE
         AB = 'B('
         KA = ' K('
      ENDIF
      
      
      IF (E_NUMBERS) THEN
         WRITE (TEMP,200) (I, AB, I, PAR(I), ERR(I), TL(I), TU(I),
     +                     TPER(I),
     +                     SYMBOL(I), TYPE1(I), I = 1, ITIME)
         DO I = 1, ITIME
            NTEXT = NTEXT + 1
            TEXT(NTEXT) = TEMP(I)
         ENDDO   
         WRITE (NF,200) (I, AB, I, PAR(I), ERR(I), TL(I), TU(I),
     +                   TPER(I),
     +                   SYMBOL(I), TYPE1(I), I = 1, ITIME)
         WRITE (TEMP,300) (ITIME+I, KA, I, PAR(ITIME + I), 
     +                     ERR(ITIME + I),
     +                     TL(ITIME + I), TU(ITIME + I), 
     +                     TPER(ITIME + I),
     +                     SYMBOL(ITIME + I),
     +                     TYPE1(ITIME + I), I = 1, ITIME)
         DO I = 1, ITIME
            NTEXT = NTEXT + 1
            TEXT(NTEXT) = TEMP(I)
         ENDDO   
         WRITE (NF,300) (ITIME + I, KA, I, PAR(ITIME + I),
     +                   ERR(ITIME + I),
     +                   TL(ITIME + I), TU(ITIME + I), TPER(ITIME + I),
     +                   SYMBOL(ITIME + I),
     +                   TYPE1(ITIME + I), I = 1, ITIME)
     
      ELSE
C
C Write to TEMP then copy to TEXT
C              
         DO I = 1, ITIME
            D13(1) = SHOWRJ(PAR(I))
            D13(2) = SHOWRJ(ERR(I))
            D13(3) = SHOWRJ(TL(I))
            D13(4) = SHOWRJ(TU(I))
            WRITE (TEMP(I),250) I, AB, I, D13(1), D13(2), D13(3),
     +                           D13(4),
     +                           TPER(I), SYMBOL(I), TYPE1(I)
         ENDDO
         DO I = 1, ITIME
            NTEXT = NTEXT + 1
            TEXT(NTEXT) = TEMP(I)
         ENDDO 
         DO I = 1, ITIME
            D13(1) = SHOWRJ(PAR(ITIME + I))
            D13(2) = SHOWRJ(ERR(ITIME + I))
            D13(3) = SHOWRJ(TL(ITIME + I))
            D13(4) = SHOWRJ(TU(ITIME + I))  
            WRITE (TEMP(I),350) ITIME + I, KA, I, D13(1), D13(2),
     +                          D13(3), D13(4), TPER(ITIME + I),
     +                          SYMBOL(ITIME + I), TYPE1(ITIME + I)
         ENDDO  
         DO I = 1, ITIME
            NTEXT = NTEXT + 1
            TEXT(NTEXT) = TEMP(I)
         ENDDO  
C
C Write to NF
C            
         DO I = 1, ITIME
            D13(1) = SHOWRJ(PAR(I))
            D13(2) = SHOWRJ(ERR(I))
            D13(3) = SHOWRJ(TL(I))
            D13(4) = SHOWRJ(TU(I))
            WRITE (NF,250) I, AB, I, D13(1), D13(2), D13(3), D13(4),
     +                     TPER(I), SYMBOL(I), TYPE1(I)
         ENDDO
         DO I = 1, ITIME
            D13(1) = SHOWRJ(PAR(ITIME + I))
            D13(2) = SHOWRJ(ERR(ITIME + I))
            D13(3) = SHOWRJ(TL(ITIME + I))
            D13(4) = SHOWRJ(TU(ITIME + I))  
            WRITE (NF,350) ITIME + I, KA, I, D13(1), D13(2), D13(3),
     +             D13(4), TPER(ITIME + I), SYMBOL(ITIME + I),
     +             TYPE1(ITIME + I)
         ENDDO 
      ENDIF
      
      IF (CIN) THEN
        
         IF (E_NUMBERS) THEN
            WRITE (LINE,400) N, PAR(N), ERR(N), TL(N), TU(N), TPER(N),
     +                       SYMBOL(N)
            WRITE (NF,400) N, PAR(N), ERR(N), TL(N), TU(N), TPER(N),
     +                     SYMBOL(N)
         ELSE
            D13(1) = SHOWRJ(PAR(N))
            D13(2) = SHOWRJ(ERR(N))
            D13(3) = SHOWRJ(TL(N))
            D13(4) = SHOWRJ(TU(N))  
            WRITE (LINE,450) N, D13(1), D13(2), D13(3), D13(4),
     +                       TPER(N), SYMBOL(N)
            WRITE (NF,450) N, D13(1), D13(2), D13(3), D13(4), 
     +                     TPER(N), SYMBOL(N)
         ENDIF  
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = LINE
      ENDIF
C
C Calculate apparent VMAX and KM
C
      MA = ITIME
      NA = NPAR(ITIME)
      XA = ZERO
      YA = F100*XX(NPTS)
      CALL VMAXKM (MA, MODE, NA, NTEMP,
     +             PAR, VMAX, XA, YA,
     +             TEMP)
      IF (NTEMP.GT.0) THEN
         DO I = 1, NTEMP
            NTEXT = NTEXT + 1
            TEXT(NTEXT) = TEMP(I)
         ENDDO
      ENDIF
C
C Correlation matrix if NFREE > 1 and NOUT(1)
C
      IF (NFREE.GT.1 .AND. NOUT(1)) THEN
         WRITE (TEMP,500)
         DO I = 1, 2
            NTEXT = NTEXT + 1
            TEXT(NTEXT) = TEMP(I)
         ENDDO
         JCOLOR(NTEXT) = 4   
         WRITE (NF,500)
         DO I = 1, N
             NTEXT = NTEXT + 1
             IF (N.LE.12) THEN
                WRITE (TEXT(NTEXT),600) (CORR(I,J), J = 1, I)
                WRITE (NF,600) (CORR(I,J), J = 1, I)
             ELSE
                WRITE (TEXT(NTEXT),700) (CORR(I,J), J = 1, I)
                WRITE (NF,700) (CORR(I,J), J = 1, I)
             ENDIF
         ENDDO
      ENDIF
      CALL TABLE6 (JCOLOR, NTEXT,
     +             TEXT)       
C
C First call ZMOD to make sure THEORY is defined properly then set
C ZZ = Best-fit curve in external coordinates and call GKSR01, FTESTS
C
      CALL ZMOD (X)
      DO I = 1, NPTS
         ZZ(I) = THEORY(I)*YT
      ENDDO
      CALL GKSR01 (NF, NPAR(ITIME), NPTS,
     +             RESID, EE, ZZ, WRESID, XX, YY,
     +             NOUT(7), SAVEIT, NOUT(5), NOUT(6), NOUT(1))
      IF (ITIME.GT.NSTART) THEN
         CALL FTESTS (NPAR(ITIME - 1), NPAR(ITIME), NF, NPTS,
     +                WSSQ(ITIME - 1), WSSQ(ITIME),
     +                SAVEIT, NOUT(1))
      ENDIF
      IF (NOUT(4)) THEN
         DO I = 1, NPTS
            EQSAV(I) = EQUAL(I)
            XSAV(I) = XVAL(I)
            ZSAV(I) = THEORY(I)
         ENDDO
         XFIRST = XVAL(1)
         XLAST = XVAL(NPTS)
         CALL DIVIDE (NGRAF,
     +                XVAL, XFIRST, XLAST)
         DO I = 1, NGRAF
            EQUAL(I) = .FALSE.
         ENDDO
         NSAV = NPTS
         NPTS = NGRAF
         CALL ZMOD (X)
         NPTS = NSAV
         DO I = 1, NGRAF
            XVAL(I) = XVAL(I)*XM
            THEORY(I) = THEORY(I)*YT
         ENDDO
         DO I = 1, L2
            XTEMP1(I) = ONE
            XTEMP2(I) = ONE
            YTEMP1(I) = ONE
            YTEMP2(I) = ONE
         ENDDO
         XTITLE = 'x'
         YTITLE = 'y'
         IF (ITIME.EQ.NSTART) THEN
            PTITLE = 'Experimental Data and Best-Fit Curve'
            CALL GKST04 (L0, L1, L0, L0,
     +                   L11, L0, L0, L0,
     +                   NPTS, NGRAF, L2, L2,
     +                   VMAX,
     +                   XX, XVAL, XTEMP1, XTEMP2,
     +                   YY, THEORY, YTEMP1, YTEMP2,
     +                   PTITLE, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)
         ELSE
            PTITLE = 'Data, Best-Fit Curve and Previous Fit'
            CALL GKST04 (L0, L1, L3, L0, 
     +                   L11, L0, L0, L0,
     +                   NPTS, NGRAF, NGRAF, L2, 
     +                   VMAX,
     +                   XX, XVAL, XGRAF, XTEMP1,
     +                   YY, THEORY, YGRAF, YTEMP1,
     +                   PTITLE, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)
         ENDIF
C----------------------------------------------------------------------
C Start of graphical deconvolution (note new EXTERNAL subroutine GDCON0)
C
         IF (NOUT(10)) THEN
            J = 3
            CALL GDCON0 (MODE, ITIME, J, NPAR(ITIME), NPTS, NGRAF,
     +                   PAR, XX, XVAL, YY, THEORY)
         ENDIF
C
C End of graphical deconvolution
C----------------------------------------------------------------------
C
C Save best-fit curve and restore data
C
         DO I = 1, NGRAF
            XGRAF(I) = XVAL(I)
            YGRAF(I) = THEORY(I)
         ENDDO
         DO I = 1, NPTS
            EQUAL(I) = EQSAV(I)
            XVAL(I) = XSAV(I)
            THEORY(I) = ZSAV(I)
         ENDDO
      ENDIF
C
C Call PCVTST ... use the full parameter list to be consistent with EXFIT, RFFIT and SFFIT
C
      IF (NOUT(9)) THEN
         I = 1
         J = 2*ITIME + 1
         IF (J.GT.NPAR(ITIME)) THEN
            PAR(J) = ZERO
            CV(J,J) = ZERO
            DO K = 1, NPAR(ITIME)
               CV(J,K) = ZERO
               CV(K,J) = ZERO
            ENDDO 
         ENDIF      
         CALL PCVTST (I, NF, J, NPTS, NHESS,
     +                CV, PAR)
      ENDIF      
C
C Format statements
C      
  100 FORMAT (
     +/1X,'For best-fit',I2,':',I1,1X,'High-Low affinity sites model'
     +/
     +/1X, 
     +'Nnumber Parameter    Value       Std.Error    Lower95%cl    ',
     +'Upper95%cl',5X,'p')
  200 FORMAT (3X,I2,6X,A2,I1,')',1P,1X,E13.5,1X,E13.5,1X,E13.5,1X,E13.5,
     +        0P,F9.4,A2,1X,A)
  250 FORMAT (3X,I2,6X,A2,I1,')',1X,A13,1X,A13,1X,A13,1X,A13,
     +                           F9.4,A2,1X,A)
   
  300 FORMAT (3X,I2,5X,A3,I1,')',1P,1X,E13.5,1X,E13.5,1X,E13.5,1X,E13.5,
     +        0P,F9.4,A2,1X,A)
  350 FORMAT (3X,I2,5X,A3,I1,')',1X,A13,1X,A13,1X,A13,1X,A13,
     +                           F9.4,A2,1X,A)
  
  400 FORMAT (3X,I2,6X,'C',3X,1P,1X,E13.5,1X,E13.5,1X,E13.5,1X,E13.5,
     +        0P,F9.4,A2,1X,A)
  450 FORMAT (3X,I2,6X,'C',4X,A13,1X,A13,1X,A13,1X,A13,F9.4,A2,1X,A)
  
  500 FORMAT (/1X,'Parameter correlation matrix')
  600 FORMAT (12F8.4)
  700 FORMAT (13F8.4)
      END
C
C
