C
C
C HLFIT2.FOR: include file for HLFIT
C ==========
C
C DERIV1
C DERIV2
C DETAIL
C FUNCT1
C RANDOM
C TESTQS
C VCMATX
C VMAXKM
C ZMOD
C
C
      subroutine deriv1 (funct, n, g, w, x)
c
c action : finite difference approximation to derivatives using qngrd1
c
      implicit   none
c
c arguments
c      
      integer,          intent (in)    :: n
      double precision, intent (inout) :: x(n)
      double precision, intent (out)   :: g(n), w(3*n)
c
c locals
c      
      integer    inform
      logical    tpoint
      parameter (tpoint = .false.)
      external   funct, qngrd1
      call qngrd1 (funct, inform, n, g, w, x, tpoint)
      end
C
C-----------------------------------------------------------------------
C F95 and FTN95 complain about FUNCT and W not being used
C The next line is a FTN95 comment embedded compiler directive
CFTN95$OPTIONS (SILENT)
      SUBROUTINE DERIV2 (FUNCT, N, G, W, X)
C
C Derivatives for sum of 1:1 saturation functions plus a constant
C Note: it is assumed that FUNCT has just been called so that THEORY
C       is correctly assigned
C          =========
C

      USE MODULE_HLFIT, ONLY : ITIME, FACT, CIN, NPTS, THEORY, XVAL,
     +                         YVAL, ERRY, DOFDOM, CIN, MODE

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N
      DOUBLE PRECISION, INTENT (INOUT) :: X(N)
      DOUBLE PRECISION, INTENT (OUT)   :: G(N), W(3*N)
C
C Locals
C      
      INTEGER    NN, NX
      PARAMETER (NN = 6, NX = 2*NN + 1)
      INTEGER    I, J, K
      DOUBLE PRECISION A(NN), B(NN)
      DOUBLE PRECISION BJ, BOT, BOT2, PDERIV, PROD, T, TERM
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      EXTERNAL FUNCT
C
C If FUNCT has not been called (e.g. from qnfit1) then call FUNCT to
C make absolutely sure THEORY is defined for the current parameter set
C===================================================================
C     CALL FUNCT (N, X, T)
      if (n.lt.0) call funct (n, x, t)!to silence NAGfor
      w(1) = zero  
        
C===================================================================
C
C
C Use FACT to scale the parameters
C
      DO I = 1, ITIME
         J = ITIME + I
         A(I) = FACT(I)*X(I)
         B(I) = FACT(J)*X(J)
         G(I) = ZERO
         G(J) = ZERO
      ENDDO
C
C Calculate the gradient ... remembering the constant if CIN = .TRUE.
C
      IF (MODE.EQ.1) THEN
         IF (CIN) THEN
            G(N) = ZERO
            DO I = 1, NPTS
               T = XVAL(I)
               TERM = (YVAL(I) - THEORY(I))/(ERRY(I)*ERRY(I))
               DO J = 1, ITIME
                  K = ITIME + J
                  PROD = B(J)*T
                  BOT = ONE + PROD
                  BOT2 = BOT*BOT
                  PDERIV = FACT(J)*PROD*TERM/BOT
                  G(J) = G(J) + PDERIV
                  PDERIV = FACT(K)*A(J)*T*TERM/BOT2
                  G(K) = G(K) + PDERIV
               ENDDO
               G(N) = G(N) + FACT(N)*TERM
            ENDDO
         ELSE
            DO I = 1, NPTS
               T = XVAL(I)
               TERM = (YVAL(I) - THEORY(I))/(ERRY(I)*ERRY(I))
               DO J = 1, ITIME
                  K = ITIME + J
                  PROD = B(J)*T
                  BOT = ONE + PROD
                  BOT2 = BOT*BOT
                  PDERIV = FACT(J)*PROD*TERM/BOT
                  G(J) = G(J) + PDERIV
                  PDERIV = FACT(K)*A(J)*T*TERM/BOT2
                  G(K) = G(K) + PDERIV
               ENDDO
            ENDDO
         ENDIF
      ELSE
         IF (CIN) THEN
            G(N) = ZERO
            DO I = 1, NPTS
               T = XVAL(I)
               TERM = (YVAL(I) - THEORY(I))/(ERRY(I)*ERRY(I))
               DO J = 1, ITIME
                  K = ITIME + J
                  BJ = B(J)
                  PROD = BJ*T
                  BOT = ONE + PROD
                  BOT2 = BOT*BOT
                  PDERIV = FACT(J)*BJ*TERM/BOT
                  G(J) = G(J) + PDERIV
                  PDERIV = FACT(K)*A(J)*TERM/BOT2
                  G(K) = G(K) + PDERIV
               ENDDO
               G(N) = G(N) + FACT(N)*TERM
            ENDDO
         ELSE
            DO I = 1, NPTS
               T = XVAL(I)
               TERM = (YVAL(I) - THEORY(I))/(ERRY(I)*ERRY(I))
               DO J = 1, ITIME
                  K = ITIME + J
                  BJ = B(J)
                  PROD = BJ*T
                  BOT = ONE + PROD
                  BOT2 = BOT*BOT
                  PDERIV = FACT(J)*BJ*TERM/BOT
                  G(J) = G(J) + PDERIV
                  PDERIV = FACT(K)*A(J)*TERM/BOT2
                  G(K) = G(K) + PDERIV
               ENDDO
            ENDDO
         ENDIF
      ENDIF
C
C Finally correct for the -2 and DOFDOM = NDOF
C
      T = - TWO/DOFDOM
      DO I = 1, N
         G(I) = T*G(I)
      ENDDO
      END
C
C--------------------------------------------------------------------------
C
          SUBROUTINE DETAIL (MAXNUM, NBIG, NN, NRAND, NSMALL, NSTART,
     +                       NSTOP,
     +                       SIGMA, YB, YBDYT, YT,
     +                       CIN, ISTOP, JUMP, NOUT_IN)
C
C Read orders, scaling, output, set types
C new version derived from mmfit_detail 24/08/2017 
C 05/02/2020 increased numopt from 24 to 25 and introduced new logical variable switch_off  
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NN
      INTEGER,          INTENT (INOUT) :: MAXNUM, NBIG, NRAND, NSMALL,
     +                                    NSTART, NSTOP
      DOUBLE PRECISION, INTENT (INOUT) :: SIGMA, YB, YBDYT, YT
      LOGICAL,          INTENT (IN)    :: JUMP  
      LOGICAL,          INTENT (INOUT) :: CIN, ISTOP, NOUT_IN(10)  
C
C locals
C        
      INTEGER    MTEXT, NUMCOL, NUMROW
      PARAMETER (MTEXT = 13, NUMCOL = 2, NUMROW = 0)     
      integer    numopt, numsta, numtxt, n1
      parameter (numopt = 25, numsta = 1, numtxt = numopt, n1 = 1)
      integer    i, icolor, ixl, iyl, j, kvalue(numopt), lshade,
     +           numbld(numopt), numpos(numopt), kvlim_1(numopt),
     +           kvlim_2(numopt)
      integer    icolor1, ix, iy, klog
      parameter (icolor1 = 9, ix = 4, iy = 4, klog = 11)
      parameter (icolor = 7, ixl = 0, iyl = 0, lshade = 0)
      double precision xvalue(numopt) 
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 100) svalue(numopt), text_in(numopt)
      character (len = 100) line, text(30)
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    nout(klog)
      logical    repeet, first_time
      logical    abort, first, yes
      logical    fixed, full, high
      parameter (fixed = .false., full = .true., high = .true.)
      logical    switch_off
      LOGICAL    BORDER, FLASH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE.)      
      external   advise, get00x, putfat, yesno1  
      intrinsic  max, min 
      save       first_time, switch_off
      data       first_time, switch_off / .true., .false. /
c
c check
c      
      if (switch_off) return
      if (nstart.lt.1 .or. nstart.gt.nstop .or. nstop.gt.nn) then 
         call putfat (
     +'Must have 1 =< NSTART =< NSTOP =< NN in call to DETAIL')
         return
      endif 
      if (nrand.lt.1 .or. nrand.gt.4) then
         call putfat ('Must have 1 =< NRAND =< 4 in call to DETAIL')
         return
      endif  
C
C Include C ?
C
      if (first_time) then
         first_time = .false.
         IF (JUMP) THEN
            CIN = .FALSE.
            YBDYT = ZERO
         ELSE   
            WRITE (TEXT,100)
            LINE = 'Do you want to vary a parameter C ?'
            YES = .FALSE.
            CALL YESNO1 (ICOLOR1, IX, IY, LSHADE, NUMCOL, NUMROW, MTEXT,
     +                   LINE, TEXT,
     +                   BORDER, FLASH, HIGH, YES)
            IF (YES) THEN
               CIN = .TRUE.
               YBDYT = YB/YT
            ELSE
               CIN = .FALSE.
               YBDYT = ZERO
            ENDIF   
         ENDIF
      endif             
c
c initialise all local variables
c
      do i = 1, 10
         nout(i) = nout_in(i)
      enddo
      if (jump) cin = .false.
      nout(klog) = cin    
      do i = 1, numopt
         numbld(i) = 0
         numpos(i) = 0
         kvalue(i) = 0
         kvlim_1(i) = 0
         kvlim_2(i) = 0
         xvalue(i) = zero
         svalue(i) = blank
      enddo
c
c set parameters for nstart and nstop and default nrand
c      
      kvlim_1(2) = 1
      kvlim_2(2) = nn
      kvlim_1(3) = 1
      kvlim_2(3) = nn
      kvalue(2) = nstart
      kvalue(3) = nstop
      do i = 1, 4
         if (nrand.eq.i) kvalue(i + 5) = 1
      enddo
      if (switch_off) then
         kvalue(numopt - 1) = 0
      else   
         kvalue(numopt - 1) = 1
      endif   
c
c create the text array
c      
      write (text_in,200) n1, nn
      numpos(1) = 8 
         numbld(1) = 1!blue text
      numpos(2) = 9
      numpos(3) = 9
      numpos(4) = 8
      numpos(5) = 8
         numbld(5) = 1!blue text
      numpos(6) = 6
      numpos(7) = 6 
      numpos(8) = 6
      numpos(9) = 6
      numpos(10) = 8
      numpos(11) = 8
         numbld(11) = 1!blue text
      numpos(12) = 4
      numpos(13) = 4
      numpos(14) = 4 
      numpos(15) = 4
      numpos(16) = 4
      numpos(17) = 4
      numpos(18) = 4
      numpos(19) = 4
      numpos(20) = 4
      numpos(21) = 4
      numpos(22) = 4
      numpos(23) = 4
      numpos(24) = 4
      numpos(25) = 4
C
C set logical parameters
C nout(1)  ... display analysis table
C nout(2)  ... display starting estimates
C nout(3)  ... display random search
C nout(4)  ... plot    best fit curves
C nout(5)  ... plot    residuals
C nout(6)  ... display residuals table
C nout(7)  ... file    residuals table
C nout(8)  ... high precision convergence test
C nout(9)  ... parameters and covariance matrix
C nout(10) ... graphical deconvolution
C
      j = 11
      do i = 1, klog
         j = j + 1
         if (nout(i)) kvalue(j) = 1
      enddo  
c
c loop over the options
c      
      repeet = .true.
      do while (repeet)
         kvalue(numopt - 1) = 0
         kvalue(numopt) = 0
         call get00x (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +                lshade, numbld, numopt, numpos, numsta, numtxt,
     +                xvalue,
     +                svalue, text_in,
     +                fixed, full, high)
c
c define nstart, nstop
c     
         nstart = min(kvalue(2),kvalue(3))
         nstop = max(kvalue(2),kvalue(3))
c
c define nrand
c         
         j = 0
         do i = 6, 9
            j = j + 1
            if (kvalue(i).eq.1) then
               nrand = j
            endif
         enddo  
         IF (NRAND.EQ.1) THEN
            MAXNUM = 400
            NBIG = 10
            NSMALL = 1
            SIGMA = 0.5D+00
         ELSEIF (NRAND.EQ.2) THEN
            MAXNUM = 1000
            NBIG = 25
            NSMALL = 2
            SIGMA = 0.3D+00
         ELSEIF (NRAND.EQ.3) THEN
            MAXNUM = 2500
            NBIG = 50
            NSMALL = 4
            SIGMA = 0.125D+00  
         ENDIF 
c
c assign logical variables
c
         j = 11
         do i = 1, klog
            j = j + 1
            if (kvalue(j).eq.1) then
               nout(i) = .true.
            else
               nout(i) = .false.
            endif   
         enddo  
         if (kvalue(numopt - 1).eq.1) switch_off = .true. 
c
c check if Advise or Quit have been chosen
c          
         if (kvalue(numopt - 2).eq.1) then
             first = .false.
             call advise (i, 
     +                    blank,
     +                    abort, first) 
             repeet = .true.
         elseif (kvalue(numopt).eq.1) then
            istop = .true.
            return    
         else
            do i = 1, 10
               nout_in(i) = nout(i)
            enddo   
            if (jump) then
               cin = .false.
            else   
               cin = nout(klog)
            endif   
            if (cin) then
               ybdyt = yb/yt
            else
               ybdyt = zero
            endif      
            repeet = .false.    
         endif  
      enddo   
      if (jump) cin = .false.
c
c format statements
c 
  100 FORMAT (
     + 'First time query about the baseline correction parameter C'
     +/
     +/'Including a term C causes curve-fitting problems leading to'
     +/'poorer parameter estimates.'
     +/
     +/'If your data have f(0) = 0 (in Normal mode) or f(infinity) = 0'
     +/'(in Isotope mode) you do not need C and should not include it.'
     +/
     +/'If you have a nonzero limit a baseline correction is required,'
     +/'so you should first include a term C for a preliminary run to'
     +/'estimate C. Then you can use program EDITFL to subtract C'
     +/'from the Y-data and re-fit using HLFIT models with C = 0.'
     +/)       
  200 FORMAT (
     + 'Choose the sequence of High/Low affinity sites required'    !1
     +/'Lowest order (>=',i2,')'                                    !2
     +/'Highest order (=<',i2,')'                                   !3
     +/                                                             !4
     +/'Choose the method to use for parameter starting estimates'  !5 
     +/'Short Random search'                                        !6
     +/'Medium Random search'                                       !7
     +/'Extensive Random search'                                    !8 
     +/'You input starting estimates'                               !9
     +/                                                             !10
     +/'Choose the procedures required for this analysis'           !11 
     +/'Display the goodness of fit analysis'                       !12
     +/'Display values of starting estimates'                       !13
     +/'Display details of any random search'                       !14
     +/'Plot the best fit curves and data'                          !15 
     +/'Provide options to plot residuals'                          !16
     +/'Display tables of (wtd.) residuals'                         !17
     +/'Write residuals to results log file'                        !18
     +/'Use analytic-gradient/high-precision'                       !19
     +/'Store/test parameters/covariance-matrix'                    !20
     +/'Display graphical deconvolution for order > 1'              !21 
     +/'Fit a baseline correction factor C (Usually no)'            !22
     +/'Help'                                                       !23
     +/'Do not ask again this sesion'                               !24    
     +/'Quit ... Try other options')                                !25                       
      END
C
C--------------------------------------------------------------
C
      SUBROUTINE FUNCT1 (N,
     +                   XC, FC)
C
C Evaluation of the weighted residual  if NPTS = 1
C Evaluation of the objective function if NPTS > 1
C

      USE MODULE_HLFIT, ONLY : NPTS, ERRY, THEORY, YVAL, DOFDOM

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      DOUBLE PRECISION, INTENT (IN)  :: XC(N)
      DOUBLE PRECISION, INTENT (OUT) :: FC
C
C Locals
C      
      INTEGER    I
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL ZMOD
      CALL ZMOD (XC)
      IF (NPTS.EQ.1) THEN
         FC = (YVAL(1) - THEORY(1))/ERRY(1)
      ELSE
         FC = ZERO
         DO I = 1, NPTS
            FC = FC + ((YVAL(I) - THEORY(I))/ERRY(I))**2
         ENDDO
         FC = FC/DOFDOM
      ENDIF
      END
C
C------------------------------------------------------------------------      
C
      SUBROUTINE RANDOM (ISTATE, ITIME, MAXNUM, MODE, NBIG, NDOF, NF,
     +                   NN, NPAR, NPTS, NRAND, NSMALL, NX,
     +                   DOFDOM, FACT, SIGMA, STORES, WSSQ, X, XM,
     +                   YBDYT, YT,
     +                   CIN, ISTOP, NOUT)
C
C Random search for starting estimates for scaling factors
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NN, NX
      INTEGER,          INTENT (IN)    :: ITIME, MODE, NF, NPTS
      INTEGER,          INTENT (INOUT) :: NPAR(NN)
      INTEGER,          INTENT (OUT)   :: ISTATE(NX), NDOF
      INTEGER,          INTENT (IN)    :: MAXNUM, NBIG,  NRAND, NSMALL
      DOUBLE PRECISION, INTENT (IN)    :: SIGMA, XM, YBDYT, YT
      DOUBLE PRECISION, INTENT (OUT)   :: DOFDOM, FACT(NX), X(NX)
      DOUBLE PRECISION, INTENT (INOUT) :: STORES(NX), WSSQ(NN)
      LOGICAL,          INTENT (IN)    :: CIN, NOUT(10)
      LOGICAL,          INTENT (INOUT) :: ISTOP
C
C Locals
C     
      INTEGER    I, ITIME1, ITIME2, J, K, L, N, NDIMEX, NLOOPS, NTYPES
      INTEGER    NUMBER(3)
      INTEGER    COLOUR
      DOUBLE PRECISION PNT1, PNT2
      PARAMETER (PNT1 = 0.1D+00, PNT2 = 0.2D+00)
      DOUBLE PRECISION A, B, BMA, DUMMY, F, FSUM, STDEV
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, TEN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION G05CAF$, G05DDF$
      CHARACTER  SYMBOL(3)*6
      CHARACTER  LINE*100
      LOGICAL    POSTIV(20)
      EXTERNAL   G05CAF$, G05DDF$
      EXTERNAL   PUTFAT, XSTART, TABLE1
      EXTERNAL   FUNCT1, TESTQS
      INTRINSIC  DBLE
      IF (ISTOP) RETURN
C
C Define NPAR, NDOF, DOFDOM then set up random search
C
      ITIME1 = ITIME + 1
      ITIME2 = 2*ITIME
      NPAR(ITIME) = ITIME2
      IF (CIN) NPAR(ITIME) = NPAR(ITIME) + 1
      N = NPAR(ITIME)
      NDOF = NPTS - N
      DOFDOM = NDOF
      IF (NDOF.LE.0) THEN
         CALL PUTFAT ('Insufficient data ... Analysis terminated')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      DO I = 1, ITIME2
         ISTATE(I) = 1
         IF (I.LE.ITIME) THEN
            FACT(I) = ONE/DBLE(ITIME)
         ELSE
            FACT(I) = ONE
         ENDIF
         X(I) = ONE
      ENDDO
      IF (CIN) THEN
         ISTATE(N) = 1
         FACT(N) = YBDYT
         X(N) = ONE
      ENDIF
C
C Omit random search if starting estimates are to be input
C
      IF (NRAND.EQ.4) GOTO 20
      IF (NOUT(3)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         COLOUR = 4
      ELSE
C
C Use format 100 to indicate the search is in progress ?
C
      ENDIF
      CALL FUNCT1 (N, X, F)
      L = 1
      CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +             DOFDOM, F, FACT, STORES,
     +             NOUT)
      NLOOPS = NBIG*(2**N)
      IF (NLOOPS.GT.MAXNUM) NLOOPS = MAXNUM
      A = ONE
      B = ZERO
      STDEV = SIGMA
C
C First a global random search from fixed starting point
C
      DO I = 1, NSMALL
         B = B + THREE
         BMA = B - A
         STDEV = TWO*STDEV
         DO J = 1, NLOOPS
            DO K = 1, ITIME
               FACT(K) = A + BMA*G05CAF$(DUMMY)
            ENDDO
            DO K = ITIME1, ITIME2
               FACT(K) = TEN**G05DDF$(ZERO, STDEV)
            ENDDO
            FSUM = ZERO
            IF (MODE.EQ.1) THEN
               DO K = 1, ITIME
                  FSUM = FSUM + FACT(K)
               ENDDO
            ELSE
               DO K = 1, ITIME
                  FSUM = FSUM + FACT(K)*FACT(ITIME + K)
               ENDDO
            ENDIF
            FSUM = FSUM*(TEN**G05DDF$(ZERO, PNT1))
            DO K = 1, ITIME
               FACT(K) = FACT(K)/FSUM
            ENDDO
            IF (CIN) FACT(N) = TEN**G05DDF$(ZERO, PNT1)
            CALL FUNCT1 (N, X, F)
            L = 2
            CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +                   DOFDOM, F, FACT, STORES,
     +                   NOUT)
         ENDDO
         IF (NOUT(3)) THEN
            WRITE (LINE,200) I, STDEV
            WRITE (NF,200) I, STDEV
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
      ENDDO
C
C Now a local intelligent search with updated centre point
C
      DO I = 1, NLOOPS
         DO J = 1, ITIME
            FACT(J) = STORES(J)*(TEN**G05DDF$(ZERO, PNT2))
         ENDDO
         DO J = ITIME1, ITIME2
            FACT(J) = STORES(J)*(TEN**G05DDF$(ZERO, PNT2))
         ENDDO
         IF (CIN) FACT(N) = STORES(N)*(TEN**G05DDF$(ZERO, PNT1))
         CALL FUNCT1 (N, X, F)
         L = 2
         CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +                DOFDOM, F, FACT, STORES,
     +                NOUT)
      ENDDO
      IF (NOUT(3)) THEN
         WRITE (LINE,300) PNT1, PNT2
         WRITE (NF,300) PNT1, PNT2
         CALL TABLE1 (COLOUR, LINE)
      ENDIF
      L = 3
      CALL TESTQS (L, ITIME, NF, NN, NPAR, NX,
     +             DOFDOM, F, FACT, STORES,
     +             NOUT)
      GOTO 40
C
C Enter here to input starting estimates
C
   20 CONTINUE
      NDIMEX = ITIME2
      NTYPES = 2
      NUMBER(1) = ITIME
      NUMBER(2) = ITIME
      SYMBOL(1) = '     A'
      SYMBOL(2) = '     K'
      DO I = 1, ITIME2
         POSTIV(I) = .TRUE.
      ENDDO
      IF (CIN) THEN
         NDIMEX = NDIMEX + 1
         NTYPES = NTYPES + 1
         NUMBER(3) = 1
         SYMBOL(3) = '     C'
         POSTIV(N) = .FALSE.
      ENDIF
      CALL XSTART (NDIMEX, NTYPES, NUMBER, FACT, SYMBOL, POSTIV)
      DO I = 1, ITIME
         FACT(I) = FACT(I)/YT
      ENDDO
      DO I = ITIME1, ITIME2
         FACT(I) = FACT(I)*XM
      ENDDO
      IF (CIN) FACT(N) = FACT(N)/YT
   40 CONTINUE
      CALL FUNCT1 (N, X, F)
      WSSQ(ITIME) = DOFDOM*F
C
C Format statements
C      
C*100 FORMAT (1X,'Wait',3X,'...',3X,'Random search in progress')
  200 FORMAT (1X,'Search',I2,1X,'finished (sigma =',F5.2,')')
  300 FORMAT (1X,'Local search over (sigma =',F5.2,',',F5.2,')')
      END
C
C------------------------------------------------------------------------      
C
      SUBROUTINE TESTQS (ISEND, ITIME, NF, NN, NPAR, NX,
     +                   DOFDOM, F, FACT, STORES,
     +                   NOUT)
C
C Examine WSSQ for improvement and store best fit factors
C Make sure TESTQ is saved between calls
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NN, NX
      INTEGER,          INTENT (IN)    :: ISEND, ITIME, NF, NPAR(NN)
      DOUBLE PRECISION, INTENT (IN)    :: DOFDOM, F
      DOUBLE PRECISION, INTENT (INOUT) :: FACT(NX), STORES(NX)
      LOGICAL,          INTENT (IN)    :: NOUT(10)
C
C Locals
C      
      INTEGER    I, ICOUNT, J, JCOUNT
      INTEGER    COLOUR
      DOUBLE PRECISION TEMP, TESTQ, QSAVE
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER (LEN = 9) WORD9(2), FORM09
      EXTERNAL   TABLE1, FORM09
      SAVE       ICOUNT, JCOUNT, TESTQ, QSAVE
      IF (ISEND.EQ.1) THEN
         ICOUNT = 0
         JCOUNT = 0
         QSAVE  = DOFDOM*F
         IF (NOUT(3)) THEN
            WRITE (LINE,100) ITIME, ITIME
            WRITE (NF,100) ITIME, ITIME
            COLOUR = 4
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
      ELSEIF (ISEND.EQ.2) THEN
         ICOUNT = ICOUNT + 1
         IF (F.GE.TESTQ) RETURN
         JCOUNT = JCOUNT + 1
      ENDIF
      IF (ISEND.EQ.1 .OR. ISEND.EQ.2) THEN
         TESTQ = F
         IF (NOUT(3)) THEN
            TEMP = DOFDOM*F
            WORD9(1) = FORM09(TEMP)
C            WRITE (LINE,200) ICOUNT, DOFDOM*F
C            WRITE (NF,200) ICOUNT, DOFDOM*F
            WRITE (LINE,200) ICOUNT, WORD9(1)
            WRITE (NF,200) ICOUNT, WORD9(1)
            COLOUR = 0
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
         DO J = 1, NPAR(ITIME)
            STORES(J) = FACT(J)
         ENDDO
         RETURN
      ENDIF
      DO J = 1, NPAR(ITIME)
         FACT(J) = STORES(J)
      ENDDO
      IF (NOUT(3)) THEN
         WORD9(1) = FORM09(QSAVE)
         TEMP = DOFDOM*TESTQ
         WORD9(2) = FORM09(TEMP)
C         WRITE (TEXT,300) ITIME, ITIME, ICOUNT, JCOUNT,
C     +                    QSAVE, DOFDOM*TESTQ
C         WRITE (NF,300)ITIME,ITIME,ICOUNT,JCOUNT,QSAVE,DOFDOM*TESTQ
         WRITE (TEXT,300) ITIME, ITIME, ICOUNT, JCOUNT,
     +                    WORD9(1), WORD9(2)
         WRITE (NF,300) ITIME, ITIME, ICOUNT, JCOUNT, 
     +                  WORD9(1), WORD9(2)
         DO I = 1, 5
            IF (I.EQ.2) THEN
               COLOUR = 4
            ELSE
               COLOUR = 0
            ENDIF
            LINE = TEXT(I)
            CALL TABLE1 (COLOUR, LINE)
         ENDDO
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF
C
C Format statements
C      
  100 FORMAT (1X,'Iteration    WSSQ (',I1,':',I1,')')
C  200 FORMAT (1X,I8,4X,1P,E10.3)
  200 FORMAT (1X,I8,4X,1X,A)
  300 FORMAT (/1X,'For best random',I2,':',I1,1X,'search '
     +/1X,'Number of improvements in',I6,1X,'cycles =',I4
C     +/1X,'WSSQ before search =',1P,E10.3
C     +/1X,'WSSQ after  search =',   E10.3/)
     +/1X,'WSSQ before search =',1X,A
     +/1X,'WSSQ after  search =',1X,A/)
      END
C
C------------------------------------------------------------------------      
C
      SUBROUTINE VMAXKM (M, MODE, N, NTEMP,
     +                   P, VMAX, X, Y,
     +                   TEMP)
C
C Predict asymptote and half saturation point
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: M, MODE, N
      INTEGER,             INTENT (OUT) :: NTEMP  
      DOUBLE PRECISION,    INTENT (IN)  :: P(N), X, Y
      DOUBLE PRECISION,    INTENT (OUT) :: VMAX
      CHARACTER (LEN = *), INTENT (OUT) :: TEMP(30)
C
C Locals
C      
      INTEGER    NF
      PARAMETER (NF = 4)
      INTEGER    I, IR, IND, IFAIL
      DOUBLE PRECISION C(17), CONST, FKM, FX, FZ, TOLX, VOVER2, XX, YY
      CHARACTER  RECORD(3)*100
      CHARACTER (LEN = 9) FORM09, WORD9(2)
      EXTERNAL   C05AZF$
      EXTERNAL   PUTIFA, FORM09
      INTRINSIC  ABS
C
C Calculate Vmax and Km numerically
C
      VMAX = 0.0D+00
      IF (MODE.EQ.1) THEN
         DO I = 1, M
            VMAX = VMAX + P(I)
         ENDDO
      ELSE
         DO I = 1, M
            VMAX = VMAX + P(I)*P(M + I)
         ENDDO
      ENDIF
      IF (M.EQ.1 .AND. ABS(P(2)).GT.1.0D-100) THEN
         IFAIL = 0
         FKM = 1.0D+00/P(2)
      ELSE
         VOVER2 = VMAX/2.0D+00
         XX = X
         YY = Y
         TOLX = 1.0D-04
         IR = 0
         IND = 1
         IFAIL = 1
   20    CONTINUE
         CALL C05AZF$(XX, YY, FX, TOLX, IR, C, IND, IFAIL)
         FKM = XX
         IF (IND.EQ.0) GOTO 40
         IF (IND.LT.2 .OR. IND.GT.4) RETURN
         FX = 0.0D+00
         IF (MODE.EQ.1) THEN
            DO I = 1, M
               FZ = P(M + I)*XX
               FX = FX + P(I)*FZ/(1.0D+00 + FZ)
            ENDDO
         ELSE
            DO I = 1, M
               FZ = P(M + I)
               FX = FX + P(I)*FZ/(1.0D+00 + FZ*XX)
            ENDDO
         ENDIF
         FX = FX - VOVER2
         GOTO 20
   40    CONTINUE
      ENDIF
C
C Initialise NTEMP then fill in TEMP if appropriate
C
      NTEMP = 0
      IF (IFAIL.EQ.0) THEN
         WORD9(1) = FORM09(VMAX)
         WORD9(2) = FORM09(FKM)
         IF (MODE.EQ.1) THEN
C            WRITE (RECORD,100) VMAX, FKM
C            WRITE (NF,100) VMAX, FKM
            WRITE (RECORD,100) WORD9(1), WORD9(2)
            WRITE (NF,100) WORD9(1), WORD9(2)
         ELSE
C            WRITE (RECORD,200) VMAX, FKM
C            WRITE (NF,200) VMAX, FKM
            WRITE (RECORD,200) WORD9(1), WORD9(2)
            WRITE (NF,200) WORD9(1), WORD9(2)            
         ENDIF
         DO I = 1, 3
           NTEMP = NTEMP + 1
           TEMP(NTEMP) = RECORD(I)
         ENDDO
      ELSE
         CALL PUTIFA (IFAIL, NF, 'C05AZF/VMAXKM')
      ENDIF
C
C Further calculations required if parameter C is also varied
C
      IF (N.EQ.2*M + 1) THEN
         CONST = P(N)
         VMAX = VMAX + CONST
         VOVER2 = VMAX/2.0D+00
         XX = X
         YY = Y
         TOLX = 1.0D-04
         IR = 0
         IND = 1
         IFAIL = 1
   60    CONTINUE
         CALL C05AZF$(XX, YY, FX, TOLX, IR, C, IND, IFAIL)
         FKM = XX
         IF (IND.EQ.0) GOTO 80
         IF (IND.LT.2 .OR. IND.GT.4) RETURN
         FX = 0.0D+00
         IF (MODE.EQ.1) THEN
            DO I = 1, M
               FZ = P(M + I)*XX
               FX = FX + P(I)*FZ/(1.0D+00 + FZ)
            ENDDO
         ELSE
            DO I = 1, M
               FZ = P(M + I)
               FX = FX + P(I)*FZ/(1.0D+00 + FZ*XX)
            ENDDO
         ENDIF
         FX = FX + CONST - VOVER2
         GOTO 60
   80    CONTINUE
         IF (IFAIL.EQ.0) THEN
            WORD9(1) = FORM09(VMAX)
            WORD9(2) = FORM09(FKM)
C            WRITE (RECORD,300) VMAX, FKM
C            WRITE (NF,300) VMAX, FKM
            WRITE (RECORD,300) WORD9(1), WORD9(2)
            WRITE (NF,300) WORD9(1), WORD9(2)            
            DO I = 1, 3
               NTEMP = NTEMP + 1
               TEMP(NTEMP) = RECORD(I)
            ENDDO
         ELSE
            CALL PUTIFA (IFAIL, NF, 'C05AZF/VMAXKM')
         ENDIF
      ENDIF
C
C Format statements
C      
  100 FORMAT (
C     +/1X,'Apparent Ymax (i.e. A(1) + A(2) + ... + A(n)) =',1P,E13.5
C     +/1X,'Apparent Ka  (i.e. x where f(x) - C = Ymax/2) =',E13.5)
     +/1X,'Apparent Ymax (i.e. A(1) + A(2) + ... + A(n)) =',1X,A
     +/1X,'Apparent Ka  (i.e. x where f(x) - C = Ymax/2) =',1X,A)
  200 FORMAT (
C     +/1X,'App. Ymax (B(1)K(1)+B(2)K(2)+ ... +B(n)K(n)) =',1P,E13.5
C     +/1X,'Apparent Ka (i.e. x where f(x) - C = Ymax/2) =',E13.5)
     +/1X,'App. Ymax (B(1)K(1)+B(2)K(2)+ ... +B(n)K(n)) =',1X,A
     +/1X,'Apparent Ka (i.e. x where f(x) - C = Ymax/2) =',1X,A)
  300 FORMAT (
     + 1X,'The value of C is nonzero so we also calculate:'
     +/1X,'Ymax, the maximum predicted y value =',
C    +1P,E13.5
     +1X,A     
     +/1X,'X-half, i.e. x where f(x) is Ymax/2 =',
C     +E13.5)
     +1X,A)     
      END
C
C------------------------------------------------------------------------      
C
      SUBROUTINE ZMOD (P)
C
C Sum of 1:1 saturation functions plus a constant
C

      USE MODULE_HLFIT, ONLY : ITIME, FACT, CIN, EQUAL, THEORY, XVAL,
     +                         NPTS, MODE 

      IMPLICIT   NONE
C
C Argument
C      
      DOUBLE PRECISION, INTENT (IN) :: P(*)
C
C Locals
C      
      INTEGER    NN, NX
      PARAMETER (NN = 6, NX = 2*NN + 1)
      INTEGER    I, J
      DOUBLE PRECISION A(NN), B(NN)
      DOUBLE PRECISION BJ, CONST, TEMP, VSUM
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
C
C Use FACT to scale up the parameters
C
      DO I = 1, ITIME
         J = ITIME + I
         A(I) = FACT(I)*P(I)
         B(I) = FACT(J)*P(J)
      ENDDO
C
C Calculate THEORY = MODEL remembering the constant term if CIN = .TRUE.
C
      IF (CIN) THEN
         I = 2*ITIME + 1
         CONST = FACT(I)*P(I)
         IF (MODE.EQ.1) THEN
            DO I = 1, NPTS
               IF (EQUAL(I)) THEN
                  THEORY(I) = THEORY(I - 1)
               ELSE
                  VSUM = ZERO
                  DO J = 1, ITIME
                     TEMP = B(J)*XVAL(I)
                     VSUM = VSUM + A(J)*TEMP/(ONE + TEMP)
                  ENDDO
                  THEORY(I) = VSUM + CONST
               ENDIF
            ENDDO
         ELSE
            DO I = 1, NPTS
               IF (EQUAL(I)) THEN
                  THEORY(I) = THEORY(I - 1)
               ELSE
                  VSUM = ZERO
                  DO J = 1, ITIME
                     BJ = B(J)
                     TEMP = BJ*XVAL(I)
                     VSUM = VSUM + A(J)*BJ/(ONE + TEMP)
                  ENDDO
                  THEORY(I) = VSUM + CONST
               ENDIF
            ENDDO
         ENDIF
      ELSE
         IF (MODE.EQ.1) THEN
            DO I = 1, NPTS
               IF (EQUAL(I)) THEN
                  THEORY(I) = THEORY(I - 1)
               ELSE
                  VSUM = ZERO
                  DO J = 1, ITIME
                     TEMP = B(J)*XVAL(I)
                     VSUM = VSUM + A(J)*TEMP/(ONE + TEMP)
                  ENDDO
                  THEORY(I) = VSUM
               ENDIF
            ENDDO
         ELSE
            DO I = 1, NPTS
               IF (EQUAL(I)) THEN
                  THEORY(I) = THEORY(I - 1)
               ELSE
                  VSUM = ZERO
                  DO J = 1, ITIME
                     BJ = B(J)
                     TEMP = BJ*XVAL(I)
                     VSUM = VSUM + A(J)*BJ/(ONE + TEMP)
                  ENDDO
                  THEORY(I) = VSUM
               ENDIF
            ENDDO
         ENDIF
      ENDIF
      END
C
C
