C
C FTN95 version
C =============
C
C
C The following extra source files must be included
C =================================================
C INRATE1.INS: ADVISE, DATAIN, DATFIT
C INRATE2.INS: DATOUT, DETAIL
C INRATE3.INS: GOFFIT, SUMMIT, ZEROIN, DSDT, FUNC
C INRATE4.INS: LSFUN1, FMOD, FZER, LSJAC1, JMOD, JZER
C
C The COMMON blocks are needed to communicate with the models
C     ======
C The dimensions must agree with those in the COMMON blocks
C
C Now include the extra source
C ============================
C
C     INCLUDE 'inrate1.ins', NOLIST
C     INCLUDE 'inrate2.ins', NOLIST
C     INCLUDE 'inrate3.ins', NOLIST
C     INCLUDE 'inrate4.ins', NOLIST
C     INCLUDE 'dllchk.for'
C
C
      PROGRAM INRATE
C
C VERSION : details from SIMVER/DLLCHK
C           Best-fit initial rates and asymptotes
C           Derived from GCFIT not the 'original' INRATE program
C MINPACK : LMDER1/LMFUNC/LMFIT1
C INPUT   : File with TITLE, NPTS, TIME, SIZE, Standard error in
C           size as formatted by program MAKFIL.
C MODELS  :  1. LINE
C            2. QUADRATIC
C            3. EXPONENTIAL
C            4. HILL
C            5. LINE/EXPONENTIAL
C OUTPUT  : Best-fit parameters, standard errors, residuals, statistics
C ADVICE  : The program requires that SIZE >= 0, TIME >= 0 , TIME points
C           in increasing order and ERROR IN SIZE > 0.
C           Set array dimension using parameter NMAX
C AUTHOR  : W. G. Bardsley, 12/6/91
C           13/1/92 Corrected output for model 3 and provision for F(0) = 0
C           15/4/92 ENDALL, REPEAT, ZEROIN and extensive revision
C           5/5/92 CORCOF and R squared
C           18/1/93 GET???, PUT??? etc. and compressed
C           15/6/93 RESFIL
C           DBOS version ... 9/6/94
C           20/2/95 Salamanca version
C           31/10/95 Split source file and upgraded for nag mark 16
C           26/8/97 win32 version ... replaced NAG by MINPACK
C           28/8/97 corrected W(N4 + 1) and W(N5 + 1) to allow for
C           replicates when calculating residuals for analysis
C           22/3/98 Added GOGOGO and NEW
C           7/8/97 added dllchk
C           18/11/98 added Shapiro_Wilks
C           14/12/98 replaced TUTORS by TUTOR1
C           19/08/99 revised control
C           13/09/99 added call to WINDOW
C           06/12/99 added default value for KPAR
C           12/02/2000 added SIMVER
C           01/10/2000 added asymptote to graphs and warning about
C                      positive exponentials as counted by NTOTL2
C           28/03/2001 revised
C           30/07/2005 increased DVER to *30 and added to call to ADVISE
C           01/04/2022 added e_numbers and e_formats, etc. and introduced
C                      NDEM and DEMFIL to allow the demonstration of test files   
C
      IMPLICIT   NONE
      INTEGER    NGRAF, NMAX, NOPT, NX
      PARAMETER (NGRAF = 120, NMAX = 10000, NOPT = 5, NX = 4)
      INTEGER    NCMAX, NRMAX
      PARAMETER (NCMAX = NX, NRMAX = NMAX)
      INTEGER    NF, NIN
      PARAMETER (NF = 4, NIN = 3)
      INTEGER    LW
      PARAMETER (LW = 8*NRMAX)
      INTEGER    ISEND, NBAD, NDEM, NDOF, NDIST, NFLY, NPAR, NPTS
      INTEGER    ITIME, KPAR, NTOTL1, NTOTL2
      DOUBLE PRECISION CV(NCMAX,NCMAX), FJAC(NRMAX,NCMAX), FVEC(NRMAX),
     +                 STD(NCMAX), XGRAF(NGRAF), W(LW), X(NCMAX)
      DOUBLE PRECISION CONST, SLOPE, SMAX, SMIN, TMAX, TMIN, WSSQ
      DOUBLE PRECISION AVRR, STAT(NOPT,9), YABS
      DOUBLE PRECISION EN, SN, TN
      DOUBLE PRECISION PARAM, VALN
      DOUBLE PRECISION ENEG, EPOS, EPSI, RTOL
      DOUBLE PRECISION XVER, YVER
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_inrate.exe')
      CHARACTER  DNAME*1024, FNAME*1024, QUAL(NRMAX)*4, TITLE*100
      CHARACTER  BLANK*1, PNAME*6
      PARAMETER (BLANK = ' ', PNAME = 'INRATE')
      LOGICAL    ISTOP, NOUT(2), OMIT(NOPT), PLOT(2)
      LOGICAL    EQUAL, FIXN, ZERO
      LOGICAL    WEIGHT
      LOGICAL    FITTED(NOPT)
      LOGICAL    DOIT, FIRST, NEW, REPEET
      LOGICAL    ABORT, ACTION, SHOW
      COMMON
     +/ARR/ EN(NMAX), SN(NMAX), TN(NMAX)
     +/INT/ ITIME, KPAR, NTOTL1, NTOTL2
     +/LGL/ EQUAL(NMAX), FIXN, ZERO
     +/PAR/ PARAM(NX), VALN
     +/TOL/ ENEG, EPOS, EPSI, RTOL
      EXTERNAL GOGOGO
      EXTERNAL ADVISE, DATAIN, DETAIL, DATFIT, DATOUT, GOFFIT, SUMMIT
      EXTERNAL DLLCHK, WINDOW, SIMVER

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND, TITLE, ACTION)
      CALL SIMVER (XVER, YVER, DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER, DVER, PVER, ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

      FIRST = .TRUE.
      CALL ADVISE (NMAX,
     +             DVER,
     +             ISTOP, FIRST)
      IF (ISTOP) THEN
         DOIT = .FALSE.
      ELSE
         KPAR = 1
         DOIT = .TRUE.
         VALN = 1.0D+00
         FIXN = .TRUE.
         ZERO = .FALSE.
         NOUT(1) = .TRUE.
         NOUT(2) = .FALSE.
         PLOT(1) = .TRUE.
         PLOT(2) = .FALSE.
         DO ITIME = 1, NOPT
            OMIT(ITIME) = .TRUE.
         ENDDO
         OMIT(2) = .FALSE.
         DNAME = BLANK
         FNAME = BLANK
         NEW = .TRUE.
      ENDIF
C
C Main loop ... Read in new data then fit
C Note: initialisation of NDEM for DATAIN and DETAIL 
C
      NDEM = 1
      IF (DOIT) THEN
         REPEET = .TRUE.
         DO WHILE (REPEET)
            CALL DATAIN (LW, NDEM, NDIST, NF, NGRAF, NIN, NMAX, NPTS,
     +                   NOPT,
     +                   CONST, EN, ENEG, EPOS, EPSI, RTOL, SLOPE,
     +                   SMAX, SMIN, SN, TMAX, TMIN, TN, W, XGRAF,
     +                   DNAME, FNAME,
     +                   EQUAL, ISTOP, NEW, OMIT, WEIGHT)
            IF (ISTOP) THEN
               DOIT = .FALSE.
               DNAME = BLANK
            ELSE
C
C Decide what to do
C
               CALL DETAIL (NDEM, NOPT, VALN, FIXN, ISTOP, NOUT,
     +                      OMIT, PLOT, ZERO)
               IF (ISTOP) THEN
                  DOIT = .FALSE.
               ELSE
                  DOIT = .TRUE.
               ENDIF
            ENDIF
C
C The main loop
C
            IF (DOIT) THEN
               DO ITIME = 1, NOPT
                  ISTOP = .FALSE.
                  FITTED(ITIME) = .FALSE.
                  NTOTL1 = 0
                  NTOTL2 = 0
                  CALL DATFIT (ITIME, LW, NCMAX, NDIST, NDOF, NF, NOPT,
     +                         NPAR, NPTS, NRMAX,
     +                         CONST, CV, FJAC, FVEC, RTOL, SLOPE,
     +                         SMIN, SN, STD, TMIN, TN, VALN, W,
     +                         WSSQ, X,
     +                         EQUAL, FIXN, ISTOP, OMIT, ZERO)
                  CALL DATOUT (ITIME, KPAR, LW, NBAD, NCMAX, NDOF, NF,
     +                         NFLY, NOPT, NPAR, NPTS, NRMAX,
     +                         NTOTL1, NTOTL2,
     +                         AVRR, CV, EN, EPSI, PARAM, RTOL, SMAX,
     +                         SN, STD, TMAX, TMIN, TN, VALN, W, X,
     +                         YABS, QUAL,
     +                         EQUAL, FIXN, ISTOP, NOUT, OMIT, ZERO)
                  CALL GOFFIT (ITIME, KPAR, LW, NBAD, NDOF, NF, NFLY,
     +                         NGRAF, NOPT, NPTS,
     +                         AVRR, PARAM, RTOL, STAT, W, WSSQ, XGRAF,
     +                         YABS,
     +                         ISTOP, NOUT, OMIT, PLOT, WEIGHT)
                  IF (.NOT.OMIT(ITIME) .AND. .NOT.ISTOP)
     +                FITTED(ITIME) = .TRUE.
               ENDDO
C
C Sum it all up
C
               CALL SUMMIT (NF, NOPT, STAT, FITTED, WEIGHT)
            ENDIF
C
C Another go ?
C
            CALL GOGOGO (NF, DNAME, FNAME, PNAME, 
     +                   ISTOP, NEW)
            IF (ISTOP) THEN
               REPEET = .FALSE.
            ELSE
               REPEET = .TRUE.
            ENDIF
         ENDDO
      ENDIF
C
C Terminate program
C

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND, TITLE, ACTION)
C
C======================================================================
C

      CLOSE (UNIT = NF)
      END
C
C
