C
C
C INRATE1.INS
C ===========
C ADVISE
C DATAIN
C DATFIT
C DEMFIL
C
      SUBROUTINE ADVISE (NMAX,
     +                   DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NMAX
      CHARACTER  DVER*(*)
      LOGICAL    ABORT, FIRST
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 14, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_INRATE
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER, NMAX
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_INRATE ('inrate')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `INRATE'
     +/'        `      '
     +/'Action  `Best fit (weighted least squares) using up to five'
     +/'        `models to estimate initial rates, lag time, steady'
     +/'        `state rates or horizontal/inclined asymptotes.'
     +/'        `      '
     +/'Version `',A
     +/'        `Maximum number of rows',I6
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
      SUBROUTINE DATAIN (LW, NDEM, NDIST, NF, NGRAF, NIN, NMAX, NPTS,
     +                   NOPT,
     +                   CONST, EN, ENEG, EPOS, EPSI, RTOL, SLOPE, SMAX,
     +                   SMIN, SN, TMAX, TMIN, TN, W, XGRAF,
     +                   FNAME, DATOUT,
     +                   EQUAL, ISTOP, NEW, OMIT, WEIGHT)
C
C Set tolerance parameters ENEG, EPOS and RTOL
C Read in TITLE, NPTS, TIME, SIZE, ERRROR and calculate SMAX and TMAX
C Then normalise data to generate TN, SN and EN and linear regression
C to first 3 distinct data values for slope and intercept
C 01/04/2022 NDEM and DEMFIL added
C
      IMPLICIT   NONE
      INTEGER    LW, NGRAF, NMAX
      INTEGER    NCOL, NDEM, NDIST, NF, NIN, NPTS, NOPT
      INTEGER    I, IFAIL, ITYPE, J, NDATA
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 4, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 7,
     +           NSTART = 10, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION CONST, EN(NMAX), ENEG, EPOS, EPSI, RTOL, SLOPE,
     +                 SMAX, SMIN, SN(NMAX), TMAX, TMIN, TN(NMAX),
     +                 W(LW), XGRAF(NGRAF)
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION RESUL(20)
      DOUBLE PRECISION DELTA, WMAX, WMIN
      DOUBLE PRECISION X02AJF$, X02AMF$
      LOGICAL    EQUAL(NMAX), FIXN, ISTOP, NEW, OMIT(NOPT), WEIGHT
      LOGICAL    FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      CHARACTER  DATOUT*(*), FNAME*(*)
      CHARACTER  LINE*100, TEXT(30)*100, TITLE*80
      EXTERNAL   DEMFIL
      EXTERNAL   X02AMF$, X02AJF$, G02CAF$, LBOX01
      EXTERNAL   DATTIN, DATCHK, PUTFAT, PUTIFA, RESFIL, DATSXY
      INTRINSIC  LOG, ABS, DBLE
      SAVE  ITYPE, NDATA
      DATA  NDATA / 0 /
      DATA  NUMBLD / 16*0 /
      DATA  NUMPOS / NUMOPT*1 /
      IF (ISTOP) RETURN
C
C Assign RTOL, ENEG, EPOS, EPSI
C
      RTOL = 1.0D+09*X02AMF$()
      ENEG = LOG(RTOL)/TWO
      EPOS = - ENEG/TWO
      EPSI = X02AJF$()
      WMAX = ONE + TWO*EPSI
      WMIN = ONE - TWO*EPSI
C
C First time menu
C
      IF (NDATA.EQ.0 .OR. NDEM.NE.0) THEN
         WRITE (TEXT,100)
         NUMBLD(1) = 4
         ITYPE = 2
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, ITYPE, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NDEM = 0
         IF (ITYPE.GE.4 .AND. ITYPE.LE.7) THEN
             NDEM = ITYPE - 3
             ITYPE = 2
             CALL DEMFIL (NDEM, NOPT,
     +                    FNAME,
     +                    FIXN, OMIT)           
         ENDIF  
         NUMBLD(1) = 0
      ENDIF
C
C Read in and check data
C
      IF (NDEM.GE.1 .AND. NDEM.LE.4) THEN
C
C read in fro test files
C	        
         OPEN (UNIT = NIN, FILE = FNAME)
         READ (NIN,'(A)') TITLE
         READ (NIN,*) NPTS, NCOL
         DO I = 1, NPTS
            IF (NCOL.EQ.2) THEN
               READ (NIN,*) TN(I), SN(I)
               EN(I) = ONE
            ELSE
               READ (NIN,*) TN(I), SN(I), EN(I)
            ENDIF  
         ENDDO  
         CLOSE (UNIT = NIN)
      ELSEIF (NEW) THEN
C
C use DATTIN to get data from file or console depending on ITYPE 
C      
         CLOSE (UNIT = NIN)
         CALL DATTIN (ITYPE, NIN, NMAX, NPTS, EN, TN, SN, FNAME, TITLE,
     +                ISTOP, FIXNPT, LABEL)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ELSE
         CLOSE (UNIT = NIN)
         CALL DATSXY (NIN, NMAX, NPTS, EN, TN, SN, FNAME, TITLE, ISTOP)
         CLOSE (UNIT = NIN)
         IF (ISTOP) RETURN
      ENDIF
      CALL DATCHK (NPTS, EN, TN, SN, ISTOP)
      IF (ISTOP) RETURN
C
C Further checks on input data
C
      IF (NPTS.LT.2) THEN
         CALL PUTFAT ('< 2 data points ... No analysis')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      SMAX = SN(1)
      SMIN = SN(1)
      TMAX = TN(NPTS)
      TMIN = TN(1)
      NDIST = 1
      WEIGHT = .FALSE.
      DO I = 1, NPTS
         IF (.NOT.WEIGHT) THEN
            IF (EN(I).LT. WMIN .OR. EN(I).GT.WMAX) WEIGHT = .TRUE.
         ENDIF
         IF (SN(I).GT.SMAX) SMAX = SN(I)
         IF (SN(I).LT.SMIN) SMIN = SN(I)
         IF (TN(I).GT.TMAX) TMAX = TN(I)
         IF (TN(I).LT.TMIN) TMIN = TN(I)
         EQUAL(I) = .FALSE.
         IF (I.GT.1) THEN
            IF (ABS(TN(I) - TN(I - 1)).LE.RTOL) THEN
               EQUAL(I) = .TRUE.
            ELSE
               NDIST = NDIST + 1
            ENDIF
          ENDIF
      ENDDO
      IF (NDIST.LT.2) THEN
         CALL PUTFAT ('Must have at least 2 distinct t-values')
         ISTOP = .TRUE.
         RETURN
      ENDIF
C
C Calculate XGRAF for graphical axes in external coordinates
C
      XGRAF(1) = TMIN
      DELTA = (TMAX - XGRAF(1))/(DBLE(NGRAF) - ONE)
      DO I = 2, NGRAF - 1
         XGRAF(I) = XGRAF(I - 1) + DELTA
      ENDDO
      XGRAF(NGRAF) = TMAX
C
C SMAX and TMAX have now been recorded and so the original data can be
C normalised to produce EN, SN and TN where 0 <= SN <= 1, 0 <= TN <= 1
C
      DO I = 1, NPTS
         EN(I) = EN(I)/SMAX
         SN(I) = SN(I)/SMAX
         TN(I) = TN(I)/TMAX
         IF (EN(I).LE.RTOL .OR. SN(I).LT.ZERO .OR. TN(I).LT.ZERO) THEN
            WRITE (LINE,200) I
            CALL PUTFAT (LINE)
            ISTOP = .TRUE.
            RETURN
         ENDIF
      ENDDO
      SMIN = SMIN/SMAX
      TMIN = TMIN/TMAX
C
C Now find first three set of distinct points and estimate slope/intercept
C
      J = 0
      DO I = 1, 3
         J = J + 1
         W(J) = TN(J)
         W(NPTS + J) = SN(J)
         IF (EQUAL(J + 1)) THEN
   20      CONTINUE
           J = J + 1
           W(J) = TN(J)
           W(NPTS + J) = SN(J)
           IF (EQUAL(J + 1)) GOTO 20
         ENDIF
      ENDDO
      IFAIL = 1
      CALL G02CAF$(J, W(1), W(NPTS + 1), RESUL, IFAIL)
      CALL PUTIFA (IFAIL, NF, 'G02CAF/DATTIN')
      IF (IFAIL.NE.0) THEN
         CONST = ZERO
         SLOPE = ONE
      ELSE
         CONST = RESUL(7)
         SLOPE = RESUL(6)
      ENDIF
C
C Open output file for results and write out program declaration
C
      IF (NDATA.EQ.0) THEN
         CALL RESFIL (NF, DATOUT, ISTOP)
         IF (ISTOP) RETURN
         WRITE (NF,300)
      ENDIF
      NDATA = NDATA + 1
      WRITE (NF,400) NDATA, TITLE
C
C Format statements
C      
  100 FORMAT (
     + 'Select the data input mode required'
     +/
     +/'Files formatted for curve fitting prepared'
     +/'by program MAKFIL are recommended.'
     +/
     +/'To input test files choose the [Input from files] option'
     +/'then press the [Demo] button instead of selecting a file,'
     +/'or choose to demonstrate the model types shown in the menu.'
     +/
     +/'Type in all data (from now on)'
     +/'Input from files (from now on)'
     +/'Choose input mode each time'
     +/'Demo Model 2 (quadratic initial rate)'
     +/'Demo Model 3 (monomolecular/horizontal asymptote)'
     +/'Demo Model 4 (Hill/Michaelis-Menten/horizontal asymptote'
     +/'Demo Model 5 (Lag-Burst to inclined asymptote)')
  200 FORMAT ('t, s or y < 0 at data point',I6)
  300 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : INRATE'
     +/1X,'ACTION  : Estimate initial rates and/or final asymptotes'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  400 FORMAT (/1X,'Analysis number',I3/1X,'------------------'
     +/1X,'Data title'/1X,A)
      END
C
C
      SUBROUTINE DATFIT (ITIME, LW, NCMAX, NDIST, NDOF, NF, NOPT, NPAR,
     +                   NPTS, NRMAX,
     +                   CONST, CV, FJAC, FVEC, RTOL, SLOPE, SMIN,
     +                   SN, STD, TMIN, TN, VALN, W, WSSQ, X,
     +                   EQUAL, FIXN, ISTOP, OMIT, ZERO)
C
C Set appropriate starting parameter estimates then curve-fit
C
      IMPLICIT   NONE
      INTEGER    LW, NCMAX, NOPT, NRMAX
      INTEGER    ITIME, NDIST, NDOF, NF, NPAR, NPTS
      INTEGER    IPVT(5)
      INTEGER    I, IFAIL, IRANK, J, K, M, N
      DOUBLE PRECISION CONST, CV(NCMAX,NCMAX), FJAC(NRMAX,NCMAX),
     +                 FVEC(NRMAX), RTOL, SLOPE, SMIN, SN(NRMAX),
     +                 STD(NCMAX), TMIN, TN(NRMAX), VALN, W(LW),
     +                 WSSQ, X(NCMAX)
      DOUBLE PRECISION RESUL(20)
      DOUBLE PRECISION ZERO1, ONE
      PARAMETER (ZERO1 = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION F1P2, PNT1, PNT25, PNT75
      PARAMETER (F1P2 = 1.2D+00, PNT1 = 0.1D+00, PNT25 = 0.25D+00,
     +           PNT75 = 0.75D+00)
      LOGICAL    EQUAL(NRMAX), FIXN, ISTOP, OMIT(NOPT), ZERO
      LOGICAL    IWARNU
      PARAMETER (IWARNU = .TRUE.)
      EXTERNAL   G02CAF$
      EXTERNAL   LMFIT1, LMFUNC, LSFUN1
      EXTERNAL   PUTIFA, CHECKW
      INTRINSIC  LOG, SQRT
      IF (ISTOP) RETURN
      IF (OMIT(ITIME)) RETURN
      IF (ITIME.EQ.1) THEN
         X(1) = SLOPE
         IF (ZERO) THEN
            NPAR = 1
         ELSE
            NPAR = 2
            X(2) = CONST
         ENDIF
      ELSEIF (ITIME.EQ.2) THEN
         X(1) = ZERO1
         X(2) = SLOPE
         IF (ZERO) THEN
            NPAR = 2
         ELSE
            NPAR = 3
            X(3) = CONST
         ENDIF
      ELSEIF (ITIME.EQ.3) THEN
         IF (ZERO) THEN
            NPAR = 2
            X(1) = F1P2
         ELSE
            NPAR = 3
            IF (SLOPE.GE.ZERO1) THEN
               X(1) = F1P2 - CONST
            ELSE
               X(1) = PNT75*SMIN - CONST
            ENDIF
            X(3) = CONST
         ENDIF
         X(2) = - LOG(PNT1)
      ELSEIF (ITIME.EQ.4) THEN
         IF (ZERO) THEN
            X(1) = F1P2
            X(2) = PNT25
            IF (FIXN) THEN
               NPAR = 2
               X(3) = VALN
            ELSE
               NPAR = 3
C*****MINPACK seems to work better with 1 but E04FDF is OK with 2
C*****A compromise is to use VALN
C***********X(3) = TWO
C***********X(3) = ONE
            X(3) = VALN
            ENDIF
         ELSE
            IF (SLOPE.GE.ZERO1) THEN
               X(1) = F1P2 - CONST
            ELSE
               X(1) = PNT75*SMIN - CONST
            ENDIF
            X(2) = PNT25
            X(3) = CONST
            IF (FIXN) THEN
               NPAR = 3
               X(4) = VALN
            ELSE
               NPAR = 4
C*****MINPACK seems to work better with 1 but E04FDF is OK with 2
C*****A compromise is to use VALN
C***********X(4) = TWO
C***********X(4) = ONE
               X(4) = VALN
            ENDIF
         ENDIF
      ELSEIF (ITIME.EQ.5) THEN
         J = NPTS + 1
         K = 0
         DO I = 1, 3
            J = J - 1
            K = K + 1
            W(K) = TN(J)
            W(NPTS + K) = SN(J)
            IF (EQUAL(J)) THEN
   10          CONTINUE
               J = J - 1
               K = K + 1
               W(K) = TN(J)
               W(NPTS + K) = SN(J)
               IF (EQUAL(J)) GOTO 10
            ENDIF
         ENDDO
         IFAIL = 1
         CALL G02CAF$(K, W(1), W(NPTS + 1), RESUL, IFAIL)
         CALL PUTIFA (IFAIL, NF, 'G02CAF/DATFIT')
         IF (IFAIL.NE.0) THEN
            X(1) = (ONE - SMIN)/(ONE - TMIN)
         ELSE
            X(1) = RESUL(6)
         ENDIF
         X(2) = ZERO1
         X(3) = - LOG(PNT1)
         IF (ZERO) THEN
            NPAR = 3
         ELSE
            NPAR = 4
            X(4) = CONST
         ENDIF
      ENDIF
C
C NPAR has now been set and X contains the starting estimates
C so we can now proceed with the curve-fitting if NDIST >= NPAR
C
      IF (NPAR.GT.NDIST) THEN
         ISTOP = .TRUE.
         RETURN
      ENDIF
C
C Define M, N, WSSQ-before
C
      M = NPTS
      N = NPAR
      NDOF = M - N
      CALL LSFUN1 (M, N, X, W)
      WSSQ = ZERO1
      DO I = 1, M
         WSSQ = WSSQ + W(I)*W(I)
      ENDDO
      CALL CHECKW (NDOF, WSSQ)
      J = 5*N + M
      CALL LMFIT1 (LMFUNC, IFAIL, IPVT, IRANK, J, M, N, NCMAX, NF,
     +             NRMAX,
     +             CV, FJAC, FVEC, X, W, WSSQ,
     +             IWARNU)
C
C Now calculate parameter standard errors
C
      DO I = 1, N
         IF (CV(I,I).LT.RTOL) CV(I,I) = RTOL
         STD(I) = SQRT(CV(I,I))
      ENDDO
C 100 FORMAT (1X,A6,1X,'curve-fitting WSSQ =',1P,E10.3)
C 200 FORMAT ('Wait ... Curve-fitting in progress for model',I2)
C 300 FORMAT ('Max. iterations used: WSSQ =',1P,E10.3,': Re-enter ?')
      END
C
c      
      subroutine demfil (ndem, nopt,
     +                   fname,
     +                   fixn, omit)
c
c This subroutine is only active if 1 =< ndem =< 4 o/w it just returns FNAME = BLANK
c ndem = 1: select inrate.tf1 ... for model = 2
c ndem = 2: select inrate.tf2 ... for model = 3
c ndem = 3: select inrate.tf3 ... for model = 4
c ndem = 4: select inrate.tf4 ... for ,odel = 5
c
c arguments
c     
      integer,                intent (in)    :: ndem, nopt
      character (len = 1024), intent (inout) :: fname
      
      logical,                intent (inout) :: fixn, omit(nopt)
c
c local
c     
      integer    i 
      character (len = 1024) sim256 
      character (len = 10  ) stub(4)
      character (len = 1   ) blank
      parameter (blank = ' ')
      external   sim256
      if (ndem.ge.1 .and. ndem.le.4) then
         stub(1) = 'inrate.tf1'
         stub(2) = 'inrate.tf2'
         stub(3) = 'inrate.tf3'
         stub(4) = 'inrate.tf4'
         fixn = .false.
         do i = 1, nopt
            omit(i) = .true.
         enddo
         omit(ndem + 1) = .false.
         fname = sim256(stub(ndem))
      else
         fname = blank   
      endif     
      end
c
c     