C
C
C INRATE2.INS
C ==========
C DATOUT
C DETAIL
C
C
      SUBROUTINE DATOUT (ITIME, KPAR, LW, NBAD, NCMAX, NDOF, NF, NFLY,
     +                   NOPT, NPAR, NPTS, NRMAX, NTOTL1, NTOTL2,
     +                   AVRR, CV, EN, EPSI, PARAM, RTOL, SMAX, SN,
     +                   STD, TMAX, TMIN, TN, VALN, W, X, YABS,
     +                   QUAL,
     +                   EQUAL, FIXN, ISTOP, NOUT, OMIT, ZERO)
C
C Output best-fit parameters and residuals
C
      IMPLICIT   NONE
      INTEGER    LW, NCMAX, NOPT, NRMAX
      INTEGER    ITIME, KPAR, NBAD, NDOF, NF, NFLY, NPAR, NPTS, NTOTL1,
     +           NTOTL2
      INTEGER    NX
      PARAMETER (NX = 4)
      INTEGER    I, IFAIL, J
      INTEGER    N1, N2, N3, N4, N5, N6
      INTEGER    COLOUR
      DOUBLE PRECISION PNT05, PNT975
      PARAMETER (PNT05 = 0.05D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION AVRR, CV(NCMAX,NCMAX), EN(NRMAX), EPSI,
     +                 PARAM(NCMAX),
     +                 RTOL, SMAX, SN(NRMAX), STD(NCMAX),
     +                 TMAX, TMIN, TN(NRMAX), VALN, W(LW),
     +                 X(NCMAX), YABS
      DOUBLE PRECISION DFDT0, THALF, TLAG, TRELAX, TZERO
      DOUBLE PRECISION STDERR(NX), TEMP, TSIG(NX), TVAL(NX)
      DOUBLE PRECISION ALPHA, ARGVAL, TSTAT
      DOUBLE PRECISION DBIG, RBIG, RDENOM, RELERR, TDER, TREL
      DOUBLE PRECISION G01EBF$, G01FBF$
      DOUBLE PRECISION DSDT, FMOD
      DOUBLE PRECISION ZERO1, ONE, TWO
      PARAMETER (ZERO1 = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    EQUAL(NRMAX), FIXN, ISTOP, NOUT(2), OMIT(NOPT), ZERO
      LOGICAL    OK
      CHARACTER (LEN = 13) D13(6), SHOWLJ, SHOWRJ
      CHARACTER  QUAL(NRMAX)*(*)
      CHARACTER  TYPE1(NX)*5, SYMBOL(NX)*8
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   G01EBF$, G01FBF$
      EXTERNAL   ZEROIN, FMOD, DSDT
      EXTERNAL   PUTIFA, TABLE1, PUTADV, TABLE5
      INTRINSIC  ABS, SQRT, MAX, DBLE, LOG
      IF (ISTOP) RETURN
      IF (OMIT(ITIME)) RETURN
      E_NUMBERS = E_FORMATS() 
      IF (NTOTL2.GT.1) THEN
         WRITE (LINE,1600) NTOTL2, NTOTL1
         CALL PUTADV (LINE)
      ENDIF
      IF (ITIME.EQ.1) THEN
         PARAM(1) = X(1)*SMAX/TMAX
         STDERR(1) = STD(1)*SMAX/TMAX
         IF (ZERO) THEN
            PARAM(2) = ZERO1
            STDERR(2) = ZERO1
         ELSE
            PARAM(2) = X(2)*SMAX
            STDERR(2) = STD(2)*SMAX
         ENDIF
         KPAR = 2
         SYMBOL(1) = '   B'
         SYMBOL(2) = '   C'
      ELSEIF (ITIME.EQ.2) THEN
         PARAM(1) = X(1)*SMAX/(TMAX**2)
         PARAM(2) = X(2)*SMAX/TMAX
         STDERR(1) = STD(1)*SMAX/(TMAX**2)
         STDERR(2) = STD(2)*SMAX/TMAX
         IF (ZERO) THEN
            PARAM(3) = ZERO1
            STDERR(3) = ZERO1
         ELSE
            PARAM(3) = X(3)*SMAX
            STDERR(3) = STD(3)*SMAX
         ENDIF
         KPAR = 3
         SYMBOL(1) = '   A'
         SYMBOL(2) = '   B'
         SYMBOL(3) = '   C'
      ELSEIF (ITIME.EQ.3) THEN
         PARAM(1) = X(1)*SMAX
         STDERR(1) = STD(1)*SMAX
         PARAM(2) = X(2)/TMAX
         STDERR(2) = STD(2)/TMAX
         IF (ZERO) THEN
            PARAM(3) = ZERO1
            STDERR(3) = ZERO1
         ELSE
            PARAM(3) = X(3)*SMAX
            STDERR(3) = STD(3)*SMAX
         ENDIF
         KPAR = 3
         SYMBOL(1) = ' alpha'
         SYMBOL(2) = ' beta'
         SYMBOL(3) = '   C'
      ELSEIF (ITIME.EQ.4) THEN
         IF (ZERO) THEN
            IF (FIXN) THEN
               PARAM(4) = VALN
               STDERR(4) = ZERO1
            ELSE
               PARAM(4) = ABS(X(3))
               STDERR(4) = STD(3)
            ENDIF
            PARAM(1) = X(1)*SMAX
            PARAM(2) = ABS(X(2))*TMAX
            PARAM(3) = ZERO1
            STDERR(1) = STD(1)*SMAX
            STDERR(2) = STD(2)*TMAX
            STDERR(3) = ZERO1
         ELSE
            IF (FIXN) THEN
               PARAM(4) = VALN
               STDERR(4) = ZERO1
            ELSE
               PARAM(4) = ABS(X(4))
               STDERR(4) = STD(4)
            ENDIF
            PARAM(1) = X(1)*SMAX
            PARAM(2) = ABS(X(2))*TMAX
            PARAM(3) = X(3)*SMAX
            STDERR(1) = STD(1)*SMAX
            STDERR(2) = STD(2)*TMAX
            STDERR(3) = STD(3)*SMAX
         ENDIF
         KPAR = 4
         SYMBOL(1) = '  Vmax'
         SYMBOL(2) = '   Km'
         SYMBOL(3) = '   C'
         SYMBOL(4) = '   n'
      ELSEIF (ITIME.EQ.5) THEN
         PARAM(1) = X(1)*SMAX/TMAX
         PARAM(2) = X(2)*SMAX
         STDERR(1) = STD(1)*SMAX/TMAX
         STDERR(2) = STD(2)*SMAX
         PARAM(3) = X(3)/TMAX
         STDERR(3) = STD(3)/TMAX
         IF (ZERO) THEN
            PARAM(4) = ZERO1
            STDERR(4) = ZERO1
         ELSE
            PARAM(4) = X(4)*SMAX
            STDERR(4) = STD(4)*SMAX
         ENDIF
         KPAR = 4
         SYMBOL(1) = '   P'
         SYMBOL(2) = '   Q'
         SYMBOL(3) = '   R'
         SYMBOL(4) = '   C'
         IF (ABS(PARAM(1)).GT.RTOL) THEN
            TLAG = - (PARAM(2) + PARAM(4))/PARAM(1)
         ELSE
            TLAG = ZERO1
         ENDIF
         IF (ABS(PARAM(3)).GT.RTOL) THEN
            TRELAX = ONE/PARAM(3)
         ELSE
            TRELAX = ZERO1
         ENDIF
      ENDIF
C
C Parameters have now been transformed into the original coordinates so
C we can calculate standard errors, confidence limits and t statistics
C
      OK = .FALSE.
      IF (.NOT.ZERO) CALL ZEROIN (ITIME, KPAR, DFDT0, EPSI, PARAM,
     +                            RTOL, TMAX, TMIN, TZERO, OK)
      IFAIL = 1
      TSTAT = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
      CALL PUTIFA (IFAIL, NF, 'G01FBF/DATOUT')
      DO I = 1, KPAR
         IF (STDERR(I).GT.RTOL) THEN
            ARGVAL = ABS(PARAM(I)/STDERR(I))
            IFAIL = 1
            ALPHA = ONE - G01EBF$('Lower-tail', ARGVAL, DBLE(NDOF),
     +                            IFAIL)
            CALL PUTIFA (IFAIL, NF, 'G01EBF/DATOUT')
            TSIG(I) = TWO*ALPHA
            IF (TSIG(I).GT.PNT05) THEN
               TYPE1(I) = ' *'
            ELSE
               TYPE1(I) = ' '
            ENDIF
         ELSE
            TSIG(I) = ONE
            TYPE1(I) = 'fixed'
         ENDIF
         TVAL(I) = TSTAT*STDERR(I)
      ENDDO
      WRITE (NF,100) ITIME
      DO I = 1, KPAR
         IF (E_NUMBERS) THEN
            WRITE (NF,200) SYMBOL(I), PARAM(I), STDERR(I), PARAM(I) -
     +                     TVAL(I), PARAM(I) + TVAL(I), TSIG(I),
     +                     TYPE1(I)
         ELSE
            D13(1) = SHOWRJ(PARAM(I))
            D13(2) = SHOWRJ(STDERR(I))
            TEMP = PARAM(I) - TVAL(I)
            D13(3) = SHOWRJ(TEMP)
            TEMP = PARAM(I) + TVAL(I)
            D13(4) = SHOWRJ(TEMP)   
            WRITE (NF,250) SYMBOL(I), D13(1), D13(2),
     +                     D13(3), D13(4),
     +                     TSIG(I), TYPE1(I)
         ENDIF  
      ENDDO
      IF (ITIME.EQ.1) THEN
         IF (E_NUMBERS) THEN
            WRITE (NF,300) PARAM(2)
            WRITE (NF,400) PARAM(1)
            IF (OK) WRITE (NF,500) TZERO, DFDT0
         ELSE
            D13(1) = SHOWLJ(PARAM(2))
            D13(2) = SHOWLJ(PARAM(1))
            WRITE (NF,350) D13(1)
            WRITE (NF,450) D13(2)
            IF (OK) THEN
               D13(1) = SHOWLJ(TZERO)
               D13(2) = SHOWLJ(DFDT0) 
               WRITE (NF,550) D13(1), D13(2) 
            ENDIF   
         ENDIF  
      ELSEIF (ITIME.EQ.2) THEN
         IF (E_NUMBERS) THEN
            WRITE (NF,300) PARAM(3)
            WRITE (NF,400) PARAM(2)
            IF (OK) WRITE (NF,500) TZERO, DFDT0
         ELSE
            D13(1) = SHOWLJ(PARAM(3))
            D13(2) = SHOWLJ(PARAM(2))
            WRITE (NF,350) D13(1)
            WRITE (NF,450) D13(2)
            IF (OK) THEN
               D13(1) = SHOWLJ(TZERO)
               D13(2) = SHOWLJ(DFDT0)
               WRITE (NF,550) D13(1), D13(2)               
            ENDIF   
         ENDIF   
      ELSEIF (ITIME.EQ.3) THEN
         IF (E_NUMBERS) THEN
            WRITE (NF,300) PARAM(3)
            WRITE (NF,400) (PARAM(1)*PARAM(2))
            IF (OK) WRITE (NF,500) TZERO, DFDT0
            WRITE (NF,600) (PARAM(1) + PARAM(3))
            THALF = LOG(TWO)/PARAM(2)
            WRITE (NF,650) THALF
         ELSE
            D13(1) = SHOWLJ(PARAM(3))
            TEMP = PARAM(1)*PARAM(2)
            D13(2) = SHOWLJ(TEMP)
              
            WRITE (NF,350) D13(1)
            WRITE (NF,450) D13(2)
            IF (OK) THEN
               D13(1) = SHOWLJ(TZERO)
               D13(2) = SHOWLJ(DFDT0)
               WRITE (NF,550) D13(1), D13(2)
            ENDIF   
            TEMP = PARAM(1) + PARAM(3) 
            D13(1) = SHOWLJ(TEMP)
            WRITE (NF,625) D13(1)  
            THALF = LOG(TWO)/PARAM(2)
            D13(1) = SHOWLJ(THALF)
            WRITE(NF,675) D13(1)
         ENDIF  
      ELSEIF (ITIME.EQ.4) THEN
         IF (E_NUMBERS) THEN
            WRITE (NF,300) PARAM(3)
            IF (PARAM(4).GT.(ONE + TWO*EPSI)) THEN
               WRITE (NF,400) ZERO1
            ELSEIF (PARAM(4).GE.(ONE - TWO*EPSI) .AND.
     +              PARAM(2).GT.EPSI) THEN
               WRITE (NF,400) (PARAM(1)/PARAM(2))
            ENDIF
            IF (OK) WRITE (NF,500) TZERO, DFDT0
            WRITE (NF,600) (PARAM(1) + PARAM(3))
            IF (FIXN) WRITE (NF,700) VALN
         ELSE
            D13(1) = SHOWLJ(PARAM(3))
            WRITE (NF,350) D13(1)
            IF (PARAM(4).GT.(ONE + TWO*EPSI)) THEN
               D13(1) = SHOWLJ(ZERO1)
               WRITE (NF,450) D13(1)
            ELSEIF (PARAM(4).GE.(ONE - TWO*EPSI) .AND.
     +              PARAM(2).GT.EPSI) THEN
               TEMP = PARAM(1)/PARAM(2)
               D13(1) = SHOWLJ(TEMP)
               WRITE (NF,450) D13(1)
            ENDIF
            
            IF (OK) THEN
               D13(1) = SHOWLJ(TZERO)
               D13(2) = SHOWLJ(DFDT0)
              WRITE (NF,550) D13(1), D13(2)
            ENDIF  
            TEMP = PARAM(1) + PARAM(2)
            D13(1) = SHOWLJ(TEMP)  
            WRITE (NF,625) D13(1)
            IF (FIXN) WRITE (NF,700) VALN
         ENDIF  
      ELSEIF (ITIME.EQ.5) THEN
         IF (E_NUMBERS) THEN
            WRITE (NF,300) PARAM(4)
            WRITE (NF,400) (PARAM(1) + PARAM(2)*PARAM(3))
            IF (OK) WRITE (NF,500) TZERO, DFDT0
            WRITE (NF,800) PARAM(1)
            IF (ABS(TRELAX).GT.EPSI) WRITE (NF,900) TRELAX
            IF (ABS(TLAG).GT.EPSI) WRITE (NF,950) TLAG
         ELSE
            D13(1) = SHOWLJ(PARAM(4))
            WRITE (NF,350) D13(1)
            TEMP = PARAM(1) + PARAM(2)*PARAM(3)
            D13(1) = SHOWLJ(TEMP)
            WRITE (NF,450) D13(1)
            
            IF (OK) THEN
               D13(1) = SHOWLJ(TZERO)
               D13(2) = SHOWLJ(DFDT0)
               WRITE (NF,550) D13(1), D13(2)
            ENDIF   
            D13(1) = SHOWLJ(PARAM(1))  
            WRITE (NF,850) D13(1)
            D13(1) = SHOWLJ(TRELAX)
            IF (ABS(TRELAX).GT.EPSI) WRITE (NF,925) D13(1)
            D13(1) = SHOWLJ(TLAG)  
            IF (ABS(TLAG).GT.EPSI) WRITE (NF,975) D13(1) 
         ENDIF
      ENDIF
      IF (NPAR.GT.1) THEN
         WRITE (NF,1000)  ITIME
         DO I = 1, NPAR
               WRITE (NF,1100) (CV(I,J)/MAX(RTOL,
     +                          SQRT(ABS(CV(I,I)*CV(J,J)))), J = 1, I)
         ENDDO
      ENDIF
      IF (NOUT(1)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         WRITE (TEXT,100) ITIME
         COLOUR = 4
         DO I = 1, 4
            CALL TABLE1 (COLOUR, TEXT(I))
         ENDDO
         COLOUR = 0
         DO I = 1, KPAR
            IF (E_NUMBERS) THEN
               WRITE (TEXT,200) SYMBOL(I), PARAM(I), STDERR(I),
     +                          PARAM(I) - TVAL(I), PARAM(I) + TVAL(I),
     +                          TSIG(I), TYPE1(I)
            ELSE
               D13(1) = SHOWRJ(PARAM(I))
               D13(2) = SHOWRJ(STDERR(I))
               TEMP = PARAM(I) - TVAL(I)
               D13(3) = SHOWRJ(TEMP)
               TEMP = PARAM(I) + TVAL(I)
               D13(4) = SHOWRJ(TEMP)   
               WRITE (TEXT(I),250) SYMBOL(I), D13(1), D13(2),
     +                             D13(3), D13(4),
     +                             TSIG(I), TYPE1(I)
            ENDIF  
         ENDDO
         DO I = 1, KPAR
            CALL TABLE1 (COLOUR, TEXT(I))
         ENDDO
         IF (ITIME.EQ.1) THEN
            IF (E_NUMBERS) THEN
               WRITE (TEXT,300) PARAM(2)
            ELSE
               D13(1) = SHOWLJ(PARAM(2))   
               WRITE (TEXT,350) D13(1)
            ENDIF   
         ELSEIF (ITIME.LT.5) THEN
            IF (E_NUMBERS) THEN
               WRITE (TEXT,300) PARAM(3)
            ELSE
               D13(1) = SHOWLJ(PARAM(3))
               WRITE (TEXT,350) D13(1) 
            ENDIF  
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (TEXT,300) PARAM(4)
            ELSE
               D13(1) = SHOWLJ(PARAM(4))
               WRITE (TEXT,350) D13(1)
            ENDIF 
         ENDIF
         CALL TABLE1 (COLOUR, TEXT(1))
         CALL TABLE1 (COLOUR, TEXT(2))
         IF (ITIME.EQ.1) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,400) PARAM(1)
               CALL TABLE1 (COLOUR, LINE)
               IF (OK) THEN
                  WRITE (LINE,500) TZERO, DFDT0
                  CALL TABLE1 (COLOUR, LINE)
              ENDIF
            ELSE
               D13(1) = SHOWLJ(PARAM(1))
               WRITE (LINE,450) D13(1)
               CALL TABLE1 (COLOUR, LINE)
               IF (OK) THEN
                  D13(1) = SHOWLJ(TZERO)
                  D13(2) = SHOWLJ(DFDT0)
                  WRITE (LINE,550) D13(1), D13(2)
                  CALL TABLE1 (COLOUR, LINE)
              ENDIF 

            ENDIF  
         ELSEIF (ITIME.EQ.2) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,400) PARAM(2)
               CALL TABLE1 (COLOUR, LINE)
               IF (OK) THEN
                  WRITE (LINE,500) TZERO, DFDT0
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
            ELSE
               D13(1) = SHOWLJ(PARAM(2))
               WRITE (LINE,450) D13(1)
               CALL TABLE1 (COLOUR, LINE)
               IF (OK) THEN
                  D13(1) = SHOWLJ(TZERO)
                  D13(2) = SHOWLJ(DFDT0)
                  WRITE (LINE,550) D13(1), D13(2)
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF 
             ENDIF 
         ELSEIF (ITIME.EQ.3) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,400) (PARAM(1)*PARAM(2))
               CALL TABLE1 (COLOUR, LINE)
               IF (OK) THEN
                  WRITE (LINE,500) TZERO, DFDT0
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
               WRITE (LINE,600) (PARAM(1) + PARAM(3))
               CALL TABLE1 (COLOUR, LINE)
               THALF = LOG(TWO)/PARAM(2)
               WRITE (LINE,650) THALF
               CALL TABLE1 (COLOUR, LINE)
            ELSE
               TEMP = PARAM(1)*PARAM(2)
               D13(1) = SHOWLJ(TEMP)
               WRITE (LINE,450) D13(1)
               CALL TABLE1 (COLOUR, LINE)
               IF (OK) THEN
                  D13(1) = SHOWLJ(TZERO)
                  D13(2) = SHOWLJ(DFDT0)
                  WRITE (LINE,550) D13(1), D13(2)
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
               TEMP = PARAM(1) + PARAM(3)
               D13(1) = SHOWLJ(TEMP)
               WRITE (LINE,625) D13(1)
               CALL TABLE1 (COLOUR, LINE)
               THALF = LOG(TWO)/PARAM(2)
               D13(1) = SHOWLJ(THALF)
               WRITE (LINE,675) D13(1)
               CALL TABLE1 (COLOUR, LINE)
             ENDIF 
         ELSEIF (ITIME.EQ.4) THEN
            IF (E_NUMBERS) THEN
               IF (PARAM(4).GT.(ONE + TWO*EPSI)) THEN
                  WRITE (LINE,400) ZERO1
                  CALL TABLE1 (COLOUR, LINE)
               ELSEIF (PARAM(4).GE.(ONE - TWO*EPSI) .AND.
     +                 PARAM(2).GT.EPSI) THEN
                  WRITE (LINE,400) (PARAM(1)/PARAM(2))
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
               IF (OK) THEN
                  WRITE (LINE,500) TZERO, DFDT0
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
               WRITE (LINE,600) (PARAM(1) + PARAM(3))
               CALL TABLE1 (COLOUR, LINE)
               IF (FIXN) THEN
                  WRITE (LINE,700) VALN
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
            ELSE
               IF (PARAM(4).GT.(ONE + TWO*EPSI)) THEN
                  D13(1) = SHOWLJ(ZERO1)
                  WRITE (LINE,450) D13(1)
                  CALL TABLE1 (COLOUR, LINE)
               ELSEIF (PARAM(4).GE.(ONE - TWO*EPSI) .AND.
     +                 PARAM(2).GT.EPSI) THEN
                  TEMP = PARAM(1)/PARAM(2)
                  D13(1) = SHOWLJ(TEMP) 
                  WRITE (LINE,450) D13(1)
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
               IF (OK) THEN
                  D13(1) = SHOWLJ(TZERO)
                  D13(2) = SHOWLJ(DFDT0)
                  WRITE (LINE,550) D13(1), D13(2)
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
               TEMP = PARAM(1) + PARAM(3)
               D13(1) = SHOWLJ(TEMP)
               WRITE (LINE,625) D13(1)
               CALL TABLE1 (COLOUR, LINE)
               IF (FIXN) THEN
                  WRITE (LINE,700) VALN
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF 
            ENDIF  
         ELSEIF (ITIME.EQ.5) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,400) (PARAM(1) + PARAM(2)*PARAM(3))
               CALL TABLE1 (COLOUR, LINE)
               IF (OK) THEN
                  WRITE (LINE,500) TZERO, DFDT0
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
               WRITE (LINE,800) PARAM(1)
               CALL TABLE1 (COLOUR, LINE)
               IF (ABS(TRELAX).GT.EPSI) THEN
                  WRITE (LINE,900) TRELAX
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
               IF (ABS(TLAG).GT.EPSI) THEN
                  WRITE (LINE,950) TLAG
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
            ELSE
               TEMP = PARAM(1) + PARAM(2)*PARAM(3)
               D13(1) = SHOWLJ(TEMP)
               WRITE (LINE,450) D13(1)
               CALL TABLE1 (COLOUR, LINE)
               IF (OK) THEN
                  D13(1) = SHOWLJ(TZERO)
                  D13(2) = SHOWLJ(DFDT0)
                  WRITE (LINE,550) D13(1), D13(2)
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
               D13(1) = SHOWLJ(PARAM(1))
               WRITE (LINE,850) D13(1)
               CALL TABLE1 (COLOUR, LINE)
               IF (ABS(TRELAX).GT.EPSI) THEN
                  D13(1) = SHOWLJ(TRELAX)
                  WRITE (LINE,925) D13(1)
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
               IF (ABS(TLAG).GT.EPSI) THEN
                  D13(1) = SHOWLJ(TLAG)
                  WRITE (LINE,975) D13(1)
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
            ENDIF  
         ENDIF
         IF (NPAR.GT.1) THEN
            WRITE (TEXT,1000) ITIME
            COLOUR = 4
            CALL TABLE1 (COLOUR, TEXT(1))
            CALL TABLE1 (COLOUR, TEXT(2))
            COLOUR = 0
            DO I = 1, NPAR
               WRITE (LINE,1100) (CV(I,J)/MAX(RTOL,
     +                         SQRT(ABS(CV(I,I)*CV(J,J)))), J = 1, I)
               CALL TABLE1 (COLOUR, LINE)
            ENDDO
         ENDIF
         CALL TABLE1 (COLOUR, 'CLOSE')
       ENDIF
C
C Generate residuals and THEORY and restore to external coordinates
C Calculate DS/DT and check for quality of fit of THEORY to data
C Workspace W used for storage as follows:-
C
C W(        1 ->  NPTS) = E
C W( NPTS + 1 -> 2NPTS) = S        ... In original coordinates
C W(2NPTS + 1 -> 3NPTS) = T        ...         ''
C W(3NPTS + 1 -> 4NPTS) = THEORY   ...         ''
C W(4NPTS + 1 -> 5NPTS) = RESID    ...         ''
C W(5NPTS + 1 -> 6NPTS) = WRESID   ...         ''
C W(6NPTS + 1 -> 7NPTS) = DSDT     ...         ''
C
      NBAD = 0
      NFLY = 0
      N1 = NPTS
      N2 = 2*NPTS
      N3 = 3*NPTS
      N4 = 4*NPTS
      N5 = 5*NPTS
      N6 = 6*NPTS
      AVRR = ZERO1
      DBIG = - ONE/RTOL
      RBIG = DBIG
      YABS = ZERO1
      DO I = 1, NPTS
         W(I) = EN(I)*SMAX
         W(N1 + I) = SN(I)*SMAX
         W(N2 + I) = TN(I)*TMAX
         YABS = YABS + ABS(W(N1 + I))
         IF (EQUAL(I)) THEN
            W(N3 + I) = W(N3 + I - 1)
            W(N6 + I) = W(N6 + I - 1)
         ELSE
            W(N3 + I) = FMOD(KPAR, PARAM, W(N2 + I))
            W(N6 + I)  = DSDT(ITIME, KPAR, PARAM, W(N2 + I))
            IF (ABS(W(N6 + I)).GT.DBIG) THEN
               DBIG = ABS(W(N6 + I))
               TDER = W(N2 + I)
            ENDIF
         ENDIF
         W(N4 + I) = W(N1 + I) - W(N3 + I)
         W(N5 + I) = W(N4 + I)/W(I)
         RDENOM = 0.5D+00*(ABS(W(N3 + I)) + ABS(W(N1 + I)))
         IF (RDENOM.LT.RTOL) THEN
            RELERR = ZERO1
         ELSE
            RELERR = ABS(W(N4 + I))/RDENOM
            IF (RELERR.GT.RBIG) THEN
               RBIG = RELERR
               TREL = W(N2 + I)
            ENDIF
         ENDIF
         AVRR = AVRR + RELERR
         IF (RELERR.GT.0.8D+00) THEN
            NBAD = NBAD + 1
            NFLY = NFLY + 1
            QUAL(I) = '****'
         ELSEIF (RELERR.GT.0.4D+00) THEN
            NBAD = NBAD + 1
            NFLY = NFLY + 1
            QUAL(I) = '***'
         ELSEIF (RELERR.GT.0.2D+00) THEN
            NBAD = NBAD + 1
            QUAL(I) = '**'
         ELSEIF (RELERR.GT.0.1D+00) THEN
            NBAD = NBAD + 1
            QUAL(I) = '*'
         ELSE
            QUAL(I) = ' '
         ENDIF
      ENDDO
      AVRR = AVRR/DBLE(NPTS)
      YABS = YABS/DBLE(NPTS)
      IF (NOUT(2)) THEN
         WRITE (NF,1200)
         IF (E_NUMBERS) THEN
            WRITE (NF,1300) (W(N2 + I), W(I), W(N1 + I), W(N3 + I),
     +                       W(N6 + I), W(N5 + I), QUAL(I), I = 1, NPTS)
         ELSE
            DO I = 1, NPTS
               D13(1) = SHOWRJ(W(N2 + I))
               D13(2) = SHOWRJ(W(I)) 
               D13(3) = SHOWRJ(W(N1 + I))
               D13(4) = SHOWRJ(W(N3 + I)) 
               D13(5) = SHOWRJ(W(N6 + I))
               D13(6) = SHOWRJ(W(N5 + I))
               WRITE (NF,1350) D13(1), D13(2), D13(3), D13(4), D13(5),
     +                         D13(6), QUAL(I)
            ENDDO
         ENDIF  
         IF (NBAD.GT.0) WRITE (NF,1400)
         IF (E_NUMBERS) THEN    
            WRITE (NF,1500) DBIG, TDER, TREL, 100.0D+00*RBIG,
     +                      100.0D+00*AVRR
         ELSE
            D13(1) = SHOWLJ(DBIG)
            D13(2) = SHOWLJ(TDER)
            D13(3) = SHOWLJ(TREL)
            WRITE (NF,1550) D13(1), D13(2), D13(3), 100.0D+00*RBIG,
     +                      100.0D+00*AVRR
         ENDIF  
         COLOUR = 15
         CALL TABLE5 (COLOUR, 'OPEN')
         WRITE (TEXT,1200)
         COLOUR = 4
         CALL TABLE5 (COLOUR, TEXT(2))
         COLOUR = 0
         DO I = 1, NPTS 
            IF (E_NUMBERS) THEN
               WRITE (LINE,1300) W(N2 + I), W(I), W(N1 + I), W(N3 + I),
     +                           W(N6 + I), W(N5 + I), QUAL(I)
            ELSE
               D13(1) = SHOWRJ(W(N2 + I))
               D13(2) = SHOWRJ(W(I)) 
               D13(3) = SHOWRJ(W(N1 + I))
               D13(4) = SHOWRJ(W(N3 + I)) 
               D13(5) = SHOWRJ(W(N6 + I))
               D13(6) = SHOWRJ(W(N5 + I))
               WRITE (LINE,1350) D13(1), D13(2), D13(3), D13(4), D13(5),
     +                           D13(6), QUAL(I)
            ENDIF  
            CALL TABLE5 (COLOUR, LINE)
         ENDDO
         IF (NBAD.GT.0) THEN
            WRITE (LINE,1400)
            COLOUR = 4
            CALL TABLE5 (COLOUR, LINE)
         ENDIF
         CALL TABLE5 (COLOUR, 'CLOSE')
      ENDIF
      IF (NOUT(1)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         IF (E_NUMBERS) THEN
            WRITE (TEXT,1500) DBIG, TDER, TREL, 100.0D+00*RBIG,
     +                        100.0D+00*AVRR
         ELSE
            D13(1) = SHOWLJ(DBIG)
            D13(2) = SHOWLJ(TDER)
            D13(3) = SHOWLJ(TREL)
            WRITE (TEXT,1550) D13(1), D13(2), D13(3), 100.0D+00*RBIG,
     +                        100.0D+00*AVRR
         ENDIF  
         COLOUR = 0
         DO I = 1, 5
            CALL TABLE1 (COLOUR, TEXT(I))
         ENDDO
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF
C
C Format statements
C      
  100 FORMAT (/1X,'Results for model',I2/
     +/1X,'Parameter       Value      Std.Error    Lower95%cl',
     +'    Upper95%cl',4X,'p')
  200 FORMAT (A8,1X,1P,4(1X,E13.5),0P,F8.4,1X,A5) 
  250 FORMAT (A8,1X,4(1X,A13),0P,F8.4,1X,A5)      
  300 FORMAT (/1X,'Estimated initial value i.e. f(t = 0) =',1P,E13.5)
  350 FORMAT (/1X,'Estimated initial value i.e. f(t = 0) =',1X,A)
  400 FORMAT (1X,'Estimated initial rate   df/dt(t = 0) =',1P,E13.5)
  450 FORMAT (1X,'Estimated initial rate   df/dt(t = 0) =',1X,A)
  500 FORMAT (1X,'At t =',1P,E13.5,', f = 0, and df/dt =',1P,E13.5,
     + ' ... extrapolated value')
  550 FORMAT (1X,'At t =',1X,A,',f = 0, and df/dt =',1X,A,
     + ' ... extrapolated value')   
  600 FORMAT (1X,'Estimated final asymptote f(infinity) =',1P,E13.5)
  625 FORMAT (1X,'Estimated final asymptote f(infinity) =',1X,A)
  650 FORMAT (1X,'Estimated half time (i.e. ln(2)/beta) =',1P,E13.5)
  675 FORMAT (1X,'Estimated half time (i.e. ln(2)/beta) =',1X,A)
  700 FORMAT (1X,'The exponent was fixed at the value n =',F8.4)
  800 FORMAT (1X,'The estimated  final  asymptotic rate =',1P,E13.5)
  850 FORMAT (1X,'The estimated  final  asymptotic rate =',1X,A)
  900 FORMAT (1X,'Estimated relaxation time  (i.e. 1/R) =',1P,E13.5)
  925 FORMAT (1X,'Estimated relaxation time  (i.e. 1/R) =',1X,A)
  950 FORMAT (1X,'Estimated lag time (i.e. -(Q + C)/P ) =',1P,E13.5)
  975 FORMAT (1X,'Estimated lag time (i.e. -(Q + C)/P ) =',1X,A)
 1000 FORMAT (/1X,'Parameter correlation matrix for model',I2)
 1100 FORMAT (6F8.4)
 1200 FORMAT (/12X,'t',2X,'  std.err.f(t)        f(t)',5X,'     Theory',
     +1X,'  rate(df/dt)  Wtd. Resids.')
 1300 FORMAT (1X,1P,6(1X,E13.5),A4)
 1350 FORMAT (1X,6(1X,A13),A4)
 1400 FORMAT (1X,'Relative residuals: >10% (*), >20% (**)',
     +', >40% (***), >80% (****)')
 1500 FORMAT (1X,'The maximum  observed  absolute  rate =',1P,E13.5
     +/1X,'Time at the   maximum  observed  rate =',   E13.5
     +/1X,'Time at the largest relative residual =',   E13.5
     +/1X,'Largest absolute relative residual  % =',0P,F12.3,' %'
     +/1X,'Average absolute relative residual  % =',   F12.3,' %')
 1550 FORMAT (1X,'The maximum  observed  absolute  rate =',1X,A
     +/1X,'Time at the   maximum  observed  rate =',1X,A
     +/1X,'Time at the largest relative residual =',1X,A
     +/1X,'Largest absolute relative residual  % =',F12.3,' %'
     +/1X,'Average absolute relative residual  % =',F12.3,' %')    
 1600 FORMAT ('In',I5,' of',I5,
     +' iterations the exponential parameter reached lower limit 0')
      END
C
C
      SUBROUTINE DETAIL (NDEM, NOPT, VALN, 
     +                   FIXN, ISTOP, NOUT, OMIT, PLOT, ZERO)
C
C Details of mode of program operation
C
      IMPLICIT   NONE
      INTEGER    NDEM, NOPT
      INTEGER    I, IVALN, NFIT
      INTEGER    IVAL6
      PARAMETER (IVAL6 = 1000000)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMDEC = 1,
     +           NUMOPT = 15, NSTART = 4, NTEXT = 20)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION VALN
      DOUBLE PRECISION VALMAX, VALMIN
      PARAMETER (VALMAX = 6.0D+00, VALMIN = 0.01D+00)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  TEXT(NTEXT)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    FIXN, ISTOP, NOUT(2), OMIT(NOPT), PLOT(2), ZERO
      LOGICAL    ABORT, FIRST
      PARAMETER (FIRST = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GETRM1, RBOX01
      EXTERNAL   ADVISE
      INTRINSIC  NINT
      IF (NDEM.GE.1 .AND. NDEM.LE.4) THEN
         FIXN = .FALSE.
         RETURN
      ENDIF   
   20 CONTINUE
C
C Define TEXT then set NUMBLD to 0, 1 or - 100
C
      WRITE (TEXT,100) VALN
C
C Now set NUMBLD = - 100 where a ganged group is required (all can be off)
C
      DO I = 1, NTEXT
         IF (I.LE.3) THEN
            NUMBLD(I) = 4
         ELSEIF (I.GE.7 .AND. I.LE.10) THEN
            NUMBLD(I) = - 100
         ELSEIF (I.GE.17 .AND. I.LE.18) THEN
            NUMBLD(I) = - 200
         ELSE
            NUMBLD(I) = 0
         ENDIF
      ENDDO
C
C set NUMPOS (0 = false, 1 = true) for the control
C
      IF (OMIT(1)) THEN
         NUMPOS(1) = 0
      ELSE
         NUMPOS(1) = 1
      ENDIF
      IF (OMIT(2)) THEN
         NUMPOS(2) = 0
      ELSE
         NUMPOS(2) = 1
      ENDIF
      IF (OMIT(3)) THEN
         NUMPOS(3) = 0
      ELSE
         NUMPOS(3) = 1
      ENDIF
      IF (OMIT(4)) THEN
         NUMPOS(4) = 0
         NUMPOS(5) = 0
         NUMPOS(6) = 0
         NUMPOS(7) = 0
      ELSE
         IF (FIXN) THEN
            IVALN = NINT(IVAL6*VALN)
            IF (IVALN.EQ.IVAL6) THEN
               NUMPOS(4) = 1
               NUMPOS(5) = 0
            ELSE
               NUMPOS(4) = 0
               NUMPOS(5) = 1
            ENDIF
            NUMPOS(6) = 0
            NUMPOS(7) = 0
         ELSE
            NUMPOS(4) = 0
            NUMPOS(5) = 0
            NUMPOS(6) = 0
            NUMPOS(7) = 1
         ENDIF
      ENDIF
      IF (OMIT(5)) THEN
         NUMPOS(8) = 0
      ELSE
         NUMPOS(8) = 1
      ENDIF
      IF (ZERO) THEN
         NUMPOS(9) = 1
      ELSE
         NUMPOS(9) = 0
      ENDIF
      IF (NOUT(1)) THEN
         NUMPOS(10) = 1
      ELSE
         NUMPOS(10) = 0
      ENDIF
      IF (NOUT(2)) THEN
         NUMPOS(11) = 1
      ELSE
         NUMPOS(11) = 0
      ENDIF
      IF (PLOT(1)) THEN
         NUMPOS(12) = 1
      ELSE
         NUMPOS(12) = 0
      ENDIF
      IF (PLOT(2)) THEN
         NUMPOS(13) = 1
      ELSE
         NUMPOS(13) = 0
      ENDIF
      NUMPOS(14) = 0
      NUMPOS(15) = 0
C
C Call the check box
C
      CALL RBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, TEXT, BORDER, FLASH,
     +             HIGH)
C
C Assign the logical parameters
C
      IF (NUMPOS(1).EQ.1) THEN
         OMIT(1) = .FALSE.
      ELSE
         OMIT(1) = .TRUE.
      ENDIF
      IF (NUMPOS(2).EQ.1) THEN
         OMIT(2) = .FALSE.
      ELSE
         OMIT(2) = .TRUE.
      ENDIF
      IF (NUMPOS(3).EQ.1) THEN
         OMIT(3) = .FALSE.
      ELSE
         OMIT(3) = .TRUE.
      ENDIF
      OMIT(4) = .TRUE.
      IF (NUMPOS(4).EQ.1) THEN
         OMIT(4) = .FALSE.
         FIXN = .TRUE.
         VALN = ONE
      ENDIF
      IF (NUMPOS(5).EQ.1) THEN
         OMIT(4) = .FALSE.
         FIXN = .TRUE.
      ENDIF
      IF (NUMPOS(6).EQ.1) THEN
         OMIT(4) = .FALSE.
C
C Get new value for VALN
C
         CALL GETRM1 (VALMIN, VALN, VALMAX,
     +'Value required for n [i.e. fixed n or starting value for 4(d)]')
         GOTO 20
      ENDIF
      IF (NUMPOS(7).EQ.1) THEN
         OMIT(4) = .FALSE.
         FIXN = .FALSE.
      ENDIF
      IF (NUMPOS(8).EQ.1) THEN
         OMIT(5) = .FALSE.
      ELSE
         OMIT(5) = .TRUE.
      ENDIF
      IF (NUMPOS(9).EQ.1) THEN
         ZERO = .TRUE.
      ELSE
         ZERO = .FALSE.
      ENDIF
      IF (NUMPOS(10).EQ.1) THEN
         NOUT(1) = .TRUE.
      ELSE
         NOUT(1) = .FALSE.
      ENDIF
      IF (NUMPOS(11).EQ.1) THEN
         NOUT(2) = .TRUE.
      ELSE
         NOUT(2) = .FALSE.
      ENDIF
      IF (NUMPOS(12).EQ.1) THEN
         PLOT(1) = .TRUE.
      ELSE
         PLOT(1) = .FALSE.
      ENDIF
      IF (NUMPOS(13).EQ.1) THEN
         PLOT(2) = .TRUE.
      ELSE
         PLOT(2) = .FALSE.
      ENDIF
      IF (NUMPOS(14).EQ.1) THEN
         I = 1
         CALL ADVISE (I,
     +                BLANK,
     +                ABORT, FIRST)
         GOTO 20
      ENDIF
      IF (NUMPOS(15).EQ.1) THEN
         ISTOP = .TRUE.
         RETURN
      ENDIF
C
C Check that at least one model is to be fitted
C
      ISTOP = .FALSE.
      NFIT = 0
      DO I = 1, NOPT
         IF (.NOT.OMIT(I)) NFIT = NFIT + 1
      ENDDO
      IF (NFIT.EQ.0) THEN
         ISTOP = .TRUE.
         RETURN
      ENDIF
C
C Format statement
C      
  100 FORMAT (
     + 'Now select the mathematical models to be fitted to the current'
     +/'data and choose the details for displaying/filing the results'
     +/'...'
     +/'Model 1: Linear model, Bt + C'
     +/'Model 2: Quadratic model, At^2 + Bt + C'
     +/'Model 3: Exponential model, alpha[1 - exp(-beta.t)] + C'
     +/'Model 4: (a) Michaelis-Menten, Vmax.t/(Km + t) + C'
     +/'Model 4: (b) Hill, Vmax.t^n/(Km^n + t^n) + C, current n =',F6.3
     +/'Model 4: (c) Hill, Vmax.t^n/(Km^n + t^n) + C, change current n'
     +/'Model 4: (d) Hill, Vmax.t^n/(Km^n + t^n) + C, n to be estimated'
     +/'Model 5: Lag/burst-phase model, Pt + Q[1 - exp(-Rt)] + C'
     +/'f(0) = 0: Force best-fit curve through origin at t = 0 (C = 0)'
     +/'Parameters: Display/File tables of the best-fit parameters'
     +/'Residuals: Display/File tables of residuals/goodness of fit'
     +/'Plot best-fit: Options to display/save best-fit f(t) curves'
     +/'Plot residuals: Options to display/save best-fit residuals'
     +/'Help'
     +/'Exit'/'...'
     +/'The Model 4(b/c) value is used as a starting estimate for 4(d)')
      END
C
C
