C
C
C INRATE3.INS
C ===========
C GOFFIT
C SUMMIT
C ZEROIN
C DSDT
C FUNC
C
C
C
      SUBROUTINE GOFFIT (ITIME, KPAR, LW, NBAD, NDOF, NF, NFLY, NGRAF,
     +                   NOPT, NPTS,
     +                   AVRR, PARAM, RTOL, STAT, W, WSSQ, XGRAF, YABS,
     +                   ISTOP, NOUT, OMIT, PLOT, WEIGHT)
C
C Goodness of fit and call to graphics if required
C 10/06/2010 added call to NKLCFG
C
      IMPLICIT   NONE
      INTEGER    LW
      INTEGER    ITIME, KPAR, NBAD, NDOF, NF, NFLY, NGRAF, NOPT, NPTS
      INTEGER    L0, L1, L2, L3, L5, L23
      PARAMETER (L0 = 0, L1 = 1, L2 = 2, L3 = 3, L5 = 5, L23 = 23)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, NUMOPT = 4)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    I, IFAIL, ISEND, J, K, L, NPAR
      INTEGER    NNEG, NPOS, NRUN, NR1, NR5
      INTEGER    JCOLOR, JX, JY
      INTEGER    COLOUR
      INTEGER    KVAL_11, NKLCFG
      DOUBLE PRECISION AVRR, PARAM(KPAR), RTOL, STAT(NOPT,9), W(LW),
     +                 WSSQ, XGRAF(NGRAF), YABS
      DOUBLE PRECISION PNT01, PNT05, PNT95, PNT99, ZERO, ONE, TWO
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00, PNT95 = 0.95D+00,
     +           PNT99 = 0.99D+00, ZERO = 0.0D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION R, RSQD
      DOUBLE PRECISION CHI95, CHI99, PGCHI, PROBR, PROBS, PROBT,
     +                 VALUE(4)
      DOUBLE PRECISION G01ECF$, G01FCF$
      DOUBLE PRECISION FMOD, VAREST
      DOUBLE PRECISION DW, SSQ
      DOUBLE PRECISION X0(2), Y0(2)
      DOUBLE PRECISION XTEMP, X1(2), Y1(2)
      DOUBLE PRECISION AIC, DNDOF, DNPAR, DNPTS, PW, SC, WSTAT
      CHARACTER (LEN = 13) D13(5), SHOWLJ
      CHARACTER (LEN = 12) I12(5), FORM12
      CHARACTER  SYMBOL(4)*31, WORD*4
      CHARACTER  PTITLE*31, XTITLE*17, YTITLE*17
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  MSSAGE*16
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ISTOP, NOUT(2), OMIT(NOPT), PLOT(2), WEIGHT
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      LOGICAL    ACCEPT, YES
      LOGICAL    AGAIN, FIRST, GRAF1, GRAF2
      EXTERNAL   E_FORMATS, SHOWLJ, FORM12
      EXTERNAL   G01ECF$, G01FCF$
      EXTERNAL   PUTIFA, PROBRS, CORCOF, GKS004, YESNO2, TABLE1, GKSR03,
     +           PUTMES, LBOX02, PUTFAT, NKLCFG
      EXTERNAL   FMOD
      INTRINSIC  SQRT, MAX, DBLE, LOG, ABS
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
      DATA       NUMPOS / NUMOPT*1 /
      IF (ISTOP) RETURN
      IF (OMIT(ITIME)) RETURN
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      NPAR = NPTS - NDOF
      DNPAR = DBLE(NPAR)
      DNDOF = DBLE(NDOF)
      DNPTS = DBLE(NPTS)
C
C chi-square test
C
      IF (WEIGHT) THEN
         IFAIL = 1
         PGCHI = G01ECF$('Upper-tail', WSSQ, DNDOF, IFAIL)
         CALL PUTIFA (IFAIL, NF, 'G01ECF/GOFFIT')
         IFAIL = 1
         CHI95 = G01FCF$(PNT95, DNDOF, IFAIL)
         CALL PUTIFA (IFAIL, NF, 'G01FCF/GOFFIT')
         IFAIL = 1
         CHI99 = G01FCF$(PNT99, DNDOF, IFAIL)
         CALL PUTIFA (IFAIL, NF, 'G01FCF/GOFFIT')
         WORD = 'wtd.'
      ELSE
         VAREST = SQRT(WSSQ/DNDOF)
         PGCHI = (100.0D+00*VAREST)/YABS
         WORD = 'the '
      ENDIF
      VALUE(1) = PGCHI
C
C Run tests
C
      ISEND = 1
      I = 4*NPTS + 1
      CALL PROBRS (ISEND, NF, NNEG, NPOS, NPTS, NRUN, NR1, NR5, PROBR,
     +             PROBS, PROBT, W(I))
      VALUE(2) = PROBR
      VALUE(3) = PROBT
      VALUE(4) = PROBS
      DO I = 1, 4
         IF (VALUE(I).LT.PNT01) THEN
            SYMBOL(I) = 'Reject at 1% significance level'
         ELSEIF (VALUE(I).LT.PNT05) THEN
            SYMBOL(I) = 'Reject at 5% significance level'
         ELSE
            SYMBOL(I) = ' '
         ENDIF
      ENDDO
C
C Work out DW
C
      DW = ZERO
      J = 4*NPTS + 1
      SSQ = W(J)**2
      DO I = 1, NPTS - 1
         J = J + 1
         DW = DW + (W(J) - W(J - 1))**2
         SSQ = SSQ + W(J)**2
      ENDDO
      DW = DW/MAX(SSQ, RTOL)
      IF (DW.LT.1.5D+00) THEN
         PTITLE = '< 1.5, +ve serial correlation ?'
      ELSEIF (DW.LT.2.5D+00) THEN
         PTITLE = ' '
      ELSE
         PTITLE = '> 2.5, -ve serial correlation ?'
      ENDIF
      I = NPTS + 1
      J = 3*NPTS + 1
      CALL CORCOF (NPTS, R, W(I), W(J))
      RSQD = R**2
C
C Shapiro-Wilks test
C
      J = 5*NPTS + 1
      CALL GKSR03 (NF, NPTS, PW, W(J), WSTAT, MSSAGE, ACCEPT)
C
C AIC and SC
C
      AIC = DNPTS*LOG(MAX(RTOL,WSSQ)) + TWO*DNPAR
      SC = DNPTS*LOG(MAX(RTOL,WSSQ)) + DNPAR*LOG(DNPTS)/TWO
C
C Output results
C
      WRITE (NF,100) ITIME
      IF (WEIGHT) THEN
         IF (E_NUMBERS) THEN
            WRITE (NF,200) WSSQ, PGCHI, SYMBOL(1), CHI99, CHI95, RSQD,
     +                     NNEG, NPOS, NRUN, PROBR, SYMBOL(2), NR1, NR5,
     +                     PROBT, SYMBOL(3), PROBS, SYMBOL(4), DW,
     +                     PTITLE, WSTAT, PW, MSSAGE, AIC, SC
         ELSE
            D13(1) = SHOWLJ(WSSQ)
            D13(2) = SHOWLJ(CHI99)
            D13(3) = SHOWLJ(CHI95)
            D13(4) = SHOWLJ(AIC)
            D13(5) = SHOWLJ(SC) 
            I12(1) = FORM12(NNEG)
            I12(2) = FORM12(NPOS)
            I12(3) = FORM12(NRUN)
            I12(4) = FORM12(NR1)
            I12(5) = FORM12(NR5)
            WRITE (NF,250) D13(1), PGCHI, SYMBOL(1), D13(2), D13(3), 
     +                     RSQD, I12(1), I12(2), I12(3), PROBR,
     +                     SYMBOL(2), I12(4), I12(5), PROBT, SYMBOL(3),
     +                     PROBS, SYMBOL(4), DW, PTITLE, WSTAT, PW,
     +                     MSSAGE, D13(4), D13(5)
         ENDIF  
      ELSE
         IF (E_NUMBERS) THEN
            WRITE (NF,300) WSSQ, VAREST, YABS, PGCHI, RSQD, NNEG, NPOS,
     +                     NRUN, PROBR, SYMBOL(2), NR1, NR5, PROBT,
     +                     SYMBOL(3), PROBS, SYMBOL(4), DW, PTITLE,
     +                     WSTAT, PW, MSSAGE, AIC, SC
         ELSE
            D13(1) = SHOWLJ(WSSQ)
            D13(2) = SHOWLJ(VAREST)
            D13(3) = SHOWLJ(YABS)
            D13(4) = SHOWLJ(AIC)
            D13(5) = SHOWLJ(SC) 
            I12(1) = FORM12(NNEG)
            I12(2) = FORM12(NPOS)
            I12(3) = FORM12(NRUN)
            I12(4) = FORM12(NR1)
            I12(5) = FORM12(NR5)
            WRITE (NF,350) D13(1), D13(2), D13(3), PGCHI, RSQD, I12(1), 
     +                     I12(2), I12(3), PROBR, SYMBOL(2), I12(4),
     +                     I12(5), PROBT,  SYMBOL(3), PROBS, SYMBOL(4),
     +                     DW, PTITLE, WSTAT, PW, MSSAGE, D13(4), D13(5)   
         ENDIF 
      ENDIF
      IF (NOUT(1)) THEN
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         WRITE (TEXT,100) ITIME
         COLOUR = 4
         DO I = 1, 3
            CALL TABLE1 (COLOUR, TEXT(I))
         ENDDO
         IF (WEIGHT) THEN
         IF (E_NUMBERS) THEN
            WRITE (TEXT,200) WSSQ, PGCHI, SYMBOL(1), CHI99, CHI95, RSQD,
     +                       NNEG, NPOS, NRUN, PROBR, SYMBOL(2), NR1,
     +                       NR5, PROBT, SYMBOL(3), PROBS, SYMBOL(4), 
     +                       DW, PTITLE, WSTAT, PW, MSSAGE, AIC, SC
         ELSE
            D13(1) = SHOWLJ(WSSQ)
            D13(2) = SHOWLJ(CHI99)
            D13(3) = SHOWLJ(CHI95)
            D13(4) = SHOWLJ(AIC)
            D13(5) = SHOWLJ(SC) 
            I12(1) = FORM12(NNEG)
            I12(2) = FORM12(NPOS)
            I12(3) = FORM12(NRUN)
            I12(4) = FORM12(NR1)
            I12(5) = FORM12(NR5)
            WRITE (TEXT,250) D13(1), PGCHI, SYMBOL(1), D13(2), D13(3), 
     +                       RSQD, I12(1), I12(2), I12(3), PROBR,
     +                       SYMBOL(2), I12(4), I12(5), PROBT, 
     +                       SYMBOL(3), PROBS, SYMBOL(4), DW, PTITLE, 
     +                       WSTAT, PW, MSSAGE, D13(4), D13(5)
         ENDIF  
      ELSE
         IF (E_NUMBERS) THEN
            WRITE (TEXT,300) WSSQ, VAREST, YABS, PGCHI, RSQD, NNEG,
     +                       NPOS, NRUN, PROBR, SYMBOL(2), NR1, NR5, 
     +                       PROBT, SYMBOL(3), PROBS, SYMBOL(4), DW, 
     +                       PTITLE, WSTAT, PW, MSSAGE, AIC, SC
         ELSE
            D13(1) = SHOWLJ(WSSQ)
            D13(2) = SHOWLJ(VAREST)
            D13(3) = SHOWLJ(YABS)
            D13(4) = SHOWLJ(AIC)
            D13(5) = SHOWLJ(SC) 
            I12(1) = FORM12(NNEG)
            I12(2) = FORM12(NPOS)
            I12(3) = FORM12(NRUN)
            I12(4) = FORM12(NR1)
            I12(5) = FORM12(NR5)
            WRITE (TEXT,350) D13(1), D13(2), D13(3), PGCHI, RSQD,
     +                       I12(1), I12(2), I12(3), PROBR, SYMBOL(2),
     +                       I12(4), I12(5), PROBT,  SYMBOL(3), PROBS, 
     +                       SYMBOL(4), DW, PTITLE, WSTAT, PW, MSSAGE, 
     +                       D13(4), D13(5)   
         ENDIF 
      ENDIF   


         
         COLOUR = 0
         DO I = 1, 18
            CALL TABLE1 (COLOUR, TEXT(I))
         ENDDO
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF
C
C Graphics
C
      Y0(1) = ZERO
      Y0(2) = ZERO
      JCOLOR = 9
      JX = 4
      JY = 4
      IF (PLOT(1)) THEN
         AGAIN = .TRUE.
         NUMDEC = 3
         DO WHILE (AGAIN)
            IF (ITIME.EQ.1) THEN
C
C Just yes or no for model 1
C
               WRITE (LINE,400) ITIME
               YES = .TRUE.
               CALL YESNO2 (JCOLOR, JX, JY, LINE, YES)
               AGAIN = .FALSE.
               GRAF1 = YES
               GRAF2 = .FALSE.
            ELSE
C
C Choices for models 2, 3, 4 and 5
C
               IF (FIRST) THEN
                  KVAL_11 = NKLCFG(L23)
                  IF (KVAL_11.EQ.L1) THEN
                     FIRST = .FALSE.
                     WRITE (TEXT,500)
                     L = 17
                     CALL PUTMES (L, TEXT)
                  ENDIF   
               ENDIF
               WRITE (TEXT,600)
               CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                      TEXT)
               AGAIN = .TRUE.
               GRAF1 = .FALSE.
               GRAF2 = .FALSE.
               IF (NUMDEC.EQ.1) THEN
                  GRAF1 = .TRUE.
               ELSEIF (NUMDEC.EQ.2) THEN
                  GRAF2 = .TRUE.
               ELSEIF (NUMDEC.EQ.3) THEN
                  GRAF1 = .TRUE.
                  GRAF2 = .TRUE.
               ELSE
                  AGAIN = .FALSE.
               ENDIF
               IF (GRAF2 .AND.
     +             (ITIME.EQ.3 .AND. PARAM(2).LT.ZERO) .OR.
     +             (ITIME.EQ.5 .AND. PARAM(3).LT.ZERO)) THEN
                   CALL PUTFAT ('Exponent > 0, so no asymptote')
                   GRAF2 = .FALSE.
               ENDIF
               NUMDEC = NUMOPT
            ENDIF
            IF (GRAF1) THEN
               J = 6*NPTS
               DO I = 1, NGRAF
                  W(J + I) = FMOD(KPAR, PARAM, XGRAF(I))
               ENDDO
               PTITLE = 'Data and Best-Fit Curve'
               XTITLE = 't'
               YTITLE = 'f(t)'
               I = 2*NPTS + 1
               J = NPTS + 1
               K = 6*NPTS + 1
               CALL GKS004 (L0, L1, L0, L0, L5, L0, L0, L0,
     +                      NPTS, NGRAF, NGRAF, NGRAF,
     +                      W(I), XGRAF, XGRAF, XGRAF, W(J), W(K), W(K),
     +                      W(K), PTITLE, XTITLE, YTITLE, AXES, GSAVE)
            ENDIF
            IF (GRAF2) THEN
C
C Calculate the asymptotes (X0,Y0) and tangents (X1,Y1)
C Use W(3*NPTS) = X(NPTS) in original coordinates
C L = 0 implies no tangent
C
               X0(2) = W(3*NPTS)
               X1(1) = ZERO
               X1(2) = X0(2)
               Y1(1) = ZERO
               Y1(2) = ZERO
               L = 0
               IF (ITIME.EQ.2) THEN
C
C f(x) = p(1)x^2 + p(2)x + p(3)
C t(x) = p(2)x + p(3)
C
                  X0(1) = ZERO
                  Y0(1) = PARAM(3)
                  Y0(2) = PARAM(2)*X0(2) + PARAM(3)
                  PTITLE = 'Data and Initial-Rate Tangent'
               ELSEIF (ITIME.EQ.3) THEN
C
C f(x) = p(1)[1 - exp(-p(2)x)] + p(3)
C t(x) = p(1)p(2)x + p(3), iff p(2) > 0
C A = p(1) + p(3) implies X_intersect = 1/p(2), iff p(2) > 0
C
                  X0(1) = ZERO
                  Y0(1) = PARAM(1) + PARAM(3)
                  Y0(2) = Y0(1)
                  IF (PARAM(2).GT.RTOL) THEN
                     L = 3
                     XTEMP = ONE/PARAM(2)
                     IF (XTEMP.LE.X0(2)) THEN
                        X1(2) = XTEMP
                     ELSE
                        X1(2) = X0(2)
                     ENDIF
                     Y1(1) = PARAM(3)
                     Y1(2) = PARAM(1)*PARAM(2)*X1(2) + PARAM(3)
                  ENDIF
                  PTITLE = '  Data and Best-Fit asymptote'
               ELSEIF (ITIME.EQ.4) THEN
C
C f(x) = p(1)x^p(4)/[p(2)^p(4) + x^p(4)] + p(3)
C t(x) = [p(1)/p(2)]x + p(3), iff p(4) = 1
C A = p(1) + p(3) implies X_intersect = p(2), iff p(4) = 1
C
                  X0(1) = ZERO
                  Y0(1) = PARAM(1) + PARAM(3)
                  Y0(2) = Y0(1)
                  IF (ABS(PARAM(4) - ONE).LE.RTOL .AND.
     +               PARAM(2).GT.RTOL) THEN
                     L = 3
                     IF (PARAM(2).LE.X0(2)) THEN
                        X1(2) = PARAM(2)
                     ELSE
                        X1(2) = X0(2)
                     ENDIF
                     Y1(1) = PARAM(3)
                     Y1(2) = PARAM(1)*X1(2)/PARAM(2) + PARAM(3)
                  ENDIF
                  PTITLE = '  Data and Best-Fit asymptote'
               ELSEIF (ITIME.EQ.5) THEN
C
C f(x) = p(1)x + p(2)[1 - exp(-p(3)x)] + p(4)
C t(x) = [p(1) + p(2)p(3)]x + p(4), iff p(3) > 0
C A(x) = p(1)x + [p(2) + p(4)]
C        implies X_intersect = -[p(2) + p(4)]/p(1), iff p(3) > 0
C
                  XTEMP = X0(2)
                  Y0(1) = ZERO
                  IF (ABS(PARAM(1)).GT.RTOL) THEN
                     X0(1) = - (PARAM(2) + PARAM(4))/PARAM(1)
                  ELSEIF (PARAM(1).GT.ZERO) THEN
                     X0(1) = - (PARAM(2) + PARAM(4))/RTOL
                  ELSE
                     X0(1) = (PARAM(2) + PARAM(4))/RTOL
                  ENDIF
                  IF (X0(1).GE.X0(2)) X0(2) = X0(1) + X0(2)
                  Y0(2) = PARAM(1)*X0(2) + PARAM(2) + PARAM(4)
                  IF (X0(1).GE.ZERO) THEN
                     L = 3
                     X1(2) = XTEMP
                     Y1(1) = PARAM(4)
                     Y1(2) = (PARAM(1) + PARAM(2)*PARAM(3))*X1(2) +
     +                        PARAM(4)
                  ELSEIF (PARAM(3).GT.RTOL) THEN
                     L = 3
                     X1(2) = ONE/PARAM(3)
                     IF (X1(2).GT.X0(2)) X1(2) = X0(2)
                     Y1(1) = PARAM(4)
                     Y1(2) = (PARAM(1) + PARAM(2)*PARAM(3))*X1(2) +
     +                        PARAM(4)
                  ENDIF
                  PTITLE = '  Data and Best-Fit asymptote'
               ENDIF
               J = 6*NPTS
               DO I = 1, NGRAF
                  W(J + I) = FMOD(KPAR, PARAM, XGRAF(I))
               ENDDO
               XTITLE = '       t'
               YTITLE = '      f(t)'
               I = 2*NPTS + 1
               J = NPTS + 1
               K = 6*NPTS + 1
               CALL GKS004 (L0, L1, L2, L,
     +                      L5, L0, L0, L0,
     +                      NPTS, NGRAF, L2, L2,
     +                      W(I), XGRAF, X0, X1,
     +                      W(J), W(K), Y0, Y1,
     +                      PTITLE, XTITLE, YTITLE, AXES, GSAVE)
            ENDIF
         ENDDO
      ENDIF
      IF (PLOT(2)) THEN
         Y0(1) = ZERO
         Y0(2) = ZERO
         WRITE (LINE,700) ITIME
         YES = .FALSE.
         CALL YESNO2 (JCOLOR, JX, JY, LINE, YES)
         IF (YES) THEN
            I = 2*NPTS + 1
            J = 4*NPTS + 1
            K = 3*NPTS
            X0(1) = W(I)
            X0(2) = W(K)
            PTITLE = '     Residuals Against t'
            XTITLE = '       t'
            YTITLE = '    Residuals'
            CALL GKS004 (L0, L3, L0, L0, L3, L0, L0, L0,
     +                   NPTS, L2, L2, L2,
     +                   W(I), X0, X0, X0, W(J), Y0, Y0,
     +                   Y0, PTITLE, XTITLE, YTITLE, AXES, GSAVE)
         ENDIF
         WRITE (LINE,800) WORD, ITIME
         YES = .FALSE.
         CALL YESNO2 (JCOLOR, JX, JY, LINE, YES)
         IF (YES) THEN
            I = 3*NPTS + 1
            X0(1) = W(I)
            X0(2) = W(I)
            J = I - 1
            DO I = 1, NPTS
               J = J + 1
               IF (W(J).LT.X0(1)) X0(1) = W(J)
               IF (W(J).GT.X0(2)) X0(2) = W(J)
            ENDDO
            I = 3*NPTS + 1
            J = 5*NPTS + 1
            IF (WEIGHT) THEN
               PTITLE = 'Wtd. Residuals Against Best-Fit'
               YTITLE = '  Wtd. Residuals '
            ELSE
               PTITLE = '   Residuals Against Best-Fit'
               YTITLE = '     Residuals'
            ENDIF
            XTITLE = ' Best-Fit Theory'
            CALL GKS004 (L0, L3, L0, L0, L3, L0, L0, L0,
     +                   NPTS, L2, L2, L2,
     +                   W(I), X0, X0, X0, W(J), Y0, Y0,
     +                   Y0, PTITLE, XTITLE, YTITLE, AXES, GSAVE)
         ENDIF
      ENDIF
C
C Now store all the important statistics for subroutine SUMMIT
C
      STAT(ITIME,1) = WSSQ
      STAT(ITIME,2) = NDOF
      STAT(ITIME,3) = PGCHI
      STAT(ITIME,4) = PROBR
      STAT(ITIME,5) = NBAD
      STAT(ITIME,6) = NFLY
      STAT(ITIME,7) = STAT(ITIME,5)/DBLE(NPTS)
      STAT(ITIME,8) = AVRR
      STAT(ITIME,9) = PW
C
C Format statements
C      
  100 FORMAT (/1X,'Goodness of fit for model',I2/)
  200 FORMAT (1X,'Weighted sum of squares WSSQ      =',1P,E13.5
     +/1X,'P(chi-sq. variable >= WSSQ)       =',0P,F8.4,6X,A31
     +/1X,'1% upper tail chi-sq. value       =',1P,E13.5
     +/1X,'5% upper tail chi-sq. value       =',   E13.5
     +/1X,'R squared (theory,experiment)     =',0P,F8.4,
     +/1X,'Number of negative residuals (m)  =',I6
     +/1X,'Number of positive residuals (n)  =',I6
     +/1X,'Number of runs observed (r)       =',I6
     +/1X,'p = P(runs =< r : given m and n)  =',0P,F8.4,6X,A31
     +/1X,'1% lower tail critical value      =',I6
     +/1X,'5% lower tail critical value      =',I6
     +/1X,'p = P(runs =< r : given m plus n) =',   F8.4,6X,A31
     +/1X,'p = P(signs =< observed) (2 tail) =',   F8.4,6X,A31
     +/1X,'Durbin-Watson test statistic      =',   F8.4,6X,A31
     +/1X,'Shapiro-Wilks W (wtd. res.)       =',F8.4
     +/1X,'Significance level of W           =',F8.4,6X,A
     +/1X,'Akaike AIC statistic              =',1P,E13.5
     +/1X,'Schwarz SC statistic              ='   ,E13.5)
  250 FORMAT (1X,'Weighted sum of squares WSSQ      =', 1X,A
     +/1X,'P(chi-sq. variable >= WSSQ)       =', F7.4,6X,A31
     +/1X,'1% upper tail chi-sq. value       =', 1X,A
     +/1X,'5% upper tail chi-sq. value       =', 1X,A
     +/1X,'R squared (theory,experiment)     =', F8.4,
     +/1X,'Number of negative residuals (m)  =', 1X,A
     +/1X,'Number of positive residuals (n)  =', 1X,A
     +/1X,'Number of runs observed (r)       =', 1X,A
     +/1X,'p = P(runs =< r : given m and n)  =', F7.4,6X,A31
     +/1X,'1% lower tail critical value      =', 1X,A
     +/1X,'5% lower tail critical value      =', 1X,A
     +/1X,'p = P(runs =< r : given m plus n) =', F7.4,6X,A31
     +/1X,'p = P(signs =< observed) (2 tail) =', F7.4,6X,A31
     +/1X,'Durbin-Watson test statistic      =', F7.4,6X,A31
     +/1X,'Shapiro-Wilks W (wtd. res.)       =', F7.4
     +/1X,'Significance level of W           =', F7.4,6X,A
     +/1X,'Akaike AIC statistic              =', 1X,A
     +/1X,'Schwarz SC statistic              =', 1X,A)   
  300 FORMAT (1X,'Unweighted sum of squares SSQ     =',1P,E13.5
     +/1X,'Best-fit variance estimate        =',   E13.5
     +/1X,'Sample average of size values     =',   E13.5
     +/1X,'Estimated average coeff.var.%     =',0P,F12.4
     +/1X,'R squared (theory,experiment)     =',   F8.4,
     +/1X,'Number of negative residuals (m)  =',I6
     +/1X,'Number of positive residuals (n)  =',I6
     +/1X,'Number of runs observed (r)       =',I6
     +/1X,'p = P(runs =< r : given m and n)  =',0P,F8.4,6X,A31
     +/1X,'1% lower tail critical value      =',I6
     +/1X,'5% lower tail critical value      =',I6
     +/1X,'p = P(runs =< r : given m plus n) =',   F8.4,6X,A31
     +/1X,'p = P(signs =< observed) (2 tail) =',   F8.4,6X,A31
     +/1X,'Durbin-Watson test statistic      =',   F8.4,6X,A31
     +/1X,'Shapiro-Wilks W (wtd. res.)       =',F8.4
     +/1X,'Significance level of W           =',F8.4,6X,A
     +/1X,'Akaike AIC statistic              =',1P,E13.5
     +/1X,'Schwarz SC statistic              ='   ,E13.5)
  350 FORMAT (1X,'Unweighted sum of squares SSQ     =', 1X,A
     +/1X,'Best-fit variance estimate        =', 1X,A
     +/1X,'Sample average of size values     =', 1X,A
     +/1X,'Estimated average coeff.var.%     =', F12.4
     +/1X,'R squared (theory,experiment)     =', F8.4,
     +/1X,'Number of negative residuals (m)  =', 1X,A
     +/1X,'Number of positive residuals (n)  =', 1X,A
     +/1X,'Number of runs observed (r)       =', 1X,A
     +/1X,'p = P(runs =< r : given m and n)  =', F7.4,6X,A31
     +/1X,'1% lower tail critical value      =', 1X,A
     +/1X,'5% lower tail critical value      =', 1X,A
     +/1X,'p = P(runs =< r : given m plus n) =', F7.4,6X,A31
     +/1X,'p = P(signs =< observed) (2 tail) =', F7.4,6X,A31
     +/1X,'Durbin-Watson test statistic      =', F7.4,6X,A31
     +/1X,'Shapiro-Wilks W (wtd. res.)       =', F7.4
     +/1X,'Significance level of W           =', F7.4,6X,A
     +/1X,'Akaike AIC statistic              =', 1X,A
     +/1X,'Schwarz SC statistic              =', 1X,A)   
  400 FORMAT (
     +'Plot  data and best-fit f(t) curve for model',I2,' ?')
  500 FORMAT (
     + 'First time message about limiting tangents and asymptotes'
     +/
     +/'After fitting model 2, the limiting tangent used to estimate'
     +/'the initial rate can be plotted and, after fitting models 3,'
     +/'4 or 5 the asymptotes can be seen, so you can check the fit.'
     +/'Models 3, 4, and especially 5, often seem to fit well over'
     +/'the data range, but outside this range they may extrapolate'
     +/'to meaningless values, indicating an ill-determined model.'
     +/'So the asymptotic behaviour of the model fitted can be seen,'
     +/'in addition to the best fit curve, to check for this problem.'
     +/'If the asymptotic behaviour indicates that a badly defined'
     +/'model has been fitted, then you cannot trust the parameters'
     +/'estimated and need better data. If model 5 cannot be fitted'
     +/'by this program in such a way as to gives sensible estimates'
     +/'for the asymptotic steady state and lag time, you may have'
     +/'to use program QNFIT, where you can control the parameter'
     +/'starting estimates and limits.')
  600 FORMAT (
     + 'Plot data and best-fit curve'
     +/'Plot tangent and asymptote'
     +/'Both plots'
     +/'Cancel')
  700 FORMAT (
     +'Plot residuals against indep. var. for model',I2,' ?')
  800 FORMAT (
     +'Plot ',A4,' residuals against theory for model',I2,' ?')
      END
C
C
      SUBROUTINE SUMMIT (NF, NOPT, STAT, FITTED, WEIGHT)
C
C Sum it all up
C
      IMPLICIT   NONE
      INTEGER    NF, NOPT
      INTEGER    I, NBAD, NDOF, NFLY, NSCORE
      INTEGER    NFIT
      INTEGER    COLOUR
      DOUBLE PRECISION STAT(NOPT,9)
      DOUBLE PRECISION AVRRPC, PGCHI, PROB, VAREST, WSSQ
      LOGICAL    FITTED(NOPT), WEIGHT
      CHARACTER (LEN = 13) D13(2), SHOWRJ
      CHARACTER  SYMBOL*7, VERDIC(11)*10, WORD*1
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   TABLE1
      INTRINSIC  NINT
      DATA VERDIC / '  Terrible',
     +              ' Very  bad',
     +              '       Bad',
     +              ' Very Poor',
     +              '      Poor',
     +              '      Fair',
     +              '      Good',
     +              ' Very good',
     +              ' Excellent',
     +              ' Fantastic',
     +              'Incredible' /
      E_NUMBERS = E_FORMATS()
      NFIT = 0
      DO I = 1, NOPT
         IF (FITTED(I)) NFIT = NFIT + 1
      ENDDO
      IF (NFIT.LT.1) RETURN
      COLOUR = 15
      CALL TABLE1 (COLOUR, 'OPEN')
      IF (WEIGHT) THEN
         SYMBOL = 'P(C>=W)'
         WORD = 'W'
      ELSE
         SYMBOL = ' Av.cv%'
         WORD = ' '
      ENDIF
      WRITE (TEXT,100) WORD, WORD, SYMBOL
      WRITE (NF,100) WORD, WORD, SYMBOL
      COLOUR = 4
      DO I = 1, 5
         CALL TABLE1 (COLOUR, TEXT(I))
      ENDDO
      COLOUR = 0
      DO I = 1, NOPT
         IF (FITTED(I)) THEN
            NSCORE = 1
            IF (WEIGHT) THEN
               IF (STAT(I,3).GT.0.01D+00) NSCORE = NSCORE + 1
               IF (STAT(I,3).GT.0.05D+00) NSCORE = NSCORE + 1
            ELSE
               IF (STAT(I,3).LT.10.0D+00) NSCORE = NSCORE + 1
               IF (STAT(I,3).LT.20.0D+00) NSCORE = NSCORE + 1
            ENDIF
            IF (STAT(I,4).GT.0.01D+00) NSCORE = NSCORE + 1
            IF (STAT(I,4).GT.0.05D+00) NSCORE = NSCORE + 1
            IF (STAT(I,6).LT.1.00D+00) NSCORE = NSCORE + 1
            IF (STAT(I,7).LT.0.10D+00) NSCORE = NSCORE + 1
            IF (STAT(I,7).LT.0.25D+00) NSCORE = NSCORE + 1
            IF (STAT(I,8).LT.0.05D+00) NSCORE = NSCORE + 1
            IF (STAT(I,8).LT.0.10D+00) NSCORE = NSCORE + 1
            IF (STAT(I,9).GT.0.05D+00) NSCORE = NSCORE + 1
            WSSQ = STAT(I,1)
            NDOF = NINT(STAT(I,2))
            VAREST = STAT(I,1)/STAT(I,2)
            PGCHI = STAT(I,3)
            PROB = STAT(I,4)
            NBAD = NINT(STAT(I,5))
            NFLY = NINT(STAT(I,6))
            AVRRPC = 100.0D+00*STAT(I,8)
            IF (E_NUMBERS) THEN
               WRITE (LINE,200) I, WSSQ, NDOF, VAREST, PGCHI, PROB,
     +                          NBAD, NFLY, AVRRPC, VERDIC(NSCORE)
               WRITE (NF,200) I, WSSQ, NDOF, VAREST, PGCHI, PROB,
     +                        NBAD, NFLY, AVRRPC, VERDIC(NSCORE)
            ELSE
               D13(1) = SHOWRJ(WSSQ)
               D13(2) = SHOWRJ(VAREST)
               WRITE (LINE,250) I, D13(1), NDOF, D13(2), PGCHI, PROB,
     +                          NBAD, NFLY, AVRRPC, VERDIC(NSCORE)
               WRITE (NF,250) I, D13(1), NDOF, D13(2), PGCHI, PROB,
     +                        NBAD, NFLY, AVRRPC, VERDIC(NSCORE)
            ENDIF  
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
      ENDDO
      CALL TABLE1 (COLOUR, 'CLOSE')
C
C Format statements
C      
  100 FORMAT (/1X,'Summary'//1X,'Model',6X,A1,'SSQ',2X,'NDOF',5X,A1,
     +'SSQ/NDOF',3X,A7,2X,'P(R=<r)  N>10% N>40%  Av.r%',3X,
     +'Verdict'/)
  200 FORMAT (I2,1P,1X,E13.5,I6,1X,E13.5,0P,2F9.3,I7,I5,F9.2,1X,A)
  250 FORMAT (I2,   1X,  A13,I6,1X,A13,     2F9.3,I7,I5,F9.2,1X,A)
      END
C
C
      SUBROUTINE ZEROIN (ITIME, NPAR, DFDT0, EPSI, PARAM, RTOL,
     +                   TMAX, TMIN, TZERO, OK)
C
C Calculate T0 and DF/DT at T = T0 where F(T0) = 0
C
      IMPLICIT   NONE
      INTEGER    ITIME, NPAR
      INTEGER    ICOUNT, IFAIL
      DOUBLE PRECISION DFDT0, EPSI, PARAM(NPAR), RTOL, TMAX, TMIN,
     +                 TZERO
      DOUBLE PRECISION ONE, TWO, FOUR
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, FOUR = 4.0D+00)
      DOUBLE PRECISION A, ARG, B, DELTA, EPS, ETA, ROOT1, ROOT2
      DOUBLE PRECISION FUNC
      LOGICAL    OK
      EXTERNAL   C05ADF$
      EXTERNAL   MIDDLE, PUTADV
      EXTERNAL   FUNC
      INTRINSIC  SQRT, ABS, LOG, EXP
      IF (ITIME.EQ.1) THEN
         IF (ABS(PARAM(1)).LT.RTOL) GOTO 40
         TZERO = - PARAM(2)/PARAM(1)
         DFDT0 = PARAM(1)
      ELSEIF (ITIME.EQ.2) THEN
         DELTA = PARAM(2)**2 - FOUR*PARAM(1)*PARAM(3)
         IF (DELTA.LE.RTOL) GOTO 40
         ROOT1 = (- PARAM(2) + SQRT(DELTA))/(TWO*PARAM(1))
         ROOT2 = (- PARAM(2) - SQRT(DELTA))/(TWO*PARAM(1))
         IF (ABS(ROOT1).LE.ABS(ROOT2)) THEN
            TZERO = ROOT1
         ELSE
            TZERO = ROOT2
         ENDIF
         DFDT0 = TWO*PARAM(1)*TZERO + PARAM(2)
      ELSEIF (ITIME.EQ.3) THEN
         IF (ABS(PARAM(1)).LE.RTOL) GOTO 40
         DELTA = (PARAM(1) + PARAM(3))/PARAM(1)
         IF (DELTA.LE.RTOL) GOTO 40
         TZERO = - LOG(DELTA)/PARAM(2)
         ARG = - PARAM(2)*TZERO
         CALL MIDDLE (LOG(RTOL), ARG, LOG(ONE/RTOL))
         DFDT0 = PARAM(1)*PARAM(2)*EXP(ARG)
      ELSEIF (ITIME.EQ.4) THEN
         IF (PARAM(4).LE.(ONE - TWO*EPSI) .OR.
     +       PARAM(4).GE.(ONE + TWO*EPSI)) GOTO 40
         DELTA = PARAM(1) + PARAM(3)
         IF (DELTA.LE.RTOL) GOTO 40
         TZERO = - PARAM(2)*PARAM(3)/DELTA
         DELTA = (PARAM(2) + TZERO)**2
         IF (DELTA.LE.RTOL) GOTO 40
         DFDT0 = PARAM(1)*PARAM(2)/DELTA
      ELSEIF (ITIME.EQ.5) THEN
         ICOUNT = 0
         DELTA = (TMAX - TMIN)/(FOUR*FOUR)
         A = TMAX - TWO*DELTA
         B = TMIN + TWO*DELTA
   20    CONTINUE
         DELTA = TWO*DELTA
         A = A - DELTA
         B = B + DELTA
         EPS = EPSI
         ETA = RTOL
         IFAIL = 1
         CALL C05ADF$(A, B, EPS, ETA, FUNC, TZERO, IFAIL)
         IF (IFAIL.NE.0) THEN
            ICOUNT = ICOUNT + 1
            IF (ICOUNT.LE.8) GOTO 20
C*************************
C Switch off this message
C***********CALL PUTIFA (IFAIL, NF, 'C05ADF/ZEROIN')
            GOTO 40
         ENDIF
         ARG = - PARAM(3)*TZERO
         CALL MIDDLE (LOG(RTOL), ARG, LOG(ONE/RTOL))
         DFDT0 = PARAM(1) + PARAM(2)*PARAM(3)*EXP(ARG)
      ENDIF
      OK = .TRUE.
      RETURN
   40 CONTINUE
      CALL PUTADV ('Extrapolation to f(t) = 0 is not possible')
      OK = .FALSE.
      END
C
C
      FUNCTION DSDT (ITIME, K, P, T)
C
C Function for DS/DT
C
      IMPLICIT   NONE
      INTEGER    ITIME, K
      DOUBLE PRECISION P(K)
      DOUBLE PRECISION T
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION ENEG, EPOS, EPSI, RTOL
      DOUBLE PRECISION DSDT
      DOUBLE PRECISION ARG, BOT, TOP
      COMMON
     +/TOL/ ENEG, EPOS, EPSI, RTOL
      EXTERNAL  MIDDLE
      INTRINSIC ABS, EXP
      DSDT = ZERO
      IF (ITIME.EQ.1) THEN
         DSDT = P(1)
      ELSEIF (ITIME.EQ.2) THEN
         DSDT =  TWO*P(1)*T + P(2)
      ELSEIF (ITIME.EQ.3) THEN
         IF (P(2).GT.ZERO) THEN
            ARG = - P(2)*T
            CALL MIDDLE (ENEG, ARG, EPOS)
         ELSE
            ARG = ZERO
         ENDIF
         DSDT = P(1)*P(2)*EXP(ARG)
      ELSEIF (ITIME.EQ.4) THEN
         IF (T.LE.RTOL) RETURN
         IF (P(4).LT.ONE .AND. T.LT.EPSI) RETURN
         BOT = (ABS(P(2))**P(4) + T**P(4))**2
         IF (BOT.LE.RTOL) RETURN
         TOP = P(1)*P(4)*(T**(P(4) - ONE))*(ABS(P(2))**P(4))
         DSDT = TOP/BOT
      ELSEIF (ITIME.EQ.5) THEN
         IF (P(3).GT.ZERO) THEN
            ARG = - P(3)*T
            CALL MIDDLE (ENEG, ARG, EPOS)
         ELSE
            ARG = ZERO
         ENDIF
         DSDT = P(1) + P(2)*P(3)*EXP(ARG)
      ENDIF
      END
C
C
      FUNCTION FUNC (T)
C
C Function for ZEROIN
C
      IMPLICIT   NONE
      INTEGER    NX
      PARAMETER (NX = 4)
      INTEGER    ITIME, KPAR, NTOTL1, NTOTL2
      DOUBLE PRECISION T
      DOUBLE PRECISION PARAM, VALN
      DOUBLE PRECISION FUNC, FMOD
      EXTERNAL FMOD
      COMMON
     +/INT/ ITIME, KPAR, NTOTL1, NTOTL2
     +/PAR/ PARAM(NX), VALN
      FUNC = FMOD (KPAR, PARAM, T)
      END
C
C
