C
C INRATE4.INS
C ===========
C LMFUNC
C LSFUN1
C FMOD
C FZER
C LSJAC1
C JMOD
C JZER
C
C
      SUBROUTINE LMFUNC (M, N, X, FVEC, FJAC, LDFJAC, IFLAG)
C
C ACTION : Subroutine for MINPACK
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 26/8/97
C
      IMPLICIT NONE
      INTEGER  IFLAG, LDFJAC, M, N
      DOUBLE PRECISION FVEC(M), FJAC(LDFJAC,N), X(N)
      EXTERNAL LSFUN1, LSJAC1
      IF (IFLAG.EQ.1) THEN
         CALL LSFUN1 (M, N, X, FVEC)
      ELSEIF (IFLAG.EQ.2) THEN
         CALL LSJAC1 (M, N, LDFJAC, X, FJAC)
      ENDIF
      END
C
C
      SUBROUTINE LSFUN1 (M, N, XC, FVECC)
C
C Subroutine for E04FDF/LMFUNC/MINPACK
C This version only calls the model if EQUAL is false
C To work it is vital that equal(1) = .false.
C
      IMPLICIT   NONE
      INTEGER    NMAX
      PARAMETER (NMAX = 10000)
      INTEGER    M, N
      INTEGER    ITIME, KPAR, NTOTL1, NTOTL2
      INTEGER    I
      DOUBLE PRECISION FVECC(M), XC(N)
      DOUBLE PRECISION EN, SN, TN
      DOUBLE PRECISION FMOD, FZER
      DOUBLE PRECISION FCNVAL
      DOUBLE PRECISION ZERO1
      PARAMETER (ZERO1 = 0.0D+00)
      LOGICAL    EQUAL, FIXN, ZERO
      COMMON
     +/ARR/ EN(NMAX), SN(NMAX), TN(NMAX)
     +/INT/ ITIME, KPAR, NTOTL1, NTOTL2
     +/LGL/ EQUAL(NMAX), FIXN, ZERO
      EXTERNAL FZER, FMOD
C
C Count no. of iterations and those calling positive exponentials
C
      NTOTL1 = NTOTL1 + 1
      IF ((ITIME.EQ.3 .AND. XC(2).LT.ZERO1) .OR.
     +    (ITIME.EQ.5 .AND. XC(3).LT.ZERO1)) NTOTL2 = NTOTL2 + 1
C
C Evaluate model and Jacobian
C
      IF (ZERO) THEN
         DO I = 1, M
            IF (.NOT.EQUAL(I)) FCNVAL = FZER (N, XC, TN(I))
            FVECC(I) = (SN(I) - FCNVAL)/EN(I)
         ENDDO
      ELSE
         DO I = 1, M
            IF (.NOT.EQUAL(I)) FCNVAL = FMOD (N, XC, TN(I))
            FVECC(I) = (SN(I) - FCNVAL)/EN(I)
         ENDDO
      ENDIF
      END
C
C
      FUNCTION FMOD (K, P, T)
C
C ACTION: Function for LSFUN1 when ZERO = .FALSE.
C

      IMPLICIT   NONE
      INTEGER    NMAX, NX
      PARAMETER (NMAX = 10000, NX = 4)
      INTEGER    K
      INTEGER    ITIME, KPAR, NTOTL1, NTOTL2
      DOUBLE PRECISION P(K), T
      DOUBLE PRECISION PARAM, VALN
      DOUBLE PRECISION ENEG, EPOS, EPSI, RTOL
      DOUBLE PRECISION ARG, BOT, DUMMY, TOP
      DOUBLE PRECISION FMOD
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      LOGICAL    EQUAL, FIXN, ZERO
      COMMON
     +/LGL/ EQUAL(NMAX), FIXN, ZERO
     +/INT/ ITIME, KPAR, NTOTL1, NTOTL2
     +/PAR/ PARAM(NX), VALN
     +/TOL/ ENEG, EPOS, EPSI, RTOL
      EXTERNAL  MIDDLE
      INTRINSIC EXP, ABS, MAX
      IF (ITIME.EQ.1) THEN
         FMOD = T*P(1) + P(2)
      ELSEIF (ITIME.EQ.2) THEN
         FMOD = T*(P(1)*T + P(2)) + P(3)
      ELSEIF (ITIME.EQ.3) THEN
         ARG = - P(2)*T
         CALL MIDDLE (ENEG, ARG, EPOS)
         FMOD = P(1)*(ONE - EXP(ARG)) + P(3)
      ELSEIF (ITIME.EQ.4) THEN
         IF (FIXN) THEN
            DUMMY = VALN
         ELSE
            DUMMY = MAX(RTOL, P(4))
         ENDIF
         ARG = T**DUMMY
         BOT = MAX(RTOL, P(2))**DUMMY + ARG
         IF (ABS(BOT).LE.RTOL) THEN
            FMOD = P(3)
         ELSE
            TOP = P(1)*ARG
            FMOD = TOP/BOT + P(3)
         ENDIF
      ELSEIF (ITIME.EQ.5) THEN
         ARG = - P(3)*T
         CALL MIDDLE (ENEG, ARG, EPOS)
         FMOD = P(1)*T + P(2)*(ONE - EXP(ARG)) + P(4)
      ENDIF
      END
C
C
      FUNCTION FZER (K, P, T)
C
C ACTION: Function for LSFUN1 when ZERO = .TRUE.
C

      IMPLICIT   NONE
      INTEGER    NMAX, NX
      PARAMETER (NMAX = 10000, NX = 4)
      INTEGER    K
      INTEGER    ITIME, KPAR, NTOTL1, NTOTL2
      DOUBLE PRECISION P(K)
      DOUBLE PRECISION T
      DOUBLE PRECISION PARAM, VALN
      DOUBLE PRECISION ENEG, EPOS, EPSI, RTOL
      DOUBLE PRECISION ARG, BOT, DUMMY, TOP
      DOUBLE PRECISION FZER
      DOUBLE PRECISION ZERO1, ONE
      PARAMETER (ZERO1 = 0.0D+00, ONE = 1.0D+00)
      LOGICAL    EQUAL, FIXN, ZERO
      COMMON
     +/LGL/ EQUAL(NMAX), FIXN, ZERO
     +/INT/ ITIME, KPAR, NTOTL1, NTOTL2
     +/PAR/ PARAM(NX), VALN
     +/TOL/ ENEG, EPOS, EPSI, RTOL
      EXTERNAL  MIDDLE
      INTRINSIC ABS, EXP, MAX
      IF (ITIME.EQ.1) THEN
         FZER = T*P(1)
      ELSEIF (ITIME.EQ.2) THEN
         FZER = T*(P(1)*T + P(2))
      ELSEIF (ITIME.EQ.3) THEN
         ARG = - P(2)*T
         CALL MIDDLE (ENEG, ARG, EPOS)
         FZER = P(1)*(ONE - EXP(ARG))
      ELSEIF (ITIME.EQ.4) THEN
         IF (FIXN) THEN
            DUMMY = VALN
         ELSE
            DUMMY = MAX(RTOL, P(3))
         ENDIF
         ARG = T**DUMMY
         BOT = MAX(RTOL, P(2))**DUMMY + ARG
         IF (ABS(BOT).LE.RTOL) THEN
            FZER = ZERO1
         ELSE
            TOP = P(1)*ARG
            FZER = TOP/BOT
         ENDIF
      ELSEIF (ITIME.EQ.5) THEN
         ARG = - P(3)*T
         CALL MIDDLE (ENEG, ARG, EPOS)
         FZER = P(1)*T + P(2)*(ONE - EXP(ARG))
      ENDIF
      END
C
C
      SUBROUTINE LSJAC1 (M, N, NRMAX, XC, FJACC)
C
C Subroutine for LMFUNC/MINPACK
C
      IMPLICIT   NONE
      INTEGER    NMAX
      PARAMETER (NMAX = 10000)
      INTEGER    M, N, NRMAX
      INTEGER    I, J
      DOUBLE PRECISION FJACC(NRMAX,N), XC(N)
      DOUBLE PRECISION EN, SN, TN
      DOUBLE PRECISION Z(5)
      LOGICAL    EQUAL, FIXN, ZERO
      COMMON
     +/ARR/ EN(NMAX), SN(NMAX), TN(NMAX)
     +/LGL/ EQUAL(NMAX), FIXN, ZERO
      EXTERNAL JZER, JMOD
      IF (ZERO) THEN
         DO I = 1, M
            IF (.NOT.EQUAL(I)) CALL JZER (N, XC, TN(I), Z)
            DO J = 1, N
               FJACC(I,J) =  - Z(J)/EN(I)
            ENDDO
         ENDDO
      ELSE
         DO I = 1, M
            IF (.NOT.EQUAL(I)) CALL JMOD (N, XC, TN(I), Z)
            DO J = 1, N
               FJACC(I,J) = - Z(J)/EN(I)
            ENDDO
         ENDDO
      ENDIF
      END
C
C
      SUBROUTINE JMOD (K, P, T, Z)
C
C Subroutine for LSJAC1 when ZERO = .FALSE.
C Note that the derivatives are calculated and sign changed in LSJAC1
C
      IMPLICIT   NONE
      INTEGER    NMAX, NX
      PARAMETER (NMAX = 10000, NX = 4)
      INTEGER    K
      INTEGER    ITIME, KPAR, NTOTL1, NTOTL2
      DOUBLE PRECISION P(K)
      DOUBLE PRECISION T, Z(K)
      DOUBLE PRECISION PARAM, VALN
      DOUBLE PRECISION ENEG, EPOS, EPSI, RTOL
      DOUBLE PRECISION ARG, BOT, BOT2, DUMMY, P2, P2P4, P4, P4M1, TEMP,
     +                 TP4, TOP
      DOUBLE PRECISION ZERO1, ONE
      PARAMETER (ZERO1 = 0.0D+00, ONE = 1.0D+00)
      LOGICAL    EQUAL, FIXN, ZERO
      COMMON
     +/LGL/ EQUAL(NMAX), FIXN, ZERO
     +/INT/ ITIME, KPAR, NTOTL1, NTOTL2
     +/PAR/ PARAM(NX), VALN
     +/TOL/ ENEG, EPOS, EPSI, RTOL
      EXTERNAL  MIDDLE
      INTRINSIC EXP, ABS, LOG, MAX
      IF (ITIME.EQ.1) THEN
         Z(1) = T
         Z(2) = ONE
      ELSEIF (ITIME.EQ.2) THEN
         Z(1) = T*T
         Z(2) = T
         Z(3) = ONE
      ELSEIF (ITIME.EQ.3) THEN
         ARG = - P(2)*T
         CALL MIDDLE (ENEG, ARG, EPOS)
         DUMMY = EXP(ARG)
         Z(1) = ONE - DUMMY
         Z(2) = P(1)*T*DUMMY
         Z(3) = ONE
      ELSEIF (ITIME.EQ.4) THEN
         P2 = MAX(RTOL, P(2))
         IF (FIXN) THEN
            P4 = VALN
         ELSE
            P4 = MAX(RTOL, P(4))
         ENDIF
         P4M1 = P4 - ONE
         TEMP = MAX(RTOL, T)
         TP4 = TEMP**P4
         P2P4 = P2**P4
         BOT = P2P4 + TP4
         IF (ABS(BOT).LE.RTOL) THEN
            Z(1) = ZERO1
            Z(2) = ZERO1
            Z(3) = ONE
            IF (.NOT.FIXN) Z(4) = ZERO1
         ELSE
            BOT2 = BOT*BOT
            TOP = P(1)*TP4
            Z(1) = TP4/BOT
            Z(2) = - TOP*P2**P4M1*P4/BOT2
            Z(3) = ONE
            IF (.NOT.FIXN) THEN
               IF (T.LE.RTOL) THEN
                  Z(4) = ZERO1
               ELSE
                  Z(4) = TOP*P2P4*(LOG(TEMP) - LOG(P2))/BOT2
               ENDIF
            ENDIF
         ENDIF
      ELSEIF (ITIME.EQ.5) THEN
         ARG = - P(3)*T
         CALL MIDDLE (ENEG, ARG, EPOS)
         DUMMY = EXP(ARG)
         Z(1) = T
         Z(2) = ONE - DUMMY
         Z(3) = P(2)*T*DUMMY
         Z(4) = ONE
      ENDIF
      END
C
C
      SUBROUTINE JZER (K, P, T, Z)
C
C Subroutine for LSJAC1 when ZERO = .TRUE.
C Note that the derivatives are calculated and sign changed in LSJAC1
C

      IMPLICIT   NONE
      INTEGER    NMAX, NX
      PARAMETER (NMAX = 10000, NX = 4)
      INTEGER    K
      INTEGER    ITIME, KPAR, NTOTL1, NTOTL2
      DOUBLE PRECISION P(K), T, Z(K)
      DOUBLE PRECISION PARAM, VALN
      DOUBLE PRECISION ENEG, EPOS, EPSI, RTOL
      DOUBLE PRECISION ARG, BOT, BOT2, DUMMY, P2, P2P3, P3, P3M1,
     +                 TP3, TEMP, TOP
      DOUBLE PRECISION ZERO1, ONE
      PARAMETER (ZERO1 = 0.0D+00, ONE = 1.0D+00)
      LOGICAL    EQUAL, FIXN, ZERO
      COMMON
     +/LGL/ EQUAL(NMAX), FIXN, ZERO
     +/INT/ ITIME, KPAR, NTOTL1, NTOTL2
     +/PAR/ PARAM(NX), VALN
     +/TOL/ ENEG, EPOS, EPSI, RTOL
      EXTERNAL  MIDDLE
      INTRINSIC ABS, EXP, LOG, MAX
      IF (ITIME.EQ.1) THEN
         Z(1) = T
      ELSEIF (ITIME.EQ.2) THEN
         Z(1) = T*T
         Z(2) = T
      ELSEIF (ITIME.EQ.3) THEN
         ARG = - P(2)*T
         CALL MIDDLE (ENEG, ARG, EPOS)
         DUMMY = EXP(ARG)
         Z(1) = ONE - DUMMY
         Z(2) = P(1)*T*DUMMY
      ELSEIF (ITIME.EQ.4) THEN
         P2 = MAX(ABS(P(2)), RTOL)
         IF (FIXN) THEN
            P3 = VALN
         ELSE
            P3 = MAX(RTOL, P(3))
         ENDIF
         P3M1 = P3 - ONE
         TEMP = MAX(RTOL, T)
         TP3 = TEMP**P3
         P2P3 = P2**P3
         BOT = P2P3 + TP3
         IF (ABS(BOT).LE.RTOL) THEN
            Z(1) = ZERO1
            Z(2) = ZERO1
            IF (.NOT.FIXN) Z(3) = ZERO1
         ELSE
            BOT2 = BOT*BOT
            TOP = P(1)*TP3
            Z(1) = TP3/BOT
            Z(2) = - TOP*P2**P3M1*P3/BOT2
            IF (.NOT.FIXN) THEN
               IF (T.LE.RTOL) THEN
                  Z(3) = ZERO1
               ELSE
                  Z(3) = TOP*P2P3*(LOG(TEMP) - LOG(P2))/BOT2
               ENDIF
            ENDIF
         ENDIF
      ELSEIF (ITIME.EQ.5) THEN
         ARG = - P(3)*T
         CALL MIDDLE (ENEG, ARG, EPOS)
         DUMMY = EXP(ARG)
         Z(1) = T
         Z(2) = ONE - DUMMY
         Z(3) = P(2)*T*DUMMY
      ENDIF
      END
C
C
