
C
C FTN95 version
C =============
C
C LINFIT.FOR: ADVISE
C LINFIT1.FOR: FITLIN
C
C
C     INCLUDE 'linfit1.for'
C     INCLUDE 'dllchk.for'
C
      PROGRAM MAIN
C
C VERSION : details from SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C NAG     : G02DAF, etc.
C INPUT   : File with TITLE, N, X1, X2, ..., XN, Y, S
C           as prepared by program MAKFIL, MAKDAT, etc.
C ACTION  : Linear regression by G02DAF, etc.
C OUTPUT  : Details to a results file
C ADVICE  : Set parameters : NF  = output unit
C                            NIN = input unit
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K., 24/6/96
C           07/08/1998 added dllchk
C           14/12/1998 replaced TUTORS by TUTOR1
C           28/01/1999 added call to MATTRN
C           18/03/1999 added L1NORM
C           01/04/1999 added LINORM
C           13/09/1999 added call to WINDOW
C           17/09/1999 added call to ORTHOG
C           12/02/2000 added call to SIMVER
C           29/03/2001 revised
C           08/05/2001 created simplified options menu
C           29/08/2002 increased dimension of JWRK and altered call to GLMINI
C           30/07/2005 increased DVER to *30 and added to call to ADVISE
C           05/11/2005 new version of subroutine DETAIL
C           09/01/2006 deleted D in call to LINEAR and V in call to GLMINI
C           16/01/2006 deleted E in call to L1NORM AND LINORM
C           24/04/2005 replaced GLMINI by M_GLMINI
C           21/05/2006 deleted W1 and W2 from call to MATTRN
C           20/07/2006 completely new version calling FITLIN
C           07/09/2023 added SV_FITLIN and uses the command line to define JUMP
C
      IMPLICIT   NONE
      INTEGER    NF, NIN
      PARAMETER (NF = 4, NIN = 3)
      INTEGER    ISEND
      INTEGER    I, IOS, I_LENGTH, I_STATUS, J, N0, N1, N10
      PARAMETER  (N0 = 0, N1 = 1, N10 = 10)
      DOUBLE PRECISION XVER, YVER
      CHARACTER (LEN = 100) COMMAND
      CHARACTER (LEN = 1  ) BLANK, LETTER 
      PARAMETER (BLANK = ' ')
      CHARACTER  DVER*30, FNAME*1024, PNAME*6, PVER*15, TITLE*80
      PARAMETER (PNAME = 'LINFIT', PVER = 'w_linfit.exe')
      LOGICAL    JUMP
      LOGICAL    ABORT, ACTION, FIRST, ISTOP, SHOW
      EXTERNAL   SV_FITLIN
      EXTERNAL   ADVISE, FITLIN
      EXTERNAL   DLLCHK, WINDOW, SIMVER, RESFIL, FNAMES

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release details
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C
C
C First check the command line to initialise ISEND and JUMP
C
      ISEND = COMMAND_ARGUMENT_COUNT()  
      IF (ISEND.NE.N1) THEN
         ISEND = N0
      ELSE      
         CALL GET_COMMAND_ARGUMENT (N1, COMMAND, I_LENGTH, I_STATUS)
         IF (I_LENGTH.GE.N1 .AND. I_STATUS.EQ.N0) THEN
C
C 29/10/2023
C Replaced non-integer characters by blanks to interpret '0' as 0 which causes trouble otherwise
C It appears that 'i' is passed by run_program and returned as such by command argument 
C retrieval and read accurately except for '0' which is not read as 0 even if the quotes are 
C removed. Is it being read as a C string terminator ? So 0 is changed to 11 to call sv_simstat. 
C         
            do i = 1, i_length
               letter = command(i:i)
               j = ichar(letter)
               if (j.lt.48 .or. j.gt.57) command(i:i) = blank
            enddo           
            READ (COMMAND,*,IOSTAT=IOS) I
            IF (IOS.EQ.N0) THEN
               IF (I.GE.N1 .AND. I.LE.N10) THEN
                  ISEND = I
               ELSE
                  ISEND = N0
               ENDIF
            ELSE
               ISEND = N0
            ENDIF
         ELSE
            ISEND = N0
         ENDIF      
      ENDIF
      IF (ISEND.EQ.N0) THEN
         JUMP = .FALSE.
      ELSE
         JUMP = .TRUE.
      ENDIF

C
C Initialise
C
      FIRST = .TRUE.
      IF (JUMP) THEN
         ISTOP = .FALSE.
      ELSE   
        CALL ADVISE (DVER,
     +              ISTOP, FIRST)
      ENDIF
      IF (.NOT.ISTOP) THEN
         CALL RESFIL (NF,
     +                FNAME, ISTOP)
         IF (.NOT.ISTOP) THEN
            IF (JUMP) THEN
               WRITE (NF,200)
               CALL SV_FITLIN (NIN, NF)
            ELSE   
               WRITE (NF,100)
               CALL FITLIN (NIN, NF)
            ENDIF
        ENDIF       


      ENDIF
C
C Inform user about results file
C      
      CLOSE (UNIT = NF)
      ISEND = 2
      CALL FNAMES (ISEND,
     +             FNAME) 

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NF)
C
C Format statements
C
  100 FORMAT (
     +/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : LINFIT'
     +/1X,'ACTION  : Fit linear models'
     +/1X,'AUTHOR  : W.G.Bardsley, University of Manchester, U.K.')
  200 FORMAT (
     +/1X,'PACKAGE : SIMFIT'
     +/1X,'PROGRAM : SV_LINFIT'
     +/1X,'ACTION  : Fit linear models'
     +/1X,'AUTHOR  : W.G.Bardsley, University of Manchester, U.K.')     
      END
C
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ICOLOR, NUMHDR, NUMOPT, ISEND
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_LINFIT
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_LINFIT ('linfit')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `LINFIT'
     +/'        `      '
     +/'Action  `Linear calibration, interactive multi-linear'
     +/'        `regression, generalised linear models (GLM),'
     +/'        `orthogonal, and robust regression.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
