
C
C LINFIT1.FOR: Include file for LINFIT
C ============
C
C 20/07/2006 derived from SIMSTAT6
C 02/10/2007 added INTENTS
C 07/09/2023 added SV_FITLIN
C-----------------------------------------------------------------------
C
      SUBROUTINE FITLIN (NIN, NOUT)
C
C Regress
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (IN) :: NIN, NOUT
C
C Local arrays
C
      INTEGER    NAMAX
      PARAMETER (NAMAX = 30)
      INTEGER    NCSAV(NAMAX), NRSAV(NAMAX)
      CHARACTER  FNAMEA(NAMAX)*1024, TITLEA(NAMAX)*80
C
C Locals
C
      INTEGER    IX, IY, NUMDEC, NUMOPT, NTEXT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 24, NTEXT = NUMOPT + 1)
      INTEGER    I, ISEND, MARK
      INTEGER    MTYPE
      PARAMETER (MTYPE = 3)
      CHARACTER  TEXT(NTEXT)*100
      CHARACTER  NAG5*5
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      LOGICAL    OK, REPEET
      LOGICAL    ASAMOD
      PARAMETER (ASAMOD = .FALSE.)
      EXTERNAL   LVIEW2, REVPRO, TTEST2, PCVTS3, DLLNAG, PLSFIT
      EXTERNAL   M_MATONE, M_GLMINI
      EXTERNAL   HELP_LINFIT
C
C Check for NAG library
C      
      CALL DLLNAG (MARK, OK)
C
C Initialise default files
C      
      DO I = 1, NAMAX
         NCSAV(I) = 0
         NRSAV(I) = 0
         FNAMEA(I) = 'No File'
         TITLEA(I) = 'No data'
      ENDDO
      CLOSE (UNIT = NIN)
C
C Main loop
C      
      NUMDEC = NUMOPT
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CLOSE (UNIT = NIN)
         IF (OK .AND. MARK.GE.20) THEN
            NAG5 = '     '
         ELSE
            NAG5 = '[NAG]'
         ENDIF
         WRITE (TEXT,100) NAG5, NAG5, NAG5
         NUMDEC = NUMOPT - 1
         CALL LVIEW2 (IX, IY, NUMDEC, NUMOPT,
     +                TEXT, TITLES)
         IF (NUMDEC.GE.1 .AND. NUMDEC.LE.6) THEN
C
C Fit one of three line types in simple or advanced mode
C
            ISEND = NUMDEC + 14
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.GE.7 .AND. NUMDEC.LT.11) THEN
C
C Fit one of various polynomial types
C
            ISEND = NUMDEC + 14
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.11) THEN
C
C Multilinear regression: L1
C
            ISEND = 27
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
        ELSEIF (NUMDEC.EQ.12) THEN
C
C Multilinear regression: L2
C
            ISEND = 25
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.13) THEN
C
C Multilinear regression: L_infinity
C
            ISEND = 28
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.14) THEN
C
C Multilinear regression: M-estimates
C
            ISEND = 26
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND)) 
             ELSEIF (NUMDEC.EQ.15) THEN
C
C Multilinear regression: on ranks
C
            ISEND = 29
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.16) THEN
C
C Dose-response by GLM
C
            ISEND = 12
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.17) THEN
C
C Logistic regression by GLM
C
            CALL M_GLMINI (MTYPE, NIN, NOUT)
         ELSEIF (NUMDEC.EQ.18) THEN
C
C Cox regression
C
            ISEND = 11
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.19) THEN
C
C PLS
C         
            CALL PLSFIT (NIN, NOUT,
     +                   ASAMOD)             
         ELSEIF (NUMDEC.EQ.NUMOPT - 4) THEN
C
C Test two parameters
C
            CALL TTEST2 (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 3) THEN
C
C Test two sets of parameters
C
            CALL PCVTS3 (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
            CALL HELP_LINFIT ('linfit')
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'The LINFIT linear regression type options`Data Type'
     +/'Fit a line (simple least squares)        `x,y,s data'
     +/'Fit a line (simple reduced major axis)   `x,y,s data'
     +/'Fit a line (simple orthogonal)           `x,y,s data'
     +/'Fit a line (advanced least squares)      `x,y,s data'
     +/'Fit a line (advanced reduced major axis) `x,y,s data'
     +/'Fit a line (advanced orthogonal)         `x,y,s data'
     +/'Fit a line/calibrate (simple)            `x,y,s data'
     +/'Fit a line/calibrate (advanced)          `x,y,s data'
     +/'Fit a polynomial/calibrate (x,y)         `x,y,s data'
     +/'Fit a polynomial/calibrate (g(x),f(y))   `x,y,s data'
     +/'Multilinear regression: L_1 norm         `x1,...,xm,y,s data'
     +/'Multilinear regression: Least Squares    `x1,...,xm,y,s data'
     +/'Multilinear regression: L_infinity norm  `x1,...,xm,y,s data'
     +/'Multilinear regression: M-estimates      `x1,...,xm,y,s data',
     +1X,A  
     +/'Multilinear regression: on ranks         `x1,...,xm,y,t,s data',
     +1X,A
     +/'Fit LD50 dose-response curves (GLM)      `x,y,N,s data'
     +/'Fit logistic regression models (GLM)     `x1,...,xm,y,N,s data'
     +/'Fit the Cox proportional hazards model   `',
     + 'x1,...,xm,y,t,s data',1X,A
     +/'Partial least squares (PLS)              `X, Y, Z matrices'
     +/'Compare 2 regression parameters          `p,se(p),npts,npar'
     +/'Compare 2 sets of regression parameters  `c_recent.cfg files'
     +/'Results                                  `...'
     +/'Help                                     `...'
     +/'Exit program LINFIT                      `...')
      END
C
C SV_FITLIN.FOR: Include file for SV_LINFIT
C ==============
C
C 20/07/2006 derived from SIMSTAT6
C 02/10/2007 added INTENTS
C 07/09/2023 version for SV_SIMFIT
C
C-----------------------------------------------------------------------
C
      SUBROUTINE SV_FITLIN (NIN, NOUT)
C
C Regress
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (IN) :: NIN, NOUT
C
C Local arrays
C
      INTEGER    NAMAX
      PARAMETER (NAMAX = 30)
      INTEGER    NCSAV(NAMAX), NRSAV(NAMAX)
      CHARACTER  FNAMEA(NAMAX)*1024, TITLEA(NAMAX)*80
C
C Locals
C
      INTEGER    IX, IY, NUMDEC, NUMOPT, NTEXT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 9, NTEXT = NUMOPT + 1)
      INTEGER    NUMSTA
      PARAMETER (NUMSTA = 2) 
      INTEGER    NUMBLD(NTEXT) 
      INTEGER    I, ISEND
      INTEGER    MTYPE
      PARAMETER (MTYPE = 3)
      INTEGER    MODE
      CHARACTER  TEXT(NTEXT)*100
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      LOGICAL    REPEET
      LOGICAL    ASAMOD
      PARAMETER (ASAMOD = .FALSE.)
      EXTERNAL   LVIEW2, REVPRO, TTEST2, PCVTS3, PLSFIT
      EXTERNAL   M_MATONE, M_GLMINI
      EXTERNAL   HELP_LINFIT
      EXTERNAL   LSTBOX
      MODE = 2
      DO I = 1, NTEXT
        NUMBLD(I) = 0
      ENDDO
      NUMBLD(1) = 4  
C
C Check for NAG library
C      
C      CALL DLLNAG (MARK, OK)
C
C Initialise default files
C      
      DO I = 1, NAMAX
         NCSAV(I) = 0
         NRSAV(I) = 0
         FNAMEA(I) = 'No File'
         TITLEA(I) = 'No data'
      ENDDO
      CLOSE (UNIT = NIN)
C
C Main loop
C      
      NUMDEC = NUMOPT
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CLOSE (UNIT = NIN)
c         IF (OK .AND. MARK.GE.20) THEN
c            NAG5 = '     '
c         ELSE
c            NAG5 = '[NAG]'
c         ENDIF
         IF (MODE.EQ.1) THEN
            WRITE (TEXT,100) 
            NUMDEC = 1
            CALL LVIEW2 (IX, IY, NUMDEC, NUMOPT,
     +                   TEXT, TITLES)
         ELSE
            WRITE (TEXT,200) 
            NUMDEC = 1
            CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NTEXT,
     +                   TEXT)            

         ENDIF  
         IF (NUMDEC.EQ.1) THEN
            CONTINUE
         ELSEIF (NUMDEC.EQ.2) THEN
            NUMDEC = 4
         ELSEIF (NUMDEC.EQ.3) THEN
            NUMDEC = 7
         ELSEIF (NUMDEC.EQ.4) THEN
            NUMDEC = 8
         ELSEIF (NUMDEC.EQ.5) THEN
            NUMDEC = 12
         ElSEIF (NUMDEC.EQ.6) THEN
            NUMDEC = 16   
         ELSEIF (NUMDEC.EQ.7) THEN
            NUMDEC = 22
         ELSEIF (NUMDEC.EQ.8) THEN
            NUMDEC = 23
         ELSE
            NUMDEC = 24
         ENDIF 

         
         IF (NUMDEC.EQ.1 .OR. NUMDEC.EQ.4) THEN
C
C Fit a line in simple or advanced mode
C
            ISEND = NUMDEC + 14
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
          ELSEIF (NUMDEC.EQ.7 .OR. NUMDEC.EQ.8) THEN
C
C Fit one of various polynomial types
C
            ISEND = NUMDEC + 14
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.11) THEN
C
C Multilinear regression: L1
C
            ISEND = 27
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
        ELSEIF (NUMDEC.EQ.12) THEN
C
C Multilinear regression: L2
C
            ISEND = 25
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.13) THEN
C
C Multilinear regression: L_infinity
C
            ISEND = 28
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.14) THEN
C
C Multilinear regression: M-estimates
C
            ISEND = 26
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND)) 
             ELSEIF (NUMDEC.EQ.15) THEN
C
C Multilinear regression: on ranks
C
            ISEND = 29
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.16) THEN
C
C Dose-response by GLM
C
            ISEND = 12
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.17) THEN
C
C Logistic regression by GLM
C
            CALL M_GLMINI (MTYPE, NIN, NOUT)
         ELSEIF (NUMDEC.EQ.18) THEN
C
C Cox regression
C
            ISEND = 11
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.19) THEN
C
C PLS
C         
            CALL PLSFIT (NIN, NOUT,
     +                   ASAMOD)             
         ELSEIF (NUMDEC.EQ.NUMOPT - 4) THEN
C
C Test two parameters
C
            CALL TTEST2 (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 3) THEN
C
C Test two sets of parameters
C
            CALL PCVTS3 (NOUT)
         ELSEIF (NUMDEC.EQ.22) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.23) THEN
C
C Help
C
            CALL HELP_LINFIT ('linfit')
         ELSEIF (NUMDEC.EQ.24) THEN
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'The LINFIT linear regression type options`Data Type'
     +/'Fit a line (simple least squares)        `x,y,s data'
c****+/'Fit a line (simple reduced major axis)   `x,y,s data'
c****+/'Fit a line (simple orthogonal)           `x,y,s data'
     +/'Fit a line (advanced least squares)      `x,y,s data'
c****+/'Fit a line (advanced reduced major axis) `x,y,s data'
c****+/'Fit a line (advanced orthogonal)         `x,y,s data'
     +/'Fit a line/calibrate (simple)            `x,y,s data'
     +/'Fit a line/calibrate (advanced)          `x,y,s data'
c****+/'Fit a polynomial/calibrate (x,y)         `x,y,s data'
c****+/'Fit a polynomial/calibrate (g(x),f(y))   `x,y,s data'
c****+/'Multilinear regression: L_1 norm         `x1,...,xm,y,s data'
     +/'Multilinear regression: Least Squares    `x1,...,xm,y,s data'
c****+/'Multilinear regression: L_infinity norm  `x1,...,xm,y,s data'
c****+/'Multilinear regression: M-estimates      `x1,...,xm,y,s data',
c***** 1X,A  
c****/'Multilinear regression: on ranks         `x1,...,xm,y,t,s data',
c****+1X,A
c****+/'Fit LD50 dose-response curves (GLM)      `x,y,N,s data'
c****+/'Fit logistic regression models (GLM)     `x1,...,xm,y,N,s data'
c****+/'Fit the Cox proportional hazards model   `',
c****+ 'x1,...,xm,y,t,s data',1X,A
c****+/'Partial least squares (PLS)              `X, Y, Z matrices'
c****+/'Compare 2 regression parameters          `p,se(p),npts,npar'
c****+/'Compare 2 sets of regression parameters  `c_recent.cfg files'
     +/'Results                                  `...'
     +/'Help                                     `...'
     +/'Exit program LINFIT                      `...')
  200 FORMAT (
     + 'The sv_simfit linear regression options' 
     +/'Fit a line (simple least squares)'
     +/'Fit a line (advanced least squares)'
     +/'Fit a line/calibrate (simple)'
     +/'Fit a line/calibrate (advanced)'
     +/'Multilinear regression: Least Squares'
     +/'Fit LD50 dose-response curves (GLM)'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit linear regression options')    
      END
C
C
