C
C FTN95 version
C =============
C
C
C      INCLUDE 'dllchk.for'
      PROGRAM MAIN
C
C ACTION  : MAKE DATA FOR CSAFIT
C VERSION : details from SIMVER/DLLCHK
C           ALPHA = STRETCH
C           BETA = TRANSLATION
C           XBOT = LOWEST INSTRUMENT SETTING
C           XTOP = HIGHEST INSTRUMENT SETTING
C           XMU = MU IN MODEL FUNCTION
C           SIG = SIGMA IN MODEL FUNCTION
C           NCELL = TOTAL NO. CELLS COUNTED
C           NMAX = MAXIMUM ARRAY DIMENSION
C           NPTS = TOTAL NO. CHANNEL SETTINGS
C           DELTA = (XTOP - XBOT)/NPTS = HISTOGRAM BIN WIDTH
C           XSTART = XBOT + DELTA = FIRST CHANNEL SETTING
C AUTHOR  : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K. 10/2/91
C           16/12/1994 DBOS version
C           08/02/1995 Overhauled parameter setting routine PARAMS
C           20/02/1995 Salamanca version
C           05/11/1997 win32 version
C           07/08/1998 added dllchk
C           13/09/1999 added call to WINDOW
C           12/02/2000 added call to SIMVER
C           29/03/2001 revised
C           30/07/2005 increased DVER to *30 and added to call to ADVISE
C           08/02/2008 edited for version 6
C
      IMPLICIT   NONE
C
C Allocatable arrays
C      
      DOUBLE PRECISION, ALLOCATABLE :: X(:), Y(:), YSAV(:), Z(:),
     +                                 ZSAV(:)
C
C Declarations
C     
      INTEGER    NMAX
      INTEGER    NPTS, NPTS1
      PARAMETER (NPTS1 = 250)
      INTEGER    NCELL, NCELL1
      PARAMETER (NCELL1 = 30000)
      INTEGER    L0, L1
      PARAMETER (L0 = 0, L1 = 1)
      INTEGER    I, IERR, ISEND, ITEMP, KNOTS, NOUT
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 4, NUMOPT = 6,
     +           NSTART = 13, NTEXT = 18)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION ALPHA, ALPHA1, BETA, BETA1
      PARAMETER (ALPHA1 = 15.0D+00, BETA1 = 5.0D+00)
      DOUBLE PRECISION SIG, SIG1, XMU, XMU1
      PARAMETER (SIG1 = 25.0D+00, XMU1 = 100.0D+00)
      DOUBLE PRECISION XBOT, XBOT1, XTOP, XTOP1
      PARAMETER (XBOT1 = 0.0D+00, XTOP1 = 250.0D+00)
      DOUBLE PRECISION RKNOTS(9), TEMP(9)
      DOUBLE PRECISION DELTA, ERROR, FRACTN, HALF, PCENT
      DOUBLE PRECISION XSTART, YBOT, YTOP
      DOUBLE PRECISION ARGY, ARGZ, RNCELL
      DOUBLE PRECISION A, YFACT, YSUM, ZFACT, ZSUM
      DOUBLE PRECISION ENEG, EPOS, X02AMF$
      DOUBLE PRECISION FUNC, G05DDF$
      DOUBLE PRECISION ZERO, ONE, TWO, F4, F100, F200
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           F4 = 4.0D+00, F100 = 1.0D+02, F200 = 2.0D+02)
      DOUBLE PRECISION XVER, YVER
      CHARACTER  PNAME*6
      PARAMETER (PNAME = 'MAKCSA')
      CHARACTER (LEN = 13) D13(4), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12) I12(3), FORM12
      CHARACTER (LEN = 10) WORD10(50)
      CHARACTER (LEN = 9 ) D09, FORM09 
      CHARACTER  FNAME*1024, TITLE*100
      CHARACTER  PTITLE*15, XTITLE*16, YTITLE*12
      CHARACTER  TEXT(30)*100
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_makcsa.exe')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, ACTION, SHOW
      LOGICAL    AXES, SAVEIT
      PARAMETER (AXES = .TRUE., SAVEIT = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)

      COMMON     ALPHA, BETA, ENEG, EPOS, SIG, XMU

      EXTERNAL   E_FORMATS, FORM09, FORM12, SHOWLJ, SHOWRJ
      EXTERNAL   X02AMF$, G05CCF$, G05DDF$
      EXTERNAL   GKS004, OFILES, GETDL1, LBOX01, HELP_MAKCSA
      EXTERNAL   ADVISE, PARAMS, FUNC
      EXTERNAL   DLLCHK, WINDOW, SIMVER
      INTRINSIC  NINT, LOG, DBLE

      DATA       PTITLE, XTITLE, YTITLE / 'Data Histograms',
     +                                    'Channel Settings',
     +                                    'No. of cells' /
      DATA       NUMBLD / 1*4, 17*0 /
      DATA       NUMPOS / NUMOPT*1 /

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      E_NUMBERS = E_FORMATS()
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER, 
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C


      CALL ADVISE (DVER,
     +             ABORT)
      IF (ABORT) GOTO 60
      CALL G05CCF$
      ENEG = LOG(X02AMF$())
      EPOS = - ENEG
      NDEC = 1
      
      IERR = 0
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) GOTO 60 
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      IF (ALLOCATED(YSAV)) DEALLOCATE(YSAV, STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      IF (ALLOCATED(Z)) DEALLOCATE(Z, STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      IF (ALLOCATED(ZSAV)) DEALLOCATE(ZSAV, STAT = IERR)
      IF (IERR.NE.0) GOTO 60
        
      NMAX = NPTS1

      ALLOCATE(X(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      ALLOCATE(Y(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      ALLOCATE(YSAV(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      ALLOCATE(Z(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      ALLOCATE(ZSAV(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 60
                
   20 CONTINUE
C
C SET VALUES FOR PARAMETERS
C
      CALL PARAMS (NCELL, NCELL1, NPTS, NPTS1,
     +             ALPHA, ALPHA1, BETA, BETA1, PCENT, SIG, SIG1, XBOT, 
     +             XBOT1, XMU, XMU1, XTOP, XTOP1)

      IF (NPTS.GT.NMAX) THEN
         IERR = 0
         IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
         IF (IERR.NE.0) GOTO 60 
         IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         IF (ALLOCATED(YSAV)) DEALLOCATE(YSAV, STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         IF (ALLOCATED(Z)) DEALLOCATE(Z, STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         IF (ALLOCATED(ZSAV)) DEALLOCATE(ZSAV, STAT = IERR)
         IF (IERR.NE.0) GOTO 60
        
         NMAX = NPTS

         ALLOCATE(X(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         ALLOCATE(Y(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         ALLOCATE(YSAV(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         ALLOCATE(Z(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         ALLOCATE(ZSAV(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 60      
      ENDIF
             
      DELTA = (XTOP - XBOT)/DBLE(NPTS)
      XSTART = XBOT + DELTA
      HALF = DELTA/TWO
      YBOT = ALPHA*XBOT + BETA
      YTOP = ALPHA*XTOP + BETA
      IF (YBOT.LT.XBOT) YBOT = XBOT
      IF (YBOT.GT.XTOP) YBOT = XTOP
      IF (YTOP.GT.XTOP) YTOP = XTOP
      IF (YTOP.LT.XBOT) YTOP = XBOT
      A = ONE/ALPHA
      YSUM = ZERO
      ZSUM = ZERO
      DO I = 1, NPTS
         IF (I.EQ.1) THEN
            X(I) = XSTART
         ELSEIF (I.EQ.NPTS) THEN
            X(I) = XTOP
         ELSE
           X(I) = X(I - 1) + DELTA
         ENDIF
         ARGY = X(I) - HALF
         Y(I) = FUNC(ARGY)
         IF (ARGY.LT.YBOT) THEN
            Z(I) = ZERO
         ELSEIF (ARGY.GT.YTOP) THEN
            Z(I) = ZERO
         ELSE
            ARGZ = A*(ARGY - BETA)
            Z(I) = A*FUNC(ARGZ)
         ENDIF
         YSUM = YSUM + Y(I)
         ZSUM = ZSUM + Z(I)
      ENDDO
C
C X, Y AND Z HAVE BEEN SET SO NOW NORMALISE DATA
C
      RNCELL = DBLE(NCELL)
      YFACT = RNCELL/YSUM
      ZFACT = RNCELL/ZSUM
      YSUM = ZERO
      ZSUM = ZERO
      DO I = 1, NPTS
         Y(I) = YFACT*Y(I)
         Z(I) = ZFACT*Z(I)
         YSAV(I) = Y(I)
         ZSAV(I) = Z(I)
         YSUM = YSUM + Y(I)
         ZSUM = ZSUM + Y(I)
      ENDDO
   40 CONTINUE
      IF (E_NUMBERS) THEN
         WRITE (TEXT,100) NINT(YSUM), NINT(ZSUM), NPTS, XBOT, XTOP, XMU,
     +                    SIG, F100*(ALPHA - ONE),
     +                    F100*BETA/(XTOP - XBOT), PCENT
      ELSE
         ITEMP = NINT(YSUM)
         I12(1) = FORM12(ITEMP)
         ITEMP = NINT(ZSUM)
         I12(2) = FORM12(ITEMP)
         I12(3) = FORM12(NPTS)
         D13(1) = SHOWLJ(XBOT)
         D13(2) = SHOWLJ(XTOP)
         D13(3) = SHOWLJ(XMU)
         D13(4) = SHOWLJ(SIG)
         WRITE (TEXT,150) I12(1), I12(2), I12(3), D13(1), D13(2),
     +                    D13(3), D13(4),
     +                    F100*(ALPHA - ONE),
     +                    F100*BETA/(XTOP - XBOT), PCENT 
      ENDIF  
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NDEC.EQ.1) THEN
         CALL GKS004 (L1, L1, L0, L0, L0, L0, L0, L0,
     +                NPTS, NPTS, NPTS, NPTS,
     +                X, X, X, X, Y, Z, Z, Z,
     +                PTITLE, XTITLE, YTITLE,
     +                AXES, SAVEIT)
         GOTO 40
      ELSEIF (NDEC.EQ.2) THEN
         GOTO 20
      ELSEIF (NDEC.EQ.3) THEN
         CALL GETDL1 (ZERO, PCENT, F200,
     +               'The percentage relative error required')
         FRACTN = PCENT/F100
         DO I = 1, NPTS
            ERROR = G05DDF$(ZERO, ONE)
            IF (ERROR.LT. - F4) ERROR = - F4
            IF (ERROR.GT.   F4) ERROR =   F4
            Y(I) = YSAV(I)*(ONE + FRACTN*ERROR)
            IF (Y(I).LT.ZERO) Y(I) = ZERO
            ERROR = G05DDF$(ZERO, ONE)
            IF (ERROR.LT. - F4) ERROR = - F4
            IF (ERROR.GT.   F4) ERROR =   F4
            Z(I) = ZSAV(I)*(ONE + FRACTN*ERROR)
            IF (Z(I).LT.ZERO) Z(I) = ZERO
         ENDDO
         YSUM = ZERO
         ZSUM = ZERO
         DO I = 1, NPTS
             Y(I) = DBLE(NINT(Y(I)))
             Z(I) = DBLE(NINT(Z(I)))
             YSUM = YSUM + Y(I)
             ZSUM = ZSUM + Z(I)
         ENDDO  
         GOTO 40
      ELSEIF (NDEC.EQ.4) THEN
         ISEND = 1
         NOUT = 4
         CLOSE (UNIT = NOUT)
         CALL OFILES (ISEND, NOUT,
     +                FNAME,
     +                ABORT)
         IF (ABORT) THEN
           CLOSE (UNIT = NOUT) 
           GOTO 40
         ENDIF
         TEMP(1) = XMU - TWO*SIG
         DO I = 2, 8
            TEMP(I) = TEMP(I - 1) + SIG/TWO
         ENDDO   
         TEMP(9) = XMU + TWO*SIG
         KNOTS = 0  
         DO I = 1, 9
            IF (TEMP(I).GT.XBOT .AND. TEMP(I).LT.XTOP) THEN
               KNOTS = KNOTS + 1
               RKNOTS(KNOTS) = TEMP(I)
            ENDIF   
         ENDDO  
         WRITE (NOUT,300)
         WRITE (NOUT,400) NPTS, 3
         IF (E_NUMBERS) THEN
            WRITE (NOUT,500) (X(I), NINT(Y(I)), NINT(Z(I)), I = 1, NPTS)
         ELSE
            DO I = 1, NPTS
               D13(1) = SHOWRJ(X(I))
               WRITE (NOUT,550) D13(1), NINT(Y(I)), NINT(Z(I)) 
            ENDDO
         ENDIF  
         IF (KNOTS.LT.4) THEN
            WRITE (NOUT,600) 13
            IF (E_NUMBERS) THEN
               WRITE (NOUT,700) NINT(YSUM), NINT(ZSUM), NPTS,
     +                          XBOT, XTOP, XMU, SIG,
     +                          F100*(ALPHA - ONE),
     +                          F100*BETA/(XTOP - XBOT), PCENT
            ELSE
               ITEMP = NINT(YSUM)
               I12(1) = FORM12(ITEMP)
               ITEMP = NINT(ZSUM)
               I12(2) = FORM12(ITEMP)
               I12(3) = FORM12(NPTS)
               D13(1) = SHOWLJ(XBOT)
               D13(2) = SHOWLJ(XTOP)
               D13(3) = SHOWLJ(XMU)
               D13(4) = SHOWLJ(SIG)  
               WRITE (NOUT,750) I12(1), I12(2), I12(3),
     +                          D13(1), D13(2), D13(3), D13(4),
     +                          F100*(ALPHA - ONE),
     +                          F100*BETA/(XTOP - XBOT), PCENT  
            ENDIF  
         ELSE
            WRITE (NOUT,600) 18 
            WRITE (NOUT,600) KNOTS
            IF (E_NUMBERS) THEN
               WRITE (NOUT,'(1P,50E10.2)') (RKNOTS(I), I = 1, KNOTS)
            ELSE   
               DO I = 1, KNOTS
                  D09 = FORM09(RKNOTS(I))
                  WORD10(I) = ' '//D09
               ENDDO   
               WRITE (NOUT,'(50(A10))') (WORD10(I), I = 1, KNOTS)
            ENDIF  
            IF (E_NUMBERS) THEN
               WRITE (NOUT,800) NINT(YSUM), NINT(ZSUM), NPTS,
     +                          XBOT, XTOP, XMU, SIG, 
     +                          F100*(ALPHA - ONE),
     +                          F100*BETA/(XTOP - XBOT), PCENT
            ELSE
               ITEMP = NINT(YSUM)
               I12(1) = FORM12(ITEMP)
               ITEMP = NINT(ZSUM)
               I12(2) = FORM12(ITEMP)
               I12(3) = FORM12(NPTS)
               D13(1) = SHOWLJ(XBOT)
               D13(2) = SHOWLJ(XTOP)
               D13(3) = SHOWLJ(XMU)
               D13(4) = SHOWLJ(SIG)  
               WRITE (NOUT,850) I12(1), I12(2), I12(3),
     +                          D13(1), D13(2), D13(3), D13(4),
     +                          F100*(ALPHA - ONE),
     +                          F100*BETA/(XTOP - XBOT), PCENT  
            ENDIF  
         ENDIF
         CLOSE (UNIT = NOUT)
         GOTO 40
      ELSEIF (NDEC.EQ.5) THEN   
         CALL HELP_MAKCSA ('makcsa')
         GOTO 40
      ENDIF
   60 CONTINUE

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C

C
C Format statement
C
  100 FORMAT ('Current parameter settings'
     +/
     +/'Number of reference cells  =',I8
     +/'Number of test cells       =',I8
     +/'Number of channel settings =',I8
     +/'Lowest channel setting     =',1P,E11.3
     +/'Highest channel setting    =',   E11.3
     +/'Model parameter mu         =',   E11.3
     +/'Model parameter sigma      =',   E11.3
     +/'% stretch                  =',0P,F9.2,' %'
     +/'% translation              =',   F9.2,' %'
     +/'% relative error added     =',   F9.2,' %'
     +/'Display graph of the current data',1X,
     +'(inspect current histogram)'
     +/'Alter parameters for current data',1X,
     +'(make  error-free data set)'
     +/'Add  random error to current data',1X,
     +'(simulate experiment error)'
     +/'Write  the current data to a file',1X,
     +'(make data file for CSAFIT)'
     +/'Help'
     +/'Quit ... Exit program MAKCSA')
  150 FORMAT ('Current parameter settings'
     +/
     +/'Number of reference cells  `',1X,A
     +/'Number of test cells       `',1X,A
     +/'Number of channel settings `',1X,A
     +/'Lowest channel setting     `',1X,A
     +/'Highest channel setting    `',1X,A
     +/'Model parameter mu         `',1X,A
     +/'Model parameter sigma      `',1X,A
     +/'% stretch                  `',F9.2,' %'
     +/'% translation              `',F9.2,' %'
     +/'% relative error added     `',F9.2,' %'
     +/'Display graph of the current data',1X,
     +'(inspect current histogram)'
     +/'Alter parameters for current data',1X,
     +'(make  error-free data set)'
     +/'Add  random error to current data',1X,
     +'(simulate experiment error)'
     +/'Write  the current data to a file',1X,
     +'(make data file for CSAFIT)'
     +/'Help'
     +/'Quit ... Exit program MAKCSA')     
  300 FORMAT ('Data file output from MAKCSA for program CSAFIT')
  400 FORMAT (2I6)
  500 FORMAT (1P,E12.4,2I8)
  550 FORMAT (1X,A13,2I18)
  600 FORMAT (I6)
  700 FORMAT (
     + 1X,'Column 1 = Channel settings'
     +/1X,'Column 2 = Reference frequencies'
     +/1X,'Column 3 = Treatment frequencies'
     +/1X,'Number of  reference cells  =',   I8
     +/1X,'Number of  test cells       =',   I8
     +/1X,'Number of  channel settings =',   I8
     +/1X,'Lowest  channel setting     =',1P,E11.3
     +/1X,'Highest channel setting     =',   E11.3
     +/1X,'Model parameter mu          =',   E11.3
     +/1X,'Model parameter sigma       =',   E11.3
     +/1X,'% stretch                   =',0P,F9.2,' %'
     +/1X,'% translation               =',   F9.2,' %'
     +/1X,'% relative error added      =',   F9.2,' %')
  750 FORMAT (
     + 1X,'Column 1 = Channel settings'
     +/1X,'Column 2 = Reference frequencies'
     +/1X,'Column 3 = Treatment frequencies'
     +/1X,'Number of  reference cells  =',1X,A
     +/1X,'Number of  test cells       =',1X,A
     +/1X,'Number of  channel settings =',1X,A
     +/1X,'Lowest  channel setting     =',1X,A
     +/1X,'Highest channel setting     =',1X,A
     +/1X,'Model parameter mu          =',1X,A
     +/1X,'Model parameter sigma       =',1X,A
     +/1X,'% stretch                   =',F9.2,' %'
     +/1X,'% translation               =',F9.2,' %'
     +/1X,'% relative error added      =',F9.2,' %')   
  800 FORMAT (
     + 1X,'Previous two lines are only used in expert mode operation'
     +/1X,'Line 1: suggested number of knots'
     +/1X,'Line 2: suggested knot positions'
     +/1X,'Column 1 = Channel settings'
     +/1X,'Column 2 = Reference frequencies'
     +/1X,'Column 3 = Treatment frequencies'
     +/1X,'Number of  reference cells  =',   I8
     +/1X,'Number of  test cells       =',   I8
     +/1X,'Number of  channel settings =',   I8
     +/1X,'Lowest  channel setting     =',1P,E11.3
     +/1X,'Highest channel setting     =',   E11.3
     +/1X,'Model parameter mu          =',   E11.3
     +/1X,'Model parameter sigma       =',   E11.3
     +/1X,'% stretch                   =',0P,F9.2,' %'
     +/1X,'% translation               =',   F9.2,' %'
     +/1X,'% relative error added      =',   F9.2,' %')
  850 FORMAT (
     + 1X,'Previous two lines are only used in expert mode operation'
     +/1X,'Line 1: suggested number of knots'
     +/1X,'Line 2: suggested knot positions'
     +/1X,'Column 1 = Channel settings'
     +/1X,'Column 2 = Reference frequencies'
     +/1X,'Column 3 = Treatment frequencies'
     +/1X,'Number of  reference cells  =',1X,A
     +/1X,'Number of  test cells       =',1X,A
     +/1X,'Number of  channel settings =',1X,A
     +/1X,'Lowest  channel setting     =',1X,A
     +/1X,'Highest channel setting     =',1X,A
     +/1X,'Model parameter mu          =',1X,A
     +/1X,'Model parameter sigma       =',1X,A
     +/1X,'% stretch                   =',F9.2,' %'
     +/1X,'% translation               =',F9.2,' %'
     +/1X,'% relative error added      =',F9.2,' %')     
      END
C
C-----------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_MAKCSA
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (HEADER,100) DVER
         ISEND = 1
         CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                HEADER, OPTION)
         IF (ISEND.EQ.1) THEN
            CALL HELP_MAKCSA ('makcsa')
            REPEET = .TRUE.
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `MAKCSA'
     +/'        `      '
     +/'Action  `Simulate histogram data (e.g,  for CSAFIT)'
     +/'        `Input: parameters'
     +/'        `Output: simulated data'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE PARAMS (NCELL, NCELL1, NPTS, NPTS1,
     +                   ALPHA, ALPHA1, BETA, BETA1, PCENT, SIG, SIG1,
     +                   XBOT, XBOT1, XMU, XMU1, XTOP, XTOP1)
C
C INITIALISE THEN SET PARAMETERS FOR NEW DATA SET
C ON ENTRY ALPHA AND BETA ARE TRANSFORMED INTO %
C ON EXIT  ALPHA AND BETA ARE TRANSFORMED FROM %
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NCELL1, NPTS1
      INTEGER,          INTENT (INOUT) :: NCELL, NPTS
      DOUBLE PRECISION, INTENT (IN)    :: ALPHA1, BETA1, SIG1
      DOUBLE PRECISION, INTENT (INOUT) :: ALPHA, BETA, PCENT, SIG
      DOUBLE PRECISION, INTENT (IN)    :: XBOT1, XMU1, XTOP1
      DOUBLE PRECISION, INTENT (INOUT) :: XBOT, XMU, XTOP
C
C Locals
C      
      INTEGER    N10, N100, N1000, NBIG
      PARAMETER (N10 = 10, N100 = 100, N1000 = 1000, NBIG = 10000000)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 4, NUMOPT = 3,
     +           NSTART = 14, NTEXT = 16)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION ZERO, ONE, RTOL, BIG, HUN, TEN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, RTOL = 1.0D-7,
     +           BIG = 1.0D+35, HUN = 1.0D+02, TEN = 10.0D+00)
      CHARACTER (LEN = 12) WORD12, FORM12
      CHARACTER (LEN = 11) FORM11, SHOW11, WORD11(8)  
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      LOGICAL    E_NUMBERS, E_FORMATS, FIRST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .TRUE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, FORM11, FORM12, SHOW11 
      EXTERNAL   GETDM1, GETJM1, LBOX01
      INTRINSIC  TRIM
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
      DATA       NUMBLD / 1*1, 15*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C SET PCENT THEN INITIALISE OR TRANSFORM ALPHA AND BETA INTO %
C
      E_NUMBERS = E_FORMATS()
      IF (FIRST) THEN
         PCENT = TEN
         NCELL = NCELL1
         NPTS = NPTS1
         ALPHA = ALPHA1
         BETA = BETA1
         SIG = SIG1
         XBOT = XBOT1
         XMU = XMU1
         XTOP = XTOP1
         FIRST = .FALSE.
      ELSE
         ALPHA = HUN*(ALPHA - ONE)
         BETA = HUN*BETA/(XTOP - XBOT)
      ENDIF
   20 CONTINUE
      IF (E_NUMBERS) THEN
         WRITE (TEXT,100) NCELL,NCELL1,NPTS,NPTS1,XBOT,XBOT1,XTOP,XTOP1,
     +                    XMU,XMU1,SIG,SIG1,ALPHA,ALPHA1,BETA,BETA1
      ELSE
         WORD11(1) = SHOW11(XBOT)
         WORD11(2) = SHOW11(XBOT1)
         WORD11(3) = SHOW11(XTOP)
         WORD11(4) = SHOW11(XTOP1)
         WORD11(5) = SHOW11(XMU)
         WORD11(6) = SHOW11(XMU1)
         WORD11(7) = SHOW11(SIG)
         WORD11(8) = SHOW11(SIG1) 
         WRITE (TEXT,150) NCELL,NCELL1,NPTS,NPTS1,
     +                    WORD11(1), WORD11(2), WORD11(3), WORD11(4),
     +                    WORD11(5), WORD11(6), WORD11(7), WORD11(8),
     +                    ALPHA,ALPHA1,BETA,BETA1
      ENDIF  
      NDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NDEC.EQ.1) THEN
         NCELL = NCELL1
         NPTS = NPTS1
         XBOT = XBOT1
         XTOP = XTOP1
         XMU = XMU1
         SIG = SIG1
         ALPHA = ALPHA1
         BETA = BETA1
         GOTO 20
      ELSEIF (NDEC.EQ.2) THEN
         WORD12 = FORM12(NCELL)
         WRITE (LINE,200) TRIM(WORD12)
         CALL GETJM1 (N100, NCELL, NBIG, LINE)
         
         WORD12 = FORM12(NPTS)
         WRITE (LINE,300) TRIM(WORD12)
         CALL GETJM1 (N10, NPTS, N1000, LINE)
         
         WORD11(1) = FORM11(XBOT)
         WRITE (LINE,400) TRIM(WORD11(1))
         CALL GETDM1 (ZERO, XBOT, BIG, LINE)

         WORD11(1) = FORM11(XTOP)  
         WRITE (LINE,500) TRIM(WORD11(1))
         CALL GETDM1 (XBOT + RTOL, XTOP, BIG, LINE)
         
         WORD11(1) = FORM11(XMU) 
         WRITE (LINE,600) TRIM(WORD11(1))
         CALL GETDM1 (RTOL, XMU, BIG, LINE)
         
         WORD11(1) = FORM11(SIG) 
         WRITE (LINE,700) TRIM(WORD11(1))
         CALL GETDM1 (RTOL, SIG, BIG, LINE)
         
         WORD11(1) = FORM11(ALPHA)
         WRITE (LINE,800) TRIM(WORD11(1))
         CALL GETDM1 (-HUN, ALPHA, HUN, LINE)
         
         WORD11(1) = FORM11(BETA)
         WRITE (LINE,900) TRIM(WORD11(1))
         CALL GETDM1 (-HUN, BETA, HUN, LINE)
         GOTO 20
      ELSE
C
C TRANSFORM ALPHA, BETA FROM %
C
         ALPHA = ONE + ALPHA/HUN
         BETA = (BETA/HUN)*(XTOP - XBOT)
         RETURN
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Values for the parameters used by this program'
     +/
     +/'Parameter            Current value  Default value'
     +/
     +/'Number of cells     ',I11,5X,I11
     +/'Number of bins      ',I11,5X,I11
     +/'Lowest setting      ',1P,E11.3,5X,E11.3
     +/'Highest setting     ',E11.3,5X,E11.3
     +/'Mu                  ',E11.3,5X,E11.3
     +/'Sigma               ',E11.3,5X,E11.3
     +/'% stretch           ',0P,F11.3,5X,F11.3
     +/'% translation       ',F11.3,5X,F11.3/
     +/'Set all values to defaults'
     +/'Set all values as required'
     +/'Accept  all current values')
  150 FORMAT (
     + 'Values for the parameters used by this program'
     +/
     +/'Parameter            Current value  Default value'
     +/
     +/'Number of cells     ',I11,5X,I11
     +/'Number of bins      ',I11,5X,I11
     +/'Lowest setting      ',A11,5X,A11
     +/'Highest setting     ',A11,5X,A11
     +/'Mu                  ',A11,5X,A11
     +/'Sigma               ',A11,5X,A11
     +/'% stretch           ',F11.3,5X,F11.3
     +/'% translation       ',F11.3,5X,F11.3/
     +/'Set all values to defaults'
     +/'Set all values as required'
     +/'Accept  all current values')     
  200 FORMAT (
     +'Total number of cells required (current =',1X,A,')')
  300 FORMAT (
     +'Total number of channels required (current =',1X,A,')')
  400 FORMAT (
     +'Lowest channel setting required (current =',1X,A,')')
  500 FORMAT (
     +'Highest channel setting required (current =',1X,A,')')
  600 FORMAT (
     +'Mean mu required (current =',1X,A,')')
  700 FORMAT (
     +'Sigma required (current =',1X,A,')')
  800 FORMAT (
     +'Percentage stretch required (current =',1X,A,')')
  900 FORMAT (
     +'Percentage translation required (current =',1X,A,')')
      END
C
C-------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION FUNC(X)
      IMPLICIT  NONE
C
C Argument
C      
      DOUBLE PRECISION, INTENT (IN) :: X
C
C Locals
C      
      DOUBLE PRECISION ARG
      DOUBLE PRECISION ALPHA, BETA, ENEG, EPOS, SIG, XMU
      DOUBLE PRECISION HALF
      PARAMETER (HALF = 0.5D+00)

      COMMON    ALPHA, BETA, ENEG, EPOS, SIG, XMU

      INTRINSIC EXP
      ARG = - HALF*((X - XMU)/SIG)**2
      IF (ARG.GT.EPOS) THEN
         ARG = EPOS
      ELSEIF (ARG.LT.ENEG) THEN
         ARG = ENEG
      ENDIF
      FUNC = EXP(ARG)
      END
C
C
