C
C FTN95 version
C =============
C
C MAKDAT
C ======
C This version assumes that QNUSER is in MODELS.DLL so there is no
C need for MAKDAT7.FOR = QNUSER
C
C
C Include files: MAKDAT1.FOR:- ADVISE, BOTTOP, DECIDE
C                MAKDAT2.FOR:- INDATA, OUTDAT
C                MAKDAT3.FOR:- SETSUP, TIMEIN
C                MAKDAT4.FOR:- XYGRID, XYZVAL
C                MAKDAT5.FOR:- ZSOLVE, FZMOD
C                MAKDAT6.INS:- QMODEL, QMODEX ... = QNFIT4.INS
C
C
c      INCLUDE 'makdat1.for'
c      INCLUDE 'makdat2.for'
c      INCLUDE 'makdat3.for'
c      INCLUDE 'makdat4.for'
c      INCLUDE 'makdat5.for'
c      INCLUDE 'makdat6.for'
c      INCLUDE 'dllchk.for'
C
C******************************************************************
C Start of module for MAKDAT
C NP = maximum no. of columns
C NX = maximum no. of parameters
C******************************************************************
      MODULE MODULE_MAKDAT
      
      IMPLICIT NONE
      
      INTEGER    NP, NX
      PARAMETER (NP = 10000, NX = 100)
      INTEGER    KPAR
      PARAMETER (KPAR = 100)
      INTEGER    MODEL, NCALLS, NMOD, NPAR, NPTS, NVAR, NZEROS
      INTEGER    IRELAB, METH, MITER
      INTEGER    N1_SAV
      DOUBLE PRECISION ERROR(NP), FVAL(NP), XVAL(NP), YVAL(NP), ZVAL(NP)
      DOUBLE PRECISION X1_SAV(NP) 
      DOUBLE PRECISION A(NX), B(NX), FACT(NX), RNDOF, THEORY(NP)
      DOUBLE PRECISION DTOL, ENEG, EPOS, EPSI, RTOL, XTOL, ZTOL
      DOUBLE PRECISION X(NX)
      DOUBLE PRECISION XTEMP(NP)
      DOUBLE PRECISION P1(KPAR)
      LOGICAL    CONST, DEQN, EQUAL(NP)
      
      END MODULE MODULE_MAKDAT
C*******************************************************************
C End of module for MAKDAT
C*******************************************************************

      PROGRAM MAIN

      USE MODULE_MAKDAT
C
C VERSION : details from SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C NAG     : C05AZF, X02AJF, X02AMF
C SUPPLY  : Model subroutines
C INPUT   : Parameters and factors for a model in subroutine ZMODEL
C           Parameters fixed = 1.0 and factors set as required
C           Estimates for X-start and X-stop satisfying Y(X) = Constant
C OUTPUT  : Exact data for Y(X), X-start < = X < = X-stop, written
C           as X, Y, S = error in Y ( = 5.0%Y ) to a new file
C AUTHOR  : W. G. Bardsley  25/11/1985
C ADVICE  : COMMON blocks in FZMOD and QMODEL must be consistent with QNFIT
C           Note that unused COMMON preserve consistency with QNFIT library
C           This version also uses the same QMODEL as QNFIT but COMMON block
C           /NEW/ replaces /DAT/ to save storage space
C           COMMON blocks /IWK/, /RWK/ must only be used for the models
C           06/06/1994 COMMON blocks do not now overlap with library so they
C                      can be deleted if required with a bit of programming
C                      in FZMOD and QMODEL and where these are called
C REVISED : 04/09/1988 to accomodate differential equation models
C REVISED : 29/11/1989 to match revision of models
C REVISED : BOTTOP, TIMEIN, ZSOLVE and OUTDAT removed to library
C           13/04/1993 Developed from PC2 version MAKPOLY
C           14/04/1993 QNLIB1, QNSUB1, QMODEL from QNFIT series uses NFIX
C           23/06/1993 Removed array TEMP, added /IWRK/, /RWRK/ for models
C           09/01/1993 Version for models in a dynamic link library
C           21/06/1994 DBOS version 
C           06/10/1994 Added function of three variables
C           20/12/1994 Added differential equations and relaced /NEW/ by /DAT/
C           13/02/1995 Added scratch file so no crash when PUTIFA is called
C           11/07/1995 Added NZMOD, QNUSER so consistent with deqsol/qnfit
C           20/05/1997 removed COMMON blocks referring to QNUSER
C           20/05/1997 win32 version
C           13/10/1997 Adjusted dimensions and MAKDAT6.INS for DVODE
C           10/02/1998 Checked and minor adjustments
C           18/02/1998 removed topmost from %ww and added unit 6 for DVODE
C           07/08/1998 added dllchk
C           14/12/1998 replaced TUTORS by TUTOR1
C           13/09/1999 added call to WINDOW
C           14/02/2000 added call to SIMVER
C           29/09/2000 added PKURVE
C           30/03/2001 revised
C           07/06/2003 revised
C           30/07/2005 increased DVER to *30 and included in call to ADVISE
C           24/01/2007 added FULL_PATH and SIM256 
C           02/08/2007 renamed w_makdat.err to w_makdat.txt
C           22/03/2008 edited for version 6
C           15/08/2015 extensive editing including initialising NPTS = 20 and adding
C                      code to check limits for simulating differential equations
C                      Also added N1_SAV and X1_SAV to insulate X for the 1 variable 
C                      case from data simulated for 2 and 3 variables  
C           05/04/2022 added E_NUMBERS and E_FORMATS, etc.  
C
      IMPLICIT   NONE
      INTEGER    NOUT
      PARAMETER (NOUT = 4)
      INTEGER    NZMOD
      PARAMETER (NZMOD = 24)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N20
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N20 = 20)
      INTEGER    I, ISEND, NDEC, NFIX
      DOUBLE PRECISION XVER, YVER
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  FULL_PATH*1024, SIM256*1024
      CHARACTER  PNAME*6
      PARAMETER (PNAME = 'MAKDAT')
      CHARACTER  MODNAM(NZMOD)*80
      CHARACTER  DVER*30, PVER*15, TITLE*80
      PARAMETER (PVER = 'w_makdat.exe')
      LOGICAL    ABORT, ACTION, ALLPAR, SHOW, SUPPLY, TPLOTS
      LOGICAL    FIRST, LOOP1, LOOP2
C
C Externals
C
      EXTERNAL PUTADV, PKURVE
      EXTERNAL ADVISE, SETSUP, DECIDE, TIMEIN, XYGRID, QMODEL,
     +         OUTDAT, INDATA, XYZVAL
      EXTERNAL DLLCHK, WINDOW, SIMVER, SIM256

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND, 
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

      FIRST = .TRUE.
      CALL ADVISE (DVER,
     +             ABORT, FIRST)
      IF (ABORT) THEN
C
C Quit ... Exit
C
         LOOP1 = .FALSE.
      ELSE
C
C Proceed to enter main loop
C
         LOOP1 = .TRUE.
C
C Open scratch file for PUTIFA messages .. closed/re-opened by OUTDAT
C
         OPEN (UNIT = NOUT, STATUS = 'SCRATCH')
         CALL SETSUP (ENEG, EPOS, EPSI, RTOL, XTOL, ZTOL)
         DTOL = 1.0D-03
         IRELAB = N0
         METH = N2
         MITER = N1
         NPAR = N1
         NPTS = N20
         N1_SAV = NPTS
C
C Initialise EQUAL, etc. and P1
C
         DO I = N1, NP
            EQUAL(I) = .FALSE.
            ERROR(I) = ONE
            FVAL(I) = ONE
            XVAL(I) = ONE
            YVAL(I) = ONE
            ZVAL(I) = ONE
            XTEMP(I) = ONE
            X1_SAV(I) = ONE
         ENDDO
         DO I = N1, KPAR
            P1(I) = ONE
         ENDDO
         DO I = N1, NX
            A(I) = ONE
            B(I) = ONE
            FACT(I) = ONE
            X(I) = ONE
         ENDDO
C
C open error unit for DVODE
C                              
         FULL_PATH = SIM256('w_makdat.txt')
         OPEN (UNIT = N6, FILE = FULL_PATH)
         WRITE (N6,'(A)')
     +   'SIMFIT: Program MAKDAT ... error messages from DVODE'
      ENDIF
C
C LOOP 1: Main cycle point to choose a new model
C =======
C
      DO WHILE (LOOP1)
C
C Decide next course of action
C
         CALL DECIDE (MODEL, NFIX, NMOD, NPAR, NVAR, NX,
     +                B, EPSI, FACT, X,
     +                MODNAM,
     +                ABORT, CONST, DEQN, SUPPLY, TPLOTS)
         IF (ABORT) THEN
C
C Quit ... Exit
C
            LOOP1 = .FALSE.
            LOOP2 = .FALSE.
         ELSE
            IF (TPLOTS) THEN
C
C Parameteric curves so no need to enter second loop
C
               CALL PKURVE (KPAR,
     +                      P1)
               LOOP2 = .FALSE.
            ELSE
C
C Enter second loop
C
               LOOP2 = .TRUE.
            ENDIF
            IF (FIRST .AND. DEQN) THEN
C
C Remind user that x >= 0 for differential equations
C
               FIRST = .FALSE.
               CALL PUTADV (
     +        'With differential equations ALL x must be >= 0')
            ENDIF
         ENDIF
C
C LOOP 2: Intermediate cycle point to choose parameters and plots, etc.
C =======
C
         DO WHILE (LOOP2)
            ABORT = .FALSE.
            IF (NVAR.EQ.N1) THEN
C
C New x-coordinates ... 1 variable (saving/restoring using N1_SAV and X1_SAV)
C
               NPTS = N1_SAV
               DO I = 1, NPTS
                  XVAL(I) = X1_SAV(I)
               ENDDO   
               CALL TIMEIN (NP, NPTS, NPAR, NZEROS,
     +                      EPSI, RTOL, X, XTEMP, XVAL,
     +                      ABORT, EQUAL)
               N1_SAV = NPTS
               DO I = 1, NPTS
                  X1_SAV(I) = XVAL(I)
               ENDDO   
            ELSEIF (NVAR.EQ.N2) THEN
C
C New x,y-coordinates ... 2 variables
C
               CALL XYGRID (NP, NPTS,
     +                      RTOL, XVAL, YVAL,
     +                      EQUAL)
            ELSEIF (NVAR.EQ.N3) THEN
C
C New x,y,z-coordinates ... 3 variables
C
               CALL XYZVAL (NP, NPTS,
     +                      RTOL, XVAL, YVAL, ZVAL,
     +                      EQUAL)
            ENDIF
C
C Evaluate the model
C
            IF (.NOT.ABORT) CALL QMODEL (NPAR,
     +                                   X)
C
C Output the results
C
            CALL OUTDAT (NDEC, NFIX, NOUT, NPAR, NPTS, NVAR,
     +                   THEORY, X, XVAL, YVAL, ZVAL,
     +                   MODNAM,
     +                   ABORT)
            IF (NDEC.EQ.N4) THEN
C
C New coordinates
C
               LOOP2 = .TRUE.
            ELSEIF (NDEC.EQ.N5) THEN
C
C New parameters
C
               ALLPAR = .FALSE.
               CALL INDATA (NFIX, NPAR, NX,
     +                      FACT, X, EPSI,
     +                      MODNAM,
     +                      ALLPAR)
               LOOP2 = .TRUE.
            ELSEIF (NDEC.EQ.N6) THEN
C
C New model
C
               LOOP2 = .FALSE.
            ELSEIF (NDEC.EQ.7) THEN
C
C Quit ... Exit
C
               LOOP1 = .FALSE.
               LOOP2 = .FALSE.
            ENDIF
         ENDDO
C
C Close UNIT  = 6 then end the program
C
         CLOSE (UNIT = N6)
      ENDDO

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C

      END
C
C
