C
C
C INCLUDE FILE FOR MAKDAT
C =======================
C ADVISE
C BOTTOP
C DECIDE
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER  (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,              INTENT (IN)  :: FIRST
      LOGICAL,              INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_MAKDAT
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help            ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_MAKDAT ('makdat')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `MAKDAT'
     +/'        `      '
     +/'Action  `Generate f(x), g(x,y), h(x,y,z) data for plotting or'
     +/'        `curve fitting using user-supplied or library models.'
     +/'        `Program ADDERR is then used to simulate errors.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE BOTTOP (ISEND, NPAR, 
     +                   BOT, RTOL, TOP, X,
     +                   ABORT)
      USE MODULE_MAKDAT, ONLY : DEQN
C
C ACTION : Choose/calculate lowest and highest X-values
C          Subroutine required by program MAKDAT
C          Calls subroutine ZSOLVE
C          ISEND = 1 enter with intention to input BOT, TOP
C          ISEND = 2 input X1, X2 and calculate BOT, TOP
C AUTHOR : W. G. Bardsley, University of Manchester, U.K. 21/06/1994
C          15/08/2015 edited to improve the interface and checking
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND, NPAR
      DOUBLE PRECISION, INTENT (IN)    :: RTOL, X(NPAR)
      DOUBLE PRECISION, INTENT (INOUT) :: BOT, TOP 
      LOGICAL,          INTENT (OUT)   :: ABORT         
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4)
      DOUBLE PRECISION BOTSAV, TOPSAV
      DOUBLE PRECISION B1, B2, T1, T2, V1, V2
      DOUBLE PRECISION B1TEMP, B2TEMP, T1TEMP, T2TEMP, TEMP
      DOUBLE PRECISION XMIN, ZERO
      PARAMETER (XMIN = 1.0D-06, ZERO = 0.0D+00)
      CHARACTER (LEN = 100) LINE
      CHARACTER (LEN = 13) D13(3), SHOWLJ
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    YES
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   PUTFAT, GETD01, GETDG2, YESNO2, PUTADV
      EXTERNAL   ZSOLVE
      INTRINSIC  ABS, TRIM
      SAVE       B1, B2, T1, T2, V1, V2
      SAVE       BOTSAV, TOPSAV
      DATA       B1, T1, V1 / -100.0D+00, 100.0D+00, 1.0D+00 /
      DATA       B2, T2, V2 / -100.0D+00, 100.0D+00, 10.0D+00 /
      DATA       BOTSAV, TOPSAV / 1.0D+00, 10.0D+00 /
      ABORT = .TRUE.
      IF (ISEND.LT.1 .OR. ISEND.GT.2) THEN
         CALL PUTFAT ('ISEND inconsistent in call to BOTTOP')
         RETURN
      ENDIF
      E_NUMBERS = E_FORMATS()
C
C LABEL 20: cycle point
C =========
C
   20 CONTINUE
      ABORT = .TRUE.
      IF (ISEND.EQ.1) THEN
   40    CONTINUE     
         CALL GETDG2 (BOTSAV, TOPSAV,
     +'Values for X_start, X_stop ... (x > 0 if log-spacing required)')
         IF (DEQN .AND. BOTSAV.LT.ZERO) THEN
            WRITE (LINE,100)
            CALL PUTADV (LINE)
            GOTO 40
         ENDIF   
         BOT = BOTSAV
         TOP = TOPSAV
      ELSE
         CALL GETD01 (V1,
     +'Function value at X = X_start .. (i.e. Y_input = f(X_start))')
  60     CONTINUE     
         CALL GETDG2 (B1, T1,
     +'Approximate values for A (i.e. X_below), B (i.e. X_above)')
         IF (DEQN .AND. B1.LT.ZERO) THEN
            WRITE (LINE,100)
            CALL PUTADV (LINE)
            GOTO 60
         ENDIF  
         B1TEMP = B1
         T1TEMP = T1
         IF (DEQN .AND. B1TEMP.LT.XMIN) THEN
            B1TEMP = B1TEMP + XMIN
            T1TEMP = T1TEMP + XMIN
         ENDIF  
         CALL ZSOLVE (NPAR, X, B1TEMP, T1TEMP, V1,
     +                ABORT)
         IF (ABORT) RETURN
         CALL GETD01 (V2,
     +'Function value at X = X_stop ... (i.e. Y_input = f(X_stop))')
  80     CONTINUE     
         CALL GETDG2 (B2, T2,
     +'Approximate values for A (i.e. X_below), B (i.e. X_above)')
         IF (DEQN .AND. B2.LT.ZERO) THEN
            WRITE (LINE,100)
            CALL PUTADV (LINE)
            GOTO 80
         ENDIF  
         B2TEMP = B2
         T2TEMP = T2
         IF (DEQN .AND. B2TEMP.LT.XMIN) THEN
            B2TEMP = B2TEMP + XMIN
            T2TEMP = T2TEMP + XMIN
         ENDIF
         CALL ZSOLVE (NPAR,
     +                X, B2TEMP, T2TEMP, V2,
     +                ABORT)
         IF (ABORT) RETURN
         BOT = B1TEMP
         TOP = B2TEMP
         BOTSAV = BOT
         TOPSAV = TOP
      ENDIF
      IF (BOT.GE.TOP .OR. (ABS(BOT - TOP)).LE.RTOL) THEN
         ABORT = .TRUE.
         WRITE (LINE,200)
         YES = .TRUE.
         CALL YESNO2 (ICOLOR, IX, IY, 
     +                LINE,
     +                YES)
         IF (YES) GOTO 20
      ELSE
         IF (ABS(BOT).GT.RTOL) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,300) BOT, TOP, TOP/BOT
            ELSE
               D13(1) = SHOWLJ(BOT)
               D13(2) = SHOWLJ(TOP)
               TEMP = TOP/BOT
               D13(3) = SHOWLJ(TEMP)   
               WRITE (LINE, 350) TRIM(D13(1)), TRIM(D13(2)),
     +                           TRIM(D13(3)) 
            ENDIF
            CALL PUTADV (LINE)
         ENDIF
         ABORT = .FALSE.
         RETURN
      ENDIF
C
C Format statements
C      
  100 FORMAT ('X_start must be >= 0 with differential equations')
  200 FORMAT ('FATAL : X_start >= X_stop ... Try again ?')
  300 FORMAT ('X_start =',1P,E13.5,', X_stop =',E13.5,
     +', X_stop/X_start =',E13.5)
  350 FORMAT ('X_start =',1X,A,', X_stop =',1X,A,
     +', X_stop/X_start =',1X,A)   
      END
C
C-------------------------------------------------------------------------
C
      SUBROUTINE DECIDE (MODEL, NFIX, NMOD, NPAR, NVAR, NX,
     +                   B, EPSI, FACT, X,
     +                   MODNAM,
     +                   ABORT, CONST, DEQN, SUPPLY, TPLOTS)
C
C Decide on model
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NX
      INTEGER,             INTENT (INOUT) :: MODEL, NFIX, NMOD, NPAR,
     +                                       NVAR
      DOUBLE PRECISION,    INTENT (IN)    :: EPSI
      DOUBLE PRECISION,    INTENT (INOUT) :: B(NX), FACT(NX), X(NX)
      CHARACTER (LEN = *), INTENT (INOUT) :: MODNAM(*)
      LOGICAL,             INTENT (OUT)   :: ABORT, CONST, DEQN, SUPPLY,
     +                                       TPLOTS
C
C Locals
C
      INTEGER    NDEC      
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 6, IY = 4, LSHADE = 1, NUMOPT = 7,
     +           NSTART = 3, NTEXT = 9)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      CHARACTER (LEN = 100) TEXT(30)
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ALLPAR
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FIRST
      PARAMETER (FIRST = .FALSE.)
      EXTERNAL   LBOX01
      EXTERNAL   QNSUBD, QNSUB1, QNSUB2, QNSUB3
      EXTERNAL   ADVISE, INDATA
      DATA       NUMBLD / 1*1, 8*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise
C      
      NMOD = 1
      ABORT = .FALSE.
      CONST = .FALSE.
      DEQN = .FALSE.
      SUPPLY = .FALSE.
      TPLOTS = .FALSE.
C
C LABEL 20: cycle point
C =========
C
   20 CONTINUE
      WRITE (TEXT,100)
      NDEC = 1
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NMOD = 1
      ABORT = .FALSE.
      DEQN = .FALSE.
      SUPPLY = .FALSE.
      TPLOTS = .FALSE.
      IF (NDEC.EQ.1) THEN
         NVAR = 1
      ELSEIF (NDEC.EQ.2) THEN
         NVAR = 2
      ELSEIF (NDEC.EQ.3) THEN
         NVAR = 3
      ELSEIF (NDEC.EQ.4) THEN
         DEQN = .TRUE.
         NVAR = 1
      ELSEIF (NDEC.EQ.5) THEN
         TPLOTS = .TRUE.
         RETURN
      ELSEIF (NDEC.EQ.6) THEN
         CALL ADVISE (BLANK,
     +                ABORT, FIRST)
         GOTO 20
      ELSE
         ABORT = .TRUE.
         RETURN
      ENDIF
      IF (DEQN) THEN
         CALL QNSUBD (MODEL, NFIX, NMOD, NPAR, NX,
     +                B,
     +                MODNAM,
     +                CONST)
      ELSEIF (NVAR.EQ.1) THEN
         CALL QNSUB1 (MODEL, NFIX, NMOD, NPAR, NX,
     +                B,
     +                MODNAM, 
     +                CONST, DEQN)
      ELSEIF (NVAR.EQ.2) THEN
         CALL QNSUB2 (MODEL, NFIX, NMOD, NPAR, NX,
     +                B,
     +                MODNAM,
     +                CONST)
      ELSEIF (NVAR.EQ.3) THEN
         CALL QNSUB3 (MODEL, NFIX, NMOD, NPAR, NX,
     +                B,
     +                MODNAM,
     +                CONST)
      ENDIF
      IF (MODEL.LT.1) GOTO 20
      ALLPAR = .FALSE.
      CALL INDATA (NFIX, NPAR, NX,
     +             FACT, X, EPSI, 
     +             MODNAM,
     +             ALLPAR)
C
C Format statement
C
  100 FORMAT (
     + 'Choose the model type'
     +/
     +/'Function of 1 variable'
     +/'Function of 2 variables'
     +/'Function of 3 variables'
     +/'A differential equation'
     +/'Parametric equations'
     +/'Help'
     +/'Quit ... Exit program MAKDAT')
      END
C
C
