C
C INCLUDE FILE FOR MAKDAT
C =======================
C INDATA
C OUTDAT
C
      SUBROUTINE INDATA (NFIX, NPAR, NX, 
     +                   FACT, X, EPSI,
     +                   MODNAM,
     +                   ALLPAR)
C
C Assign values to parameters in model and set FACTORS = 1.0
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NFIX, NPAR, NX
      DOUBLE PRECISION,    INTENT (IN)    :: EPSI
      DOUBLE PRECISION,    INTENT (INOUT) :: FACT(NX), X(NX)
      CHARACTER (LEN = *), INTENT (IN)    :: MODNAM(*)
      LOGICAL,             INTENT (IN)    :: ALLPAR
C
C Locals
C      
      INTEGER    ISEND, ITYPE, NCOLS, NIN, NRMAX, NROWS
      PARAMETER (ISEND = 2, ITYPE = 1, NIN = 3, NCOLS = 1)
      INTEGER    I, J, NDEC, NPTS, NZERO
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NUMTXT, NSTART, NTEXT
      PARAMETER  (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 6)
      INTEGER    NTEMP
      PARAMETER (NTEMP = 100)
      INTEGER    ICOUNT, IOS, NCHAR
      INTEGER    COLOUR
      INTEGER    NUMBLD(20), NUMPOS(NUMOPT)
      DOUBLE PRECISION TEMP, XTEMP(NTEMP)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION PFIX
      CHARACTER  LINE*100, TEXT(30)*100, TEXT1(30)*100, WORD20*20
      CHARACTER (LEN = 13) D13, SHOWRJ
      CHARACTER  FNAME*1024, TITLE*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .TRUE.,
     +           LABEL = .TRUE., ORDER = .FALSE., WEIGHT = .FALSE.)
      LOGICAL    ABORT, FIXNPT, REPEET
      PARAMETER (FIXNPT = .FALSE.)
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PUTFAT, TABLE1, LBOX01, REJECT, GETD01, EDITOR, VEC1IN,
     +           PUTADV
      EXTERNAL   LINEIN
      INTRINSIC  ABS, MIN
      SAVE       PFIX
      DATA       PFIX / ONE /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       NUMBLD / 20*0 /
      E_NUMBERS = E_FORMATS()
C
C Check NX then initialise TEXT
C
      IF (NX.GT.NTEMP) CALL PUTFAT ('NX > NTEMP in call to INDATA')
      DO I = 1, 30
         TEXT(I) = BLANK
         TEXT1(I) = BLANK
      ENDDO
      LINE = BLANK
      WORD20 = BLANK
C
C Declare details of the model in a permanent window
C
      WRITE (TEXT,100) (MODNAM(J), J = 1, 4)
      NUMTXT = 7
      TEXT(NUMTXT) = BLANK
      NUMTXT = NUMTXT + 1
      WRITE (TEXT(NUMTXT),200) NPAR
      NUMTXT = NUMTXT + 1
      TEXT(NUMTXT) = BLANK
      IF (NFIX.EQ.1) THEN
         NUMTXT = NUMTXT + 1
         WRITE (TEXT(NUMTXT),300) NPAR + 1
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = BLANK
      ENDIF
C
C Set all the parameters if ALLPAR = .TRUE.
C
      IF (ALLPAR) THEN
         NCHAR = 20
         NUMTXT = NUMTXT + 1
         DO I = 1, NPAR
            ICOUNT = 0
   20       CONTINUE
            IF (ICOUNT.GT.0) CALL REJECT
            WRITE (TEXT(NUMTXT),400) I
            WORD20 = BLANK
            CALL LINEIN (ICOLOR, IXL, IYL, NCHAR, NUMBLD, NUMTXT,
     +                   WORD20, TEXT,
     +                   BORDER)
            ICOUNT = ICOUNT + 1
            READ (WORD20,*,END=20,ERR=20,IOSTAT=IOS) TEMP
            IF (IOS.NE.0) GOTO 20
            X(I) = TEMP
            FACT(I) = ONE
         ENDDO
         NUMTXT = NUMTXT - 1
      ENDIF
C
C Main branch point for control of subroutine functions
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (TEXT1,500)
         DO I = 1, NUMOPT
            TEXT(NUMTXT + I) = TEXT1(I)
         ENDDO
         NDEC = 4
         NTEXT = NUMTXT + NUMOPT
         NSTART = NUMTXT + 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NDEC.EQ.1) THEN
C
C Set all parameters = C
C
            CALL GETD01 (PFIX,
     +                  'Value of C required to set all p(i) = C')
            DO I = 1, NPAR
               X(I) = PFIX
               FACT(I) = ONE
            ENDDO
         ELSEIF (NDEC.EQ.2) THEN
C
C Set individual parameter values
C
            NCHAR = 20
            NUMTXT = NUMTXT + 1
            DO I = 1, NPAR
               ICOUNT = 0
   40          CONTINUE
               IF (ICOUNT.GT.0) CALL REJECT
               WRITE (TEXT(NUMTXT),400) I
               WORD20 = BLANK
               CALL LINEIN (ICOLOR, IXL, IYL, NCHAR, NUMBLD, NUMTXT,
     +                      WORD20, TEXT,
     +                      BORDER)
               ICOUNT = ICOUNT + 1
               READ (WORD20,*,END=40,ERR=40,IOSTAT=IOS) TEMP
               IF (IOS.NE.0) GOTO 40
               X(I) = TEMP
               FACT(I) = ONE
            ENDDO
            NUMTXT = NUMTXT - 1
         ELSEIF (NDEC.EQ.3) THEN
C
C Edit
C
            NRMAX = NPAR
            NROWS = NPAR
            LINE = 'Model parameters'
            CALL EDITOR (ISEND, ITYPE, NCOLS, NRMAX, NROWS, X,
     +                   LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
         ELSEIF (NDEC.EQ.4) THEN
C
C Display current parameteres
C
            WRITE (LINE,600)
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = 4
            CALL TABLE1 (COLOUR, LINE)
            COLOUR = 0
            DO I = 1, NPAR
               IF (E_NUMBERS) THEN
                  WRITE (LINE,700) I, X(I)
               ELSE
                  D13 = SHOWRJ(X(I))
                  WRITE (LINE,750) I, D13
               ENDIF      
               CALL TABLE1 (COLOUR, LINE)
            ENDDO
            IF (NFIX.EQ.1) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,700) NPAR + 1, ZERO
               ELSE
                  D13 = SHOWRJ(ZERO) 
                  WRITE (LINE,750) NPAR + 1, D13 
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
            CALL TABLE1 (COLOUR, 'CLOSE')
         ELSEIF (NDEC.EQ.5) THEN
            NPTS = 0
            CALL PUTADV (
     +     'Now supply a parameter vector file (like vector.tf1)')
            CLOSE (UNIT = NIN)
            CALL VEC1IN (ISEND, NIN, NTEMP, NPTS,
     +                   XTEMP,
     +                   FNAME, TITLE,
     +                   ABORT, FIXNPT, LABEL)
            CLOSE (UNIT = NIN)
            IF (.NOT.ABORT .AND. NPTS.GT.0) THEN
               IF (NPTS.LT.NPAR) THEN
                  CALL PUTADV (
     +'Not enough parameters supplied ... the subset will be used')
               ELSEIF (NPTS.GT.NPAR) THEN
                  CALL PUTADV (
     +'Too many parameters supplied ... a subset will be used')
               ELSE
                  CALL PUTADV (
     +'Model parameters are now set to parameters in file supplied')
               ENDIF
               DO I = 1, MIN(NPAR, NPTS)
                  X(I) = XTEMP(I)
                  FACT(I) = ONE
               ENDDO
            ELSE
               CALL PUTADV ('Model parameters unchanged')
            ENDIF
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Check then close down window with model details
C
      NZERO = 0
      DO I = 1, NPAR
         IF (ABS(X(I) - ZERO).LE.EPSI) NZERO = NZERO + 1
      ENDDO
      IF (NZERO.EQ.NPAR) CALL PUTADV ('All parameters = 0, Try again ?')
C
C Format statements
C        
  100 FORMAT ('Details of the model parameters'//A/A/A/A)
  200 FORMAT ('Model has',I3,1X,'parameters p(i)')
  300 FORMAT ('Constant set to 0: i.e. p(',I2,') = 0 ')
  400 FORMAT ('INPUT : The value required for p(',I2,')')
  500 FORMAT (
     + 'Set parameters to a fixed C'
     +/'Set parameters individually'
     +/'Edit current parameters'
     +/'View current parameters'
     +/'Input a parameter file'
     +/'Apply')
  600 FORMAT (1X,'Parameter   Current Value')
  700 FORMAT (2X,I2,9X,1P,E13.5)
  750 FORMAT (2X,I2,9X,A13)
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE OUTDAT (NDEC, NFIX, NOUT, NPAR, NPTS, NVAR, 
     +                   THEORY, X, XVAL, YVAL, ZVAL, 
     +                   MODNAM,
     +                   ABORT)
C
C ACTION : Output of calculated data to screen or file
C          Subroutine required by program MAKDAT
C VERSION: DUMMY is not used but ERRMIN is set as a parameter
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          25/04/1991 added GRFGK1 
C          22/05/1991 GKS001
C          13/04/1993 GKS004 and removed COMMON
C          07/09/1995 Added calls to TABLE1 and SURD2S$
C          15/02/1998 minor changes
C          30/08/2000 replaced GKS004 by GKST04
C          14/08/2015 added calls to GKS001 or GKST04 
C
      IMPLICIT   NONE
C
C Arguments
C   
      INTEGER,             INTENT (IN)    :: NFIX, NOUT, NPAR, NPTS,
     +                                       NVAR   
      INTEGER,             INTENT (OUT)   :: NDEC
      DOUBLE PRECISION,    INTENT (IN)    :: THEORY(NPTS), X(NPAR),
     +                                       XVAL(NPTS), YVAL(NPTS),
     +                                       ZVAL(NPTS)      
      CHARACTER (LEN = *), INTENT (IN)    :: MODNAM(*)
      LOGICAL,             INTENT (INOUT) :: ABORT
C
C Special data for surface plotting: NMAX must agree with SURD2S$
C
      INTEGER    JSEND, JSEND4, NMAX, NXX, NYY
      PARAMETER (JSEND4 = 4, NMAX = 100)
      DOUBLE PRECISION XXMAX, XXMIN
      DOUBLE PRECISION YYMAX, YYMIN
      DOUBLE PRECISION ZZ(NMAX, NMAX)
      DOUBLE PRECISION VECTOR (NMAX*NMAX + 6)
C
C Usual data
C
      INTEGER    NBIG, N0
      PARAMETER (NBIG = 50, N0 = 0)
      INTEGER    I, ICOUNT, ISEND, J, K, L, M
      INTEGER    ICOLOR, IXL, IYL
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4)
      INTEGER    NUMSTA, NUMOPT, NUMTXT
      PARAMETER (NUMSTA = 7, NUMOPT = 9, NUMTXT = NUMSTA + NUMOPT - 1)
      INTEGER    NUMBLD(100)
      DOUBLE PRECISION ZERO, ONE, ERRMIN, PCENT, CENT
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, ERRMIN = 1.0D-20,
     +           PCENT = 5.0D+00, CENT = 100.0D+00)
      DOUBLE PRECISION ABSZI, ERRFAC, ERRZ
      DOUBLE PRECISION ASYMP
      CHARACTER  PTITLE*16, XTITLE*1, YTITLE*1
      CHARACTER  FNAME*1024, SYMBOL*4, TEXT72*72
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER (LEN = 13) D13(5), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12) WORD12(3), FORM12 
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    UNUSED(NMAX,NMAX)
      LOGICAL    AXES, SAVEIT
      PARAMETER (AXES = .TRUE., SAVEIT = .TRUE.)
      LOGICAL    YES
      LOGICAL    FIRST, LTEMP
      PARAMETER (FIRST = .FALSE.)
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   PUTFAT, OFILES, GETTXT, GETIM1, PUTADV, GKST04, FNAMES,
     +           TABLE1, LSTBOX, YESNO2, FORM12, GKS001
      EXTERNAL   ADVISE
      EXTERNAL   SURD2S
      INTRINSIC  ABS, DBLE
      DATA       NUMBLD / 100*0 /
      E_NUMBERS = E_FORMATS()
C
C In this version set JSEND = JSEND4 = 4
C      
      NDEC = 0
      JSEND = JSEND4
   20 CONTINUE
      IF (ABORT) THEN
         NDEC = 4
         SYMBOL = '(NA)'
      ELSE
         IF (NVAR.EQ.1) THEN
            NDEC = 2
         ELSE
            NDEC = 1
         ENDIF
         SYMBOL = ' '
      ENDIF
      WORD12(1) = FORM12(NVAR)
      WORD12(2) = FORM12(NPAR)
      WORD12(3) = FORM12(NPTS)
      WRITE (TEXT,100) (WORD12(I), I = 1, 3), SYMBOL, SYMBOL, SYMBOL, 
     +                                        SYMBOL 
      NUMBLD(1) = 1
      CALL LSTBOX (NUMBLD, NDEC, NUMOPT, NUMSTA, NUMTXT,
     +             TEXT) 
      NUMBLD(1) = 0    
      IF (ABORT .AND. NDEC.LE.3) THEN
         CALL PUTFAT ('Not available .. Calculate values')
         GOTO 20
      ENDIF
      IF (NDEC.EQ.1) THEN
         IF (NPTS.GT.200) THEN
            I = 1
            K = NPTS
            CALL GETIM1 (I, L, K,
     + 'Number of the line to start displaying in the table')
            M = NPTS
         ELSE
            L = 1
            M = NPTS
         ENDIF
         K = 15
         CALL TABLE1 (K, 'OPEN')
         IF (NVAR.EQ.1) THEN
            WRITE (LINE,200)
         ELSEIF (NVAR.EQ.2) THEN
            WRITE (LINE,300)
         ELSE
            WRITE (LINE,350)
         ENDIF
         K = 4
         CALL TABLE1 (K, LINE)
         K = 0
         DO I = L, M
            IF (NVAR.EQ.1) THEN
               IF (E_NUMBERS) THEN 
                  WRITE (LINE,400) I, XVAL(I), THEORY(I)
               ELSE
                  D13(1) = SHOWRJ(XVAL(I))
                  D13(2) = SHOWRJ(THEORY(I))
                  WRITE (LINE,450) I, D13(1), D13(2)
               ENDIF  
            ELSEIF (NVAR.EQ.2) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,500) I, XVAL(I), YVAL(I), THEORY(I)
               ELSE
                  D13(1) = SHOWRJ(XVAL(I))
                  D13(2) = SHOWRJ(YVAL(I))
                  D13(3) = SHOWRJ(THEORY(I))
                  WRITE (LINE,525) I, D13(1), D13(2), D13(3)
               ENDIF   
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,550) I, XVAL(I), YVAL(I), ZVAL(I), 
     +                             THEORY(I)
               ELSE
                  D13(1) = SHOWRJ(XVAL(I))
                  D13(2) = SHOWRJ(YVAL(I))
                  D13(3) = SHOWRJ(ZVAL(I))
                  D13(4) = SHOWRJ(THEORY(I))
                  WRITE (LINE,575) I, D13(1), D13(2), D13(3), D13(4)
               ENDIF   
            ENDIF
            CALL TABLE1 (K, LINE)
         ENDDO
         CALL TABLE1 (K, 'CLOSE')
         GOTO 20
      ELSEIF (NDEC.EQ.2 .OR. NDEC.EQ.3) THEN
         IF (NVAR.EQ.1) THEN
            I = 0
            L = 0
            IF (NPTS.LE.20) THEN
               M = 5
            ELSEIF (NPTS.LE.40) THEN
               M = 8
            ELSEIF (NPTS.LE.80) THEN
               M = 4
            ELSE
               M = 1
            ENDIF
            PTITLE = 'Current x,y Data'
            XTITLE = 'x'
            YTITLE = 'y'
            IF (NDEC.EQ.2) THEN
               CALL GKS001 (L, M, NPTS,
     +                      XVAL, THEORY,  
     +                      PTITLE, XTITLE, YTITLE)              
            ELSE  
               ASYMP = - ONE
               CALL GKST04 (L, I, I, I,
     +                      M, I, I, I,
     +                      NPTS, NPTS, NPTS, NPTS,
     +                      ASYMP,
     +                      XVAL, XVAL, XVAL, XVAL,
     +                      THEORY, THEORY, THEORY, THEORY,
     +                      PTITLE, XTITLE, YTITLE, 
     +                      AXES, SAVEIT)
            ENDIF
         ELSEIF (NVAR.EQ.2) THEN
C
C This code will only work if the data has no replicates and
C is in order of X increasing for successive increasing fixed Y
C at all equal intervals for X and also for Y
C
C
C First of all calculate NXX, NYY, XXMAX, XXMIN, YYMAX, YYMIN
C
            XXMAX = XVAL(1)
            XXMIN = XVAL(1)
            DO I = 2, NPTS
               IF (XVAL(I).GT.XXMAX) XXMAX = XVAL(I)
               IF (XVAL(I).LT.XXMIN) XXMIN = XVAL(I)
            ENDDO
            NYY = 1
            YYMAX = YVAL(1)
            YYMIN = YVAL(1)
            DO I = 2, NPTS
               IF (YVAL(I).GT.YVAL(I - 1)) NYY = NYY + 1
               IF (YVAL(I).GT.YYMAX) YYMAX = YVAL(I)
               IF (YVAL(I).LT.YYMIN) YYMIN = YVAL(I)
            ENDDO
            NXX = NPTS/NYY
            IF (JSEND.EQ.3) THEN
C
C Now fill in VECTOR if JSEND = 3
C
               VECTOR(1) = DBLE(NXX)
               VECTOR(2) = DBLE(NYY)
               VECTOR(3) = XXMIN
               VECTOR(4) = XXMAX
               VECTOR(5) = YYMIN
               VECTOR(6) = YYMAX
               L = 6
               DO I = 1, NPTS
                  L = L + 1
                  VECTOR(L) = THEORY(I)
               ENDDO
            ELSEIF (JSEND.EQ.4) THEN
C
C Otherwise fill in ZZ if JSEND = 4
C
               L = 0
               DO J = 1, NYY
                  DO I = 1, NXX
                     L = L + 1
                     ZZ(I,J) = THEORY(L)
                  ENDDO
               ENDDO
            ENDIF
            CALL SURD2S (JSEND, NMAX, NXX, NYY,
     +                   VECTOR, XXMAX, XXMIN, YYMAX, YYMIN, ZZ,
     +                   UNUSED)
         ELSE
            CALL PUTFAT ('Not available for h(x,y,z)')
            GOTO 20
         ENDIF
         GOTO 20
      ELSEIF (NDEC.EQ.4) THEN
C
C Close existing scratch file
C
         CLOSE (UNIT = NOUT)
         ISEND = 1
         CALL OFILES (ISEND, NOUT, FNAME, ABORT)
         IF (ABORT) GOTO 20
         CALL GETTXT ('Title for this data set', TEXT72)
         WRITE (NOUT,600) TEXT72
         WRITE (NOUT,700) NPTS, NVAR + 2
         ERRFAC = PCENT/CENT
         DO I = 1, NPTS
            ABSZI = ERRFAC*ABS(THEORY(I))
            IF (ABSZI.GT.ERRMIN) THEN
               ERRZ = ABSZI
            ELSE
               ERRZ = ONE
            ENDIF
            IF (NVAR.EQ.1) THEN
               IF (E_NUMBERS) THEN
                  WRITE (NOUT,800) XVAL(I), THEORY(I), ERRZ
               ELSE
                  D13(1) = SHOWRJ(XVAL(I))
                  D13(2) = SHOWRJ(THEORY(I))
                  D13(3) = SHOWRJ(ERRZ) 
                  WRITE (NOUT,850) D13(1), D13(2), D13(3)
               ENDIF  
            ELSEIF (NVAR.EQ.2) THEN
               IF (E_NUMBERS) THEN
                  WRITE (NOUT,900) XVAL(I), YVAL(I), THEORY(I), ERRZ
               ELSE
                  D13(1) = SHOWRJ(XVAL(I))
                  D13(2) = SHOWRJ(YVAL(I))
                  D13(3) = SHOWRJ(THEORY(I))
                  D13(4) = SHOWRJ(ERRZ) 
                  WRITE (NOUT,925) D13(1), D13(2), D13(3), D13(4)
               ENDIF   
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (NOUT,950) XVAL(I), YVAL(I), ZVAL(I), THEORY(I),
     +                             ERRZ
               ELSE
                  D13(1) = SHOWRJ(XVAL(I))
                  D13(2) = SHOWRJ(YVAL(I))
                  D13(3) = SHOWRJ(ZVAL(I))
                  D13(4) = SHOWRJ(THEORY(I))
                  D13(5) = SHOWRJ(ERRZ) 
                  WRITE (NOUT,975) D13(1), D13(2), D13(3), D13(4),
     +                             D13(5)
               ENDIF 
            ENDIF
         ENDDO
         ICOUNT = 0
         WRITE (LINE,1000)
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IXL, IYL, LINE, YES)
         IF (YES) THEN
            CALL GETIM1 (N0, ICOUNT, NBIG, 'No. extra lines required')
         ENDIF
         WRITE (NOUT,1100) ICOUNT + NFIX + NPAR + 5
         WRITE (NOUT,1200)
         WRITE (NOUT, 600) (MODNAM(I), I = 1, 4)
         IF (E_NUMBERS) THEN
            WRITE (NOUT,1300) (I, X(I), I = 1, NPAR)
         ELSE
            DO I = 1, NPAR
               D13(1) = SHOWLJ(X(I))
               WRITE (NOUT,1350) I, D13(1)  
            ENDDO 
         ENDIF  
         IF (NFIX.EQ.1) WRITE (NOUT,1300) NPAR + 1, ZERO
         IF (ICOUNT.GT.0) THEN
            DO I = 1, ICOUNT
               CALL GETTXT ('Next line', TEXT72)
               WRITE (NOUT,600) TEXT72
            ENDDO
         ENDIF
C
C Close data file then open scratch file
C
         CLOSE (UNIT = NOUT)
         OPEN (UNIT = NOUT, STATUS = 'SCRATCH')
         ISEND = 2
         CALL FNAMES (ISEND, FNAME)
         WRITE (LINE,1400) PCENT
         CALL PUTADV (LINE)
         GOTO 20
      ELSEIF (NDEC.LT.NUMOPT - 1) THEN
         NDEC = NDEC - 1
         RETURN   
      ELSEIF (NDEC.EQ.NUMOPT - 1) THEN
         CALL ADVISE (BLANK,
     +                LTEMP, FIRST)
         GOTO 20
      ELSEIF (NDEC.EQ.NUMOPT) THEN
         NDEC = 7
         RETURN
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'MAKDAT display/plot/save/re-configure options' 
     +/
     +/'Number of variables =',1X,A
     +/'Number of parameters =',1X,A
     +/'Number of points =',1X,A
     +/
     +/'Current data: display a table',1X,A
     +/'Current data: plot a graph',1X,A
     +/'Current data: plot transforms',1X,A
     +/'Current data: make a curve-fit file',1X,A
     +/'New data: same model, change x-values'
     +/'New data: same model, new parameters'
     +/'New data: new  model, new parameters'
     +/'Help'
     +/'Quit ... Exit program MAKDAT')
  200 FORMAT (1X,'Number',13X,'x',11X,'f(x)')
  300 FORMAT (1X,'Number',13X,'x',14X,'y',9X,'f(x,y)')
  350 FORMAT (1X,'Number',13X,'x',14X,'y',14X,'z',8X,'f(x,y,z)')
  400 FORMAT (1X,I4,3X,1P,E13.5,2X,E13.5)
  450 FORMAT (1X,I4,3X,A13,2X,A13)
  500 FORMAT (1X,I4,3X,1P,E13.5,2X,E13.5,2X,E13.5)
  525 FORMAT (1X,I4,3X,A13,2X,A13,2X,A13)  
  550 FORMAT (1X,I4,3X,1P,E13.5,2X,E13.5,2X,E13.5,2X,E13.5)  
  575 FORMAT (1X,I4,3X,A13,2X,A13,2X,A13,2X,A13)
  600 FORMAT (A)
  700 FORMAT (2I6)
  800 FORMAT (1P,3E13.5)
  850 FORMAT (3(1X,A13))  
  900 FORMAT (1P,4E13.5)
  925 FORMAT (4(1X,A13))  
  950 FORMAT (1P,5E13.5)
  975 FORMAT (5(1X,A13))  
 1000 FORMAT ('Add any further details to the file ?')
 1100 FORMAT (I6)
 1200 FORMAT ('Data from program MAKDAT using the model:')
 1300 FORMAT (1X,'p(',I2,') =',1P,E13.5)
 1350 FORMAT (1X,'p(',I2,') =',1X,A) 
 1400 FORMAT (
     +'s values have been set to',F4.1,'% of the absolute y-values')
      END
C
C
