C
C INCLUDE FILE FOR MAKDAT
C =======================
C SETSUP
C TIMEIN
C
C
      SUBROUTINE SETSUP (ENEG, EPOS, EPSI, RTOL, XTOL, ZTOL)
C
C Machine constants and tolerances
C
      IMPLICIT  NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (OUT) :: ENEG, EPOS, EPSI, RTOL, XTOL,
     +                                  ZTOL
C
C Locals
C      
      DOUBLE PRECISION X02AJF$, X02AMF$
      EXTERNAL  X02AMF$, X02AJF$
      INTRINSIC LOG
      RTOL = 1.0D+12*X02AMF$()
      ENEG = 0.25D+00*LOG(RTOL)
      EPOS = - ENEG/2.0D+00
      EPSI = 10.0D+00*X02AJF$()
      ZTOL = 1.0D+00/RTOL
      XTOL = - ZTOL
      END
C
C----------------------------------------------------------------------------
C
      SUBROUTINE TIMEIN (NP, NPTS, NPAR, NZ,
     +                   EPSI, RTOL, X, XTEMP, XVAL,
     +                   ABORT, EQUAL)
C
C ACTION : Choose/calculate values for the independent variable
C          Subroutine required by program MAKDAT
C          Calls subroutine BOTTOP
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          08/06/2003 extensive revision
C          12/08/2015 another major revision, mainly cosmetic
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NP, NPAR 
      INTEGER,          INTENT (INOUT) :: NPTS, NZ
      DOUBLE PRECISION, INTENT (INOUT) :: X(NPAR), XTEMP(NP), XVAL(NP)
      DOUBLE PRECISION, INTENT (IN)    :: EPSI, RTOL      
      LOGICAL,          INTENT (INOUT) :: EQUAL(NP)
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    I, JSEND, JTYPE, NCOLS, NDEC, NIN, NMAX, NOPT, NPTSAV,
     +           NPTVAL, NUMDEC
      PARAMETER (JTYPE = 1, NCOLS = 1)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 2)
      INTEGER    NUMBLD(30), NUMPOS(5)
      DOUBLE PRECISION STEP, TE, TEMP1, TEMP2, TS
      DOUBLE PRECISION XSTART, XSTOP
      DOUBLE PRECISION ZERO, HALF, ONE, TEN
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00, 
     +           TEN = 10.0D+00)
      CHARACTER (LEN = 1024) FNAME
      CHARACTER (LEN = 100 ) LINE, TEXT(30)
      CHARACTER (LEN = 80  ) TITLE
      CHARACTER (LEN = 20  ) METHOD
      CHARACTER (LEN = 13  ) D13(2), SHOWLJ
      CHARACTER (LEN = 12  ) WORD12, FORM12
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    OK, FIRST, REPEET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    CURVE, FIXCOL, FIXNPT, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXNPT = .FALSE.,
     +           FIXROW = .FALSE., LABEL = .TRUE., ORDER = .FALSE.,
     +           WEIGHT = .FALSE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   GETJM1, PUTFAT, PUTWAR, DIVIDE, LBOX01, EDITOR,
     +           VEC1IN, GETNOU, PUTADV, FORM12, PATCH2
      EXTERNAL   BOTTOP
      INTRINSIC  LOG, ABS, EXP, DBLE
      SAVE       FIRST
      SAVE       METHOD
      SAVE       NPTSAV, TE, TS
      DATA       NPTSAV, TE, TS / 20, TEN, HALF /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 5*1 /
      DATA       METHOD / 'None' /
      DATA       FIRST / .TRUE. /
      E_NUMBERS = E_FORMATS()
      IF (FIRST) THEN
         FIRST = .FALSE.
C
C Create default linear data first time
C
         METHOD = 'Arithmetic (Linear)' 
         STEP = (TE - TS)/(DBLE(NPTS) - ONE)
         XVAL(1) = TS
         DO I = 2, NPTS - 1
            XVAL(I) = XVAL(I - 1) + STEP
         ENDDO
         XVAL(NPTS) = TE
      ENDIF      
C
C ***Next code required to fool BOTTOP/ZSOLVE/FZMOD/ZMOD
C ***Do not delete the next 5 lines redefining NPTS, ABORT, EQUAL(1), EQUAL(2)
C
      NPTSAV = NPTS
      NPTS = 1
      ABORT = .TRUE.
      EQUAL(1) = .FALSE.
      EQUAL(2) = .FALSE.
C
C ***Above code required to fool BOTTOP/ZSOLVE/FZMOD/ZMOD
C ***Do not delete previous 4 lines redefining NPTS, EQUAL(1), EQUAL(2)
C
      WORD12 = FORM12(NPTSAV)
      NUMDEC = 1
      REPEET = .TRUE.
      DO WHILE (REPEET)
         NUMOPT = 5
         NSTART = 8
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) WORD12, TS, TE, METHOD
         ELSE
            D13(1) = SHOWLJ(TS) 
            D13(2) = SHOWLJ(TE)
            WRITE (TEXT,150) WORD12, D13(1), D13(2), METHOD
         ENDIF  
         NTEXT = NSTART + NUMOPT - 1
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT, 
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0  
         IF (NUMDEC.EQ.NUMOPT - 1) THEN
            WRITE (TEXT,1000)
            NTEXT = 23
            NUMBLD(1) = 1 
            CALL PATCH2 (NUMBLD, NTEXT,
     +                   TEXT)
            NUMBLD(1) = 0             
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO           
      IF (NUMDEC.EQ.1) THEN
C
C Calculate coordinates
C
         REPEET = .TRUE.
         DO WHILE (REPEET) 
            IF (E_NUMBERS) THEN
               WRITE (TEXT,200) WORD12, TS, TE, METHOD
            ELSE
               D13(1) = SHOWLJ(TS)
               D13(2) = SHOWLJ(TE)
               WRITE (TEXT,250) WORD12, D13(1), D13(2), METHOD
            ENDIF  
            NOPT = 1
            NUMOPT = 4
            NSTART = 8
            NTEXT = NSTART + NUMOPT - 1
            NUMBLD(1) = 1
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NOPT, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT, 
     +                   TEXT, 
     +                   BORDER, FLASH, HIGH)
            NUMBLD(1) = 0
            IF (NOPT.NE.NUMOPT - 1) REPEET = .FALSE.
            IF (NOPT.LT.3) THEN
               CALL BOTTOP (NOPT, NPAR,
     +                      TS, RTOL, TE, X, 
     +                      ABORT)
               IF (ABORT) RETURN
            ELSEIF (NOPT.EQ.NUMOPT - 1) THEN   
               WRITE (TEXT,1000)
               NTEXT = 23
               NUMBLD(1) = 1 
               CALL PATCH2 (NUMBLD, NTEXT,
     +                      TEXT)
               NUMBLD(1) = 0     
            ELSE
               ABORT = .FALSE.
               RETURN     
            ENDIF  
         ENDDO
         I = 2
         NMAX = NP - 1
         IF (NPTSAV.LT.I) NPTSAV = I
         CALL GETJM1 (I, NPTSAV, NMAX, 'Number of points required')
         NPTS = NPTSAV
         WRITE (TEXT,300)
         NDEC = 1
         NUMOPT = 4
         NSTART = 3
         NTEXT = 14
         NUMBLD(1) = 1 
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NDEC.EQ.2) THEN
            IF (TS.LE.RTOL .OR. TE.LE.RTOL) THEN
               CALL PUTFAT (
     +        'x too small for log(x) ... linear spacing will be used')
               NDEC = 1
            ENDIF
         ENDIF
         IF (NDEC.EQ.1) THEN
C
C Linear
C
            METHOD = 'Arithmetic (Linear)' 
            STEP = (TE - TS)/(DBLE(NPTS) - ONE)
            XVAL(1) = TS
            DO I = 2, NPTS - 1
               XVAL(I) = XVAL(I - 1) + STEP
            ENDDO
            XVAL(NPTS) = TE
         ELSEIF (NDEC.EQ.2) THEN
C
C Log
C
            METHOD = 'Geometric (Log)'
            STEP = (LOG(TE) - LOG(TS))/(DBLE(NPTS) - ONE)
            XVAL(1) = TS
            TEMP1 = LOG(TS)
            TEMP2 = TEMP1
            DO I = 2, NPTS - 1
               TEMP2 = TEMP1 + STEP
               XVAL(I) = EXP(TEMP2)
               TEMP1 = TEMP2
            ENDDO
            XVAL(NPTS) = TE
         ELSEIF (NDEC.EQ.3) THEN
C
C Simfit algorithm
C
            METHOD = 'Simfit algorithm' 
            I = NPTS
            NPTS = NPTS/4
            NPTS = 4*NPTS
            IF (NPTS.LT.8) NPTS = 8
            IF (I.NE.NPTS) THEN
               CALL PUTWAR ('No. of points adjusted to 4n, n >= 2')
            ENDIF
            CALL DIVIDE (NPTS,
     +                   XVAL, TS, TE)
         ELSE
            ABORT = .FALSE.
            RETURN
         ENDIF
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Read in XTEMP from a file or terminal
C
         NMAX = NP
         NPTVAL = 0
         CALL GETNOU (NIN)
         CLOSE (UNIT = NIN)
         JSEND = 3
         CALL VEC1IN (JSEND, NIN, NMAX, NPTVAL,
     +                XTEMP,
     +                FNAME, TITLE,
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT .OR. NPTVAL.LT.2) THEN
            CALL PUTADV (
     +'Insufficient data  ...  x-coordinates will not be changed')
            RETURN
         ELSE
            NPTS = NPTVAL
            NPTSAV = NPTS
            OK = .TRUE.
            DO I = 1, NPTS
               XVAL(I) = XTEMP(I)
               IF (OK .AND. I.GT.1) THEN
                  IF (XVAL(I).LT.XVAL(I - 1)) OK = .FALSE.
               ENDIF
            ENDDO
            IF (.NOT.OK) CALL PUTADV (
     +'x-coordinates are not all in increasing order')
            XSTART = XVAL(1)
            XSTOP = XVAL(1)
            DO I = 2, NPTS
               IF (XVAL(I).LT.XSTART) XSTART = XVAL(I)
               IF (XVAL(I).GT.XSTOP) XSTOP = XVAL(I)
            ENDDO
            TE = XSTOP
            TS = XSTART
         ENDIF
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Edit XVAL
C
         JSEND = 2
         LINE = 'X-coordinates'
         NPTS = NPTSAV
         NMAX = NP
         CALL EDITOR (JSEND, JTYPE, NCOLS, NMAX, NPTS,
     +                XVAL,
     +                LINE,
     +                CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
         OK = .TRUE.
         XSTART = XVAL(1)
         XSTOP = XVAL(1)
         DO I = 2, NPTS
            IF (XVAL(I).LT.XSTART) XSTART = XVAL(I)
            IF (XVAL(I).GT.XSTOP) XSTOP = XVAL(I)
            IF (OK) THEN
               IF (XVAL(I).LT.XVAL(I - 1)) OK = .FALSE.
            ENDIF
         ENDDO
         TE = XSTOP
         TS = XSTART
         IF (.NOT.OK) CALL PUTADV (
     +'x-coordinates are not all in increasing order')
         ABORT = .FALSE.
      ELSEIF (NUMDEC.EQ.NUMOPT) THEN
         ABORT = .FALSE.
         NPTS = NPTSAV
      ENDIF
C
C Next code required to fool ZMOD with differential equations
C This code must not be deleted if differential equations are to be used
C
      NZ = 0
      IF (ABS(XVAL(1) - ZERO).LE.EPSI) NZ = 1
      XVAL(NPTS + 1) = XVAL(NPTS) + ONE
      DO I = 3, NPTS + 1
         EQUAL(I) = .FALSE.
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Choose the method to set x-coordinates' 
     +/
     +/'Current number of points =',1X,A
     +/'Current X_start value =',1P,E13.5
     +/'Current X_stop value  =',    E13.5
     +/'Current spacing type =',1X,A
     +/
     +/'X-coordinates: Calculate interactively'
     +/'X-coordinates: Read from a file'
     +/'X-coordinates: Edit current values'
     +/'Help'
     +/'Quit ... No changes')
  150 FORMAT (
     + 'Choose the method to set x-coordinates' 
     +/
     +/'Current number of points =',1X,A
     +/'Current X_start value =',1X,A
     +/'Current X_stop value =',1X,A
     +/'Current spacing type =',1X,A
     +/
     +/'X-coordinates: Calculate interactively'
     +/'X-coordinates: Read from a file'
     +/'X-coordinates: Edit current values'
     +/'Help'
     +/'Quit ... No changes')     
  200 FORMAT (
     + 'Choose the method to set data limits'
     +/
     +/'Current number of points =',1X,A
     +/'Current X_start value =',1P,E11.3
     +/'Current X_stop value =',    E11.3
     +/'Current spacing type =',1X,A
     +/
     +/'X_start and X_stop: Input from terminal'
     +/'X_start and X_stop: Estimate numerically'
     +/'Help'
     +/'Quit ... No changes')
  250 FORMAT (
     + 'Choose the method to set data limits'
     +/
     +/'Current number of points =',1X,A
     +/'Current X_start value =',1X,A
     +/'Current X_stop value =',1X,A
     +/'Current spacing type =',1X,A
     +/
     +/'X_start and X_stop: Input from terminal'
     +/'X_start and X_stop: Estimate numerically'
     +/'Help'
     +/'Quit ... No changes')     
  300 FORMAT (
     + 'Choose the method to space x-points'
     +/ 
     +/'X-spacing: Arithmetic (Linear)'
     +/'X-spacing: Geometric (logarithmic)'
     +/'X-spacing: Simfit algorithm'
     +/'Quit ... no changes'
     +/
     +/'The SIMFIT algorithm requires a multiple of 4 points.'
     +/'Select it if you want (positive) x-values to input into'
     +/'program Simplot to generate smooth curves. It minimises'
     +/'stepping effects at extremes of continuous curves when'
     +/'coordinate transformations are used, e.g. in log plots.'
     +/'Usually, about 120 points will be sufficient to create'
     +/'a smooth curve using program Simplot.')
 1000 FORMAT (
     + 'Choosing the number, range, and spacing for X_values' 
     +/
     +/'This program calculates function values y = f(x) for a'
     +/'set of n X_values, i.e.'
     +/
     +/'     y_1 = f(x_1), y_2 = f(x_2), ..., y_n = f(x_n)'
     +/
     +/'and you can input such X_values in several ways.' 
     +/
     +/'1.`You can calculate a set of points by selecting the number n,'
     +/'  `the range X_start to X_stop, and the spacing required.' 
     +/'2.`You can read in a Simfit-type vector file containing a'
     +/'  `single column of X_values.'
     +/'3.`You can edit the current coordinates interactively.'
     +/'4.`You can proceed using the current X_values.'
     +/
     +/'Experienced users can select the range by numerical solution' 
     +/'of the nonlinear equations'
     +/'        Y_start - f(X-start) = 0'
     +/'        Y_stop - f(X_stop) = 0' 
     +/'and can space points linearly, logarithmically, or by a Simfit'
     +/'algorithm. Increasing order is best for plotting, while some'
     +/'functions (like differential equations) require X > 0.')     
      END
C
C
