C
C INCLUDE FILE FOR MAKDAT
C =======================
C XYGRID
C XYZVAL
C
C
      SUBROUTINE XYGRID (N, NPTS,
     +                   RTOL, X, Y,
     +                   EQUAL)
C
C ACTION : Create a grid of x, y points
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/4/93
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      INTEGER,          INTENT (OUT) :: NPTS
      DOUBLE PRECISION, INTENT (IN)  :: RTOL
      DOUBLE PRECISION, INTENT (OUT) :: X(N), Y(N)
      LOGICAL,          INTENT (OUT) :: EQUAL(N)
C
C Locals
C      
      INTEGER    I, J, NMAX, NX, NY
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 2,
     +           NSTART = 13, NTEXT = 14)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION XDELTA, XSAV, X1, X2, YDELTA, YSAV, Y1, Y2
      DOUBLE PRECISION X1SAV, X2SAV, Y1SAV, Y2SAV
      DOUBLE PRECISION ONE, ONE_M
      PARAMETER (ONE = 1.0D+00, ONE_M = -ONE)
      CHARACTER (LEN = 13) D13(4), SHOWLJ
      CHARACTER (LEN = 12) FORM12, I12(3)
      CHARACTER  XTYPE*9, YTYPE*9
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    XLOG, YLOG
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   GETDG2, REJECT, GETJM1, HBOX01, YESNO2
      INTRINSIC  SQRT, LOG, EXP, ABS, DBLE, NINT
      SAVE       NX, NY, X1SAV, X2SAV, Y1SAV, Y2SAV
      DATA       NX, NY / 20, 20 /
      DATA       X1SAV, X2SAV, Y1SAV, Y2SAV / ONE_M, ONE, ONE_M, ONE /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      E_NUMBERS = E_FORMATS()
      NPTS = 0
      DO I = 1, N
         X(I) = ONE
         Y(I) = ONE
         EQUAL(I) = .FALSE.
      ENDDO   
C
C Limit on no. of grid points = sqrt(n)
C
      NMAX = NINT(SQRT(DBLE(N)))
C
C First the x range
C
   20 CONTINUE
      X1 = X1SAV
      X2 = X2SAV
      CALL GETDG2 (X1, X2,
     +'X_start, X_stop ... ( where X_start < X_stop )')
      IF (ABS(X2 - X1).LE.RTOL) THEN
         CALL REJECT
         GOTO 20
      ENDIF
      X1SAV = X1
      X2SAV = X2
      I = 2
      CALL GETJM1 (I, NX, NMAX,
     +'Number of distinct X_values required ... (i.e. X grid points)')
      IF (X1.GT.RTOL) THEN
         WRITE (LINE,100)
         XLOG = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                XLOG)
      ELSE
         XLOG = .FALSE.
      ENDIF
      IF (XLOG) THEN
         XDELTA = (LOG(X2) - LOG(X1))/(DBLE(NX) - ONE)
         X1 =  LOG(X1) - XDELTA
         XTYPE = 'Geometric'
      ELSE
         XDELTA = (X2 - X1)/(DBLE(NX) - ONE)
         X1 = X1 - XDELTA
         XTYPE = 'Linear'
      ENDIF
C
C Now the y range
C
   40 CONTINUE
      Y1 = Y1SAV
      Y2 = Y2SAV
      CALL GETDG2 (Y1, Y2,
     +'Y_start, Y_stop ... ( where Y_start < Y_stop )')
      IF (ABS(Y2 - Y1).LE.RTOL) THEN
         CALL REJECT
         GOTO 40
      ENDIF
      Y1SAV = Y1
      Y2SAV = Y2
      I = 2
      CALL GETJM1 (I, NY, NMAX,
     +'Number of distinct Y_values required ... (i.e. Y_grid points)')
      IF (Y1.GT.RTOL) THEN
         WRITE (LINE,100)
         YLOG = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY, 
     +                LINE, 
     +                YLOG)
      ELSE
         YLOG = .FALSE.
      ENDIF
      IF (YLOG) THEN
         YDELTA = (LOG(Y2) - LOG(Y1))/(DBLE(NY) - ONE)
         Y1 =  LOG(Y1) - YDELTA
         YTYPE = 'Geometric'
      ELSE
         YDELTA = (Y2 - Y1)/(DBLE(NY) - ONE)
         Y1 = Y1 - YDELTA
         YTYPE = 'Linear'
      ENDIF
C
C Loop defining X, Y and NPTS
C
      NPTS = 0
      DO I = 1, NY
         Y1 = Y1 + YDELTA
         IF (YLOG) THEN
            YSAV = EXP(Y1)
         ELSE
            YSAV = Y1
         ENDIF
         XSAV = X1
         DO J = 1, NX
            NPTS = NPTS + 1
            Y(NPTS) = YSAV
            XSAV = XSAV + XDELTA
            IF (XLOG) THEN
               X(NPTS) = EXP(XSAV)
            ELSE
               X(NPTS) = XSAV
            ENDIF
            EQUAL(NPTS) = .FALSE.
         ENDDO
      ENDDO
      IF (E_NUMBERS) THEN
         I12(1) = FORM12(NPTS)
         I12(2) = FORM12(NX)
         I12(3) = FORM12(NY)
         WRITE (TEXT,200) I12(1), I12(2), X(1), X(NPTS), XTYPE, I12(3),
     +                    Y(1), Y(NPTS), YTYPE
      ELSE
         I12(1) = FORM12(NPTS)
         I12(2) = FORM12(NX)
         I12(3) = FORM12(NY)
         D13(1) = SHOWLJ(X(1))
         D13(2) = SHOWLJ(X(NPTS))
         D13(3) = SHOWLJ(Y(1))
         D13(4) = SHOWLJ(Y(NPTS))  
          WRITE (TEXT,250) I12(1), I12(2), D13(1), D13(2), XTYPE,
     +                     I12(3), D13(3), D13(4), YTYPE
      ENDIF  
      I = 1
      NUMBLD(1) = 1
      CALL HBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, I, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (I.EQ.2) GOTO 20
C
C Format statements
C        
  100 FORMAT ('Geometric (log) spacing ?')
  200 FORMAT (
     + 'Details of the current data set'
     +/
     +/'Number of x,y pairs    `',1X,A
     +/'Number of x divisions  `',1X,A
     +/'X_start                `',1P,E13.5
     +/'X_stop                 `',1P,E13.5
     +/'X spacing type         `',2X,A
     +/'Number of y divisions  `',1X,A
     +/'Y_start                `',1P,E13.5
     +/'Y_stop                 `',1P,E13.5
     +/'Y_spacing type         `',2X,A/
     +/'Accept'
     +/'Try again')
  250 FORMAT (
     + 'Details of the current data set'
     +/
     +/'Number of x,y pairs    `',1X,A
     +/'Number of x divisions  `',1X,A
     +/'X_start                `',1X,A
     +/'X_stop                 `',1X,A
     +/'X spacing type         `',2X,A
     +/'Number of y divisions  `',1X,A
     +/'Y_start                `',1X,A
     +/'Y_stop                 `',1X,A
     +/'Y_spacing type         `',2X,A/
     +/'Accept'
     +/'Try again')   
      END
C
C------------------------------------------------------------------
C
      SUBROUTINE XYZVAL (N, NPTS,
     +                   RTOL, X, Y, Z,
     +                   EQUAL)
C
C ACTION : Create a grid of x, y, z points
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/4/93
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      INTEGER,          INTENT (OUT) :: NPTS
      DOUBLE PRECISION, INTENT (IN)  :: RTOL
      DOUBLE PRECISION, INTENT (OUT) :: X(N), Y(N), Z(N)
      LOGICAL,          INTENT (OUT) :: EQUAL(N)
C
C Locals
C      
      INTEGER    I, J, K, NMAX, NX, NY, NZ
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 3, NUMOPT = 2,
     +           NSTART = 17, NTEXT = 18)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION XDELTA, XSAV, X1, X2, YDELTA, YSAV, YTEMP, Y1,
     +                 Y2, ZDELTA, ZSAV, Z1, Z2
      DOUBLE PRECISION X1SAV, X2SAV, Y1SAV, Y2SAV, Z1SAV, Z2SAV
      DOUBLE PRECISION ONE, ONETHD, ONE_M
      PARAMETER (ONE = 1.0D+00, ONE_M = -ONE, ONETHD = ONE/3.0D+00)
      CHARACTER  XTYPE*9, YTYPE*9, ZTYPE*9
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER (LEN = 13) D13(6), SHOWLJ
      CHARACTER (LEN = 12) I12(6), FORM12
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    XLOG, YLOG, ZLOG
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   GETDG2, REJECT, GETJM1, HBOX01, YESNO2
      INTRINSIC  LOG, EXP, ABS, DBLE, NINT
      SAVE       NX, NY, NZ, X1SAV, X2SAV, Y1SAV, Y2SAV, Z1SAV, Z2SAV
      DATA       NX, NY, NZ / 5, 5, 5 /
      DATA       X1SAV, Y1SAV, Z1SAV /  ONE_M, ONE_M, ONE_M /
      DATA       X2SAV, Y2SAV, Z2SAV /  ONE,   ONE,   ONE /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      E_NUMBERS = E_FORMATS()
      NPTS = 0
      DO I = 1, N
         X(I) = ONE
         Y(I) = ONE
         Z(I) = ONE
         EQUAL(I) = .FALSE.
      ENDDO   
C
C Limit on no. of grid points = cube root(n)
C
      NMAX = NINT(DBLE(N)**ONETHD)
C
C First the x range
C
   20 CONTINUE
      X1 = X1SAV
      X2 = X2SAV
      CALL GETDG2 (X1, X2,
     +'X_start, X_stop ... ( where X_start < X_stop )')
      IF (ABS(X2 - X1).LE.RTOL) THEN
         CALL REJECT
         GOTO 20
      ENDIF
      X1SAV = X1
      X2SAV = X2
      I = 2
      CALL GETJM1 (I, NX, NMAX,
     +'Number of distinct X values required ... (i.e. X grid points)')
      IF (X1.GT.RTOL) THEN
         WRITE (LINE,100)
         XLOG = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                XLOG)
      ELSE
         XLOG = .FALSE.
      ENDIF
      IF (XLOG) THEN
         XDELTA = (LOG(X2) - LOG(X1))/(DBLE(NX) - ONE)
         X1 =  LOG(X1) - XDELTA
         XTYPE = 'Geometric'
      ELSE
         XDELTA = (X2 - X1)/(DBLE(NX) - ONE)
         X1 = X1 - XDELTA
         XTYPE = 'Linear'
      ENDIF
C
C Now the y range
C
   40 CONTINUE
      Y1 = Y1SAV
      Y2 = Y2SAV
      CALL GETDG2 (Y1, Y2,
     +'Y_start, Y_stop ... ( where Y_start < Y_stop )')
      IF (ABS(Y2 - Y1).LE.RTOL) THEN
         CALL REJECT
         GOTO 40
      ENDIF
      Y1SAV = Y1
      Y2SAV = Y2
      I = 2
      CALL GETJM1 (I, NY, NMAX,
     +'Number of distinct Y values required ... (i.e. Y grid points)')
      IF (Y1.GT.RTOL) THEN
         WRITE (LINE,100)
         YLOG = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY, 
     +                LINE,
     +                YLOG)
      ELSE
         YLOG = .FALSE.
      ENDIF
      IF (YLOG) THEN
         YDELTA = (LOG(Y2) - LOG(Y1))/(DBLE(NY) - ONE)
         Y1 =  LOG(Y1) - YDELTA
         YTYPE = 'Geometric'
      ELSE
         YDELTA = (Y2 - Y1)/(DBLE(NY) - ONE)
         Y1 = Y1 - YDELTA
         YTYPE = 'Linear'
      ENDIF
C
C Now the z range
C
   60 CONTINUE
      Z1 = Z1SAV
      Z2 = Z2SAV
      CALL GETDG2 (Z1, Z2,
     +'Z_start, Z_stop ... ( where Z_start < Z_stop )')
      IF (ABS(Z2 - Z1).LE.RTOL) THEN
         CALL REJECT
         GOTO 60
      ENDIF
      Z1SAV = Z1
      Z2SAV = Z2
      I = 2
      CALL GETJM1 (I, NZ, NMAX,
     +'Number of distinct Z values required ... (i.e. Z grid points)')
      IF (Z1.GT.RTOL) THEN
         WRITE (LINE,100)
         ZLOG = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE, 
     +                ZLOG)
      ELSE
         ZLOG = .FALSE.
      ENDIF
      IF (ZLOG) THEN
         ZDELTA = (LOG(Z2) - LOG(Z1))/(DBLE(NZ) - ONE)
         Z1 =  LOG(Z1) - ZDELTA
         ZTYPE = 'Geometric'
      ELSE
         ZDELTA = (Z2 - Z1)/(DBLE(NZ) - ONE)
         Z1 = Z1 - ZDELTA
         ZTYPE = 'Linear'
      ENDIF
C
C Loop defining X, Y, Z and NPTS
C
      NPTS = 0
      DO I = 1, NX
         X1 = X1 + XDELTA
         IF (XLOG) THEN
            XSAV = EXP(X1)
         ELSE
            XSAV = X1
         ENDIF
         YTEMP = Y1
         DO J = 1, NY
            YTEMP = YTEMP + YDELTA
            IF (YLOG) THEN
               YSAV = EXP(YTEMP)
            ELSE
               YSAV = YTEMP
            ENDIF
            ZSAV = Z1
            DO K = 1, NZ
               NPTS = NPTS + 1
               X(NPTS) = XSAV
               Y(NPTS) = YSAV
               ZSAV = ZSAV + ZDELTA
               IF (ZLOG) THEN
                  Z(NPTS) = EXP(ZSAV)
               ELSE
                  Z(NPTS) = ZSAV
               ENDIF
               EQUAL(NPTS) = .FALSE.
            ENDDO
        ENDDO
      ENDDO
      IF (E_NUMBERS) THEN
         I12(1) = FORM12(NPTS)
         I12(2) = FORM12(NX)
         I12(3) = FORM12(NY)
         I12(4) = FORM12(NZ)
         WRITE (TEXT,200) I12(1), I12(2), X(1), X(NPTS), XTYPE, I12(3),
     +                    Y(1), Y(NPTS), YTYPE, I12(4), Z(1), Z(NPTS),
     +                    ZTYPE
      ELSE
         I12(1) = FORM12(NPTS)
         I12(2) = FORM12(NX)
         I12(3) = FORM12(NY)
         I12(4) = FORM12(NZ)
         D13(1) = SHOWLJ(X(1))
         D13(2) = SHOWLJ(X(NPTS))
         D13(3) = SHOWLJ(Y(1))
         D13(4) = SHOWLJ(Y(NPTS))
         D13(5) = SHOWLJ(Z(1))
         D13(6) = SHOWLJ(Z(NPTS))
         WRITE (TEXT,250) I12(1), I12(2), D13(1), D13(2), XTYPE, I12(3),
     +                    D13(3), D13(4), YTYPE, I12(4), D13(5), D13(6),
     +                    ZTYPE   
      ENDIF
      I = 1
      NUMBLD(1) = 1
      CALL HBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, I, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (I.EQ.2) GOTO 20
C
C Format statements
C        
  100 FORMAT ('Geometric (log) spacing ?')
  200 FORMAT (
     + 'Details of the current data set'
     +/
     +/'Number of x,y,z triples   `',1X,A
     +/'Number of x divisions     `',1X,A
     +/'X_start                   `',1P,E13.5
     +/'X_stop                    `',1P,E13.5
     +/'X spacing type            `',2X,A
     +/'Number of y divisions     `',1X,A
     +/'Y_start                   `',1P,E13.5
     +/'Y_stop                    `',1P,E13.5
     +/'Y spacing type            `',2X,A
     +/'Number of z divisions     `',1X,A
     +/'Z_start                   `',1P,E13.5
     +/'Z_stop                    `',1P,E13.5
     +/'Z_spacing type            `',2X,A/
     +/'Accept'
     +/'Try again')
  250 FORMAT (
     + 'Details of the current data set'
     +/
     +/'Number of x,y,z triples   `',1X,A
     +/'Number of x divisions     `',1X,A
     +/'X_start                   `',1X,A
     +/'X_stop                    `',1X,A
     +/'X spacing type            `',2X,A
     +/'Number of y divisions     `',1X,A
     +/'Y_start                   `',1X,A
     +/'Y_stop                    `',1X,A
     +/'Y spacing type            `',2X,A
     +/'Number of z divisions     `',1X,A
     +/'Z_start                   `',1X,A
     +/'Z_stop                    `',1X,A
     +/'Z_spacing type            `',2X,A/
     +/'Accept'
     +/'Try again')        
      END
C
C
