C
C INCLUDE FILE FOR MAKDAT
C =======================
C ZSOLVE
C FZMOD
C
C
      SUBROUTINE ZSOLVE (NPAR,
     +                   X, X1, X2, Y,
     +                   ABORT)
C
C ACTION : Solve the eqn. Y(X) - CONST. = 0.0 using C05AZF
C          Subroutine required by program MAKDAT
C          Requires function FZMOD
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          13/04/1993 altered A, B window when f(A)f(B) > 0, NREPS and FREPS
C          06/10/1994 minor revision
C          15/08/2015 added help option
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NPAR
      DOUBLE PRECISION, INTENT (INOUT) :: X(NPAR), X1, X2, Y
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    NREPS
      PARAMETER (NREPS = 12)
      INTEGER    I, ICOUNT, IFAIL, IND, IR, NDEC
      INTEGER    COLOUR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 3,
     +           NSTART = 7)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      DOUBLE PRECISION RELERR, FREPS, ZERO
      PARAMETER (RELERR = 1.0D-04, FREPS = 2.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION C(17)
      DOUBLE PRECISION FX, FZMOD, F1, F2, TEMP, TOLX
      CHARACTER (LEN = 100) LINE, TEXT(30)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   C05AZF$
      EXTERNAL   PUTWAR, PUTBEL, GETR01, GETRG2, PUTTXT, TABLE1, LBOX01, 
     +           PATCH2 
      EXTERNAL   FZMOD
      DATA       NUMBLD  / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
      ABORT = .TRUE.
   10 CONTINUE
      IF (X1.GT.X2) THEN
         TEMP = X2
         X2 = X1
         X1 = TEMP
         CALL PUTWAR ('A > B ... Values reversed')
      ENDIF
      ICOUNT = 0
   20 CONTINUE
      F1 = FZMOD(NPAR, X, X1, Y)
      F2 = FZMOD(NPAR, X, X2, Y)
      IF (F1*F2.GT.ZERO) THEN
C
C Open TABLE1 and try to find starting estimates
C
         CALL PUTBEL
         ICOUNT = ICOUNT + 1
         IF (ICOUNT.EQ.1) THEN
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = 4
            WRITE (LINE,100)
            CALL TABLE1 (COLOUR, LINE)
            COLOUR = 0
         ENDIF
         WRITE (LINE,200) X1, F1, X2, F2
         CALL TABLE1 (COLOUR, LINE)
         IF (ICOUNT.LE.NREPS) THEN
            IF (X1.GE.ZERO) THEN
               X1 = X1/FREPS
            ELSE
               X1 = X1*FREPS
            ENDIF
            IF (X2.GE.ZERO) THEN
               X2 = X2*FREPS
            ELSE
               X2 = X2/FREPS
            ENDIF
            GOTO 20
         ELSE
            GOTO 50
         ENDIF
      ENDIF
C
C Close the table if a window has been found
C
      IF (ICOUNT.GT.0) THEN
         WRITE (LINE,200) X1, F1, X2, F2
         CALL TABLE1 (COLOUR, LINE)
         LINE = 'SUCCESS : Your A, B values have now been adjusted'
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF
      TOLX = RELERR
      IR = 2
      IND = 1
      IFAIL = 1
   30 CONTINUE
      CALL C05AZF$(X1, X2, FX, TOLX, IR, C, IND, IFAIL)
      IF (IND.EQ.0) GOTO 40
      IF (IND.LT.2 .OR. IND.GT.4) GOTO 50
      FX = FZMOD(NPAR, X, X1, Y)
      GOTO 30
   40 CONTINUE
      IF (IFAIL.EQ.0) THEN
         WRITE (LINE,300) X1
         CALL PUTTXT (LINE)
         ABORT = .FALSE.
         RETURN
      ENDIF
      F1 = FZMOD(NPAR, X, X1, Y)
      F2 = FZMOD(NPAR, X, X2, Y)
      WRITE (TEXT,400) IFAIL, X1, F1, X2, F2
      COLOUR = 15
      CALL TABLE1 (COLOUR, 'OPEN')
      COLOUR = 0
      DO I = 1, 3
         CALL TABLE1 (COLOUR, TEXT(I))
      ENDDO
   50 CONTINUE
C
C Close TABLE1
C
      CALL TABLE1 (COLOUR, 'CLOSE')
      
      CALL PUTBEL
      
   60 CONTINUE   
      WRITE (TEXT,500)
      NTEXT = NSTART + NUMOPT - 1
      NDEC = 1
      NUMBLD(1) = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NUMBLD(1) = 0
      IF (NDEC.EQ.1) THEN
         CALL GETR01 (Y, 'Value you want for Y_input = f(X_required)')
         CALL GETRG2 (X1, X2,
     +  'A, B ... (where A < X_required < B, [y-f(A)][y-f(B)] < 0)')
         GOTO 10
      ELSEIF (NDEC.EQ.2) THEN
         WRITE (TEXT,600)
         NUMBLD(1) = 1
         NUMBLD(11) = 1
         NTEXT = 23
         CALL PATCH2 (NUMBLD, NTEXT,
     +                TEXT)
         NUMBLD(1) = 0
         NUMBLD(11) = 0         
         GOTO 60   
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     +4X,'A',8X,'y - f(A)',5X,'B',8X,'y - f(B) (Adjusting A, B values)')
  200 FORMAT (1P,4E11.3)
  300 FORMAT ('SUCCESS : Root located at x =',1P,E14.6)
  400 FORMAT ('WARNING : IFAIL =',I2,1X,'from C05AZF/ZSOLVE'
     +/10X,'At x = A, y - f(',1P,E11.3,') =',E11.3
     +/10X,'At x = B, y - f(',   E11.3,') =',E11.3)
  500 FORMAT (
     + 'Fatal  `No solution found for  A, B, y provided'
     +/'       ` '     
     +/'Reason `Failure to supply sensible start values'
     +/'Advice `Study mathematical model more carefully'
     +/'Inspect`Graph of f(x) in the region of interest'
     +/
     +/'Try again with new A, B, y values'
     +/'Help'
     +/'Cancel')
  600 FORMAT (
     + 'Calculating X_start and X_stop numerically' 
     +/
     +/'To calculate start and end points you solve two nonlinear'
     +/'equations numerically noting these definitions:'
     +/
     +/'y:`the current value required to define X_start or X_stop'
     +/'A:`a lower (or upper) starting estimate for y'
     +/'B:`a higher (or lower) starting estimate for y' 
     +/'f:`function value evaluated at A or B' 
     +/
     +/'The following procedure should be used'
     +/
     +/'First inspect a graph to guess approximate values for X_start'
     +/'and X_stop, where y_start = f(X_start) and y_stop = f(X_stop),'
     +/'then allow the program to refine your guesses.'
     +/
     +/'You input y = y_start, A, B where (y - f(A))*(y - f(B)) < 0'
     +/'and the program will adjust A, and B until finally'
     +/'y = f(A) = f(B) (approximately) so that X_start = (A + B)/2' 
     +/
     +/'Then you input y = y_stop, A, B where (y - f(A))*(y - f(B)) < 0'
     +/'and the program will adjust A, and B until finally'
     +/'y = f(A) = f(B) (approximately) so that X_stop = (A + B)/2')
      END
C
C----------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION FZMOD(N,
     +                                X, XARG, YARG)

      USE MODULE_MAKDAT, ONLY : NZEROS, 
     +                          EPSI, THEORY, XVAL
C
C Function required by subroutine ZSOLVE
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N
      DOUBLE PRECISION, INTENT (IN) :: X(N)
      DOUBLE PRECISION, INTENT (IN) :: XARG, YARG      
C
C locals
C      
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL  QMODEL
      INTRINSIC ABS
      NZEROS = 0
      IF (ABS(XARG - ZERO).LE.EPSI) NZEROS = 1
      XVAL(1) = XARG
      XVAL(2) = XVAL(1) + ONE
      CALL QMODEL (N,
     +             X)
      FZMOD = YARG - THEORY(1)
      END
C
C
