C
C
C MAKDAT6.INS = QNFIT4.INS ... The models used by MAKDAT and QNFIT
C ========================
C QMODEL
C QMODEX
C
C Given parameters P(N) and NPTS these routines calculate THEORY(i)
C for i = 1, 2, ..., NPTS for simulation or fitting
C
C IMPORTANT NOTE : this version uses MODULE_MAKDAT
C ================ 
C
C Models... QMODEL, QMODEX, DEQUSE, JACUSE, YDERIV and PEDERV
C
C 9/10/97 win32 version using DVODE instead of D02EBF
C ===================================================
C         DVODE parameters are as follows:
C
C         IP and P communicate INTEGER and DBLE parameters to the model
C         IWORK(LIW) and RWORK(LRW) are used as local workspace by DVODE
C         Note that A = FACT*P is passed to the model not P
C         LIW >= NEQN + 30
C         LRW >= 22 + 9*NEQN + 2*NEQN**2
C         ATOL = absolute tolerance
C         BTOL = relative tolerance
C         where estimated local error is EWT(i) = RTOL*ABS(Y(i)) + ATOL
C         ITASK = 1 for normal computation of Y at TOUT
C         IOPT = 0 for no optional input
C         METH = 1 Adams, 2 = BDF
C         MITER = 0 no Jacobian, 1 = analytic Jacobian, 2 = estimated Jacobian
C         MF: MF = JSV*(10*METH + MITER), e.g.
C             10 = Adams with no Jacobian
C             21 = stiff with analytic Jacobian
C             22 = stiff with estimated Jacobian
C         ISTAT:  2 = success
C                -1 = excess work (wrong MF)
C                -2 = excess accuracy (wrong TOL)
C                -3 = illegal input
C                -4 = repeated error test failures
C                -5 = repeated convergence failures (bad Jacobian)
C                -6 = error weight became zero
C
C
C
      SUBROUTINE QMODEL (N,
     +                   P)

      USE MODULE_MAKDAT, ONLY : IRELAB, MITER, METH, MODEL, NCALLS, 
     +                          NMOD, NPAR, NPTS, NVAR, NX, 
     +                          A, B, DTOL, ENEG, EPOS, EPSI, FACT,
     +                          RTOL, THEORY, XVAL, XTOL, YVAL, ZTOL, 
     +                          ZVAL,
     +                          CONST, DEQN, EQUAL 
C
C Evaluate MODEL depending on DEQN, SUPPLY, NVAR
C 19/02/1998 Added error trapping to call to DVODE
C 04/07/2005 Added warning if x < 0 or x_start = x_stop
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N
      DOUBLE PRECISION, INTENT (IN) :: P(N)
C
C Locals
C      
      INTEGER    LIW, LRW, NDEQN
      PARAMETER (LIW = 31, LRW = 33, NDEQN = 1)
      INTEGER    IWORK(LIW)
      INTEGER    I, IP(4)
      INTEGER    ITOL, ITASK, ISTAT, IOPT, JSV, MF
      PARAMETER (ITOL = 1, ITASK = 1, IOPT = 0, JSV = 1)
      DOUBLE PRECISION QNLIB1, QNLIB2, QNLIB3
      DOUBLE PRECISION ATOL(1), BTOL(1), TIME, TOUT, TSTART, TSTOP,
     +                 RWORK(LRW), Y(1), YNORM, YZERO
      DOUBLE PRECISION TOL, ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION YPREV
      CHARACTER  DEQERR(6)*80, LINE*100
      EXTERNAL   QNLIB1, QNLIB2, QNLIB3, PUTFAT
      EXTERNAL   DVODE
      EXTERNAL   PEDERV, YDERIV, QMODEX, DEQUSE, JACUSE
      INTRINSIC  ABS, MAX
C
C Save important parameters
C
      SAVE IP, IWORK, RWORK, Y, YPREV
      SAVE ATOL, BTOL, MF
      DATA  DEQERR /
     +'FATAL: ISTATE = -1 from DVODE ... excess work, maybe wrong MF ?',
     +'FATAL: ISTATE = -2 from DVODE .. maybe TOL value is too small ?',
     +'FATAL: ISTATE = -3 from DVODE .. maybe illegal input detected ?',
     +'FATAL: ISTATE = -4 from DVODE .. repeated error test failures ?',
     +'FATAL: ISTATE = -5 from DVODE  no conv. check Jacobian/MF/TOL ?',
     +'FATAL: ISTATE = -6 from DVODE  error weight = 0, and ATOL = 0 ?'/
C
C Scale the parameters up before evaluating the model
C
      DO I = 1, N
         A(I) = FACT(I)*P(I)
      ENDDO
      IF (DEQN) THEN
C
C Differential equations so define TSTART, TSTOP and YZERO
C If ISTATE < 0 then terminate with fatal error message
C
         TSTART = ZERO
         TSTOP = XVAL(NPTS)
         IF (MODEL.EQ.1) THEN
C
C For some special models Y(0) = 0.0
C
            IF (NMOD.EQ.2 .OR. NMOD.EQ.4) THEN
               YZERO = ZERO
            ELSE
               YZERO = A(N)
            ENDIF
         ELSE
C
C Usually Y(0) = A(n)
C
            YZERO = A(N)
         ENDIF
C
C======================================================================
C This next code is only required if a mistake has been made defining
C XVAL(NPTS + 1) in a calling program, e.g. for AUC, calibration, dy/dx
C and so on. Re-include it only to sort out any further problems.
C
C Make sure XVAL(NPTS + 1) > XVAL(NPTS) and that EQUAL(NPTS + 1) = .FALSE.
C
C        I = NPTS + 1
C        XVAL(I) = XVAL(NPTS) + ONE
C        EQUAL(I) = .FALSE.
C======================================================================
C
         IF (XVAL(1).LT.ZERO .OR. ABS(TSTART - TSTOP).LE.RTOL) THEN
            IF (XVAL(1).LT.ZERO) THEN
               WRITE (LINE,100) XVAL(1)
            ELSE   
               WRITE (LINE,200) TSTART, TSTOP 
            ENDIF   
            CALL PUTFAT (LINE)
            DO I = 1, NPTS
               THEORY(I) = YZERO
            ENDDO
         ELSE
            IP(1) = MODEL
            IP(2) = NMOD
            IP(3) = NDEQN
            IP(4) = NPAR
            MF = JSV*(10*METH + MITER)
            TIME = TSTART
            TOUT = TSTART
            TOL = DTOL
            YNORM = ABS(YZERO)
            IF (IRELAB.EQ.0) THEN
               ATOL(1) = EPSI*(MAX(ONE, YNORM))
               BTOL(1) = TOL
            ELSEIF (IRELAB.EQ.1) THEN
               ATOL(1) = EPSI*(MAX(ONE, YNORM))
               BTOL(1) = ZERO
            ELSE
               ATOL(1) = ZERO
               BTOL(1) = TOL
            ENDIF
C
C Initial conditions DVODE ... Define Y(1) at t = 0 and set NCALLS = 0
C
            Y(1) = YZERO
            YPREV = Y(1)
            NCALLS = 0
            CALL QMODEX (TOUT, Y)
C
C Now call DVODE
C
            ISTAT = 1
            IF (MODEL.EQ.17) THEN
C
C User supplied model
C
               DO WHILE (TOUT.LE.TSTOP)
                  IF (ISTAT.GT.0) THEN
                     CALL DVODE (DEQUSE, NDEQN, Y, TIME, TOUT, ITOL,
     +                           BTOL, ATOL, ITASK, ISTAT, IOPT, RWORK,
     +                           LRW, IWORK, LIW, JACUSE, MF, A, IP)
                     IF (ISTAT.GT.0) THEN
                        YPREV = Y(1)
                     ELSE
                        I = - ISTAT
                        CALL PUTFAT (DEQERR(I))
                        WRITE (6,'(A)') DEQERR(I)
                        Y(1) = YPREV
                     ENDIF
                  ELSE
                     Y(1) = YPREV
                  ENDIF
                  CALL QMODEX (TOUT, Y)
               ENDDO
            ELSE
C
C Model in DLL
C
               DO WHILE (TOUT.LE.TSTOP)
                  IF (ISTAT.GT.0) THEN
                     CALL DVODE (YDERIV, NDEQN, Y, TIME, TOUT, ITOL,
     +                           BTOL, ATOL, ITASK, ISTAT, IOPT, RWORK,
     +                           LRW, IWORK, LIW, PEDERV, MF, A, IP)
                     IF (ISTAT.GT.0) THEN
                        YPREV = Y(1)
                     ELSE
                        I = - ISTAT
                        CALL PUTFAT (DEQERR(I))
                        WRITE (6,'(A)') DEQERR(I)
                        Y(1) = YPREV
                     ENDIF
                  ELSE
                     Y(1) = YPREV
                  ENDIF
                  CALL QMODEX (TOUT, Y)
               ENDDO
            ENDIF
         ENDIF
      ELSEIF (NVAR.EQ.1) THEN
C
C Function of one variable
C
         DO I = 1, NPTS
            IF (EQUAL(I)) THEN
               THEORY(I) = THEORY(I - 1)
            ELSE
               THEORY(I) = QNLIB1(MODEL, NMOD, NPAR, NX,
     +                            A, B, ENEG, EPOS, EPSI, RTOL,
     +                            XVAL(I), XTOL, ZTOL, 
     +                            CONST)
            ENDIF
        ENDDO
      ELSEIF (NVAR.EQ.2) THEN
C
C Function of two variables
C
         DO I = 1, NPTS
            IF (EQUAL(I)) THEN
               THEORY(I) = THEORY(I - 1)
            ELSE
               THEORY(I) = QNLIB2(MODEL, NMOD, NPAR, NX,
     +                            A, B, ENEG, EPOS, EPSI, RTOL,
     +                            XVAL(I), XTOL, YVAL(I), ZTOL,
     +                            CONST)
            ENDIF
        ENDDO
      ELSEIF (NVAR.EQ.3) THEN
C
C Function of three variables
C
         DO I = 1, NPTS
            IF (EQUAL(I)) THEN
               THEORY(I) = THEORY(I - 1)
            ELSE
               THEORY(I) = QNLIB3(MODEL, NMOD, NPAR, NX,
     +                            A, B, ENEG, EPOS, EPSI, RTOL,
     +                            XVAL(I), XTOL, YVAL(I), ZVAL(I), ZTOL,
     +                            CONST)
            ENDIF
        ENDDO
      ENDIF
C
C Format statement
C      
  100 FORMAT ('x(1) =',1P,E12.4,'  < 0, so all y(i) => y0(i)')
  200 FORMAT ('TSTART =',1P,E12.4,', TSTOP =',E12.4,
     +        ', so all y(i) => y0(i)')
      END
C
C--------------------------------------------------------------------------
C
      SUBROUTINE QMODEX (XSOL, Y)

      USE MODULE_MAKDAT, ONLY : NCALLS, NPTS, NZEROS,
     +                          THEORY, XVAL,
     +                          EQUAL     
C
C ACTION : Intermediate output from D02EBF/DVODE
C ADVICE : This routine sets each time point for the next integration step
C          The COMMON blocks must be dimensioned correctly
C
C
      IMPLICIT   NONE
C
C Arguments
C     
      DOUBLE PRECISION, INTENT (IN)  :: Y(1) 
      DOUBLE PRECISION, INTENT (OUT) :: XSOL
C
C Locals
C      
      INTEGER    I, NTEMP
      XSOL = 0.0D+00
      IF (NCALLS.EQ.0) THEN
C
C First call only so NCALLS must be set elsewhere = 0 to start the integration
C
         NCALLS = 1
         XSOL = XVAL(1)
         IF (NZEROS.EQ.0) THEN
C
C If there are no t = 0 points just carry on
C
            I = 1!to silence ftn95
         ELSE
C
C Set each replicate t = 0 point to Y(0)
C
            DO I = 1, NZEROS
               THEORY(NCALLS) = Y(1)
               NCALLS = NCALLS + 1
            ENDDO
            XSOL = XVAL(NCALLS)
         ENDIF
      ELSE
C
C Set current Y(i) (setting NCALLS to deal with replicates) then re-set t
C
         THEORY(NCALLS) = Y(1)
         NCALLS = NCALLS + 1
         XSOL = XVAL(NCALLS)
         NTEMP = NCALLS
         DO I = NTEMP, NPTS
            IF (.NOT.EQUAL(I)) RETURN
            THEORY(I) = Y(1)
            NCALLS = NCALLS + 1
            XSOL = XVAL(NCALLS)
         ENDDO
      ENDIF
      END
C
C
