C
C
C     INCLUDE 'dllchk.for'
      PROGRAM MAIN
C
C VERSION : set from SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C INPUT   : A(I,J) values for matrix A, I < = NROW, J < = NCOL
C OUTPUT  : Matrix A written to a file
C AUTHOR  : W. G. Bardsley, 26/11/85
C REVISED : 16/12/1989 OFILES, VECSRT
C           27/07/1992 ENDALL, CHECKT, GETNUM
C           03/10/1992 Added NORMAL to display all 16 numbers
C           21/09/1994 removed NORMAL, ADD1, ADD2, ADD3, added NADD
C           22/09/1994 Extensively re-written, ORDERS, DSPLAY, DETAIL, CORREC
C           22/09/1994 DBOS version
C           20/02/1995 Salamanca version
C           16/12/1996 Increased max. dimension for Matrix/GETMAT
C           01/02/1997 Windows95 version ... up to 8 for GETMAT
C           07/08/1998 added dllchk, FTN95 version
C           08/10/1998 Added FNAME to output string
C           14/12/1998 replaced TUTORS by TUTOR1
C           12/08/1999 increased dimension and new version of DSPLAY
C           13/09/1999 added call to WINDOW
C           14/02/2000 added call to SIMVER
C           02/04/2001 revised
C           28/01/2002 removed GETVEC code since wide case now handled by
C                      GETMAT, increased NBIG and deleted formats 100, 200
C           20/01/2005 moved help to help.dll
C           27/07/2005 passed DVER to ADVISE
C           11/10/2006 extensive revision  
C           23/03/2008 revised for version 6 
C
      IMPLICIT   NONE
      INTEGER    NBIG, NCOL, NOUT, NROW, NTYPE
      PARAMETER (NBIG = 1, NCOL = 50, NOUT = 4, NROW = 250, NTYPE = 3)
      INTEGER    N1, N2, N3, N4
      PARAMETER (N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    NCMAX, NCOL1, NRMAX, NROW1
      INTEGER    M, N
      INTEGER    I, ISEND, ITYPE, L, LEN200, NDEC
      DOUBLE PRECISION A(NROW,NCOL), B(NROW)
      DOUBLE PRECISION XVER, YVER
      CHARACTER  FNAME*1024, PHRASE(NBIG)*80, TITLE*100, TRIM60*60,
     +           WORD60*60
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_makmat.exe')
      CHARACTER  BLANK*1, PNAME*6
      PARAMETER (BLANK = ' ', PNAME = 'MAKMAT')
      CHARACTER  LINE*1024
      LOGICAL    ABORT, ACTION, EXPERT, FALSE, JUMP, MATRIX, SHOW, TRUE
      PARAMETER (FALSE = .FALSE., TRUE = .TRUE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .FALSE.,
     +           LABEL = .TRUE., ORDER = .FALSE., WEIGHT = .FALSE.)
      LOGICAL    FILEIT
      PARAMETER (FILEIT = .FALSE.)
      LOGICAL    AGAIN, REPEET
      EXTERNAL   GETVEC, GETMAT, MATOUT, STOPGO, DSPLAY, SRTVEC, EDITOR,
     +           LEN200, TRIM60
      EXTERNAL   ADVISE, MTYPES, ORDERS, MAKCON, CORREC, DETAIL
      EXTERNAL   DLLCHK, WINDOW, SIMVER

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = N1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

C
C Initialise the program and provide advice
C
      CALL ADVISE (NCOL, NROW,
     +             DVER,
     +             ABORT, EXPERT)
      IF (ABORT) THEN
         REPEET = .FALSE.
      ELSE
         REPEET = .TRUE.
         M = N1
         N = N1
         NCMAX = NCOL
         NRMAX = NROW
         FNAME = BLANK
      ENDIF
      
C*******************************************************************
C Start of outer loop ... Return here for each cycle of data input
C*******************************************************************
         
      DO WHILE (REPEET)
         CLOSE (UNIT = NOUT)
         CALL MTYPES (NOUT,
     +                FNAME, TITLE, 
     +                ABORT, MATRIX)
         IF (ABORT) THEN
C
C No more matrices required so EXIT outer loop
C           
            EXIT
         ELSE
C
C Now get a matrix from the user
C           
            AGAIN = .TRUE.
            WORD60 = TRIM60(FNAME)
            L = LEN200(WORD60)
            CALL ORDERS (M, N, NCOL, NROW,
     +                   MATRIX)
C
C Make a default matrix if required or get all elements A(I,J)
C
            IF (EXPERT) THEN
               CALL MAKCON (M, N, NROW,
     +                      A, 
     +                      JUMP)
            ELSE
               JUMP = .FALSE.
            ENDIF
            IF (.NOT.JUMP) THEN
C
C Matrix filled in row by row
C
               IF (MATRIX) THEN
                  LINE = WORD60(N1:L)//' ... input matrix A'
                  CALL GETMAT (M, NROW, N,
     +                         A,
     +                         LINE)
               ELSE
                  LINE = WORD60(N1:L)//' ... input vector V'
                  CALL GETVEC (N,
     +                         B, 
     +                         LINE)
                  DO I = N1, N
                     A(I,N1) = B(I)
                  ENDDO
               ENDIF
            ENDIF
         ENDIF  
         
C******************************************************************
C Start of inner loop to display, correct, or sort the current data
C****************************************************************** 
         
         DO WHILE (AGAIN)
            CALL DETAIL (NDEC,
     +                   MATRIX)
            IF (NDEC.EQ.0) THEN
               ISEND = N2
               ITYPE = N1
               CALL EDITOR (ISEND, ITYPE, M, NROW, N,
     +                      A, 
     +                      FNAME,
     +                      CURVE, FIXCOL, FIXROW, LABEL, ORDER,
     +                      WEIGHT)
            ELSEIF (NDEC.EQ.N1) THEN
               I = - N1
               NROW1 = N
               NCOL1 = M
               CALL DSPLAY (NCMAX, NCOL1, I, NRMAX, NROW1, NTYPE,
     +                      A,
     +                      TITLE, 
     +                      FILEIT)
            ELSEIF (NDEC.EQ.N2) THEN
               CALL CORREC (M, N, NROW,
     +                      A)
            ELSEIF (NDEC.EQ.N3) THEN
               AGAIN = .FALSE.
            ELSEIF (NDEC.EQ.N4) THEN
               CALL SRTVEC (M, N, NROW, 
     +                      A, B)
            ENDIF
            
C*********************************************************
C End of inner loop
C*********************************************************
            
         ENDDO
C
C Write the output file
C
         ISEND = N3
         CALL MATOUT (ISEND, M, NOUT, NROW, N, NBIG,
     +                A,
     +                FNAME, PHRASE, TITLE,
     +                ABORT, TRUE, TRUE, FALSE)
         CLOSE (UNIT = NOUT)
C
C Request Repeat/Stop
C
         CALL STOPGO (BLANK, FNAME, PNAME, 
     +                ABORT)
         IF (ABORT) THEN
            REPEET = .FALSE.
         ELSE
            REPEET = .TRUE.
         ENDIF
         
C**************************************************************         
C End of outer loop 
C**************************************************************
         
      ENDDO

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = N1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C

      END
C
C----------------------------------------------------------------------
C

      SUBROUTINE ADVISE (NCOL, NROW,
     +                   DVER,
     +                   ABORT, EXPERT)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (IN)             :: NCOL, NROW
      CHARACTER (LEN = *), INTENT (IN) :: DVER
      LOGICAL, INTENT (OUT)            :: ABORT, EXPERT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 9, NUMHDR = 12, NUMOPT = 4)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_MAKMAT
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help        ',
     +'Normal user',
     +'Expert mode',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (HEADER,100) DVER, NCOL, NROW
         ISEND = 2
         CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                HEADER, OPTION)
         IF (ISEND.EQ.1) THEN
            CALL HELP_MAKMAT ('makmat')
            REPEET = .TRUE.
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            EXPERT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .FALSE.
            EXPERT = .TRUE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.4) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package`SIMFIT'
     +/'       `      '
     +/'Program`MAKMAT'
     +/'       `      '
     +/'Action `Make a data file for statistics or plotting.'
     +/'       `Input v(i) values: make a vector type file.'
     +/'       `Iput a(i,j) values: make a matrix type file.'
     +/'       `      '
     +/'Version`',A
     +/'       `Maximum columns',I4,', Maximum rows',I6
     +/'       `      '
     +/'Author `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C-----------------------------------------------------------------
C
      SUBROUTINE CORREC (M, N, NROW,
     +                   A)
C
C Corrections
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)              :: M, N, NROW 
      DOUBLE PRECISION, INTENT (INOUT)  :: A(NROW,M)
C
C Locals
C      
      INTEGER    I, J
      INTEGER    N1
      PARAMETER (N1 = 1)
      CHARACTER (LEN = 12 ) I12(2), FORM12
      CHARACTER (LEN = 13 ) D13, SHOWLJ
      CHARACTER (LEN = 120) LINE
      LOGICAL    E_FORMATS, E_NUMBERS
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   GETJM1, GETD01
      INTRINSIC  TRIM
      SAVE     I, J
      DATA     I, J / 1, 1 /
      E_NUMBERS = E_FORMATS()
      IF (I.GT.N) I = N1
      IF (J.GT.M) J = N1
      IF (M.GT.N1) THEN
         CALL GETJM1 (N1, I, N, 'Number of row (down) to edit')
         CALL GETJM1 (N1, J, M, 'Number of column (across) to edit')
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) I, J, A(I,J)
         ELSE
            D13 = SHOWLJ(A(I,J))
            I12(1) = FORM12(I)
            I12(2) = FORM12(J)
            WRITE (LINE,150) TRIM(I12(1)), TRIM(I12(2)), D13
         ENDIF      
         CALL GETD01 (A(I,J), LINE)
      ELSE
         CALL GETJM1 (N1, I, N, 'Number of component (down) to edit')
         IF (E_NUMBERS) THEN
            WRITE (LINE,200) I, A(I,N1)
         ELSE
            D13 = SHOWLJ(A(I,N1))
            I12(1) = FORM12(I)
            WRITE (LINE,250) TRIM(I12(1)), D13
         ENDIF      
         CALL GETD01 (A(I,N1), LINE)
      ENDIF
C
C Format statements
C      
  100 FORMAT ('New value required: Current a(',I3,',',I2,') =',1P,E12.4)
  150 FORMAT ('New value required: Current a(',A,',',A,') =',1X,A)
  200 FORMAT ('New value required: Current v(',I5,') =',1P,E12.4)
  250 FORMAT ('New value required: Current v(',A,') =',1X,A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE DETAIL (NDEC, 
     +                   MATRIX)
C
C Decide course of action
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (OUT) :: NDEC 
      LOGICAL, INTENT (IN)  :: MATRIX
C
C Locals
C      
      INTEGER    ISEND
      INTEGER    ICOLOR, IX, IY, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      INTEGER    NUMPOS(5)
      CHARACTER  TEXT(5)*100
      EXTERNAL   LBOX02
      DATA NUMPOS / 5*1 /
      IF (MATRIX) THEN
         WRITE (TEXT,100)
         NDEC = 1
         NUMOPT = 4
         CALL LBOX02 (ICOLOR, IX, IY, NDEC, NUMOPT, NUMPOS, 
     +                TEXT)
         NDEC = NDEC - 1
      ELSE
         WRITE (TEXT,200)
         ISEND = 1
         NUMOPT = 5
         CALL LBOX02 (ICOLOR, IX, IY, ISEND, NUMOPT, NUMPOS, 
     +                TEXT)
         ISEND = ISEND - 1
         IF (ISEND.EQ.0) THEN
            NDEC = 0
         ELSEIF (ISEND.EQ.1) THEN
            NDEC = 1
         ELSEIF (ISEND.EQ.2) THEN
            NDEC = 2
         ELSEIF (ISEND.EQ.3) THEN
            NDEC = 4
         ELSE
            NDEC = 3
         ENDIF
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Edit the matrix'
     +/'Display the matrix'
     +/'Correct one a(i,j)'
     +/'Save to file')
  200 FORMAT (
     + 'Edit the vector'
     +/'Display the vector'
     +/'Correct one v(i)'
     +/'Rearrange v(i)'
     +/'Save to file')
      END
C
C---------------------------------------------------------------------
C
      SUBROUTINE MAKCON (M, N, NROW, 
     +                   A, 
     +                   JUMP)
C
C Make constant type matrix if required
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)           :: M, N, NROW
      DOUBLE PRECISION, INTENT (OUT) :: A(NROW,M)
      LOGICAL, INTENT (OUT)          :: JUMP
C
C Locals
C      
      INTEGER    N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      INTEGER    I, J, K, L, NDEC
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, LSHADE = 2, NUMOPT = 2,
     +           NSTART = 4, NTEXT = 14)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION CONST
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    YES
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GETD01, GETJM1, PUTADV, HBOX01, YESNO2
      INTRINSIC  MOD
      SAVE       K, L, CONST
      DATA       K, L, CONST / 1, 1, 0.0D+00 /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise
C       
      DO J = 1, M
         DO I = 1, N
            A(I,J) = ZERO
         ENDDO
      ENDDO 
C
C No option for very small matrices
C      
      IF (N*M.LE.6) THEN
         JUMP = .FALSE.
         RETURN
      ENDIF 
C
C Get the users choice
C      
      WRITE (TEXT,100)
      NDEC = 1
      NUMBLD(1) = 1
      NUMBLD(2) = 1
      NUMBLD(3) = 1
      CALL HBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NDEC.EQ.1) THEN
         JUMP = .FALSE.
         RETURN
      ELSE
         JUMP = .TRUE.
      ENDIF
C
C First fill in the background
C
      WRITE (LINE,200)
      CALL GETD01 (CONST, LINE)
      DO I = 1, M
         DO J = 1, N
            A(J,I) = CONST
         ENDDO
      ENDDO
C
C Fill in diagonals if A is square (N = M)
C
      IF (M.GT.1 .AND. N.EQ.M) THEN
         WRITE (LINE,300) N, N
         CALL GETD01 (CONST,
     +                LINE)
         DO I = 1, N
            A(I,I) = CONST
         ENDDO
         WRITE (LINE,400) N, N
         CALL GETD01 (CONST,
     +                LINE)
         DO I = 1, N
            A(N - I + 1,I) = CONST
         ENDDO
         IF (MOD(N, N2).NE.0) THEN
            I = (N - N1)/N2
            J = N - I
            WRITE (LINE,500) J, J
            CALL GETD01 (A(J,J),
     +                   LINE)
         ENDIF
      ENDIF
C
C Fill in chosen row if M > 1 (M = No. cols.)
C
      IF (M.GT.1) THEN
         LINE = 'Fill-in (brush-stroke) a row across ?'
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE, 
     +                YES)
         DO WHILE (YES)
            IF (K.GT.N) K = N1 
            LINE = 'No. of row to fill-in'
            CALL GETJM1 (N1, K, N,
     +                   LINE)
            WRITE (LINE,600) K
            CALL GETD01 (CONST,
     +                   LINE)
            DO I = 1, M
               A(K,I) = CONST
            ENDDO
            LINE = 'Fill-in another row across ?'
            YES = .FALSE.
            CALL YESNO2 (ICOLOR, IX, IY,
     +                   LINE, 
     +                   YES)
         ENDDO
C
C Fill in a chosen column if M > 1 (M = No. cols.)
C
         LINE = 'Fill-in (brush-stroke) a column down ?'
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                YES)
         DO WHILE (YES)
            IF (L.GT.M) L = N1
            LINE = 'No. of column to fill-in'
            CALL GETJM1 (N1, L, M,
     +                   LINE)
            WRITE (LINE,700) L
            CALL GETD01 (CONST,
     +                   LINE)
            DO I = 1, N
               A(I,L) = CONST
            ENDDO
            LINE = 'Fill-in another column down ?'
            YES = .FALSE.
            CALL YESNO2 (ICOLOR, IX, IY, 
     +                   LINE,
     +                   YES)
         ENDDO
      ENDIF
      WRITE (LINE,800)
      CALL PUTADV (LINE)    
C
C Format statements
C      
  100 FORMAT (
     + 'Now select the method you wish to use for entering your'
     +/'data values into the vector or matrix file. You can type'
     +/'in each item or start by initialising all the elements.'
     +/'Type'
     +/'Initialise'
     +/
     +/'You should type in for small dimensions or if there is'
     +/'no particular pattern or shape in the structure of the'
     +/'matrix elements that can be exploited.'
     +/'You should initialise if a preliminary matrix can be made'
     +/'by filling in the background, diagonals, and selected'
     +/'rows and columns with chosen fixed values. After making'
     +/'such a matrix, you can then proceed to further editing'
     +/'to add on the fine details')
  200 FORMAT ('Value required for default (background-wash) element')
  300 FORMAT (
     +'Downward diagonal element for a(1,1) to a(',I3,',',I2,')')
  400 FORMAT (
     +'Upward diagonal element for a(',I3,',1) to a(1,',I2,')')
  500 FORMAT (
     +'Value required for overwritten central element a(',I3,',',I2,')')
  600 FORMAT ('Value required for row',I5)
  700 FORMAT ('Value required for column',I3)
  800 FORMAT ('The special matrix is now ready for editing')
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE MTYPES (NOUT,
     +                   FNAME, TITLE,
     +                   ABORT, MATRIX)
C
C Vector or matrix data type
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER, INTENT (IN)              :: NOUT
      CHARACTER (LEN = *), INTENT (OUT) :: FNAME, TITLE
      LOGICAL, INTENT (OUT)             :: ABORT, MATRIX
C
C Locals
C      
      INTEGER    M
      INTEGER    ISEND, N1
      PARAMETER (N1 = 1)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 2, NUMOPT = 3,
     +           NSTART = 3, NTEXT = 17)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      CHARACTER  TEXT(30)*100, WORD8*8
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   OFILES, GETSTR, HBOX01, YMDHMS
      DATA NUMBLD / NTEXT*0 /
      DATA NUMPOS / NUMOPT*1 /  
C
C Initialise
C      
      ABORT = .TRUE.
      MATRIX = .FALSE.
      FNAME = 'No File'
      TITLE = 'No Data'
      CLOSE (UNIT = NOUT)
C
C Get the users choice
C      
      WRITE (TEXT,100)
      M = 1
      NUMBLD(1) = 1
      NUMBLD(2) = 1
      CALL HBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, M, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (M.EQ.1) THEN
         ABORT = .FALSE.
         MATRIX = .FALSE.
      ELSEIF (M.EQ.2) THEN
         ABORT = .FALSE.
         MATRIX = .TRUE.
      ELSE
         RETURN
      ENDIF
      ISEND = N1    
      CALL OFILES (ISEND, NOUT, 
     +             FNAME, 
     +             ABORT)
      IF (ABORT) THEN
         CLOSE (UNIT = NOUT)
         RETURN
      ELSE
         CALL YMDHMS (WORD8)          
         TITLE = 'New Data: '//WORD8
         CALL GETSTR ('Title for these data', TITLE)
      ENDIF
C
C Format statement
C         
  100 FORMAT (
     + 'Decide whether to make a vector file with components v(i) or'
     +/'else a matrix type file with row and column elements a(i,j)'
     +/'Vector'
     +/'Matrix'
     +/'Exit'
     +/
     +/'Choose Vector if you just want to make a file with one column'
     +/'of data values for statistics, e.g. testing if some numbers'
     +/'come from a normal distribution, or using the data as one of'
     +/'the columns in a t test.'
     +/'Choose Matrix to create a data file containing both rows and'
     +/'columns of data, e.g. for a chi-square, or Fisher exact test'
     +/'on a contingency table. Make a matrix with x in column one'
     +/'and y in column two for graph plotting using Simplot.'
     +/'Note that files created by this program can be edited using'
     +/'program Editmt but the special programs Makfil and Editfl'
     +/'should be used to prepare or edit data for curve fitting.')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ORDERS (M, N, NCOL, NROW,
     +                   MATRIX)
C
C Return chosen M (no. rows) and N (no. columns) values and MATRIX
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (OUT)   :: M, N
      INTEGER, INTENT (IN)    :: NCOL, NROW  
      LOGICAL, INTENT (INOUT) :: MATRIX
C
C Locals
C      
      INTEGER    ICOLOR, NTEXT, NTOP, N1
      PARAMETER (ICOLOR = 9, NTEXT = 11, NTOP = 100, N1 = 1)
      INTEGER    MSAV, NSAV
      INTEGER    NUMBLD(NTEXT)
      CHARACTER  LINE*80, TEXT(NTEXT)*100
      LOGICAL    REPEET, YES
      EXTERNAL   GETJM1, ANSWER
      SAVE       MSAV, NSAV
      DATA       MSAV, NSAV / 1, 1 /        
      DATA       NUMBLD / NTEXT*0 /
C
C Initialise
C      
      IF (MSAV.LT.N1) MSAV = N1
      IF (NSAV.LT.N1) NSAV = N1
      IF (MSAV.GT.NCOL) MSAV = NCOL
      IF (NSAV.GT.NROW) NSAV = NROW
      M = MSAV
      N = NSAV
      REPEET = .TRUE.
      DO WHILE (REPEET)  
C
C Request number of rows and columns
c      
         IF (MATRIX) THEN 
            WRITE (LINE,100)
            CALL GETJM1 (N1, N, NROW,
     +                   LINE)      
            WRITE (LINE,200)
            CALL GETJM1 (N1, M, NCOL,
     +                   LINE)             
         ELSE       
            M = N1
            WRITE (LINE,100)
            CALL GETJM1 (N1, N, NROW, 
     +                   LINE)
         ENDIF    
         REPEET = .FALSE. 
C
C Check for a large data set
C         
         IF (M*N.GT.NTOP) THEN
            WRITE (TEXT,300) M*N
            WRITE (LINE,400)
            YES = .FALSE.
            NUMBLD(1) = 1
            CALL ANSWER (ICOLOR, NUMBLD, NTEXT,
     +                   TEXT, LINE, 
     +                   YES)
            NUMBLD(1) = 0
            IF (YES) THEN
               REPEET = .FALSE.
            ELSE
               REPEET = .TRUE.
            ENDIF      
         ENDIF
      ENDDO
C
C Final check for matrix or vector
C      
      IF (M.EQ.1) THEN 
         MATRIX = .FALSE.
      ELSE
         MATRIX = .TRUE.
      ENDIF 
      MSAV = M
      NSAV = N
C
C Format statements
C      
  100 FORMAT ('Number of rows required (i.e. cases, down)')
  200 FORMAT ('Number of columns required (i.e. variables, across)')
  300 FORMAT (
     +'Warning: You have requested to input',I6,1x,'values'
     +/
     +/'To prepare big data files it is better to make'
     +/'smaller files and join them together using the'
     +/'program Editmt. This avoids the sort of errors'
     +/'that tend to occur when typing in too many rows'
     +/'and/or columns of data values.'
     +/
     +/'You can of course type in a large data set if you'
     +/'insist, but importing data into Simfit from your'
     +/'spreadsheet will probably be more convenient.')           
  400 FORMAT ('Make a large file ? (usually no)')
      END
C
C
