
C
C FTN95 version
C =============
C
C MAKSIM
C ======
C MAIN
C ADVISE
C
C Extra code as follows:
C =======================
C MAKSIM1.FOR ... DECIDE, DELCOL, DELROW, FILEIT, GLOBAL, RESCOL, RESROW
C
C
C     INCLUDE 'maksim1.for'
C     INCLUDE 'dllchk.for'
     
      PROGRAM MAIN
      
C
C ACTION : Read in an ASCII text file then output a matrix
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 14/03/1995
C          05/04/1995 Edited at Salamanca
C          12/07/1997 win32 version
C          01/10/1997 added COMMAS to strip out multiple spaces and ,, etc.
C          07/08/1998 added dllchk
C          14/12/1998 replaced TUTORS by TUTOR1
C          21/12/1998 Deleted header and trailer from SIMFIT type files
C          14/08/1999 Increased dimensions and altered scrolling output
C          13/09/1999 added call to WINDOW
C          14/02/2000 added SIMVER
C          07/03/2000 improved symbol selection and output of selected matrix
C          02/04/2001 revised
C          30/07/2005 increased DVER to *30 and added to call to ADVISE
C          24/04/2008 edited for version 6
C          30/07/2008 added SUPPLY and renamed subroutines transferred to w_menus.dll
C          20/04/2010 adjusted NRMAX = 20000 and NWIDE = 1024 to agree with new version of TABLE2
c          06/04/2016 introduced ALLOCATABLE 
C
C Note: The maximum dimensions are set as parameters as follows:
C
C       NCMAX: maximum number of columns
C       NRMAX: maximum number of rows 
C       NWIDE: maximum line width for reading off files
C
C       It may be necessary to increase these for very large files.
C
      IMPLICIT   NONE
      INTEGER    NCMAX, NRMAX, NWIDE
      PARAMETER (NCMAX = 200, NRMAX = 20000, NWIDE = 1024)
      INTEGER    NIN, NOUT, N0, N1, N10
      PARAMETER (NIN = 3, NOUT = 4, N0 = 0, N1 = 1, N10 = 10)
      INTEGER    I, IOS, I_LENGTH, I_STATUS, J
      INTEGER    COMMAND_ARGUMENT_COUNT
      INTEGER    IERR, ISEND, JCOLS, JROWS, METHOD, NCOLS, NROWS
      DOUBLE PRECISION XVER, YVER
      CHARACTER  FNAME1*1024, FNAME2*1024, STRNG*(NWIDE), TITLE*80
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_maksim.exe')
      CHARACTER  BLANK*1, LETTER*1, PNAME*6
      PARAMETER (BLANK = ' ', PNAME = 'MAKSIM')
      CHARACTER (LEN = 100) COMMAND
      LOGICAL    ABORT, ACTION, FIRST, READY, SHOW
      LOGICAL    AGAIN, MORE, REPEET, USE_ALL
      LOGICAL    JUMP
      LOGICAL    QUERY, SUPPLY
      PARAMETER (QUERY = .TRUE., SUPPLY = .FALSE.)
C
C Allocatable
C 
      INTEGER,                 ALLOCATABLE :: ICOLOR(:), NFIELD(:)
      CHARACTER (LEN = 20),    ALLOCATABLE :: COL_LABELS(:),
     +                                        ROW_LABELS(:)
      CHARACTER (LEN = NWIDE), ALLOCATABLE :: MATRIX(:)
      LOGICAL,                 ALLOCATABLE :: CLASH(:), COLIN(:),
     +                                        ROWIN(:), ROWNUM(:)
C
C Externals
C            
      EXTERNAL   COMMAND_ARGUMENT_COUNT 
      EXTERNAL   SV_MAKSIM_HELP
      EXTERNAL   STOPGO
      EXTERNAL   DECIDE, DELCOL, RESCOL, DELROW, RESROW, FILEIT, ADVISE,
     +           GLOBAL, PUTADV
      EXTERNAL   MAKSIM_DATAIN, MAKSIM_GETLAB, MAKSIM_PACKIT,
     +           MAKSIM_PARSE5, MAKSIM_VIEW01, MAKSIM_VIEW02,
     +           MAKSIM_VIEW03, MAKSIM_VIEW04
      EXTERNAL   DLLCHK, WINDOW, SIMVER


C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER, 
     +             ABORT, SHOW)


C
C First check the command line to initialise ISEND and JUMP
C
      ISEND = COMMAND_ARGUMENT_COUNT()  
      IF (ISEND.NE.N1) THEN
         ISEND = N0
      ELSE      
         CALL GET_COMMAND_ARGUMENT (N1, COMMAND, I_LENGTH, I_STATUS)
         IF (I_LENGTH.GE.N1 .AND. I_STATUS.EQ.N0) THEN
C
C 29/10/2023
C Replaced non-integer characters by blanks to interpret '0' as 0 which causes trouble otherwise
C It appears that 'i' is passed by run_program and returned as such by command argument 
C retrieval and read accurately except for '0' which is not read as 0 even if the quotes are 
C removed. Is it being read as a C string terminator ? So 0 is changed to 11 to call sv_simstat. 
C         
            do i = 1, i_length
               letter = command(i:i)
               j = ichar(letter)
               if (j.lt.48 .or. j.gt.57) command(i:i) = blank
            enddo           
            READ (COMMAND,*,IOSTAT=IOS) I
            IF (IOS.EQ.N0) THEN
               IF (I.GE.N1 .AND. I.LE.N10) THEN
                  ISEND = I
               ELSE
                  ISEND = N0
               ENDIF
            ELSE
               ISEND = N0
            ENDIF
         ELSE
            ISEND = N0
         ENDIF      
      ENDIF
      IF (ISEND.EQ.N0) THEN
         JUMP = .FALSE.
      ELSE
         JUMP = .TRUE.
         CALL SV_MAKSIM_HELP (IOS)
         IF (IOS.EQ.4) GOTO 40
      ENDIF
     
C
C Checking completed so now proceed to the main program
C======================================================================
C

C
C Advise user
C
      FIRST = .TRUE.
      IF (.NOT.JUMP)THEN
         CALL ADVISE (NCMAX, NRMAX,
     +                DVER,
     +                ABORT, FIRST)
      ENDIF 
      IF (ABORT) THEN
         REPEET = .FALSE.
      ELSE 
C
C Initialise
C
         ALLOCATE (ICOLOR(NWIDE), STAT = IERR)
         ALLOCATE (NFIELD(NRMAX), STAT = IERR)
         ALLOCATE (COL_LABELS(NCMAX), STAT = IERR)
         ALLOCATE (ROW_LABELS(NRMAX), STAT = IERR)
         ALLOCATE (MATRIX(NRMAX), STAT = IERR)
         ALLOCATE (CLASH(NRMAX), STAT = IERR)
         ALLOCATE (COLIN(NCMAX), STAT = IERR)
         ALLOCATE (ROWIN(NRMAX), STAT = IERR)
         ALLOCATE (ROWNUM(NRMAX), STAT = IERR)
         METHOD = 1
         REPEET = .TRUE.  
         DO ISEND = 1, NWIDE
            ICOLOR(ISEND) = 0
         ENDDO
         
         DO ISEND = 1, NRMAX
            MATRIX(ISEND) = BLANK
            ROW_LABELS(ISEND) = BLANK
            NFIELD(ISEND) = 0
            CLASH(ISEND) = .FALSE.
            ROWIN(ISEND) = .FALSE.
            ROWNUM(ISEND) = .FALSE.
         ENDDO   
         DO ISEND = 1, NCMAX
            COL_LABELS(ISEND) = BLANK
            COLIN(ISEND) = .FALSE.
         ENDDO    
      ENDIF   

C---------------------------------------------------------------------------------

      DO WHILE (REPEET)
        
C
C Main cycle point controlled by REPEET
C
         FNAME1 = BLANK
         FNAME2 = BLANK
C
C Read in a new data set then pack it and right justify character strings
C Users can also now save full data sets from within subroutine DATAIN
C This does not involve packing with extra blanks to line up so larger
C files can be handled this way
C
         CALL MAKSIM_DATAIN (NCMAX, NCOLS, NFIELD, NIN, NOUT, NRMAX,
     +                       NROWS,
     +                       FNAME1, FNAME2, MATRIX, STRNG,
     +                       ABORT, CLASH, COLIN, QUERY, READY, ROWIN,
     +                       SUPPLY)
         INQUIRE (UNIT = NIN, FILE = FNAME1, OPENED = ABORT)
         IF (ABORT) THEN
            CALL PUTADV ('UNIT NIN was opened so will be closed')
            CLOSE (UNIT = NIN)
         ENDIF    
         
         IF (JUMP) GOTO 20  

         IF (ABORT) THEN
            AGAIN = .FALSE.
         ELSE
C
C Extract the row and column labels i.e. row 1 and column 1
C           
            CALL MAKSIM_GETLAB (NCOLS, NCMAX, NROWS, NRMAX,
     +                          COL_LABELS, MATRIX, ROW_LABELS,
     +                          ABORT)
            IF (ABORT) THEN
               AGAIN = .FALSE.
            ELSE              
               AGAIN = .TRUE.
            ENDIF   
         ENDIF

C---------------------------------------------------------------------------------

         DO WHILE (AGAIN)

C
C Subsidiary cycle point controlled by AGAIN
C PACKIT justifies all columns to maximum field width
C This inserts blanks to line up as columns
C           
            CALL MAKSIM_PACKIT (NCOLS, NFIELD, NRMAX, NROWS, 
     +                          MATRIX, STRNG)
            
            MORE = .TRUE.

C---------------------------------------------------------------------------------

             DO WHILE (MORE)

C
C Subsidiary cycle point controlled by MORE
C
               
C
C Decide next course of action
C
               CALL DECIDE (ISEND, JCOLS, JROWS, NCOLS, NROWS,
     +                      COLIN, ROWIN)
               IF (ISEND.EQ.1) THEN
C
C Restore columns
C                 
                  CALL RESCOL (NCOLS,
     +                         COL_LABELS,                 
     +                         COLIN)
               ELSEIF (ISEND.EQ.2) THEN
C
C Suppress columns
C               
                  CALL DELCOL (NCOLS, 
     +                         COL_LABELS,                  
     +                         COLIN)
               ELSEIF (ISEND.EQ.3) THEN
C
C Restore rows
C               
                  CALL RESROW (NCOLS, NFIELD, NRMAX, NROWS,
     +                         MATRIX, ROW_LABELS, STRNG, 
     +                         ROWIN)
               ELSEIF (ISEND.EQ.4) THEN
C
C Suppress rows
C               
                  CALL DELROW (NCOLS, NFIELD, NRMAX, NROWS,
     +                         MATRIX, ROW_LABELS, STRNG, 
     +                         ROWIN)
               ELSEIF (ISEND.EQ.5) THEN
C
C Table in colour ... justified
C               
                  CALL MAKSIM_VIEW01 (ICOLOR, NCOLS, NFIELD, NRMAX,
     +                                NROWS, NWIDE,
     +                                MATRIX,
     +                                COLIN, ROWIN)
               ELSEIF (ISEND.EQ.6) THEN
C
C Display .. not justified
C               
                  CALL MAKSIM_VIEW03 (NRMAX, NROWS,
     +                                MATRIX)
               ELSEIF (ISEND.EQ.7) THEN
C
C Table in colour ... justified
C               
                  CALL MAKSIM_VIEW02 (ICOLOR, JCOLS, JROWS, NCOLS,
     +                                NFIELD, NRMAX,
     +                                NROWS, NWIDE,
     +                                MATRIX, STRNG, 
     +                                COLIN, ROWIN)
               ELSEIF (ISEND.EQ.8) THEN
C
C Display ... justified
C               
                  CALL MAKSIM_VIEW04 (JROWS, NCOLS, NFIELD, NRMAX,
     +                                NROWS,
     +                                MATRIX, STRNG, 
     +                                COLIN, ROWIN)
               ELSEIF (ISEND.EQ.9) THEN
C
C Global editing options
C               
                  CALL GLOBAL (NCOLS, NROWS,
     +                         COLIN, ROWIN)
               ELSEIF (ISEND.EQ.10) THEN
                  IF (METHOD.EQ.1) THEN
C
C Use the clipboard/XML/HTML/CSV control
C         
                     USE_ALL = .TRUE.            
                     CALL MAKSIM_PARSE5 (NCOLS, NFIELD, NOUT, NROWS,
     +                                   FNAME2, MATRIX, 
     +                                   COLIN, QUERY, ROWIN, USE_ALL) 
                  ELSE
C
C Use the original control (defunct...needs editing)
C                    
                     CALL FILEIT (JCOLS, JROWS, NCOLS, NFIELD, NOUT,
     +                            NRMAX, NROWS,
     +                            FNAME2, MATRIX, STRNG,
     +                            ABORT, COLIN, ROWIN, ROWNUM)
                  ENDIF
               ELSE
C
C Quit
C                 
                  AGAIN = .FALSE.
                  MORE = .FALSE.    
               ENDIF
               
C
C End of inner loop controlled by MORE
C
               
            ENDDO

C---------------------------------------------------------------------------------
            
  
C
C End of outer loop controlled by AGAIN
C          
         ENDDO

C---------------------------------------------------------------------------------

C
C Another go ?
C
   20    CONTINUE             
         ABORT = .FALSE.
         CALL STOPGO (FNAME1, FNAME2, PNAME, 
     +                ABORT)
         IF (ABORT) THEN
            REPEET = .FALSE.
         ELSE
            REPEET = .TRUE.
         ENDIF      
C
C End of outer loop controlled by REPEET
C
        
      ENDDO

C---------------------------------------------------------------------------------
      
C
C Close down
C
    
C
C======================================================================
C The program is finished so we can close down the background window
C
   40 CONTINUE   
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C

      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE ADVISE (NCMAX, NRMAX,
     +                   DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: NCMAX, NRMAX
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 7, NUMHDR = 12, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   FORM12
      EXTERNAL   TITLES, HELP_MAKSIM
      INTRINSIC  TRIM
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            I12(1) = FORM12(NCMAX)
            I12(2) = FORM12(NRMAX)
            WRITE (HEADER,100) DVER, TRIM(I12(1)), I12(2)
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_MAKSIM ('maksim')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package`SIMFIT'
     +/'       `      '
     +/'Program`MAKSIM'
     +/'       `      '
     +/'Action `Make SIMFIT files from clipoard/spreadsheet data'
     +/'       `Input:  ASCII text data with rows and columns'
     +/'       `Output: SIMFIT type file for statistics, etc.'
     +/'       `      '
     +/'Version`',A
     +/'       `Maximum columns',1X,A,', Maximum rows',1X,A
     +/'       `      '
     +/'Author `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
c
c
      subroutine sv_maksim_help (isend)
      integer, intent(out) :: isend 
      integer i, ix, iy, lshade, numdec, numopt, numsta, ntext, nmax
      parameter (icolor = 9, ix = 0, iy = 0, lshade = 0, numopt = 4,
     +           numsta = 2, nmax = 30)
      integer icolor, numbld(nmax)
      character (len = 100) text(nmax)  
      logical border
      parameter (border = .false.)     
      external lstbox, help_maksim, patch1
      do i = 1, nmax
         numbld(i) = 0
      enddo
      numdec = 1
      do while (numdec.le.2)
         numbld(1) = 4
         ntext = numopt + 1
         write (text,100)
         call lstbox (numbld, numdec, numopt,  numsta, ntext,
     +                text)  
         if (numdec.eq.1) then
            call help_maksim ('maksim')
         elseif (numdec.eq.2) then
            numbld(1) = 5
            write (text,200)
            ntext = 20
            call patch1 (icolor, ix, iy, lshade, numbld, ntext, 
     +                   text,
     +                   border)
         endif   
      enddo  
      isend = numdec

  100 format (
     + 'Help about programs maksim and sv_maksim'
     +/'Details for program maksim'
     +/'Advice about program sv_maksim'     
     +/'Proceed to the file-opening dialogue'
     +/'Quit ... Exit program sv_maksim')
  200 format (
     + 'How to use sv_maksim to create a Simfit data file'
     +/
     +/'This utility is provided to copy data sets from spreadsheet'
     +/'programs like Excel into files in Simfit format that can then'
     +/'be used by all Simfit programs.'
     +/
     +/'Numerical data tables can be input in several ways into the'
     +/'file opening dialogue, e.g.'
     +/
     +/'1. Type in a rectangular table using the [Keyboard] button'
     +/'2. Paste in a table from the clipboard using the [Paste] button' 
     +/'3. Input a file in text format'
     +/'4. Input a file in CSV format'
     +/'5. Input a file in HTML format'
     +/'6. Input a Simfit test file using the [Demo] button.'
     +/ 
     +/'The best way to learn how to use sv_maksim is to use the'
     +/'[Demo] button on the file opening dialogue to view the test'
     +/'files provided then accept one and proceed to make and save'
     +/'the corresponding Simfit file.') 
      end 
c
c